/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.drawable;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.graphics.Canvas;
import android.graphics.CanvasProperty;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.RippleComponent;
import android.graphics.drawable.RippleDrawable;
import android.util.FloatProperty;
import android.view.DisplayListCanvas;
import android.view.RenderNodeAnimator;
import android.view.animation.LinearInterpolator;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class RippleBackground
extends RippleComponent
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static TimeInterpolator LINEAR_INTERPOLATOR;
    private static int OPACITY_ENTER_DURATION = 600;
    private static int OPACITY_ENTER_DURATION_FAST = 120;
    private static int OPACITY_EXIT_DURATION = 480;
    private CanvasProperty<Paint> mPropPaint;
    private CanvasProperty<Float> mPropRadius;
    private CanvasProperty<Float> mPropX;
    private CanvasProperty<Float> mPropY;
    private float mOpacity;
    private boolean mIsBounded;
    private static BackgroundProperty OPACITY;

    private void $$robo$$android_graphics_drawable_RippleBackground$__constructor__(RippleDrawable owner, Rect bounds, boolean isBounded, boolean forceSoftware) {
        this.mOpacity = 0.0f;
        this.mIsBounded = isBounded;
    }

    private final boolean $$robo$$android_graphics_drawable_RippleBackground$isVisible() {
        return this.mOpacity > 0.0f || this.isHardwareAnimating();
    }

    private final boolean $$robo$$android_graphics_drawable_RippleBackground$drawSoftware(Canvas c, Paint p) {
        boolean hasContent = false;
        int origAlpha = p.getAlpha();
        int alpha = (int)((float)origAlpha * this.mOpacity + 0.5f);
        if (alpha > 0) {
            p.setAlpha(alpha);
            c.drawCircle(0.0f, 0.0f, this.mTargetRadius, p);
            p.setAlpha(origAlpha);
            hasContent = true;
        }
        return hasContent;
    }

    private final boolean $$robo$$android_graphics_drawable_RippleBackground$drawHardware(DisplayListCanvas c) {
        c.drawCircle(this.mPropX, this.mPropY, this.mPropRadius, this.mPropPaint);
        return true;
    }

    private final Animator $$robo$$android_graphics_drawable_RippleBackground$createSoftwareEnter(boolean fast) {
        int maxDuration = fast ? 120 : 600;
        int duration = (int)((1.0f - this.mOpacity) * (float)maxDuration);
        ObjectAnimator opacity = ObjectAnimator.ofFloat(this, OPACITY, 1.0f);
        opacity.setAutoCancel(true);
        opacity.setDuration(duration);
        opacity.setInterpolator(LINEAR_INTERPOLATOR);
        return opacity;
    }

    private final Animator $$robo$$android_graphics_drawable_RippleBackground$createSoftwareExit() {
        int fastEnterDuration;
        AnimatorSet set = new AnimatorSet();
        ObjectAnimator exit = ObjectAnimator.ofFloat(this, OPACITY, 0.0f);
        exit.setInterpolator(LINEAR_INTERPOLATOR);
        exit.setDuration(480L);
        exit.setAutoCancel(true);
        AnimatorSet.Builder builder = set.play(exit);
        int n = fastEnterDuration = this.mIsBounded ? (int)((1.0f - this.mOpacity) * 120.0f) : 0;
        if (fastEnterDuration > 0) {
            ObjectAnimator enter = ObjectAnimator.ofFloat(this, OPACITY, 1.0f);
            enter.setInterpolator(LINEAR_INTERPOLATOR);
            enter.setDuration(fastEnterDuration);
            enter.setAutoCancel(true);
            builder.after(enter);
        }
        return set;
    }

    private final RippleComponent.RenderNodeAnimatorSet $$robo$$android_graphics_drawable_RippleBackground$createHardwareExit(Paint p) {
        RippleComponent.RenderNodeAnimatorSet set = new RippleComponent.RenderNodeAnimatorSet();
        int targetAlpha = p.getAlpha();
        int currentAlpha = (int)(this.mOpacity * (float)targetAlpha + 0.5f);
        p.setAlpha(currentAlpha);
        this.mPropPaint = CanvasProperty.createPaint(p);
        this.mPropRadius = CanvasProperty.createFloat(this.mTargetRadius);
        this.mPropX = CanvasProperty.createFloat(0.0f);
        this.mPropY = CanvasProperty.createFloat(0.0f);
        int fastEnterDuration = this.mIsBounded ? (int)((1.0f - this.mOpacity) * 120.0f) : 0;
        RenderNodeAnimator exit = new RenderNodeAnimator(this.mPropPaint, 1, 0.0f);
        exit.setInterpolator(LINEAR_INTERPOLATOR);
        exit.setDuration(480L);
        if (fastEnterDuration > 0) {
            exit.setStartDelay(fastEnterDuration);
            exit.setStartValue(targetAlpha);
        }
        set.add(exit);
        if (fastEnterDuration > 0) {
            RenderNodeAnimator enter = new RenderNodeAnimator(this.mPropPaint, 1, targetAlpha);
            enter.setInterpolator(LINEAR_INTERPOLATOR);
            enter.setDuration(fastEnterDuration);
            set.add(enter);
        }
        return set;
    }

    private final void $$robo$$android_graphics_drawable_RippleBackground$jumpValuesToExit() {
        this.mOpacity = 0.0f;
    }

    static void __staticInitializer__() {
        LINEAR_INTERPOLATOR = new LinearInterpolator();
        OPACITY = new ShadowedObject("opacity"){
            public /* synthetic */ Object __robo_data__;

            private void $$robo$$android_graphics_drawable_RippleBackground_1$__constructor__(String name) {
            }

            private final void $$robo$$android_graphics_drawable_RippleBackground_1$setValue(RippleBackground object, float value) {
                object.mOpacity = value;
                object.invalidateSelf();
            }

            private final Float $$robo$$android_graphics_drawable_RippleBackground_1$get(RippleBackground object) {
                return Float.valueOf(object.mOpacity);
            }

            private void __constructor__(String string2) {
                this.$$robo$$android_graphics_drawable_RippleBackground_1$__constructor__(string2);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_RippleBackground_1$__constructor__(java.lang.String ), this, string2);
            }

            @Override
            public void setValue(RippleBackground rippleBackground, float f) {
                InvokeDynamicSupport.bootstrap("setValue", $$robo$$android_graphics_drawable_RippleBackground_1$setValue(android.graphics.drawable.RippleBackground float ), this, rippleBackground, f);
            }

            @Override
            public Float get(RippleBackground rippleBackground) {
                return InvokeDynamicSupport.bootstrap("get", $$robo$$android_graphics_drawable_RippleBackground_1$get(android.graphics.drawable.RippleBackground ), this, rippleBackground);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__(RippleDrawable rippleDrawable, Rect rect, boolean bl, boolean bl2) {
        this.$$robo$$android_graphics_drawable_RippleBackground$__constructor__(rippleDrawable, rect, bl, bl2);
    }

    public RippleBackground(RippleDrawable rippleDrawable, Rect rect, boolean bl, boolean bl2) {
        super(rippleDrawable, rect, bl2);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_RippleBackground$__constructor__(android.graphics.drawable.RippleDrawable android.graphics.Rect boolean boolean ), this, rippleDrawable, rect, bl, bl2);
    }

    public boolean isVisible() {
        return (boolean)InvokeDynamicSupport.bootstrap("isVisible", $$robo$$android_graphics_drawable_RippleBackground$isVisible(), this);
    }

    @Override
    protected boolean drawSoftware(Canvas canvas, Paint paint) {
        return (boolean)InvokeDynamicSupport.bootstrap("drawSoftware", $$robo$$android_graphics_drawable_RippleBackground$drawSoftware(android.graphics.Canvas android.graphics.Paint ), this, canvas, paint);
    }

    @Override
    protected boolean drawHardware(DisplayListCanvas displayListCanvas) {
        return (boolean)InvokeDynamicSupport.bootstrap("drawHardware", $$robo$$android_graphics_drawable_RippleBackground$drawHardware(android.view.DisplayListCanvas ), this, displayListCanvas);
    }

    @Override
    protected Animator createSoftwareEnter(boolean bl) {
        return InvokeDynamicSupport.bootstrap("createSoftwareEnter", $$robo$$android_graphics_drawable_RippleBackground$createSoftwareEnter(boolean ), this, bl);
    }

    @Override
    protected Animator createSoftwareExit() {
        return InvokeDynamicSupport.bootstrap("createSoftwareExit", $$robo$$android_graphics_drawable_RippleBackground$createSoftwareExit(), this);
    }

    @Override
    protected RippleComponent.RenderNodeAnimatorSet createHardwareExit(Paint paint) {
        return InvokeDynamicSupport.bootstrap("createHardwareExit", $$robo$$android_graphics_drawable_RippleBackground$createHardwareExit(android.graphics.Paint ), this, paint);
    }

    @Override
    protected void jumpValuesToExit() {
        InvokeDynamicSupport.bootstrap("jumpValuesToExit", $$robo$$android_graphics_drawable_RippleBackground$jumpValuesToExit(), this);
    }

    static {
        RobolectricInternals.classInitializing(RippleBackground.class);
    }

    public /* synthetic */ RippleBackground() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RippleBackground)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static abstract class BackgroundProperty
    extends FloatProperty<RippleBackground> {
        public /* synthetic */ Object __robo_data__;

        private void $$robo$$android_graphics_drawable_RippleBackground_BackgroundProperty$__constructor__(String name) {
        }

        private void __constructor__(String string2) {
            this.$$robo$$android_graphics_drawable_RippleBackground_BackgroundProperty$__constructor__(string2);
        }

        public BackgroundProperty(String string2) {
            super(string2);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_RippleBackground_BackgroundProperty$__constructor__(java.lang.String ), this, string2);
        }

        public /* synthetic */ BackgroundProperty() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BackgroundProperty)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

