/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.drawable;

import android.annotation.IntDef;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.DashPathEffect;
import android.graphics.Insets;
import android.graphics.LinearGradient;
import android.graphics.Outline;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.RadialGradient;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.SweepGradient;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.util.Log;
import android.util.TypedValue;
import com.android.internal.R;
import com.google.errorprone.annotations.DoNotMock;
import java.io.IOException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class GradientDrawable
extends Drawable
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    public static int RECTANGLE = 0;
    public static int OVAL = 1;
    public static int LINE = 2;
    public static int RING = 3;
    public static int LINEAR_GRADIENT = 0;
    public static int RADIAL_GRADIENT = 1;
    public static int SWEEP_GRADIENT = 2;
    private static int RADIUS_TYPE_PIXELS = 0;
    private static int RADIUS_TYPE_FRACTION = 1;
    private static int RADIUS_TYPE_FRACTION_PARENT = 2;
    private static float DEFAULT_INNER_RADIUS_RATIO = 3.0f;
    private static float DEFAULT_THICKNESS_RATIO = 9.0f;
    private GradientState mGradientState;
    private Paint mFillPaint;
    private Rect mPadding;
    private Paint mStrokePaint;
    private ColorFilter mColorFilter;
    private PorterDuffColorFilter mTintFilter;
    private int mAlpha;
    private Path mPath;
    private RectF mRect;
    private Paint mLayerPaint;
    private boolean mGradientIsDirty;
    private boolean mMutated;
    private Path mRingPath;
    private boolean mPathIsDirty;
    private float mGradientRadius;

    private void $$robo$$android_graphics_drawable_GradientDrawable$__constructor__() {
    }

    private void $$robo$$android_graphics_drawable_GradientDrawable$__constructor__(Orientation orientation, int[] colors) {
    }

    private final boolean $$robo$$android_graphics_drawable_GradientDrawable$getPadding(Rect padding) {
        if (this.mPadding != null) {
            padding.set(this.mPadding);
            return true;
        }
        return super.getPadding(padding);
    }

    private final void $$robo$$android_graphics_drawable_GradientDrawable$setCornerRadii(float[] radii) {
        this.mGradientState.setCornerRadii(radii);
        this.mPathIsDirty = true;
        this.invalidateSelf();
    }

    private final float[] $$robo$$android_graphics_drawable_GradientDrawable$getCornerRadii() {
        return (float[])this.mGradientState.mRadiusArray.clone();
    }

    private final void $$robo$$android_graphics_drawable_GradientDrawable$setCornerRadius(float radius) {
        this.mGradientState.setCornerRadius(radius);
        this.mPathIsDirty = true;
        this.invalidateSelf();
    }

    private final float $$robo$$android_graphics_drawable_GradientDrawable$getCornerRadius() {
        return this.mGradientState.mRadius;
    }

    private final void $$robo$$android_graphics_drawable_GradientDrawable$setStroke(int width, int color2) {
        this.setStroke(width, color2, 0.0f, 0.0f);
    }

    private final void $$robo$$android_graphics_drawable_GradientDrawable$setStroke(int width, ColorStateList colorStateList) {
        this.setStroke(width, colorStateList, 0.0f, 0.0f);
    }

    private final void $$robo$$android_graphics_drawable_GradientDrawable$setStroke(int width, int color2, float dashWidth, float dashGap) {
        this.mGradientState.setStroke(width, ColorStateList.valueOf(color2), dashWidth, dashGap);
        this.setStrokeInternal(width, color2, dashWidth, dashGap);
    }

    private final void $$robo$$android_graphics_drawable_GradientDrawable$setStroke(int width, ColorStateList colorStateList, float dashWidth, float dashGap) {
        int color2;
        this.mGradientState.setStroke(width, colorStateList, dashWidth, dashGap);
        if (colorStateList == null) {
            color2 = 0;
        } else {
            int[] stateSet = this.getState();
            color2 = colorStateList.getColorForState(stateSet, 0);
        }
        this.setStrokeInternal(width, color2, dashWidth, dashGap);
    }

    private final void $$robo$$android_graphics_drawable_GradientDrawable$setStrokeInternal(int width, int color2, float dashWidth, float dashGap) {
        if (this.mStrokePaint == null) {
            this.mStrokePaint = new Paint(1);
            this.mStrokePaint.setStyle(Paint.Style.STROKE);
        }
        this.mStrokePaint.setStrokeWidth(width);
        this.mStrokePaint.setColor(color2);
        DashPathEffect e = null;
        if (dashWidth > 0.0f) {
            e = new DashPathEffect(new float[]{dashWidth, dashGap}, 0.0f);
        }
        this.mStrokePaint.setPathEffect(e);
        this.invalidateSelf();
    }

    private final void $$robo$$android_graphics_drawable_GradientDrawable$setSize(int width, int height) {
        this.mGradientState.setSize(width, height);
        this.mPathIsDirty = true;
        this.invalidateSelf();
    }

    private final void $$robo$$android_graphics_drawable_GradientDrawable$setShape(int shape) {
        this.mRingPath = null;
        this.mPathIsDirty = true;
        this.mGradientState.setShape(shape);
        this.invalidateSelf();
    }

    private final int $$robo$$android_graphics_drawable_GradientDrawable$getShape() {
        return this.mGradientState.mShape;
    }

    private final void $$robo$$android_graphics_drawable_GradientDrawable$setGradientType(int gradient) {
        this.mGradientState.setGradientType(gradient);
        this.mGradientIsDirty = true;
        this.invalidateSelf();
    }

    private final int $$robo$$android_graphics_drawable_GradientDrawable$getGradientType() {
        return this.mGradientState.mGradient;
    }

    private final void $$robo$$android_graphics_drawable_GradientDrawable$setGradientCenter(float x, float y) {
        this.mGradientState.setGradientCenter(x, y);
        this.mGradientIsDirty = true;
        this.invalidateSelf();
    }

    private final float $$robo$$android_graphics_drawable_GradientDrawable$getGradientCenterX() {
        return this.mGradientState.mCenterX;
    }

    private final float $$robo$$android_graphics_drawable_GradientDrawable$getGradientCenterY() {
        return this.mGradientState.mCenterY;
    }

    private final void $$robo$$android_graphics_drawable_GradientDrawable$setGradientRadius(float gradientRadius) {
        this.mGradientState.setGradientRadius(gradientRadius, 0);
        this.mGradientIsDirty = true;
        this.invalidateSelf();
    }

    private final float $$robo$$android_graphics_drawable_GradientDrawable$getGradientRadius() {
        if (this.mGradientState.mGradient != 1) {
            return 0.0f;
        }
        this.ensureValidRect();
        return this.mGradientRadius;
    }

    private final void $$robo$$android_graphics_drawable_GradientDrawable$setUseLevel(boolean useLevel) {
        this.mGradientState.mUseLevel = useLevel;
        this.mGradientIsDirty = true;
        this.invalidateSelf();
    }

    private final boolean $$robo$$android_graphics_drawable_GradientDrawable$getUseLevel() {
        return this.mGradientState.mUseLevel;
    }

    private final int $$robo$$android_graphics_drawable_GradientDrawable$modulateAlpha(int alpha) {
        int scale = this.mAlpha + (this.mAlpha >> 7);
        return alpha * scale >> 8;
    }

    private final Orientation $$robo$$android_graphics_drawable_GradientDrawable$getOrientation() {
        return this.mGradientState.mOrientation;
    }

    private final void $$robo$$android_graphics_drawable_GradientDrawable$setOrientation(Orientation orientation) {
        this.mGradientState.mOrientation = orientation;
        this.mGradientIsDirty = true;
        this.invalidateSelf();
    }

    private final void $$robo$$android_graphics_drawable_GradientDrawable$setColors(int[] colors) {
        this.mGradientState.setGradientColors(colors);
        this.mGradientIsDirty = true;
        this.invalidateSelf();
    }

    private final int[] $$robo$$android_graphics_drawable_GradientDrawable$getColors() {
        return this.mGradientState.mGradientColors == null ? null : (int[])this.mGradientState.mGradientColors.clone();
    }

    private final void $$robo$$android_graphics_drawable_GradientDrawable$draw(Canvas canvas) {
        float rad;
        boolean useLayer;
        if (!this.ensureValidRect()) {
            return;
        }
        int prevFillAlpha = this.mFillPaint.getAlpha();
        int prevStrokeAlpha = this.mStrokePaint != null ? this.mStrokePaint.getAlpha() : 0;
        int currFillAlpha = this.modulateAlpha(prevFillAlpha);
        int currStrokeAlpha = this.modulateAlpha(prevStrokeAlpha);
        boolean haveStroke = currStrokeAlpha > 0 && this.mStrokePaint != null && this.mStrokePaint.getStrokeWidth() > 0.0f;
        boolean haveFill = currFillAlpha > 0;
        GradientState st = this.mGradientState;
        ColorFilter colorFilter = this.mColorFilter != null ? this.mColorFilter : this.mTintFilter;
        boolean bl = useLayer = haveStroke && haveFill && st.mShape != 2 && currStrokeAlpha < 255 && (this.mAlpha < 255 || colorFilter != null);
        if (useLayer) {
            if (this.mLayerPaint == null) {
                this.mLayerPaint = new Paint();
            }
            this.mLayerPaint.setDither(st.mDither);
            this.mLayerPaint.setAlpha(this.mAlpha);
            this.mLayerPaint.setColorFilter(colorFilter);
            rad = this.mStrokePaint.getStrokeWidth();
            canvas.saveLayer(this.mRect.left - rad, this.mRect.top - rad, this.mRect.right + rad, this.mRect.bottom + rad, this.mLayerPaint);
            this.mFillPaint.setColorFilter(null);
            this.mStrokePaint.setColorFilter(null);
        } else {
            this.mFillPaint.setAlpha(currFillAlpha);
            this.mFillPaint.setDither(st.mDither);
            this.mFillPaint.setColorFilter(colorFilter);
            if (colorFilter != null && st.mSolidColors == null) {
                this.mFillPaint.setColor(this.mAlpha << 24);
            }
            if (haveStroke) {
                this.mStrokePaint.setAlpha(currStrokeAlpha);
                this.mStrokePaint.setDither(st.mDither);
                this.mStrokePaint.setColorFilter(colorFilter);
            }
        }
        switch (st.mShape) {
            case 0: {
                if (st.mRadiusArray != null) {
                    this.buildPathIfDirty();
                    canvas.drawPath(this.mPath, this.mFillPaint);
                    if (!haveStroke) break;
                    canvas.drawPath(this.mPath, this.mStrokePaint);
                    break;
                }
                if (st.mRadius > 0.0f) {
                    rad = Math.min(st.mRadius, Math.min(this.mRect.width(), this.mRect.height()) * 0.5f);
                    canvas.drawRoundRect(this.mRect, rad, rad, this.mFillPaint);
                    if (!haveStroke) break;
                    canvas.drawRoundRect(this.mRect, rad, rad, this.mStrokePaint);
                    break;
                }
                if (this.mFillPaint.getColor() != 0 || colorFilter != null || this.mFillPaint.getShader() != null) {
                    canvas.drawRect(this.mRect, this.mFillPaint);
                }
                if (!haveStroke) break;
                canvas.drawRect(this.mRect, this.mStrokePaint);
                break;
            }
            case 1: {
                canvas.drawOval(this.mRect, this.mFillPaint);
                if (!haveStroke) break;
                canvas.drawOval(this.mRect, this.mStrokePaint);
                break;
            }
            case 2: {
                RectF r = this.mRect;
                float y = r.centerY();
                if (!haveStroke) break;
                canvas.drawLine(r.left, y, r.right, y, this.mStrokePaint);
                break;
            }
            case 3: {
                Path path = this.buildRing(st);
                canvas.drawPath(path, this.mFillPaint);
                if (!haveStroke) break;
                canvas.drawPath(path, this.mStrokePaint);
            }
        }
        if (useLayer) {
            canvas.restore();
        } else {
            this.mFillPaint.setAlpha(prevFillAlpha);
            if (haveStroke) {
                this.mStrokePaint.setAlpha(prevStrokeAlpha);
            }
        }
    }

    private final void $$robo$$android_graphics_drawable_GradientDrawable$buildPathIfDirty() {
        GradientState st = this.mGradientState;
        if (this.mPathIsDirty) {
            this.ensureValidRect();
            this.mPath.reset();
            this.mPath.addRoundRect(this.mRect, st.mRadiusArray, Path.Direction.CW);
            this.mPathIsDirty = false;
        }
    }

    private final Path $$robo$$android_graphics_drawable_GradientDrawable$buildRing(GradientState st) {
        if (!(this.mRingPath == null || st.mUseLevelForShape && this.mPathIsDirty)) {
            return this.mRingPath;
        }
        this.mPathIsDirty = false;
        float sweep = st.mUseLevelForShape ? 360.0f * (float)this.getLevel() / 10000.0f : 360.0f;
        RectF bounds = new RectF(this.mRect);
        float x = bounds.width() / 2.0f;
        float y = bounds.height() / 2.0f;
        float thickness = st.mThickness != -1 ? (float)st.mThickness : bounds.width() / st.mThicknessRatio;
        float radius = st.mInnerRadius != -1 ? (float)st.mInnerRadius : bounds.width() / st.mInnerRadiusRatio;
        RectF innerBounds = new RectF(bounds);
        innerBounds.inset(x - radius, y - radius);
        bounds = new RectF(innerBounds);
        bounds.inset(-thickness, -thickness);
        if (this.mRingPath == null) {
            this.mRingPath = new Path();
        } else {
            this.mRingPath.reset();
        }
        Path ringPath = this.mRingPath;
        if (sweep < 360.0f && sweep > -360.0f) {
            ringPath.setFillType(Path.FillType.EVEN_ODD);
            ringPath.moveTo(x + radius, y);
            ringPath.lineTo(x + radius + thickness, y);
            ringPath.arcTo(bounds, 0.0f, sweep, false);
            ringPath.arcTo(innerBounds, sweep, -sweep, false);
            ringPath.close();
        } else {
            ringPath.addOval(bounds, Path.Direction.CW);
            ringPath.addOval(innerBounds, Path.Direction.CCW);
        }
        return ringPath;
    }

    private final void $$robo$$android_graphics_drawable_GradientDrawable$setColor(int argb) {
        this.mGradientState.setSolidColors(ColorStateList.valueOf(argb));
        this.mFillPaint.setColor(argb);
        this.invalidateSelf();
    }

    private final void $$robo$$android_graphics_drawable_GradientDrawable$setColor(ColorStateList colorStateList) {
        int color2;
        this.mGradientState.setSolidColors(colorStateList);
        if (colorStateList == null) {
            color2 = 0;
        } else {
            int[] stateSet = this.getState();
            color2 = colorStateList.getColorForState(stateSet, 0);
        }
        this.mFillPaint.setColor(color2);
        this.invalidateSelf();
    }

    private final ColorStateList $$robo$$android_graphics_drawable_GradientDrawable$getColor() {
        return this.mGradientState.mSolidColors;
    }

    private final boolean $$robo$$android_graphics_drawable_GradientDrawable$onStateChange(int[] stateSet) {
        ColorStateList strokeColors;
        Paint strokePaint;
        boolean invalidateSelf = false;
        GradientState s = this.mGradientState;
        ColorStateList solidColors = s.mSolidColors;
        if (solidColors != null) {
            int newColor = solidColors.getColorForState(stateSet, 0);
            int oldColor = this.mFillPaint.getColor();
            if (oldColor != newColor) {
                this.mFillPaint.setColor(newColor);
                invalidateSelf = true;
            }
        }
        if ((strokePaint = this.mStrokePaint) != null && (strokeColors = s.mStrokeColors) != null) {
            int newColor = strokeColors.getColorForState(stateSet, 0);
            int oldColor = strokePaint.getColor();
            if (oldColor != newColor) {
                strokePaint.setColor(newColor);
                invalidateSelf = true;
            }
        }
        if (s.mTint != null && s.mTintMode != null) {
            this.mTintFilter = this.updateTintFilter(this.mTintFilter, s.mTint, s.mTintMode);
            invalidateSelf = true;
        }
        if (invalidateSelf) {
            this.invalidateSelf();
            return true;
        }
        return false;
    }

    private final boolean $$robo$$android_graphics_drawable_GradientDrawable$isStateful() {
        GradientState s = this.mGradientState;
        return super.isStateful() || s.mSolidColors != null && s.mSolidColors.isStateful() || s.mStrokeColors != null && s.mStrokeColors.isStateful() || s.mTint != null && s.mTint.isStateful();
    }

    private final boolean $$robo$$android_graphics_drawable_GradientDrawable$hasFocusStateSpecified() {
        GradientState s = this.mGradientState;
        return s.mSolidColors != null && s.mSolidColors.hasFocusStateSpecified() || s.mStrokeColors != null && s.mStrokeColors.hasFocusStateSpecified() || s.mTint != null && s.mTint.hasFocusStateSpecified();
    }

    private final int $$robo$$android_graphics_drawable_GradientDrawable$getChangingConfigurations() {
        return super.getChangingConfigurations() | this.mGradientState.getChangingConfigurations();
    }

    private final void $$robo$$android_graphics_drawable_GradientDrawable$setAlpha(int alpha) {
        if (alpha != this.mAlpha) {
            this.mAlpha = alpha;
            this.invalidateSelf();
        }
    }

    private final int $$robo$$android_graphics_drawable_GradientDrawable$getAlpha() {
        return this.mAlpha;
    }

    private final void $$robo$$android_graphics_drawable_GradientDrawable$setDither(boolean dither) {
        if (dither != this.mGradientState.mDither) {
            this.mGradientState.mDither = dither;
            this.invalidateSelf();
        }
    }

    private final ColorFilter $$robo$$android_graphics_drawable_GradientDrawable$getColorFilter() {
        return this.mColorFilter;
    }

    private final void $$robo$$android_graphics_drawable_GradientDrawable$setColorFilter(ColorFilter colorFilter) {
        if (colorFilter != this.mColorFilter) {
            this.mColorFilter = colorFilter;
            this.invalidateSelf();
        }
    }

    private final void $$robo$$android_graphics_drawable_GradientDrawable$setTintList(ColorStateList tint) {
        this.mGradientState.mTint = tint;
        this.mTintFilter = this.updateTintFilter(this.mTintFilter, tint, this.mGradientState.mTintMode);
        this.invalidateSelf();
    }

    private final void $$robo$$android_graphics_drawable_GradientDrawable$setTintMode(PorterDuff.Mode tintMode) {
        this.mGradientState.mTintMode = tintMode;
        this.mTintFilter = this.updateTintFilter(this.mTintFilter, this.mGradientState.mTint, tintMode);
        this.invalidateSelf();
    }

    private final int $$robo$$android_graphics_drawable_GradientDrawable$getOpacity() {
        return this.mAlpha == 255 && this.mGradientState.mOpaqueOverBounds && this.isOpaqueForState() ? -1 : -3;
    }

    private final void $$robo$$android_graphics_drawable_GradientDrawable$onBoundsChange(Rect r) {
        super.onBoundsChange(r);
        this.mRingPath = null;
        this.mPathIsDirty = true;
        this.mGradientIsDirty = true;
    }

    private final boolean $$robo$$android_graphics_drawable_GradientDrawable$onLevelChange(int level) {
        super.onLevelChange(level);
        this.mGradientIsDirty = true;
        this.mPathIsDirty = true;
        this.invalidateSelf();
        return true;
    }

    private final boolean $$robo$$android_graphics_drawable_GradientDrawable$ensureValidRect() {
        if (this.mGradientIsDirty) {
            this.mGradientIsDirty = false;
            Rect bounds = this.getBounds();
            float inset = 0.0f;
            if (this.mStrokePaint != null) {
                inset = this.mStrokePaint.getStrokeWidth() * 0.5f;
            }
            GradientState st = this.mGradientState;
            this.mRect.set((float)bounds.left + inset, (float)bounds.top + inset, (float)bounds.right - inset, (float)bounds.bottom - inset);
            int[] gradientColors = st.mGradientColors;
            if (gradientColors != null) {
                RectF r = this.mRect;
                if (st.mGradient == 0) {
                    float y1;
                    float x1;
                    float y0;
                    float x0;
                    float level = st.mUseLevel ? (float)this.getLevel() / 10000.0f : 1.0f;
                    switch (1.$SwitchMap$android$graphics$drawable$GradientDrawable$Orientation[st.mOrientation.ordinal()]) {
                        case 1: {
                            x0 = r.left;
                            y0 = r.top;
                            x1 = x0;
                            y1 = level * r.bottom;
                            break;
                        }
                        case 2: {
                            x0 = r.right;
                            y0 = r.top;
                            x1 = level * r.left;
                            y1 = level * r.bottom;
                            break;
                        }
                        case 3: {
                            x0 = r.right;
                            y0 = r.top;
                            x1 = level * r.left;
                            y1 = y0;
                            break;
                        }
                        case 4: {
                            x0 = r.right;
                            y0 = r.bottom;
                            x1 = level * r.left;
                            y1 = level * r.top;
                            break;
                        }
                        case 5: {
                            x0 = r.left;
                            y0 = r.bottom;
                            x1 = x0;
                            y1 = level * r.top;
                            break;
                        }
                        case 6: {
                            x0 = r.left;
                            y0 = r.bottom;
                            x1 = level * r.right;
                            y1 = level * r.top;
                            break;
                        }
                        case 7: {
                            x0 = r.left;
                            y0 = r.top;
                            x1 = level * r.right;
                            y1 = y0;
                            break;
                        }
                        default: {
                            x0 = r.left;
                            y0 = r.top;
                            x1 = level * r.right;
                            y1 = level * r.bottom;
                        }
                    }
                    this.mFillPaint.setShader(new LinearGradient(x0, y0, x1, y1, gradientColors, st.mPositions, Shader.TileMode.CLAMP));
                } else if (st.mGradient == 1) {
                    float x0 = r.left + (r.right - r.left) * st.mCenterX;
                    float y0 = r.top + (r.bottom - r.top) * st.mCenterY;
                    float radius = st.mGradientRadius;
                    if (st.mGradientRadiusType == 1) {
                        float width = st.mWidth >= 0 ? (float)st.mWidth : r.width();
                        float height = st.mHeight >= 0 ? (float)st.mHeight : r.height();
                        radius *= Math.min(width, height);
                    } else if (st.mGradientRadiusType == 2) {
                        radius *= Math.min(r.width(), r.height());
                    }
                    if (st.mUseLevel) {
                        radius *= (float)this.getLevel() / 10000.0f;
                    }
                    this.mGradientRadius = radius;
                    if (radius <= 0.0f) {
                        radius = 0.001f;
                    }
                    this.mFillPaint.setShader(new RadialGradient(x0, y0, radius, gradientColors, null, Shader.TileMode.CLAMP));
                } else if (st.mGradient == 2) {
                    float x0 = r.left + (r.right - r.left) * st.mCenterX;
                    float y0 = r.top + (r.bottom - r.top) * st.mCenterY;
                    int[] tempColors = gradientColors;
                    float[] tempPositions = null;
                    if (st.mUseLevel) {
                        tempColors = st.mTempColors;
                        int length = gradientColors.length;
                        if (tempColors == null || tempColors.length != length + 1) {
                            st.mTempColors = new int[length + 1];
                            tempColors = st.mTempColors;
                        }
                        InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (int[])gradientColors, (int)0, (int[])tempColors, (int)0, (int)length);
                        tempColors[length] = gradientColors[length - 1];
                        tempPositions = st.mTempPositions;
                        float fraction2 = 1.0f / (float)(length - 1);
                        if (tempPositions == null || tempPositions.length != length + 1) {
                            tempPositions = st.mTempPositions = new float[length + 1];
                        }
                        float level = (float)this.getLevel() / 10000.0f;
                        for (int i = 0; i < length; ++i) {
                            tempPositions[i] = (float)i * fraction2 * level;
                        }
                        tempPositions[length] = 1.0f;
                    }
                    this.mFillPaint.setShader(new SweepGradient(x0, y0, tempColors, tempPositions));
                }
                if (st.mSolidColors == null) {
                    this.mFillPaint.setColor(-16777216);
                }
            }
        }
        return !this.mRect.isEmpty();
    }

    private final void $$robo$$android_graphics_drawable_GradientDrawable$inflate(Resources r, XmlPullParser parser, AttributeSet attrs, Resources.Theme theme) throws XmlPullParserException, IOException {
        super.inflate(r, parser, attrs, theme);
        this.mGradientState.setDensity(Drawable.resolveDensity(r, 0));
        TypedArray a = GradientDrawable.obtainAttributes(r, theme, attrs, R.styleable.GradientDrawable);
        this.updateStateFromTypedArray(a);
        a.recycle();
        this.inflateChildElements(r, parser, attrs, theme);
        this.updateLocalState(r);
    }

    private final void $$robo$$android_graphics_drawable_GradientDrawable$applyTheme(Resources.Theme t) {
        super.applyTheme(t);
        GradientState state = this.mGradientState;
        if (state == null) {
            return;
        }
        state.setDensity(Drawable.resolveDensity(t.getResources(), 0));
        if (state.mThemeAttrs != null) {
            TypedArray a = t.resolveAttributes(state.mThemeAttrs, R.styleable.GradientDrawable);
            this.updateStateFromTypedArray(a);
            a.recycle();
        }
        if (state.mTint != null && state.mTint.canApplyTheme()) {
            state.mTint = state.mTint.obtainForTheme(t);
        }
        if (state.mSolidColors != null && state.mSolidColors.canApplyTheme()) {
            state.mSolidColors = state.mSolidColors.obtainForTheme(t);
        }
        if (state.mStrokeColors != null && state.mStrokeColors.canApplyTheme()) {
            state.mStrokeColors = state.mStrokeColors.obtainForTheme(t);
        }
        this.applyThemeChildElements(t);
        this.updateLocalState(t.getResources());
    }

    private final void $$robo$$android_graphics_drawable_GradientDrawable$updateStateFromTypedArray(TypedArray a) {
        ColorStateList tint;
        int tintMode;
        GradientState state = this.mGradientState;
        state.mChangingConfigurations |= a.getChangingConfigurations();
        state.mThemeAttrs = a.extractThemeAttrs();
        state.mShape = a.getInt(3, state.mShape);
        state.mDither = a.getBoolean(0, state.mDither);
        if (state.mShape == 3) {
            state.mInnerRadius = a.getDimensionPixelSize(7, state.mInnerRadius);
            if (state.mInnerRadius == -1) {
                state.mInnerRadiusRatio = a.getFloat(4, state.mInnerRadiusRatio);
            }
            state.mThickness = a.getDimensionPixelSize(8, state.mThickness);
            if (state.mThickness == -1) {
                state.mThicknessRatio = a.getFloat(5, state.mThicknessRatio);
            }
            state.mUseLevelForShape = a.getBoolean(6, state.mUseLevelForShape);
        }
        if ((tintMode = a.getInt(9, -1)) != -1) {
            state.mTintMode = Drawable.parseTintMode(tintMode, PorterDuff.Mode.SRC_IN);
        }
        if ((tint = a.getColorStateList(1)) != null) {
            state.mTint = tint;
        }
        int insetLeft = a.getDimensionPixelSize(11, state.mOpticalInsets.left);
        int insetTop = a.getDimensionPixelSize(13, state.mOpticalInsets.top);
        int insetRight = a.getDimensionPixelSize(12, state.mOpticalInsets.right);
        int insetBottom = a.getDimensionPixelSize(10, state.mOpticalInsets.bottom);
        state.mOpticalInsets = Insets.of(insetLeft, insetTop, insetRight, insetBottom);
    }

    private final boolean $$robo$$android_graphics_drawable_GradientDrawable$canApplyTheme() {
        return this.mGradientState != null && this.mGradientState.canApplyTheme() || super.canApplyTheme();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_graphics_drawable_GradientDrawable$applyThemeChildElements(Resources.Theme t) {
        TypedArray a;
        GradientState st = this.mGradientState;
        if (st.mAttrSize != null) {
            a = t.resolveAttributes(st.mAttrSize, R.styleable.GradientDrawableSize);
            this.updateGradientDrawableSize(a);
            a.recycle();
        }
        if (st.mAttrGradient != null) {
            a = t.resolveAttributes(st.mAttrGradient, R.styleable.GradientDrawableGradient);
            try {
                this.updateGradientDrawableGradient(t.getResources(), a);
            }
            catch (XmlPullParserException e) {
                GradientDrawable.rethrowAsRuntimeException(e);
            }
            finally {
                a.recycle();
            }
        }
        if (st.mAttrSolid != null) {
            a = t.resolveAttributes(st.mAttrSolid, R.styleable.GradientDrawableSolid);
            this.updateGradientDrawableSolid(a);
            a.recycle();
        }
        if (st.mAttrStroke != null) {
            a = t.resolveAttributes(st.mAttrStroke, R.styleable.GradientDrawableStroke);
            this.updateGradientDrawableStroke(a);
            a.recycle();
        }
        if (st.mAttrCorners != null) {
            a = t.resolveAttributes(st.mAttrCorners, R.styleable.DrawableCorners);
            this.updateDrawableCorners(a);
            a.recycle();
        }
        if (st.mAttrPadding != null) {
            a = t.resolveAttributes(st.mAttrPadding, R.styleable.GradientDrawablePadding);
            this.updateGradientDrawablePadding(a);
            a.recycle();
        }
    }

    private final void $$robo$$android_graphics_drawable_GradientDrawable$inflateChildElements(Resources r, XmlPullParser parser, AttributeSet attrs, Resources.Theme theme) throws XmlPullParserException, IOException {
        int depth;
        int type;
        int innerDepth = parser.getDepth() + 1;
        while ((type = parser.next()) != 1 && ((depth = parser.getDepth()) >= innerDepth || type != 3)) {
            TypedArray a;
            if (type != 2 || depth > innerDepth) continue;
            String name = parser.getName();
            if (name.equals("size")) {
                a = GradientDrawable.obtainAttributes(r, theme, attrs, R.styleable.GradientDrawableSize);
                this.updateGradientDrawableSize(a);
                a.recycle();
                continue;
            }
            if (name.equals("gradient")) {
                a = GradientDrawable.obtainAttributes(r, theme, attrs, R.styleable.GradientDrawableGradient);
                this.updateGradientDrawableGradient(r, a);
                a.recycle();
                continue;
            }
            if (name.equals("solid")) {
                a = GradientDrawable.obtainAttributes(r, theme, attrs, R.styleable.GradientDrawableSolid);
                this.updateGradientDrawableSolid(a);
                a.recycle();
                continue;
            }
            if (name.equals("stroke")) {
                a = GradientDrawable.obtainAttributes(r, theme, attrs, R.styleable.GradientDrawableStroke);
                this.updateGradientDrawableStroke(a);
                a.recycle();
                continue;
            }
            if (name.equals("corners")) {
                a = GradientDrawable.obtainAttributes(r, theme, attrs, R.styleable.DrawableCorners);
                this.updateDrawableCorners(a);
                a.recycle();
                continue;
            }
            if (name.equals("padding")) {
                a = GradientDrawable.obtainAttributes(r, theme, attrs, R.styleable.GradientDrawablePadding);
                this.updateGradientDrawablePadding(a);
                a.recycle();
                continue;
            }
            Log.w("drawable", "Bad element under <shape>: " + name);
        }
    }

    private final void $$robo$$android_graphics_drawable_GradientDrawable$updateGradientDrawablePadding(TypedArray a) {
        GradientState st = this.mGradientState;
        st.mChangingConfigurations |= a.getChangingConfigurations();
        st.mAttrPadding = a.extractThemeAttrs();
        if (st.mPadding == null) {
            st.mPadding = new Rect();
        }
        Rect pad = st.mPadding;
        pad.set(a.getDimensionPixelOffset(0, pad.left), a.getDimensionPixelOffset(1, pad.top), a.getDimensionPixelOffset(2, pad.right), a.getDimensionPixelOffset(3, pad.bottom));
        this.mPadding = pad;
    }

    private final void $$robo$$android_graphics_drawable_GradientDrawable$updateDrawableCorners(TypedArray a) {
        GradientState st = this.mGradientState;
        st.mChangingConfigurations |= a.getChangingConfigurations();
        st.mAttrCorners = a.extractThemeAttrs();
        int radius = a.getDimensionPixelSize(0, (int)st.mRadius);
        this.setCornerRadius(radius);
        int topLeftRadius = a.getDimensionPixelSize(1, radius);
        int topRightRadius = a.getDimensionPixelSize(2, radius);
        int bottomLeftRadius = a.getDimensionPixelSize(3, radius);
        int bottomRightRadius = a.getDimensionPixelSize(4, radius);
        if (topLeftRadius != radius || topRightRadius != radius || bottomLeftRadius != radius || bottomRightRadius != radius) {
            this.setCornerRadii(new float[]{topLeftRadius, topLeftRadius, topRightRadius, topRightRadius, bottomRightRadius, bottomRightRadius, bottomLeftRadius, bottomLeftRadius});
        }
    }

    private final void $$robo$$android_graphics_drawable_GradientDrawable$updateGradientDrawableStroke(TypedArray a) {
        GradientState st = this.mGradientState;
        st.mChangingConfigurations |= a.getChangingConfigurations();
        st.mAttrStroke = a.extractThemeAttrs();
        int defaultStrokeWidth = Math.max(0, st.mStrokeWidth);
        int width = a.getDimensionPixelSize(0, defaultStrokeWidth);
        float dashWidth = a.getDimension(2, st.mStrokeDashWidth);
        ColorStateList colorStateList = a.getColorStateList(1);
        if (colorStateList == null) {
            colorStateList = st.mStrokeColors;
        }
        if (dashWidth != 0.0f) {
            float dashGap = a.getDimension(3, st.mStrokeDashGap);
            this.setStroke(width, colorStateList, dashWidth, dashGap);
        } else {
            this.setStroke(width, colorStateList);
        }
    }

    private final void $$robo$$android_graphics_drawable_GradientDrawable$updateGradientDrawableSolid(TypedArray a) {
        GradientState st = this.mGradientState;
        st.mChangingConfigurations |= a.getChangingConfigurations();
        st.mAttrSolid = a.extractThemeAttrs();
        ColorStateList colorStateList = a.getColorStateList(0);
        if (colorStateList != null) {
            this.setColor(colorStateList);
        }
    }

    private final void $$robo$$android_graphics_drawable_GradientDrawable$updateGradientDrawableGradient(Resources r, TypedArray a) throws XmlPullParserException {
        GradientState st = this.mGradientState;
        st.mChangingConfigurations |= a.getChangingConfigurations();
        st.mAttrGradient = a.extractThemeAttrs();
        st.mCenterX = GradientDrawable.getFloatOrFraction(a, 5, st.mCenterX);
        st.mCenterY = GradientDrawable.getFloatOrFraction(a, 6, st.mCenterY);
        st.mUseLevel = a.getBoolean(2, st.mUseLevel);
        st.mGradient = a.getInt(4, st.mGradient);
        int startColor = a.getColor(0, 0);
        boolean hasCenterColor = a.hasValue(8);
        int centerColor = a.getColor(8, 0);
        int endColor = a.getColor(1, 0);
        if (hasCenterColor) {
            st.mGradientColors = new int[3];
            st.mGradientColors[0] = startColor;
            st.mGradientColors[1] = centerColor;
            st.mGradientColors[2] = endColor;
            st.mPositions = new float[3];
            st.mPositions[0] = 0.0f;
            st.mPositions[1] = st.mCenterX != 0.5f ? st.mCenterX : st.mCenterY;
            st.mPositions[2] = 1.0f;
        } else {
            st.mGradientColors = new int[2];
            st.mGradientColors[0] = startColor;
            st.mGradientColors[1] = endColor;
        }
        if (st.mGradient == 0) {
            int angle = (int)a.getFloat(3, st.mAngle);
            if ((angle %= 360) % 45 != 0) {
                throw new XmlPullParserException(a.getPositionDescription() + "<gradient> tag requires 'angle' attribute to be a multiple of 45");
            }
            st.mAngle = angle;
            switch (angle) {
                case 0: {
                    st.mOrientation = Orientation.LEFT_RIGHT;
                    break;
                }
                case 45: {
                    st.mOrientation = Orientation.BL_TR;
                    break;
                }
                case 90: {
                    st.mOrientation = Orientation.BOTTOM_TOP;
                    break;
                }
                case 135: {
                    st.mOrientation = Orientation.BR_TL;
                    break;
                }
                case 180: {
                    st.mOrientation = Orientation.RIGHT_LEFT;
                    break;
                }
                case 225: {
                    st.mOrientation = Orientation.TR_BL;
                    break;
                }
                case 270: {
                    st.mOrientation = Orientation.TOP_BOTTOM;
                    break;
                }
                case 315: {
                    st.mOrientation = Orientation.TL_BR;
                }
            }
        } else {
            TypedValue tv = a.peekValue(7);
            if (tv != null) {
                int radiusType;
                float radius;
                if (tv.type == 6) {
                    radius = tv.getFraction(1.0f, 1.0f);
                    int unit = tv.data >> 0 & 0xF;
                    radiusType = unit == 1 ? 2 : 1;
                } else if (tv.type == 5) {
                    radius = tv.getDimension(r.getDisplayMetrics());
                    radiusType = 0;
                } else {
                    radius = tv.getFloat();
                    radiusType = 0;
                }
                st.mGradientRadius = radius;
                st.mGradientRadiusType = radiusType;
            } else if (st.mGradient == 1) {
                throw new XmlPullParserException(a.getPositionDescription() + "<gradient> tag requires 'gradientRadius' attribute with radial type");
            }
        }
    }

    private final void $$robo$$android_graphics_drawable_GradientDrawable$updateGradientDrawableSize(TypedArray a) {
        GradientState st = this.mGradientState;
        st.mChangingConfigurations |= a.getChangingConfigurations();
        st.mAttrSize = a.extractThemeAttrs();
        st.mWidth = a.getDimensionPixelSize(1, st.mWidth);
        st.mHeight = a.getDimensionPixelSize(0, st.mHeight);
    }

    private static final float $$robo$$android_graphics_drawable_GradientDrawable$getFloatOrFraction(TypedArray a, int index, float defaultValue) {
        TypedValue tv = a.peekValue(index);
        float v = defaultValue;
        if (tv != null) {
            boolean vIsFraction = tv.type == 6;
            v = vIsFraction ? tv.getFraction(1.0f, 1.0f) : tv.getFloat();
        }
        return v;
    }

    private final int $$robo$$android_graphics_drawable_GradientDrawable$getIntrinsicWidth() {
        return this.mGradientState.mWidth;
    }

    private final int $$robo$$android_graphics_drawable_GradientDrawable$getIntrinsicHeight() {
        return this.mGradientState.mHeight;
    }

    private final Insets $$robo$$android_graphics_drawable_GradientDrawable$getOpticalInsets() {
        return this.mGradientState.mOpticalInsets;
    }

    private final Drawable.ConstantState $$robo$$android_graphics_drawable_GradientDrawable$getConstantState() {
        this.mGradientState.mChangingConfigurations = this.getChangingConfigurations();
        return this.mGradientState;
    }

    private final boolean $$robo$$android_graphics_drawable_GradientDrawable$isOpaqueForState() {
        if (this.mGradientState.mStrokeWidth >= 0 && this.mStrokePaint != null && !GradientDrawable.isOpaque(this.mStrokePaint.getColor())) {
            return false;
        }
        return this.mGradientState.mGradientColors != null || GradientDrawable.isOpaque(this.mFillPaint.getColor());
    }

    private final void $$robo$$android_graphics_drawable_GradientDrawable$getOutline(Outline outline) {
        GradientState st = this.mGradientState;
        Rect bounds = this.getBounds();
        boolean useFillOpacity = st.mOpaqueOverShape && (this.mGradientState.mStrokeWidth <= 0 || this.mStrokePaint == null || this.mStrokePaint.getAlpha() == this.mFillPaint.getAlpha());
        outline.setAlpha(useFillOpacity ? (float)this.modulateAlpha(this.mFillPaint.getAlpha()) / 255.0f : 0.0f);
        switch (st.mShape) {
            case 0: {
                if (st.mRadiusArray != null) {
                    this.buildPathIfDirty();
                    outline.setConvexPath(this.mPath);
                    return;
                }
                float rad = 0.0f;
                if (st.mRadius > 0.0f) {
                    rad = Math.min(st.mRadius, (float)Math.min(bounds.width(), bounds.height()) * 0.5f);
                }
                outline.setRoundRect(bounds, rad);
                return;
            }
            case 1: {
                outline.setOval(bounds);
                return;
            }
            case 2: {
                float halfStrokeWidth = this.mStrokePaint == null ? 1.0E-4f : this.mStrokePaint.getStrokeWidth() * 0.5f;
                float centerY = bounds.centerY();
                int top = (int)Math.floor(centerY - halfStrokeWidth);
                int bottom = (int)Math.ceil(centerY + halfStrokeWidth);
                outline.setRect(bounds.left, top, bounds.right, bottom);
                return;
            }
        }
    }

    private final Drawable $$robo$$android_graphics_drawable_GradientDrawable$mutate() {
        if (!this.mMutated && super.mutate() == this) {
            this.mGradientState = new GradientState(this.mGradientState, null);
            this.updateLocalState(null);
            this.mMutated = true;
        }
        return this;
    }

    private final void $$robo$$android_graphics_drawable_GradientDrawable$clearMutated() {
        super.clearMutated();
        this.mMutated = false;
    }

    private static final boolean $$robo$$android_graphics_drawable_GradientDrawable$isOpaque(int color2) {
        return (color2 >> 24 & 0xFF) == 255;
    }

    private void $$robo$$android_graphics_drawable_GradientDrawable$__constructor__(GradientState state, Resources res) {
        this.mFillPaint = new Paint(1);
        this.mAlpha = 255;
        this.mPath = new Path();
        this.mRect = new RectF();
        this.mPathIsDirty = true;
        this.mGradientState = state;
        this.updateLocalState(res);
    }

    private final void $$robo$$android_graphics_drawable_GradientDrawable$updateLocalState(Resources res) {
        int[] currentState;
        GradientState state = this.mGradientState;
        if (state.mSolidColors != null) {
            currentState = this.getState();
            int stateColor = state.mSolidColors.getColorForState(currentState, 0);
            this.mFillPaint.setColor(stateColor);
        } else if (state.mGradientColors == null) {
            this.mFillPaint.setColor(0);
        } else {
            this.mFillPaint.setColor(-16777216);
        }
        this.mPadding = state.mPadding;
        if (state.mStrokeWidth >= 0) {
            this.mStrokePaint = new Paint(1);
            this.mStrokePaint.setStyle(Paint.Style.STROKE);
            this.mStrokePaint.setStrokeWidth(state.mStrokeWidth);
            if (state.mStrokeColors != null) {
                currentState = this.getState();
                int strokeStateColor = state.mStrokeColors.getColorForState(currentState, 0);
                this.mStrokePaint.setColor(strokeStateColor);
            }
            if (state.mStrokeDashWidth != 0.0f) {
                DashPathEffect e = new DashPathEffect(new float[]{state.mStrokeDashWidth, state.mStrokeDashGap}, 0.0f);
                this.mStrokePaint.setPathEffect(e);
            }
        }
        this.mTintFilter = this.updateTintFilter(this.mTintFilter, state.mTint, state.mTintMode);
        this.mGradientIsDirty = true;
        state.computeOpacity();
    }

    private /* synthetic */ void $$robo$$android_graphics_drawable_GradientDrawable$__constructor__(GradientState x0, Resources x1, 1 x2) {
    }

    private void __constructor__() {
        this.$$robo$$android_graphics_drawable_GradientDrawable$__constructor__();
    }

    public GradientDrawable() {
        this(new GradientState(Orientation.TOP_BOTTOM, null), null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_GradientDrawable$__constructor__(), this);
    }

    private void __constructor__(Orientation orientation, int[] nArray) {
        this.$$robo$$android_graphics_drawable_GradientDrawable$__constructor__(orientation, nArray);
    }

    public GradientDrawable(Orientation orientation, int[] nArray) {
        this(new GradientState(orientation, nArray), null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_GradientDrawable$__constructor__(android.graphics.drawable.GradientDrawable$Orientation int[] ), this, orientation, nArray);
    }

    @Override
    public boolean getPadding(Rect rect) {
        return (boolean)InvokeDynamicSupport.bootstrap("getPadding", $$robo$$android_graphics_drawable_GradientDrawable$getPadding(android.graphics.Rect ), this, rect);
    }

    public void setCornerRadii(float[] fArray) {
        InvokeDynamicSupport.bootstrap("setCornerRadii", $$robo$$android_graphics_drawable_GradientDrawable$setCornerRadii(float[] ), this, fArray);
    }

    public float[] getCornerRadii() {
        return InvokeDynamicSupport.bootstrap("getCornerRadii", $$robo$$android_graphics_drawable_GradientDrawable$getCornerRadii(), this);
    }

    public void setCornerRadius(float f) {
        InvokeDynamicSupport.bootstrap("setCornerRadius", $$robo$$android_graphics_drawable_GradientDrawable$setCornerRadius(float ), this, f);
    }

    public float getCornerRadius() {
        return (float)InvokeDynamicSupport.bootstrap("getCornerRadius", $$robo$$android_graphics_drawable_GradientDrawable$getCornerRadius(), this);
    }

    public void setStroke(int n, int n2) {
        InvokeDynamicSupport.bootstrap("setStroke", $$robo$$android_graphics_drawable_GradientDrawable$setStroke(int int ), this, n, n2);
    }

    public void setStroke(int n, ColorStateList colorStateList) {
        InvokeDynamicSupport.bootstrap("setStroke", $$robo$$android_graphics_drawable_GradientDrawable$setStroke(int android.content.res.ColorStateList ), this, n, colorStateList);
    }

    public void setStroke(int n, int n2, float f, float f2) {
        InvokeDynamicSupport.bootstrap("setStroke", $$robo$$android_graphics_drawable_GradientDrawable$setStroke(int int float float ), this, n, n2, f, f2);
    }

    public void setStroke(int n, ColorStateList colorStateList, float f, float f2) {
        InvokeDynamicSupport.bootstrap("setStroke", $$robo$$android_graphics_drawable_GradientDrawable$setStroke(int android.content.res.ColorStateList float float ), this, n, colorStateList, f, f2);
    }

    private void setStrokeInternal(int n, int n2, float f, float f2) {
        InvokeDynamicSupport.bootstrap("setStrokeInternal", $$robo$$android_graphics_drawable_GradientDrawable$setStrokeInternal(int int float float ), this, n, n2, f, f2);
    }

    public void setSize(int n, int n2) {
        InvokeDynamicSupport.bootstrap("setSize", $$robo$$android_graphics_drawable_GradientDrawable$setSize(int int ), this, n, n2);
    }

    public void setShape(int n) {
        InvokeDynamicSupport.bootstrap("setShape", $$robo$$android_graphics_drawable_GradientDrawable$setShape(int ), this, n);
    }

    public int getShape() {
        return (int)InvokeDynamicSupport.bootstrap("getShape", $$robo$$android_graphics_drawable_GradientDrawable$getShape(), this);
    }

    public void setGradientType(int n) {
        InvokeDynamicSupport.bootstrap("setGradientType", $$robo$$android_graphics_drawable_GradientDrawable$setGradientType(int ), this, n);
    }

    public int getGradientType() {
        return (int)InvokeDynamicSupport.bootstrap("getGradientType", $$robo$$android_graphics_drawable_GradientDrawable$getGradientType(), this);
    }

    public void setGradientCenter(float f, float f2) {
        InvokeDynamicSupport.bootstrap("setGradientCenter", $$robo$$android_graphics_drawable_GradientDrawable$setGradientCenter(float float ), this, f, f2);
    }

    public float getGradientCenterX() {
        return (float)InvokeDynamicSupport.bootstrap("getGradientCenterX", $$robo$$android_graphics_drawable_GradientDrawable$getGradientCenterX(), this);
    }

    public float getGradientCenterY() {
        return (float)InvokeDynamicSupport.bootstrap("getGradientCenterY", $$robo$$android_graphics_drawable_GradientDrawable$getGradientCenterY(), this);
    }

    public void setGradientRadius(float f) {
        InvokeDynamicSupport.bootstrap("setGradientRadius", $$robo$$android_graphics_drawable_GradientDrawable$setGradientRadius(float ), this, f);
    }

    public float getGradientRadius() {
        return (float)InvokeDynamicSupport.bootstrap("getGradientRadius", $$robo$$android_graphics_drawable_GradientDrawable$getGradientRadius(), this);
    }

    public void setUseLevel(boolean bl) {
        InvokeDynamicSupport.bootstrap("setUseLevel", $$robo$$android_graphics_drawable_GradientDrawable$setUseLevel(boolean ), this, bl);
    }

    public boolean getUseLevel() {
        return (boolean)InvokeDynamicSupport.bootstrap("getUseLevel", $$robo$$android_graphics_drawable_GradientDrawable$getUseLevel(), this);
    }

    private int modulateAlpha(int n) {
        return (int)InvokeDynamicSupport.bootstrap("modulateAlpha", $$robo$$android_graphics_drawable_GradientDrawable$modulateAlpha(int ), this, n);
    }

    public Orientation getOrientation() {
        return InvokeDynamicSupport.bootstrap("getOrientation", $$robo$$android_graphics_drawable_GradientDrawable$getOrientation(), this);
    }

    public void setOrientation(Orientation orientation) {
        InvokeDynamicSupport.bootstrap("setOrientation", $$robo$$android_graphics_drawable_GradientDrawable$setOrientation(android.graphics.drawable.GradientDrawable$Orientation ), this, orientation);
    }

    public void setColors(int[] nArray) {
        InvokeDynamicSupport.bootstrap("setColors", $$robo$$android_graphics_drawable_GradientDrawable$setColors(int[] ), this, nArray);
    }

    public int[] getColors() {
        return InvokeDynamicSupport.bootstrap("getColors", $$robo$$android_graphics_drawable_GradientDrawable$getColors(), this);
    }

    @Override
    public void draw(Canvas canvas) {
        InvokeDynamicSupport.bootstrap("draw", $$robo$$android_graphics_drawable_GradientDrawable$draw(android.graphics.Canvas ), this, canvas);
    }

    private void buildPathIfDirty() {
        InvokeDynamicSupport.bootstrap("buildPathIfDirty", $$robo$$android_graphics_drawable_GradientDrawable$buildPathIfDirty(), this);
    }

    private Path buildRing(GradientState gradientState) {
        return InvokeDynamicSupport.bootstrap("buildRing", $$robo$$android_graphics_drawable_GradientDrawable$buildRing(android.graphics.drawable.GradientDrawable$GradientState ), this, gradientState);
    }

    public void setColor(int n) {
        InvokeDynamicSupport.bootstrap("setColor", $$robo$$android_graphics_drawable_GradientDrawable$setColor(int ), this, n);
    }

    public void setColor(ColorStateList colorStateList) {
        InvokeDynamicSupport.bootstrap("setColor", $$robo$$android_graphics_drawable_GradientDrawable$setColor(android.content.res.ColorStateList ), this, colorStateList);
    }

    public ColorStateList getColor() {
        return InvokeDynamicSupport.bootstrap("getColor", $$robo$$android_graphics_drawable_GradientDrawable$getColor(), this);
    }

    @Override
    protected boolean onStateChange(int[] nArray) {
        return (boolean)InvokeDynamicSupport.bootstrap("onStateChange", $$robo$$android_graphics_drawable_GradientDrawable$onStateChange(int[] ), this, nArray);
    }

    @Override
    public boolean isStateful() {
        return (boolean)InvokeDynamicSupport.bootstrap("isStateful", $$robo$$android_graphics_drawable_GradientDrawable$isStateful(), this);
    }

    @Override
    public boolean hasFocusStateSpecified() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasFocusStateSpecified", $$robo$$android_graphics_drawable_GradientDrawable$hasFocusStateSpecified(), this);
    }

    @Override
    public int getChangingConfigurations() {
        return (int)InvokeDynamicSupport.bootstrap("getChangingConfigurations", $$robo$$android_graphics_drawable_GradientDrawable$getChangingConfigurations(), this);
    }

    @Override
    public void setAlpha(int n) {
        InvokeDynamicSupport.bootstrap("setAlpha", $$robo$$android_graphics_drawable_GradientDrawable$setAlpha(int ), this, n);
    }

    @Override
    public int getAlpha() {
        return (int)InvokeDynamicSupport.bootstrap("getAlpha", $$robo$$android_graphics_drawable_GradientDrawable$getAlpha(), this);
    }

    @Override
    public void setDither(boolean bl) {
        InvokeDynamicSupport.bootstrap("setDither", $$robo$$android_graphics_drawable_GradientDrawable$setDither(boolean ), this, bl);
    }

    @Override
    public ColorFilter getColorFilter() {
        return InvokeDynamicSupport.bootstrap("getColorFilter", $$robo$$android_graphics_drawable_GradientDrawable$getColorFilter(), this);
    }

    @Override
    public void setColorFilter(ColorFilter colorFilter) {
        InvokeDynamicSupport.bootstrap("setColorFilter", $$robo$$android_graphics_drawable_GradientDrawable$setColorFilter(android.graphics.ColorFilter ), this, colorFilter);
    }

    @Override
    public void setTintList(ColorStateList colorStateList) {
        InvokeDynamicSupport.bootstrap("setTintList", $$robo$$android_graphics_drawable_GradientDrawable$setTintList(android.content.res.ColorStateList ), this, colorStateList);
    }

    @Override
    public void setTintMode(PorterDuff.Mode mode) {
        InvokeDynamicSupport.bootstrap("setTintMode", $$robo$$android_graphics_drawable_GradientDrawable$setTintMode(android.graphics.PorterDuff$Mode ), this, mode);
    }

    @Override
    public int getOpacity() {
        return (int)InvokeDynamicSupport.bootstrap("getOpacity", $$robo$$android_graphics_drawable_GradientDrawable$getOpacity(), this);
    }

    @Override
    protected void onBoundsChange(Rect rect) {
        InvokeDynamicSupport.bootstrap("onBoundsChange", $$robo$$android_graphics_drawable_GradientDrawable$onBoundsChange(android.graphics.Rect ), this, rect);
    }

    @Override
    protected boolean onLevelChange(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("onLevelChange", $$robo$$android_graphics_drawable_GradientDrawable$onLevelChange(int ), this, n);
    }

    private boolean ensureValidRect() {
        return (boolean)InvokeDynamicSupport.bootstrap("ensureValidRect", $$robo$$android_graphics_drawable_GradientDrawable$ensureValidRect(), this);
    }

    @Override
    public void inflate(Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet, Resources.Theme theme) throws XmlPullParserException, IOException {
        InvokeDynamicSupport.bootstrap("inflate", $$robo$$android_graphics_drawable_GradientDrawable$inflate(android.content.res.Resources org.xmlpull.v1.XmlPullParser android.util.AttributeSet android.content.res.Resources$Theme ), this, resources, xmlPullParser, attributeSet, theme);
    }

    @Override
    public void applyTheme(Resources.Theme theme) {
        InvokeDynamicSupport.bootstrap("applyTheme", $$robo$$android_graphics_drawable_GradientDrawable$applyTheme(android.content.res.Resources$Theme ), this, theme);
    }

    private void updateStateFromTypedArray(TypedArray typedArray) {
        InvokeDynamicSupport.bootstrap("updateStateFromTypedArray", $$robo$$android_graphics_drawable_GradientDrawable$updateStateFromTypedArray(android.content.res.TypedArray ), this, typedArray);
    }

    @Override
    public boolean canApplyTheme() {
        return (boolean)InvokeDynamicSupport.bootstrap("canApplyTheme", $$robo$$android_graphics_drawable_GradientDrawable$canApplyTheme(), this);
    }

    private void applyThemeChildElements(Resources.Theme theme) {
        InvokeDynamicSupport.bootstrap("applyThemeChildElements", $$robo$$android_graphics_drawable_GradientDrawable$applyThemeChildElements(android.content.res.Resources$Theme ), this, theme);
    }

    private void inflateChildElements(Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet, Resources.Theme theme) throws XmlPullParserException, IOException {
        InvokeDynamicSupport.bootstrap("inflateChildElements", $$robo$$android_graphics_drawable_GradientDrawable$inflateChildElements(android.content.res.Resources org.xmlpull.v1.XmlPullParser android.util.AttributeSet android.content.res.Resources$Theme ), this, resources, xmlPullParser, attributeSet, theme);
    }

    private void updateGradientDrawablePadding(TypedArray typedArray) {
        InvokeDynamicSupport.bootstrap("updateGradientDrawablePadding", $$robo$$android_graphics_drawable_GradientDrawable$updateGradientDrawablePadding(android.content.res.TypedArray ), this, typedArray);
    }

    private void updateDrawableCorners(TypedArray typedArray) {
        InvokeDynamicSupport.bootstrap("updateDrawableCorners", $$robo$$android_graphics_drawable_GradientDrawable$updateDrawableCorners(android.content.res.TypedArray ), this, typedArray);
    }

    private void updateGradientDrawableStroke(TypedArray typedArray) {
        InvokeDynamicSupport.bootstrap("updateGradientDrawableStroke", $$robo$$android_graphics_drawable_GradientDrawable$updateGradientDrawableStroke(android.content.res.TypedArray ), this, typedArray);
    }

    private void updateGradientDrawableSolid(TypedArray typedArray) {
        InvokeDynamicSupport.bootstrap("updateGradientDrawableSolid", $$robo$$android_graphics_drawable_GradientDrawable$updateGradientDrawableSolid(android.content.res.TypedArray ), this, typedArray);
    }

    private void updateGradientDrawableGradient(Resources resources, TypedArray typedArray) throws XmlPullParserException {
        InvokeDynamicSupport.bootstrap("updateGradientDrawableGradient", $$robo$$android_graphics_drawable_GradientDrawable$updateGradientDrawableGradient(android.content.res.Resources android.content.res.TypedArray ), this, resources, typedArray);
    }

    private void updateGradientDrawableSize(TypedArray typedArray) {
        InvokeDynamicSupport.bootstrap("updateGradientDrawableSize", $$robo$$android_graphics_drawable_GradientDrawable$updateGradientDrawableSize(android.content.res.TypedArray ), this, typedArray);
    }

    private static float getFloatOrFraction(TypedArray typedArray, int n, float f) {
        return (float)InvokeDynamicSupport.bootstrapStatic("getFloatOrFraction", $$robo$$android_graphics_drawable_GradientDrawable$getFloatOrFraction(android.content.res.TypedArray int float ), (TypedArray)typedArray, (int)n, (float)f);
    }

    @Override
    public int getIntrinsicWidth() {
        return (int)InvokeDynamicSupport.bootstrap("getIntrinsicWidth", $$robo$$android_graphics_drawable_GradientDrawable$getIntrinsicWidth(), this);
    }

    @Override
    public int getIntrinsicHeight() {
        return (int)InvokeDynamicSupport.bootstrap("getIntrinsicHeight", $$robo$$android_graphics_drawable_GradientDrawable$getIntrinsicHeight(), this);
    }

    @Override
    public Insets getOpticalInsets() {
        return InvokeDynamicSupport.bootstrap("getOpticalInsets", $$robo$$android_graphics_drawable_GradientDrawable$getOpticalInsets(), this);
    }

    @Override
    public Drawable.ConstantState getConstantState() {
        return InvokeDynamicSupport.bootstrap("getConstantState", $$robo$$android_graphics_drawable_GradientDrawable$getConstantState(), this);
    }

    private boolean isOpaqueForState() {
        return (boolean)InvokeDynamicSupport.bootstrap("isOpaqueForState", $$robo$$android_graphics_drawable_GradientDrawable$isOpaqueForState(), this);
    }

    @Override
    public void getOutline(Outline outline) {
        InvokeDynamicSupport.bootstrap("getOutline", $$robo$$android_graphics_drawable_GradientDrawable$getOutline(android.graphics.Outline ), this, outline);
    }

    @Override
    public Drawable mutate() {
        return InvokeDynamicSupport.bootstrap("mutate", $$robo$$android_graphics_drawable_GradientDrawable$mutate(), this);
    }

    @Override
    public void clearMutated() {
        InvokeDynamicSupport.bootstrap("clearMutated", $$robo$$android_graphics_drawable_GradientDrawable$clearMutated(), this);
    }

    static boolean isOpaque(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isOpaque", $$robo$$android_graphics_drawable_GradientDrawable$isOpaque(int ), (int)n);
    }

    private void __constructor__(GradientState gradientState, Resources resources) {
        this.$$robo$$android_graphics_drawable_GradientDrawable$__constructor__(gradientState, resources);
    }

    public GradientDrawable(GradientState gradientState, Resources resources) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_GradientDrawable$__constructor__(android.graphics.drawable.GradientDrawable$GradientState android.content.res.Resources ), this, gradientState, resources);
    }

    private void updateLocalState(Resources resources) {
        InvokeDynamicSupport.bootstrap("updateLocalState", $$robo$$android_graphics_drawable_GradientDrawable$updateLocalState(android.content.res.Resources ), this, resources);
    }

    private /* synthetic */ void __constructor__(GradientState gradientState, Resources resources, 1 var3_3) {
        this.$$robo$$android_graphics_drawable_GradientDrawable$__constructor__(gradientState, resources, var3_3);
    }

    public /* synthetic */ GradientDrawable(GradientState gradientState, Resources resources, 1 var3_3) {
        this(gradientState, resources);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_GradientDrawable$__constructor__(android.graphics.drawable.GradientDrawable$GradientState android.content.res.Resources android.graphics.drawable.GradientDrawable$1 ), this, gradientState, resources, var3_3);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (GradientDrawable)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class GradientState
    extends Drawable.ConstantState
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public int mChangingConfigurations;
        public int mShape;
        public int mGradient;
        public int mAngle;
        public Orientation mOrientation;
        public ColorStateList mSolidColors;
        public ColorStateList mStrokeColors;
        public int[] mGradientColors;
        public int[] mTempColors;
        public float[] mTempPositions;
        public float[] mPositions;
        public int mStrokeWidth;
        public float mStrokeDashWidth;
        public float mStrokeDashGap;
        public float mRadius;
        public float[] mRadiusArray;
        public Rect mPadding;
        public int mWidth;
        public int mHeight;
        public float mInnerRadiusRatio;
        public float mThicknessRatio;
        public int mInnerRadius;
        public int mThickness;
        public boolean mDither;
        public Insets mOpticalInsets;
        float mCenterX;
        float mCenterY;
        float mGradientRadius;
        int mGradientRadiusType;
        boolean mUseLevel;
        boolean mUseLevelForShape;
        boolean mOpaqueOverBounds;
        boolean mOpaqueOverShape;
        ColorStateList mTint;
        PorterDuff.Mode mTintMode;
        int mDensity;
        int[] mThemeAttrs;
        int[] mAttrSize;
        int[] mAttrGradient;
        int[] mAttrSolid;
        int[] mAttrStroke;
        int[] mAttrCorners;
        int[] mAttrPadding;

        private void $$robo$$android_graphics_drawable_GradientDrawable_GradientState$__constructor__(Orientation orientation, int[] gradientColors) {
            this.mShape = 0;
            this.mGradient = 0;
            this.mAngle = 0;
            this.mStrokeWidth = -1;
            this.mStrokeDashWidth = 0.0f;
            this.mStrokeDashGap = 0.0f;
            this.mRadius = 0.0f;
            this.mRadiusArray = null;
            this.mPadding = null;
            this.mWidth = -1;
            this.mHeight = -1;
            this.mInnerRadiusRatio = 3.0f;
            this.mThicknessRatio = 9.0f;
            this.mInnerRadius = -1;
            this.mThickness = -1;
            this.mDither = false;
            this.mOpticalInsets = Insets.NONE;
            this.mCenterX = 0.5f;
            this.mCenterY = 0.5f;
            this.mGradientRadius = 0.5f;
            this.mGradientRadiusType = 0;
            this.mUseLevel = false;
            this.mUseLevelForShape = true;
            this.mTint = null;
            this.mTintMode = Drawable.DEFAULT_TINT_MODE;
            this.mDensity = 160;
            this.mOrientation = orientation;
            this.setGradientColors(gradientColors);
        }

        private void $$robo$$android_graphics_drawable_GradientDrawable_GradientState$__constructor__(GradientState orig, Resources res) {
            this.mShape = 0;
            this.mGradient = 0;
            this.mAngle = 0;
            this.mStrokeWidth = -1;
            this.mStrokeDashWidth = 0.0f;
            this.mStrokeDashGap = 0.0f;
            this.mRadius = 0.0f;
            this.mRadiusArray = null;
            this.mPadding = null;
            this.mWidth = -1;
            this.mHeight = -1;
            this.mInnerRadiusRatio = 3.0f;
            this.mThicknessRatio = 9.0f;
            this.mInnerRadius = -1;
            this.mThickness = -1;
            this.mDither = false;
            this.mOpticalInsets = Insets.NONE;
            this.mCenterX = 0.5f;
            this.mCenterY = 0.5f;
            this.mGradientRadius = 0.5f;
            this.mGradientRadiusType = 0;
            this.mUseLevel = false;
            this.mUseLevelForShape = true;
            this.mTint = null;
            this.mTintMode = Drawable.DEFAULT_TINT_MODE;
            this.mDensity = 160;
            this.mChangingConfigurations = orig.mChangingConfigurations;
            this.mShape = orig.mShape;
            this.mGradient = orig.mGradient;
            this.mAngle = orig.mAngle;
            this.mOrientation = orig.mOrientation;
            this.mSolidColors = orig.mSolidColors;
            if (orig.mGradientColors != null) {
                this.mGradientColors = (int[])orig.mGradientColors.clone();
            }
            if (orig.mPositions != null) {
                this.mPositions = (float[])orig.mPositions.clone();
            }
            this.mStrokeColors = orig.mStrokeColors;
            this.mStrokeWidth = orig.mStrokeWidth;
            this.mStrokeDashWidth = orig.mStrokeDashWidth;
            this.mStrokeDashGap = orig.mStrokeDashGap;
            this.mRadius = orig.mRadius;
            if (orig.mRadiusArray != null) {
                this.mRadiusArray = (float[])orig.mRadiusArray.clone();
            }
            if (orig.mPadding != null) {
                this.mPadding = new Rect(orig.mPadding);
            }
            this.mWidth = orig.mWidth;
            this.mHeight = orig.mHeight;
            this.mInnerRadiusRatio = orig.mInnerRadiusRatio;
            this.mThicknessRatio = orig.mThicknessRatio;
            this.mInnerRadius = orig.mInnerRadius;
            this.mThickness = orig.mThickness;
            this.mDither = orig.mDither;
            this.mOpticalInsets = orig.mOpticalInsets;
            this.mCenterX = orig.mCenterX;
            this.mCenterY = orig.mCenterY;
            this.mGradientRadius = orig.mGradientRadius;
            this.mGradientRadiusType = orig.mGradientRadiusType;
            this.mUseLevel = orig.mUseLevel;
            this.mUseLevelForShape = orig.mUseLevelForShape;
            this.mOpaqueOverBounds = orig.mOpaqueOverBounds;
            this.mOpaqueOverShape = orig.mOpaqueOverShape;
            this.mTint = orig.mTint;
            this.mTintMode = orig.mTintMode;
            this.mThemeAttrs = orig.mThemeAttrs;
            this.mAttrSize = orig.mAttrSize;
            this.mAttrGradient = orig.mAttrGradient;
            this.mAttrSolid = orig.mAttrSolid;
            this.mAttrStroke = orig.mAttrStroke;
            this.mAttrCorners = orig.mAttrCorners;
            this.mAttrPadding = orig.mAttrPadding;
            this.mDensity = Drawable.resolveDensity(res, orig.mDensity);
            if (orig.mDensity != this.mDensity) {
                this.applyDensityScaling(orig.mDensity, this.mDensity);
            }
        }

        private final void $$robo$$android_graphics_drawable_GradientDrawable_GradientState$setDensity(int targetDensity) {
            if (this.mDensity != targetDensity) {
                int sourceDensity = this.mDensity;
                this.mDensity = targetDensity;
                this.applyDensityScaling(sourceDensity, targetDensity);
            }
        }

        private final void $$robo$$android_graphics_drawable_GradientDrawable_GradientState$applyDensityScaling(int sourceDensity, int targetDensity) {
            if (this.mInnerRadius > 0) {
                this.mInnerRadius = Drawable.scaleFromDensity(this.mInnerRadius, sourceDensity, targetDensity, true);
            }
            if (this.mThickness > 0) {
                this.mThickness = Drawable.scaleFromDensity(this.mThickness, sourceDensity, targetDensity, true);
            }
            if (this.mOpticalInsets != Insets.NONE) {
                int left = Drawable.scaleFromDensity(this.mOpticalInsets.left, sourceDensity, targetDensity, true);
                int top = Drawable.scaleFromDensity(this.mOpticalInsets.top, sourceDensity, targetDensity, true);
                int right = Drawable.scaleFromDensity(this.mOpticalInsets.right, sourceDensity, targetDensity, true);
                int bottom = Drawable.scaleFromDensity(this.mOpticalInsets.bottom, sourceDensity, targetDensity, true);
                this.mOpticalInsets = Insets.of(left, top, right, bottom);
            }
            if (this.mPadding != null) {
                this.mPadding.left = Drawable.scaleFromDensity(this.mPadding.left, sourceDensity, targetDensity, false);
                this.mPadding.top = Drawable.scaleFromDensity(this.mPadding.top, sourceDensity, targetDensity, false);
                this.mPadding.right = Drawable.scaleFromDensity(this.mPadding.right, sourceDensity, targetDensity, false);
                this.mPadding.bottom = Drawable.scaleFromDensity(this.mPadding.bottom, sourceDensity, targetDensity, false);
            }
            if (this.mRadius > 0.0f) {
                this.mRadius = Drawable.scaleFromDensity(this.mRadius, sourceDensity, targetDensity);
            }
            if (this.mRadiusArray != null) {
                this.mRadiusArray[0] = Drawable.scaleFromDensity((int)this.mRadiusArray[0], sourceDensity, targetDensity, true);
                this.mRadiusArray[1] = Drawable.scaleFromDensity((int)this.mRadiusArray[1], sourceDensity, targetDensity, true);
                this.mRadiusArray[2] = Drawable.scaleFromDensity((int)this.mRadiusArray[2], sourceDensity, targetDensity, true);
                this.mRadiusArray[3] = Drawable.scaleFromDensity((int)this.mRadiusArray[3], sourceDensity, targetDensity, true);
            }
            if (this.mStrokeWidth > 0) {
                this.mStrokeWidth = Drawable.scaleFromDensity(this.mStrokeWidth, sourceDensity, targetDensity, true);
            }
            if (this.mStrokeDashWidth > 0.0f) {
                this.mStrokeDashWidth = Drawable.scaleFromDensity(this.mStrokeDashGap, sourceDensity, targetDensity);
            }
            if (this.mStrokeDashGap > 0.0f) {
                this.mStrokeDashGap = Drawable.scaleFromDensity(this.mStrokeDashGap, sourceDensity, targetDensity);
            }
            if (this.mGradientRadiusType == 0) {
                this.mGradientRadius = Drawable.scaleFromDensity(this.mGradientRadius, sourceDensity, targetDensity);
            }
            if (this.mWidth > 0) {
                this.mWidth = Drawable.scaleFromDensity(this.mWidth, sourceDensity, targetDensity, true);
            }
            if (this.mHeight > 0) {
                this.mHeight = Drawable.scaleFromDensity(this.mHeight, sourceDensity, targetDensity, true);
            }
        }

        private final boolean $$robo$$android_graphics_drawable_GradientDrawable_GradientState$canApplyTheme() {
            return this.mThemeAttrs != null || this.mAttrSize != null || this.mAttrGradient != null || this.mAttrSolid != null || this.mAttrStroke != null || this.mAttrCorners != null || this.mAttrPadding != null || this.mTint != null && this.mTint.canApplyTheme() || this.mStrokeColors != null && this.mStrokeColors.canApplyTheme() || this.mSolidColors != null && this.mSolidColors.canApplyTheme() || super.canApplyTheme();
        }

        private final Drawable $$robo$$android_graphics_drawable_GradientDrawable_GradientState$newDrawable() {
            return new GradientDrawable(this, null, null);
        }

        private final Drawable $$robo$$android_graphics_drawable_GradientDrawable_GradientState$newDrawable(Resources res) {
            int density = Drawable.resolveDensity(res, this.mDensity);
            GradientState state = density != this.mDensity ? new GradientState(this, res) : this;
            return new GradientDrawable(state, res, null);
        }

        private final int $$robo$$android_graphics_drawable_GradientDrawable_GradientState$getChangingConfigurations() {
            return this.mChangingConfigurations | (this.mStrokeColors != null ? this.mStrokeColors.getChangingConfigurations() : 0) | (this.mSolidColors != null ? this.mSolidColors.getChangingConfigurations() : 0) | (this.mTint != null ? this.mTint.getChangingConfigurations() : 0);
        }

        private final void $$robo$$android_graphics_drawable_GradientDrawable_GradientState$setShape(int shape) {
            this.mShape = shape;
            this.computeOpacity();
        }

        private final void $$robo$$android_graphics_drawable_GradientDrawable_GradientState$setGradientType(int gradient) {
            this.mGradient = gradient;
        }

        private final void $$robo$$android_graphics_drawable_GradientDrawable_GradientState$setGradientCenter(float x, float y) {
            this.mCenterX = x;
            this.mCenterY = y;
        }

        private final void $$robo$$android_graphics_drawable_GradientDrawable_GradientState$setGradientColors(int[] colors) {
            this.mGradientColors = colors;
            this.mSolidColors = null;
            this.computeOpacity();
        }

        private final void $$robo$$android_graphics_drawable_GradientDrawable_GradientState$setSolidColors(ColorStateList colors) {
            this.mGradientColors = null;
            this.mSolidColors = colors;
            this.computeOpacity();
        }

        private final void $$robo$$android_graphics_drawable_GradientDrawable_GradientState$computeOpacity() {
            this.mOpaqueOverBounds = false;
            this.mOpaqueOverShape = false;
            if (this.mGradientColors != null) {
                for (int i = 0; i < this.mGradientColors.length; ++i) {
                    if (GradientDrawable.isOpaque(this.mGradientColors[i])) continue;
                    return;
                }
            }
            if (this.mGradientColors == null && this.mSolidColors == null) {
                return;
            }
            this.mOpaqueOverShape = true;
            this.mOpaqueOverBounds = this.mShape == 0 && this.mRadius <= 0.0f && this.mRadiusArray == null;
        }

        private final void $$robo$$android_graphics_drawable_GradientDrawable_GradientState$setStroke(int width, ColorStateList colors, float dashWidth, float dashGap) {
            this.mStrokeWidth = width;
            this.mStrokeColors = colors;
            this.mStrokeDashWidth = dashWidth;
            this.mStrokeDashGap = dashGap;
            this.computeOpacity();
        }

        private final void $$robo$$android_graphics_drawable_GradientDrawable_GradientState$setCornerRadius(float radius) {
            if (radius < 0.0f) {
                radius = 0.0f;
            }
            this.mRadius = radius;
            this.mRadiusArray = null;
        }

        private final void $$robo$$android_graphics_drawable_GradientDrawable_GradientState$setCornerRadii(float[] radii) {
            this.mRadiusArray = radii;
            if (radii == null) {
                this.mRadius = 0.0f;
            }
        }

        private final void $$robo$$android_graphics_drawable_GradientDrawable_GradientState$setSize(int width, int height) {
            this.mWidth = width;
            this.mHeight = height;
        }

        private final void $$robo$$android_graphics_drawable_GradientDrawable_GradientState$setGradientRadius(float gradientRadius, int type) {
            this.mGradientRadius = gradientRadius;
            this.mGradientRadiusType = type;
        }

        private void __constructor__(Orientation orientation, int[] nArray) {
            this.$$robo$$android_graphics_drawable_GradientDrawable_GradientState$__constructor__(orientation, nArray);
        }

        public GradientState(Orientation orientation, int[] nArray) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_GradientDrawable_GradientState$__constructor__(android.graphics.drawable.GradientDrawable$Orientation int[] ), this, orientation, nArray);
        }

        private void __constructor__(GradientState gradientState, Resources resources) {
            this.$$robo$$android_graphics_drawable_GradientDrawable_GradientState$__constructor__(gradientState, resources);
        }

        public GradientState(GradientState gradientState, Resources resources) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_GradientDrawable_GradientState$__constructor__(android.graphics.drawable.GradientDrawable$GradientState android.content.res.Resources ), this, gradientState, resources);
        }

        public void setDensity(int n) {
            InvokeDynamicSupport.bootstrap("setDensity", $$robo$$android_graphics_drawable_GradientDrawable_GradientState$setDensity(int ), this, n);
        }

        private void applyDensityScaling(int n, int n2) {
            InvokeDynamicSupport.bootstrap("applyDensityScaling", $$robo$$android_graphics_drawable_GradientDrawable_GradientState$applyDensityScaling(int int ), this, n, n2);
        }

        @Override
        public boolean canApplyTheme() {
            return (boolean)InvokeDynamicSupport.bootstrap("canApplyTheme", $$robo$$android_graphics_drawable_GradientDrawable_GradientState$canApplyTheme(), this);
        }

        @Override
        public Drawable newDrawable() {
            return InvokeDynamicSupport.bootstrap("newDrawable", $$robo$$android_graphics_drawable_GradientDrawable_GradientState$newDrawable(), this);
        }

        @Override
        public Drawable newDrawable(Resources resources) {
            return InvokeDynamicSupport.bootstrap("newDrawable", $$robo$$android_graphics_drawable_GradientDrawable_GradientState$newDrawable(android.content.res.Resources ), this, resources);
        }

        @Override
        public int getChangingConfigurations() {
            return (int)InvokeDynamicSupport.bootstrap("getChangingConfigurations", $$robo$$android_graphics_drawable_GradientDrawable_GradientState$getChangingConfigurations(), this);
        }

        public void setShape(int n) {
            InvokeDynamicSupport.bootstrap("setShape", $$robo$$android_graphics_drawable_GradientDrawable_GradientState$setShape(int ), this, n);
        }

        public void setGradientType(int n) {
            InvokeDynamicSupport.bootstrap("setGradientType", $$robo$$android_graphics_drawable_GradientDrawable_GradientState$setGradientType(int ), this, n);
        }

        public void setGradientCenter(float f, float f2) {
            InvokeDynamicSupport.bootstrap("setGradientCenter", $$robo$$android_graphics_drawable_GradientDrawable_GradientState$setGradientCenter(float float ), this, f, f2);
        }

        public void setGradientColors(int[] nArray) {
            InvokeDynamicSupport.bootstrap("setGradientColors", $$robo$$android_graphics_drawable_GradientDrawable_GradientState$setGradientColors(int[] ), this, nArray);
        }

        public void setSolidColors(ColorStateList colorStateList) {
            InvokeDynamicSupport.bootstrap("setSolidColors", $$robo$$android_graphics_drawable_GradientDrawable_GradientState$setSolidColors(android.content.res.ColorStateList ), this, colorStateList);
        }

        private void computeOpacity() {
            InvokeDynamicSupport.bootstrap("computeOpacity", $$robo$$android_graphics_drawable_GradientDrawable_GradientState$computeOpacity(), this);
        }

        public void setStroke(int n, ColorStateList colorStateList, float f, float f2) {
            InvokeDynamicSupport.bootstrap("setStroke", $$robo$$android_graphics_drawable_GradientDrawable_GradientState$setStroke(int android.content.res.ColorStateList float float ), this, n, colorStateList, f, f2);
        }

        public void setCornerRadius(float f) {
            InvokeDynamicSupport.bootstrap("setCornerRadius", $$robo$$android_graphics_drawable_GradientDrawable_GradientState$setCornerRadius(float ), this, f);
        }

        public void setCornerRadii(float[] fArray) {
            InvokeDynamicSupport.bootstrap("setCornerRadii", $$robo$$android_graphics_drawable_GradientDrawable_GradientState$setCornerRadii(float[] ), this, fArray);
        }

        public void setSize(int n, int n2) {
            InvokeDynamicSupport.bootstrap("setSize", $$robo$$android_graphics_drawable_GradientDrawable_GradientState$setSize(int int ), this, n, n2);
        }

        public void setGradientRadius(float f, int n) {
            InvokeDynamicSupport.bootstrap("setGradientRadius", $$robo$$android_graphics_drawable_GradientDrawable_GradientState$setGradientRadius(float int ), this, f, n);
        }

        public /* synthetic */ GradientState() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (GradientState)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class Orientation
    extends Enum<Orientation> {
        public /* synthetic */ Object __robo_data__;
        public static /* enum */ Orientation TOP_BOTTOM;
        public static /* enum */ Orientation TR_BL;
        public static /* enum */ Orientation RIGHT_LEFT;
        public static /* enum */ Orientation BR_TL;
        public static /* enum */ Orientation BOTTOM_TOP;
        public static /* enum */ Orientation BL_TR;
        public static /* enum */ Orientation LEFT_RIGHT;
        public static /* enum */ Orientation TL_BR;
        private static /* synthetic */ Orientation[] $VALUES;

        private static final Orientation[] $$robo$$android_graphics_drawable_GradientDrawable_Orientation$values() {
            return (Orientation[])$VALUES.clone();
        }

        private static final Orientation $$robo$$android_graphics_drawable_GradientDrawable_Orientation$valueOf(String name) {
            return Enum.valueOf(Orientation.class, name);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void $$robo$$android_graphics_drawable_GradientDrawable_Orientation$__constructor__(String string2, int n) {
        }

        static void __staticInitializer__() {
            TOP_BOTTOM = new Orientation();
            TR_BL = new Orientation();
            RIGHT_LEFT = new Orientation();
            BR_TL = new Orientation();
            BOTTOM_TOP = new Orientation();
            BL_TR = new Orientation();
            LEFT_RIGHT = new Orientation();
            TL_BR = new Orientation();
            $VALUES = new Orientation[]{TOP_BOTTOM, TR_BL, RIGHT_LEFT, BR_TL, BOTTOM_TOP, BL_TR, LEFT_RIGHT, TL_BR};
        }

        public static Orientation[] values() {
            return InvokeDynamicSupport.bootstrapStatic("values", $$robo$$android_graphics_drawable_GradientDrawable_Orientation$values());
        }

        public static Orientation valueOf(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("valueOf", $$robo$$android_graphics_drawable_GradientDrawable_Orientation$valueOf(java.lang.String ), (String)string2);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void __constructor__(String string2, int n) {
            this.$$robo$$android_graphics_drawable_GradientDrawable_Orientation$__constructor__(string2, n);
        }

        public Orientation() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_GradientDrawable_Orientation$__constructor__(java.lang.String int ), this, string2, n);
        }

        static {
            RobolectricInternals.classInitializing(Orientation.class);
        }

        public /* synthetic */ Orientation() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Orientation)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @IntDef(value={0L, 1L, 2L})
    public static @interface RadiusType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @IntDef(value={0L, 1L, 2L})
    public static @interface GradientType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @IntDef(value={0L, 1L, 2L, 3L})
    public static @interface Shape {
    }
}

