/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.Matrix;
import android.graphics.RectF;
import android.graphics.Region;
import com.google.errorprone.annotations.DoNotMock;
import dalvik.annotation.optimization.CriticalNative;
import dalvik.annotation.optimization.FastNative;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class Path
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    public long mNativePath;
    public boolean isSimplePath;
    public Region rects;
    private Direction mLastDirection;
    static FillType[] sFillTypeArray;

    private void $$robo$$android_graphics_Path$__constructor__() {
        this.isSimplePath = true;
        this.mLastDirection = null;
        this.mNativePath = Path.nInit();
    }

    private void $$robo$$android_graphics_Path$__constructor__(Path src) {
        this.isSimplePath = true;
        this.mLastDirection = null;
        long valNative = 0L;
        if (src != null) {
            valNative = src.mNativePath;
            this.isSimplePath = src.isSimplePath;
            if (src.rects != null) {
                this.rects = new Region(src.rects);
            }
        }
        this.mNativePath = Path.nInit(valNative);
    }

    private final void $$robo$$android_graphics_Path$reset() {
        this.isSimplePath = true;
        this.mLastDirection = null;
        if (this.rects != null) {
            this.rects.setEmpty();
        }
        FillType fillType = this.getFillType();
        Path.nReset(this.mNativePath);
        this.setFillType(fillType);
    }

    private final void $$robo$$android_graphics_Path$rewind() {
        this.isSimplePath = true;
        this.mLastDirection = null;
        if (this.rects != null) {
            this.rects.setEmpty();
        }
        Path.nRewind(this.mNativePath);
    }

    private final void $$robo$$android_graphics_Path$set(Path src) {
        if (this == src) {
            return;
        }
        this.isSimplePath = src.isSimplePath;
        Path.nSet(this.mNativePath, src.mNativePath);
        if (!this.isSimplePath) {
            return;
        }
        if (this.rects != null && src.rects != null) {
            this.rects.set(src.rects);
        } else if (this.rects != null && src.rects == null) {
            this.rects.setEmpty();
        } else if (src.rects != null) {
            this.rects = new Region(src.rects);
        }
    }

    private final boolean $$robo$$android_graphics_Path$op(Path path, Op op) {
        return this.op(this, path, op);
    }

    private final boolean $$robo$$android_graphics_Path$op(Path path1, Path path2, Op op) {
        if (Path.nOp(path1.mNativePath, path2.mNativePath, op.ordinal(), this.mNativePath)) {
            this.isSimplePath = false;
            this.rects = null;
            return true;
        }
        return false;
    }

    private final boolean $$robo$$android_graphics_Path$isConvex() {
        return Path.nIsConvex(this.mNativePath);
    }

    private final FillType $$robo$$android_graphics_Path$getFillType() {
        return sFillTypeArray[Path.nGetFillType(this.mNativePath)];
    }

    private final void $$robo$$android_graphics_Path$setFillType(FillType ft) {
        Path.nSetFillType(this.mNativePath, ft.nativeInt);
    }

    private final boolean $$robo$$android_graphics_Path$isInverseFillType() {
        int ft = Path.nGetFillType(this.mNativePath);
        return (ft & FillType.INVERSE_WINDING.nativeInt) != 0;
    }

    private final void $$robo$$android_graphics_Path$toggleInverseFillType() {
        int ft = Path.nGetFillType(this.mNativePath);
        Path.nSetFillType(this.mNativePath, ft ^= FillType.INVERSE_WINDING.nativeInt);
    }

    private final boolean $$robo$$android_graphics_Path$isEmpty() {
        return Path.nIsEmpty(this.mNativePath);
    }

    private final boolean $$robo$$android_graphics_Path$isRect(RectF rect) {
        return Path.nIsRect(this.mNativePath, rect);
    }

    private final void $$robo$$android_graphics_Path$computeBounds(RectF bounds, boolean exact) {
        Path.nComputeBounds(this.mNativePath, bounds);
    }

    private final void $$robo$$android_graphics_Path$incReserve(int extraPtCount) {
        Path.nIncReserve(this.mNativePath, extraPtCount);
    }

    private final void $$robo$$android_graphics_Path$moveTo(float x, float y) {
        Path.nMoveTo(this.mNativePath, x, y);
    }

    private final void $$robo$$android_graphics_Path$rMoveTo(float dx, float dy) {
        Path.nRMoveTo(this.mNativePath, dx, dy);
    }

    private final void $$robo$$android_graphics_Path$lineTo(float x, float y) {
        this.isSimplePath = false;
        Path.nLineTo(this.mNativePath, x, y);
    }

    private final void $$robo$$android_graphics_Path$rLineTo(float dx, float dy) {
        this.isSimplePath = false;
        Path.nRLineTo(this.mNativePath, dx, dy);
    }

    private final void $$robo$$android_graphics_Path$quadTo(float x1, float y1, float x2, float y2) {
        this.isSimplePath = false;
        Path.nQuadTo(this.mNativePath, x1, y1, x2, y2);
    }

    private final void $$robo$$android_graphics_Path$rQuadTo(float dx1, float dy1, float dx2, float dy2) {
        this.isSimplePath = false;
        Path.nRQuadTo(this.mNativePath, dx1, dy1, dx2, dy2);
    }

    private final void $$robo$$android_graphics_Path$cubicTo(float x1, float y1, float x2, float y2, float x3, float y3) {
        this.isSimplePath = false;
        Path.nCubicTo(this.mNativePath, x1, y1, x2, y2, x3, y3);
    }

    private final void $$robo$$android_graphics_Path$rCubicTo(float x1, float y1, float x2, float y2, float x3, float y3) {
        this.isSimplePath = false;
        Path.nRCubicTo(this.mNativePath, x1, y1, x2, y2, x3, y3);
    }

    private final void $$robo$$android_graphics_Path$arcTo(RectF oval, float startAngle, float sweepAngle, boolean forceMoveTo) {
        this.arcTo(oval.left, oval.top, oval.right, oval.bottom, startAngle, sweepAngle, forceMoveTo);
    }

    private final void $$robo$$android_graphics_Path$arcTo(RectF oval, float startAngle, float sweepAngle) {
        this.arcTo(oval.left, oval.top, oval.right, oval.bottom, startAngle, sweepAngle, false);
    }

    private final void $$robo$$android_graphics_Path$arcTo(float left, float top, float right, float bottom, float startAngle, float sweepAngle, boolean forceMoveTo) {
        this.isSimplePath = false;
        Path.nArcTo(this.mNativePath, left, top, right, bottom, startAngle, sweepAngle, forceMoveTo);
    }

    private final void $$robo$$android_graphics_Path$close() {
        this.isSimplePath = false;
        Path.nClose(this.mNativePath);
    }

    private final void $$robo$$android_graphics_Path$detectSimplePath(float left, float top, float right, float bottom, Direction dir) {
        if (this.mLastDirection == null) {
            this.mLastDirection = dir;
        }
        if (this.mLastDirection != dir) {
            this.isSimplePath = false;
        } else {
            if (this.rects == null) {
                this.rects = new Region();
            }
            this.rects.op((int)left, (int)top, (int)right, (int)bottom, Region.Op.UNION);
        }
    }

    private final void $$robo$$android_graphics_Path$addRect(RectF rect, Direction dir) {
        this.addRect(rect.left, rect.top, rect.right, rect.bottom, dir);
    }

    private final void $$robo$$android_graphics_Path$addRect(float left, float top, float right, float bottom, Direction dir) {
        this.detectSimplePath(left, top, right, bottom, dir);
        Path.nAddRect(this.mNativePath, left, top, right, bottom, dir.nativeInt);
    }

    private final void $$robo$$android_graphics_Path$addOval(RectF oval, Direction dir) {
        this.addOval(oval.left, oval.top, oval.right, oval.bottom, dir);
    }

    private final void $$robo$$android_graphics_Path$addOval(float left, float top, float right, float bottom, Direction dir) {
        this.isSimplePath = false;
        Path.nAddOval(this.mNativePath, left, top, right, bottom, dir.nativeInt);
    }

    private final void $$robo$$android_graphics_Path$addCircle(float x, float y, float radius, Direction dir) {
        this.isSimplePath = false;
        Path.nAddCircle(this.mNativePath, x, y, radius, dir.nativeInt);
    }

    private final void $$robo$$android_graphics_Path$addArc(RectF oval, float startAngle, float sweepAngle) {
        this.addArc(oval.left, oval.top, oval.right, oval.bottom, startAngle, sweepAngle);
    }

    private final void $$robo$$android_graphics_Path$addArc(float left, float top, float right, float bottom, float startAngle, float sweepAngle) {
        this.isSimplePath = false;
        Path.nAddArc(this.mNativePath, left, top, right, bottom, startAngle, sweepAngle);
    }

    private final void $$robo$$android_graphics_Path$addRoundRect(RectF rect, float rx, float ry, Direction dir) {
        this.addRoundRect(rect.left, rect.top, rect.right, rect.bottom, rx, ry, dir);
    }

    private final void $$robo$$android_graphics_Path$addRoundRect(float left, float top, float right, float bottom, float rx, float ry, Direction dir) {
        this.isSimplePath = false;
        Path.nAddRoundRect(this.mNativePath, left, top, right, bottom, rx, ry, dir.nativeInt);
    }

    private final void $$robo$$android_graphics_Path$addRoundRect(RectF rect, float[] radii, Direction dir) {
        if (rect == null) {
            throw new NullPointerException("need rect parameter");
        }
        this.addRoundRect(rect.left, rect.top, rect.right, rect.bottom, radii, dir);
    }

    private final void $$robo$$android_graphics_Path$addRoundRect(float left, float top, float right, float bottom, float[] radii, Direction dir) {
        if (radii.length < 8) {
            throw new ArrayIndexOutOfBoundsException("radii[] needs 8 values");
        }
        this.isSimplePath = false;
        Path.nAddRoundRect(this.mNativePath, left, top, right, bottom, radii, dir.nativeInt);
    }

    private final void $$robo$$android_graphics_Path$addPath(Path src, float dx, float dy) {
        this.isSimplePath = false;
        Path.nAddPath(this.mNativePath, src.mNativePath, dx, dy);
    }

    private final void $$robo$$android_graphics_Path$addPath(Path src) {
        this.isSimplePath = false;
        Path.nAddPath(this.mNativePath, src.mNativePath);
    }

    private final void $$robo$$android_graphics_Path$addPath(Path src, Matrix matrix) {
        if (!src.isSimplePath) {
            this.isSimplePath = false;
        }
        Path.nAddPath(this.mNativePath, src.mNativePath, matrix.native_instance);
    }

    private final void $$robo$$android_graphics_Path$offset(float dx, float dy, Path dst) {
        if (dst != null) {
            dst.set(this);
        } else {
            dst = this;
        }
        dst.offset(dx, dy);
    }

    private final void $$robo$$android_graphics_Path$offset(float dx, float dy) {
        if (this.isSimplePath && this.rects == null) {
            return;
        }
        if (this.isSimplePath && (double)dx == Math.rint(dx) && (double)dy == Math.rint(dy)) {
            this.rects.translate((int)dx, (int)dy);
        } else {
            this.isSimplePath = false;
        }
        Path.nOffset(this.mNativePath, dx, dy);
    }

    private final void $$robo$$android_graphics_Path$setLastPoint(float dx, float dy) {
        this.isSimplePath = false;
        Path.nSetLastPoint(this.mNativePath, dx, dy);
    }

    private final void $$robo$$android_graphics_Path$transform(Matrix matrix, Path dst) {
        long dstNative = 0L;
        if (dst != null) {
            dst.isSimplePath = false;
            dstNative = dst.mNativePath;
        }
        Path.nTransform(this.mNativePath, matrix.native_instance, dstNative);
    }

    private final void $$robo$$android_graphics_Path$transform(Matrix matrix) {
        this.isSimplePath = false;
        Path.nTransform(this.mNativePath, matrix.native_instance);
    }

    private final void $$robo$$android_graphics_Path$finalize() throws Throwable {
        try {
            Path.nFinalize(this.mNativePath);
            this.mNativePath = 0L;
        }
        finally {
            super.finalize();
        }
    }

    private final long $$robo$$android_graphics_Path$readOnlyNI() {
        return this.mNativePath;
    }

    private final long $$robo$$android_graphics_Path$mutateNI() {
        this.isSimplePath = false;
        return this.mNativePath;
    }

    private final float[] $$robo$$android_graphics_Path$approximate(float acceptableError) {
        if (acceptableError < 0.0f) {
            throw new IllegalArgumentException("AcceptableError must be greater than or equal to 0");
        }
        return Path.nApproximate(this.mNativePath, acceptableError);
    }

    private static final long $$robo$$android_graphics_Path$nInit() {
        return 0L;
    }

    private static final long $$robo$$android_graphics_Path$nInit(long l) {
        return 0L;
    }

    private static final void $$robo$$android_graphics_Path$nFinalize(long l) {
    }

    private static final void $$robo$$android_graphics_Path$nSet(long l, long l2) {
    }

    private static final void $$robo$$android_graphics_Path$nComputeBounds(long l, RectF rectF) {
    }

    private static final void $$robo$$android_graphics_Path$nIncReserve(long l, int n) {
    }

    private static final void $$robo$$android_graphics_Path$nMoveTo(long l, float f, float f2) {
    }

    private static final void $$robo$$android_graphics_Path$nRMoveTo(long l, float f, float f2) {
    }

    private static final void $$robo$$android_graphics_Path$nLineTo(long l, float f, float f2) {
    }

    private static final void $$robo$$android_graphics_Path$nRLineTo(long l, float f, float f2) {
    }

    private static final void $$robo$$android_graphics_Path$nQuadTo(long l, float f, float f2, float f3, float f4) {
    }

    private static final void $$robo$$android_graphics_Path$nRQuadTo(long l, float f, float f2, float f3, float f4) {
    }

    private static final void $$robo$$android_graphics_Path$nCubicTo(long l, float f, float f2, float f3, float f4, float f5, float f6) {
    }

    private static final void $$robo$$android_graphics_Path$nRCubicTo(long l, float f, float f2, float f3, float f4, float f5, float f6) {
    }

    private static final void $$robo$$android_graphics_Path$nArcTo(long l, float f, float f2, float f3, float f4, float f5, float f6, boolean bl) {
    }

    private static final void $$robo$$android_graphics_Path$nClose(long l) {
    }

    private static final void $$robo$$android_graphics_Path$nAddRect(long l, float f, float f2, float f3, float f4, int n) {
    }

    private static final void $$robo$$android_graphics_Path$nAddOval(long l, float f, float f2, float f3, float f4, int n) {
    }

    private static final void $$robo$$android_graphics_Path$nAddCircle(long l, float f, float f2, float f3, int n) {
    }

    private static final void $$robo$$android_graphics_Path$nAddArc(long l, float f, float f2, float f3, float f4, float f5, float f6) {
    }

    private static final void $$robo$$android_graphics_Path$nAddRoundRect(long l, float f, float f2, float f3, float f4, float f5, float f6, int n) {
    }

    private static final void $$robo$$android_graphics_Path$nAddRoundRect(long l, float f, float f2, float f3, float f4, float[] fArray, int n) {
    }

    private static final void $$robo$$android_graphics_Path$nAddPath(long l, long l2, float f, float f2) {
    }

    private static final void $$robo$$android_graphics_Path$nAddPath(long l, long l2) {
    }

    private static final void $$robo$$android_graphics_Path$nAddPath(long l, long l2, long l3) {
    }

    private static final void $$robo$$android_graphics_Path$nOffset(long l, float f, float f2) {
    }

    private static final void $$robo$$android_graphics_Path$nSetLastPoint(long l, float f, float f2) {
    }

    private static final void $$robo$$android_graphics_Path$nTransform(long l, long l2, long l3) {
    }

    private static final void $$robo$$android_graphics_Path$nTransform(long l, long l2) {
    }

    private static final boolean $$robo$$android_graphics_Path$nOp(long l, long l2, int n, long l3) {
        return false;
    }

    private static final float[] $$robo$$android_graphics_Path$nApproximate(long l, float f) {
        return null;
    }

    @FastNative
    private static final boolean $$robo$$android_graphics_Path$nIsRect(long l, RectF rectF) {
        return false;
    }

    @CriticalNative
    private static final void $$robo$$android_graphics_Path$nReset(long l) {
    }

    @CriticalNative
    private static final void $$robo$$android_graphics_Path$nRewind(long l) {
    }

    @CriticalNative
    private static final boolean $$robo$$android_graphics_Path$nIsEmpty(long l) {
        return false;
    }

    @CriticalNative
    private static final boolean $$robo$$android_graphics_Path$nIsConvex(long l) {
        return false;
    }

    @CriticalNative
    private static final int $$robo$$android_graphics_Path$nGetFillType(long l) {
        return 0;
    }

    @CriticalNative
    private static final void $$robo$$android_graphics_Path$nSetFillType(long l, int n) {
    }

    static void __staticInitializer__() {
        sFillTypeArray = new FillType[]{FillType.WINDING, FillType.EVEN_ODD, FillType.INVERSE_WINDING, FillType.INVERSE_EVEN_ODD};
    }

    private void __constructor__() {
        this.$$robo$$android_graphics_Path$__constructor__();
    }

    public Path() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_Path$__constructor__(), this);
    }

    private void __constructor__(Path path) {
        this.$$robo$$android_graphics_Path$__constructor__(path);
    }

    public Path(Path path) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_Path$__constructor__(android.graphics.Path ), this, path);
    }

    public void reset() {
        InvokeDynamicSupport.bootstrap("reset", $$robo$$android_graphics_Path$reset(), this);
    }

    public void rewind() {
        InvokeDynamicSupport.bootstrap("rewind", $$robo$$android_graphics_Path$rewind(), this);
    }

    public void set(Path path) {
        InvokeDynamicSupport.bootstrap("set", $$robo$$android_graphics_Path$set(android.graphics.Path ), this, path);
    }

    public boolean op(Path path, Op op) {
        return (boolean)InvokeDynamicSupport.bootstrap("op", $$robo$$android_graphics_Path$op(android.graphics.Path android.graphics.Path$Op ), this, path, op);
    }

    public boolean op(Path path, Path path2, Op op) {
        return (boolean)InvokeDynamicSupport.bootstrap("op", $$robo$$android_graphics_Path$op(android.graphics.Path android.graphics.Path android.graphics.Path$Op ), this, path, path2, op);
    }

    public boolean isConvex() {
        return (boolean)InvokeDynamicSupport.bootstrap("isConvex", $$robo$$android_graphics_Path$isConvex(), this);
    }

    public FillType getFillType() {
        return InvokeDynamicSupport.bootstrap("getFillType", $$robo$$android_graphics_Path$getFillType(), this);
    }

    public void setFillType(FillType fillType) {
        InvokeDynamicSupport.bootstrap("setFillType", $$robo$$android_graphics_Path$setFillType(android.graphics.Path$FillType ), this, fillType);
    }

    public boolean isInverseFillType() {
        return (boolean)InvokeDynamicSupport.bootstrap("isInverseFillType", $$robo$$android_graphics_Path$isInverseFillType(), this);
    }

    public void toggleInverseFillType() {
        InvokeDynamicSupport.bootstrap("toggleInverseFillType", $$robo$$android_graphics_Path$toggleInverseFillType(), this);
    }

    public boolean isEmpty() {
        return (boolean)InvokeDynamicSupport.bootstrap("isEmpty", $$robo$$android_graphics_Path$isEmpty(), this);
    }

    public boolean isRect(RectF rectF) {
        return (boolean)InvokeDynamicSupport.bootstrap("isRect", $$robo$$android_graphics_Path$isRect(android.graphics.RectF ), this, rectF);
    }

    public void computeBounds(RectF rectF, boolean bl) {
        InvokeDynamicSupport.bootstrap("computeBounds", $$robo$$android_graphics_Path$computeBounds(android.graphics.RectF boolean ), this, rectF, bl);
    }

    public void incReserve(int n) {
        InvokeDynamicSupport.bootstrap("incReserve", $$robo$$android_graphics_Path$incReserve(int ), this, n);
    }

    public void moveTo(float f, float f2) {
        InvokeDynamicSupport.bootstrap("moveTo", $$robo$$android_graphics_Path$moveTo(float float ), this, f, f2);
    }

    public void rMoveTo(float f, float f2) {
        InvokeDynamicSupport.bootstrap("rMoveTo", $$robo$$android_graphics_Path$rMoveTo(float float ), this, f, f2);
    }

    public void lineTo(float f, float f2) {
        InvokeDynamicSupport.bootstrap("lineTo", $$robo$$android_graphics_Path$lineTo(float float ), this, f, f2);
    }

    public void rLineTo(float f, float f2) {
        InvokeDynamicSupport.bootstrap("rLineTo", $$robo$$android_graphics_Path$rLineTo(float float ), this, f, f2);
    }

    public void quadTo(float f, float f2, float f3, float f4) {
        InvokeDynamicSupport.bootstrap("quadTo", $$robo$$android_graphics_Path$quadTo(float float float float ), this, f, f2, f3, f4);
    }

    public void rQuadTo(float f, float f2, float f3, float f4) {
        InvokeDynamicSupport.bootstrap("rQuadTo", $$robo$$android_graphics_Path$rQuadTo(float float float float ), this, f, f2, f3, f4);
    }

    public void cubicTo(float f, float f2, float f3, float f4, float f5, float f6) {
        InvokeDynamicSupport.bootstrap("cubicTo", $$robo$$android_graphics_Path$cubicTo(float float float float float float ), this, f, f2, f3, f4, f5, f6);
    }

    public void rCubicTo(float f, float f2, float f3, float f4, float f5, float f6) {
        InvokeDynamicSupport.bootstrap("rCubicTo", $$robo$$android_graphics_Path$rCubicTo(float float float float float float ), this, f, f2, f3, f4, f5, f6);
    }

    public void arcTo(RectF rectF, float f, float f2, boolean bl) {
        InvokeDynamicSupport.bootstrap("arcTo", $$robo$$android_graphics_Path$arcTo(android.graphics.RectF float float boolean ), this, rectF, f, f2, bl);
    }

    public void arcTo(RectF rectF, float f, float f2) {
        InvokeDynamicSupport.bootstrap("arcTo", $$robo$$android_graphics_Path$arcTo(android.graphics.RectF float float ), this, rectF, f, f2);
    }

    public void arcTo(float f, float f2, float f3, float f4, float f5, float f6, boolean bl) {
        InvokeDynamicSupport.bootstrap("arcTo", $$robo$$android_graphics_Path$arcTo(float float float float float float boolean ), this, f, f2, f3, f4, f5, f6, bl);
    }

    public void close() {
        InvokeDynamicSupport.bootstrap("close", $$robo$$android_graphics_Path$close(), this);
    }

    private void detectSimplePath(float f, float f2, float f3, float f4, Direction direction) {
        InvokeDynamicSupport.bootstrap("detectSimplePath", $$robo$$android_graphics_Path$detectSimplePath(float float float float android.graphics.Path$Direction ), this, f, f2, f3, f4, direction);
    }

    public void addRect(RectF rectF, Direction direction) {
        InvokeDynamicSupport.bootstrap("addRect", $$robo$$android_graphics_Path$addRect(android.graphics.RectF android.graphics.Path$Direction ), this, rectF, direction);
    }

    public void addRect(float f, float f2, float f3, float f4, Direction direction) {
        InvokeDynamicSupport.bootstrap("addRect", $$robo$$android_graphics_Path$addRect(float float float float android.graphics.Path$Direction ), this, f, f2, f3, f4, direction);
    }

    public void addOval(RectF rectF, Direction direction) {
        InvokeDynamicSupport.bootstrap("addOval", $$robo$$android_graphics_Path$addOval(android.graphics.RectF android.graphics.Path$Direction ), this, rectF, direction);
    }

    public void addOval(float f, float f2, float f3, float f4, Direction direction) {
        InvokeDynamicSupport.bootstrap("addOval", $$robo$$android_graphics_Path$addOval(float float float float android.graphics.Path$Direction ), this, f, f2, f3, f4, direction);
    }

    public void addCircle(float f, float f2, float f3, Direction direction) {
        InvokeDynamicSupport.bootstrap("addCircle", $$robo$$android_graphics_Path$addCircle(float float float android.graphics.Path$Direction ), this, f, f2, f3, direction);
    }

    public void addArc(RectF rectF, float f, float f2) {
        InvokeDynamicSupport.bootstrap("addArc", $$robo$$android_graphics_Path$addArc(android.graphics.RectF float float ), this, rectF, f, f2);
    }

    public void addArc(float f, float f2, float f3, float f4, float f5, float f6) {
        InvokeDynamicSupport.bootstrap("addArc", $$robo$$android_graphics_Path$addArc(float float float float float float ), this, f, f2, f3, f4, f5, f6);
    }

    public void addRoundRect(RectF rectF, float f, float f2, Direction direction) {
        InvokeDynamicSupport.bootstrap("addRoundRect", $$robo$$android_graphics_Path$addRoundRect(android.graphics.RectF float float android.graphics.Path$Direction ), this, rectF, f, f2, direction);
    }

    public void addRoundRect(float f, float f2, float f3, float f4, float f5, float f6, Direction direction) {
        InvokeDynamicSupport.bootstrap("addRoundRect", $$robo$$android_graphics_Path$addRoundRect(float float float float float float android.graphics.Path$Direction ), this, f, f2, f3, f4, f5, f6, direction);
    }

    public void addRoundRect(RectF rectF, float[] fArray, Direction direction) {
        InvokeDynamicSupport.bootstrap("addRoundRect", $$robo$$android_graphics_Path$addRoundRect(android.graphics.RectF float[] android.graphics.Path$Direction ), this, rectF, fArray, direction);
    }

    public void addRoundRect(float f, float f2, float f3, float f4, float[] fArray, Direction direction) {
        InvokeDynamicSupport.bootstrap("addRoundRect", $$robo$$android_graphics_Path$addRoundRect(float float float float float[] android.graphics.Path$Direction ), this, f, f2, f3, f4, fArray, direction);
    }

    public void addPath(Path path, float f, float f2) {
        InvokeDynamicSupport.bootstrap("addPath", $$robo$$android_graphics_Path$addPath(android.graphics.Path float float ), this, path, f, f2);
    }

    public void addPath(Path path) {
        InvokeDynamicSupport.bootstrap("addPath", $$robo$$android_graphics_Path$addPath(android.graphics.Path ), this, path);
    }

    public void addPath(Path path, Matrix matrix) {
        InvokeDynamicSupport.bootstrap("addPath", $$robo$$android_graphics_Path$addPath(android.graphics.Path android.graphics.Matrix ), this, path, matrix);
    }

    public void offset(float f, float f2, Path path) {
        InvokeDynamicSupport.bootstrap("offset", $$robo$$android_graphics_Path$offset(float float android.graphics.Path ), this, f, f2, path);
    }

    public void offset(float f, float f2) {
        InvokeDynamicSupport.bootstrap("offset", $$robo$$android_graphics_Path$offset(float float ), this, f, f2);
    }

    public void setLastPoint(float f, float f2) {
        InvokeDynamicSupport.bootstrap("setLastPoint", $$robo$$android_graphics_Path$setLastPoint(float float ), this, f, f2);
    }

    public void transform(Matrix matrix, Path path) {
        InvokeDynamicSupport.bootstrap("transform", $$robo$$android_graphics_Path$transform(android.graphics.Matrix android.graphics.Path ), this, matrix, path);
    }

    public void transform(Matrix matrix) {
        InvokeDynamicSupport.bootstrap("transform", $$robo$$android_graphics_Path$transform(android.graphics.Matrix ), this, matrix);
    }

    protected void finalize() throws Throwable {
        InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_graphics_Path$finalize(), this);
    }

    public long readOnlyNI() {
        return (long)InvokeDynamicSupport.bootstrap("readOnlyNI", $$robo$$android_graphics_Path$readOnlyNI(), this);
    }

    long mutateNI() {
        return (long)InvokeDynamicSupport.bootstrap("mutateNI", $$robo$$android_graphics_Path$mutateNI(), this);
    }

    public float[] approximate(float f) {
        return InvokeDynamicSupport.bootstrap("approximate", $$robo$$android_graphics_Path$approximate(float ), this, f);
    }

    private static long nInit() {
        return (long)InvokeDynamicSupport.bootstrapStatic("nInit", $$robo$$android_graphics_Path$nInit());
    }

    private static long nInit(long l) {
        return (long)InvokeDynamicSupport.bootstrapStatic("nInit", $$robo$$android_graphics_Path$nInit(long ), (long)l);
    }

    private static void nFinalize(long l) {
        InvokeDynamicSupport.bootstrapStatic("nFinalize", $$robo$$android_graphics_Path$nFinalize(long ), (long)l);
    }

    private static void nSet(long l, long l2) {
        InvokeDynamicSupport.bootstrapStatic("nSet", $$robo$$android_graphics_Path$nSet(long long ), (long)l, (long)l2);
    }

    private static void nComputeBounds(long l, RectF rectF) {
        InvokeDynamicSupport.bootstrapStatic("nComputeBounds", $$robo$$android_graphics_Path$nComputeBounds(long android.graphics.RectF ), (long)l, (RectF)rectF);
    }

    private static void nIncReserve(long l, int n) {
        InvokeDynamicSupport.bootstrapStatic("nIncReserve", $$robo$$android_graphics_Path$nIncReserve(long int ), (long)l, (int)n);
    }

    private static void nMoveTo(long l, float f, float f2) {
        InvokeDynamicSupport.bootstrapStatic("nMoveTo", $$robo$$android_graphics_Path$nMoveTo(long float float ), (long)l, (float)f, (float)f2);
    }

    private static void nRMoveTo(long l, float f, float f2) {
        InvokeDynamicSupport.bootstrapStatic("nRMoveTo", $$robo$$android_graphics_Path$nRMoveTo(long float float ), (long)l, (float)f, (float)f2);
    }

    private static void nLineTo(long l, float f, float f2) {
        InvokeDynamicSupport.bootstrapStatic("nLineTo", $$robo$$android_graphics_Path$nLineTo(long float float ), (long)l, (float)f, (float)f2);
    }

    private static void nRLineTo(long l, float f, float f2) {
        InvokeDynamicSupport.bootstrapStatic("nRLineTo", $$robo$$android_graphics_Path$nRLineTo(long float float ), (long)l, (float)f, (float)f2);
    }

    private static void nQuadTo(long l, float f, float f2, float f3, float f4) {
        InvokeDynamicSupport.bootstrapStatic("nQuadTo", $$robo$$android_graphics_Path$nQuadTo(long float float float float ), (long)l, (float)f, (float)f2, (float)f3, (float)f4);
    }

    private static void nRQuadTo(long l, float f, float f2, float f3, float f4) {
        InvokeDynamicSupport.bootstrapStatic("nRQuadTo", $$robo$$android_graphics_Path$nRQuadTo(long float float float float ), (long)l, (float)f, (float)f2, (float)f3, (float)f4);
    }

    private static void nCubicTo(long l, float f, float f2, float f3, float f4, float f5, float f6) {
        InvokeDynamicSupport.bootstrapStatic("nCubicTo", $$robo$$android_graphics_Path$nCubicTo(long float float float float float float ), (long)l, (float)f, (float)f2, (float)f3, (float)f4, (float)f5, (float)f6);
    }

    private static void nRCubicTo(long l, float f, float f2, float f3, float f4, float f5, float f6) {
        InvokeDynamicSupport.bootstrapStatic("nRCubicTo", $$robo$$android_graphics_Path$nRCubicTo(long float float float float float float ), (long)l, (float)f, (float)f2, (float)f3, (float)f4, (float)f5, (float)f6);
    }

    private static void nArcTo(long l, float f, float f2, float f3, float f4, float f5, float f6, boolean bl) {
        InvokeDynamicSupport.bootstrapStatic("nArcTo", $$robo$$android_graphics_Path$nArcTo(long float float float float float float boolean ), (long)l, (float)f, (float)f2, (float)f3, (float)f4, (float)f5, (float)f6, (boolean)bl);
    }

    private static void nClose(long l) {
        InvokeDynamicSupport.bootstrapStatic("nClose", $$robo$$android_graphics_Path$nClose(long ), (long)l);
    }

    private static void nAddRect(long l, float f, float f2, float f3, float f4, int n) {
        InvokeDynamicSupport.bootstrapStatic("nAddRect", $$robo$$android_graphics_Path$nAddRect(long float float float float int ), (long)l, (float)f, (float)f2, (float)f3, (float)f4, (int)n);
    }

    private static void nAddOval(long l, float f, float f2, float f3, float f4, int n) {
        InvokeDynamicSupport.bootstrapStatic("nAddOval", $$robo$$android_graphics_Path$nAddOval(long float float float float int ), (long)l, (float)f, (float)f2, (float)f3, (float)f4, (int)n);
    }

    private static void nAddCircle(long l, float f, float f2, float f3, int n) {
        InvokeDynamicSupport.bootstrapStatic("nAddCircle", $$robo$$android_graphics_Path$nAddCircle(long float float float int ), (long)l, (float)f, (float)f2, (float)f3, (int)n);
    }

    private static void nAddArc(long l, float f, float f2, float f3, float f4, float f5, float f6) {
        InvokeDynamicSupport.bootstrapStatic("nAddArc", $$robo$$android_graphics_Path$nAddArc(long float float float float float float ), (long)l, (float)f, (float)f2, (float)f3, (float)f4, (float)f5, (float)f6);
    }

    private static void nAddRoundRect(long l, float f, float f2, float f3, float f4, float f5, float f6, int n) {
        InvokeDynamicSupport.bootstrapStatic("nAddRoundRect", $$robo$$android_graphics_Path$nAddRoundRect(long float float float float float float int ), (long)l, (float)f, (float)f2, (float)f3, (float)f4, (float)f5, (float)f6, (int)n);
    }

    private static void nAddRoundRect(long l, float f, float f2, float f3, float f4, float[] fArray, int n) {
        InvokeDynamicSupport.bootstrapStatic("nAddRoundRect", $$robo$$android_graphics_Path$nAddRoundRect(long float float float float float[] int ), (long)l, (float)f, (float)f2, (float)f3, (float)f4, (float[])fArray, (int)n);
    }

    private static void nAddPath(long l, long l2, float f, float f2) {
        InvokeDynamicSupport.bootstrapStatic("nAddPath", $$robo$$android_graphics_Path$nAddPath(long long float float ), (long)l, (long)l2, (float)f, (float)f2);
    }

    private static void nAddPath(long l, long l2) {
        InvokeDynamicSupport.bootstrapStatic("nAddPath", $$robo$$android_graphics_Path$nAddPath(long long ), (long)l, (long)l2);
    }

    private static void nAddPath(long l, long l2, long l3) {
        InvokeDynamicSupport.bootstrapStatic("nAddPath", $$robo$$android_graphics_Path$nAddPath(long long long ), (long)l, (long)l2, (long)l3);
    }

    private static void nOffset(long l, float f, float f2) {
        InvokeDynamicSupport.bootstrapStatic("nOffset", $$robo$$android_graphics_Path$nOffset(long float float ), (long)l, (float)f, (float)f2);
    }

    private static void nSetLastPoint(long l, float f, float f2) {
        InvokeDynamicSupport.bootstrapStatic("nSetLastPoint", $$robo$$android_graphics_Path$nSetLastPoint(long float float ), (long)l, (float)f, (float)f2);
    }

    private static void nTransform(long l, long l2, long l3) {
        InvokeDynamicSupport.bootstrapStatic("nTransform", $$robo$$android_graphics_Path$nTransform(long long long ), (long)l, (long)l2, (long)l3);
    }

    private static void nTransform(long l, long l2) {
        InvokeDynamicSupport.bootstrapStatic("nTransform", $$robo$$android_graphics_Path$nTransform(long long ), (long)l, (long)l2);
    }

    private static boolean nOp(long l, long l2, int n, long l3) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("nOp", $$robo$$android_graphics_Path$nOp(long long int long ), (long)l, (long)l2, (int)n, (long)l3);
    }

    private static float[] nApproximate(long l, float f) {
        return InvokeDynamicSupport.bootstrapStatic("nApproximate", $$robo$$android_graphics_Path$nApproximate(long float ), (long)l, (float)f);
    }

    private static boolean nIsRect(long l, RectF rectF) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("nIsRect", $$robo$$android_graphics_Path$nIsRect(long android.graphics.RectF ), (long)l, (RectF)rectF);
    }

    private static void nReset(long l) {
        InvokeDynamicSupport.bootstrapStatic("nReset", $$robo$$android_graphics_Path$nReset(long ), (long)l);
    }

    private static void nRewind(long l) {
        InvokeDynamicSupport.bootstrapStatic("nRewind", $$robo$$android_graphics_Path$nRewind(long ), (long)l);
    }

    private static boolean nIsEmpty(long l) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("nIsEmpty", $$robo$$android_graphics_Path$nIsEmpty(long ), (long)l);
    }

    private static boolean nIsConvex(long l) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("nIsConvex", $$robo$$android_graphics_Path$nIsConvex(long ), (long)l);
    }

    private static int nGetFillType(long l) {
        return (int)InvokeDynamicSupport.bootstrapStatic("nGetFillType", $$robo$$android_graphics_Path$nGetFillType(long ), (long)l);
    }

    private static void nSetFillType(long l, int n) {
        InvokeDynamicSupport.bootstrapStatic("nSetFillType", $$robo$$android_graphics_Path$nSetFillType(long int ), (long)l, (int)n);
    }

    static {
        RobolectricInternals.classInitializing(Path.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Path)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class Direction
    extends Enum<Direction> {
        public /* synthetic */ Object __robo_data__;
        public static /* enum */ Direction CW;
        public static /* enum */ Direction CCW;
        int nativeInt;
        private static /* synthetic */ Direction[] $VALUES;

        private static final Direction[] $$robo$$android_graphics_Path_Direction$values() {
            return (Direction[])$VALUES.clone();
        }

        private static final Direction $$robo$$android_graphics_Path_Direction$valueOf(String name) {
            return Enum.valueOf(Direction.class, name);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void $$robo$$android_graphics_Path_Direction$__constructor__(String string2, int n, int ni) {
            this.nativeInt = ni;
        }

        static void __staticInitializer__() {
            CW = new Direction(0);
            CCW = new Direction(1);
            $VALUES = new Direction[]{CW, CCW};
        }

        public static Direction[] values() {
            return InvokeDynamicSupport.bootstrapStatic("values", $$robo$$android_graphics_Path_Direction$values());
        }

        public static Direction valueOf(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("valueOf", $$robo$$android_graphics_Path_Direction$valueOf(java.lang.String ), (String)string2);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void __constructor__(String string2, int n, int n2) {
            this.$$robo$$android_graphics_Path_Direction$__constructor__(string2, n, n2);
        }

        public Direction(int n2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_Path_Direction$__constructor__(java.lang.String int int ), this, string2, n, n2);
        }

        static {
            RobolectricInternals.classInitializing(Direction.class);
        }

        public /* synthetic */ Direction() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Direction)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class FillType
    extends Enum<FillType> {
        public /* synthetic */ Object __robo_data__;
        public static /* enum */ FillType WINDING;
        public static /* enum */ FillType EVEN_ODD;
        public static /* enum */ FillType INVERSE_WINDING;
        public static /* enum */ FillType INVERSE_EVEN_ODD;
        int nativeInt;
        private static /* synthetic */ FillType[] $VALUES;

        private static final FillType[] $$robo$$android_graphics_Path_FillType$values() {
            return (FillType[])$VALUES.clone();
        }

        private static final FillType $$robo$$android_graphics_Path_FillType$valueOf(String name) {
            return Enum.valueOf(FillType.class, name);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void $$robo$$android_graphics_Path_FillType$__constructor__(String string2, int n, int ni) {
            this.nativeInt = ni;
        }

        static void __staticInitializer__() {
            WINDING = new FillType(0);
            EVEN_ODD = new FillType(1);
            INVERSE_WINDING = new FillType(2);
            INVERSE_EVEN_ODD = new FillType(3);
            $VALUES = new FillType[]{WINDING, EVEN_ODD, INVERSE_WINDING, INVERSE_EVEN_ODD};
        }

        public static FillType[] values() {
            return InvokeDynamicSupport.bootstrapStatic("values", $$robo$$android_graphics_Path_FillType$values());
        }

        public static FillType valueOf(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("valueOf", $$robo$$android_graphics_Path_FillType$valueOf(java.lang.String ), (String)string2);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void __constructor__(String string2, int n, int n2) {
            this.$$robo$$android_graphics_Path_FillType$__constructor__(string2, n, n2);
        }

        public FillType(int n2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_Path_FillType$__constructor__(java.lang.String int int ), this, string2, n, n2);
        }

        static {
            RobolectricInternals.classInitializing(FillType.class);
        }

        public /* synthetic */ FillType() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (FillType)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class Op
    extends Enum<Op> {
        public /* synthetic */ Object __robo_data__;
        public static /* enum */ Op DIFFERENCE;
        public static /* enum */ Op INTERSECT;
        public static /* enum */ Op UNION;
        public static /* enum */ Op XOR;
        public static /* enum */ Op REVERSE_DIFFERENCE;
        private static /* synthetic */ Op[] $VALUES;

        private static final Op[] $$robo$$android_graphics_Path_Op$values() {
            return (Op[])$VALUES.clone();
        }

        private static final Op $$robo$$android_graphics_Path_Op$valueOf(String name) {
            return Enum.valueOf(Op.class, name);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void $$robo$$android_graphics_Path_Op$__constructor__(String string2, int n) {
        }

        static void __staticInitializer__() {
            DIFFERENCE = new Op();
            INTERSECT = new Op();
            UNION = new Op();
            XOR = new Op();
            REVERSE_DIFFERENCE = new Op();
            $VALUES = new Op[]{DIFFERENCE, INTERSECT, UNION, XOR, REVERSE_DIFFERENCE};
        }

        public static Op[] values() {
            return InvokeDynamicSupport.bootstrapStatic("values", $$robo$$android_graphics_Path_Op$values());
        }

        public static Op valueOf(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("valueOf", $$robo$$android_graphics_Path_Op$valueOf(java.lang.String ), (String)string2);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void __constructor__(String string2, int n) {
            this.$$robo$$android_graphics_Path_Op$__constructor__(string2, n);
        }

        public Op() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_Path_Op$__constructor__(java.lang.String int ), this, string2, n);
        }

        static {
            RobolectricInternals.classInitializing(Op.class);
        }

        public /* synthetic */ Op() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Op)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

