/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.Canvas;
import android.graphics.ColorSpace;
import android.graphics.GraphicBuffer;
import android.graphics.Matrix;
import android.graphics.NinePatch;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.StrictMode;
import android.os.Trace;
import android.util.DisplayMetrics;
import android.util.Log;
import com.google.errorprone.annotations.DoNotMock;
import java.io.OutputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import libcore.util.NativeAllocationRegistry;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class Bitmap
implements Parcelable,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG = "Bitmap";
    public static int DENSITY_NONE = 0;
    private static long NATIVE_ALLOCATION_SIZE = 32L;
    private long mNativePtr;
    private boolean mIsMutable;
    private boolean mRequestPremultiplied;
    private byte[] mNinePatchChunk;
    private NinePatch.InsetStruct mNinePatchInsets;
    private int mWidth;
    private int mHeight;
    private boolean mRecycled;
    private ColorSpace mColorSpace;
    public int mDensity;
    private static volatile int sDefaultDensity;
    private static int WORKING_COMPRESS_STORAGE = 4096;
    public static Parcelable.Creator<Bitmap> CREATOR;

    private static final void $$robo$$android_graphics_Bitmap$setDefaultDensity(int density) {
        sDefaultDensity = density;
    }

    private static final int $$robo$$android_graphics_Bitmap$getDefaultDensity() {
        if (sDefaultDensity >= 0) {
            return sDefaultDensity;
        }
        sDefaultDensity = DisplayMetrics.DENSITY_DEVICE;
        return sDefaultDensity;
    }

    private void $$robo$$android_graphics_Bitmap$__constructor__(long nativeBitmap, int width, int height, int density, boolean isMutable, boolean requestPremultiplied, byte[] ninePatchChunk, NinePatch.InsetStruct ninePatchInsets) {
        this.mDensity = Bitmap.getDefaultDensity();
        if (nativeBitmap == 0L) {
            throw new RuntimeException("internal error: native bitmap is 0");
        }
        this.mWidth = width;
        this.mHeight = height;
        this.mIsMutable = isMutable;
        this.mRequestPremultiplied = requestPremultiplied;
        this.mNinePatchChunk = ninePatchChunk;
        this.mNinePatchInsets = ninePatchInsets;
        if (density >= 0) {
            this.mDensity = density;
        }
        this.mNativePtr = nativeBitmap;
        long nativeSize = 32L + (long)this.getAllocationByteCount();
        NativeAllocationRegistry registry = new NativeAllocationRegistry(Bitmap.class.getClassLoader(), Bitmap.nativeGetNativeFinalizer(), nativeSize);
        registry.registerNativeAllocation((Object)this, nativeBitmap);
    }

    private final long $$robo$$android_graphics_Bitmap$getNativeInstance() {
        return this.mNativePtr;
    }

    private final void $$robo$$android_graphics_Bitmap$reinit(int width, int height, boolean requestPremultiplied) {
        this.mWidth = width;
        this.mHeight = height;
        this.mRequestPremultiplied = requestPremultiplied;
        this.mColorSpace = null;
    }

    private final int $$robo$$android_graphics_Bitmap$getDensity() {
        if (this.mRecycled) {
            Log.w("Bitmap", "Called getDensity() on a recycle()'d bitmap! This is undefined behavior!");
        }
        return this.mDensity;
    }

    private final void $$robo$$android_graphics_Bitmap$setDensity(int density) {
        this.mDensity = density;
    }

    private final void $$robo$$android_graphics_Bitmap$reconfigure(int width, int height, Config config) {
        this.checkRecycled("Can't call reconfigure() on a recycled bitmap");
        if (width <= 0 || height <= 0) {
            throw new IllegalArgumentException("width and height must be > 0");
        }
        if (!this.isMutable()) {
            throw new IllegalStateException("only mutable bitmaps may be reconfigured");
        }
        Bitmap.nativeReconfigure(this.mNativePtr, width, height, config.nativeInt, this.mRequestPremultiplied);
        this.mWidth = width;
        this.mHeight = height;
        this.mColorSpace = null;
    }

    private final void $$robo$$android_graphics_Bitmap$setWidth(int width) {
        this.reconfigure(width, this.getHeight(), this.getConfig());
    }

    private final void $$robo$$android_graphics_Bitmap$setHeight(int height) {
        this.reconfigure(this.getWidth(), height, this.getConfig());
    }

    private final void $$robo$$android_graphics_Bitmap$setConfig(Config config) {
        this.reconfigure(this.getWidth(), this.getHeight(), config);
    }

    private final void $$robo$$android_graphics_Bitmap$setNinePatchChunk(byte[] chunk) {
        this.mNinePatchChunk = chunk;
    }

    private final void $$robo$$android_graphics_Bitmap$recycle() {
        if (!this.mRecycled && this.mNativePtr != 0L) {
            if (Bitmap.nativeRecycle(this.mNativePtr)) {
                this.mNinePatchChunk = null;
            }
            this.mRecycled = true;
        }
    }

    private final boolean $$robo$$android_graphics_Bitmap$isRecycled() {
        return this.mRecycled;
    }

    private final int $$robo$$android_graphics_Bitmap$getGenerationId() {
        if (this.mRecycled) {
            Log.w("Bitmap", "Called getGenerationId() on a recycle()'d bitmap! This is undefined behavior!");
        }
        return Bitmap.nativeGenerationId(this.mNativePtr);
    }

    private final void $$robo$$android_graphics_Bitmap$checkRecycled(String errorMessage) {
        if (this.mRecycled) {
            throw new IllegalStateException(errorMessage);
        }
    }

    private final void $$robo$$android_graphics_Bitmap$checkHardware(String errorMessage) {
        if (this.getConfig() == Config.HARDWARE) {
            throw new IllegalStateException(errorMessage);
        }
    }

    private static final void $$robo$$android_graphics_Bitmap$checkXYSign(int x, int y) {
        if (x < 0) {
            throw new IllegalArgumentException("x must be >= 0");
        }
        if (y < 0) {
            throw new IllegalArgumentException("y must be >= 0");
        }
    }

    private static final void $$robo$$android_graphics_Bitmap$checkWidthHeight(int width, int height) {
        if (width <= 0) {
            throw new IllegalArgumentException("width must be > 0");
        }
        if (height <= 0) {
            throw new IllegalArgumentException("height must be > 0");
        }
    }

    private final void $$robo$$android_graphics_Bitmap$copyPixelsToBuffer(Buffer dst) {
        int shift;
        this.checkHardware("unable to copyPixelsToBuffer, pixel access is not supported on Config#HARDWARE bitmaps");
        int elements = dst.remaining();
        if (dst instanceof ByteBuffer) {
            shift = 0;
        } else if (dst instanceof ShortBuffer) {
            shift = 1;
        } else if (dst instanceof IntBuffer) {
            shift = 2;
        } else {
            throw new RuntimeException("unsupported Buffer subclass");
        }
        long bufferSize = (long)elements << shift;
        long pixelSize = this.getByteCount();
        if (bufferSize < pixelSize) {
            throw new RuntimeException("Buffer not large enough for pixels");
        }
        Bitmap.nativeCopyPixelsToBuffer(this.mNativePtr, dst);
        int position = dst.position();
        position = (int)((long)position + (pixelSize >> shift));
        dst.position(position);
    }

    private final void $$robo$$android_graphics_Bitmap$copyPixelsFromBuffer(Buffer src) {
        int shift;
        this.checkRecycled("copyPixelsFromBuffer called on recycled bitmap");
        this.checkHardware("unable to copyPixelsFromBuffer, Config#HARDWARE bitmaps are immutable");
        int elements = src.remaining();
        if (src instanceof ByteBuffer) {
            shift = 0;
        } else if (src instanceof ShortBuffer) {
            shift = 1;
        } else if (src instanceof IntBuffer) {
            shift = 2;
        } else {
            throw new RuntimeException("unsupported Buffer subclass");
        }
        long bufferBytes = (long)elements << shift;
        long bitmapBytes = this.getByteCount();
        if (bufferBytes < bitmapBytes) {
            throw new RuntimeException("Buffer not large enough for pixels");
        }
        Bitmap.nativeCopyPixelsFromBuffer(this.mNativePtr, src);
        int position = src.position();
        position = (int)((long)position + (bitmapBytes >> shift));
        src.position(position);
    }

    private final void $$robo$$android_graphics_Bitmap$noteHardwareBitmapSlowCall() {
        if (this.getConfig() == Config.HARDWARE) {
            StrictMode.noteSlowCall("Warning: attempt to read pixels from hardware bitmap, which is very slow operation");
        }
    }

    private final Bitmap $$robo$$android_graphics_Bitmap$copy(Config config, boolean isMutable) {
        this.checkRecycled("Can't copy a recycled bitmap");
        if (config == Config.HARDWARE && isMutable) {
            throw new IllegalArgumentException("Hardware bitmaps are always immutable");
        }
        this.noteHardwareBitmapSlowCall();
        Bitmap b = Bitmap.nativeCopy(this.mNativePtr, config.nativeInt, isMutable);
        if (b != null) {
            b.setPremultiplied(this.mRequestPremultiplied);
            b.mDensity = this.mDensity;
        }
        return b;
    }

    private final Bitmap $$robo$$android_graphics_Bitmap$createAshmemBitmap() {
        this.checkRecycled("Can't copy a recycled bitmap");
        this.noteHardwareBitmapSlowCall();
        Bitmap b = Bitmap.nativeCopyAshmem(this.mNativePtr);
        if (b != null) {
            b.setPremultiplied(this.mRequestPremultiplied);
            b.mDensity = this.mDensity;
        }
        return b;
    }

    private final Bitmap $$robo$$android_graphics_Bitmap$createAshmemBitmap(Config config) {
        this.checkRecycled("Can't copy a recycled bitmap");
        this.noteHardwareBitmapSlowCall();
        Bitmap b = Bitmap.nativeCopyAshmemConfig(this.mNativePtr, config.nativeInt);
        if (b != null) {
            b.setPremultiplied(this.mRequestPremultiplied);
            b.mDensity = this.mDensity;
        }
        return b;
    }

    private static final Bitmap $$robo$$android_graphics_Bitmap$createHardwareBitmap(GraphicBuffer graphicBuffer) {
        return Bitmap.nativeCreateHardwareBitmap(graphicBuffer);
    }

    private static final Bitmap $$robo$$android_graphics_Bitmap$createScaledBitmap(Bitmap src, int dstWidth, int dstHeight, boolean filter) {
        Matrix m = new Matrix();
        int width = src.getWidth();
        int height = src.getHeight();
        if (width != dstWidth || height != dstHeight) {
            float sx = (float)dstWidth / (float)width;
            float sy = (float)dstHeight / (float)height;
            m.setScale(sx, sy);
        }
        return Bitmap.createBitmap(src, 0, 0, width, height, m, filter);
    }

    private static final Bitmap $$robo$$android_graphics_Bitmap$createBitmap(Bitmap src) {
        return Bitmap.createBitmap(src, 0, 0, src.getWidth(), src.getHeight());
    }

    private static final Bitmap $$robo$$android_graphics_Bitmap$createBitmap(Bitmap source, int x, int y, int width, int height) {
        return Bitmap.createBitmap(source, x, y, width, height, null, false);
    }

    private static final Bitmap $$robo$$android_graphics_Bitmap$createBitmap(Bitmap source, int x, int y, int width, int height, Matrix m, boolean filter) {
        Paint paint;
        Bitmap bitmap;
        boolean isHardware;
        Bitmap.checkXYSign(x, y);
        Bitmap.checkWidthHeight(width, height);
        if (x + width > source.getWidth()) {
            throw new IllegalArgumentException("x + width must be <= bitmap.width()");
        }
        if (y + height > source.getHeight()) {
            throw new IllegalArgumentException("y + height must be <= bitmap.height()");
        }
        if (!source.isMutable() && x == 0 && y == 0 && width == source.getWidth() && height == source.getHeight() && (m == null || m.isIdentity())) {
            return source;
        }
        boolean bl = isHardware = source.getConfig() == Config.HARDWARE;
        if (isHardware) {
            source.noteHardwareBitmapSlowCall();
            source = Bitmap.nativeCopyPreserveInternalConfig(source.mNativePtr);
        }
        int neww = width;
        int newh = height;
        Rect srcR = new Rect(x, y, x + width, y + height);
        RectF dstR = new RectF(0.0f, 0.0f, width, height);
        RectF deviceR = new RectF();
        Config newConfig = Config.ARGB_8888;
        Config config = source.getConfig();
        if (config != null) {
            switch (2.$SwitchMap$android$graphics$Bitmap$Config[config.ordinal()]) {
                case 1: {
                    newConfig = Config.RGB_565;
                    break;
                }
                case 2: {
                    newConfig = Config.ALPHA_8;
                    break;
                }
                case 3: {
                    newConfig = Config.RGBA_F16;
                    break;
                }
                default: {
                    newConfig = Config.ARGB_8888;
                }
            }
        }
        if (m == null || m.isIdentity()) {
            bitmap = Bitmap.createBitmap(neww, newh, newConfig, source.hasAlpha());
            paint = null;
        } else {
            boolean transformed = !m.rectStaysRect();
            m.mapRect(deviceR, dstR);
            neww = Math.round(deviceR.width());
            newh = Math.round(deviceR.height());
            Config transformedConfig = newConfig;
            if (transformed && transformedConfig != Config.ARGB_8888 && transformedConfig != Config.RGBA_F16) {
                transformedConfig = Config.ARGB_8888;
            }
            bitmap = Bitmap.createBitmap(neww, newh, transformedConfig, transformed || source.hasAlpha());
            paint = new Paint();
            paint.setFilterBitmap(filter);
            if (transformed) {
                paint.setAntiAlias(true);
            }
        }
        Bitmap.nativeCopyColorSpace(source.mNativePtr, bitmap.mNativePtr);
        bitmap.mDensity = source.mDensity;
        bitmap.setHasAlpha(source.hasAlpha());
        bitmap.setPremultiplied(source.mRequestPremultiplied);
        Canvas canvas = new Canvas(bitmap);
        canvas.translate(-deviceR.left, -deviceR.top);
        canvas.concat(m);
        canvas.drawBitmap(source, srcR, dstR, paint);
        canvas.setBitmap(null);
        if (isHardware) {
            return bitmap.copy(Config.HARDWARE, false);
        }
        return bitmap;
    }

    private static final Bitmap $$robo$$android_graphics_Bitmap$createBitmap(int width, int height, Config config) {
        return Bitmap.createBitmap(width, height, config, true);
    }

    private static final Bitmap $$robo$$android_graphics_Bitmap$createBitmap(DisplayMetrics display, int width, int height, Config config) {
        return Bitmap.createBitmap(display, width, height, config, true);
    }

    private static final Bitmap $$robo$$android_graphics_Bitmap$createBitmap(int width, int height, Config config, boolean hasAlpha) {
        return Bitmap.createBitmap(null, width, height, config, hasAlpha);
    }

    private static final Bitmap $$robo$$android_graphics_Bitmap$createBitmap(int width, int height, Config config, boolean hasAlpha, ColorSpace colorSpace) {
        return Bitmap.createBitmap(null, width, height, config, hasAlpha, colorSpace);
    }

    private static final Bitmap $$robo$$android_graphics_Bitmap$createBitmap(DisplayMetrics display, int width, int height, Config config, boolean hasAlpha) {
        return Bitmap.createBitmap(display, width, height, config, hasAlpha, ColorSpace.get(ColorSpace.Named.SRGB));
    }

    private static final Bitmap $$robo$$android_graphics_Bitmap$createBitmap(DisplayMetrics display, int width, int height, Config config, boolean hasAlpha, ColorSpace colorSpace) {
        Bitmap bm;
        if (width <= 0 || height <= 0) {
            throw new IllegalArgumentException("width and height must be > 0");
        }
        if (config == Config.HARDWARE) {
            throw new IllegalArgumentException("can't create mutable bitmap with Config.HARDWARE");
        }
        if (colorSpace == null) {
            throw new IllegalArgumentException("can't create bitmap without a color space");
        }
        if (config != Config.ARGB_8888 || colorSpace == ColorSpace.get(ColorSpace.Named.SRGB)) {
            bm = Bitmap.nativeCreate(null, 0, width, width, height, config.nativeInt, true, null, null);
        } else {
            if (!(colorSpace instanceof ColorSpace.Rgb)) {
                throw new IllegalArgumentException("colorSpace must be an RGB color space");
            }
            ColorSpace.Rgb rgb = (ColorSpace.Rgb)colorSpace;
            ColorSpace.Rgb.TransferParameters parameters = rgb.getTransferParameters();
            if (parameters == null) {
                throw new IllegalArgumentException("colorSpace must use an ICC parametric transfer function");
            }
            ColorSpace.Rgb d50 = (ColorSpace.Rgb)ColorSpace.adapt(rgb, ColorSpace.ILLUMINANT_D50);
            bm = Bitmap.nativeCreate(null, 0, width, width, height, config.nativeInt, true, d50.getTransform(), parameters);
        }
        if (display != null) {
            bm.mDensity = display.densityDpi;
        }
        bm.setHasAlpha(hasAlpha);
        if (!(config != Config.ARGB_8888 && config != Config.RGBA_F16 || hasAlpha)) {
            Bitmap.nativeErase(bm.mNativePtr, -16777216);
        }
        return bm;
    }

    private static final Bitmap $$robo$$android_graphics_Bitmap$createBitmap(int[] colors, int offset, int stride, int width, int height, Config config) {
        return Bitmap.createBitmap(null, colors, offset, stride, width, height, config);
    }

    private static final Bitmap $$robo$$android_graphics_Bitmap$createBitmap(DisplayMetrics display, int[] colors, int offset, int stride, int width, int height, Config config) {
        Bitmap.checkWidthHeight(width, height);
        if (Math.abs(stride) < width) {
            throw new IllegalArgumentException("abs(stride) must be >= width");
        }
        int lastScanline = offset + (height - 1) * stride;
        int length = colors.length;
        if (offset < 0 || offset + width > length || lastScanline < 0 || lastScanline + width > length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (width <= 0 || height <= 0) {
            throw new IllegalArgumentException("width and height must be > 0");
        }
        Bitmap bm = Bitmap.nativeCreate(colors, offset, stride, width, height, config.nativeInt, false, null, null);
        if (display != null) {
            bm.mDensity = display.densityDpi;
        }
        return bm;
    }

    private static final Bitmap $$robo$$android_graphics_Bitmap$createBitmap(int[] colors, int width, int height, Config config) {
        return Bitmap.createBitmap(null, colors, 0, width, width, height, config);
    }

    private static final Bitmap $$robo$$android_graphics_Bitmap$createBitmap(DisplayMetrics display, int[] colors, int width, int height, Config config) {
        return Bitmap.createBitmap(display, colors, 0, width, width, height, config);
    }

    private final byte[] $$robo$$android_graphics_Bitmap$getNinePatchChunk() {
        return this.mNinePatchChunk;
    }

    private final void $$robo$$android_graphics_Bitmap$getOpticalInsets(Rect outInsets) {
        if (this.mNinePatchInsets == null) {
            outInsets.setEmpty();
        } else {
            outInsets.set(this.mNinePatchInsets.opticalRect);
        }
    }

    private final NinePatch.InsetStruct $$robo$$android_graphics_Bitmap$getNinePatchInsets() {
        return this.mNinePatchInsets;
    }

    private final boolean $$robo$$android_graphics_Bitmap$compress(CompressFormat format, int quality, OutputStream stream) {
        this.checkRecycled("Can't compress a recycled bitmap");
        if (stream == null) {
            throw new NullPointerException();
        }
        if (quality < 0 || quality > 100) {
            throw new IllegalArgumentException("quality must be 0..100");
        }
        StrictMode.noteSlowCall("Compression of a bitmap is slow");
        Trace.traceBegin(8192L, "Bitmap.compress");
        boolean result = Bitmap.nativeCompress(this.mNativePtr, format.nativeInt, quality, stream, new byte[4096]);
        Trace.traceEnd(8192L);
        return result;
    }

    private final boolean $$robo$$android_graphics_Bitmap$isMutable() {
        return this.mIsMutable;
    }

    private final boolean $$robo$$android_graphics_Bitmap$isPremultiplied() {
        if (this.mRecycled) {
            Log.w("Bitmap", "Called isPremultiplied() on a recycle()'d bitmap! This is undefined behavior!");
        }
        return Bitmap.nativeIsPremultiplied(this.mNativePtr);
    }

    private final void $$robo$$android_graphics_Bitmap$setPremultiplied(boolean premultiplied) {
        this.checkRecycled("setPremultiplied called on a recycled bitmap");
        this.mRequestPremultiplied = premultiplied;
        Bitmap.nativeSetPremultiplied(this.mNativePtr, premultiplied);
    }

    private final int $$robo$$android_graphics_Bitmap$getWidth() {
        if (this.mRecycled) {
            Log.w("Bitmap", "Called getWidth() on a recycle()'d bitmap! This is undefined behavior!");
        }
        return this.mWidth;
    }

    private final int $$robo$$android_graphics_Bitmap$getHeight() {
        if (this.mRecycled) {
            Log.w("Bitmap", "Called getHeight() on a recycle()'d bitmap! This is undefined behavior!");
        }
        return this.mHeight;
    }

    private final int $$robo$$android_graphics_Bitmap$getScaledWidth(Canvas canvas) {
        return Bitmap.scaleFromDensity(this.getWidth(), this.mDensity, canvas.mDensity);
    }

    private final int $$robo$$android_graphics_Bitmap$getScaledHeight(Canvas canvas) {
        return Bitmap.scaleFromDensity(this.getHeight(), this.mDensity, canvas.mDensity);
    }

    private final int $$robo$$android_graphics_Bitmap$getScaledWidth(DisplayMetrics metrics) {
        return Bitmap.scaleFromDensity(this.getWidth(), this.mDensity, metrics.densityDpi);
    }

    private final int $$robo$$android_graphics_Bitmap$getScaledHeight(DisplayMetrics metrics) {
        return Bitmap.scaleFromDensity(this.getHeight(), this.mDensity, metrics.densityDpi);
    }

    private final int $$robo$$android_graphics_Bitmap$getScaledWidth(int targetDensity) {
        return Bitmap.scaleFromDensity(this.getWidth(), this.mDensity, targetDensity);
    }

    private final int $$robo$$android_graphics_Bitmap$getScaledHeight(int targetDensity) {
        return Bitmap.scaleFromDensity(this.getHeight(), this.mDensity, targetDensity);
    }

    private static final int $$robo$$android_graphics_Bitmap$scaleFromDensity(int size, int sdensity, int tdensity) {
        if (sdensity == 0 || tdensity == 0 || sdensity == tdensity) {
            return size;
        }
        return (size * tdensity + (sdensity >> 1)) / sdensity;
    }

    private final int $$robo$$android_graphics_Bitmap$getRowBytes() {
        if (this.mRecycled) {
            Log.w("Bitmap", "Called getRowBytes() on a recycle()'d bitmap! This is undefined behavior!");
        }
        return Bitmap.nativeRowBytes(this.mNativePtr);
    }

    private final int $$robo$$android_graphics_Bitmap$getByteCount() {
        if (this.mRecycled) {
            Log.w("Bitmap", "Called getByteCount() on a recycle()'d bitmap! This is undefined behavior!");
            return 0;
        }
        return this.getRowBytes() * this.getHeight();
    }

    private final int $$robo$$android_graphics_Bitmap$getAllocationByteCount() {
        if (this.mRecycled) {
            Log.w("Bitmap", "Called getAllocationByteCount() on a recycle()'d bitmap! This is undefined behavior!");
            return 0;
        }
        return Bitmap.nativeGetAllocationByteCount(this.mNativePtr);
    }

    private final Config $$robo$$android_graphics_Bitmap$getConfig() {
        if (this.mRecycled) {
            Log.w("Bitmap", "Called getConfig() on a recycle()'d bitmap! This is undefined behavior!");
        }
        return Config.nativeToConfig(Bitmap.nativeConfig(this.mNativePtr));
    }

    private final boolean $$robo$$android_graphics_Bitmap$hasAlpha() {
        if (this.mRecycled) {
            Log.w("Bitmap", "Called hasAlpha() on a recycle()'d bitmap! This is undefined behavior!");
        }
        return Bitmap.nativeHasAlpha(this.mNativePtr);
    }

    private final void $$robo$$android_graphics_Bitmap$setHasAlpha(boolean hasAlpha) {
        this.checkRecycled("setHasAlpha called on a recycled bitmap");
        Bitmap.nativeSetHasAlpha(this.mNativePtr, hasAlpha, this.mRequestPremultiplied);
    }

    private final boolean $$robo$$android_graphics_Bitmap$hasMipMap() {
        if (this.mRecycled) {
            Log.w("Bitmap", "Called hasMipMap() on a recycle()'d bitmap! This is undefined behavior!");
        }
        return Bitmap.nativeHasMipMap(this.mNativePtr);
    }

    private final void $$robo$$android_graphics_Bitmap$setHasMipMap(boolean hasMipMap) {
        this.checkRecycled("setHasMipMap called on a recycled bitmap");
        Bitmap.nativeSetHasMipMap(this.mNativePtr, hasMipMap);
    }

    private final ColorSpace $$robo$$android_graphics_Bitmap$getColorSpace() {
        if (this.getConfig() == Config.RGBA_F16) {
            this.mColorSpace = null;
            return ColorSpace.get(ColorSpace.Named.LINEAR_EXTENDED_SRGB);
        }
        if (this.mColorSpace == null) {
            if (Bitmap.nativeIsSRGB(this.mNativePtr)) {
                this.mColorSpace = ColorSpace.get(ColorSpace.Named.SRGB);
            } else {
                float[] xyz = new float[9];
                float[] params = new float[7];
                boolean hasColorSpace = Bitmap.nativeGetColorSpace(this.mNativePtr, xyz, params);
                if (hasColorSpace) {
                    ColorSpace.Rgb.TransferParameters parameters = new ColorSpace.Rgb.TransferParameters(params[0], params[1], params[2], params[3], params[4], params[5], params[6]);
                    ColorSpace cs = ColorSpace.match(xyz, parameters);
                    this.mColorSpace = cs != null ? cs : new ColorSpace.Rgb("Unknown", xyz, parameters);
                }
            }
        }
        return this.mColorSpace;
    }

    private final void $$robo$$android_graphics_Bitmap$eraseColor(int c) {
        this.checkRecycled("Can't erase a recycled bitmap");
        if (!this.isMutable()) {
            throw new IllegalStateException("cannot erase immutable bitmaps");
        }
        Bitmap.nativeErase(this.mNativePtr, c);
    }

    private final int $$robo$$android_graphics_Bitmap$getPixel(int x, int y) {
        this.checkRecycled("Can't call getPixel() on a recycled bitmap");
        this.checkHardware("unable to getPixel(), pixel access is not supported on Config#HARDWARE bitmaps");
        this.checkPixelAccess(x, y);
        return Bitmap.nativeGetPixel(this.mNativePtr, x, y);
    }

    private final void $$robo$$android_graphics_Bitmap$getPixels(int[] pixels, int offset, int stride, int x, int y, int width, int height) {
        this.checkRecycled("Can't call getPixels() on a recycled bitmap");
        this.checkHardware("unable to getPixels(), pixel access is not supported on Config#HARDWARE bitmaps");
        if (width == 0 || height == 0) {
            return;
        }
        this.checkPixelsAccess(x, y, width, height, offset, stride, pixels);
        Bitmap.nativeGetPixels(this.mNativePtr, pixels, offset, stride, x, y, width, height);
    }

    private final void $$robo$$android_graphics_Bitmap$checkPixelAccess(int x, int y) {
        Bitmap.checkXYSign(x, y);
        if (x >= this.getWidth()) {
            throw new IllegalArgumentException("x must be < bitmap.width()");
        }
        if (y >= this.getHeight()) {
            throw new IllegalArgumentException("y must be < bitmap.height()");
        }
    }

    private final void $$robo$$android_graphics_Bitmap$checkPixelsAccess(int x, int y, int width, int height, int offset, int stride, int[] pixels) {
        Bitmap.checkXYSign(x, y);
        if (width < 0) {
            throw new IllegalArgumentException("width must be >= 0");
        }
        if (height < 0) {
            throw new IllegalArgumentException("height must be >= 0");
        }
        if (x + width > this.getWidth()) {
            throw new IllegalArgumentException("x + width must be <= bitmap.width()");
        }
        if (y + height > this.getHeight()) {
            throw new IllegalArgumentException("y + height must be <= bitmap.height()");
        }
        if (Math.abs(stride) < width) {
            throw new IllegalArgumentException("abs(stride) must be >= width");
        }
        int lastScanline = offset + (height - 1) * stride;
        int length = pixels.length;
        if (offset < 0 || offset + width > length || lastScanline < 0 || lastScanline + width > length) {
            throw new ArrayIndexOutOfBoundsException();
        }
    }

    private final void $$robo$$android_graphics_Bitmap$setPixel(int x, int y, int color2) {
        this.checkRecycled("Can't call setPixel() on a recycled bitmap");
        if (!this.isMutable()) {
            throw new IllegalStateException();
        }
        this.checkPixelAccess(x, y);
        Bitmap.nativeSetPixel(this.mNativePtr, x, y, color2);
    }

    private final void $$robo$$android_graphics_Bitmap$setPixels(int[] pixels, int offset, int stride, int x, int y, int width, int height) {
        this.checkRecycled("Can't call setPixels() on a recycled bitmap");
        if (!this.isMutable()) {
            throw new IllegalStateException();
        }
        if (width == 0 || height == 0) {
            return;
        }
        this.checkPixelsAccess(x, y, width, height, offset, stride, pixels);
        Bitmap.nativeSetPixels(this.mNativePtr, pixels, offset, stride, x, y, width, height);
    }

    private final int $$robo$$android_graphics_Bitmap$describeContents() {
        return 0;
    }

    private final void $$robo$$android_graphics_Bitmap$writeToParcel(Parcel p, int flags) {
        this.checkRecycled("Can't parcel a recycled bitmap");
        this.noteHardwareBitmapSlowCall();
        if (!Bitmap.nativeWriteToParcel(this.mNativePtr, this.mIsMutable, this.mDensity, p)) {
            throw new RuntimeException("native writeToParcel failed");
        }
    }

    private final Bitmap $$robo$$android_graphics_Bitmap$extractAlpha() {
        return this.extractAlpha(null, null);
    }

    private final Bitmap $$robo$$android_graphics_Bitmap$extractAlpha(Paint paint, int[] offsetXY) {
        this.checkRecycled("Can't extractAlpha on a recycled bitmap");
        long nativePaint = paint != null ? paint.getNativeInstance() : 0L;
        this.noteHardwareBitmapSlowCall();
        Bitmap bm = Bitmap.nativeExtractAlpha(this.mNativePtr, nativePaint, offsetXY);
        if (bm == null) {
            throw new RuntimeException("Failed to extractAlpha on Bitmap");
        }
        bm.mDensity = this.mDensity;
        return bm;
    }

    private final boolean $$robo$$android_graphics_Bitmap$sameAs(Bitmap other) {
        this.checkRecycled("Can't call sameAs on a recycled bitmap!");
        this.noteHardwareBitmapSlowCall();
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        other.noteHardwareBitmapSlowCall();
        if (other.isRecycled()) {
            throw new IllegalArgumentException("Can't compare to a recycled bitmap!");
        }
        return Bitmap.nativeSameAs(this.mNativePtr, other.mNativePtr);
    }

    private final void $$robo$$android_graphics_Bitmap$prepareToDraw() {
        this.checkRecycled("Can't prepareToDraw on a recycled bitmap!");
        Bitmap.nativePrepareToDraw(this.mNativePtr);
    }

    private final GraphicBuffer $$robo$$android_graphics_Bitmap$createGraphicBufferHandle() {
        return Bitmap.nativeCreateGraphicBufferHandle(this.mNativePtr);
    }

    private static final Bitmap $$robo$$android_graphics_Bitmap$nativeCreate(int[] nArray, int n, int n2, int n3, int n4, int n5, boolean bl, float[] fArray, ColorSpace.Rgb.TransferParameters transferParameters) {
        return null;
    }

    private static final Bitmap $$robo$$android_graphics_Bitmap$nativeCopy(long l, int n, boolean bl) {
        return null;
    }

    private static final Bitmap $$robo$$android_graphics_Bitmap$nativeCopyAshmem(long l) {
        return null;
    }

    private static final Bitmap $$robo$$android_graphics_Bitmap$nativeCopyAshmemConfig(long l, int n) {
        return null;
    }

    private static final long $$robo$$android_graphics_Bitmap$nativeGetNativeFinalizer() {
        return 0L;
    }

    private static final boolean $$robo$$android_graphics_Bitmap$nativeRecycle(long l) {
        return false;
    }

    private static final void $$robo$$android_graphics_Bitmap$nativeReconfigure(long l, int n, int n2, int n3, boolean bl) {
    }

    private static final boolean $$robo$$android_graphics_Bitmap$nativeCompress(long l, int n, int n2, OutputStream outputStream, byte[] byArray) {
        return false;
    }

    private static final void $$robo$$android_graphics_Bitmap$nativeErase(long l, int n) {
    }

    private static final int $$robo$$android_graphics_Bitmap$nativeRowBytes(long l) {
        return 0;
    }

    private static final int $$robo$$android_graphics_Bitmap$nativeConfig(long l) {
        return 0;
    }

    private static final int $$robo$$android_graphics_Bitmap$nativeGetPixel(long l, int n, int n2) {
        return 0;
    }

    private static final void $$robo$$android_graphics_Bitmap$nativeGetPixels(long l, int[] nArray, int n, int n2, int n3, int n4, int n5, int n6) {
    }

    private static final void $$robo$$android_graphics_Bitmap$nativeSetPixel(long l, int n, int n2, int n3) {
    }

    private static final void $$robo$$android_graphics_Bitmap$nativeSetPixels(long l, int[] nArray, int n, int n2, int n3, int n4, int n5, int n6) {
    }

    private static final void $$robo$$android_graphics_Bitmap$nativeCopyPixelsToBuffer(long l, Buffer buffer) {
    }

    private static final void $$robo$$android_graphics_Bitmap$nativeCopyPixelsFromBuffer(long l, Buffer buffer) {
    }

    private static final int $$robo$$android_graphics_Bitmap$nativeGenerationId(long l) {
        return 0;
    }

    private static final Bitmap $$robo$$android_graphics_Bitmap$nativeCreateFromParcel(Parcel parcel) {
        return null;
    }

    private static final boolean $$robo$$android_graphics_Bitmap$nativeWriteToParcel(long l, boolean bl, int n, Parcel parcel) {
        return false;
    }

    private static final Bitmap $$robo$$android_graphics_Bitmap$nativeExtractAlpha(long l, long l2, int[] nArray) {
        return null;
    }

    private static final boolean $$robo$$android_graphics_Bitmap$nativeHasAlpha(long l) {
        return false;
    }

    private static final boolean $$robo$$android_graphics_Bitmap$nativeIsPremultiplied(long l) {
        return false;
    }

    private static final void $$robo$$android_graphics_Bitmap$nativeSetPremultiplied(long l, boolean bl) {
    }

    private static final void $$robo$$android_graphics_Bitmap$nativeSetHasAlpha(long l, boolean bl, boolean bl2) {
    }

    private static final boolean $$robo$$android_graphics_Bitmap$nativeHasMipMap(long l) {
        return false;
    }

    private static final void $$robo$$android_graphics_Bitmap$nativeSetHasMipMap(long l, boolean bl) {
    }

    private static final boolean $$robo$$android_graphics_Bitmap$nativeSameAs(long l, long l2) {
        return false;
    }

    private static final void $$robo$$android_graphics_Bitmap$nativePrepareToDraw(long l) {
    }

    private static final int $$robo$$android_graphics_Bitmap$nativeGetAllocationByteCount(long l) {
        return 0;
    }

    private static final Bitmap $$robo$$android_graphics_Bitmap$nativeCopyPreserveInternalConfig(long l) {
        return null;
    }

    private static final Bitmap $$robo$$android_graphics_Bitmap$nativeCreateHardwareBitmap(GraphicBuffer graphicBuffer) {
        return null;
    }

    private static final GraphicBuffer $$robo$$android_graphics_Bitmap$nativeCreateGraphicBufferHandle(long l) {
        return null;
    }

    private static final boolean $$robo$$android_graphics_Bitmap$nativeGetColorSpace(long l, float[] fArray, float[] fArray2) {
        return false;
    }

    private static final boolean $$robo$$android_graphics_Bitmap$nativeIsSRGB(long l) {
        return false;
    }

    private static final void $$robo$$android_graphics_Bitmap$nativeCopyColorSpace(long l, long l2) {
    }

    static void __staticInitializer__() {
        sDefaultDensity = -1;
        CREATOR = new Parcelable.Creator<Bitmap>(){
            public /* synthetic */ Object __robo_data__;

            private void $$robo$$android_graphics_Bitmap_1$__constructor__() {
            }

            private final Bitmap $$robo$$android_graphics_Bitmap_1$createFromParcel(Parcel p) {
                Bitmap bm = Bitmap.nativeCreateFromParcel(p);
                if (bm == null) {
                    throw new RuntimeException("Failed to unparcel Bitmap");
                }
                return bm;
            }

            private final Bitmap[] $$robo$$android_graphics_Bitmap_1$newArray(int size) {
                return new Bitmap[size];
            }

            private void __constructor__() {
                this.$$robo$$android_graphics_Bitmap_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_Bitmap_1$__constructor__(), this);
            }

            @Override
            public Bitmap createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_graphics_Bitmap_1$createFromParcel(android.os.Parcel ), this, parcel);
            }

            public Bitmap[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_graphics_Bitmap_1$newArray(int ), this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    public static void setDefaultDensity(int n) {
        InvokeDynamicSupport.bootstrapStatic("setDefaultDensity", $$robo$$android_graphics_Bitmap$setDefaultDensity(int ), (int)n);
    }

    static int getDefaultDensity() {
        return (int)InvokeDynamicSupport.bootstrapStatic("getDefaultDensity", $$robo$$android_graphics_Bitmap$getDefaultDensity());
    }

    private void __constructor__(long l, int n, int n2, int n3, boolean bl, boolean bl2, byte[] byArray, NinePatch.InsetStruct insetStruct) {
        this.$$robo$$android_graphics_Bitmap$__constructor__(l, n, n2, n3, bl, bl2, byArray, insetStruct);
    }

    public Bitmap(long l, int n, int n2, int n3, boolean bl, boolean bl2, byte[] byArray, NinePatch.InsetStruct insetStruct) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_Bitmap$__constructor__(long int int int boolean boolean byte[] android.graphics.NinePatch$InsetStruct ), this, l, n, n2, n3, bl, bl2, byArray, insetStruct);
    }

    public long getNativeInstance() {
        return (long)InvokeDynamicSupport.bootstrap("getNativeInstance", $$robo$$android_graphics_Bitmap$getNativeInstance(), this);
    }

    void reinit(int n, int n2, boolean bl) {
        InvokeDynamicSupport.bootstrap("reinit", $$robo$$android_graphics_Bitmap$reinit(int int boolean ), this, n, n2, bl);
    }

    public int getDensity() {
        return (int)InvokeDynamicSupport.bootstrap("getDensity", $$robo$$android_graphics_Bitmap$getDensity(), this);
    }

    public void setDensity(int n) {
        InvokeDynamicSupport.bootstrap("setDensity", $$robo$$android_graphics_Bitmap$setDensity(int ), this, n);
    }

    public void reconfigure(int n, int n2, Config config) {
        InvokeDynamicSupport.bootstrap("reconfigure", $$robo$$android_graphics_Bitmap$reconfigure(int int android.graphics.Bitmap$Config ), this, n, n2, config);
    }

    public void setWidth(int n) {
        InvokeDynamicSupport.bootstrap("setWidth", $$robo$$android_graphics_Bitmap$setWidth(int ), this, n);
    }

    public void setHeight(int n) {
        InvokeDynamicSupport.bootstrap("setHeight", $$robo$$android_graphics_Bitmap$setHeight(int ), this, n);
    }

    public void setConfig(Config config) {
        InvokeDynamicSupport.bootstrap("setConfig", $$robo$$android_graphics_Bitmap$setConfig(android.graphics.Bitmap$Config ), this, config);
    }

    public void setNinePatchChunk(byte[] byArray) {
        InvokeDynamicSupport.bootstrap("setNinePatchChunk", $$robo$$android_graphics_Bitmap$setNinePatchChunk(byte[] ), this, byArray);
    }

    public void recycle() {
        InvokeDynamicSupport.bootstrap("recycle", $$robo$$android_graphics_Bitmap$recycle(), this);
    }

    public boolean isRecycled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isRecycled", $$robo$$android_graphics_Bitmap$isRecycled(), this);
    }

    public int getGenerationId() {
        return (int)InvokeDynamicSupport.bootstrap("getGenerationId", $$robo$$android_graphics_Bitmap$getGenerationId(), this);
    }

    private void checkRecycled(String string2) {
        InvokeDynamicSupport.bootstrap("checkRecycled", $$robo$$android_graphics_Bitmap$checkRecycled(java.lang.String ), this, string2);
    }

    private void checkHardware(String string2) {
        InvokeDynamicSupport.bootstrap("checkHardware", $$robo$$android_graphics_Bitmap$checkHardware(java.lang.String ), this, string2);
    }

    private static void checkXYSign(int n, int n2) {
        InvokeDynamicSupport.bootstrapStatic("checkXYSign", $$robo$$android_graphics_Bitmap$checkXYSign(int int ), (int)n, (int)n2);
    }

    private static void checkWidthHeight(int n, int n2) {
        InvokeDynamicSupport.bootstrapStatic("checkWidthHeight", $$robo$$android_graphics_Bitmap$checkWidthHeight(int int ), (int)n, (int)n2);
    }

    public void copyPixelsToBuffer(Buffer buffer) {
        InvokeDynamicSupport.bootstrap("copyPixelsToBuffer", $$robo$$android_graphics_Bitmap$copyPixelsToBuffer(java.nio.Buffer ), this, buffer);
    }

    public void copyPixelsFromBuffer(Buffer buffer) {
        InvokeDynamicSupport.bootstrap("copyPixelsFromBuffer", $$robo$$android_graphics_Bitmap$copyPixelsFromBuffer(java.nio.Buffer ), this, buffer);
    }

    private void noteHardwareBitmapSlowCall() {
        InvokeDynamicSupport.bootstrap("noteHardwareBitmapSlowCall", $$robo$$android_graphics_Bitmap$noteHardwareBitmapSlowCall(), this);
    }

    public Bitmap copy(Config config, boolean bl) {
        return InvokeDynamicSupport.bootstrap("copy", $$robo$$android_graphics_Bitmap$copy(android.graphics.Bitmap$Config boolean ), this, config, bl);
    }

    public Bitmap createAshmemBitmap() {
        return InvokeDynamicSupport.bootstrap("createAshmemBitmap", $$robo$$android_graphics_Bitmap$createAshmemBitmap(), this);
    }

    public Bitmap createAshmemBitmap(Config config) {
        return InvokeDynamicSupport.bootstrap("createAshmemBitmap", $$robo$$android_graphics_Bitmap$createAshmemBitmap(android.graphics.Bitmap$Config ), this, config);
    }

    public static Bitmap createHardwareBitmap(GraphicBuffer graphicBuffer) {
        return InvokeDynamicSupport.bootstrapStatic("createHardwareBitmap", $$robo$$android_graphics_Bitmap$createHardwareBitmap(android.graphics.GraphicBuffer ), (GraphicBuffer)graphicBuffer);
    }

    public static Bitmap createScaledBitmap(Bitmap bitmap, int n, int n2, boolean bl) {
        return InvokeDynamicSupport.bootstrapStatic("createScaledBitmap", $$robo$$android_graphics_Bitmap$createScaledBitmap(android.graphics.Bitmap int int boolean ), (Bitmap)bitmap, (int)n, (int)n2, (boolean)bl);
    }

    public static Bitmap createBitmap(Bitmap bitmap) {
        return InvokeDynamicSupport.bootstrapStatic("createBitmap", $$robo$$android_graphics_Bitmap$createBitmap(android.graphics.Bitmap ), (Bitmap)bitmap);
    }

    public static Bitmap createBitmap(Bitmap bitmap, int n, int n2, int n3, int n4) {
        return InvokeDynamicSupport.bootstrapStatic("createBitmap", $$robo$$android_graphics_Bitmap$createBitmap(android.graphics.Bitmap int int int int ), (Bitmap)bitmap, (int)n, (int)n2, (int)n3, (int)n4);
    }

    public static Bitmap createBitmap(Bitmap bitmap, int n, int n2, int n3, int n4, Matrix matrix, boolean bl) {
        return InvokeDynamicSupport.bootstrapStatic("createBitmap", $$robo$$android_graphics_Bitmap$createBitmap(android.graphics.Bitmap int int int int android.graphics.Matrix boolean ), (Bitmap)bitmap, (int)n, (int)n2, (int)n3, (int)n4, (Matrix)matrix, (boolean)bl);
    }

    public static Bitmap createBitmap(int n, int n2, Config config) {
        return InvokeDynamicSupport.bootstrapStatic("createBitmap", $$robo$$android_graphics_Bitmap$createBitmap(int int android.graphics.Bitmap$Config ), (int)n, (int)n2, (Config)config);
    }

    public static Bitmap createBitmap(DisplayMetrics displayMetrics, int n, int n2, Config config) {
        return InvokeDynamicSupport.bootstrapStatic("createBitmap", $$robo$$android_graphics_Bitmap$createBitmap(android.util.DisplayMetrics int int android.graphics.Bitmap$Config ), (DisplayMetrics)displayMetrics, (int)n, (int)n2, (Config)config);
    }

    public static Bitmap createBitmap(int n, int n2, Config config, boolean bl) {
        return InvokeDynamicSupport.bootstrapStatic("createBitmap", $$robo$$android_graphics_Bitmap$createBitmap(int int android.graphics.Bitmap$Config boolean ), (int)n, (int)n2, (Config)config, (boolean)bl);
    }

    public static Bitmap createBitmap(int n, int n2, Config config, boolean bl, ColorSpace colorSpace) {
        return InvokeDynamicSupport.bootstrapStatic("createBitmap", $$robo$$android_graphics_Bitmap$createBitmap(int int android.graphics.Bitmap$Config boolean android.graphics.ColorSpace ), (int)n, (int)n2, (Config)config, (boolean)bl, (ColorSpace)colorSpace);
    }

    public static Bitmap createBitmap(DisplayMetrics displayMetrics, int n, int n2, Config config, boolean bl) {
        return InvokeDynamicSupport.bootstrapStatic("createBitmap", $$robo$$android_graphics_Bitmap$createBitmap(android.util.DisplayMetrics int int android.graphics.Bitmap$Config boolean ), (DisplayMetrics)displayMetrics, (int)n, (int)n2, (Config)config, (boolean)bl);
    }

    public static Bitmap createBitmap(DisplayMetrics displayMetrics, int n, int n2, Config config, boolean bl, ColorSpace colorSpace) {
        return InvokeDynamicSupport.bootstrapStatic("createBitmap", $$robo$$android_graphics_Bitmap$createBitmap(android.util.DisplayMetrics int int android.graphics.Bitmap$Config boolean android.graphics.ColorSpace ), (DisplayMetrics)displayMetrics, (int)n, (int)n2, (Config)config, (boolean)bl, (ColorSpace)colorSpace);
    }

    public static Bitmap createBitmap(int[] nArray, int n, int n2, int n3, int n4, Config config) {
        return InvokeDynamicSupport.bootstrapStatic("createBitmap", $$robo$$android_graphics_Bitmap$createBitmap(int[] int int int int android.graphics.Bitmap$Config ), (int[])nArray, (int)n, (int)n2, (int)n3, (int)n4, (Config)config);
    }

    public static Bitmap createBitmap(DisplayMetrics displayMetrics, int[] nArray, int n, int n2, int n3, int n4, Config config) {
        return InvokeDynamicSupport.bootstrapStatic("createBitmap", $$robo$$android_graphics_Bitmap$createBitmap(android.util.DisplayMetrics int[] int int int int android.graphics.Bitmap$Config ), (DisplayMetrics)displayMetrics, (int[])nArray, (int)n, (int)n2, (int)n3, (int)n4, (Config)config);
    }

    public static Bitmap createBitmap(int[] nArray, int n, int n2, Config config) {
        return InvokeDynamicSupport.bootstrapStatic("createBitmap", $$robo$$android_graphics_Bitmap$createBitmap(int[] int int android.graphics.Bitmap$Config ), (int[])nArray, (int)n, (int)n2, (Config)config);
    }

    public static Bitmap createBitmap(DisplayMetrics displayMetrics, int[] nArray, int n, int n2, Config config) {
        return InvokeDynamicSupport.bootstrapStatic("createBitmap", $$robo$$android_graphics_Bitmap$createBitmap(android.util.DisplayMetrics int[] int int android.graphics.Bitmap$Config ), (DisplayMetrics)displayMetrics, (int[])nArray, (int)n, (int)n2, (Config)config);
    }

    public byte[] getNinePatchChunk() {
        return InvokeDynamicSupport.bootstrap("getNinePatchChunk", $$robo$$android_graphics_Bitmap$getNinePatchChunk(), this);
    }

    public void getOpticalInsets(Rect rect) {
        InvokeDynamicSupport.bootstrap("getOpticalInsets", $$robo$$android_graphics_Bitmap$getOpticalInsets(android.graphics.Rect ), this, rect);
    }

    public NinePatch.InsetStruct getNinePatchInsets() {
        return InvokeDynamicSupport.bootstrap("getNinePatchInsets", $$robo$$android_graphics_Bitmap$getNinePatchInsets(), this);
    }

    public boolean compress(CompressFormat compressFormat, int n, OutputStream outputStream) {
        return (boolean)InvokeDynamicSupport.bootstrap("compress", $$robo$$android_graphics_Bitmap$compress(android.graphics.Bitmap$CompressFormat int java.io.OutputStream ), this, compressFormat, n, outputStream);
    }

    public boolean isMutable() {
        return (boolean)InvokeDynamicSupport.bootstrap("isMutable", $$robo$$android_graphics_Bitmap$isMutable(), this);
    }

    public boolean isPremultiplied() {
        return (boolean)InvokeDynamicSupport.bootstrap("isPremultiplied", $$robo$$android_graphics_Bitmap$isPremultiplied(), this);
    }

    public void setPremultiplied(boolean bl) {
        InvokeDynamicSupport.bootstrap("setPremultiplied", $$robo$$android_graphics_Bitmap$setPremultiplied(boolean ), this, bl);
    }

    public int getWidth() {
        return (int)InvokeDynamicSupport.bootstrap("getWidth", $$robo$$android_graphics_Bitmap$getWidth(), this);
    }

    public int getHeight() {
        return (int)InvokeDynamicSupport.bootstrap("getHeight", $$robo$$android_graphics_Bitmap$getHeight(), this);
    }

    public int getScaledWidth(Canvas canvas) {
        return (int)InvokeDynamicSupport.bootstrap("getScaledWidth", $$robo$$android_graphics_Bitmap$getScaledWidth(android.graphics.Canvas ), this, canvas);
    }

    public int getScaledHeight(Canvas canvas) {
        return (int)InvokeDynamicSupport.bootstrap("getScaledHeight", $$robo$$android_graphics_Bitmap$getScaledHeight(android.graphics.Canvas ), this, canvas);
    }

    public int getScaledWidth(DisplayMetrics displayMetrics) {
        return (int)InvokeDynamicSupport.bootstrap("getScaledWidth", $$robo$$android_graphics_Bitmap$getScaledWidth(android.util.DisplayMetrics ), this, displayMetrics);
    }

    public int getScaledHeight(DisplayMetrics displayMetrics) {
        return (int)InvokeDynamicSupport.bootstrap("getScaledHeight", $$robo$$android_graphics_Bitmap$getScaledHeight(android.util.DisplayMetrics ), this, displayMetrics);
    }

    public int getScaledWidth(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getScaledWidth", $$robo$$android_graphics_Bitmap$getScaledWidth(int ), this, n);
    }

    public int getScaledHeight(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getScaledHeight", $$robo$$android_graphics_Bitmap$getScaledHeight(int ), this, n);
    }

    public static int scaleFromDensity(int n, int n2, int n3) {
        return (int)InvokeDynamicSupport.bootstrapStatic("scaleFromDensity", $$robo$$android_graphics_Bitmap$scaleFromDensity(int int int ), (int)n, (int)n2, (int)n3);
    }

    public int getRowBytes() {
        return (int)InvokeDynamicSupport.bootstrap("getRowBytes", $$robo$$android_graphics_Bitmap$getRowBytes(), this);
    }

    public int getByteCount() {
        return (int)InvokeDynamicSupport.bootstrap("getByteCount", $$robo$$android_graphics_Bitmap$getByteCount(), this);
    }

    public int getAllocationByteCount() {
        return (int)InvokeDynamicSupport.bootstrap("getAllocationByteCount", $$robo$$android_graphics_Bitmap$getAllocationByteCount(), this);
    }

    public Config getConfig() {
        return InvokeDynamicSupport.bootstrap("getConfig", $$robo$$android_graphics_Bitmap$getConfig(), this);
    }

    public boolean hasAlpha() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasAlpha", $$robo$$android_graphics_Bitmap$hasAlpha(), this);
    }

    public void setHasAlpha(boolean bl) {
        InvokeDynamicSupport.bootstrap("setHasAlpha", $$robo$$android_graphics_Bitmap$setHasAlpha(boolean ), this, bl);
    }

    public boolean hasMipMap() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasMipMap", $$robo$$android_graphics_Bitmap$hasMipMap(), this);
    }

    public void setHasMipMap(boolean bl) {
        InvokeDynamicSupport.bootstrap("setHasMipMap", $$robo$$android_graphics_Bitmap$setHasMipMap(boolean ), this, bl);
    }

    public ColorSpace getColorSpace() {
        return InvokeDynamicSupport.bootstrap("getColorSpace", $$robo$$android_graphics_Bitmap$getColorSpace(), this);
    }

    public void eraseColor(int n) {
        InvokeDynamicSupport.bootstrap("eraseColor", $$robo$$android_graphics_Bitmap$eraseColor(int ), this, n);
    }

    public int getPixel(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("getPixel", $$robo$$android_graphics_Bitmap$getPixel(int int ), this, n, n2);
    }

    public void getPixels(int[] nArray, int n, int n2, int n3, int n4, int n5, int n6) {
        InvokeDynamicSupport.bootstrap("getPixels", $$robo$$android_graphics_Bitmap$getPixels(int[] int int int int int int ), this, nArray, n, n2, n3, n4, n5, n6);
    }

    private void checkPixelAccess(int n, int n2) {
        InvokeDynamicSupport.bootstrap("checkPixelAccess", $$robo$$android_graphics_Bitmap$checkPixelAccess(int int ), this, n, n2);
    }

    private void checkPixelsAccess(int n, int n2, int n3, int n4, int n5, int n6, int[] nArray) {
        InvokeDynamicSupport.bootstrap("checkPixelsAccess", $$robo$$android_graphics_Bitmap$checkPixelsAccess(int int int int int int int[] ), this, n, n2, n3, n4, n5, n6, nArray);
    }

    public void setPixel(int n, int n2, int n3) {
        InvokeDynamicSupport.bootstrap("setPixel", $$robo$$android_graphics_Bitmap$setPixel(int int int ), this, n, n2, n3);
    }

    public void setPixels(int[] nArray, int n, int n2, int n3, int n4, int n5, int n6) {
        InvokeDynamicSupport.bootstrap("setPixels", $$robo$$android_graphics_Bitmap$setPixels(int[] int int int int int int ), this, nArray, n, n2, n3, n4, n5, n6);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_graphics_Bitmap$describeContents(), this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_graphics_Bitmap$writeToParcel(android.os.Parcel int ), this, parcel, n);
    }

    public Bitmap extractAlpha() {
        return InvokeDynamicSupport.bootstrap("extractAlpha", $$robo$$android_graphics_Bitmap$extractAlpha(), this);
    }

    public Bitmap extractAlpha(Paint paint, int[] nArray) {
        return InvokeDynamicSupport.bootstrap("extractAlpha", $$robo$$android_graphics_Bitmap$extractAlpha(android.graphics.Paint int[] ), this, paint, nArray);
    }

    public boolean sameAs(Bitmap bitmap) {
        return (boolean)InvokeDynamicSupport.bootstrap("sameAs", $$robo$$android_graphics_Bitmap$sameAs(android.graphics.Bitmap ), this, bitmap);
    }

    public void prepareToDraw() {
        InvokeDynamicSupport.bootstrap("prepareToDraw", $$robo$$android_graphics_Bitmap$prepareToDraw(), this);
    }

    public GraphicBuffer createGraphicBufferHandle() {
        return InvokeDynamicSupport.bootstrap("createGraphicBufferHandle", $$robo$$android_graphics_Bitmap$createGraphicBufferHandle(), this);
    }

    private static Bitmap nativeCreate(int[] nArray, int n, int n2, int n3, int n4, int n5, boolean bl, float[] fArray, ColorSpace.Rgb.TransferParameters transferParameters) {
        return InvokeDynamicSupport.bootstrapStatic("nativeCreate", $$robo$$android_graphics_Bitmap$nativeCreate(int[] int int int int int boolean float[] android.graphics.ColorSpace$Rgb$TransferParameters ), (int[])nArray, (int)n, (int)n2, (int)n3, (int)n4, (int)n5, (boolean)bl, (float[])fArray, (ColorSpace.Rgb.TransferParameters)transferParameters);
    }

    private static Bitmap nativeCopy(long l, int n, boolean bl) {
        return InvokeDynamicSupport.bootstrapStatic("nativeCopy", $$robo$$android_graphics_Bitmap$nativeCopy(long int boolean ), (long)l, (int)n, (boolean)bl);
    }

    private static Bitmap nativeCopyAshmem(long l) {
        return InvokeDynamicSupport.bootstrapStatic("nativeCopyAshmem", $$robo$$android_graphics_Bitmap$nativeCopyAshmem(long ), (long)l);
    }

    private static Bitmap nativeCopyAshmemConfig(long l, int n) {
        return InvokeDynamicSupport.bootstrapStatic("nativeCopyAshmemConfig", $$robo$$android_graphics_Bitmap$nativeCopyAshmemConfig(long int ), (long)l, (int)n);
    }

    private static long nativeGetNativeFinalizer() {
        return (long)InvokeDynamicSupport.bootstrapStatic("nativeGetNativeFinalizer", $$robo$$android_graphics_Bitmap$nativeGetNativeFinalizer());
    }

    private static boolean nativeRecycle(long l) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("nativeRecycle", $$robo$$android_graphics_Bitmap$nativeRecycle(long ), (long)l);
    }

    private static void nativeReconfigure(long l, int n, int n2, int n3, boolean bl) {
        InvokeDynamicSupport.bootstrapStatic("nativeReconfigure", $$robo$$android_graphics_Bitmap$nativeReconfigure(long int int int boolean ), (long)l, (int)n, (int)n2, (int)n3, (boolean)bl);
    }

    private static boolean nativeCompress(long l, int n, int n2, OutputStream outputStream, byte[] byArray) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("nativeCompress", $$robo$$android_graphics_Bitmap$nativeCompress(long int int java.io.OutputStream byte[] ), (long)l, (int)n, (int)n2, (OutputStream)outputStream, (byte[])byArray);
    }

    private static void nativeErase(long l, int n) {
        InvokeDynamicSupport.bootstrapStatic("nativeErase", $$robo$$android_graphics_Bitmap$nativeErase(long int ), (long)l, (int)n);
    }

    private static int nativeRowBytes(long l) {
        return (int)InvokeDynamicSupport.bootstrapStatic("nativeRowBytes", $$robo$$android_graphics_Bitmap$nativeRowBytes(long ), (long)l);
    }

    private static int nativeConfig(long l) {
        return (int)InvokeDynamicSupport.bootstrapStatic("nativeConfig", $$robo$$android_graphics_Bitmap$nativeConfig(long ), (long)l);
    }

    private static int nativeGetPixel(long l, int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("nativeGetPixel", $$robo$$android_graphics_Bitmap$nativeGetPixel(long int int ), (long)l, (int)n, (int)n2);
    }

    private static void nativeGetPixels(long l, int[] nArray, int n, int n2, int n3, int n4, int n5, int n6) {
        InvokeDynamicSupport.bootstrapStatic("nativeGetPixels", $$robo$$android_graphics_Bitmap$nativeGetPixels(long int[] int int int int int int ), (long)l, (int[])nArray, (int)n, (int)n2, (int)n3, (int)n4, (int)n5, (int)n6);
    }

    private static void nativeSetPixel(long l, int n, int n2, int n3) {
        InvokeDynamicSupport.bootstrapStatic("nativeSetPixel", $$robo$$android_graphics_Bitmap$nativeSetPixel(long int int int ), (long)l, (int)n, (int)n2, (int)n3);
    }

    private static void nativeSetPixels(long l, int[] nArray, int n, int n2, int n3, int n4, int n5, int n6) {
        InvokeDynamicSupport.bootstrapStatic("nativeSetPixels", $$robo$$android_graphics_Bitmap$nativeSetPixels(long int[] int int int int int int ), (long)l, (int[])nArray, (int)n, (int)n2, (int)n3, (int)n4, (int)n5, (int)n6);
    }

    private static void nativeCopyPixelsToBuffer(long l, Buffer buffer) {
        InvokeDynamicSupport.bootstrapStatic("nativeCopyPixelsToBuffer", $$robo$$android_graphics_Bitmap$nativeCopyPixelsToBuffer(long java.nio.Buffer ), (long)l, (Buffer)buffer);
    }

    private static void nativeCopyPixelsFromBuffer(long l, Buffer buffer) {
        InvokeDynamicSupport.bootstrapStatic("nativeCopyPixelsFromBuffer", $$robo$$android_graphics_Bitmap$nativeCopyPixelsFromBuffer(long java.nio.Buffer ), (long)l, (Buffer)buffer);
    }

    private static int nativeGenerationId(long l) {
        return (int)InvokeDynamicSupport.bootstrapStatic("nativeGenerationId", $$robo$$android_graphics_Bitmap$nativeGenerationId(long ), (long)l);
    }

    private static Bitmap nativeCreateFromParcel(Parcel parcel) {
        return InvokeDynamicSupport.bootstrapStatic("nativeCreateFromParcel", $$robo$$android_graphics_Bitmap$nativeCreateFromParcel(android.os.Parcel ), (Parcel)parcel);
    }

    private static boolean nativeWriteToParcel(long l, boolean bl, int n, Parcel parcel) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("nativeWriteToParcel", $$robo$$android_graphics_Bitmap$nativeWriteToParcel(long boolean int android.os.Parcel ), (long)l, (boolean)bl, (int)n, (Parcel)parcel);
    }

    private static Bitmap nativeExtractAlpha(long l, long l2, int[] nArray) {
        return InvokeDynamicSupport.bootstrapStatic("nativeExtractAlpha", $$robo$$android_graphics_Bitmap$nativeExtractAlpha(long long int[] ), (long)l, (long)l2, (int[])nArray);
    }

    private static boolean nativeHasAlpha(long l) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("nativeHasAlpha", $$robo$$android_graphics_Bitmap$nativeHasAlpha(long ), (long)l);
    }

    private static boolean nativeIsPremultiplied(long l) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("nativeIsPremultiplied", $$robo$$android_graphics_Bitmap$nativeIsPremultiplied(long ), (long)l);
    }

    private static void nativeSetPremultiplied(long l, boolean bl) {
        InvokeDynamicSupport.bootstrapStatic("nativeSetPremultiplied", $$robo$$android_graphics_Bitmap$nativeSetPremultiplied(long boolean ), (long)l, (boolean)bl);
    }

    private static void nativeSetHasAlpha(long l, boolean bl, boolean bl2) {
        InvokeDynamicSupport.bootstrapStatic("nativeSetHasAlpha", $$robo$$android_graphics_Bitmap$nativeSetHasAlpha(long boolean boolean ), (long)l, (boolean)bl, (boolean)bl2);
    }

    private static boolean nativeHasMipMap(long l) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("nativeHasMipMap", $$robo$$android_graphics_Bitmap$nativeHasMipMap(long ), (long)l);
    }

    private static void nativeSetHasMipMap(long l, boolean bl) {
        InvokeDynamicSupport.bootstrapStatic("nativeSetHasMipMap", $$robo$$android_graphics_Bitmap$nativeSetHasMipMap(long boolean ), (long)l, (boolean)bl);
    }

    private static boolean nativeSameAs(long l, long l2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("nativeSameAs", $$robo$$android_graphics_Bitmap$nativeSameAs(long long ), (long)l, (long)l2);
    }

    private static void nativePrepareToDraw(long l) {
        InvokeDynamicSupport.bootstrapStatic("nativePrepareToDraw", $$robo$$android_graphics_Bitmap$nativePrepareToDraw(long ), (long)l);
    }

    private static int nativeGetAllocationByteCount(long l) {
        return (int)InvokeDynamicSupport.bootstrapStatic("nativeGetAllocationByteCount", $$robo$$android_graphics_Bitmap$nativeGetAllocationByteCount(long ), (long)l);
    }

    private static Bitmap nativeCopyPreserveInternalConfig(long l) {
        return InvokeDynamicSupport.bootstrapStatic("nativeCopyPreserveInternalConfig", $$robo$$android_graphics_Bitmap$nativeCopyPreserveInternalConfig(long ), (long)l);
    }

    private static Bitmap nativeCreateHardwareBitmap(GraphicBuffer graphicBuffer) {
        return InvokeDynamicSupport.bootstrapStatic("nativeCreateHardwareBitmap", $$robo$$android_graphics_Bitmap$nativeCreateHardwareBitmap(android.graphics.GraphicBuffer ), (GraphicBuffer)graphicBuffer);
    }

    private static GraphicBuffer nativeCreateGraphicBufferHandle(long l) {
        return InvokeDynamicSupport.bootstrapStatic("nativeCreateGraphicBufferHandle", $$robo$$android_graphics_Bitmap$nativeCreateGraphicBufferHandle(long ), (long)l);
    }

    private static boolean nativeGetColorSpace(long l, float[] fArray, float[] fArray2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("nativeGetColorSpace", $$robo$$android_graphics_Bitmap$nativeGetColorSpace(long float[] float[] ), (long)l, (float[])fArray, (float[])fArray2);
    }

    private static boolean nativeIsSRGB(long l) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("nativeIsSRGB", $$robo$$android_graphics_Bitmap$nativeIsSRGB(long ), (long)l);
    }

    private static void nativeCopyColorSpace(long l, long l2) {
        InvokeDynamicSupport.bootstrapStatic("nativeCopyColorSpace", $$robo$$android_graphics_Bitmap$nativeCopyColorSpace(long long ), (long)l, (long)l2);
    }

    static {
        RobolectricInternals.classInitializing(Bitmap.class);
    }

    public /* synthetic */ Bitmap() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Bitmap)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class CompressFormat
    extends Enum<CompressFormat> {
        public /* synthetic */ Object __robo_data__;
        public static /* enum */ CompressFormat JPEG;
        public static /* enum */ CompressFormat PNG;
        public static /* enum */ CompressFormat WEBP;
        int nativeInt;
        private static /* synthetic */ CompressFormat[] $VALUES;

        private static final CompressFormat[] $$robo$$android_graphics_Bitmap_CompressFormat$values() {
            return (CompressFormat[])$VALUES.clone();
        }

        private static final CompressFormat $$robo$$android_graphics_Bitmap_CompressFormat$valueOf(String name) {
            return Enum.valueOf(CompressFormat.class, name);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void $$robo$$android_graphics_Bitmap_CompressFormat$__constructor__(String string2, int n, int nativeInt) {
            this.nativeInt = nativeInt;
        }

        static void __staticInitializer__() {
            JPEG = new CompressFormat(0);
            PNG = new CompressFormat(1);
            WEBP = new CompressFormat(2);
            $VALUES = new CompressFormat[]{JPEG, PNG, WEBP};
        }

        public static CompressFormat[] values() {
            return InvokeDynamicSupport.bootstrapStatic("values", $$robo$$android_graphics_Bitmap_CompressFormat$values());
        }

        public static CompressFormat valueOf(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("valueOf", $$robo$$android_graphics_Bitmap_CompressFormat$valueOf(java.lang.String ), (String)string2);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void __constructor__(String string2, int n, int n2) {
            this.$$robo$$android_graphics_Bitmap_CompressFormat$__constructor__(string2, n, n2);
        }

        public CompressFormat(int n2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_Bitmap_CompressFormat$__constructor__(java.lang.String int int ), this, string2, n, n2);
        }

        static {
            RobolectricInternals.classInitializing(CompressFormat.class);
        }

        public /* synthetic */ CompressFormat() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CompressFormat)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class Config
    extends Enum<Config> {
        public /* synthetic */ Object __robo_data__;
        public static /* enum */ Config ALPHA_8;
        public static /* enum */ Config RGB_565;
        @Deprecated
        public static /* enum */ Config ARGB_4444;
        public static /* enum */ Config ARGB_8888;
        public static /* enum */ Config RGBA_F16;
        public static /* enum */ Config HARDWARE;
        int nativeInt;
        private static Config[] sConfigs;
        private static /* synthetic */ Config[] $VALUES;

        private static final Config[] $$robo$$android_graphics_Bitmap_Config$values() {
            return (Config[])$VALUES.clone();
        }

        private static final Config $$robo$$android_graphics_Bitmap_Config$valueOf(String name) {
            return Enum.valueOf(Config.class, name);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void $$robo$$android_graphics_Bitmap_Config$__constructor__(String string2, int n, int ni) {
            this.nativeInt = ni;
        }

        private static final Config $$robo$$android_graphics_Bitmap_Config$nativeToConfig(int ni) {
            return sConfigs[ni];
        }

        static void __staticInitializer__() {
            ALPHA_8 = new Config(1);
            RGB_565 = new Config(3);
            ARGB_4444 = new Config(4);
            ARGB_8888 = new Config(5);
            RGBA_F16 = new Config(6);
            HARDWARE = new Config(7);
            $VALUES = new Config[]{ALPHA_8, RGB_565, ARGB_4444, ARGB_8888, RGBA_F16, HARDWARE};
            sConfigs = new Config[]{null, ALPHA_8, null, RGB_565, ARGB_4444, ARGB_8888, RGBA_F16, HARDWARE};
        }

        public static Config[] values() {
            return InvokeDynamicSupport.bootstrapStatic("values", $$robo$$android_graphics_Bitmap_Config$values());
        }

        public static Config valueOf(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("valueOf", $$robo$$android_graphics_Bitmap_Config$valueOf(java.lang.String ), (String)string2);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void __constructor__(String string2, int n, int n2) {
            this.$$robo$$android_graphics_Bitmap_Config$__constructor__(string2, n, n2);
        }

        public Config(int n2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_Bitmap_Config$__constructor__(java.lang.String int int ), this, string2, n, n2);
        }

        static Config nativeToConfig(int n) {
            return InvokeDynamicSupport.bootstrapStatic("nativeToConfig", $$robo$$android_graphics_Bitmap_Config$nativeToConfig(int ), (int)n);
        }

        static {
            RobolectricInternals.classInitializing(Config.class);
        }

        public /* synthetic */ Config() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Config)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

