/*
 * Decompiled with CFR 0.152.
 */
package android.filterpacks.ui;

import android.filterfw.core.Filter;
import android.filterfw.core.FilterContext;
import android.filterfw.core.Frame;
import android.filterfw.core.GLEnvironment;
import android.filterfw.core.GLFrame;
import android.filterfw.core.GenerateFieldPort;
import android.filterfw.core.GenerateFinalPort;
import android.filterfw.core.MutableFrameFormat;
import android.filterfw.core.ShaderProgram;
import android.filterfw.format.ImageFormat;
import android.util.Log;
import android.view.Surface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class SurfaceTargetFilter
extends Filter
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private int RENDERMODE_STRETCH = 0;
    private int RENDERMODE_FIT = 1;
    private int RENDERMODE_FILL_CROP = 2;
    @GenerateFinalPort(name="surface")
    private Surface mSurface;
    @GenerateFieldPort(name="owidth")
    private int mScreenWidth;
    @GenerateFieldPort(name="oheight")
    private int mScreenHeight;
    @GenerateFieldPort(name="renderMode", hasDefault=true)
    private String mRenderModeString;
    private ShaderProgram mProgram;
    private GLEnvironment mGlEnv;
    private GLFrame mScreen;
    private int mRenderMode;
    private float mAspectRatio;
    private int mSurfaceId;
    private boolean mLogVerbose;
    private static String TAG = "SurfaceRenderFilter";

    private void $$robo$$android_filterpacks_ui_SurfaceTargetFilter$__constructor__(String name) {
        this.RENDERMODE_STRETCH = 0;
        this.RENDERMODE_FIT = 1;
        this.RENDERMODE_FILL_CROP = 2;
        this.mRenderMode = 1;
        this.mAspectRatio = 1.0f;
        this.mSurfaceId = -1;
        this.mLogVerbose = Log.isLoggable("SurfaceRenderFilter", 2);
    }

    private final void $$robo$$android_filterpacks_ui_SurfaceTargetFilter$setupPorts() {
        if (this.mSurface == null) {
            throw new RuntimeException("NULL Surface passed to SurfaceTargetFilter");
        }
        this.addMaskedInputPort("frame", ImageFormat.create(3));
    }

    private final void $$robo$$android_filterpacks_ui_SurfaceTargetFilter$updateRenderMode() {
        if (this.mRenderModeString != null) {
            if (this.mRenderModeString.equals("stretch")) {
                this.mRenderMode = 0;
            } else if (this.mRenderModeString.equals("fit")) {
                this.mRenderMode = 1;
            } else if (this.mRenderModeString.equals("fill_crop")) {
                this.mRenderMode = 2;
            } else {
                throw new RuntimeException("Unknown render mode '" + this.mRenderModeString + "'!");
            }
        }
        this.updateTargetRect();
    }

    private final void $$robo$$android_filterpacks_ui_SurfaceTargetFilter$prepare(FilterContext context) {
        this.mGlEnv = context.getGLEnvironment();
        this.mProgram = ShaderProgram.createIdentity(context);
        this.mProgram.setSourceRect(0.0f, 1.0f, 1.0f, -1.0f);
        this.mProgram.setClearsOutput(true);
        this.mProgram.setClearColor(0.0f, 0.0f, 0.0f);
        MutableFrameFormat screenFormat = ImageFormat.create(this.mScreenWidth, this.mScreenHeight, 3, 3);
        this.mScreen = (GLFrame)context.getFrameManager().newBoundFrame(screenFormat, 101, 0L);
        this.updateRenderMode();
    }

    private final void $$robo$$android_filterpacks_ui_SurfaceTargetFilter$open(FilterContext context) {
        this.registerSurface();
    }

    private final void $$robo$$android_filterpacks_ui_SurfaceTargetFilter$process(FilterContext context) {
        int target;
        if (this.mLogVerbose) {
            Log.v("SurfaceRenderFilter", "Starting frame processing");
        }
        Frame input = this.pullInput("frame");
        boolean createdFrame = false;
        float currentAspectRatio = (float)input.getFormat().getWidth() / (float)input.getFormat().getHeight();
        if (currentAspectRatio != this.mAspectRatio) {
            if (this.mLogVerbose) {
                Log.v("SurfaceRenderFilter", "New aspect ratio: " + currentAspectRatio + ", previously: " + this.mAspectRatio);
            }
            this.mAspectRatio = currentAspectRatio;
            this.updateTargetRect();
        }
        Frame gpuFrame = null;
        if (this.mLogVerbose) {
            Log.v("SurfaceRenderFilter", "Got input format: " + input.getFormat());
        }
        if ((target = input.getFormat().getTarget()) != 3) {
            gpuFrame = context.getFrameManager().duplicateFrameToTarget(input, 3);
            createdFrame = true;
        } else {
            gpuFrame = input;
        }
        this.mGlEnv.activateSurfaceWithId(this.mSurfaceId);
        this.mProgram.process(gpuFrame, (Frame)this.mScreen);
        this.mGlEnv.swapBuffers();
        if (createdFrame) {
            gpuFrame.release();
        }
    }

    private final void $$robo$$android_filterpacks_ui_SurfaceTargetFilter$fieldPortValueUpdated(String name, FilterContext context) {
        this.mScreen.setViewport(0, 0, this.mScreenWidth, this.mScreenHeight);
        this.updateTargetRect();
    }

    private final void $$robo$$android_filterpacks_ui_SurfaceTargetFilter$close(FilterContext context) {
        this.unregisterSurface();
    }

    private final void $$robo$$android_filterpacks_ui_SurfaceTargetFilter$tearDown(FilterContext context) {
        if (this.mScreen != null) {
            this.mScreen.release();
        }
    }

    private final void $$robo$$android_filterpacks_ui_SurfaceTargetFilter$updateTargetRect() {
        if (this.mScreenWidth > 0 && this.mScreenHeight > 0 && this.mProgram != null) {
            float screenAspectRatio = (float)this.mScreenWidth / (float)this.mScreenHeight;
            float relativeAspectRatio = screenAspectRatio / this.mAspectRatio;
            switch (this.mRenderMode) {
                case 0: {
                    this.mProgram.setTargetRect(0.0f, 0.0f, 1.0f, 1.0f);
                    break;
                }
                case 1: {
                    if (relativeAspectRatio > 1.0f) {
                        this.mProgram.setTargetRect(0.5f - 0.5f / relativeAspectRatio, 0.0f, 1.0f / relativeAspectRatio, 1.0f);
                        break;
                    }
                    this.mProgram.setTargetRect(0.0f, 0.5f - 0.5f * relativeAspectRatio, 1.0f, relativeAspectRatio);
                    break;
                }
                case 2: {
                    if (relativeAspectRatio > 1.0f) {
                        this.mProgram.setTargetRect(0.0f, 0.5f - 0.5f * relativeAspectRatio, 1.0f, relativeAspectRatio);
                        break;
                    }
                    this.mProgram.setTargetRect(0.5f - 0.5f / relativeAspectRatio, 0.0f, 1.0f / relativeAspectRatio, 1.0f);
                }
            }
        }
    }

    private final void $$robo$$android_filterpacks_ui_SurfaceTargetFilter$registerSurface() {
        this.mSurfaceId = this.mGlEnv.registerSurface(this.mSurface);
        if (this.mSurfaceId < 0) {
            throw new RuntimeException("Could not register Surface: " + this.mSurface);
        }
    }

    private final void $$robo$$android_filterpacks_ui_SurfaceTargetFilter$unregisterSurface() {
        if (this.mSurfaceId > 0) {
            this.mGlEnv.unregisterSurfaceId(this.mSurfaceId);
        }
    }

    private void __constructor__(String string2) {
        this.$$robo$$android_filterpacks_ui_SurfaceTargetFilter$__constructor__(string2);
    }

    public SurfaceTargetFilter(String string2) {
        super(string2);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_filterpacks_ui_SurfaceTargetFilter$__constructor__(java.lang.String ), this, string2);
    }

    @Override
    public void setupPorts() {
        InvokeDynamicSupport.bootstrap("setupPorts", $$robo$$android_filterpacks_ui_SurfaceTargetFilter$setupPorts(), this);
    }

    public void updateRenderMode() {
        InvokeDynamicSupport.bootstrap("updateRenderMode", $$robo$$android_filterpacks_ui_SurfaceTargetFilter$updateRenderMode(), this);
    }

    @Override
    public void prepare(FilterContext filterContext) {
        InvokeDynamicSupport.bootstrap("prepare", $$robo$$android_filterpacks_ui_SurfaceTargetFilter$prepare(android.filterfw.core.FilterContext ), this, filterContext);
    }

    @Override
    public void open(FilterContext filterContext) {
        InvokeDynamicSupport.bootstrap("open", $$robo$$android_filterpacks_ui_SurfaceTargetFilter$open(android.filterfw.core.FilterContext ), this, filterContext);
    }

    @Override
    public void process(FilterContext filterContext) {
        InvokeDynamicSupport.bootstrap("process", $$robo$$android_filterpacks_ui_SurfaceTargetFilter$process(android.filterfw.core.FilterContext ), this, filterContext);
    }

    @Override
    public void fieldPortValueUpdated(String string2, FilterContext filterContext) {
        InvokeDynamicSupport.bootstrap("fieldPortValueUpdated", $$robo$$android_filterpacks_ui_SurfaceTargetFilter$fieldPortValueUpdated(java.lang.String android.filterfw.core.FilterContext ), this, string2, filterContext);
    }

    @Override
    public void close(FilterContext filterContext) {
        InvokeDynamicSupport.bootstrap("close", $$robo$$android_filterpacks_ui_SurfaceTargetFilter$close(android.filterfw.core.FilterContext ), this, filterContext);
    }

    @Override
    public void tearDown(FilterContext filterContext) {
        InvokeDynamicSupport.bootstrap("tearDown", $$robo$$android_filterpacks_ui_SurfaceTargetFilter$tearDown(android.filterfw.core.FilterContext ), this, filterContext);
    }

    private void updateTargetRect() {
        InvokeDynamicSupport.bootstrap("updateTargetRect", $$robo$$android_filterpacks_ui_SurfaceTargetFilter$updateTargetRect(), this);
    }

    private void registerSurface() {
        InvokeDynamicSupport.bootstrap("registerSurface", $$robo$$android_filterpacks_ui_SurfaceTargetFilter$registerSurface(), this);
    }

    private void unregisterSurface() {
        InvokeDynamicSupport.bootstrap("unregisterSurface", $$robo$$android_filterpacks_ui_SurfaceTargetFilter$unregisterSurface(), this);
    }

    public /* synthetic */ SurfaceTargetFilter() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SurfaceTargetFilter)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

