/*
 * Decompiled with CFR 0.152.
 */
package android.filterfw.core;

import android.filterfw.core.KeyValueMap;
import android.filterfw.core.MutableFrameFormat;
import java.util.Arrays;
import java.util.Map;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class FrameFormat
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    public static int TYPE_UNSPECIFIED = 0;
    public static int TYPE_BIT = 1;
    public static int TYPE_BYTE = 2;
    public static int TYPE_INT16 = 3;
    public static int TYPE_INT32 = 4;
    public static int TYPE_FLOAT = 5;
    public static int TYPE_DOUBLE = 6;
    public static int TYPE_POINTER = 7;
    public static int TYPE_OBJECT = 8;
    public static int TARGET_UNSPECIFIED = 0;
    public static int TARGET_SIMPLE = 1;
    public static int TARGET_NATIVE = 2;
    public static int TARGET_GPU = 3;
    public static int TARGET_VERTEXBUFFER = 4;
    public static int TARGET_RS = 5;
    public static int SIZE_UNSPECIFIED = 0;
    public static int BYTES_PER_SAMPLE_UNSPECIFIED = 1;
    protected static int SIZE_UNKNOWN = -1;
    protected int mBaseType;
    protected int mBytesPerSample;
    protected int mSize;
    protected int mTarget;
    protected int[] mDimensions;
    protected KeyValueMap mMetaData;
    protected Class mObjectClass;

    private void $$robo$$android_filterfw_core_FrameFormat$__constructor__() {
        this.mBaseType = 0;
        this.mBytesPerSample = 1;
        this.mSize = -1;
        this.mTarget = 0;
    }

    private void $$robo$$android_filterfw_core_FrameFormat$__constructor__(int baseType, int target) {
        this.mBaseType = 0;
        this.mBytesPerSample = 1;
        this.mSize = -1;
        this.mTarget = 0;
        this.mBaseType = baseType;
        this.mTarget = target;
        this.initDefaults();
    }

    private static final FrameFormat $$robo$$android_filterfw_core_FrameFormat$unspecified() {
        return new FrameFormat(0, 0);
    }

    private final int $$robo$$android_filterfw_core_FrameFormat$getBaseType() {
        return this.mBaseType;
    }

    private final boolean $$robo$$android_filterfw_core_FrameFormat$isBinaryDataType() {
        return this.mBaseType >= 1 && this.mBaseType <= 6;
    }

    private final int $$robo$$android_filterfw_core_FrameFormat$getBytesPerSample() {
        return this.mBytesPerSample;
    }

    private final int $$robo$$android_filterfw_core_FrameFormat$getValuesPerSample() {
        return this.mBytesPerSample / FrameFormat.bytesPerSampleOf(this.mBaseType);
    }

    private final int $$robo$$android_filterfw_core_FrameFormat$getTarget() {
        return this.mTarget;
    }

    private final int[] $$robo$$android_filterfw_core_FrameFormat$getDimensions() {
        return this.mDimensions;
    }

    private final int $$robo$$android_filterfw_core_FrameFormat$getDimension(int i) {
        return this.mDimensions[i];
    }

    private final int $$robo$$android_filterfw_core_FrameFormat$getDimensionCount() {
        return this.mDimensions == null ? 0 : this.mDimensions.length;
    }

    private final boolean $$robo$$android_filterfw_core_FrameFormat$hasMetaKey(String key) {
        return this.mMetaData != null ? this.mMetaData.containsKey(key) : false;
    }

    private final boolean $$robo$$android_filterfw_core_FrameFormat$hasMetaKey(String key, Class expectedClass) {
        if (this.mMetaData != null && this.mMetaData.containsKey(key)) {
            if (!expectedClass.isAssignableFrom(this.mMetaData.get(key).getClass())) {
                throw new RuntimeException("FrameFormat meta-key '" + key + "' is of type " + this.mMetaData.get(key).getClass() + " but expected to be of type " + expectedClass + "!");
            }
            return true;
        }
        return false;
    }

    private final Object $$robo$$android_filterfw_core_FrameFormat$getMetaValue(String key) {
        return this.mMetaData != null ? this.mMetaData.get(key) : null;
    }

    private final int $$robo$$android_filterfw_core_FrameFormat$getNumberOfDimensions() {
        return this.mDimensions != null ? this.mDimensions.length : 0;
    }

    private final int $$robo$$android_filterfw_core_FrameFormat$getLength() {
        return this.mDimensions != null && this.mDimensions.length >= 1 ? this.mDimensions[0] : -1;
    }

    private final int $$robo$$android_filterfw_core_FrameFormat$getWidth() {
        return this.getLength();
    }

    private final int $$robo$$android_filterfw_core_FrameFormat$getHeight() {
        return this.mDimensions != null && this.mDimensions.length >= 2 ? this.mDimensions[1] : -1;
    }

    private final int $$robo$$android_filterfw_core_FrameFormat$getDepth() {
        return this.mDimensions != null && this.mDimensions.length >= 3 ? this.mDimensions[2] : -1;
    }

    private final int $$robo$$android_filterfw_core_FrameFormat$getSize() {
        if (this.mSize == -1) {
            this.mSize = this.calcSize(this.mDimensions);
        }
        return this.mSize;
    }

    private final Class $$robo$$android_filterfw_core_FrameFormat$getObjectClass() {
        return this.mObjectClass;
    }

    private final MutableFrameFormat $$robo$$android_filterfw_core_FrameFormat$mutableCopy() {
        MutableFrameFormat result = new MutableFrameFormat();
        result.setBaseType(this.getBaseType());
        result.setTarget(this.getTarget());
        result.setBytesPerSample(this.getBytesPerSample());
        result.setDimensions(this.getDimensions());
        result.setObjectClass(this.getObjectClass());
        result.mMetaData = this.mMetaData == null ? null : (KeyValueMap)this.mMetaData.clone();
        return result;
    }

    private final boolean $$robo$$android_filterfw_core_FrameFormat$equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof FrameFormat)) {
            return false;
        }
        FrameFormat format = (FrameFormat)object;
        return format.mBaseType == this.mBaseType && format.mTarget == this.mTarget && format.mBytesPerSample == this.mBytesPerSample && Arrays.equals(format.mDimensions, this.mDimensions) && format.mMetaData.equals(this.mMetaData);
    }

    private final int $$robo$$android_filterfw_core_FrameFormat$hashCode() {
        return 0x1073 ^ this.mBaseType ^ this.mBytesPerSample ^ this.getSize();
    }

    private final boolean $$robo$$android_filterfw_core_FrameFormat$isCompatibleWith(FrameFormat specification) {
        if (specification.getBaseType() != 0 && this.getBaseType() != specification.getBaseType()) {
            return false;
        }
        if (specification.getTarget() != 0 && this.getTarget() != specification.getTarget()) {
            return false;
        }
        if (specification.getBytesPerSample() != 1 && this.getBytesPerSample() != specification.getBytesPerSample()) {
            return false;
        }
        if (specification.getDimensionCount() > 0 && this.getDimensionCount() != specification.getDimensionCount()) {
            return false;
        }
        for (int i = 0; i < specification.getDimensionCount(); ++i) {
            int specDim = specification.getDimension(i);
            if (specDim == 0 || this.getDimension(i) == specDim) continue;
            return false;
        }
        if (!(specification.getObjectClass() == null || this.getObjectClass() != null && specification.getObjectClass().isAssignableFrom(this.getObjectClass()))) {
            return false;
        }
        if (specification.mMetaData != null) {
            for (String specKey : specification.mMetaData.keySet()) {
                if (this.mMetaData != null && this.mMetaData.containsKey(specKey) && this.mMetaData.get(specKey).equals(specification.mMetaData.get(specKey))) continue;
                return false;
            }
        }
        return true;
    }

    private final boolean $$robo$$android_filterfw_core_FrameFormat$mayBeCompatibleWith(FrameFormat specification) {
        if (specification.getBaseType() != 0 && this.getBaseType() != 0 && this.getBaseType() != specification.getBaseType()) {
            return false;
        }
        if (specification.getTarget() != 0 && this.getTarget() != 0 && this.getTarget() != specification.getTarget()) {
            return false;
        }
        if (specification.getBytesPerSample() != 1 && this.getBytesPerSample() != 1 && this.getBytesPerSample() != specification.getBytesPerSample()) {
            return false;
        }
        if (specification.getDimensionCount() > 0 && this.getDimensionCount() > 0 && this.getDimensionCount() != specification.getDimensionCount()) {
            return false;
        }
        for (int i = 0; i < specification.getDimensionCount(); ++i) {
            int specDim = specification.getDimension(i);
            if (specDim == 0 || this.getDimension(i) == 0 || this.getDimension(i) == specDim) continue;
            return false;
        }
        if (specification.getObjectClass() != null && this.getObjectClass() != null && !specification.getObjectClass().isAssignableFrom(this.getObjectClass())) {
            return false;
        }
        if (specification.mMetaData != null && this.mMetaData != null) {
            for (String specKey : specification.mMetaData.keySet()) {
                if (!this.mMetaData.containsKey(specKey) || this.mMetaData.get(specKey).equals(specification.mMetaData.get(specKey))) continue;
                return false;
            }
        }
        return true;
    }

    private static final int $$robo$$android_filterfw_core_FrameFormat$bytesPerSampleOf(int baseType) {
        switch (baseType) {
            case 1: 
            case 2: {
                return 1;
            }
            case 3: {
                return 2;
            }
            case 4: 
            case 5: 
            case 7: {
                return 4;
            }
            case 6: {
                return 8;
            }
        }
        return 1;
    }

    private static final String $$robo$$android_filterfw_core_FrameFormat$dimensionsToString(int[] dimensions) {
        StringBuffer buffer = new StringBuffer();
        if (dimensions != null) {
            int n = dimensions.length;
            for (int i = 0; i < n; ++i) {
                if (dimensions[i] == 0) {
                    buffer.append("[]");
                    continue;
                }
                buffer.append("[" + String.valueOf(dimensions[i]) + "]");
            }
        }
        return buffer.toString();
    }

    private static final String $$robo$$android_filterfw_core_FrameFormat$baseTypeToString(int baseType) {
        switch (baseType) {
            case 0: {
                return "unspecified";
            }
            case 1: {
                return "bit";
            }
            case 2: {
                return "byte";
            }
            case 3: {
                return "int";
            }
            case 4: {
                return "int";
            }
            case 5: {
                return "float";
            }
            case 6: {
                return "double";
            }
            case 7: {
                return "pointer";
            }
            case 8: {
                return "object";
            }
        }
        return "unknown";
    }

    private static final String $$robo$$android_filterfw_core_FrameFormat$targetToString(int target) {
        switch (target) {
            case 0: {
                return "unspecified";
            }
            case 1: {
                return "simple";
            }
            case 2: {
                return "native";
            }
            case 3: {
                return "gpu";
            }
            case 4: {
                return "vbo";
            }
            case 5: {
                return "renderscript";
            }
        }
        return "unknown";
    }

    private static final String $$robo$$android_filterfw_core_FrameFormat$metaDataToString(KeyValueMap metaData) {
        if (metaData == null) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("{ ");
        for (Map.Entry entry : metaData.entrySet()) {
            buffer.append((String)entry.getKey() + ": " + entry.getValue() + " ");
        }
        buffer.append("}");
        return buffer.toString();
    }

    private static final int $$robo$$android_filterfw_core_FrameFormat$readTargetString(String targetString) {
        if (targetString.equalsIgnoreCase("CPU") || targetString.equalsIgnoreCase("NATIVE")) {
            return 2;
        }
        if (targetString.equalsIgnoreCase("GPU")) {
            return 3;
        }
        if (targetString.equalsIgnoreCase("SIMPLE")) {
            return 1;
        }
        if (targetString.equalsIgnoreCase("VERTEXBUFFER")) {
            return 4;
        }
        if (targetString.equalsIgnoreCase("UNSPECIFIED")) {
            return 0;
        }
        throw new RuntimeException("Unknown target type '" + targetString + "'!");
    }

    private final String $$robo$$android_filterfw_core_FrameFormat$toString() {
        int valuesPerSample = this.getValuesPerSample();
        String sampleCountString = valuesPerSample == 1 ? "" : String.valueOf(valuesPerSample);
        String targetString = this.mTarget == 0 ? "" : FrameFormat.targetToString(this.mTarget) + " ";
        String classString = this.mObjectClass == null ? "" : " class(" + this.mObjectClass.getSimpleName() + ") ";
        return targetString + FrameFormat.baseTypeToString(this.mBaseType) + sampleCountString + FrameFormat.dimensionsToString(this.mDimensions) + classString + FrameFormat.metaDataToString(this.mMetaData);
    }

    private final void $$robo$$android_filterfw_core_FrameFormat$initDefaults() {
        this.mBytesPerSample = FrameFormat.bytesPerSampleOf(this.mBaseType);
    }

    private final int $$robo$$android_filterfw_core_FrameFormat$calcSize(int[] dimensions) {
        if (dimensions != null && dimensions.length > 0) {
            int size = this.getBytesPerSample();
            for (int dim : dimensions) {
                size *= dim;
            }
            return size;
        }
        return 0;
    }

    private final boolean $$robo$$android_filterfw_core_FrameFormat$isReplaceableBy(FrameFormat format) {
        return this.mTarget == format.mTarget && this.getSize() == format.getSize() && Arrays.equals(format.mDimensions, this.mDimensions);
    }

    private void __constructor__() {
        this.$$robo$$android_filterfw_core_FrameFormat$__constructor__();
    }

    public FrameFormat() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_filterfw_core_FrameFormat$__constructor__(), this);
    }

    private void __constructor__(int n, int n2) {
        this.$$robo$$android_filterfw_core_FrameFormat$__constructor__(n, n2);
    }

    public FrameFormat(int n, int n2) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_filterfw_core_FrameFormat$__constructor__(int int ), this, n, n2);
    }

    public static FrameFormat unspecified() {
        return InvokeDynamicSupport.bootstrapStatic("unspecified", $$robo$$android_filterfw_core_FrameFormat$unspecified());
    }

    public int getBaseType() {
        return (int)InvokeDynamicSupport.bootstrap("getBaseType", $$robo$$android_filterfw_core_FrameFormat$getBaseType(), this);
    }

    public boolean isBinaryDataType() {
        return (boolean)InvokeDynamicSupport.bootstrap("isBinaryDataType", $$robo$$android_filterfw_core_FrameFormat$isBinaryDataType(), this);
    }

    public int getBytesPerSample() {
        return (int)InvokeDynamicSupport.bootstrap("getBytesPerSample", $$robo$$android_filterfw_core_FrameFormat$getBytesPerSample(), this);
    }

    public int getValuesPerSample() {
        return (int)InvokeDynamicSupport.bootstrap("getValuesPerSample", $$robo$$android_filterfw_core_FrameFormat$getValuesPerSample(), this);
    }

    public int getTarget() {
        return (int)InvokeDynamicSupport.bootstrap("getTarget", $$robo$$android_filterfw_core_FrameFormat$getTarget(), this);
    }

    public int[] getDimensions() {
        return InvokeDynamicSupport.bootstrap("getDimensions", $$robo$$android_filterfw_core_FrameFormat$getDimensions(), this);
    }

    public int getDimension(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getDimension", $$robo$$android_filterfw_core_FrameFormat$getDimension(int ), this, n);
    }

    public int getDimensionCount() {
        return (int)InvokeDynamicSupport.bootstrap("getDimensionCount", $$robo$$android_filterfw_core_FrameFormat$getDimensionCount(), this);
    }

    public boolean hasMetaKey(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("hasMetaKey", $$robo$$android_filterfw_core_FrameFormat$hasMetaKey(java.lang.String ), this, string2);
    }

    public boolean hasMetaKey(String string2, Class clazz) {
        return (boolean)InvokeDynamicSupport.bootstrap("hasMetaKey", $$robo$$android_filterfw_core_FrameFormat$hasMetaKey(java.lang.String java.lang.Class ), this, string2, clazz);
    }

    public Object getMetaValue(String string2) {
        return InvokeDynamicSupport.bootstrap("getMetaValue", $$robo$$android_filterfw_core_FrameFormat$getMetaValue(java.lang.String ), this, string2);
    }

    public int getNumberOfDimensions() {
        return (int)InvokeDynamicSupport.bootstrap("getNumberOfDimensions", $$robo$$android_filterfw_core_FrameFormat$getNumberOfDimensions(), this);
    }

    public int getLength() {
        return (int)InvokeDynamicSupport.bootstrap("getLength", $$robo$$android_filterfw_core_FrameFormat$getLength(), this);
    }

    public int getWidth() {
        return (int)InvokeDynamicSupport.bootstrap("getWidth", $$robo$$android_filterfw_core_FrameFormat$getWidth(), this);
    }

    public int getHeight() {
        return (int)InvokeDynamicSupport.bootstrap("getHeight", $$robo$$android_filterfw_core_FrameFormat$getHeight(), this);
    }

    public int getDepth() {
        return (int)InvokeDynamicSupport.bootstrap("getDepth", $$robo$$android_filterfw_core_FrameFormat$getDepth(), this);
    }

    public int getSize() {
        return (int)InvokeDynamicSupport.bootstrap("getSize", $$robo$$android_filterfw_core_FrameFormat$getSize(), this);
    }

    public Class getObjectClass() {
        return InvokeDynamicSupport.bootstrap("getObjectClass", $$robo$$android_filterfw_core_FrameFormat$getObjectClass(), this);
    }

    public MutableFrameFormat mutableCopy() {
        return InvokeDynamicSupport.bootstrap("mutableCopy", $$robo$$android_filterfw_core_FrameFormat$mutableCopy(), this);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_filterfw_core_FrameFormat$equals(java.lang.Object ), this, object);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_filterfw_core_FrameFormat$hashCode(), this);
    }

    public boolean isCompatibleWith(FrameFormat frameFormat) {
        return (boolean)InvokeDynamicSupport.bootstrap("isCompatibleWith", $$robo$$android_filterfw_core_FrameFormat$isCompatibleWith(android.filterfw.core.FrameFormat ), this, frameFormat);
    }

    public boolean mayBeCompatibleWith(FrameFormat frameFormat) {
        return (boolean)InvokeDynamicSupport.bootstrap("mayBeCompatibleWith", $$robo$$android_filterfw_core_FrameFormat$mayBeCompatibleWith(android.filterfw.core.FrameFormat ), this, frameFormat);
    }

    public static int bytesPerSampleOf(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("bytesPerSampleOf", $$robo$$android_filterfw_core_FrameFormat$bytesPerSampleOf(int ), (int)n);
    }

    public static String dimensionsToString(int[] nArray) {
        return InvokeDynamicSupport.bootstrapStatic("dimensionsToString", $$robo$$android_filterfw_core_FrameFormat$dimensionsToString(int[] ), (int[])nArray);
    }

    public static String baseTypeToString(int n) {
        return InvokeDynamicSupport.bootstrapStatic("baseTypeToString", $$robo$$android_filterfw_core_FrameFormat$baseTypeToString(int ), (int)n);
    }

    public static String targetToString(int n) {
        return InvokeDynamicSupport.bootstrapStatic("targetToString", $$robo$$android_filterfw_core_FrameFormat$targetToString(int ), (int)n);
    }

    public static String metaDataToString(KeyValueMap keyValueMap) {
        return InvokeDynamicSupport.bootstrapStatic("metaDataToString", $$robo$$android_filterfw_core_FrameFormat$metaDataToString(android.filterfw.core.KeyValueMap ), (KeyValueMap)keyValueMap);
    }

    public static int readTargetString(String string2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("readTargetString", $$robo$$android_filterfw_core_FrameFormat$readTargetString(java.lang.String ), (String)string2);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_filterfw_core_FrameFormat$toString(), this);
    }

    private void initDefaults() {
        InvokeDynamicSupport.bootstrap("initDefaults", $$robo$$android_filterfw_core_FrameFormat$initDefaults(), this);
    }

    int calcSize(int[] nArray) {
        return (int)InvokeDynamicSupport.bootstrap("calcSize", $$robo$$android_filterfw_core_FrameFormat$calcSize(int[] ), this, nArray);
    }

    boolean isReplaceableBy(FrameFormat frameFormat) {
        return (boolean)InvokeDynamicSupport.bootstrap("isReplaceableBy", $$robo$$android_filterfw_core_FrameFormat$isReplaceableBy(android.filterfw.core.FrameFormat ), this, frameFormat);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (FrameFormat)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

