/*
 * Decompiled with CFR 0.152.
 */
package android.drm;

import android.drm.DrmConvertedStatus;
import android.drm.DrmManagerClient;
import android.os.ParcelFileDescriptor;
import android.system.ErrnoException;
import android.system.Os;
import android.system.OsConstants;
import android.util.Log;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.OutputStream;
import java.net.UnknownServiceException;
import java.util.Arrays;
import libcore.io.IoBridge;
import libcore.io.Streams;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class DrmOutputStream
extends OutputStream
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG = "DrmOutputStream";
    private DrmManagerClient mClient;
    private ParcelFileDescriptor mPfd;
    private FileDescriptor mFd;
    private int mSessionId;

    private void $$robo$$android_drm_DrmOutputStream$__constructor__(DrmManagerClient client, ParcelFileDescriptor pfd, String mimeType) throws IOException {
        this.mSessionId = -1;
        this.mClient = client;
        this.mPfd = pfd;
        this.mFd = pfd.getFileDescriptor();
        this.mSessionId = this.mClient.openConvertSession(mimeType);
        if (this.mSessionId == -1) {
            throw new UnknownServiceException("Failed to open DRM session for " + mimeType);
        }
    }

    private final void $$robo$$android_drm_DrmOutputStream$finish() throws IOException {
        DrmConvertedStatus status = this.mClient.closeConvertSession(this.mSessionId);
        if (status.statusCode == 1) {
            try {
                Os.lseek(this.mFd, status.offset, OsConstants.SEEK_SET);
            }
            catch (ErrnoException e) {
                e.rethrowAsIOException();
            }
        } else {
            throw new IOException("Unexpected DRM status: " + status.statusCode);
        }
        IoBridge.write(this.mFd, status.convertedData, 0, status.convertedData.length);
        this.mSessionId = -1;
    }

    private final void $$robo$$android_drm_DrmOutputStream$close() throws IOException {
        if (this.mSessionId == -1) {
            Log.w("DrmOutputStream", "Closing stream without finishing");
        }
        this.mPfd.close();
    }

    private final void $$robo$$android_drm_DrmOutputStream$write(byte[] buffer, int offset, int count) throws IOException {
        byte[] exactBuffer;
        Arrays.checkOffsetAndCount((int)buffer.length, (int)offset, (int)count);
        if (count == buffer.length) {
            exactBuffer = buffer;
        } else {
            exactBuffer = new byte[count];
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (byte[])buffer, (int)offset, (byte[])exactBuffer, (int)0, (int)count);
        }
        DrmConvertedStatus status = this.mClient.convertData(this.mSessionId, exactBuffer);
        if (status.statusCode != 1) {
            throw new IOException("Unexpected DRM status: " + status.statusCode);
        }
        IoBridge.write(this.mFd, status.convertedData, 0, status.convertedData.length);
    }

    private final void $$robo$$android_drm_DrmOutputStream$write(int oneByte) throws IOException {
        Streams.writeSingleByte(this, oneByte);
    }

    private void __constructor__(DrmManagerClient drmManagerClient, ParcelFileDescriptor parcelFileDescriptor, String string2) throws IOException {
        this.$$robo$$android_drm_DrmOutputStream$__constructor__(drmManagerClient, parcelFileDescriptor, string2);
    }

    public DrmOutputStream(DrmManagerClient drmManagerClient, ParcelFileDescriptor parcelFileDescriptor, String string2) throws IOException {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_drm_DrmOutputStream$__constructor__(android.drm.DrmManagerClient android.os.ParcelFileDescriptor java.lang.String ), this, drmManagerClient, parcelFileDescriptor, string2);
    }

    public void finish() throws IOException {
        InvokeDynamicSupport.bootstrap("finish", $$robo$$android_drm_DrmOutputStream$finish(), this);
    }

    @Override
    public void close() throws IOException {
        InvokeDynamicSupport.bootstrap("close", $$robo$$android_drm_DrmOutputStream$close(), this);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        InvokeDynamicSupport.bootstrap("write", $$robo$$android_drm_DrmOutputStream$write(byte[] int int ), this, byArray, n, n2);
    }

    @Override
    public void write(int n) throws IOException {
        InvokeDynamicSupport.bootstrap("write", $$robo$$android_drm_DrmOutputStream$write(int ), this, n);
    }

    public /* synthetic */ DrmOutputStream() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DrmOutputStream)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

