/*
 * Decompiled with CFR 0.152.
 */
package android.ddm;

import android.util.Log;
import android.view.View;
import android.view.ViewDebug;
import android.view.WindowManagerGlobal;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.invoke.CallSite;
import java.lang.reflect.Method;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import org.apache.harmony.dalvik.ddmc.Chunk;
import org.apache.harmony.dalvik.ddmc.ChunkHandler;
import org.apache.harmony.dalvik.ddmc.DdmServer;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class DdmHandleViewDebug
extends ChunkHandler
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static int CHUNK_VULW;
    private static int CHUNK_VURT;
    private static int VURT_DUMP_HIERARCHY = 1;
    private static int VURT_CAPTURE_LAYERS = 2;
    private static int VURT_DUMP_THEME = 3;
    private static int CHUNK_VUOP;
    private static int VUOP_CAPTURE_VIEW = 1;
    private static int VUOP_DUMP_DISPLAYLIST = 2;
    private static int VUOP_PROFILE_VIEW = 3;
    private static int VUOP_INVOKE_VIEW_METHOD = 4;
    private static int VUOP_SET_LAYOUT_PARAMETER = 5;
    private static int ERR_INVALID_OP = -1;
    private static int ERR_INVALID_PARAM = -2;
    private static int ERR_EXCEPTION = -3;
    private static String TAG = "DdmViewDebug";
    private static DdmHandleViewDebug sInstance;

    private void $$robo$$android_ddm_DdmHandleViewDebug$__constructor__() {
    }

    private static final void $$robo$$android_ddm_DdmHandleViewDebug$register() {
        DdmServer.registerHandler(CHUNK_VULW, sInstance);
        DdmServer.registerHandler(CHUNK_VURT, sInstance);
        DdmServer.registerHandler(CHUNK_VUOP, sInstance);
    }

    private final void $$robo$$android_ddm_DdmHandleViewDebug$connected() {
    }

    private final void $$robo$$android_ddm_DdmHandleViewDebug$disconnected() {
    }

    private final Chunk $$robo$$android_ddm_DdmHandleViewDebug$handleChunk(Chunk request) {
        int type = request.type;
        if (type == CHUNK_VULW) {
            return this.listWindows();
        }
        ByteBuffer in = DdmHandleViewDebug.wrapChunk(request);
        int op = in.getInt();
        View rootView = this.getRootView(in);
        if (rootView == null) {
            return DdmHandleViewDebug.createFailChunk(-2, "Invalid View Root");
        }
        if (type == CHUNK_VURT) {
            if (op == 1) {
                return this.dumpHierarchy(rootView, in);
            }
            if (op == 2) {
                return this.captureLayers(rootView);
            }
            if (op == 3) {
                return this.dumpTheme(rootView);
            }
            return DdmHandleViewDebug.createFailChunk(-1, "Unknown view root operation: " + op);
        }
        View targetView = this.getTargetView(rootView, in);
        if (targetView == null) {
            return DdmHandleViewDebug.createFailChunk(-2, "Invalid target view");
        }
        if (type == CHUNK_VUOP) {
            switch (op) {
                case 1: {
                    return this.captureView(rootView, targetView);
                }
                case 2: {
                    return this.dumpDisplayLists(rootView, targetView);
                }
                case 3: {
                    return this.profileView(rootView, targetView);
                }
                case 4: {
                    return this.invokeViewMethod(rootView, targetView, in);
                }
                case 5: {
                    return this.setLayoutParameter(rootView, targetView, in);
                }
            }
            return DdmHandleViewDebug.createFailChunk(-1, "Unknown view operation: " + op);
        }
        throw new RuntimeException("Unknown packet " + ChunkHandler.name(type));
    }

    private final Chunk $$robo$$android_ddm_DdmHandleViewDebug$listWindows() {
        String[] windowNames = WindowManagerGlobal.getInstance().getViewRootNames();
        int responseLength = 4;
        for (String name : windowNames) {
            responseLength += 4;
            responseLength += name.length() * 2;
        }
        ByteBuffer out = ByteBuffer.allocate(responseLength);
        out.order(ChunkHandler.CHUNK_ORDER);
        out.putInt(windowNames.length);
        for (String name : windowNames) {
            out.putInt(name.length());
            DdmHandleViewDebug.putString(out, name);
        }
        return new Chunk(CHUNK_VULW, out);
    }

    private final View $$robo$$android_ddm_DdmHandleViewDebug$getRootView(ByteBuffer in) {
        try {
            int viewRootNameLength = in.getInt();
            String viewRootName = DdmHandleViewDebug.getString(in, viewRootNameLength);
            return WindowManagerGlobal.getInstance().getRootView(viewRootName);
        }
        catch (BufferUnderflowException e) {
            return null;
        }
    }

    private final View $$robo$$android_ddm_DdmHandleViewDebug$getTargetView(View root, ByteBuffer in) {
        String viewName;
        try {
            int viewLength = in.getInt();
            viewName = DdmHandleViewDebug.getString(in, viewLength);
        }
        catch (BufferUnderflowException e) {
            return null;
        }
        return ViewDebug.findView(root, viewName);
    }

    private final Chunk $$robo$$android_ddm_DdmHandleViewDebug$dumpHierarchy(View rootView, ByteBuffer in) {
        boolean skipChildren = in.getInt() > 0;
        boolean includeProperties = in.getInt() > 0;
        boolean v2 = in.hasRemaining() && in.getInt() > 0;
        CallSite start = InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System");
        ByteArrayOutputStream b = new ByteArrayOutputStream(0x200000);
        try {
            if (v2) {
                ViewDebug.dumpv2(rootView, b);
            } else {
                ViewDebug.dump(rootView, skipChildren, includeProperties, b);
            }
        }
        catch (IOException | InterruptedException e) {
            return DdmHandleViewDebug.createFailChunk(1, "Unexpected error while obtaining view hierarchy: " + e.getMessage());
        }
        CallSite end = InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System");
        Log.d("DdmViewDebug", "Time to obtain view hierarchy (ms): " + (long)(end - start));
        byte[] data = b.toByteArray();
        return new Chunk(CHUNK_VURT, data, 0, data.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Chunk $$robo$$android_ddm_DdmHandleViewDebug$captureLayers(View rootView) {
        ByteArrayOutputStream b = new ByteArrayOutputStream(1024);
        DataOutputStream dos = new DataOutputStream(b);
        try {
            ViewDebug.captureLayers(rootView, dos);
        }
        catch (IOException e) {
            Chunk chunk = DdmHandleViewDebug.createFailChunk(1, "Unexpected error while obtaining view hierarchy: " + e.getMessage());
            return chunk;
        }
        finally {
            try {
                dos.close();
            }
            catch (IOException iOException) {}
        }
        byte[] data = b.toByteArray();
        return new Chunk(CHUNK_VURT, data, 0, data.length);
    }

    private final Chunk $$robo$$android_ddm_DdmHandleViewDebug$dumpTheme(View rootView) {
        ByteArrayOutputStream b = new ByteArrayOutputStream(1024);
        try {
            ViewDebug.dumpTheme(rootView, b);
        }
        catch (IOException e) {
            return DdmHandleViewDebug.createFailChunk(1, "Unexpected error while dumping the theme: " + e.getMessage());
        }
        byte[] data = b.toByteArray();
        return new Chunk(CHUNK_VURT, data, 0, data.length);
    }

    private final Chunk $$robo$$android_ddm_DdmHandleViewDebug$captureView(View rootView, View targetView) {
        ByteArrayOutputStream b = new ByteArrayOutputStream(1024);
        try {
            ViewDebug.capture(rootView, (OutputStream)b, targetView);
        }
        catch (IOException e) {
            return DdmHandleViewDebug.createFailChunk(1, "Unexpected error while capturing view: " + e.getMessage());
        }
        byte[] data = b.toByteArray();
        return new Chunk(CHUNK_VUOP, data, 0, data.length);
    }

    private final Chunk $$robo$$android_ddm_DdmHandleViewDebug$dumpDisplayLists(View rootView, View targetView) {
        rootView.post(new Runnable(this, rootView, targetView){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ View val$rootView;
            /* synthetic */ View val$targetView;
            /* synthetic */ DdmHandleViewDebug this$0;

            private void $$robo$$android_ddm_DdmHandleViewDebug_1$__constructor__(DdmHandleViewDebug this$0, View view, View view2) {
                this.val$rootView = view;
                this.val$targetView = view2;
            }

            private final void $$robo$$android_ddm_DdmHandleViewDebug_1$run() {
                ViewDebug.outputDisplayList(this.val$rootView, this.val$targetView);
            }

            private void __constructor__(DdmHandleViewDebug ddmHandleViewDebug, View view, View view2) {
                this.$$robo$$android_ddm_DdmHandleViewDebug_1$__constructor__(ddmHandleViewDebug, view, view2);
            }
            {
                this.this$0 = ddmHandleViewDebug;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_ddm_DdmHandleViewDebug_1$__constructor__(android.ddm.DdmHandleViewDebug android.view.View android.view.View ), this, ddmHandleViewDebug, view, view2);
            }

            @Override
            public void run() {
                InvokeDynamicSupport.bootstrap("run", $$robo$$android_ddm_DdmHandleViewDebug_1$run(), this);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
        return null;
    }

    private final Chunk $$robo$$android_ddm_DdmHandleViewDebug$invokeViewMethod(View rootView, View targetView, ByteBuffer in) {
        Object[] args;
        Class[] argTypes;
        int l = in.getInt();
        String methodName = DdmHandleViewDebug.getString(in, l);
        if (!in.hasRemaining()) {
            argTypes = new Class[]{};
            args = new Object[]{};
        } else {
            int nArgs = in.getInt();
            argTypes = new Class[nArgs];
            args = new Object[nArgs];
            block14: for (int i = 0; i < nArgs; ++i) {
                char c = in.getChar();
                switch (c) {
                    case 'Z': {
                        argTypes[i] = Boolean.TYPE;
                        args[i] = in.get() != 0;
                        continue block14;
                    }
                    case 'B': {
                        argTypes[i] = Byte.TYPE;
                        args[i] = in.get();
                        continue block14;
                    }
                    case 'C': {
                        argTypes[i] = Character.TYPE;
                        args[i] = Character.valueOf(in.getChar());
                        continue block14;
                    }
                    case 'S': {
                        argTypes[i] = Short.TYPE;
                        args[i] = in.getShort();
                        continue block14;
                    }
                    case 'I': {
                        argTypes[i] = Integer.TYPE;
                        args[i] = in.getInt();
                        continue block14;
                    }
                    case 'J': {
                        argTypes[i] = Long.TYPE;
                        args[i] = in.getLong();
                        continue block14;
                    }
                    case 'F': {
                        argTypes[i] = Float.TYPE;
                        args[i] = Float.valueOf(in.getFloat());
                        continue block14;
                    }
                    case 'D': {
                        argTypes[i] = Double.TYPE;
                        args[i] = in.getDouble();
                        continue block14;
                    }
                    default: {
                        Log.e("DdmViewDebug", "arg " + i + ", unrecognized type: " + c);
                        return DdmHandleViewDebug.createFailChunk(-2, "Unsupported parameter type (" + c + ") to invoke view method.");
                    }
                }
            }
        }
        Method method = null;
        try {
            method = targetView.getClass().getMethod(methodName, argTypes);
        }
        catch (NoSuchMethodException e) {
            Log.e("DdmViewDebug", "No such method: " + e.getMessage());
            return DdmHandleViewDebug.createFailChunk(-2, "No such method: " + e.getMessage());
        }
        try {
            ViewDebug.invokeViewMethod(targetView, method, args);
        }
        catch (Exception e) {
            Log.e("DdmViewDebug", "Exception while invoking method: " + e.getCause().getMessage());
            String msg = e.getCause().getMessage();
            if (msg == null) {
                msg = e.getCause().toString();
            }
            return DdmHandleViewDebug.createFailChunk(-3, msg);
        }
        return null;
    }

    private final Chunk $$robo$$android_ddm_DdmHandleViewDebug$setLayoutParameter(View rootView, View targetView, ByteBuffer in) {
        int l = in.getInt();
        String param = DdmHandleViewDebug.getString(in, l);
        int value = in.getInt();
        try {
            ViewDebug.setLayoutParameter(targetView, param, value);
        }
        catch (Exception e) {
            Log.e("DdmViewDebug", "Exception setting layout parameter: " + e);
            return DdmHandleViewDebug.createFailChunk(-3, "Error accessing field " + param + ":" + e.getMessage());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Chunk $$robo$$android_ddm_DdmHandleViewDebug$profileView(View rootView, View targetView) {
        ByteArrayOutputStream b = new ByteArrayOutputStream(32768);
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(b), 32768);
        try {
            ViewDebug.profileViewAndChildren(targetView, bw);
        }
        catch (IOException e) {
            Chunk chunk = DdmHandleViewDebug.createFailChunk(1, "Unexpected error while profiling view: " + e.getMessage());
            return chunk;
        }
        finally {
            try {
                bw.close();
            }
            catch (IOException iOException) {}
        }
        byte[] data = b.toByteArray();
        return new Chunk(CHUNK_VUOP, data, 0, data.length);
    }

    static void __staticInitializer__() {
        CHUNK_VULW = DdmHandleViewDebug.type("VULW");
        CHUNK_VURT = DdmHandleViewDebug.type("VURT");
        CHUNK_VUOP = DdmHandleViewDebug.type("VUOP");
        sInstance = new DdmHandleViewDebug();
    }

    private void __constructor__() {
        this.$$robo$$android_ddm_DdmHandleViewDebug$__constructor__();
    }

    public DdmHandleViewDebug() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_ddm_DdmHandleViewDebug$__constructor__(), this);
    }

    public static void register() {
        InvokeDynamicSupport.bootstrapStatic("register", $$robo$$android_ddm_DdmHandleViewDebug$register());
    }

    @Override
    public void connected() {
        InvokeDynamicSupport.bootstrap("connected", $$robo$$android_ddm_DdmHandleViewDebug$connected(), this);
    }

    @Override
    public void disconnected() {
        InvokeDynamicSupport.bootstrap("disconnected", $$robo$$android_ddm_DdmHandleViewDebug$disconnected(), this);
    }

    @Override
    public Chunk handleChunk(Chunk chunk) {
        return InvokeDynamicSupport.bootstrap("handleChunk", $$robo$$android_ddm_DdmHandleViewDebug$handleChunk(org.apache.harmony.dalvik.ddmc.Chunk ), this, chunk);
    }

    private Chunk listWindows() {
        return InvokeDynamicSupport.bootstrap("listWindows", $$robo$$android_ddm_DdmHandleViewDebug$listWindows(), this);
    }

    private View getRootView(ByteBuffer byteBuffer) {
        return InvokeDynamicSupport.bootstrap("getRootView", $$robo$$android_ddm_DdmHandleViewDebug$getRootView(java.nio.ByteBuffer ), this, byteBuffer);
    }

    private View getTargetView(View view, ByteBuffer byteBuffer) {
        return InvokeDynamicSupport.bootstrap("getTargetView", $$robo$$android_ddm_DdmHandleViewDebug$getTargetView(android.view.View java.nio.ByteBuffer ), this, view, byteBuffer);
    }

    private Chunk dumpHierarchy(View view, ByteBuffer byteBuffer) {
        return InvokeDynamicSupport.bootstrap("dumpHierarchy", $$robo$$android_ddm_DdmHandleViewDebug$dumpHierarchy(android.view.View java.nio.ByteBuffer ), this, view, byteBuffer);
    }

    private Chunk captureLayers(View view) {
        return InvokeDynamicSupport.bootstrap("captureLayers", $$robo$$android_ddm_DdmHandleViewDebug$captureLayers(android.view.View ), this, view);
    }

    private Chunk dumpTheme(View view) {
        return InvokeDynamicSupport.bootstrap("dumpTheme", $$robo$$android_ddm_DdmHandleViewDebug$dumpTheme(android.view.View ), this, view);
    }

    private Chunk captureView(View view, View view2) {
        return InvokeDynamicSupport.bootstrap("captureView", $$robo$$android_ddm_DdmHandleViewDebug$captureView(android.view.View android.view.View ), this, view, view2);
    }

    private Chunk dumpDisplayLists(View view, View view2) {
        return InvokeDynamicSupport.bootstrap("dumpDisplayLists", $$robo$$android_ddm_DdmHandleViewDebug$dumpDisplayLists(android.view.View android.view.View ), this, view, view2);
    }

    private Chunk invokeViewMethod(View view, View view2, ByteBuffer byteBuffer) {
        return InvokeDynamicSupport.bootstrap("invokeViewMethod", $$robo$$android_ddm_DdmHandleViewDebug$invokeViewMethod(android.view.View android.view.View java.nio.ByteBuffer ), this, view, view2, byteBuffer);
    }

    private Chunk setLayoutParameter(View view, View view2, ByteBuffer byteBuffer) {
        return InvokeDynamicSupport.bootstrap("setLayoutParameter", $$robo$$android_ddm_DdmHandleViewDebug$setLayoutParameter(android.view.View android.view.View java.nio.ByteBuffer ), this, view, view2, byteBuffer);
    }

    private Chunk profileView(View view, View view2) {
        return InvokeDynamicSupport.bootstrap("profileView", $$robo$$android_ddm_DdmHandleViewDebug$profileView(android.view.View android.view.View ), this, view, view2);
    }

    static {
        RobolectricInternals.classInitializing(DdmHandleViewDebug.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DdmHandleViewDebug)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

