/*
 * Decompiled with CFR 0.152.
 */
package android.database.sqlite;

import android.database.sqlite.SQLiteDatabase;
import android.os.Build;
import android.os.SystemProperties;
import android.util.Log;
import android.util.Printer;
import com.google.errorprone.annotations.DoNotMock;
import java.util.ArrayList;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class SQLiteDebug
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    public static boolean DEBUG_SQL_LOG;
    public static boolean DEBUG_SQL_STATEMENTS;
    public static boolean DEBUG_SQL_TIME;
    public static boolean DEBUG_LOG_SLOW_QUERIES;

    private static final void $$robo$$android_database_sqlite_SQLiteDebug$nativeGetPagerStats(PagerStats pagerStats) {
    }

    private void $$robo$$android_database_sqlite_SQLiteDebug$__constructor__() {
    }

    private static final boolean $$robo$$android_database_sqlite_SQLiteDebug$shouldLogSlowQuery(long elapsedTimeMillis) {
        int slowQueryMillis = SystemProperties.getInt("db.log.slow_query_threshold", -1);
        return slowQueryMillis >= 0 && elapsedTimeMillis >= (long)slowQueryMillis;
    }

    private static final PagerStats $$robo$$android_database_sqlite_SQLiteDebug$getDatabaseInfo() {
        PagerStats stats = new PagerStats();
        SQLiteDebug.nativeGetPagerStats(stats);
        stats.dbStats = SQLiteDatabase.getDbStats();
        return stats;
    }

    private static final void $$robo$$android_database_sqlite_SQLiteDebug$dump(Printer printer, String[] args) {
        boolean verbose = false;
        for (String arg : args) {
            if (!arg.equals("-v")) continue;
            verbose = true;
        }
        SQLiteDatabase.dumpAll(printer, verbose);
    }

    static void __staticInitializer__() {
        DEBUG_SQL_LOG = Log.isLoggable("SQLiteLog", 2);
        DEBUG_SQL_STATEMENTS = Log.isLoggable("SQLiteStatements", 2);
        DEBUG_SQL_TIME = Log.isLoggable("SQLiteTime", 2);
        DEBUG_LOG_SLOW_QUERIES = Build.IS_DEBUGGABLE;
    }

    private static void nativeGetPagerStats(PagerStats pagerStats) {
        InvokeDynamicSupport.bootstrapStatic("nativeGetPagerStats", $$robo$$android_database_sqlite_SQLiteDebug$nativeGetPagerStats(android.database.sqlite.SQLiteDebug$PagerStats ), (PagerStats)pagerStats);
    }

    private void __constructor__() {
        this.$$robo$$android_database_sqlite_SQLiteDebug$__constructor__();
    }

    public SQLiteDebug() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_database_sqlite_SQLiteDebug$__constructor__(), this);
    }

    public static boolean shouldLogSlowQuery(long l) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("shouldLogSlowQuery", $$robo$$android_database_sqlite_SQLiteDebug$shouldLogSlowQuery(long ), (long)l);
    }

    public static PagerStats getDatabaseInfo() {
        return InvokeDynamicSupport.bootstrapStatic("getDatabaseInfo", $$robo$$android_database_sqlite_SQLiteDebug$getDatabaseInfo());
    }

    public static void dump(Printer printer, String[] stringArray) {
        InvokeDynamicSupport.bootstrapStatic("dump", $$robo$$android_database_sqlite_SQLiteDebug$dump(android.util.Printer java.lang.String[] ), (Printer)printer, (String[])stringArray);
    }

    static {
        RobolectricInternals.classInitializing(SQLiteDebug.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SQLiteDebug)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class DbStats
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public String dbName;
        public long pageSize;
        public long dbSize;
        public int lookaside;
        public String cache;

        private void $$robo$$android_database_sqlite_SQLiteDebug_DbStats$__constructor__(String dbName, long pageCount, long pageSize, int lookaside, int hits, int misses, int cachesize) {
            this.dbName = dbName;
            this.pageSize = pageSize / 1024L;
            this.dbSize = pageCount * pageSize / 1024L;
            this.lookaside = lookaside;
            this.cache = hits + "/" + misses + "/" + cachesize;
        }

        private void __constructor__(String string2, long l, long l2, int n, int n2, int n3, int n4) {
            this.$$robo$$android_database_sqlite_SQLiteDebug_DbStats$__constructor__(string2, l, l2, n, n2, n3, n4);
        }

        public DbStats(String string2, long l, long l2, int n, int n2, int n3, int n4) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_database_sqlite_SQLiteDebug_DbStats$__constructor__(java.lang.String long long int int int int ), this, string2, l, l2, n, n2, n3, n4);
        }

        public /* synthetic */ DbStats() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DbStats)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class PagerStats
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public int memoryUsed;
        public int pageCacheOverflow;
        public int largestMemAlloc;
        public ArrayList<DbStats> dbStats;

        private void $$robo$$android_database_sqlite_SQLiteDebug_PagerStats$__constructor__() {
        }

        private void __constructor__() {
            this.$$robo$$android_database_sqlite_SQLiteDebug_PagerStats$__constructor__();
        }

        public PagerStats() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_database_sqlite_SQLiteDebug_PagerStats$__constructor__(), this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PagerStats)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

