/*
 * Decompiled with CFR 0.152.
 */
package android.content.res;

import android.content.pm.ActivityInfo;
import android.content.res.AssetManager;
import android.content.res.ColorStateList;
import android.content.res.ComplexColor;
import android.content.res.Resources;
import android.content.res.XmlBlock;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.os.StrictMode;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import com.android.internal.util.XmlUtils;
import dalvik.system.VMRuntime;
import java.util.Arrays;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class TypedArray
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private Resources mResources;
    private DisplayMetrics mMetrics;
    private AssetManager mAssets;
    private boolean mRecycled;
    XmlBlock.Parser mXml;
    Resources.Theme mTheme;
    int[] mData;
    long mDataAddress;
    int[] mIndices;
    long mIndicesAddress;
    int mLength;
    TypedValue mValue;

    private static final TypedArray $$robo$$android_content_res_TypedArray$obtain(Resources res, int len) {
        TypedArray attrs = res.mTypedArrayPool.acquire();
        if (attrs == null) {
            attrs = new TypedArray(res);
        }
        attrs.mRecycled = false;
        attrs.mAssets = res.getAssets();
        attrs.mMetrics = res.getDisplayMetrics();
        attrs.resize(len);
        return attrs;
    }

    private final void $$robo$$android_content_res_TypedArray$resize(int len) {
        this.mLength = len;
        int dataLen = len * 6;
        int indicesLen = len + 1;
        VMRuntime runtime = VMRuntime.getRuntime();
        if (this.mDataAddress == 0L || this.mData.length < dataLen) {
            this.mData = (int[])runtime.newNonMovableArray(Integer.TYPE, dataLen);
            this.mDataAddress = runtime.addressOf(this.mData);
            this.mIndices = (int[])runtime.newNonMovableArray(Integer.TYPE, indicesLen);
            this.mIndicesAddress = runtime.addressOf(this.mIndices);
        }
    }

    private final int $$robo$$android_content_res_TypedArray$length() {
        if (this.mRecycled) {
            throw new RuntimeException("Cannot make calls to a recycled instance!");
        }
        return this.mLength;
    }

    private final int $$robo$$android_content_res_TypedArray$getIndexCount() {
        if (this.mRecycled) {
            throw new RuntimeException("Cannot make calls to a recycled instance!");
        }
        return this.mIndices[0];
    }

    private final int $$robo$$android_content_res_TypedArray$getIndex(int at) {
        if (this.mRecycled) {
            throw new RuntimeException("Cannot make calls to a recycled instance!");
        }
        return this.mIndices[1 + at];
    }

    private final Resources $$robo$$android_content_res_TypedArray$getResources() {
        if (this.mRecycled) {
            throw new RuntimeException("Cannot make calls to a recycled instance!");
        }
        return this.mResources;
    }

    private final CharSequence $$robo$$android_content_res_TypedArray$getText(int index) {
        if (this.mRecycled) {
            throw new RuntimeException("Cannot make calls to a recycled instance!");
        }
        int[] data = this.mData;
        int type = data[(index *= 6) + 0];
        if (type == 0) {
            return null;
        }
        if (type == 3) {
            return this.loadStringValueAt(index);
        }
        TypedValue v = this.mValue;
        if (this.getValueAt(index, v)) {
            return v.coerceToString();
        }
        throw new RuntimeException("getText of bad type: 0x" + Integer.toHexString(type));
    }

    private final String $$robo$$android_content_res_TypedArray$getString(int index) {
        if (this.mRecycled) {
            throw new RuntimeException("Cannot make calls to a recycled instance!");
        }
        int[] data = this.mData;
        int type = data[(index *= 6) + 0];
        if (type == 0) {
            return null;
        }
        if (type == 3) {
            return this.loadStringValueAt(index).toString();
        }
        TypedValue v = this.mValue;
        if (this.getValueAt(index, v)) {
            CharSequence cs = v.coerceToString();
            return cs != null ? cs.toString() : null;
        }
        throw new RuntimeException("getString of bad type: 0x" + Integer.toHexString(type));
    }

    private final String $$robo$$android_content_res_TypedArray$getNonResourceString(int index) {
        int cookie;
        if (this.mRecycled) {
            throw new RuntimeException("Cannot make calls to a recycled instance!");
        }
        int[] data = this.mData;
        int type = data[(index *= 6) + 0];
        if (type == 3 && (cookie = data[index + 2]) < 0) {
            return this.mXml.getPooledString(data[index + 1]).toString();
        }
        return null;
    }

    private final String $$robo$$android_content_res_TypedArray$getNonConfigurationString(int index, int allowedChangingConfigs) {
        if (this.mRecycled) {
            throw new RuntimeException("Cannot make calls to a recycled instance!");
        }
        int[] data = this.mData;
        int type = data[(index *= 6) + 0];
        int changingConfigs = ActivityInfo.activityInfoConfigNativeToJava(data[index + 4]);
        if ((changingConfigs & ~allowedChangingConfigs) != 0) {
            return null;
        }
        if (type == 0) {
            return null;
        }
        if (type == 3) {
            return this.loadStringValueAt(index).toString();
        }
        TypedValue v = this.mValue;
        if (this.getValueAt(index, v)) {
            CharSequence cs = v.coerceToString();
            return cs != null ? cs.toString() : null;
        }
        throw new RuntimeException("getNonConfigurationString of bad type: 0x" + Integer.toHexString(type));
    }

    private final boolean $$robo$$android_content_res_TypedArray$getBoolean(int index, boolean defValue) {
        if (this.mRecycled) {
            throw new RuntimeException("Cannot make calls to a recycled instance!");
        }
        int[] data = this.mData;
        int type = data[(index *= 6) + 0];
        if (type == 0) {
            return defValue;
        }
        if (type >= 16 && type <= 31) {
            return data[index + 1] != 0;
        }
        TypedValue v = this.mValue;
        if (this.getValueAt(index, v)) {
            StrictMode.noteResourceMismatch(v);
            return XmlUtils.convertValueToBoolean(v.coerceToString(), defValue);
        }
        throw new RuntimeException("getBoolean of bad type: 0x" + Integer.toHexString(type));
    }

    private final int $$robo$$android_content_res_TypedArray$getInt(int index, int defValue) {
        if (this.mRecycled) {
            throw new RuntimeException("Cannot make calls to a recycled instance!");
        }
        int[] data = this.mData;
        int type = data[(index *= 6) + 0];
        if (type == 0) {
            return defValue;
        }
        if (type >= 16 && type <= 31) {
            return data[index + 1];
        }
        TypedValue v = this.mValue;
        if (this.getValueAt(index, v)) {
            StrictMode.noteResourceMismatch(v);
            return XmlUtils.convertValueToInt(v.coerceToString(), defValue);
        }
        throw new RuntimeException("getInt of bad type: 0x" + Integer.toHexString(type));
    }

    private final float $$robo$$android_content_res_TypedArray$getFloat(int index, float defValue) {
        CharSequence str;
        if (this.mRecycled) {
            throw new RuntimeException("Cannot make calls to a recycled instance!");
        }
        int[] data = this.mData;
        int type = data[(index *= 6) + 0];
        if (type == 0) {
            return defValue;
        }
        if (type == 4) {
            return Float.intBitsToFloat(data[index + 1]);
        }
        if (type >= 16 && type <= 31) {
            return data[index + 1];
        }
        TypedValue v = this.mValue;
        if (this.getValueAt(index, v) && (str = v.coerceToString()) != null) {
            StrictMode.noteResourceMismatch(v);
            return Float.parseFloat(str.toString());
        }
        throw new RuntimeException("getFloat of bad type: 0x" + Integer.toHexString(type));
    }

    private final int $$robo$$android_content_res_TypedArray$getColor(int index, int defValue) {
        if (this.mRecycled) {
            throw new RuntimeException("Cannot make calls to a recycled instance!");
        }
        int attrIndex = index;
        int[] data = this.mData;
        int type = data[(index *= 6) + 0];
        if (type == 0) {
            return defValue;
        }
        if (type >= 16 && type <= 31) {
            return data[index + 1];
        }
        if (type == 3) {
            TypedValue value = this.mValue;
            if (this.getValueAt(index, value)) {
                ColorStateList csl = this.mResources.loadColorStateList(value, value.resourceId, this.mTheme);
                return csl.getDefaultColor();
            }
            return defValue;
        }
        if (type == 2) {
            TypedValue value = this.mValue;
            this.getValueAt(index, value);
            throw new UnsupportedOperationException("Failed to resolve attribute at index " + attrIndex + ": " + value);
        }
        throw new UnsupportedOperationException("Can't convert value at index " + attrIndex + " to color: type=0x" + Integer.toHexString(type));
    }

    private final ComplexColor $$robo$$android_content_res_TypedArray$getComplexColor(int index) {
        if (this.mRecycled) {
            throw new RuntimeException("Cannot make calls to a recycled instance!");
        }
        TypedValue value = this.mValue;
        if (this.getValueAt(index * 6, value)) {
            if (value.type == 2) {
                throw new UnsupportedOperationException("Failed to resolve attribute at index " + index + ": " + value);
            }
            return this.mResources.loadComplexColor(value, value.resourceId, this.mTheme);
        }
        return null;
    }

    private final ColorStateList $$robo$$android_content_res_TypedArray$getColorStateList(int index) {
        if (this.mRecycled) {
            throw new RuntimeException("Cannot make calls to a recycled instance!");
        }
        TypedValue value = this.mValue;
        if (this.getValueAt(index * 6, value)) {
            if (value.type == 2) {
                throw new UnsupportedOperationException("Failed to resolve attribute at index " + index + ": " + value);
            }
            return this.mResources.loadColorStateList(value, value.resourceId, this.mTheme);
        }
        return null;
    }

    private final int $$robo$$android_content_res_TypedArray$getInteger(int index, int defValue) {
        if (this.mRecycled) {
            throw new RuntimeException("Cannot make calls to a recycled instance!");
        }
        int attrIndex = index;
        int[] data = this.mData;
        int type = data[(index *= 6) + 0];
        if (type == 0) {
            return defValue;
        }
        if (type >= 16 && type <= 31) {
            return data[index + 1];
        }
        if (type == 2) {
            TypedValue value = this.mValue;
            this.getValueAt(index, value);
            throw new UnsupportedOperationException("Failed to resolve attribute at index " + attrIndex + ": " + value);
        }
        throw new UnsupportedOperationException("Can't convert value at index " + attrIndex + " to integer: type=0x" + Integer.toHexString(type));
    }

    private final float $$robo$$android_content_res_TypedArray$getDimension(int index, float defValue) {
        if (this.mRecycled) {
            throw new RuntimeException("Cannot make calls to a recycled instance!");
        }
        int attrIndex = index;
        int[] data = this.mData;
        int type = data[(index *= 6) + 0];
        if (type == 0) {
            return defValue;
        }
        if (type == 5) {
            return TypedValue.complexToDimension(data[index + 1], this.mMetrics);
        }
        if (type == 2) {
            TypedValue value = this.mValue;
            this.getValueAt(index, value);
            throw new UnsupportedOperationException("Failed to resolve attribute at index " + attrIndex + ": " + value);
        }
        throw new UnsupportedOperationException("Can't convert value at index " + attrIndex + " to dimension: type=0x" + Integer.toHexString(type));
    }

    private final int $$robo$$android_content_res_TypedArray$getDimensionPixelOffset(int index, int defValue) {
        if (this.mRecycled) {
            throw new RuntimeException("Cannot make calls to a recycled instance!");
        }
        int attrIndex = index;
        int[] data = this.mData;
        int type = data[(index *= 6) + 0];
        if (type == 0) {
            return defValue;
        }
        if (type == 5) {
            return TypedValue.complexToDimensionPixelOffset(data[index + 1], this.mMetrics);
        }
        if (type == 2) {
            TypedValue value = this.mValue;
            this.getValueAt(index, value);
            throw new UnsupportedOperationException("Failed to resolve attribute at index " + attrIndex + ": " + value);
        }
        throw new UnsupportedOperationException("Can't convert value at index " + attrIndex + " to dimension: type=0x" + Integer.toHexString(type));
    }

    private final int $$robo$$android_content_res_TypedArray$getDimensionPixelSize(int index, int defValue) {
        if (this.mRecycled) {
            throw new RuntimeException("Cannot make calls to a recycled instance!");
        }
        int attrIndex = index;
        int[] data = this.mData;
        int type = data[(index *= 6) + 0];
        if (type == 0) {
            return defValue;
        }
        if (type == 5) {
            return TypedValue.complexToDimensionPixelSize(data[index + 1], this.mMetrics);
        }
        if (type == 2) {
            TypedValue value = this.mValue;
            this.getValueAt(index, value);
            throw new UnsupportedOperationException("Failed to resolve attribute at index " + attrIndex + ": " + value);
        }
        throw new UnsupportedOperationException("Can't convert value at index " + attrIndex + " to dimension: type=0x" + Integer.toHexString(type));
    }

    private final int $$robo$$android_content_res_TypedArray$getLayoutDimension(int index, String name) {
        if (this.mRecycled) {
            throw new RuntimeException("Cannot make calls to a recycled instance!");
        }
        int attrIndex = index;
        int[] data = this.mData;
        int type = data[(index *= 6) + 0];
        if (type >= 16 && type <= 31) {
            return data[index + 1];
        }
        if (type == 5) {
            return TypedValue.complexToDimensionPixelSize(data[index + 1], this.mMetrics);
        }
        if (type == 2) {
            TypedValue value = this.mValue;
            this.getValueAt(index, value);
            throw new UnsupportedOperationException("Failed to resolve attribute at index " + attrIndex + ": " + value);
        }
        throw new UnsupportedOperationException(this.getPositionDescription() + ": You must supply a " + name + " attribute.");
    }

    private final int $$robo$$android_content_res_TypedArray$getLayoutDimension(int index, int defValue) {
        if (this.mRecycled) {
            throw new RuntimeException("Cannot make calls to a recycled instance!");
        }
        int[] data = this.mData;
        int type = data[(index *= 6) + 0];
        if (type >= 16 && type <= 31) {
            return data[index + 1];
        }
        if (type == 5) {
            return TypedValue.complexToDimensionPixelSize(data[index + 1], this.mMetrics);
        }
        return defValue;
    }

    private final float $$robo$$android_content_res_TypedArray$getFraction(int index, int base, int pbase, float defValue) {
        if (this.mRecycled) {
            throw new RuntimeException("Cannot make calls to a recycled instance!");
        }
        int attrIndex = index;
        int[] data = this.mData;
        int type = data[(index *= 6) + 0];
        if (type == 0) {
            return defValue;
        }
        if (type == 6) {
            return TypedValue.complexToFraction(data[index + 1], base, pbase);
        }
        if (type == 2) {
            TypedValue value = this.mValue;
            this.getValueAt(index, value);
            throw new UnsupportedOperationException("Failed to resolve attribute at index " + attrIndex + ": " + value);
        }
        throw new UnsupportedOperationException("Can't convert value at index " + attrIndex + " to fraction: type=0x" + Integer.toHexString(type));
    }

    private final int $$robo$$android_content_res_TypedArray$getResourceId(int index, int defValue) {
        int resid;
        if (this.mRecycled) {
            throw new RuntimeException("Cannot make calls to a recycled instance!");
        }
        int[] data = this.mData;
        if (data[(index *= 6) + 0] != 0 && (resid = data[index + 3]) != 0) {
            return resid;
        }
        return defValue;
    }

    private final int $$robo$$android_content_res_TypedArray$getThemeAttributeId(int index, int defValue) {
        if (this.mRecycled) {
            throw new RuntimeException("Cannot make calls to a recycled instance!");
        }
        int[] data = this.mData;
        if (data[(index *= 6) + 0] == 2) {
            return data[index + 1];
        }
        return defValue;
    }

    private final Drawable $$robo$$android_content_res_TypedArray$getDrawable(int index) {
        return this.getDrawableForDensity(index, 0);
    }

    private final Drawable $$robo$$android_content_res_TypedArray$getDrawableForDensity(int index, int density) {
        if (this.mRecycled) {
            throw new RuntimeException("Cannot make calls to a recycled instance!");
        }
        TypedValue value = this.mValue;
        if (this.getValueAt(index * 6, value)) {
            if (value.type == 2) {
                throw new UnsupportedOperationException("Failed to resolve attribute at index " + index + ": " + value);
            }
            if (density > 0) {
                this.mResources.getValueForDensity(value.resourceId, density, value, true);
            }
            return this.mResources.loadDrawable(value, value.resourceId, density, this.mTheme);
        }
        return null;
    }

    private final Typeface $$robo$$android_content_res_TypedArray$getFont(int index) {
        if (this.mRecycled) {
            throw new RuntimeException("Cannot make calls to a recycled instance!");
        }
        TypedValue value = this.mValue;
        if (this.getValueAt(index * 6, value)) {
            if (value.type == 2) {
                throw new UnsupportedOperationException("Failed to resolve attribute at index " + index + ": " + value);
            }
            return this.mResources.getFont(value, value.resourceId);
        }
        return null;
    }

    private final CharSequence[] $$robo$$android_content_res_TypedArray$getTextArray(int index) {
        if (this.mRecycled) {
            throw new RuntimeException("Cannot make calls to a recycled instance!");
        }
        TypedValue value = this.mValue;
        if (this.getValueAt(index * 6, value)) {
            return this.mResources.getTextArray(value.resourceId);
        }
        return null;
    }

    private final boolean $$robo$$android_content_res_TypedArray$getValue(int index, TypedValue outValue) {
        if (this.mRecycled) {
            throw new RuntimeException("Cannot make calls to a recycled instance!");
        }
        return this.getValueAt(index * 6, outValue);
    }

    private final int $$robo$$android_content_res_TypedArray$getType(int index) {
        if (this.mRecycled) {
            throw new RuntimeException("Cannot make calls to a recycled instance!");
        }
        return this.mData[(index *= 6) + 0];
    }

    private final boolean $$robo$$android_content_res_TypedArray$hasValue(int index) {
        if (this.mRecycled) {
            throw new RuntimeException("Cannot make calls to a recycled instance!");
        }
        int[] data = this.mData;
        int type = data[(index *= 6) + 0];
        return type != 0;
    }

    private final boolean $$robo$$android_content_res_TypedArray$hasValueOrEmpty(int index) {
        if (this.mRecycled) {
            throw new RuntimeException("Cannot make calls to a recycled instance!");
        }
        int[] data = this.mData;
        int type = data[(index *= 6) + 0];
        return type != 0 || data[index + 1] == 1;
    }

    private final TypedValue $$robo$$android_content_res_TypedArray$peekValue(int index) {
        if (this.mRecycled) {
            throw new RuntimeException("Cannot make calls to a recycled instance!");
        }
        TypedValue value = this.mValue;
        if (this.getValueAt(index * 6, value)) {
            return value;
        }
        return null;
    }

    private final String $$robo$$android_content_res_TypedArray$getPositionDescription() {
        if (this.mRecycled) {
            throw new RuntimeException("Cannot make calls to a recycled instance!");
        }
        return this.mXml != null ? this.mXml.getPositionDescription() : "<internal>";
    }

    private final void $$robo$$android_content_res_TypedArray$recycle() {
        if (this.mRecycled) {
            throw new RuntimeException(this.toString() + " recycled twice!");
        }
        this.mRecycled = true;
        this.mXml = null;
        this.mTheme = null;
        this.mAssets = null;
        this.mResources.mTypedArrayPool.release(this);
    }

    private final int[] $$robo$$android_content_res_TypedArray$extractThemeAttrs() {
        return this.extractThemeAttrs(null);
    }

    private final int[] $$robo$$android_content_res_TypedArray$extractThemeAttrs(int[] scrap) {
        if (this.mRecycled) {
            throw new RuntimeException("Cannot make calls to a recycled instance!");
        }
        int[] attrs = null;
        int[] data = this.mData;
        int N = this.length();
        for (int i = 0; i < N; ++i) {
            int index = i * 6;
            if (data[index + 0] != 2) continue;
            data[index + 0] = 0;
            int attr2 = data[index + 1];
            if (attr2 == 0) continue;
            if (attrs == null) {
                if (scrap != null && scrap.length == N) {
                    attrs = scrap;
                    Arrays.fill(attrs, 0);
                } else {
                    attrs = new int[N];
                }
            }
            attrs[i] = attr2;
        }
        return attrs;
    }

    private final int $$robo$$android_content_res_TypedArray$getChangingConfigurations() {
        if (this.mRecycled) {
            throw new RuntimeException("Cannot make calls to a recycled instance!");
        }
        int changingConfig = 0;
        int[] data = this.mData;
        int N = this.length();
        for (int i = 0; i < N; ++i) {
            int index = i * 6;
            int type = data[index + 0];
            if (type == 0) continue;
            changingConfig |= ActivityInfo.activityInfoConfigNativeToJava(data[index + 4]);
        }
        return changingConfig;
    }

    private final boolean $$robo$$android_content_res_TypedArray$getValueAt(int index, TypedValue outValue) {
        int[] data = this.mData;
        int type = data[index + 0];
        if (type == 0) {
            return false;
        }
        outValue.type = type;
        outValue.data = data[index + 1];
        outValue.assetCookie = data[index + 2];
        outValue.resourceId = data[index + 3];
        outValue.changingConfigurations = ActivityInfo.activityInfoConfigNativeToJava(data[index + 4]);
        outValue.density = data[index + 5];
        outValue.string = type == 3 ? this.loadStringValueAt(index) : null;
        return true;
    }

    private final CharSequence $$robo$$android_content_res_TypedArray$loadStringValueAt(int index) {
        int[] data = this.mData;
        int cookie = data[index + 2];
        if (cookie < 0) {
            if (this.mXml != null) {
                return this.mXml.getPooledString(data[index + 1]);
            }
            return null;
        }
        return this.mAssets.getPooledStringForCookie(cookie, data[index + 1]);
    }

    private void $$robo$$android_content_res_TypedArray$__constructor__(Resources resources) {
        this.mValue = new TypedValue();
        this.mResources = resources;
        this.mMetrics = this.mResources.getDisplayMetrics();
        this.mAssets = this.mResources.getAssets();
    }

    private final String $$robo$$android_content_res_TypedArray$toString() {
        return Arrays.toString(this.mData);
    }

    static TypedArray obtain(Resources resources, int n) {
        return InvokeDynamicSupport.bootstrapStatic("obtain", $$robo$$android_content_res_TypedArray$obtain(android.content.res.Resources int ), (Resources)resources, (int)n);
    }

    private void resize(int n) {
        InvokeDynamicSupport.bootstrap("resize", $$robo$$android_content_res_TypedArray$resize(int ), this, n);
    }

    public int length() {
        return (int)InvokeDynamicSupport.bootstrap("length", $$robo$$android_content_res_TypedArray$length(), this);
    }

    public int getIndexCount() {
        return (int)InvokeDynamicSupport.bootstrap("getIndexCount", $$robo$$android_content_res_TypedArray$getIndexCount(), this);
    }

    public int getIndex(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getIndex", $$robo$$android_content_res_TypedArray$getIndex(int ), this, n);
    }

    public Resources getResources() {
        return InvokeDynamicSupport.bootstrap("getResources", $$robo$$android_content_res_TypedArray$getResources(), this);
    }

    public CharSequence getText(int n) {
        return InvokeDynamicSupport.bootstrap("getText", $$robo$$android_content_res_TypedArray$getText(int ), this, n);
    }

    public String getString(int n) {
        return InvokeDynamicSupport.bootstrap("getString", $$robo$$android_content_res_TypedArray$getString(int ), this, n);
    }

    public String getNonResourceString(int n) {
        return InvokeDynamicSupport.bootstrap("getNonResourceString", $$robo$$android_content_res_TypedArray$getNonResourceString(int ), this, n);
    }

    public String getNonConfigurationString(int n, int n2) {
        return InvokeDynamicSupport.bootstrap("getNonConfigurationString", $$robo$$android_content_res_TypedArray$getNonConfigurationString(int int ), this, n, n2);
    }

    public boolean getBoolean(int n, boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("getBoolean", $$robo$$android_content_res_TypedArray$getBoolean(int boolean ), this, n, bl);
    }

    public int getInt(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("getInt", $$robo$$android_content_res_TypedArray$getInt(int int ), this, n, n2);
    }

    public float getFloat(int n, float f) {
        return (float)InvokeDynamicSupport.bootstrap("getFloat", $$robo$$android_content_res_TypedArray$getFloat(int float ), this, n, f);
    }

    public int getColor(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("getColor", $$robo$$android_content_res_TypedArray$getColor(int int ), this, n, n2);
    }

    public ComplexColor getComplexColor(int n) {
        return InvokeDynamicSupport.bootstrap("getComplexColor", $$robo$$android_content_res_TypedArray$getComplexColor(int ), this, n);
    }

    public ColorStateList getColorStateList(int n) {
        return InvokeDynamicSupport.bootstrap("getColorStateList", $$robo$$android_content_res_TypedArray$getColorStateList(int ), this, n);
    }

    public int getInteger(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("getInteger", $$robo$$android_content_res_TypedArray$getInteger(int int ), this, n, n2);
    }

    public float getDimension(int n, float f) {
        return (float)InvokeDynamicSupport.bootstrap("getDimension", $$robo$$android_content_res_TypedArray$getDimension(int float ), this, n, f);
    }

    public int getDimensionPixelOffset(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("getDimensionPixelOffset", $$robo$$android_content_res_TypedArray$getDimensionPixelOffset(int int ), this, n, n2);
    }

    public int getDimensionPixelSize(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("getDimensionPixelSize", $$robo$$android_content_res_TypedArray$getDimensionPixelSize(int int ), this, n, n2);
    }

    public int getLayoutDimension(int n, String string2) {
        return (int)InvokeDynamicSupport.bootstrap("getLayoutDimension", $$robo$$android_content_res_TypedArray$getLayoutDimension(int java.lang.String ), this, n, string2);
    }

    public int getLayoutDimension(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("getLayoutDimension", $$robo$$android_content_res_TypedArray$getLayoutDimension(int int ), this, n, n2);
    }

    public float getFraction(int n, int n2, int n3, float f) {
        return (float)InvokeDynamicSupport.bootstrap("getFraction", $$robo$$android_content_res_TypedArray$getFraction(int int int float ), this, n, n2, n3, f);
    }

    public int getResourceId(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("getResourceId", $$robo$$android_content_res_TypedArray$getResourceId(int int ), this, n, n2);
    }

    public int getThemeAttributeId(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("getThemeAttributeId", $$robo$$android_content_res_TypedArray$getThemeAttributeId(int int ), this, n, n2);
    }

    public Drawable getDrawable(int n) {
        return InvokeDynamicSupport.bootstrap("getDrawable", $$robo$$android_content_res_TypedArray$getDrawable(int ), this, n);
    }

    public Drawable getDrawableForDensity(int n, int n2) {
        return InvokeDynamicSupport.bootstrap("getDrawableForDensity", $$robo$$android_content_res_TypedArray$getDrawableForDensity(int int ), this, n, n2);
    }

    public Typeface getFont(int n) {
        return InvokeDynamicSupport.bootstrap("getFont", $$robo$$android_content_res_TypedArray$getFont(int ), this, n);
    }

    public CharSequence[] getTextArray(int n) {
        return InvokeDynamicSupport.bootstrap("getTextArray", $$robo$$android_content_res_TypedArray$getTextArray(int ), this, n);
    }

    public boolean getValue(int n, TypedValue typedValue) {
        return (boolean)InvokeDynamicSupport.bootstrap("getValue", $$robo$$android_content_res_TypedArray$getValue(int android.util.TypedValue ), this, n, typedValue);
    }

    public int getType(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getType", $$robo$$android_content_res_TypedArray$getType(int ), this, n);
    }

    public boolean hasValue(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("hasValue", $$robo$$android_content_res_TypedArray$hasValue(int ), this, n);
    }

    public boolean hasValueOrEmpty(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("hasValueOrEmpty", $$robo$$android_content_res_TypedArray$hasValueOrEmpty(int ), this, n);
    }

    public TypedValue peekValue(int n) {
        return InvokeDynamicSupport.bootstrap("peekValue", $$robo$$android_content_res_TypedArray$peekValue(int ), this, n);
    }

    public String getPositionDescription() {
        return InvokeDynamicSupport.bootstrap("getPositionDescription", $$robo$$android_content_res_TypedArray$getPositionDescription(), this);
    }

    public void recycle() {
        InvokeDynamicSupport.bootstrap("recycle", $$robo$$android_content_res_TypedArray$recycle(), this);
    }

    public int[] extractThemeAttrs() {
        return InvokeDynamicSupport.bootstrap("extractThemeAttrs", $$robo$$android_content_res_TypedArray$extractThemeAttrs(), this);
    }

    public int[] extractThemeAttrs(int[] nArray) {
        return InvokeDynamicSupport.bootstrap("extractThemeAttrs", $$robo$$android_content_res_TypedArray$extractThemeAttrs(int[] ), this, nArray);
    }

    public int getChangingConfigurations() {
        return (int)InvokeDynamicSupport.bootstrap("getChangingConfigurations", $$robo$$android_content_res_TypedArray$getChangingConfigurations(), this);
    }

    private boolean getValueAt(int n, TypedValue typedValue) {
        return (boolean)InvokeDynamicSupport.bootstrap("getValueAt", $$robo$$android_content_res_TypedArray$getValueAt(int android.util.TypedValue ), this, n, typedValue);
    }

    private CharSequence loadStringValueAt(int n) {
        return InvokeDynamicSupport.bootstrap("loadStringValueAt", $$robo$$android_content_res_TypedArray$loadStringValueAt(int ), this, n);
    }

    private void __constructor__(Resources resources) {
        this.$$robo$$android_content_res_TypedArray$__constructor__(resources);
    }

    public TypedArray(Resources resources) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_res_TypedArray$__constructor__(android.content.res.Resources ), this, resources);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_content_res_TypedArray$toString(), this);
    }

    public /* synthetic */ TypedArray() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TypedArray)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

