/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm;

import android.os.Parcel;
import android.os.Parcelable;
import com.android.internal.util.ArrayUtils;
import java.io.ByteArrayInputStream;
import java.lang.ref.SoftReference;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class Signature
implements Parcelable,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private byte[] mSignature;
    private int mHashCode;
    private boolean mHaveHashCode;
    private SoftReference<String> mStringRef;
    private Certificate[] mCertificateChain;
    public static Parcelable.Creator<Signature> CREATOR;

    private void $$robo$$android_content_pm_Signature$__constructor__(byte[] signature) {
        this.mSignature = (byte[])signature.clone();
        this.mCertificateChain = null;
    }

    private void $$robo$$android_content_pm_Signature$__constructor__(Certificate[] certificateChain) throws CertificateEncodingException {
        this.mSignature = certificateChain[0].getEncoded();
        if (certificateChain.length > 1) {
            this.mCertificateChain = Arrays.copyOfRange(certificateChain, 1, certificateChain.length);
        }
    }

    private static final int $$robo$$android_content_pm_Signature$parseHexDigit(int nibble) {
        if (48 <= nibble && nibble <= 57) {
            return nibble - 48;
        }
        if (97 <= nibble && nibble <= 102) {
            return nibble - 97 + 10;
        }
        if (65 <= nibble && nibble <= 70) {
            return nibble - 65 + 10;
        }
        throw new IllegalArgumentException("Invalid character " + nibble + " in hex string");
    }

    private void $$robo$$android_content_pm_Signature$__constructor__(String text) {
        byte[] input = text.getBytes();
        int N = input.length;
        if (N % 2 != 0) {
            throw new IllegalArgumentException("text size " + N + " is not even");
        }
        byte[] sig = new byte[N / 2];
        int sigIndex = 0;
        int i = 0;
        while (i < N) {
            int hi = Signature.parseHexDigit(input[i++]);
            int lo = Signature.parseHexDigit(input[i++]);
            sig[sigIndex++] = (byte)(hi << 4 | lo);
        }
        this.mSignature = sig;
    }

    private final char[] $$robo$$android_content_pm_Signature$toChars() {
        return this.toChars(null, null);
    }

    private final char[] $$robo$$android_content_pm_Signature$toChars(char[] existingArray, int[] outLen) {
        byte[] sig = this.mSignature;
        int N = sig.length;
        int N2 = N * 2;
        char[] text = existingArray == null || N2 > existingArray.length ? new char[N2] : existingArray;
        for (int j = 0; j < N; ++j) {
            byte v = sig[j];
            int d = v >> 4 & 0xF;
            text[j * 2] = (char)(d >= 10 ? 97 + d - 10 : 48 + d);
            d = v & 0xF;
            text[j * 2 + 1] = (char)(d >= 10 ? 97 + d - 10 : 48 + d);
        }
        if (outLen != null) {
            outLen[0] = N;
        }
        return text;
    }

    private final String $$robo$$android_content_pm_Signature$toCharsString() {
        String str;
        String string2 = str = this.mStringRef == null ? null : this.mStringRef.get();
        if (str != null) {
            return str;
        }
        str = new String(this.toChars());
        this.mStringRef = new SoftReference<String>(str);
        return str;
    }

    private final byte[] $$robo$$android_content_pm_Signature$toByteArray() {
        byte[] bytes = new byte[this.mSignature.length];
        InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (byte[])this.mSignature, (int)0, (byte[])bytes, (int)0, (int)this.mSignature.length);
        return bytes;
    }

    private final PublicKey $$robo$$android_content_pm_Signature$getPublicKey() throws CertificateException {
        CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
        ByteArrayInputStream bais = new ByteArrayInputStream(this.mSignature);
        Certificate cert = certFactory.generateCertificate(bais);
        return cert.getPublicKey();
    }

    private final Signature[] $$robo$$android_content_pm_Signature$getChainSignatures() throws CertificateEncodingException {
        if (this.mCertificateChain == null) {
            return new Signature[]{this};
        }
        Signature[] chain = new Signature[1 + this.mCertificateChain.length];
        chain[0] = this;
        int i = 1;
        for (Certificate c : this.mCertificateChain) {
            chain[i++] = new Signature(c.getEncoded());
        }
        return chain;
    }

    private final boolean $$robo$$android_content_pm_Signature$equals(Object obj) {
        try {
            if (obj != null) {
                Signature other = (Signature)obj;
                return this == other || Arrays.equals(this.mSignature, other.mSignature);
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return false;
    }

    private final int $$robo$$android_content_pm_Signature$hashCode() {
        if (this.mHaveHashCode) {
            return this.mHashCode;
        }
        this.mHashCode = Arrays.hashCode(this.mSignature);
        this.mHaveHashCode = true;
        return this.mHashCode;
    }

    private final int $$robo$$android_content_pm_Signature$describeContents() {
        return 0;
    }

    private final void $$robo$$android_content_pm_Signature$writeToParcel(Parcel dest, int parcelableFlags) {
        dest.writeByteArray(this.mSignature);
    }

    private void $$robo$$android_content_pm_Signature$__constructor__(Parcel source) {
        this.mSignature = source.createByteArray();
    }

    private static final boolean $$robo$$android_content_pm_Signature$areExactMatch(Signature[] a, Signature[] b) {
        return a.length == b.length && ArrayUtils.containsAll(a, b) && ArrayUtils.containsAll(b, a);
    }

    private static final boolean $$robo$$android_content_pm_Signature$areEffectiveMatch(Signature[] a, Signature[] b) throws CertificateException {
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        Signature[] aPrime = new Signature[a.length];
        for (int i = 0; i < a.length; ++i) {
            aPrime[i] = Signature.bounce(cf, a[i]);
        }
        Signature[] bPrime = new Signature[b.length];
        for (int i = 0; i < b.length; ++i) {
            bPrime[i] = Signature.bounce(cf, b[i]);
        }
        return Signature.areExactMatch(aPrime, bPrime);
    }

    private static final Signature $$robo$$android_content_pm_Signature$bounce(CertificateFactory cf, Signature s) throws CertificateException {
        ByteArrayInputStream is = new ByteArrayInputStream(s.mSignature);
        X509Certificate cert = (X509Certificate)cf.generateCertificate(is);
        Signature sPrime = new Signature(cert.getEncoded());
        if (Math.abs(sPrime.mSignature.length - s.mSignature.length) > 2) {
            throw new CertificateException("Bounced cert length looks fishy; before " + s.mSignature.length + ", after " + sPrime.mSignature.length);
        }
        return sPrime;
    }

    private /* synthetic */ void $$robo$$android_content_pm_Signature$__constructor__(Parcel x0, 1 x1) {
    }

    static void __staticInitializer__() {
        CREATOR = new Parcelable.Creator<Signature>(){
            public /* synthetic */ Object __robo_data__;

            private void $$robo$$android_content_pm_Signature_1$__constructor__() {
            }

            private final Signature $$robo$$android_content_pm_Signature_1$createFromParcel(Parcel source) {
                return new Signature(source, null);
            }

            private final Signature[] $$robo$$android_content_pm_Signature_1$newArray(int size) {
                return new Signature[size];
            }

            private void __constructor__() {
                this.$$robo$$android_content_pm_Signature_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_Signature_1$__constructor__(), this);
            }

            @Override
            public Signature createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_content_pm_Signature_1$createFromParcel(android.os.Parcel ), this, parcel);
            }

            public Signature[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_content_pm_Signature_1$newArray(int ), this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__(byte[] byArray) {
        this.$$robo$$android_content_pm_Signature$__constructor__(byArray);
    }

    public Signature(byte[] byArray) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_Signature$__constructor__(byte[] ), this, byArray);
    }

    private void __constructor__(Certificate[] certificateArray) throws CertificateEncodingException {
        this.$$robo$$android_content_pm_Signature$__constructor__(certificateArray);
    }

    public Signature(Certificate[] certificateArray) throws CertificateEncodingException {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_Signature$__constructor__(java.security.cert.Certificate[] ), this, certificateArray);
    }

    private static int parseHexDigit(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("parseHexDigit", $$robo$$android_content_pm_Signature$parseHexDigit(int ), (int)n);
    }

    private void __constructor__(String string2) {
        this.$$robo$$android_content_pm_Signature$__constructor__(string2);
    }

    public Signature(String string2) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_Signature$__constructor__(java.lang.String ), this, string2);
    }

    public char[] toChars() {
        return InvokeDynamicSupport.bootstrap("toChars", $$robo$$android_content_pm_Signature$toChars(), this);
    }

    public char[] toChars(char[] cArray, int[] nArray) {
        return InvokeDynamicSupport.bootstrap("toChars", $$robo$$android_content_pm_Signature$toChars(char[] int[] ), this, cArray, nArray);
    }

    public String toCharsString() {
        return InvokeDynamicSupport.bootstrap("toCharsString", $$robo$$android_content_pm_Signature$toCharsString(), this);
    }

    public byte[] toByteArray() {
        return InvokeDynamicSupport.bootstrap("toByteArray", $$robo$$android_content_pm_Signature$toByteArray(), this);
    }

    public PublicKey getPublicKey() throws CertificateException {
        return InvokeDynamicSupport.bootstrap("getPublicKey", $$robo$$android_content_pm_Signature$getPublicKey(), this);
    }

    public Signature[] getChainSignatures() throws CertificateEncodingException {
        return InvokeDynamicSupport.bootstrap("getChainSignatures", $$robo$$android_content_pm_Signature$getChainSignatures(), this);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_content_pm_Signature$equals(java.lang.Object ), this, object);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_content_pm_Signature$hashCode(), this);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_content_pm_Signature$describeContents(), this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_content_pm_Signature$writeToParcel(android.os.Parcel int ), this, parcel, n);
    }

    private void __constructor__(Parcel parcel) {
        this.$$robo$$android_content_pm_Signature$__constructor__(parcel);
    }

    public Signature(Parcel parcel) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_Signature$__constructor__(android.os.Parcel ), this, parcel);
    }

    public static boolean areExactMatch(Signature[] signatureArray, Signature[] signatureArray2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("areExactMatch", $$robo$$android_content_pm_Signature$areExactMatch(android.content.pm.Signature[] android.content.pm.Signature[] ), (Signature[])signatureArray, (Signature[])signatureArray2);
    }

    public static boolean areEffectiveMatch(Signature[] signatureArray, Signature[] signatureArray2) throws CertificateException {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("areEffectiveMatch", $$robo$$android_content_pm_Signature$areEffectiveMatch(android.content.pm.Signature[] android.content.pm.Signature[] ), (Signature[])signatureArray, (Signature[])signatureArray2);
    }

    public static Signature bounce(CertificateFactory certificateFactory, Signature signature) throws CertificateException {
        return InvokeDynamicSupport.bootstrapStatic("bounce", $$robo$$android_content_pm_Signature$bounce(java.security.cert.CertificateFactory android.content.pm.Signature ), (CertificateFactory)certificateFactory, (Signature)signature);
    }

    private /* synthetic */ void __constructor__(Parcel parcel, 1 var2_2) {
        this.$$robo$$android_content_pm_Signature$__constructor__(parcel, var2_2);
    }

    public /* synthetic */ Signature(Parcel parcel, 1 var2_2) {
        this(parcel);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_Signature$__constructor__(android.os.Parcel android.content.pm.Signature$1 ), this, parcel, var2_2);
    }

    static {
        RobolectricInternals.classInitializing(Signature.class);
    }

    public /* synthetic */ Signature() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Signature)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

