/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm;

import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.res.XmlResourceParser;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Parcel;
import android.text.Html;
import android.text.TextPaint;
import android.text.TextUtils;
import android.util.Printer;
import java.text.Collator;
import java.util.Comparator;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class PackageItemInfo
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static float MAX_LABEL_SIZE_PX = 500.0f;
    public String name;
    public String packageName;
    public int labelRes;
    public CharSequence nonLocalizedLabel;
    public int icon;
    public int banner;
    public int logo;
    public Bundle metaData;
    public int showUserIcon;
    public static int DUMP_FLAG_DETAILS = 1;
    public static int DUMP_FLAG_APPLICATION = 2;
    public static int DUMP_FLAG_ALL = 3;

    private void $$robo$$android_content_pm_PackageItemInfo$__constructor__() {
        this.showUserIcon = -10000;
    }

    private void $$robo$$android_content_pm_PackageItemInfo$__constructor__(PackageItemInfo orig) {
        this.name = orig.name;
        if (this.name != null) {
            this.name = this.name.trim();
        }
        this.packageName = orig.packageName;
        this.labelRes = orig.labelRes;
        this.nonLocalizedLabel = orig.nonLocalizedLabel;
        if (this.nonLocalizedLabel != null) {
            this.nonLocalizedLabel = this.nonLocalizedLabel.toString().trim();
        }
        this.icon = orig.icon;
        this.banner = orig.banner;
        this.logo = orig.logo;
        this.metaData = orig.metaData;
        this.showUserIcon = orig.showUserIcon;
    }

    private final CharSequence $$robo$$android_content_pm_PackageItemInfo$loadLabel(PackageManager pm) {
        CharSequence label;
        if (this.nonLocalizedLabel != null) {
            return this.nonLocalizedLabel;
        }
        if (this.labelRes != 0 && (label = pm.getText(this.packageName, this.labelRes, this.getApplicationInfo())) != null) {
            return label.toString().trim();
        }
        if (this.name != null) {
            return this.name;
        }
        return this.packageName;
    }

    private final CharSequence $$robo$$android_content_pm_PackageItemInfo$loadSafeLabel(PackageManager pm) {
        int codePoint;
        String label = this.loadLabel(pm).toString();
        String labelStr = Html.fromHtml(label).toString();
        int labelLength = labelStr.length();
        for (int offset = 0; offset < labelLength; offset += Character.charCount(codePoint)) {
            codePoint = labelStr.codePointAt(offset);
            int type = Character.getType(codePoint);
            if (type == 13 || type == 15 || type == 14) {
                labelStr = labelStr.substring(0, offset);
                break;
            }
            if (type != 12) continue;
            labelStr = labelStr.substring(0, offset) + " " + labelStr.substring(offset + Character.charCount(codePoint));
        }
        if ((labelStr = labelStr.trim()).isEmpty()) {
            return this.packageName;
        }
        TextPaint paint = new TextPaint();
        paint.setTextSize(42.0f);
        return TextUtils.ellipsize(labelStr, paint, 500.0f, TextUtils.TruncateAt.END);
    }

    private final Drawable $$robo$$android_content_pm_PackageItemInfo$loadIcon(PackageManager pm) {
        return pm.loadItemIcon(this, this.getApplicationInfo());
    }

    private final Drawable $$robo$$android_content_pm_PackageItemInfo$loadUnbadgedIcon(PackageManager pm) {
        return pm.loadUnbadgedItemIcon(this, this.getApplicationInfo());
    }

    private final Drawable $$robo$$android_content_pm_PackageItemInfo$loadBanner(PackageManager pm) {
        Drawable dr;
        if (this.banner != 0 && (dr = pm.getDrawable(this.packageName, this.banner, this.getApplicationInfo())) != null) {
            return dr;
        }
        return this.loadDefaultBanner(pm);
    }

    private final Drawable $$robo$$android_content_pm_PackageItemInfo$loadDefaultIcon(PackageManager pm) {
        return pm.getDefaultActivityIcon();
    }

    private final Drawable $$robo$$android_content_pm_PackageItemInfo$loadDefaultBanner(PackageManager pm) {
        return null;
    }

    private final Drawable $$robo$$android_content_pm_PackageItemInfo$loadLogo(PackageManager pm) {
        Drawable d;
        if (this.logo != 0 && (d = pm.getDrawable(this.packageName, this.logo, this.getApplicationInfo())) != null) {
            return d;
        }
        return this.loadDefaultLogo(pm);
    }

    private final Drawable $$robo$$android_content_pm_PackageItemInfo$loadDefaultLogo(PackageManager pm) {
        return null;
    }

    private final XmlResourceParser $$robo$$android_content_pm_PackageItemInfo$loadXmlMetaData(PackageManager pm, String name) {
        int resid;
        if (this.metaData != null && (resid = this.metaData.getInt(name)) != 0) {
            return pm.getXml(this.packageName, resid, this.getApplicationInfo());
        }
        return null;
    }

    private final void $$robo$$android_content_pm_PackageItemInfo$dumpFront(Printer pw, String prefix) {
        if (this.name != null) {
            pw.println(prefix + "name=" + this.name);
        }
        pw.println(prefix + "packageName=" + this.packageName);
        if (this.labelRes != 0 || this.nonLocalizedLabel != null || this.icon != 0 || this.banner != 0) {
            pw.println(prefix + "labelRes=0x" + Integer.toHexString(this.labelRes) + " nonLocalizedLabel=" + this.nonLocalizedLabel + " icon=0x" + Integer.toHexString(this.icon) + " banner=0x" + Integer.toHexString(this.banner));
        }
    }

    private final void $$robo$$android_content_pm_PackageItemInfo$dumpBack(Printer pw, String prefix) {
    }

    private final void $$robo$$android_content_pm_PackageItemInfo$writeToParcel(Parcel dest, int parcelableFlags) {
        dest.writeString(this.name);
        dest.writeString(this.packageName);
        dest.writeInt(this.labelRes);
        TextUtils.writeToParcel(this.nonLocalizedLabel, dest, parcelableFlags);
        dest.writeInt(this.icon);
        dest.writeInt(this.logo);
        dest.writeBundle(this.metaData);
        dest.writeInt(this.banner);
        dest.writeInt(this.showUserIcon);
    }

    private void $$robo$$android_content_pm_PackageItemInfo$__constructor__(Parcel source) {
        this.name = source.readString();
        this.packageName = source.readString();
        this.labelRes = source.readInt();
        this.nonLocalizedLabel = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(source);
        this.icon = source.readInt();
        this.logo = source.readInt();
        this.metaData = source.readBundle();
        this.banner = source.readInt();
        this.showUserIcon = source.readInt();
    }

    private final ApplicationInfo $$robo$$android_content_pm_PackageItemInfo$getApplicationInfo() {
        return null;
    }

    private void __constructor__() {
        this.$$robo$$android_content_pm_PackageItemInfo$__constructor__();
    }

    public PackageItemInfo() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_PackageItemInfo$__constructor__(), this);
    }

    private void __constructor__(PackageItemInfo packageItemInfo) {
        this.$$robo$$android_content_pm_PackageItemInfo$__constructor__(packageItemInfo);
    }

    public PackageItemInfo(PackageItemInfo packageItemInfo) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_PackageItemInfo$__constructor__(android.content.pm.PackageItemInfo ), this, packageItemInfo);
    }

    public CharSequence loadLabel(PackageManager packageManager) {
        return InvokeDynamicSupport.bootstrap("loadLabel", $$robo$$android_content_pm_PackageItemInfo$loadLabel(android.content.pm.PackageManager ), this, packageManager);
    }

    public CharSequence loadSafeLabel(PackageManager packageManager) {
        return InvokeDynamicSupport.bootstrap("loadSafeLabel", $$robo$$android_content_pm_PackageItemInfo$loadSafeLabel(android.content.pm.PackageManager ), this, packageManager);
    }

    public Drawable loadIcon(PackageManager packageManager) {
        return InvokeDynamicSupport.bootstrap("loadIcon", $$robo$$android_content_pm_PackageItemInfo$loadIcon(android.content.pm.PackageManager ), this, packageManager);
    }

    public Drawable loadUnbadgedIcon(PackageManager packageManager) {
        return InvokeDynamicSupport.bootstrap("loadUnbadgedIcon", $$robo$$android_content_pm_PackageItemInfo$loadUnbadgedIcon(android.content.pm.PackageManager ), this, packageManager);
    }

    public Drawable loadBanner(PackageManager packageManager) {
        return InvokeDynamicSupport.bootstrap("loadBanner", $$robo$$android_content_pm_PackageItemInfo$loadBanner(android.content.pm.PackageManager ), this, packageManager);
    }

    public Drawable loadDefaultIcon(PackageManager packageManager) {
        return InvokeDynamicSupport.bootstrap("loadDefaultIcon", $$robo$$android_content_pm_PackageItemInfo$loadDefaultIcon(android.content.pm.PackageManager ), this, packageManager);
    }

    protected Drawable loadDefaultBanner(PackageManager packageManager) {
        return InvokeDynamicSupport.bootstrap("loadDefaultBanner", $$robo$$android_content_pm_PackageItemInfo$loadDefaultBanner(android.content.pm.PackageManager ), this, packageManager);
    }

    public Drawable loadLogo(PackageManager packageManager) {
        return InvokeDynamicSupport.bootstrap("loadLogo", $$robo$$android_content_pm_PackageItemInfo$loadLogo(android.content.pm.PackageManager ), this, packageManager);
    }

    protected Drawable loadDefaultLogo(PackageManager packageManager) {
        return InvokeDynamicSupport.bootstrap("loadDefaultLogo", $$robo$$android_content_pm_PackageItemInfo$loadDefaultLogo(android.content.pm.PackageManager ), this, packageManager);
    }

    public XmlResourceParser loadXmlMetaData(PackageManager packageManager, String string2) {
        return InvokeDynamicSupport.bootstrap("loadXmlMetaData", $$robo$$android_content_pm_PackageItemInfo$loadXmlMetaData(android.content.pm.PackageManager java.lang.String ), this, packageManager, string2);
    }

    protected void dumpFront(Printer printer, String string2) {
        InvokeDynamicSupport.bootstrap("dumpFront", $$robo$$android_content_pm_PackageItemInfo$dumpFront(android.util.Printer java.lang.String ), this, printer, string2);
    }

    protected void dumpBack(Printer printer, String string2) {
        InvokeDynamicSupport.bootstrap("dumpBack", $$robo$$android_content_pm_PackageItemInfo$dumpBack(android.util.Printer java.lang.String ), this, printer, string2);
    }

    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_content_pm_PackageItemInfo$writeToParcel(android.os.Parcel int ), this, parcel, n);
    }

    private void __constructor__(Parcel parcel) {
        this.$$robo$$android_content_pm_PackageItemInfo$__constructor__(parcel);
    }

    public PackageItemInfo(Parcel parcel) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_PackageItemInfo$__constructor__(android.os.Parcel ), this, parcel);
    }

    protected ApplicationInfo getApplicationInfo() {
        return InvokeDynamicSupport.bootstrap("getApplicationInfo", $$robo$$android_content_pm_PackageItemInfo$getApplicationInfo(), this);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PackageItemInfo)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class DisplayNameComparator
    implements Comparator<PackageItemInfo> {
        public /* synthetic */ Object __robo_data__;
        private Collator sCollator;
        private PackageManager mPM;

        private void $$robo$$android_content_pm_PackageItemInfo_DisplayNameComparator$__constructor__(PackageManager pm) {
            this.sCollator = Collator.getInstance();
            this.mPM = pm;
        }

        private final int $$robo$$android_content_pm_PackageItemInfo_DisplayNameComparator$compare(PackageItemInfo aa, PackageItemInfo ab) {
            CharSequence sb;
            CharSequence sa = aa.loadLabel(this.mPM);
            if (sa == null) {
                sa = aa.name;
            }
            if ((sb = ab.loadLabel(this.mPM)) == null) {
                sb = ab.name;
            }
            return this.sCollator.compare(sa.toString(), sb.toString());
        }

        private void __constructor__(PackageManager packageManager) {
            this.$$robo$$android_content_pm_PackageItemInfo_DisplayNameComparator$__constructor__(packageManager);
        }

        public DisplayNameComparator(PackageManager packageManager) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_PackageItemInfo_DisplayNameComparator$__constructor__(android.content.pm.PackageManager ), this, packageManager);
        }

        @Override
        public int compare(PackageItemInfo packageItemInfo, PackageItemInfo packageItemInfo2) {
            return (int)InvokeDynamicSupport.bootstrap("compare", $$robo$$android_content_pm_PackageItemInfo_DisplayNameComparator$compare(android.content.pm.PackageItemInfo android.content.pm.PackageItemInfo ), this, packageItemInfo, packageItemInfo2);
        }

        public /* synthetic */ DisplayNameComparator() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DisplayNameComparator)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

