/*
 * Decompiled with CFR 0.152.
 */
package android.companion;

import android.bluetooth.BluetoothDevice;
import android.bluetooth.le.ScanFilter;
import android.net.wifi.ScanResult;
import android.os.ParcelUuid;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class BluetoothDeviceFilterUtils
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static boolean DEBUG = false;
    private static String LOG_TAG = "BluetoothDeviceFilterUtils";

    private void $$robo$$android_companion_BluetoothDeviceFilterUtils$__constructor__() {
    }

    private static final String $$robo$$android_companion_BluetoothDeviceFilterUtils$patternToString(Pattern p) {
        return p == null ? null : p.pattern();
    }

    private static final Pattern $$robo$$android_companion_BluetoothDeviceFilterUtils$patternFromString(String s) {
        return s == null ? null : Pattern.compile(s);
    }

    private static final boolean $$robo$$android_companion_BluetoothDeviceFilterUtils$matches(ScanFilter filter, BluetoothDevice device) {
        boolean result = BluetoothDeviceFilterUtils.matchesAddress(filter.getDeviceAddress(), device) && BluetoothDeviceFilterUtils.matchesServiceUuid(filter.getServiceUuid(), filter.getServiceUuidMask(), device);
        return result;
    }

    private static final boolean $$robo$$android_companion_BluetoothDeviceFilterUtils$matchesAddress(String deviceAddress, BluetoothDevice device) {
        boolean result = deviceAddress == null || device != null && deviceAddress.equals(device.getAddress());
        return result;
    }

    private static final boolean $$robo$$android_companion_BluetoothDeviceFilterUtils$matchesServiceUuids(List<ParcelUuid> serviceUuids, List<ParcelUuid> serviceUuidMasks, BluetoothDevice device) {
        for (int i = 0; i < serviceUuids.size(); ++i) {
            ParcelUuid uuidMask;
            ParcelUuid uuid = serviceUuids.get(i);
            if (BluetoothDeviceFilterUtils.matchesServiceUuid(uuid, uuidMask = serviceUuidMasks.get(i), device)) continue;
            return false;
        }
        return true;
    }

    private static final boolean $$robo$$android_companion_BluetoothDeviceFilterUtils$matchesServiceUuid(ParcelUuid serviceUuid, ParcelUuid serviceUuidMask, BluetoothDevice device) {
        boolean result = serviceUuid == null || ScanFilter.matchesServiceUuids(serviceUuid, serviceUuidMask, Arrays.asList(device.getUuids()));
        return result;
    }

    private static final boolean $$robo$$android_companion_BluetoothDeviceFilterUtils$matchesName(Pattern namePattern, BluetoothDevice device) {
        String name;
        boolean result = namePattern == null ? true : (device == null ? false : (name = device.getName()) != null && namePattern.matcher(name).find());
        return result;
    }

    private static final boolean $$robo$$android_companion_BluetoothDeviceFilterUtils$matchesName(Pattern namePattern, ScanResult device) {
        String name;
        boolean result = namePattern == null ? true : (device == null ? false : (name = device.SSID) != null && namePattern.matcher(name).find());
        return result;
    }

    private static final void $$robo$$android_companion_BluetoothDeviceFilterUtils$debugLogMatchResult(boolean result, BluetoothDevice device, Object criteria) {
        Log.i("BluetoothDeviceFilterUtils", BluetoothDeviceFilterUtils.getDeviceDisplayNameInternal(device) + (result ? " ~ " : " !~ ") + criteria);
    }

    private static final void $$robo$$android_companion_BluetoothDeviceFilterUtils$debugLogMatchResult(boolean result, ScanResult device, Object criteria) {
        Log.i("BluetoothDeviceFilterUtils", BluetoothDeviceFilterUtils.getDeviceDisplayNameInternal(device) + (result ? " ~ " : " !~ ") + criteria);
    }

    private static final String $$robo$$android_companion_BluetoothDeviceFilterUtils$getDeviceDisplayNameInternal(BluetoothDevice device) {
        return TextUtils.firstNotEmpty(device.getAliasName(), device.getAddress());
    }

    private static final String $$robo$$android_companion_BluetoothDeviceFilterUtils$getDeviceDisplayNameInternal(ScanResult device) {
        return TextUtils.firstNotEmpty(device.SSID, device.BSSID);
    }

    private static final String $$robo$$android_companion_BluetoothDeviceFilterUtils$getDeviceMacAddress(Parcelable device) {
        if (device instanceof BluetoothDevice) {
            return ((BluetoothDevice)device).getAddress();
        }
        if (device instanceof ScanResult) {
            return ((ScanResult)device).BSSID;
        }
        if (device instanceof android.bluetooth.le.ScanResult) {
            return BluetoothDeviceFilterUtils.getDeviceMacAddress(((android.bluetooth.le.ScanResult)device).getDevice());
        }
        throw new IllegalArgumentException("Unknown device type: " + device);
    }

    private void __constructor__() {
        this.$$robo$$android_companion_BluetoothDeviceFilterUtils$__constructor__();
    }

    public BluetoothDeviceFilterUtils() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_companion_BluetoothDeviceFilterUtils$__constructor__(), this);
    }

    static String patternToString(Pattern pattern) {
        return InvokeDynamicSupport.bootstrapStatic("patternToString", $$robo$$android_companion_BluetoothDeviceFilterUtils$patternToString(java.util.regex.Pattern ), (Pattern)pattern);
    }

    static Pattern patternFromString(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("patternFromString", $$robo$$android_companion_BluetoothDeviceFilterUtils$patternFromString(java.lang.String ), (String)string2);
    }

    static boolean matches(ScanFilter scanFilter, BluetoothDevice bluetoothDevice) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("matches", $$robo$$android_companion_BluetoothDeviceFilterUtils$matches(android.bluetooth.le.ScanFilter android.bluetooth.BluetoothDevice ), (ScanFilter)scanFilter, (BluetoothDevice)bluetoothDevice);
    }

    static boolean matchesAddress(String string2, BluetoothDevice bluetoothDevice) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("matchesAddress", $$robo$$android_companion_BluetoothDeviceFilterUtils$matchesAddress(java.lang.String android.bluetooth.BluetoothDevice ), (String)string2, (BluetoothDevice)bluetoothDevice);
    }

    static boolean matchesServiceUuids(List<ParcelUuid> list, List<ParcelUuid> list2, BluetoothDevice bluetoothDevice) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("matchesServiceUuids", $$robo$$android_companion_BluetoothDeviceFilterUtils$matchesServiceUuids(java.util.List<android.os.ParcelUuid> java.util.List<android.os.ParcelUuid> android.bluetooth.BluetoothDevice ), list, list2, (BluetoothDevice)bluetoothDevice);
    }

    static boolean matchesServiceUuid(ParcelUuid parcelUuid, ParcelUuid parcelUuid2, BluetoothDevice bluetoothDevice) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("matchesServiceUuid", $$robo$$android_companion_BluetoothDeviceFilterUtils$matchesServiceUuid(android.os.ParcelUuid android.os.ParcelUuid android.bluetooth.BluetoothDevice ), (ParcelUuid)parcelUuid, (ParcelUuid)parcelUuid2, (BluetoothDevice)bluetoothDevice);
    }

    static boolean matchesName(Pattern pattern, BluetoothDevice bluetoothDevice) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("matchesName", $$robo$$android_companion_BluetoothDeviceFilterUtils$matchesName(java.util.regex.Pattern android.bluetooth.BluetoothDevice ), (Pattern)pattern, (BluetoothDevice)bluetoothDevice);
    }

    static boolean matchesName(Pattern pattern, ScanResult scanResult) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("matchesName", $$robo$$android_companion_BluetoothDeviceFilterUtils$matchesName(java.util.regex.Pattern android.net.wifi.ScanResult ), (Pattern)pattern, (ScanResult)scanResult);
    }

    private static void debugLogMatchResult(boolean bl, BluetoothDevice bluetoothDevice, Object object) {
        InvokeDynamicSupport.bootstrapStatic("debugLogMatchResult", $$robo$$android_companion_BluetoothDeviceFilterUtils$debugLogMatchResult(boolean android.bluetooth.BluetoothDevice java.lang.Object ), (boolean)bl, (BluetoothDevice)bluetoothDevice, (Object)object);
    }

    private static void debugLogMatchResult(boolean bl, ScanResult scanResult, Object object) {
        InvokeDynamicSupport.bootstrapStatic("debugLogMatchResult", $$robo$$android_companion_BluetoothDeviceFilterUtils$debugLogMatchResult(boolean android.net.wifi.ScanResult java.lang.Object ), (boolean)bl, (ScanResult)scanResult, (Object)object);
    }

    public static String getDeviceDisplayNameInternal(BluetoothDevice bluetoothDevice) {
        return InvokeDynamicSupport.bootstrapStatic("getDeviceDisplayNameInternal", $$robo$$android_companion_BluetoothDeviceFilterUtils$getDeviceDisplayNameInternal(android.bluetooth.BluetoothDevice ), (BluetoothDevice)bluetoothDevice);
    }

    public static String getDeviceDisplayNameInternal(ScanResult scanResult) {
        return InvokeDynamicSupport.bootstrapStatic("getDeviceDisplayNameInternal", $$robo$$android_companion_BluetoothDeviceFilterUtils$getDeviceDisplayNameInternal(android.net.wifi.ScanResult ), (ScanResult)scanResult);
    }

    public static String getDeviceMacAddress(Parcelable parcelable) {
        return InvokeDynamicSupport.bootstrapStatic("getDeviceMacAddress", $$robo$$android_companion_BluetoothDeviceFilterUtils$getDeviceMacAddress(android.os.Parcelable ), (Parcelable)parcelable);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BluetoothDeviceFilterUtils)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

