/*
 * Decompiled with CFR 0.152.
 */
package android.companion;

import android.bluetooth.BluetoothDevice;
import android.companion.BluetoothDeviceFilterUtils;
import android.companion.DeviceFilter;
import android.os.Parcel;
import android.os.ParcelUuid;
import android.os.Parcelable;
import android.provider.OneTimeUseBuilder;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.CollectionUtils;
import com.google.errorprone.annotations.DoNotMock;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class BluetoothDeviceFilter
implements DeviceFilter<BluetoothDevice> {
    public /* synthetic */ Object __robo_data__;
    private Pattern mNamePattern;
    private String mAddress;
    private List<ParcelUuid> mServiceUuids;
    private List<ParcelUuid> mServiceUuidMasks;
    public static Parcelable.Creator<BluetoothDeviceFilter> CREATOR;

    private void $$robo$$android_companion_BluetoothDeviceFilter$__constructor__(Pattern namePattern, String address, List<ParcelUuid> serviceUuids, List<ParcelUuid> serviceUuidMasks) {
        this.mNamePattern = namePattern;
        this.mAddress = address;
        this.mServiceUuids = CollectionUtils.emptyIfNull(serviceUuids);
        this.mServiceUuidMasks = CollectionUtils.emptyIfNull(serviceUuidMasks);
    }

    private void $$robo$$android_companion_BluetoothDeviceFilter$__constructor__(Parcel in) {
    }

    private static final List<ParcelUuid> $$robo$$android_companion_BluetoothDeviceFilter$readUuids(Parcel in) {
        return in.readParcelableList(new ArrayList(), ParcelUuid.class.getClassLoader());
    }

    private final boolean $$robo$$android_companion_BluetoothDeviceFilter$matches(BluetoothDevice device) {
        return BluetoothDeviceFilterUtils.matchesAddress(this.mAddress, device) && BluetoothDeviceFilterUtils.matchesServiceUuids(this.mServiceUuids, this.mServiceUuidMasks, device) && BluetoothDeviceFilterUtils.matchesName(this.getNamePattern(), device);
    }

    private final String $$robo$$android_companion_BluetoothDeviceFilter$getDeviceDisplayName(BluetoothDevice device) {
        return BluetoothDeviceFilterUtils.getDeviceDisplayNameInternal(device);
    }

    private final int $$robo$$android_companion_BluetoothDeviceFilter$getMediumType() {
        return 0;
    }

    private final Pattern $$robo$$android_companion_BluetoothDeviceFilter$getNamePattern() {
        return this.mNamePattern;
    }

    private final String $$robo$$android_companion_BluetoothDeviceFilter$getAddress() {
        return this.mAddress;
    }

    private final List<ParcelUuid> $$robo$$android_companion_BluetoothDeviceFilter$getServiceUuids() {
        return this.mServiceUuids;
    }

    private final List<ParcelUuid> $$robo$$android_companion_BluetoothDeviceFilter$getServiceUuidMasks() {
        return this.mServiceUuidMasks;
    }

    private final void $$robo$$android_companion_BluetoothDeviceFilter$writeToParcel(Parcel dest, int flags) {
        dest.writeString(BluetoothDeviceFilterUtils.patternToString(this.getNamePattern()));
        dest.writeString(this.mAddress);
        dest.writeParcelableList(this.mServiceUuids, flags);
        dest.writeParcelableList(this.mServiceUuidMasks, flags);
    }

    private final boolean $$robo$$android_companion_BluetoothDeviceFilter$equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BluetoothDeviceFilter that = (BluetoothDeviceFilter)o;
        return Objects.equals(this.mNamePattern, that.mNamePattern) && Objects.equals(this.mAddress, that.mAddress) && Objects.equals(this.mServiceUuids, that.mServiceUuids) && Objects.equals(this.mServiceUuidMasks, that.mServiceUuidMasks);
    }

    private final int $$robo$$android_companion_BluetoothDeviceFilter$hashCode() {
        return Objects.hash(this.mNamePattern, this.mAddress, this.mServiceUuids, this.mServiceUuidMasks);
    }

    private final int $$robo$$android_companion_BluetoothDeviceFilter$describeContents() {
        return 0;
    }

    private /* synthetic */ void $$robo$$android_companion_BluetoothDeviceFilter$__constructor__(Parcel x0, 1 x1) {
    }

    private /* synthetic */ void $$robo$$android_companion_BluetoothDeviceFilter$__constructor__(Pattern x0, String x1, List x2, List x3, 1 x4) {
    }

    static void __staticInitializer__() {
        CREATOR = new Parcelable.Creator<BluetoothDeviceFilter>(){
            public /* synthetic */ Object __robo_data__;

            private void $$robo$$android_companion_BluetoothDeviceFilter_1$__constructor__() {
            }

            private final BluetoothDeviceFilter $$robo$$android_companion_BluetoothDeviceFilter_1$createFromParcel(Parcel in) {
                return new BluetoothDeviceFilter(in, null);
            }

            private final BluetoothDeviceFilter[] $$robo$$android_companion_BluetoothDeviceFilter_1$newArray(int size) {
                return new BluetoothDeviceFilter[size];
            }

            private void __constructor__() {
                this.$$robo$$android_companion_BluetoothDeviceFilter_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_companion_BluetoothDeviceFilter_1$__constructor__(), this);
            }

            @Override
            public BluetoothDeviceFilter createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_companion_BluetoothDeviceFilter_1$createFromParcel(android.os.Parcel ), this, parcel);
            }

            public BluetoothDeviceFilter[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_companion_BluetoothDeviceFilter_1$newArray(int ), this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__(Pattern pattern, String string2, List<ParcelUuid> list, List<ParcelUuid> list2) {
        this.$$robo$$android_companion_BluetoothDeviceFilter$__constructor__(pattern, string2, list, list2);
    }

    public BluetoothDeviceFilter(Pattern pattern, String string2, List<ParcelUuid> list, List<ParcelUuid> list2) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_companion_BluetoothDeviceFilter$__constructor__(java.util.regex.Pattern java.lang.String java.util.List<android.os.ParcelUuid> java.util.List<android.os.ParcelUuid> ), this, pattern, string2, list, list2);
    }

    private void __constructor__(Parcel parcel) {
        this.$$robo$$android_companion_BluetoothDeviceFilter$__constructor__(parcel);
    }

    public BluetoothDeviceFilter(Parcel parcel) {
        this(BluetoothDeviceFilterUtils.patternFromString(parcel.readString()), parcel.readString(), BluetoothDeviceFilter.readUuids(parcel), BluetoothDeviceFilter.readUuids(parcel));
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_companion_BluetoothDeviceFilter$__constructor__(android.os.Parcel ), this, parcel);
    }

    private static List<ParcelUuid> readUuids(Parcel parcel) {
        return InvokeDynamicSupport.bootstrapStatic("readUuids", $$robo$$android_companion_BluetoothDeviceFilter$readUuids(android.os.Parcel ), (Parcel)parcel);
    }

    @Override
    public boolean matches(BluetoothDevice bluetoothDevice) {
        return (boolean)InvokeDynamicSupport.bootstrap("matches", $$robo$$android_companion_BluetoothDeviceFilter$matches(android.bluetooth.BluetoothDevice ), this, bluetoothDevice);
    }

    @Override
    public String getDeviceDisplayName(BluetoothDevice bluetoothDevice) {
        return InvokeDynamicSupport.bootstrap("getDeviceDisplayName", $$robo$$android_companion_BluetoothDeviceFilter$getDeviceDisplayName(android.bluetooth.BluetoothDevice ), this, bluetoothDevice);
    }

    @Override
    public int getMediumType() {
        return (int)InvokeDynamicSupport.bootstrap("getMediumType", $$robo$$android_companion_BluetoothDeviceFilter$getMediumType(), this);
    }

    public Pattern getNamePattern() {
        return InvokeDynamicSupport.bootstrap("getNamePattern", $$robo$$android_companion_BluetoothDeviceFilter$getNamePattern(), this);
    }

    public String getAddress() {
        return InvokeDynamicSupport.bootstrap("getAddress", $$robo$$android_companion_BluetoothDeviceFilter$getAddress(), this);
    }

    public List<ParcelUuid> getServiceUuids() {
        return InvokeDynamicSupport.bootstrap("getServiceUuids", $$robo$$android_companion_BluetoothDeviceFilter$getServiceUuids(), this);
    }

    public List<ParcelUuid> getServiceUuidMasks() {
        return InvokeDynamicSupport.bootstrap("getServiceUuidMasks", $$robo$$android_companion_BluetoothDeviceFilter$getServiceUuidMasks(), this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_companion_BluetoothDeviceFilter$writeToParcel(android.os.Parcel int ), this, parcel, n);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_companion_BluetoothDeviceFilter$equals(java.lang.Object ), this, object);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_companion_BluetoothDeviceFilter$hashCode(), this);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_companion_BluetoothDeviceFilter$describeContents(), this);
    }

    private /* synthetic */ void __constructor__(Parcel parcel, 1 var2_2) {
        this.$$robo$$android_companion_BluetoothDeviceFilter$__constructor__(parcel, var2_2);
    }

    public /* synthetic */ BluetoothDeviceFilter(Parcel parcel, 1 var2_2) {
        this(parcel);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_companion_BluetoothDeviceFilter$__constructor__(android.os.Parcel android.companion.BluetoothDeviceFilter$1 ), this, parcel, var2_2);
    }

    private /* synthetic */ void __constructor__(Pattern pattern, String string2, List list, List list2, 1 var5_5) {
        this.$$robo$$android_companion_BluetoothDeviceFilter$__constructor__(pattern, string2, list, list2, var5_5);
    }

    public /* synthetic */ BluetoothDeviceFilter(Pattern pattern, String string2, List list, List list2, 1 var5_5) {
        this(pattern, string2, list, list2);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_companion_BluetoothDeviceFilter$__constructor__(java.util.regex.Pattern java.lang.String java.util.List java.util.List android.companion.BluetoothDeviceFilter$1 ), this, pattern, string2, list, list2, var5_5);
    }

    static {
        RobolectricInternals.classInitializing(BluetoothDeviceFilter.class);
    }

    public /* synthetic */ BluetoothDeviceFilter() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BluetoothDeviceFilter)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class Builder
    extends OneTimeUseBuilder<BluetoothDeviceFilter> {
        public /* synthetic */ Object __robo_data__;
        private Pattern mNamePattern;
        private String mAddress;
        private ArrayList<ParcelUuid> mServiceUuid;
        private ArrayList<ParcelUuid> mServiceUuidMask;

        private void $$robo$$android_companion_BluetoothDeviceFilter_Builder$__constructor__() {
        }

        private final Builder $$robo$$android_companion_BluetoothDeviceFilter_Builder$setNamePattern(Pattern regex) {
            this.checkNotUsed();
            this.mNamePattern = regex;
            return this;
        }

        private final Builder $$robo$$android_companion_BluetoothDeviceFilter_Builder$setAddress(String address) {
            this.checkNotUsed();
            this.mAddress = address;
            return this;
        }

        private final Builder $$robo$$android_companion_BluetoothDeviceFilter_Builder$addServiceUuid(ParcelUuid serviceUuid, ParcelUuid serviceUuidMask) {
            this.checkNotUsed();
            this.mServiceUuid = ArrayUtils.add(this.mServiceUuid, serviceUuid);
            this.mServiceUuidMask = ArrayUtils.add(this.mServiceUuidMask, serviceUuidMask);
            return this;
        }

        private final BluetoothDeviceFilter $$robo$$android_companion_BluetoothDeviceFilter_Builder$build() {
            this.markUsed();
            return new BluetoothDeviceFilter(this.mNamePattern, this.mAddress, this.mServiceUuid, this.mServiceUuidMask, null);
        }

        private void __constructor__() {
            this.$$robo$$android_companion_BluetoothDeviceFilter_Builder$__constructor__();
        }

        public Builder() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_companion_BluetoothDeviceFilter_Builder$__constructor__(), this);
        }

        public Builder setNamePattern(Pattern pattern) {
            return InvokeDynamicSupport.bootstrap("setNamePattern", $$robo$$android_companion_BluetoothDeviceFilter_Builder$setNamePattern(java.util.regex.Pattern ), this, pattern);
        }

        public Builder setAddress(String string2) {
            return InvokeDynamicSupport.bootstrap("setAddress", $$robo$$android_companion_BluetoothDeviceFilter_Builder$setAddress(java.lang.String ), this, string2);
        }

        public Builder addServiceUuid(ParcelUuid parcelUuid, ParcelUuid parcelUuid2) {
            return InvokeDynamicSupport.bootstrap("addServiceUuid", $$robo$$android_companion_BluetoothDeviceFilter_Builder$addServiceUuid(android.os.ParcelUuid android.os.ParcelUuid ), this, parcelUuid, parcelUuid2);
        }

        @Override
        public BluetoothDeviceFilter build() {
            return InvokeDynamicSupport.bootstrap("build", $$robo$$android_companion_BluetoothDeviceFilter_Builder$build(), this);
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Builder)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

