/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothClass;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.IBluetoothManager;
import android.bluetooth.IBluetoothPbap;
import android.bluetooth.IBluetoothStateChangeCallback;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.os.Process;
import android.os.RemoteException;
import android.util.Log;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class BluetoothPbap
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG = "BluetoothPbap";
    private static boolean DBG = true;
    private static boolean VDBG = false;
    public static String PBAP_STATE = "android.bluetooth.pbap.intent.PBAP_STATE";
    public static String PBAP_PREVIOUS_STATE = "android.bluetooth.pbap.intent.PBAP_PREVIOUS_STATE";
    public static String PBAP_STATE_CHANGED_ACTION = "android.bluetooth.pbap.intent.action.PBAP_STATE_CHANGED";
    private IBluetoothPbap mService;
    private Context mContext;
    private ServiceListener mServiceListener;
    private BluetoothAdapter mAdapter;
    public static int STATE_ERROR = -1;
    public static int STATE_DISCONNECTED = 0;
    public static int STATE_CONNECTING = 1;
    public static int STATE_CONNECTED = 2;
    public static int RESULT_FAILURE = 0;
    public static int RESULT_SUCCESS = 1;
    public static int RESULT_CANCELED = 2;
    private IBluetoothStateChangeCallback mBluetoothStateChangeCallback;
    private ServiceConnection mConnection;

    private void $$robo$$android_bluetooth_BluetoothPbap$__constructor__(Context context, ServiceListener l) {
        this.mBluetoothStateChangeCallback = new ShadowedObject(this){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ BluetoothPbap this$0;

            private void $$robo$$android_bluetooth_BluetoothPbap_1$__constructor__(BluetoothPbap this$0) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_bluetooth_BluetoothPbap_1$onBluetoothStateChange(boolean up) {
                Log.d("BluetoothPbap", "onBluetoothStateChange: up=" + up);
                if (!up) {
                    ServiceConnection serviceConnection = this.this$0.mConnection;
                    synchronized (serviceConnection) {
                        try {
                            this.this$0.mService = null;
                            this.this$0.mContext.unbindService(this.this$0.mConnection);
                        }
                        catch (Exception re) {
                            Log.e("BluetoothPbap", "", re);
                        }
                    }
                }
                ServiceConnection serviceConnection = this.this$0.mConnection;
                synchronized (serviceConnection) {
                    try {
                        if (this.this$0.mService == null) {
                            this.this$0.doBind();
                        }
                    }
                    catch (Exception re) {
                        Log.e("BluetoothPbap", "", re);
                    }
                }
            }

            private void __constructor__(BluetoothPbap bluetoothPbap) {
                this.$$robo$$android_bluetooth_BluetoothPbap_1$__constructor__(bluetoothPbap);
            }
            {
                this.this$0 = bluetoothPbap;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_bluetooth_BluetoothPbap_1$__constructor__(android.bluetooth.BluetoothPbap ), this, bluetoothPbap);
            }

            @Override
            public void onBluetoothStateChange(boolean bl) {
                InvokeDynamicSupport.bootstrap("onBluetoothStateChange", $$robo$$android_bluetooth_BluetoothPbap_1$onBluetoothStateChange(boolean ), this, bl);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mConnection = new ServiceConnection(this){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ BluetoothPbap this$0;

            private void $$robo$$android_bluetooth_BluetoothPbap_2$__constructor__(BluetoothPbap this$0) {
            }

            private final void $$robo$$android_bluetooth_BluetoothPbap_2$onServiceConnected(ComponentName className, IBinder service) {
                BluetoothPbap.log("Proxy object connected");
                this.this$0.mService = IBluetoothPbap.Stub.asInterface(service);
                if (this.this$0.mServiceListener != null) {
                    this.this$0.mServiceListener.onServiceConnected(this.this$0);
                }
            }

            private final void $$robo$$android_bluetooth_BluetoothPbap_2$onServiceDisconnected(ComponentName className) {
                BluetoothPbap.log("Proxy object disconnected");
                this.this$0.mService = null;
                if (this.this$0.mServiceListener != null) {
                    this.this$0.mServiceListener.onServiceDisconnected();
                }
            }

            private void __constructor__(BluetoothPbap bluetoothPbap) {
                this.$$robo$$android_bluetooth_BluetoothPbap_2$__constructor__(bluetoothPbap);
            }
            {
                this.this$0 = bluetoothPbap;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_bluetooth_BluetoothPbap_2$__constructor__(android.bluetooth.BluetoothPbap ), this, bluetoothPbap);
            }

            @Override
            public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
                InvokeDynamicSupport.bootstrap("onServiceConnected", $$robo$$android_bluetooth_BluetoothPbap_2$onServiceConnected(android.content.ComponentName android.os.IBinder ), this, componentName, iBinder);
            }

            @Override
            public void onServiceDisconnected(ComponentName componentName) {
                InvokeDynamicSupport.bootstrap("onServiceDisconnected", $$robo$$android_bluetooth_BluetoothPbap_2$onServiceDisconnected(android.content.ComponentName ), this, componentName);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mContext = context;
        this.mServiceListener = l;
        this.mAdapter = BluetoothAdapter.getDefaultAdapter();
        IBluetoothManager mgr = this.mAdapter.getBluetoothManager();
        if (mgr != null) {
            try {
                mgr.registerStateChangeCallback(this.mBluetoothStateChangeCallback);
            }
            catch (RemoteException e) {
                Log.e("BluetoothPbap", "", e);
            }
        }
        this.doBind();
    }

    private final boolean $$robo$$android_bluetooth_BluetoothPbap$doBind() {
        Intent intent = new Intent(IBluetoothPbap.class.getName());
        ComponentName comp = intent.resolveSystemService(this.mContext.getPackageManager(), 0);
        intent.setComponent(comp);
        if (comp == null || !this.mContext.bindServiceAsUser(intent, this.mConnection, 0, Process.myUserHandle())) {
            Log.e("BluetoothPbap", "Could not bind to Bluetooth Pbap Service with " + intent);
            return false;
        }
        return true;
    }

    private final void $$robo$$android_bluetooth_BluetoothPbap$finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final synchronized void $$robo$$android_bluetooth_BluetoothPbap$close() {
        IBluetoothManager mgr = this.mAdapter.getBluetoothManager();
        if (mgr != null) {
            try {
                mgr.unregisterStateChangeCallback(this.mBluetoothStateChangeCallback);
            }
            catch (Exception e) {
                Log.e("BluetoothPbap", "", e);
            }
        }
        ServiceConnection serviceConnection = this.mConnection;
        synchronized (serviceConnection) {
            if (this.mService != null) {
                try {
                    this.mService = null;
                    this.mContext.unbindService(this.mConnection);
                }
                catch (Exception re) {
                    Log.e("BluetoothPbap", "", re);
                }
            }
        }
        this.mServiceListener = null;
    }

    private final int $$robo$$android_bluetooth_BluetoothPbap$getState() {
        if (this.mService != null) {
            try {
                return this.mService.getState();
            }
            catch (RemoteException e) {
                Log.e("BluetoothPbap", e.toString());
            }
        } else {
            Log.w("BluetoothPbap", "Proxy not attached to service");
            BluetoothPbap.log(Log.getStackTraceString(new Throwable()));
        }
        return -1;
    }

    private final BluetoothDevice $$robo$$android_bluetooth_BluetoothPbap$getClient() {
        if (this.mService != null) {
            try {
                return this.mService.getClient();
            }
            catch (RemoteException e) {
                Log.e("BluetoothPbap", e.toString());
            }
        } else {
            Log.w("BluetoothPbap", "Proxy not attached to service");
            BluetoothPbap.log(Log.getStackTraceString(new Throwable()));
        }
        return null;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothPbap$isConnected(BluetoothDevice device) {
        if (this.mService != null) {
            try {
                return this.mService.isConnected(device);
            }
            catch (RemoteException e) {
                Log.e("BluetoothPbap", e.toString());
            }
        } else {
            Log.w("BluetoothPbap", "Proxy not attached to service");
            BluetoothPbap.log(Log.getStackTraceString(new Throwable()));
        }
        return false;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothPbap$disconnect() {
        BluetoothPbap.log("disconnect()");
        if (this.mService != null) {
            try {
                this.mService.disconnect();
                return true;
            }
            catch (RemoteException e) {
                Log.e("BluetoothPbap", e.toString());
            }
        } else {
            Log.w("BluetoothPbap", "Proxy not attached to service");
            BluetoothPbap.log(Log.getStackTraceString(new Throwable()));
        }
        return false;
    }

    private static final boolean $$robo$$android_bluetooth_BluetoothPbap$doesClassMatchSink(BluetoothClass btClass) {
        switch (btClass.getDeviceClass()) {
            case 256: 
            case 260: 
            case 264: 
            case 268: {
                return true;
            }
        }
        return false;
    }

    private static final void $$robo$$android_bluetooth_BluetoothPbap$log(String msg) {
        Log.d("BluetoothPbap", msg);
    }

    private void __constructor__(Context context, ServiceListener serviceListener) {
        this.$$robo$$android_bluetooth_BluetoothPbap$__constructor__(context, serviceListener);
    }

    public BluetoothPbap(Context context, ServiceListener serviceListener) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_bluetooth_BluetoothPbap$__constructor__(android.content.Context android.bluetooth.BluetoothPbap$ServiceListener ), this, context, serviceListener);
    }

    boolean doBind() {
        return (boolean)InvokeDynamicSupport.bootstrap("doBind", $$robo$$android_bluetooth_BluetoothPbap$doBind(), this);
    }

    protected void finalize() throws Throwable {
        InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_bluetooth_BluetoothPbap$finalize(), this);
    }

    public synchronized void close() {
        InvokeDynamicSupport.bootstrap("close", $$robo$$android_bluetooth_BluetoothPbap$close(), this);
    }

    public int getState() {
        return (int)InvokeDynamicSupport.bootstrap("getState", $$robo$$android_bluetooth_BluetoothPbap$getState(), this);
    }

    public BluetoothDevice getClient() {
        return InvokeDynamicSupport.bootstrap("getClient", $$robo$$android_bluetooth_BluetoothPbap$getClient(), this);
    }

    public boolean isConnected(BluetoothDevice bluetoothDevice) {
        return (boolean)InvokeDynamicSupport.bootstrap("isConnected", $$robo$$android_bluetooth_BluetoothPbap$isConnected(android.bluetooth.BluetoothDevice ), this, bluetoothDevice);
    }

    public boolean disconnect() {
        return (boolean)InvokeDynamicSupport.bootstrap("disconnect", $$robo$$android_bluetooth_BluetoothPbap$disconnect(), this);
    }

    public static boolean doesClassMatchSink(BluetoothClass bluetoothClass) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("doesClassMatchSink", $$robo$$android_bluetooth_BluetoothPbap$doesClassMatchSink(android.bluetooth.BluetoothClass ), (BluetoothClass)bluetoothClass);
    }

    private static void log(String string2) {
        InvokeDynamicSupport.bootstrapStatic("log", $$robo$$android_bluetooth_BluetoothPbap$log(java.lang.String ), (String)string2);
    }

    public /* synthetic */ BluetoothPbap() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BluetoothPbap)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static interface ServiceListener
    extends InstrumentedInterface {
        public void onServiceConnected(BluetoothPbap var1);

        public void onServiceDisconnected();
    }
}

