/*
 * Decompiled with CFR 0.152.
 */
package android.app.backup;

import android.app.backup.BackupDataInput;
import android.app.backup.BackupDataInputStream;
import android.app.backup.BackupDataOutput;
import android.app.backup.BackupHelper;
import android.os.ParcelFileDescriptor;
import android.util.Log;
import java.io.FileDescriptor;
import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class BackupHelperDispatcher
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG = "BackupHelperDispatcher";
    TreeMap<String, BackupHelper> mHelpers;

    private void $$robo$$android_app_backup_BackupHelperDispatcher$__constructor__() {
        this.mHelpers = new TreeMap();
    }

    private final void $$robo$$android_app_backup_BackupHelperDispatcher$addHelper(String keyPrefix, BackupHelper helper) {
        this.mHelpers.put(keyPrefix, helper);
    }

    private final void $$robo$$android_app_backup_BackupHelperDispatcher$performBackup(ParcelFileDescriptor oldState, BackupDataOutput data, ParcelFileDescriptor newState) throws IOException {
        Header header = new Header(null);
        TreeMap helpers = (TreeMap)this.mHelpers.clone();
        FileDescriptor oldStateFD = null;
        if (oldState != null) {
            int err;
            oldStateFD = oldState.getFileDescriptor();
            while ((err = BackupHelperDispatcher.readHeader_native(header, oldStateFD)) >= 0) {
                if (err != 0) continue;
                BackupHelper helper = (BackupHelper)helpers.get(header.keyPrefix);
                Log.d("BackupHelperDispatcher", "handling existing helper '" + header.keyPrefix + "' " + helper);
                if (helper != null) {
                    this.doOneBackup(oldState, data, newState, header, helper);
                    helpers.remove(header.keyPrefix);
                    continue;
                }
                BackupHelperDispatcher.skipChunk_native(oldStateFD, header.chunkSize);
            }
        }
        for (Map.Entry entry : helpers.entrySet()) {
            header.keyPrefix = (String)entry.getKey();
            Log.d("BackupHelperDispatcher", "handling new helper '" + header.keyPrefix + "'");
            BackupHelper helper = (BackupHelper)entry.getValue();
            this.doOneBackup(oldState, data, newState, header, helper);
        }
    }

    private final void $$robo$$android_app_backup_BackupHelperDispatcher$doOneBackup(ParcelFileDescriptor oldState, BackupDataOutput data, ParcelFileDescriptor newState, Header header, BackupHelper helper) throws IOException {
        FileDescriptor newStateFD = newState.getFileDescriptor();
        int pos = BackupHelperDispatcher.allocateHeader_native(header, newStateFD);
        if (pos < 0) {
            throw new IOException("allocateHeader_native failed (error " + pos + ")");
        }
        data.setKeyPrefix(header.keyPrefix);
        helper.performBackup(oldState, data, newState);
        int err = BackupHelperDispatcher.writeHeader_native(header, newStateFD, pos);
        if (err != 0) {
            throw new IOException("writeHeader_native failed (error " + err + ")");
        }
    }

    private final void $$robo$$android_app_backup_BackupHelperDispatcher$performRestore(BackupDataInput input, int appVersionCode, ParcelFileDescriptor newState) throws IOException {
        boolean alreadyComplained = false;
        BackupDataInputStream stream = new BackupDataInputStream(input);
        while (input.readNextHeader()) {
            String rawKey = input.getKey();
            int pos = rawKey.indexOf(58);
            if (pos > 0) {
                String prefix = rawKey.substring(0, pos);
                BackupHelper helper = this.mHelpers.get(prefix);
                if (helper != null) {
                    stream.dataSize = input.getDataSize();
                    stream.key = rawKey.substring(pos + 1);
                    helper.restoreEntity(stream);
                } else if (!alreadyComplained) {
                    Log.w("BackupHelperDispatcher", "Couldn't find helper for: '" + rawKey + "'");
                    alreadyComplained = true;
                }
            } else if (!alreadyComplained) {
                Log.w("BackupHelperDispatcher", "Entity with no prefix: '" + rawKey + "'");
                alreadyComplained = true;
            }
            input.skipEntityData();
        }
        for (BackupHelper helper : this.mHelpers.values()) {
            helper.writeNewStateDescription(newState);
        }
    }

    private static final int $$robo$$android_app_backup_BackupHelperDispatcher$readHeader_native(Header header, FileDescriptor fileDescriptor) {
        return 0;
    }

    private static final int $$robo$$android_app_backup_BackupHelperDispatcher$skipChunk_native(FileDescriptor fileDescriptor, int n) {
        return 0;
    }

    private static final int $$robo$$android_app_backup_BackupHelperDispatcher$allocateHeader_native(Header header, FileDescriptor fileDescriptor) {
        return 0;
    }

    private static final int $$robo$$android_app_backup_BackupHelperDispatcher$writeHeader_native(Header header, FileDescriptor fileDescriptor, int n) {
        return 0;
    }

    private void __constructor__() {
        this.$$robo$$android_app_backup_BackupHelperDispatcher$__constructor__();
    }

    public BackupHelperDispatcher() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_backup_BackupHelperDispatcher$__constructor__(), this);
    }

    public void addHelper(String string2, BackupHelper backupHelper) {
        InvokeDynamicSupport.bootstrap("addHelper", $$robo$$android_app_backup_BackupHelperDispatcher$addHelper(java.lang.String android.app.backup.BackupHelper ), this, string2, backupHelper);
    }

    public void performBackup(ParcelFileDescriptor parcelFileDescriptor, BackupDataOutput backupDataOutput, ParcelFileDescriptor parcelFileDescriptor2) throws IOException {
        InvokeDynamicSupport.bootstrap("performBackup", $$robo$$android_app_backup_BackupHelperDispatcher$performBackup(android.os.ParcelFileDescriptor android.app.backup.BackupDataOutput android.os.ParcelFileDescriptor ), this, parcelFileDescriptor, backupDataOutput, parcelFileDescriptor2);
    }

    private void doOneBackup(ParcelFileDescriptor parcelFileDescriptor, BackupDataOutput backupDataOutput, ParcelFileDescriptor parcelFileDescriptor2, Header header, BackupHelper backupHelper) throws IOException {
        InvokeDynamicSupport.bootstrap("doOneBackup", $$robo$$android_app_backup_BackupHelperDispatcher$doOneBackup(android.os.ParcelFileDescriptor android.app.backup.BackupDataOutput android.os.ParcelFileDescriptor android.app.backup.BackupHelperDispatcher$Header android.app.backup.BackupHelper ), this, parcelFileDescriptor, backupDataOutput, parcelFileDescriptor2, header, backupHelper);
    }

    public void performRestore(BackupDataInput backupDataInput, int n, ParcelFileDescriptor parcelFileDescriptor) throws IOException {
        InvokeDynamicSupport.bootstrap("performRestore", $$robo$$android_app_backup_BackupHelperDispatcher$performRestore(android.app.backup.BackupDataInput int android.os.ParcelFileDescriptor ), this, backupDataInput, n, parcelFileDescriptor);
    }

    private static int readHeader_native(Header header, FileDescriptor fileDescriptor) {
        return (int)InvokeDynamicSupport.bootstrapStatic("readHeader_native", $$robo$$android_app_backup_BackupHelperDispatcher$readHeader_native(android.app.backup.BackupHelperDispatcher$Header java.io.FileDescriptor ), (Header)header, (FileDescriptor)fileDescriptor);
    }

    private static int skipChunk_native(FileDescriptor fileDescriptor, int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("skipChunk_native", $$robo$$android_app_backup_BackupHelperDispatcher$skipChunk_native(java.io.FileDescriptor int ), (FileDescriptor)fileDescriptor, (int)n);
    }

    private static int allocateHeader_native(Header header, FileDescriptor fileDescriptor) {
        return (int)InvokeDynamicSupport.bootstrapStatic("allocateHeader_native", $$robo$$android_app_backup_BackupHelperDispatcher$allocateHeader_native(android.app.backup.BackupHelperDispatcher$Header java.io.FileDescriptor ), (Header)header, (FileDescriptor)fileDescriptor);
    }

    private static int writeHeader_native(Header header, FileDescriptor fileDescriptor, int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("writeHeader_native", $$robo$$android_app_backup_BackupHelperDispatcher$writeHeader_native(android.app.backup.BackupHelperDispatcher$Header java.io.FileDescriptor int ), (Header)header, (FileDescriptor)fileDescriptor, (int)n);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BackupHelperDispatcher)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class Header
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        int chunkSize;
        String keyPrefix;

        private void $$robo$$android_app_backup_BackupHelperDispatcher_Header$__constructor__() {
        }

        private /* synthetic */ void $$robo$$android_app_backup_BackupHelperDispatcher_Header$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$android_app_backup_BackupHelperDispatcher_Header$__constructor__();
        }

        public Header() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_backup_BackupHelperDispatcher_Header$__constructor__(), this);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$android_app_backup_BackupHelperDispatcher_Header$__constructor__(var1_1);
        }

        public /* synthetic */ Header(1 var1_1) {
            this();
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_backup_BackupHelperDispatcher_Header$__constructor__(android.app.backup.BackupHelperDispatcher$1 ), this, var1_1);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Header)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

