/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.Notification;
import android.content.ClipData;
import android.content.ClipDescription;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.ArraySet;
import com.google.errorprone.annotations.DoNotMock;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class RemoteInput
implements Parcelable,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    public static String RESULTS_CLIP_LABEL = "android.remoteinput.results";
    public static String EXTRA_RESULTS_DATA = "android.remoteinput.resultsData";
    private static String EXTRA_DATA_TYPE_RESULTS_DATA = "android.remoteinput.dataTypeResultsData";
    private static int FLAG_ALLOW_FREE_FORM_INPUT = 1;
    private static int DEFAULT_FLAGS = 1;
    private String mResultKey;
    private CharSequence mLabel;
    private CharSequence[] mChoices;
    private int mFlags;
    private Bundle mExtras;
    private ArraySet<String> mAllowedDataTypes;
    public static Parcelable.Creator<RemoteInput> CREATOR;

    private void $$robo$$android_app_RemoteInput$__constructor__(String resultKey, CharSequence label, CharSequence[] choices, int flags, Bundle extras, ArraySet<String> allowedDataTypes) {
        this.mResultKey = resultKey;
        this.mLabel = label;
        this.mChoices = choices;
        this.mFlags = flags;
        this.mExtras = extras;
        this.mAllowedDataTypes = allowedDataTypes;
    }

    private final String $$robo$$android_app_RemoteInput$getResultKey() {
        return this.mResultKey;
    }

    private final CharSequence $$robo$$android_app_RemoteInput$getLabel() {
        return this.mLabel;
    }

    private final CharSequence[] $$robo$$android_app_RemoteInput$getChoices() {
        return this.mChoices;
    }

    private final Set<String> $$robo$$android_app_RemoteInput$getAllowedDataTypes() {
        return this.mAllowedDataTypes;
    }

    private final boolean $$robo$$android_app_RemoteInput$isDataOnly() {
        return !this.getAllowFreeFormInput() && (this.getChoices() == null || this.getChoices().length == 0) && !this.getAllowedDataTypes().isEmpty();
    }

    private final boolean $$robo$$android_app_RemoteInput$getAllowFreeFormInput() {
        return (this.mFlags & 1) != 0;
    }

    private final Bundle $$robo$$android_app_RemoteInput$getExtras() {
        return this.mExtras;
    }

    private void $$robo$$android_app_RemoteInput$__constructor__(Parcel in) {
        this.mResultKey = in.readString();
        this.mLabel = in.readCharSequence();
        this.mChoices = in.readCharSequenceArray();
        this.mFlags = in.readInt();
        this.mExtras = in.readBundle();
        this.mAllowedDataTypes = in.readArraySet(null);
    }

    private static final Map<String, Uri> $$robo$$android_app_RemoteInput$getDataResultsFromIntent(Intent intent, String remoteInputResultKey) {
        Intent clipDataIntent = RemoteInput.getClipDataIntentFromIntent(intent);
        if (clipDataIntent == null) {
            return null;
        }
        HashMap<String, Uri> results = new HashMap<String, Uri>();
        Bundle extras = clipDataIntent.getExtras();
        for (String key : extras.keySet()) {
            Bundle bundle;
            String uriStr;
            String mimeType;
            if (!key.startsWith("android.remoteinput.dataTypeResultsData") || (mimeType = key.substring("android.remoteinput.dataTypeResultsData".length())) == null || mimeType.isEmpty() || (uriStr = (bundle = clipDataIntent.getBundleExtra(key)).getString(remoteInputResultKey)) == null || uriStr.isEmpty()) continue;
            results.put(mimeType, Uri.parse(uriStr));
        }
        return results.isEmpty() ? null : results;
    }

    private static final Bundle $$robo$$android_app_RemoteInput$getResultsFromIntent(Intent intent) {
        Intent clipDataIntent = RemoteInput.getClipDataIntentFromIntent(intent);
        if (clipDataIntent == null) {
            return null;
        }
        return (Bundle)clipDataIntent.getExtras().getParcelable("android.remoteinput.resultsData");
    }

    private static final void $$robo$$android_app_RemoteInput$addResultsToIntent(RemoteInput[] remoteInputs, Intent intent, Bundle results) {
        Bundle resultsBundle;
        Intent clipDataIntent = RemoteInput.getClipDataIntentFromIntent(intent);
        if (clipDataIntent == null) {
            clipDataIntent = new Intent();
        }
        if ((resultsBundle = clipDataIntent.getBundleExtra("android.remoteinput.resultsData")) == null) {
            resultsBundle = new Bundle();
        }
        for (RemoteInput remoteInput : remoteInputs) {
            Object result = results.get(remoteInput.getResultKey());
            if (!(result instanceof CharSequence)) continue;
            resultsBundle.putCharSequence(remoteInput.getResultKey(), (CharSequence)result);
        }
        clipDataIntent.putExtra("android.remoteinput.resultsData", resultsBundle);
        intent.setClipData(ClipData.newIntent("android.remoteinput.results", clipDataIntent));
    }

    private static final void $$robo$$android_app_RemoteInput$addDataResultToIntent(RemoteInput remoteInput, Intent intent, Map<String, Uri> results) {
        Intent clipDataIntent = RemoteInput.getClipDataIntentFromIntent(intent);
        if (clipDataIntent == null) {
            clipDataIntent = new Intent();
        }
        for (Map.Entry<String, Uri> entry : results.entrySet()) {
            String mimeType = entry.getKey();
            Uri uri = entry.getValue();
            if (mimeType == null) continue;
            Bundle resultsBundle = clipDataIntent.getBundleExtra(RemoteInput.getExtraResultsKeyForData(mimeType));
            if (resultsBundle == null) {
                resultsBundle = new Bundle();
            }
            resultsBundle.putString(remoteInput.getResultKey(), uri.toString());
            clipDataIntent.putExtra(RemoteInput.getExtraResultsKeyForData(mimeType), resultsBundle);
        }
        intent.setClipData(ClipData.newIntent("android.remoteinput.results", clipDataIntent));
    }

    private static final String $$robo$$android_app_RemoteInput$getExtraResultsKeyForData(String mimeType) {
        return "android.remoteinput.dataTypeResultsData" + mimeType;
    }

    private final int $$robo$$android_app_RemoteInput$describeContents() {
        return 0;
    }

    private final void $$robo$$android_app_RemoteInput$writeToParcel(Parcel out, int flags) {
        out.writeString(this.mResultKey);
        out.writeCharSequence(this.mLabel);
        out.writeCharSequenceArray(this.mChoices);
        out.writeInt(this.mFlags);
        out.writeBundle(this.mExtras);
        out.writeArraySet(this.mAllowedDataTypes);
    }

    private static final Intent $$robo$$android_app_RemoteInput$getClipDataIntentFromIntent(Intent intent) {
        ClipData clipData = intent.getClipData();
        if (clipData == null) {
            return null;
        }
        ClipDescription clipDescription = clipData.getDescription();
        if (!clipDescription.hasMimeType("text/vnd.android.intent")) {
            return null;
        }
        if (!clipDescription.getLabel().equals("android.remoteinput.results")) {
            return null;
        }
        return clipData.getItemAt(0).getIntent();
    }

    private /* synthetic */ void $$robo$$android_app_RemoteInput$__constructor__(String x0, CharSequence x1, CharSequence[] x2, int x3, Bundle x4, ArraySet x5, 1 x6) {
    }

    private /* synthetic */ void $$robo$$android_app_RemoteInput$__constructor__(Parcel x0, 1 x1) {
    }

    static void __staticInitializer__() {
        CREATOR = new Parcelable.Creator<RemoteInput>(){
            public /* synthetic */ Object __robo_data__;

            private void $$robo$$android_app_RemoteInput_1$__constructor__() {
            }

            private final RemoteInput $$robo$$android_app_RemoteInput_1$createFromParcel(Parcel in) {
                return new RemoteInput(in, null);
            }

            private final RemoteInput[] $$robo$$android_app_RemoteInput_1$newArray(int size) {
                return new RemoteInput[size];
            }

            private void __constructor__() {
                this.$$robo$$android_app_RemoteInput_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_RemoteInput_1$__constructor__(), this);
            }

            @Override
            public RemoteInput createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_app_RemoteInput_1$createFromParcel(android.os.Parcel ), this, parcel);
            }

            public RemoteInput[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_app_RemoteInput_1$newArray(int ), this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__(String string2, CharSequence charSequence, CharSequence[] charSequenceArray, int n, Bundle bundle, ArraySet<String> arraySet) {
        this.$$robo$$android_app_RemoteInput$__constructor__(string2, charSequence, charSequenceArray, n, bundle, arraySet);
    }

    public RemoteInput(String string2, CharSequence charSequence, CharSequence[] charSequenceArray, int n, Bundle bundle, ArraySet<String> arraySet) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_RemoteInput$__constructor__(java.lang.String java.lang.CharSequence java.lang.CharSequence[] int android.os.Bundle android.util.ArraySet<java.lang.String> ), this, string2, charSequence, charSequenceArray, n, bundle, arraySet);
    }

    public String getResultKey() {
        return InvokeDynamicSupport.bootstrap("getResultKey", $$robo$$android_app_RemoteInput$getResultKey(), this);
    }

    public CharSequence getLabel() {
        return InvokeDynamicSupport.bootstrap("getLabel", $$robo$$android_app_RemoteInput$getLabel(), this);
    }

    public CharSequence[] getChoices() {
        return InvokeDynamicSupport.bootstrap("getChoices", $$robo$$android_app_RemoteInput$getChoices(), this);
    }

    public Set<String> getAllowedDataTypes() {
        return InvokeDynamicSupport.bootstrap("getAllowedDataTypes", $$robo$$android_app_RemoteInput$getAllowedDataTypes(), this);
    }

    public boolean isDataOnly() {
        return (boolean)InvokeDynamicSupport.bootstrap("isDataOnly", $$robo$$android_app_RemoteInput$isDataOnly(), this);
    }

    public boolean getAllowFreeFormInput() {
        return (boolean)InvokeDynamicSupport.bootstrap("getAllowFreeFormInput", $$robo$$android_app_RemoteInput$getAllowFreeFormInput(), this);
    }

    public Bundle getExtras() {
        return InvokeDynamicSupport.bootstrap("getExtras", $$robo$$android_app_RemoteInput$getExtras(), this);
    }

    private void __constructor__(Parcel parcel) {
        this.$$robo$$android_app_RemoteInput$__constructor__(parcel);
    }

    public RemoteInput(Parcel parcel) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_RemoteInput$__constructor__(android.os.Parcel ), this, parcel);
    }

    public static Map<String, Uri> getDataResultsFromIntent(Intent intent, String string2) {
        return InvokeDynamicSupport.bootstrapStatic("getDataResultsFromIntent", $$robo$$android_app_RemoteInput$getDataResultsFromIntent(android.content.Intent java.lang.String ), (Intent)intent, (String)string2);
    }

    public static Bundle getResultsFromIntent(Intent intent) {
        return InvokeDynamicSupport.bootstrapStatic("getResultsFromIntent", $$robo$$android_app_RemoteInput$getResultsFromIntent(android.content.Intent ), (Intent)intent);
    }

    public static void addResultsToIntent(RemoteInput[] remoteInputArray, Intent intent, Bundle bundle) {
        InvokeDynamicSupport.bootstrapStatic("addResultsToIntent", $$robo$$android_app_RemoteInput$addResultsToIntent(android.app.RemoteInput[] android.content.Intent android.os.Bundle ), (RemoteInput[])remoteInputArray, (Intent)intent, (Bundle)bundle);
    }

    public static void addDataResultToIntent(RemoteInput remoteInput, Intent intent, Map<String, Uri> map) {
        InvokeDynamicSupport.bootstrapStatic("addDataResultToIntent", $$robo$$android_app_RemoteInput$addDataResultToIntent(android.app.RemoteInput android.content.Intent java.util.Map<java.lang.String, android.net.Uri> ), (RemoteInput)remoteInput, (Intent)intent, map);
    }

    private static String getExtraResultsKeyForData(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("getExtraResultsKeyForData", $$robo$$android_app_RemoteInput$getExtraResultsKeyForData(java.lang.String ), (String)string2);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_app_RemoteInput$describeContents(), this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_app_RemoteInput$writeToParcel(android.os.Parcel int ), this, parcel, n);
    }

    private static Intent getClipDataIntentFromIntent(Intent intent) {
        return InvokeDynamicSupport.bootstrapStatic("getClipDataIntentFromIntent", $$robo$$android_app_RemoteInput$getClipDataIntentFromIntent(android.content.Intent ), (Intent)intent);
    }

    private /* synthetic */ void __constructor__(String string2, CharSequence charSequence, CharSequence[] charSequenceArray, int n, Bundle bundle, ArraySet arraySet, 1 var7_7) {
        this.$$robo$$android_app_RemoteInput$__constructor__(string2, charSequence, charSequenceArray, n, bundle, arraySet, var7_7);
    }

    public /* synthetic */ RemoteInput(String string2, CharSequence charSequence, CharSequence[] charSequenceArray, int n, Bundle bundle, ArraySet arraySet, 1 var7_7) {
        this(string2, charSequence, charSequenceArray, n, bundle, arraySet);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_RemoteInput$__constructor__(java.lang.String java.lang.CharSequence java.lang.CharSequence[] int android.os.Bundle android.util.ArraySet android.app.RemoteInput$1 ), this, string2, charSequence, charSequenceArray, n, bundle, arraySet, var7_7);
    }

    private /* synthetic */ void __constructor__(Parcel parcel, 1 var2_2) {
        this.$$robo$$android_app_RemoteInput$__constructor__(parcel, var2_2);
    }

    public /* synthetic */ RemoteInput(Parcel parcel, 1 var2_2) {
        this(parcel);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_RemoteInput$__constructor__(android.os.Parcel android.app.RemoteInput$1 ), this, parcel, var2_2);
    }

    static {
        RobolectricInternals.classInitializing(RemoteInput.class);
    }

    public /* synthetic */ RemoteInput() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RemoteInput)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class Builder
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private String mResultKey;
        private CharSequence mLabel;
        private CharSequence[] mChoices;
        private int mFlags;
        private Bundle mExtras;
        private ArraySet<String> mAllowedDataTypes;

        private void $$robo$$android_app_RemoteInput_Builder$__constructor__(String resultKey) {
            this.mFlags = 1;
            this.mExtras = new Bundle();
            this.mAllowedDataTypes = new ArraySet();
            if (resultKey == null) {
                throw new IllegalArgumentException("Result key can't be null");
            }
            this.mResultKey = resultKey;
        }

        private final Builder $$robo$$android_app_RemoteInput_Builder$setLabel(CharSequence label) {
            this.mLabel = Notification.safeCharSequence(label);
            return this;
        }

        private final Builder $$robo$$android_app_RemoteInput_Builder$setChoices(CharSequence[] choices) {
            if (choices == null) {
                this.mChoices = null;
            } else {
                this.mChoices = new CharSequence[choices.length];
                for (int i = 0; i < choices.length; ++i) {
                    this.mChoices[i] = Notification.safeCharSequence(choices[i]);
                }
            }
            return this;
        }

        private final Builder $$robo$$android_app_RemoteInput_Builder$setAllowDataType(String mimeType, boolean doAllow) {
            if (doAllow) {
                this.mAllowedDataTypes.add(mimeType);
            } else {
                this.mAllowedDataTypes.remove(mimeType);
            }
            return this;
        }

        private final Builder $$robo$$android_app_RemoteInput_Builder$setAllowFreeFormInput(boolean allowFreeFormTextInput) {
            this.setFlag(this.mFlags, allowFreeFormTextInput);
            return this;
        }

        private final Builder $$robo$$android_app_RemoteInput_Builder$addExtras(Bundle extras) {
            if (extras != null) {
                this.mExtras.putAll(extras);
            }
            return this;
        }

        private final Bundle $$robo$$android_app_RemoteInput_Builder$getExtras() {
            return this.mExtras;
        }

        private final void $$robo$$android_app_RemoteInput_Builder$setFlag(int mask, boolean value) {
            this.mFlags = value ? (this.mFlags |= mask) : (this.mFlags &= ~mask);
        }

        private final RemoteInput $$robo$$android_app_RemoteInput_Builder$build() {
            return new RemoteInput(this.mResultKey, this.mLabel, this.mChoices, this.mFlags, this.mExtras, this.mAllowedDataTypes, null);
        }

        private void __constructor__(String string2) {
            this.$$robo$$android_app_RemoteInput_Builder$__constructor__(string2);
        }

        public Builder(String string2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_RemoteInput_Builder$__constructor__(java.lang.String ), this, string2);
        }

        public Builder setLabel(CharSequence charSequence) {
            return InvokeDynamicSupport.bootstrap("setLabel", $$robo$$android_app_RemoteInput_Builder$setLabel(java.lang.CharSequence ), this, charSequence);
        }

        public Builder setChoices(CharSequence[] charSequenceArray) {
            return InvokeDynamicSupport.bootstrap("setChoices", $$robo$$android_app_RemoteInput_Builder$setChoices(java.lang.CharSequence[] ), this, charSequenceArray);
        }

        public Builder setAllowDataType(String string2, boolean bl) {
            return InvokeDynamicSupport.bootstrap("setAllowDataType", $$robo$$android_app_RemoteInput_Builder$setAllowDataType(java.lang.String boolean ), this, string2, bl);
        }

        public Builder setAllowFreeFormInput(boolean bl) {
            return InvokeDynamicSupport.bootstrap("setAllowFreeFormInput", $$robo$$android_app_RemoteInput_Builder$setAllowFreeFormInput(boolean ), this, bl);
        }

        public Builder addExtras(Bundle bundle) {
            return InvokeDynamicSupport.bootstrap("addExtras", $$robo$$android_app_RemoteInput_Builder$addExtras(android.os.Bundle ), this, bundle);
        }

        public Bundle getExtras() {
            return InvokeDynamicSupport.bootstrap("getExtras", $$robo$$android_app_RemoteInput_Builder$getExtras(), this);
        }

        private void setFlag(int n, boolean bl) {
            InvokeDynamicSupport.bootstrap("setFlag", $$robo$$android_app_RemoteInput_Builder$setFlag(int boolean ), this, n, bl);
        }

        public RemoteInput build() {
            return InvokeDynamicSupport.bootstrap("build", $$robo$$android_app_RemoteInput_Builder$build(), this);
        }

        public /* synthetic */ Builder() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Builder)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

