/*
 * Decompiled with CFR 0.152.
 */
package libcore.util;

import android.system.ErrnoException;
import com.google.errorprone.annotations.DoNotMock;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import libcore.io.BufferIterator;
import libcore.io.MemoryMappedFile;
import libcore.util.BasicLruCache;
import libcore.util.ZoneInfo;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
public class ZoneInfoDB
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static TzData DATA;

    private void $$robo$$libcore_util_ZoneInfoDB$__constructor__() {
    }

    private static final TzData $$robo$$libcore_util_ZoneInfoDB$getInstance() {
        return DATA;
    }

    static void __staticInitializer__() {
        DATA = new TzData(System.getenv("ANDROID_DATA") + "/misc/zoneinfo/current/tzdata", System.getenv("ANDROID_ROOT") + "/usr/share/zoneinfo/tzdata");
    }

    private void __constructor__() {
        this.$$robo$$libcore_util_ZoneInfoDB$__constructor__();
    }

    private ZoneInfoDB() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$libcore_util_ZoneInfoDB$__constructor__(), 0, this);
    }

    public static TzData getInstance() {
        return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$libcore_util_ZoneInfoDB$getInstance(), 0);
    }

    static {
        RobolectricInternals.classInitializing(ZoneInfoDB.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ZoneInfoDB)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class TzData
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private MemoryMappedFile mappedFile;
        private String version;
        private String zoneTab;
        private String[] ids;
        private int[] byteOffsets;
        private int[] rawUtcOffsetsCache;
        private static int CACHE_SIZE = 1;
        private BasicLruCache<String, ZoneInfo> cache;

        private void $$robo$$libcore_util_ZoneInfoDB_TzData$__constructor__(String ... paths) {
            this.cache = new BasicLruCache<String, ZoneInfo>(this, 1){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ TzData this$0;

                private void $$robo$$libcore_util_ZoneInfoDB_TzData_1$__constructor__(TzData this$0, int maxSize) {
                }

                private final ZoneInfo $$robo$$libcore_util_ZoneInfoDB_TzData_1$create(String id2) {
                    BufferIterator it = this.this$0.getBufferIterator(id2);
                    if (it == null) {
                        return null;
                    }
                    return ZoneInfo.makeTimeZone(id2, it);
                }

                private void __constructor__(TzData tzData, int n) {
                    this.$$robo$$libcore_util_ZoneInfoDB_TzData_1$__constructor__(tzData, n);
                }
                {
                    this.this$0 = tzData;
                    super(n);
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$libcore_util_ZoneInfoDB_TzData_1$__constructor__(libcore.util.ZoneInfoDB$TzData int ), 0, this, tzData, n);
                }

                @Override
                protected ZoneInfo create(String string2) {
                    return InvokeDynamicSupport.bootstrap("create", $$robo$$libcore_util_ZoneInfoDB_TzData_1$create(java.lang.String ), 0, this, string2);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
            for (String path : paths) {
                if (!this.loadData(path)) continue;
                return;
            }
            InvokeDynamicSupport.bootstrapIntrinsic("logE", "java.lang.System", (String)"Couldn't find any tzdata!");
            this.version = "missing";
            this.zoneTab = "# Emergency fallback data.\n";
            this.ids = new String[]{"GMT"};
            this.rawUtcOffsetsCache = new int[1];
            this.byteOffsets = this.rawUtcOffsetsCache;
        }

        private final BufferIterator $$robo$$libcore_util_ZoneInfoDB_TzData$getBufferIterator(String id2) {
            int index = Arrays.binarySearch(this.ids, id2);
            if (index < 0) {
                return null;
            }
            BufferIterator it = this.mappedFile.bigEndianIterator();
            it.skip(this.byteOffsets[index]);
            return it;
        }

        private final boolean $$robo$$libcore_util_ZoneInfoDB_TzData$loadData(String path) {
            try {
                this.mappedFile = MemoryMappedFile.mmapRO(path);
            }
            catch (ErrnoException errnoException) {
                return false;
            }
            try {
                this.readHeader();
                return true;
            }
            catch (Exception ex) {
                InvokeDynamicSupport.bootstrapIntrinsic("logE", "java.lang.System", (String)("tzdata file \"" + path + "\" was present but invalid!"), (Throwable)ex);
                return false;
            }
        }

        private final void $$robo$$libcore_util_ZoneInfoDB_TzData$readHeader() {
            BufferIterator it = this.mappedFile.bigEndianIterator();
            byte[] tzdata_version = new byte[12];
            it.readByteArray(tzdata_version, 0, tzdata_version.length);
            String magic = new String(tzdata_version, 0, 6, StandardCharsets.US_ASCII);
            if (!magic.equals("tzdata") || tzdata_version[11] != 0) {
                throw new RuntimeException("bad tzdata magic: " + Arrays.toString(tzdata_version));
            }
            this.version = new String(tzdata_version, 6, 5, StandardCharsets.US_ASCII);
            int index_offset = it.readInt();
            int data_offset = it.readInt();
            int zonetab_offset = it.readInt();
            this.readIndex(it, index_offset, data_offset);
            this.readZoneTab(it, zonetab_offset, (int)this.mappedFile.size() - zonetab_offset);
        }

        private final void $$robo$$libcore_util_ZoneInfoDB_TzData$readZoneTab(BufferIterator it, int zoneTabOffset, int zoneTabSize) {
            byte[] bytes = new byte[zoneTabSize];
            it.seek(zoneTabOffset);
            it.readByteArray(bytes, 0, bytes.length);
            this.zoneTab = new String(bytes, 0, bytes.length, StandardCharsets.US_ASCII);
        }

        private final void $$robo$$libcore_util_ZoneInfoDB_TzData$readIndex(BufferIterator it, int indexOffset, int dataOffset) {
            it.seek(indexOffset);
            int SIZEOF_TZNAME = 40;
            int SIZEOF_TZINT = 4;
            byte[] idBytes = new byte[40];
            int indexSize = dataOffset - indexOffset;
            int entryCount = indexSize / 52;
            char[] idChars = new char[entryCount * 40];
            int[] idEnd = new int[entryCount];
            int idOffset = 0;
            this.byteOffsets = new int[entryCount];
            for (int i = 0; i < entryCount; ++i) {
                it.readByteArray(idBytes, 0, idBytes.length);
                this.byteOffsets[i] = it.readInt();
                int n = i;
                this.byteOffsets[n] = this.byteOffsets[n] + dataOffset;
                int length = it.readInt();
                if (length < 44) {
                    throw new AssertionError((Object)"length in index file < sizeof(tzhead)");
                }
                it.skip(4);
                int len = idBytes.length;
                for (int j = 0; j < len && idBytes[j] != 0; ++j) {
                    idChars[idOffset++] = (char)(idBytes[j] & 0xFF);
                }
                idEnd[i] = idOffset;
            }
            String allIds = new String(idChars, 0, idOffset);
            this.ids = new String[entryCount];
            for (int i = 0; i < entryCount; ++i) {
                this.ids[i] = allIds.substring(i == 0 ? 0 : idEnd[i - 1], idEnd[i]);
            }
        }

        private final String[] $$robo$$libcore_util_ZoneInfoDB_TzData$getAvailableIDs() {
            return (String[])this.ids.clone();
        }

        private final String[] $$robo$$libcore_util_ZoneInfoDB_TzData$getAvailableIDs(int rawUtcOffset) {
            ArrayList<String> matches = new ArrayList<String>();
            int[] rawUtcOffsets = this.getRawUtcOffsets();
            for (int i = 0; i < rawUtcOffsets.length; ++i) {
                if (rawUtcOffsets[i] != rawUtcOffset) continue;
                matches.add(this.ids[i]);
            }
            return matches.toArray(new String[matches.size()]);
        }

        private final synchronized int[] $$robo$$libcore_util_ZoneInfoDB_TzData$getRawUtcOffsets() {
            if (this.rawUtcOffsetsCache != null) {
                return this.rawUtcOffsetsCache;
            }
            this.rawUtcOffsetsCache = new int[this.ids.length];
            for (int i = 0; i < this.ids.length; ++i) {
                this.rawUtcOffsetsCache[i] = this.cache.get(this.ids[i]).getRawOffset();
            }
            return this.rawUtcOffsetsCache;
        }

        private final String $$robo$$libcore_util_ZoneInfoDB_TzData$getVersion() {
            return this.version;
        }

        private final String $$robo$$libcore_util_ZoneInfoDB_TzData$getZoneTab() {
            return this.zoneTab;
        }

        private final ZoneInfo $$robo$$libcore_util_ZoneInfoDB_TzData$makeTimeZone(String id2) throws IOException {
            ZoneInfo zoneInfo = this.cache.get(id2);
            return zoneInfo == null ? null : (ZoneInfo)zoneInfo.clone();
        }

        private final boolean $$robo$$libcore_util_ZoneInfoDB_TzData$hasTimeZone(String id2) throws IOException {
            return this.cache.get(id2) != null;
        }

        private final void $$robo$$libcore_util_ZoneInfoDB_TzData$finalize() throws Throwable {
            if (this.mappedFile != null) {
                this.mappedFile.close();
            }
            super.finalize();
        }

        private void __constructor__(String ... stringArray) {
            this.$$robo$$libcore_util_ZoneInfoDB_TzData$__constructor__(stringArray);
        }

        public TzData(String ... stringArray) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$libcore_util_ZoneInfoDB_TzData$__constructor__(java.lang.String[] ), 0, this, stringArray);
        }

        public BufferIterator getBufferIterator(String string2) {
            return InvokeDynamicSupport.bootstrap("getBufferIterator", $$robo$$libcore_util_ZoneInfoDB_TzData$getBufferIterator(java.lang.String ), 0, this, string2);
        }

        private boolean loadData(String string2) {
            return (boolean)InvokeDynamicSupport.bootstrap("loadData", $$robo$$libcore_util_ZoneInfoDB_TzData$loadData(java.lang.String ), 0, this, string2);
        }

        private void readHeader() {
            InvokeDynamicSupport.bootstrap("readHeader", $$robo$$libcore_util_ZoneInfoDB_TzData$readHeader(), 0, this);
        }

        private void readZoneTab(BufferIterator bufferIterator, int n, int n2) {
            InvokeDynamicSupport.bootstrap("readZoneTab", $$robo$$libcore_util_ZoneInfoDB_TzData$readZoneTab(libcore.io.BufferIterator int int ), 0, this, bufferIterator, n, n2);
        }

        private void readIndex(BufferIterator bufferIterator, int n, int n2) {
            InvokeDynamicSupport.bootstrap("readIndex", $$robo$$libcore_util_ZoneInfoDB_TzData$readIndex(libcore.io.BufferIterator int int ), 0, this, bufferIterator, n, n2);
        }

        public String[] getAvailableIDs() {
            return InvokeDynamicSupport.bootstrap("getAvailableIDs", $$robo$$libcore_util_ZoneInfoDB_TzData$getAvailableIDs(), 0, this);
        }

        public String[] getAvailableIDs(int n) {
            return InvokeDynamicSupport.bootstrap("getAvailableIDs", $$robo$$libcore_util_ZoneInfoDB_TzData$getAvailableIDs(int ), 0, this, n);
        }

        private synchronized int[] getRawUtcOffsets() {
            return InvokeDynamicSupport.bootstrap("getRawUtcOffsets", $$robo$$libcore_util_ZoneInfoDB_TzData$getRawUtcOffsets(), 0, this);
        }

        public String getVersion() {
            return InvokeDynamicSupport.bootstrap("getVersion", $$robo$$libcore_util_ZoneInfoDB_TzData$getVersion(), 0, this);
        }

        public String getZoneTab() {
            return InvokeDynamicSupport.bootstrap("getZoneTab", $$robo$$libcore_util_ZoneInfoDB_TzData$getZoneTab(), 0, this);
        }

        public ZoneInfo makeTimeZone(String string2) throws IOException {
            return InvokeDynamicSupport.bootstrap("makeTimeZone", $$robo$$libcore_util_ZoneInfoDB_TzData$makeTimeZone(java.lang.String ), 0, this, string2);
        }

        public boolean hasTimeZone(String string2) throws IOException {
            return (boolean)InvokeDynamicSupport.bootstrap("hasTimeZone", $$robo$$libcore_util_ZoneInfoDB_TzData$hasTimeZone(java.lang.String ), 0, this, string2);
        }

        protected void finalize() throws Throwable {
            InvokeDynamicSupport.bootstrap("finalize", $$robo$$libcore_util_ZoneInfoDB_TzData$finalize(), 0, this);
        }

        public /* synthetic */ TzData() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TzData)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

