/*
 * Decompiled with CFR 0.152.
 */
package libcore.tzdata.update;

import com.google.errorprone.annotations.DoNotMock;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.zip.CRC32;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
public class FileUtils
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;

    private void $$robo$$libcore_tzdata_update_FileUtils$__constructor__() {
    }

    private static final File $$robo$$libcore_tzdata_update_FileUtils$createSubFile(File parentDir, String name) throws IOException {
        File subFile = new File(parentDir, name).getCanonicalFile();
        if (!subFile.getPath().startsWith(parentDir.getCanonicalPath())) {
            throw new IOException(name + " must exist beneath " + parentDir + ". Canonicalized subpath: " + subFile);
        }
        return subFile;
    }

    private static final void $$robo$$libcore_tzdata_update_FileUtils$ensureDirectoriesExist(File dir, boolean makeWorldReadable) throws IOException {
        LinkedList<File> dirs = new LinkedList<File>();
        File currentDir = dir;
        do {
            dirs.addFirst(currentDir);
        } while ((currentDir = currentDir.getParentFile()) != null);
        for (File dirToCheck : dirs) {
            if (!dirToCheck.exists()) {
                if (!dirToCheck.mkdir()) {
                    throw new IOException("Unable to create directory: " + dir);
                }
                if (!makeWorldReadable) continue;
                FileUtils.makeDirectoryWorldAccessible(dirToCheck);
                continue;
            }
            if (dirToCheck.isDirectory()) continue;
            throw new IOException(dirToCheck + " exists but is not a directory");
        }
    }

    private static final void $$robo$$libcore_tzdata_update_FileUtils$makeDirectoryWorldAccessible(File directory) throws IOException {
        if (!directory.isDirectory()) {
            throw new IOException(directory + " must be a directory");
        }
        FileUtils.makeWorldReadable(directory);
        if (!directory.setExecutable(true, false)) {
            throw new IOException("Unable to make " + directory + " world-executable");
        }
    }

    private static final void $$robo$$libcore_tzdata_update_FileUtils$makeWorldReadable(File file) throws IOException {
        if (!file.setReadable(true, false)) {
            throw new IOException("Unable to make " + file + " world-readable");
        }
    }

    private static final long $$robo$$libcore_tzdata_update_FileUtils$calculateChecksum(File file) throws IOException {
        int BUFFER_SIZE = 8196;
        CRC32 crc32 = new CRC32();
        try (FileInputStream fis = new FileInputStream(file);){
            int count;
            byte[] buffer = new byte[8196];
            while ((count = fis.read(buffer)) != -1) {
                crc32.update(buffer, 0, count);
            }
        }
        return crc32.getValue();
    }

    private static final void $$robo$$libcore_tzdata_update_FileUtils$rename(File from, File to) throws IOException {
        FileUtils.ensureFileDoesNotExist(to);
        if (!from.renameTo(to)) {
            throw new IOException("Unable to rename " + from + " to " + to);
        }
    }

    private static final void $$robo$$libcore_tzdata_update_FileUtils$ensureFileDoesNotExist(File file) throws IOException {
        if (file.exists()) {
            if (!file.isFile()) {
                throw new IOException(file + " is not a file");
            }
            FileUtils.doDelete(file);
        }
    }

    private static final void $$robo$$libcore_tzdata_update_FileUtils$doDelete(File file) throws IOException {
        if (!file.delete()) {
            throw new IOException("Unable to delete: " + file);
        }
    }

    private static final boolean $$robo$$libcore_tzdata_update_FileUtils$isSymlink(File file) throws IOException {
        String baseName = file.getName();
        String canonicalPathExceptBaseName = new File(file.getParentFile().getCanonicalFile(), baseName).getPath();
        return !file.getCanonicalPath().equals(canonicalPathExceptBaseName);
    }

    private static final void $$robo$$libcore_tzdata_update_FileUtils$deleteRecursive(File toDelete) throws IOException {
        if (toDelete.isDirectory()) {
            for (File file : toDelete.listFiles()) {
                if (file.isDirectory() && !FileUtils.isSymlink(file)) {
                    FileUtils.deleteRecursive(file);
                    continue;
                }
                FileUtils.doDelete(file);
            }
            Object[] remainingFiles = toDelete.list();
            if (remainingFiles.length != 0) {
                throw new IOException("Unable to delete files: " + Arrays.toString(remainingFiles));
            }
        }
        FileUtils.doDelete(toDelete);
    }

    private static final boolean $$robo$$libcore_tzdata_update_FileUtils$filesExist(File rootDir, String ... fileNames) throws IOException {
        for (String fileName : fileNames) {
            File file = new File(rootDir, fileName);
            if (file.exists()) continue;
            return false;
        }
        return true;
    }

    private static final List<String> $$robo$$libcore_tzdata_update_FileUtils$readLines(File file) throws IOException {
        FileInputStream in = new FileInputStream(file);
        try (BufferedReader fileReader = new BufferedReader(new InputStreamReader((InputStream)in, StandardCharsets.UTF_8));){
            String line;
            ArrayList<String> lines = new ArrayList<String>();
            while ((line = fileReader.readLine()) != null) {
                lines.add(line);
            }
            ArrayList<String> arrayList = lines;
            return arrayList;
        }
    }

    private void __constructor__() {
        this.$$robo$$libcore_tzdata_update_FileUtils$__constructor__();
    }

    private FileUtils() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$libcore_tzdata_update_FileUtils$__constructor__(), 0, this);
    }

    public static File createSubFile(File file, String string2) throws IOException {
        return InvokeDynamicSupport.bootstrapStatic("createSubFile", $$robo$$libcore_tzdata_update_FileUtils$createSubFile(java.io.File java.lang.String ), 0, (File)file, (String)string2);
    }

    public static void ensureDirectoriesExist(File file, boolean bl) throws IOException {
        InvokeDynamicSupport.bootstrapStatic("ensureDirectoriesExist", $$robo$$libcore_tzdata_update_FileUtils$ensureDirectoriesExist(java.io.File boolean ), 0, (File)file, (boolean)bl);
    }

    public static void makeDirectoryWorldAccessible(File file) throws IOException {
        InvokeDynamicSupport.bootstrapStatic("makeDirectoryWorldAccessible", $$robo$$libcore_tzdata_update_FileUtils$makeDirectoryWorldAccessible(java.io.File ), 0, (File)file);
    }

    public static void makeWorldReadable(File file) throws IOException {
        InvokeDynamicSupport.bootstrapStatic("makeWorldReadable", $$robo$$libcore_tzdata_update_FileUtils$makeWorldReadable(java.io.File ), 0, (File)file);
    }

    public static long calculateChecksum(File file) throws IOException {
        return (long)InvokeDynamicSupport.bootstrapStatic("calculateChecksum", $$robo$$libcore_tzdata_update_FileUtils$calculateChecksum(java.io.File ), 0, (File)file);
    }

    public static void rename(File file, File file2) throws IOException {
        InvokeDynamicSupport.bootstrapStatic("rename", $$robo$$libcore_tzdata_update_FileUtils$rename(java.io.File java.io.File ), 0, (File)file, (File)file2);
    }

    public static void ensureFileDoesNotExist(File file) throws IOException {
        InvokeDynamicSupport.bootstrapStatic("ensureFileDoesNotExist", $$robo$$libcore_tzdata_update_FileUtils$ensureFileDoesNotExist(java.io.File ), 0, (File)file);
    }

    public static void doDelete(File file) throws IOException {
        InvokeDynamicSupport.bootstrapStatic("doDelete", $$robo$$libcore_tzdata_update_FileUtils$doDelete(java.io.File ), 0, (File)file);
    }

    public static boolean isSymlink(File file) throws IOException {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isSymlink", $$robo$$libcore_tzdata_update_FileUtils$isSymlink(java.io.File ), 0, (File)file);
    }

    public static void deleteRecursive(File file) throws IOException {
        InvokeDynamicSupport.bootstrapStatic("deleteRecursive", $$robo$$libcore_tzdata_update_FileUtils$deleteRecursive(java.io.File ), 0, (File)file);
    }

    public static boolean filesExist(File file, String ... stringArray) throws IOException {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("filesExist", $$robo$$libcore_tzdata_update_FileUtils$filesExist(java.io.File java.lang.String[] ), 0, (File)file, (String[])stringArray);
    }

    public static List<String> readLines(File file) throws IOException {
        return InvokeDynamicSupport.bootstrapStatic("readLines", $$robo$$libcore_tzdata_update_FileUtils$readLines(java.io.File ), 0, (File)file);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (FileUtils)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

