/*
 * Decompiled with CFR 0.152.
 */
package libcore.tzdata.update;

import com.google.errorprone.annotations.DoNotMock;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import libcore.tzdata.update.FileUtils;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
public class ConfigBundle
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static String TZ_DATA_VERSION_FILE_NAME = "tzdata_version";
    public static String CHECKSUMS_FILE_NAME = "checksums";
    public static String ZONEINFO_FILE_NAME = "tzdata";
    public static String ICU_DATA_FILE_NAME = "icu/icu_tzdata.dat";
    private static int BUFFER_SIZE = 8192;
    private byte[] bytes;

    private void $$robo$$libcore_tzdata_update_ConfigBundle$__constructor__(byte[] bytes) {
        this.bytes = bytes;
    }

    private final byte[] $$robo$$libcore_tzdata_update_ConfigBundle$getBundleBytes() {
        return this.bytes;
    }

    private final void $$robo$$libcore_tzdata_update_ConfigBundle$extractTo(File targetDir) throws IOException {
        ConfigBundle.extractZipSafely(new ByteArrayInputStream(this.bytes), targetDir, true);
    }

    private static final void $$robo$$libcore_tzdata_update_ConfigBundle$extractZipSafely(InputStream is, File targetDir, boolean makeWorldReadable) throws IOException {
        FileUtils.ensureDirectoriesExist(targetDir, makeWorldReadable);
        try (ZipInputStream zipInputStream = new ZipInputStream(is);){
            ZipEntry entry;
            byte[] buffer = new byte[8192];
            while ((entry = zipInputStream.getNextEntry()) != null) {
                String name = entry.getName();
                File entryFile = FileUtils.createSubFile(targetDir, name);
                if (entry.isDirectory()) {
                    FileUtils.ensureDirectoriesExist(entryFile, makeWorldReadable);
                    continue;
                }
                if (!entryFile.getParentFile().exists()) {
                    FileUtils.ensureDirectoriesExist(entryFile.getParentFile(), makeWorldReadable);
                }
                try (FileOutputStream fos = new FileOutputStream(entryFile);){
                    int count;
                    while ((count = zipInputStream.read(buffer)) != -1) {
                        fos.write(buffer, 0, count);
                    }
                    fos.getFD().sync();
                }
                if (!makeWorldReadable) continue;
                FileUtils.makeWorldReadable(entryFile);
            }
        }
    }

    private final boolean $$robo$$libcore_tzdata_update_ConfigBundle$equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConfigBundle that = (ConfigBundle)o;
        return Arrays.equals(this.bytes, that.bytes);
    }

    private void __constructor__(byte[] byArray) {
        this.$$robo$$libcore_tzdata_update_ConfigBundle$__constructor__(byArray);
    }

    public ConfigBundle(byte[] byArray) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$libcore_tzdata_update_ConfigBundle$__constructor__(byte[] ), 0, this, byArray);
    }

    public byte[] getBundleBytes() {
        return InvokeDynamicSupport.bootstrap("getBundleBytes", $$robo$$libcore_tzdata_update_ConfigBundle$getBundleBytes(), 0, this);
    }

    public void extractTo(File file) throws IOException {
        InvokeDynamicSupport.bootstrap("extractTo", $$robo$$libcore_tzdata_update_ConfigBundle$extractTo(java.io.File ), 0, this, file);
    }

    static void extractZipSafely(InputStream inputStream, File file, boolean bl) throws IOException {
        InvokeDynamicSupport.bootstrapStatic("extractZipSafely", $$robo$$libcore_tzdata_update_ConfigBundle$extractZipSafely(java.io.InputStream java.io.File boolean ), 0, (InputStream)inputStream, (File)file, (boolean)bl);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$libcore_tzdata_update_ConfigBundle$equals(java.lang.Object ), 0, this, object);
    }

    public /* synthetic */ ConfigBundle() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ConfigBundle)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

