/*
 * Decompiled with CFR 0.152.
 */
package libcore.reflect;

import com.google.errorprone.annotations.DoNotMock;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.annotation.AnnotationTypeMismatchException;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
public class AnnotationMember
implements Serializable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    protected static char ERROR = '!';
    protected static char ARRAY = '[';
    protected static char OTHER = '*';
    protected static Object NO_VALUE;
    protected String name;
    protected Object value;
    protected char tag;
    protected transient Class<?> elementType;
    protected transient Method definingMethod;

    private void $$robo$$libcore_reflect_AnnotationMember$__constructor__(String name, Object val) {
        this.name = name;
        Object object = this.value = val == null ? NO_VALUE : val;
        this.tag = this.value instanceof Throwable ? (char)33 : (this.value.getClass().isArray() ? (char)91 : (char)42);
    }

    private void $$robo$$libcore_reflect_AnnotationMember$__constructor__(String name, Object val, Class type, Method m) {
        this.definingMethod = m;
        this.elementType = type == Integer.TYPE ? Integer.class : (type == Boolean.TYPE ? Boolean.class : (type == Character.TYPE ? Character.class : (type == Float.TYPE ? Float.class : (type == Double.TYPE ? Double.class : (type == Long.TYPE ? Long.class : (type == Short.TYPE ? Short.class : (type == Byte.TYPE ? Byte.class : type)))))));
    }

    private final AnnotationMember $$robo$$libcore_reflect_AnnotationMember$setDefinition(AnnotationMember copy) {
        this.definingMethod = copy.definingMethod;
        this.elementType = copy.elementType;
        return this;
    }

    private final String $$robo$$libcore_reflect_AnnotationMember$toString() {
        if (this.tag == '[') {
            StringBuilder sb = new StringBuilder(80);
            sb.append(this.name).append("=[");
            int len = Array.getLength(this.value);
            for (int i = 0; i < len; ++i) {
                if (i != 0) {
                    sb.append(", ");
                }
                sb.append(Array.get(this.value, i));
            }
            return sb.append("]").toString();
        }
        return this.name + "=" + this.value;
    }

    private final boolean $$robo$$libcore_reflect_AnnotationMember$equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof AnnotationMember) {
            AnnotationMember that = (AnnotationMember)obj;
            if (this.name.equals(that.name) && this.tag == that.tag) {
                if (this.tag == '[') {
                    return this.equalArrayValue(that.value);
                }
                if (this.tag == '!') {
                    return false;
                }
                return this.value.equals(that.value);
            }
        }
        return false;
    }

    private final boolean $$robo$$libcore_reflect_AnnotationMember$equalArrayValue(Object otherValue) {
        if (this.value instanceof Object[] && otherValue instanceof Object[]) {
            return Arrays.equals((Object[])this.value, (Object[])otherValue);
        }
        Class<?> type = this.value.getClass();
        if (type != otherValue.getClass()) {
            return false;
        }
        if (type == int[].class) {
            return Arrays.equals((int[])this.value, (int[])otherValue);
        }
        if (type == byte[].class) {
            return Arrays.equals((byte[])this.value, (byte[])otherValue);
        }
        if (type == short[].class) {
            return Arrays.equals((short[])this.value, (short[])otherValue);
        }
        if (type == long[].class) {
            return Arrays.equals((long[])this.value, (long[])otherValue);
        }
        if (type == char[].class) {
            return Arrays.equals((char[])this.value, (char[])otherValue);
        }
        if (type == boolean[].class) {
            return Arrays.equals((boolean[])this.value, (boolean[])otherValue);
        }
        if (type == float[].class) {
            return Arrays.equals((float[])this.value, (float[])otherValue);
        }
        if (type == double[].class) {
            return Arrays.equals((double[])this.value, (double[])otherValue);
        }
        return false;
    }

    private final int $$robo$$libcore_reflect_AnnotationMember$hashCode() {
        int hash = this.name.hashCode() * 127;
        if (this.tag == '[') {
            Class<?> type = this.value.getClass();
            if (type == int[].class) {
                return hash ^ Arrays.hashCode((int[])this.value);
            }
            if (type == byte[].class) {
                return hash ^ Arrays.hashCode((byte[])this.value);
            }
            if (type == short[].class) {
                return hash ^ Arrays.hashCode((short[])this.value);
            }
            if (type == long[].class) {
                return hash ^ Arrays.hashCode((long[])this.value);
            }
            if (type == char[].class) {
                return hash ^ Arrays.hashCode((char[])this.value);
            }
            if (type == boolean[].class) {
                return hash ^ Arrays.hashCode((boolean[])this.value);
            }
            if (type == float[].class) {
                return hash ^ Arrays.hashCode((float[])this.value);
            }
            if (type == double[].class) {
                return hash ^ Arrays.hashCode((double[])this.value);
            }
            return hash ^ Arrays.hashCode((Object[])this.value);
        }
        return hash ^ this.value.hashCode();
    }

    private final void $$robo$$libcore_reflect_AnnotationMember$rethrowError() throws Throwable {
        if (this.tag == '!') {
            if (this.value instanceof TypeNotPresentException) {
                TypeNotPresentException tnpe = (TypeNotPresentException)this.value;
                throw new TypeNotPresentException(tnpe.typeName(), tnpe.getCause());
            }
            if (this.value instanceof EnumConstantNotPresentException) {
                EnumConstantNotPresentException ecnpe = (EnumConstantNotPresentException)this.value;
                throw new EnumConstantNotPresentException(ecnpe.enumType(), ecnpe.constantName());
            }
            if (this.value instanceof ArrayStoreException) {
                ArrayStoreException ase = (ArrayStoreException)this.value;
                throw new ArrayStoreException(ase.getMessage());
            }
            Throwable error = (Throwable)this.value;
            StackTraceElement[] ste = error.getStackTrace();
            ByteArrayOutputStream bos = new ByteArrayOutputStream(ste == null ? 512 : (ste.length + 1) * 80);
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeObject(error);
            oos.flush();
            oos.close();
            ByteArrayInputStream bis = new ByteArrayInputStream(bos.toByteArray());
            ObjectInputStream ois = new ObjectInputStream(bis);
            error = (Throwable)ois.readObject();
            ois.close();
            throw error;
        }
    }

    private final Object $$robo$$libcore_reflect_AnnotationMember$validateValue() throws Throwable {
        if (this.tag == '!') {
            this.rethrowError();
        }
        if (this.value == NO_VALUE) {
            return null;
        }
        if (this.elementType == this.value.getClass() || this.elementType.isInstance(this.value)) {
            return this.copyValue();
        }
        throw new AnnotationTypeMismatchException(this.definingMethod, this.value.getClass().getName());
    }

    private final Object $$robo$$libcore_reflect_AnnotationMember$copyValue() throws Throwable {
        if (this.tag != '[' || Array.getLength(this.value) == 0) {
            return this.value;
        }
        Class<?> type = this.value.getClass();
        if (type == int[].class) {
            return ((int[])this.value).clone();
        }
        if (type == byte[].class) {
            return ((byte[])this.value).clone();
        }
        if (type == short[].class) {
            return ((short[])this.value).clone();
        }
        if (type == long[].class) {
            return ((long[])this.value).clone();
        }
        if (type == char[].class) {
            return ((char[])this.value).clone();
        }
        if (type == boolean[].class) {
            return ((boolean[])this.value).clone();
        }
        if (type == float[].class) {
            return ((float[])this.value).clone();
        }
        if (type == double[].class) {
            return ((double[])this.value).clone();
        }
        return ((Object[])this.value).clone();
    }

    static void __staticInitializer__() {
        NO_VALUE = DefaultValues.NO_VALUE;
    }

    private void __constructor__(String string2, Object object) {
        this.$$robo$$libcore_reflect_AnnotationMember$__constructor__(string2, object);
    }

    public AnnotationMember(String string2, Object object) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$libcore_reflect_AnnotationMember$__constructor__(java.lang.String java.lang.Object ), 0, this, string2, object);
    }

    private void __constructor__(String string2, Object object, Class clazz, Method method) {
        this.$$robo$$libcore_reflect_AnnotationMember$__constructor__(string2, object, clazz, method);
    }

    public AnnotationMember(String string2, Object object, Class clazz, Method method) {
        this(string2, object);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$libcore_reflect_AnnotationMember$__constructor__(java.lang.String java.lang.Object java.lang.Class java.lang.reflect.Method ), 0, this, string2, object, clazz, method);
    }

    protected AnnotationMember setDefinition(AnnotationMember annotationMember) {
        return InvokeDynamicSupport.bootstrap("setDefinition", $$robo$$libcore_reflect_AnnotationMember$setDefinition(libcore.reflect.AnnotationMember ), 0, this, annotationMember);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$libcore_reflect_AnnotationMember$toString(), 0, this);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$libcore_reflect_AnnotationMember$equals(java.lang.Object ), 0, this, object);
    }

    public boolean equalArrayValue(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equalArrayValue", $$robo$$libcore_reflect_AnnotationMember$equalArrayValue(java.lang.Object ), 0, this, object);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$libcore_reflect_AnnotationMember$hashCode(), 0, this);
    }

    public void rethrowError() throws Throwable {
        InvokeDynamicSupport.bootstrap("rethrowError", $$robo$$libcore_reflect_AnnotationMember$rethrowError(), 0, this);
    }

    public Object validateValue() throws Throwable {
        return InvokeDynamicSupport.bootstrap("validateValue", $$robo$$libcore_reflect_AnnotationMember$validateValue(), 0, this);
    }

    public Object copyValue() throws Throwable {
        return InvokeDynamicSupport.bootstrap("copyValue", $$robo$$libcore_reflect_AnnotationMember$copyValue(), 0, this);
    }

    static {
        RobolectricInternals.classInitializing(AnnotationMember.class);
    }

    public /* synthetic */ AnnotationMember() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AnnotationMember)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    private static final class DefaultValues
    extends Enum<DefaultValues> {
        public transient /* synthetic */ Object __robo_data__;
        public static /* enum */ DefaultValues NO_VALUE;
        private static /* synthetic */ DefaultValues[] $VALUES;

        private static final DefaultValues[] $$robo$$libcore_reflect_AnnotationMember_DefaultValues$values() {
            return (DefaultValues[])$VALUES.clone();
        }

        private static final DefaultValues $$robo$$libcore_reflect_AnnotationMember_DefaultValues$valueOf(String name) {
            return Enum.valueOf(DefaultValues.class, name);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void $$robo$$libcore_reflect_AnnotationMember_DefaultValues$__constructor__(String string2, int n) {
        }

        static void __staticInitializer__() {
            NO_VALUE = new DefaultValues();
            $VALUES = new DefaultValues[]{NO_VALUE};
        }

        public static DefaultValues[] values() {
            return InvokeDynamicSupport.bootstrapStatic("values", $$robo$$libcore_reflect_AnnotationMember_DefaultValues$values(), 0);
        }

        public static DefaultValues valueOf(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("valueOf", $$robo$$libcore_reflect_AnnotationMember_DefaultValues$valueOf(java.lang.String ), 0, (String)string2);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void __constructor__(String string2, int n) {
            this.$$robo$$libcore_reflect_AnnotationMember_DefaultValues$__constructor__(string2, n);
        }

        private DefaultValues() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$libcore_reflect_AnnotationMember_DefaultValues$__constructor__(java.lang.String int ), 0, this, string2, n);
        }

        static {
            RobolectricInternals.classInitializing(DefaultValues.class);
        }

        public /* synthetic */ DefaultValues() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DefaultValues)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

