/*
 * Decompiled with CFR 0.152.
 */
package libcore.reflect;

import com.google.errorprone.annotations.DoNotMock;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.annotation.IncompleteAnnotationException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Map;
import java.util.WeakHashMap;
import libcore.reflect.AnnotationMember;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
public class AnnotationFactory
implements InvocationHandler,
Serializable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static transient Map<Class<? extends Annotation>, AnnotationMember[]> cache;
    private Class<? extends Annotation> klazz;
    private AnnotationMember[] elements;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final AnnotationMember[] $$robo$$libcore_reflect_AnnotationFactory$getElementsDescription(Class<? extends Annotation> annotationType) {
        AnnotationMember[] desc;
        Map<Class<? extends Annotation>, AnnotationMember[]> map = cache;
        synchronized (map) {
            desc = cache.get(annotationType);
            if (desc != null) {
                return desc;
            }
        }
        if (!annotationType.isAnnotation()) {
            throw new IllegalArgumentException("Type is not annotation: " + annotationType.getName());
        }
        Method[] declaredMethods = annotationType.getDeclaredMethods();
        desc = new AnnotationMember[declaredMethods.length];
        for (int i = 0; i < declaredMethods.length; ++i) {
            Method element = declaredMethods[i];
            String name = element.getName();
            Class<?> type = element.getReturnType();
            try {
                desc[i] = new AnnotationMember(name, element.getDefaultValue(), type, element);
                continue;
            }
            catch (Throwable t) {
                desc[i] = new AnnotationMember(name, t, type, element);
            }
        }
        Map<Class<? extends Annotation>, AnnotationMember[]> map2 = cache;
        synchronized (map2) {
            cache.put(annotationType, desc);
        }
        return desc;
    }

    private static final <A extends Annotation> A $$robo$$libcore_reflect_AnnotationFactory$createAnnotation(Class<? extends Annotation> annotationType, AnnotationMember[] elements) {
        AnnotationFactory factory = new AnnotationFactory(annotationType, elements);
        return (A)((Annotation)Proxy.newProxyInstance(annotationType.getClassLoader(), new Class[]{annotationType}, (InvocationHandler)factory));
    }

    private void $$robo$$libcore_reflect_AnnotationFactory$__constructor__(Class<? extends Annotation> klzz, AnnotationMember[] values) {
        this.klazz = klzz;
        AnnotationMember[] defs = AnnotationFactory.getElementsDescription(this.klazz);
        if (values == null) {
            this.elements = defs;
        } else {
            this.elements = new AnnotationMember[defs.length];
            block0: for (int i = this.elements.length - 1; i >= 0; --i) {
                for (AnnotationMember val : values) {
                    if (!val.name.equals(defs[i].name)) continue;
                    this.elements[i] = val.setDefinition(defs[i]);
                    continue block0;
                }
                this.elements[i] = defs[i];
            }
        }
    }

    private final void $$robo$$libcore_reflect_AnnotationFactory$readObject(ObjectInputStream os) throws IOException, ClassNotFoundException {
        os.defaultReadObject();
        AnnotationMember[] defs = AnnotationFactory.getElementsDescription(this.klazz);
        AnnotationMember[] old = this.elements;
        ArrayList<AnnotationMember> merged = new ArrayList<AnnotationMember>(defs.length + old.length);
        block0: for (AnnotationMember el1 : old) {
            for (AnnotationMember el2 : defs) {
                if (el2.name.equals(el1.name)) continue block0;
            }
            merged.add(el1);
        }
        block2: for (AnnotationMember def : defs) {
            for (AnnotationMember val : old) {
                if (!val.name.equals(def.name)) continue;
                merged.add(val.setDefinition(def));
                continue block2;
            }
            merged.add(def);
        }
        this.elements = merged.toArray(new AnnotationMember[merged.size()]);
    }

    private final boolean $$robo$$libcore_reflect_AnnotationFactory$equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!this.klazz.isInstance(obj)) {
            return false;
        }
        InvocationHandler handler = null;
        if (Proxy.isProxyClass(obj.getClass()) && (handler = Proxy.getInvocationHandler(obj)) instanceof AnnotationFactory) {
            AnnotationFactory other = (AnnotationFactory)handler;
            if (this.elements.length != other.elements.length) {
                return false;
            }
            block2: for (AnnotationMember el1 : this.elements) {
                for (AnnotationMember el2 : other.elements) {
                    if (el1.equals(el2)) continue block2;
                }
                return false;
            }
            return true;
        }
        for (AnnotationMember el : this.elements) {
            if (el.tag == '!') {
                return false;
            }
            try {
                Object otherValue;
                if (!el.definingMethod.isAccessible()) {
                    el.definingMethod.setAccessible(true);
                }
                if (!((otherValue = el.definingMethod.invoke(obj, new Object[0])) != null ? (el.tag == '[' ? !el.equalArrayValue(otherValue) : !el.value.equals(otherValue)) : el.value != AnnotationMember.NO_VALUE)) continue;
                return false;
            }
            catch (Throwable e) {
                return false;
            }
        }
        return true;
    }

    private final int $$robo$$libcore_reflect_AnnotationFactory$hashCode() {
        int hash = 0;
        for (AnnotationMember element : this.elements) {
            hash += element.hashCode();
        }
        return hash;
    }

    private final String $$robo$$libcore_reflect_AnnotationFactory$toString() {
        StringBuilder result = new StringBuilder();
        result.append('@');
        result.append(this.klazz.getName());
        result.append('(');
        for (int i = 0; i < this.elements.length; ++i) {
            if (i != 0) {
                result.append(", ");
            }
            result.append(this.elements[i]);
        }
        result.append(')');
        return result.toString();
    }

    private final Object $$robo$$libcore_reflect_AnnotationFactory$invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String name = method.getName();
        Class<?>[] params = method.getParameterTypes();
        if (params.length == 0) {
            if ("annotationType".equals(name)) {
                return this.klazz;
            }
            if ("toString".equals(name)) {
                return this.toString();
            }
            if ("hashCode".equals(name)) {
                return this.hashCode();
            }
            AnnotationMember element = null;
            for (AnnotationMember el : this.elements) {
                if (!name.equals(el.name)) continue;
                element = el;
                break;
            }
            if (element == null || !method.equals(element.definingMethod)) {
                throw new IllegalArgumentException(method.toString());
            }
            Object value = element.validateValue();
            if (value == null) {
                throw new IncompleteAnnotationException(this.klazz, name);
            }
            return value;
        }
        if (params.length == 1 && params[0] == Object.class && "equals".equals(name)) {
            return this.equals(args[0]);
        }
        throw new IllegalArgumentException("Invalid method for annotation type: " + method);
    }

    static void __staticInitializer__() {
        cache = new WeakHashMap<Class<? extends Annotation>, AnnotationMember[]>();
    }

    public static AnnotationMember[] getElementsDescription(Class<? extends Annotation> clazz) {
        return InvokeDynamicSupport.bootstrapStatic("getElementsDescription", $$robo$$libcore_reflect_AnnotationFactory$getElementsDescription(java.lang.Class<? extends java.lang.annotation.Annotation> ), 0, clazz);
    }

    public static <A extends Annotation> A createAnnotation(Class<? extends Annotation> clazz, AnnotationMember[] annotationMemberArray) {
        return (A)InvokeDynamicSupport.bootstrapStatic("createAnnotation", $$robo$$libcore_reflect_AnnotationFactory$createAnnotation(java.lang.Class<? extends java.lang.annotation.Annotation> libcore.reflect.AnnotationMember[] ), 0, clazz, (AnnotationMember[])annotationMemberArray);
    }

    private void __constructor__(Class<? extends Annotation> clazz, AnnotationMember[] annotationMemberArray) {
        this.$$robo$$libcore_reflect_AnnotationFactory$__constructor__(clazz, annotationMemberArray);
    }

    private AnnotationFactory(Class<? extends Annotation> clazz, AnnotationMember[] annotationMemberArray) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$libcore_reflect_AnnotationFactory$__constructor__(java.lang.Class<? extends java.lang.annotation.Annotation> libcore.reflect.AnnotationMember[] ), 0, this, clazz, annotationMemberArray);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        InvokeDynamicSupport.bootstrap("readObject", $$robo$$libcore_reflect_AnnotationFactory$readObject(java.io.ObjectInputStream ), 0, this, objectInputStream);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$libcore_reflect_AnnotationFactory$equals(java.lang.Object ), 0, this, object);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$libcore_reflect_AnnotationFactory$hashCode(), 0, this);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$libcore_reflect_AnnotationFactory$toString(), 0, this);
    }

    @Override
    public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
        return InvokeDynamicSupport.bootstrap("invoke", $$robo$$libcore_reflect_AnnotationFactory$invoke(java.lang.Object java.lang.reflect.Method java.lang.Object[] ), 0, this, object, method, objectArray);
    }

    static {
        RobolectricInternals.classInitializing(AnnotationFactory.class);
    }

    public /* synthetic */ AnnotationFactory() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AnnotationFactory)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

