/*
 * Decompiled with CFR 0.152.
 */
package libcore.io;

import com.google.errorprone.annotations.DoNotMock;
import java.io.ByteArrayOutputStream;
import java.nio.charset.StandardCharsets;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
public class Base64
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static byte[] BASE_64_ALPHABET;
    private static int FIRST_OUTPUT_BYTE_MASK = 0xFC0000;
    private static int SECOND_OUTPUT_BYTE_MASK = 258048;
    private static int THIRD_OUTPUT_BYTE_MASK = 4032;
    private static int FOURTH_OUTPUT_BYTE_MASK = 63;
    private static byte PAD_AS_BYTE = -1;
    private static byte WHITESPACE_AS_BYTE = -2;
    private static byte END_OF_INPUT = -3;

    private static final byte[] $$robo$$libcore_io_Base64$initializeBase64Alphabet() {
        return "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".getBytes(StandardCharsets.US_ASCII);
    }

    private void $$robo$$libcore_io_Base64$__constructor__() {
    }

    private static final String $$robo$$libcore_io_Base64$encode(byte[] in) {
        int len = in.length;
        int outputLen = Base64.computeEncodingOutputLen(len);
        byte[] output = new byte[outputLen];
        int outputIndex = 0;
        for (int i = 0; i < len; i += 3) {
            int byteTripletAsInt = in[i] & 0xFF;
            if (i + 1 < len) {
                byteTripletAsInt <<= 8;
                byteTripletAsInt |= in[i + 1] & 0xFF;
                if (i + 2 < len) {
                    byteTripletAsInt <<= 8;
                    byteTripletAsInt |= in[i + 2] & 0xFF;
                } else {
                    byteTripletAsInt <<= 2;
                }
            } else {
                byteTripletAsInt <<= 4;
            }
            if (i + 2 < len) {
                output[outputIndex++] = BASE_64_ALPHABET[(byteTripletAsInt & 0xFC0000) >>> 18];
            }
            if (i + 1 < len) {
                output[outputIndex++] = BASE_64_ALPHABET[(byteTripletAsInt & 0x3F000) >>> 12];
            }
            output[outputIndex++] = BASE_64_ALPHABET[(byteTripletAsInt & 0xFC0) >>> 6];
            output[outputIndex++] = BASE_64_ALPHABET[byteTripletAsInt & 0x3F];
        }
        int inLengthMod3 = len % 3;
        if (inLengthMod3 > 0) {
            output[outputIndex++] = 61;
            if (inLengthMod3 == 1) {
                output[outputIndex++] = 61;
            }
        }
        return new String(output, StandardCharsets.US_ASCII);
    }

    private static final int $$robo$$libcore_io_Base64$computeEncodingOutputLen(int inLength) {
        int inLengthMod3 = inLength % 3;
        int outputLen = inLength / 3 * 4;
        if (inLengthMod3 == 2) {
            outputLen += 4;
        } else if (inLengthMod3 == 1) {
            outputLen += 4;
        }
        return outputLen;
    }

    private static final byte[] $$robo$$libcore_io_Base64$decode(byte[] in) {
        return Base64.decode(in, in.length);
    }

    private static final byte[] $$robo$$libcore_io_Base64$decode(byte[] in, int len) {
        int inLength = Math.min(in.length, len);
        ByteArrayOutputStream output = new ByteArrayOutputStream(inLength / 4 * 3 + 3);
        int[] pos = new int[1];
        try {
            while (pos[0] < inLength) {
                int byteTripletAsInt = 0;
                for (int j = 0; j < 4; ++j) {
                    byte c = Base64.getNextByte(in, pos, inLength);
                    if (c == -3 || c == -1) {
                        switch (j) {
                            case 0: 
                            case 1: {
                                return c == -3 ? output.toByteArray() : null;
                            }
                            case 2: {
                                if (c == -3) {
                                    return Base64.checkNoTrailingAndReturn(output, in, pos[0], inLength);
                                }
                                pos[0] = pos[0] + 1;
                                c = Base64.getNextByte(in, pos, inLength);
                                if (c == -3) {
                                    return Base64.checkNoTrailingAndReturn(output, in, pos[0], inLength);
                                }
                                if (c == -1) {
                                    output.write(byteTripletAsInt >>= 4);
                                    return Base64.checkNoTrailingAndReturn(output, in, pos[0], inLength);
                                }
                                return null;
                            }
                            case 3: {
                                if (c == -1) {
                                    output.write((byteTripletAsInt >>= 2) >> 8);
                                    output.write(byteTripletAsInt & 0xFF);
                                }
                                return Base64.checkNoTrailingAndReturn(output, in, pos[0], inLength);
                            }
                        }
                        continue;
                    }
                    byteTripletAsInt <<= 6;
                    byteTripletAsInt += c & 0xFF;
                    pos[0] = pos[0] + 1;
                }
                output.write(byteTripletAsInt >> 16);
                output.write(byteTripletAsInt >> 8 & 0xFF);
                output.write(byteTripletAsInt & 0xFF);
            }
            return Base64.checkNoTrailingAndReturn(output, in, pos[0], inLength);
        }
        catch (InvalidBase64ByteException e) {
            return null;
        }
    }

    private static final byte $$robo$$libcore_io_Base64$getNextByte(byte[] in, int[] pos, int inLength) throws InvalidBase64ByteException {
        while (pos[0] < inLength) {
            byte c = Base64.base64AlphabetToNumericalValue(in[pos[0]]);
            if (c != -2) {
                return c;
            }
            pos[0] = pos[0] + 1;
        }
        return -3;
    }

    private static final byte[] $$robo$$libcore_io_Base64$checkNoTrailingAndReturn(ByteArrayOutputStream output, byte[] in, int i, int inLength) throws InvalidBase64ByteException {
        while (i < inLength) {
            byte c = Base64.base64AlphabetToNumericalValue(in[i]);
            if (c != -2 && c != -1) {
                return null;
            }
            ++i;
        }
        return output.toByteArray();
    }

    private static final byte $$robo$$libcore_io_Base64$base64AlphabetToNumericalValue(byte c) throws InvalidBase64ByteException {
        if (65 <= c && c <= 90) {
            return (byte)(c - 65);
        }
        if (97 <= c && c <= 122) {
            return (byte)(c - 97 + 26);
        }
        if (48 <= c && c <= 57) {
            return (byte)(c - 48 + 52);
        }
        if (c == 43) {
            return 62;
        }
        if (c == 47) {
            return 63;
        }
        if (c == 61) {
            return -1;
        }
        if (c == 32 || c == 9 || c == 13 || c == 10) {
            return -2;
        }
        throw new InvalidBase64ByteException();
    }

    static void __staticInitializer__() {
        BASE_64_ALPHABET = Base64.initializeBase64Alphabet();
    }

    private static byte[] initializeBase64Alphabet() {
        return InvokeDynamicSupport.bootstrapStatic("initializeBase64Alphabet", $$robo$$libcore_io_Base64$initializeBase64Alphabet(), 0);
    }

    private void __constructor__() {
        this.$$robo$$libcore_io_Base64$__constructor__();
    }

    private Base64() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$libcore_io_Base64$__constructor__(), 0, this);
    }

    public static String encode(byte[] byArray) {
        return InvokeDynamicSupport.bootstrapStatic("encode", $$robo$$libcore_io_Base64$encode(byte[] ), 0, (byte[])byArray);
    }

    private static int computeEncodingOutputLen(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("computeEncodingOutputLen", $$robo$$libcore_io_Base64$computeEncodingOutputLen(int ), 0, (int)n);
    }

    public static byte[] decode(byte[] byArray) {
        return InvokeDynamicSupport.bootstrapStatic("decode", $$robo$$libcore_io_Base64$decode(byte[] ), 0, (byte[])byArray);
    }

    public static byte[] decode(byte[] byArray, int n) {
        return InvokeDynamicSupport.bootstrapStatic("decode", $$robo$$libcore_io_Base64$decode(byte[] int ), 0, (byte[])byArray, (int)n);
    }

    private static byte getNextByte(byte[] byArray, int[] nArray, int n) throws InvalidBase64ByteException {
        return (byte)InvokeDynamicSupport.bootstrapStatic("getNextByte", $$robo$$libcore_io_Base64$getNextByte(byte[] int[] int ), 0, (byte[])byArray, (int[])nArray, (int)n);
    }

    private static byte[] checkNoTrailingAndReturn(ByteArrayOutputStream byteArrayOutputStream, byte[] byArray, int n, int n2) throws InvalidBase64ByteException {
        return InvokeDynamicSupport.bootstrapStatic("checkNoTrailingAndReturn", $$robo$$libcore_io_Base64$checkNoTrailingAndReturn(java.io.ByteArrayOutputStream byte[] int int ), 0, (ByteArrayOutputStream)byteArrayOutputStream, (byte[])byArray, (int)n, (int)n2);
    }

    private static byte base64AlphabetToNumericalValue(byte by) throws InvalidBase64ByteException {
        return (byte)InvokeDynamicSupport.bootstrapStatic("base64AlphabetToNumericalValue", $$robo$$libcore_io_Base64$base64AlphabetToNumericalValue(byte ), 0, (byte)by);
    }

    static {
        RobolectricInternals.classInitializing(Base64.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Base64)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class InvalidBase64ByteException
    extends Exception
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$libcore_io_Base64_InvalidBase64ByteException$__constructor__() {
        }

        private /* synthetic */ void $$robo$$libcore_io_Base64_InvalidBase64ByteException$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$libcore_io_Base64_InvalidBase64ByteException$__constructor__();
        }

        private InvalidBase64ByteException() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$libcore_io_Base64_InvalidBase64ByteException$__constructor__(), 0, this);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$libcore_io_Base64_InvalidBase64ByteException$__constructor__(var1_1);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (InvalidBase64ByteException)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

