/*
 * Decompiled with CFR 0.152.
 */
package libcore.icu;

import android.icu.impl.JavaTimeZone;
import android.icu.util.Calendar;
import android.icu.util.GregorianCalendar;
import android.icu.util.TimeZone;
import android.icu.util.ULocale;
import com.google.errorprone.annotations.DoNotMock;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
public class DateUtilsBridge
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static int FORMAT_SHOW_TIME = 1;
    public static int FORMAT_SHOW_WEEKDAY = 2;
    public static int FORMAT_SHOW_YEAR = 4;
    public static int FORMAT_NO_YEAR = 8;
    public static int FORMAT_SHOW_DATE = 16;
    public static int FORMAT_NO_MONTH_DAY = 32;
    public static int FORMAT_12HOUR = 64;
    public static int FORMAT_24HOUR = 128;
    public static int FORMAT_UTC = 8192;
    public static int FORMAT_ABBREV_TIME = 16384;
    public static int FORMAT_ABBREV_WEEKDAY = 32768;
    public static int FORMAT_ABBREV_MONTH = 65536;
    public static int FORMAT_NUMERIC_DATE = 131072;
    public static int FORMAT_ABBREV_RELATIVE = 262144;
    public static int FORMAT_ABBREV_ALL = 524288;

    private void $$robo$$libcore_icu_DateUtilsBridge$__constructor__() {
    }

    private static final TimeZone $$robo$$libcore_icu_DateUtilsBridge$icuTimeZone(java.util.TimeZone tz) {
        JavaTimeZone javaTimeZone = new JavaTimeZone(tz, null);
        javaTimeZone.freeze();
        return javaTimeZone;
    }

    private static final Calendar $$robo$$libcore_icu_DateUtilsBridge$createIcuCalendar(TimeZone icuTimeZone, ULocale icuLocale, long timeInMillis) {
        GregorianCalendar calendar = new GregorianCalendar(icuTimeZone, icuLocale);
        calendar.setTimeInMillis(timeInMillis);
        return calendar;
    }

    private static final String $$robo$$libcore_icu_DateUtilsBridge$toSkeleton(Calendar calendar, int flags) {
        return DateUtilsBridge.toSkeleton(calendar, calendar, flags);
    }

    private static final String $$robo$$libcore_icu_DateUtilsBridge$toSkeleton(Calendar startCalendar, Calendar endCalendar, int flags) {
        if ((flags & 0x80000) != 0) {
            flags |= 0x1C000;
        }
        String monthPart = "MMMM";
        if ((flags & 0x20000) != 0) {
            monthPart = "M";
        } else if ((flags & 0x10000) != 0) {
            monthPart = "MMM";
        }
        String weekPart = "EEEE";
        if ((flags & 0x8000) != 0) {
            weekPart = "EEE";
        }
        String timePart = "j";
        if ((flags & 0x80) != 0) {
            timePart = "H";
        } else if ((flags & 0x40) != 0) {
            timePart = "h";
        }
        if ((flags & 0x4000) == 0 || (flags & 0x80) != 0) {
            timePart = timePart + "m";
        } else if (!DateUtilsBridge.onTheHour(startCalendar) || !DateUtilsBridge.onTheHour(endCalendar)) {
            timePart = timePart + "m";
        }
        if (DateUtilsBridge.fallOnDifferentDates(startCalendar, endCalendar)) {
            flags |= 0x10;
        }
        if (DateUtilsBridge.fallInSameMonth(startCalendar, endCalendar) && (flags & 0x20) != 0) {
            flags &= 0xFFFFFFFD;
            flags &= 0xFFFFFFFE;
        }
        if ((flags & 0x13) == 0) {
            flags |= 0x10;
        }
        if (!((flags & 0x10) == 0 || (flags & 4) != 0 || (flags & 8) != 0 || DateUtilsBridge.fallInSameYear(startCalendar, endCalendar) && DateUtilsBridge.isThisYear(startCalendar))) {
            flags |= 4;
        }
        StringBuilder builder = new StringBuilder();
        if ((flags & 0x30) != 0) {
            if ((flags & 4) != 0) {
                builder.append("y");
            }
            builder.append(monthPart);
            if ((flags & 0x20) == 0) {
                builder.append("d");
            }
        }
        if ((flags & 2) != 0) {
            builder.append(weekPart);
        }
        if ((flags & 1) != 0) {
            builder.append(timePart);
        }
        return builder.toString();
    }

    private static final int $$robo$$libcore_icu_DateUtilsBridge$dayDistance(Calendar c1, Calendar c2) {
        return c2.get(20) - c1.get(20);
    }

    private static final boolean $$robo$$libcore_icu_DateUtilsBridge$onTheHour(Calendar c) {
        return c.get(12) == 0 && c.get(13) == 0;
    }

    private static final boolean $$robo$$libcore_icu_DateUtilsBridge$fallOnDifferentDates(Calendar c1, Calendar c2) {
        return c1.get(1) != c2.get(1) || c1.get(2) != c2.get(2) || c1.get(5) != c2.get(5);
    }

    private static final boolean $$robo$$libcore_icu_DateUtilsBridge$fallInSameMonth(Calendar c1, Calendar c2) {
        return c1.get(2) == c2.get(2);
    }

    private static final boolean $$robo$$libcore_icu_DateUtilsBridge$fallInSameYear(Calendar c1, Calendar c2) {
        return c1.get(1) == c2.get(1);
    }

    private static final boolean $$robo$$libcore_icu_DateUtilsBridge$isThisYear(Calendar c) {
        Calendar now = (Calendar)c.clone();
        now.setTimeInMillis((long)InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System"));
        return c.get(1) == now.get(1);
    }

    private void __constructor__() {
        this.$$robo$$libcore_icu_DateUtilsBridge$__constructor__();
    }

    public DateUtilsBridge() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$libcore_icu_DateUtilsBridge$__constructor__(), 0, this);
    }

    public static TimeZone icuTimeZone(java.util.TimeZone timeZone) {
        return InvokeDynamicSupport.bootstrapStatic("icuTimeZone", $$robo$$libcore_icu_DateUtilsBridge$icuTimeZone(java.util.TimeZone ), 0, (java.util.TimeZone)timeZone);
    }

    public static Calendar createIcuCalendar(TimeZone timeZone, ULocale uLocale, long l) {
        return InvokeDynamicSupport.bootstrapStatic("createIcuCalendar", $$robo$$libcore_icu_DateUtilsBridge$createIcuCalendar(android.icu.util.TimeZone android.icu.util.ULocale long ), 0, (TimeZone)timeZone, (ULocale)uLocale, (long)l);
    }

    public static String toSkeleton(Calendar calendar, int n) {
        return InvokeDynamicSupport.bootstrapStatic("toSkeleton", $$robo$$libcore_icu_DateUtilsBridge$toSkeleton(android.icu.util.Calendar int ), 0, (Calendar)calendar, (int)n);
    }

    public static String toSkeleton(Calendar calendar, Calendar calendar2, int n) {
        return InvokeDynamicSupport.bootstrapStatic("toSkeleton", $$robo$$libcore_icu_DateUtilsBridge$toSkeleton(android.icu.util.Calendar android.icu.util.Calendar int ), 0, (Calendar)calendar, (Calendar)calendar2, (int)n);
    }

    public static int dayDistance(Calendar calendar, Calendar calendar2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("dayDistance", $$robo$$libcore_icu_DateUtilsBridge$dayDistance(android.icu.util.Calendar android.icu.util.Calendar ), 0, (Calendar)calendar, (Calendar)calendar2);
    }

    private static boolean onTheHour(Calendar calendar) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("onTheHour", $$robo$$libcore_icu_DateUtilsBridge$onTheHour(android.icu.util.Calendar ), 0, (Calendar)calendar);
    }

    private static boolean fallOnDifferentDates(Calendar calendar, Calendar calendar2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("fallOnDifferentDates", $$robo$$libcore_icu_DateUtilsBridge$fallOnDifferentDates(android.icu.util.Calendar android.icu.util.Calendar ), 0, (Calendar)calendar, (Calendar)calendar2);
    }

    private static boolean fallInSameMonth(Calendar calendar, Calendar calendar2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("fallInSameMonth", $$robo$$libcore_icu_DateUtilsBridge$fallInSameMonth(android.icu.util.Calendar android.icu.util.Calendar ), 0, (Calendar)calendar, (Calendar)calendar2);
    }

    private static boolean fallInSameYear(Calendar calendar, Calendar calendar2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("fallInSameYear", $$robo$$libcore_icu_DateUtilsBridge$fallInSameYear(android.icu.util.Calendar android.icu.util.Calendar ), 0, (Calendar)calendar, (Calendar)calendar2);
    }

    private static boolean isThisYear(Calendar calendar) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isThisYear", $$robo$$libcore_icu_DateUtilsBridge$isThisYear(android.icu.util.Calendar ), 0, (Calendar)calendar);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DateUtilsBridge)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

