/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent.atomic;

import java.io.Serializable;
import java.util.function.BinaryOperator;
import java.util.function.UnaryOperator;
import sun.misc.Unsafe;

public class AtomicReference<V>
implements Serializable {
    private static final long serialVersionUID = -1848883965231344442L;
    private static final Unsafe U = Unsafe.getUnsafe();
    private static final long VALUE;
    private volatile V value;

    public AtomicReference(V initialValue) {
        this.value = initialValue;
    }

    public AtomicReference() {
    }

    public final V get() {
        return this.value;
    }

    public final void set(V newValue) {
        this.value = newValue;
    }

    public final void lazySet(V newValue) {
        U.putOrderedObject(this, VALUE, newValue);
    }

    public final boolean compareAndSet(V expect, V update) {
        return U.compareAndSwapObject(this, VALUE, expect, update);
    }

    public final boolean weakCompareAndSet(V expect, V update) {
        return U.compareAndSwapObject(this, VALUE, expect, update);
    }

    public final V getAndSet(V newValue) {
        return (V)U.getAndSetObject(this, VALUE, newValue);
    }

    public final V getAndUpdate(UnaryOperator<V> updateFunction) {
        Object next;
        V prev;
        while (!this.compareAndSet(prev = this.get(), next = updateFunction.apply(prev))) {
        }
        return prev;
    }

    public final V updateAndGet(UnaryOperator<V> updateFunction) {
        Object next;
        V prev;
        while (!this.compareAndSet(prev = this.get(), next = updateFunction.apply(prev))) {
        }
        return (V)next;
    }

    public final V getAndAccumulate(V x, BinaryOperator<V> accumulatorFunction) {
        Object next;
        V prev;
        while (!this.compareAndSet(prev = this.get(), next = accumulatorFunction.apply(prev, x))) {
        }
        return prev;
    }

    public final V accumulateAndGet(V x, BinaryOperator<V> accumulatorFunction) {
        Object next;
        V prev;
        while (!this.compareAndSet(prev = this.get(), next = accumulatorFunction.apply(prev, x))) {
        }
        return (V)next;
    }

    public String toString() {
        return String.valueOf(this.get());
    }

    static {
        try {
            VALUE = U.objectFieldOffset(AtomicReference.class.getDeclaredField("value"));
        }
        catch (ReflectiveOperationException e) {
            throw new Error(e);
        }
    }
}

