/*
 * Decompiled with CFR 0.152.
 */
package java.math;

import java.math.BigInteger;
import java.math.BitLevel;
import java.math.Division;

class Conversion {
    static final int[] digitFitInInt = new int[]{-1, -1, 31, 19, 15, 13, 11, 11, 10, 9, 9, 8, 8, 8, 8, 7, 7, 7, 7, 7, 7, 7, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 5};
    static final int[] bigRadices = new int[]{Integer.MIN_VALUE, 1162261467, 0x40000000, 1220703125, 362797056, 1977326743, 0x40000000, 387420489, 1000000000, 214358881, 429981696, 815730721, 1475789056, 170859375, 0x10000000, 410338673, 612220032, 893871739, 1280000000, 1801088541, 113379904, 148035889, 191102976, 244140625, 308915776, 387420489, 481890304, 594823321, 729000000, 887503681, 0x40000000, 1291467969, 1544804416, 1838265625, 60466176};

    private Conversion() {
    }

    static String bigInteger2String(BigInteger val, int radix) {
        int resDigit;
        val.prepareJavaRepresentation();
        int sign = val.sign;
        int numberLength = val.numberLength;
        int[] digits = val.digits;
        if (sign == 0) {
            return "0";
        }
        if (numberLength == 1) {
            int highDigit = digits[numberLength - 1];
            long v = (long)highDigit & 0xFFFFFFFFL;
            if (sign < 0) {
                v = -v;
            }
            return Long.toString(v, radix);
        }
        if (radix == 10 || radix < 2 || radix > 36) {
            return val.toString();
        }
        double bitsForRadixDigit = Math.log(radix) / Math.log(2.0);
        int resLengthInChars = (int)((double)val.abs().bitLength() / bitsForRadixDigit + (double)(sign < 0 ? 1 : 0)) + 1;
        char[] result = new char[resLengthInChars];
        int currentChar = resLengthInChars;
        if (radix != 16) {
            int i;
            int[] temp = new int[numberLength];
            System.arraycopy((int[])digits, (int)0, (int[])temp, (int)0, (int)numberLength);
            int tempLen = numberLength;
            int charsPerInt = digitFitInInt[radix];
            int bigRadix = bigRadices[radix - 2];
            do {
                resDigit = Division.divideArrayByInt(temp, temp, tempLen, bigRadix);
                int previous = currentChar;
                do {
                    result[--currentChar] = Character.forDigit(resDigit % radix, radix);
                } while ((resDigit /= radix) != 0 && currentChar != 0);
                int delta = charsPerInt - previous + currentChar;
                for (i = 0; i < delta && currentChar > 0; ++i) {
                    result[--currentChar] = 48;
                }
                for (i = tempLen - 1; i > 0 && temp[i] == 0; --i) {
                }
            } while ((tempLen = i + 1) != 1 || temp[0] != 0);
        } else {
            for (int i = 0; i < numberLength; ++i) {
                for (int j = 0; j < 8 && currentChar > 0; ++j) {
                    resDigit = digits[i] >> (j << 2) & 0xF;
                    result[--currentChar] = Character.forDigit(resDigit, 16);
                }
            }
        }
        while (result[currentChar] == '0') {
            ++currentChar;
        }
        if (sign == -1) {
            result[--currentChar] = 45;
        }
        return new String(result, currentChar, resLengthInChars - currentChar);
    }

    static String toDecimalScaledString(BigInteger val, int scale) {
        val.prepareJavaRepresentation();
        int sign = val.sign;
        int numberLength = val.numberLength;
        int[] digits = val.digits;
        if (sign == 0) {
            switch (scale) {
                case 0: {
                    return "0";
                }
                case 1: {
                    return "0.0";
                }
                case 2: {
                    return "0.00";
                }
                case 3: {
                    return "0.000";
                }
                case 4: {
                    return "0.0000";
                }
                case 5: {
                    return "0.00000";
                }
                case 6: {
                    return "0.000000";
                }
            }
            StringBuilder result1 = new StringBuilder();
            if (scale < 0) {
                result1.append("0E+");
            } else {
                result1.append("0E");
            }
            result1.append(-scale);
            return result1.toString();
        }
        int resLengthInChars = numberLength * 10 + 1 + 7;
        char[] result = new char[resLengthInChars + 1];
        int currentChar = resLengthInChars;
        if (numberLength == 1) {
            int highDigit = digits[0];
            if (highDigit < 0) {
                long v = (long)highDigit & 0xFFFFFFFFL;
                do {
                    long prev = v;
                    result[--currentChar] = (char)(48 + (int)(prev - (v /= 10L) * 10L));
                } while (v != 0L);
            } else {
                int v = highDigit;
                do {
                    int prev = v;
                    result[--currentChar] = (char)(48 + (prev - (v /= 10) * 10));
                } while (v != 0);
            }
        } else {
            int[] temp = new int[numberLength];
            int tempLen = numberLength;
            System.arraycopy((int[])digits, (int)0, (int[])temp, (int)0, (int)tempLen);
            block11: while (true) {
                long result11 = 0L;
                for (int i1 = tempLen - 1; i1 >= 0; --i1) {
                    long temp1 = (result11 << 32) + ((long)temp[i1] & 0xFFFFFFFFL);
                    long res = Conversion.divideLongByBillion(temp1);
                    temp[i1] = (int)res;
                    result11 = (int)(res >> 32);
                }
                int resDigit = (int)result11;
                int previous = currentChar;
                do {
                    result[--currentChar] = (char)(48 + resDigit % 10);
                } while ((resDigit /= 10) != 0 && currentChar != 0);
                int delta = 9 - previous + currentChar;
                for (int i = 0; i < delta && currentChar > 0; ++i) {
                    result[--currentChar] = 48;
                }
                int j = tempLen - 1;
                while (temp[j] == 0) {
                    if (j == 0) break block11;
                    --j;
                }
                tempLen = j + 1;
            }
            while (result[currentChar] == '0') {
                ++currentChar;
            }
        }
        boolean negNumber = sign < 0;
        int exponent = resLengthInChars - currentChar - scale - 1;
        if (scale == 0) {
            if (negNumber) {
                result[--currentChar] = 45;
            }
            return new String(result, currentChar, resLengthInChars - currentChar);
        }
        if (scale > 0 && exponent >= -6) {
            if (exponent >= 0) {
                int insertPoint = currentChar + exponent;
                for (int j = resLengthInChars - 1; j >= insertPoint; --j) {
                    result[j + 1] = result[j];
                }
                result[++insertPoint] = 46;
                if (negNumber) {
                    result[--currentChar] = 45;
                }
                return new String(result, currentChar, resLengthInChars - currentChar + 1);
            }
            for (int j = 2; j < -exponent + 1; ++j) {
                result[--currentChar] = 48;
            }
            result[--currentChar] = 46;
            result[--currentChar] = 48;
            if (negNumber) {
                result[--currentChar] = 45;
            }
            return new String(result, currentChar, resLengthInChars - currentChar);
        }
        int startPoint = currentChar + 1;
        int endPoint = resLengthInChars;
        StringBuilder result1 = new StringBuilder(16 + endPoint - startPoint);
        if (negNumber) {
            result1.append('-');
        }
        if (endPoint - startPoint >= 1) {
            result1.append(result[currentChar]);
            result1.append('.');
            result1.append(result, currentChar + 1, resLengthInChars - currentChar - 1);
        } else {
            result1.append(result, currentChar, resLengthInChars - currentChar);
        }
        result1.append('E');
        if (exponent > 0) {
            result1.append('+');
        }
        result1.append(Integer.toString(exponent));
        return result1.toString();
    }

    static String toDecimalScaledString(long value, int scale) {
        boolean negNumber;
        boolean bl = negNumber = value < 0L;
        if (negNumber) {
            value = -value;
        }
        if (value == 0L) {
            switch (scale) {
                case 0: {
                    return "0";
                }
                case 1: {
                    return "0.0";
                }
                case 2: {
                    return "0.00";
                }
                case 3: {
                    return "0.000";
                }
                case 4: {
                    return "0.0000";
                }
                case 5: {
                    return "0.00000";
                }
                case 6: {
                    return "0.000000";
                }
            }
            StringBuilder result1 = new StringBuilder();
            if (scale < 0) {
                result1.append("0E+");
            } else {
                result1.append("0E");
            }
            result1.append(scale == Integer.MIN_VALUE ? "2147483648" : Integer.toString(-scale));
            return result1.toString();
        }
        int resLengthInChars = 18;
        char[] result = new char[resLengthInChars + 1];
        int currentChar = resLengthInChars;
        long v = value;
        do {
            long prev = v;
            result[--currentChar] = (char)(48L + (prev - (v /= 10L) * 10L));
        } while (v != 0L);
        long exponent = (long)resLengthInChars - (long)currentChar - (long)scale - 1L;
        if (scale == 0) {
            if (negNumber) {
                result[--currentChar] = 45;
            }
            return new String(result, currentChar, resLengthInChars - currentChar);
        }
        if (scale > 0 && exponent >= -6L) {
            if (exponent >= 0L) {
                int insertPoint = currentChar + (int)exponent;
                for (int j = resLengthInChars - 1; j >= insertPoint; --j) {
                    result[j + 1] = result[j];
                }
                result[++insertPoint] = 46;
                if (negNumber) {
                    result[--currentChar] = 45;
                }
                return new String(result, currentChar, resLengthInChars - currentChar + 1);
            }
            int j = 2;
            while ((long)j < -exponent + 1L) {
                result[--currentChar] = 48;
                ++j;
            }
            result[--currentChar] = 46;
            result[--currentChar] = 48;
            if (negNumber) {
                result[--currentChar] = 45;
            }
            return new String(result, currentChar, resLengthInChars - currentChar);
        }
        int startPoint = currentChar + 1;
        int endPoint = resLengthInChars;
        StringBuilder result1 = new StringBuilder(16 + endPoint - startPoint);
        if (negNumber) {
            result1.append('-');
        }
        if (endPoint - startPoint >= 1) {
            result1.append(result[currentChar]);
            result1.append('.');
            result1.append(result, currentChar + 1, resLengthInChars - currentChar - 1);
        } else {
            result1.append(result, currentChar, resLengthInChars - currentChar);
        }
        result1.append('E');
        if (exponent > 0L) {
            result1.append('+');
        }
        result1.append(Long.toString(exponent));
        return result1.toString();
    }

    static long divideLongByBillion(long a) {
        long rem;
        long quot;
        if (a >= 0L) {
            long bLong = 1000000000L;
            quot = a / bLong;
            rem = a % bLong;
        } else {
            long aPos = a >>> 1;
            long bPos = 500000000L;
            quot = aPos / bPos;
            rem = aPos % bPos;
            rem = (rem << 1) + (a & 1L);
        }
        return rem << 32 | quot & 0xFFFFFFFFL;
    }

    static double bigInteger2Double(BigInteger val) {
        val.prepareJavaRepresentation();
        if (val.numberLength < 2 || val.numberLength == 2 && val.digits[1] > 0) {
            return val.longValue();
        }
        if (val.numberLength > 32) {
            return val.sign > 0 ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY;
        }
        int bitLen = val.abs().bitLength();
        long exponent = bitLen - 1;
        int delta = bitLen - 54;
        long lVal = val.abs().shiftRight(delta).longValue();
        long mantissa = lVal & 0x1FFFFFFFFFFFFFL;
        if (exponent == 1023L) {
            if (mantissa == 0x1FFFFFFFFFFFFFL) {
                return val.sign > 0 ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY;
            }
            if (mantissa == 0x1FFFFFFFFFFFFEL) {
                return val.sign > 0 ? Double.MAX_VALUE : -1.7976931348623157E308;
            }
        }
        if ((mantissa & 1L) == 1L && ((mantissa & 2L) == 2L || BitLevel.nonZeroDroppedBits(delta, val.digits))) {
            mantissa += 2L;
        }
        long resSign = val.sign < 0 ? Long.MIN_VALUE : 0L;
        exponent = 1023L + exponent << 52 & 0x7FF0000000000000L;
        long result = resSign | exponent | (mantissa >>= 1);
        return Double.longBitsToDouble(result);
    }
}

