/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.header;

import gov.nist.javax.sip.header.ParametersHeader;
import java.text.ParseException;
import javax.sip.InvalidArgumentException;
import javax.sip.header.RetryAfterHeader;

public class RetryAfter
extends ParametersHeader
implements RetryAfterHeader {
    private static final long serialVersionUID = -1029458515616146140L;
    public static final String DURATION = "duration";
    protected Integer retryAfter = new Integer(0);
    protected String comment;

    public RetryAfter() {
        super("Retry-After");
    }

    @Override
    public String encodeBody() {
        StringBuffer s = new StringBuffer();
        if (this.retryAfter != null) {
            s.append(this.retryAfter);
        }
        if (this.comment != null) {
            s.append(" (" + this.comment + ")");
        }
        if (!this.parameters.isEmpty()) {
            s.append(";" + this.parameters.encode());
        }
        return s.toString();
    }

    @Override
    public boolean hasComment() {
        return this.comment != null;
    }

    @Override
    public void removeComment() {
        this.comment = null;
    }

    @Override
    public void removeDuration() {
        super.removeParameter(DURATION);
    }

    @Override
    public void setRetryAfter(int retryAfter) throws InvalidArgumentException {
        if (retryAfter < 0) {
            throw new InvalidArgumentException("invalid parameter " + retryAfter);
        }
        this.retryAfter = retryAfter;
    }

    @Override
    public int getRetryAfter() {
        return this.retryAfter;
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    @Override
    public void setComment(String comment) throws ParseException {
        if (comment == null) {
            throw new NullPointerException("the comment parameter is null");
        }
        this.comment = comment;
    }

    @Override
    public void setDuration(int duration) throws InvalidArgumentException {
        if (duration < 0) {
            throw new InvalidArgumentException("the duration parameter is <0");
        }
        this.setParameter(DURATION, duration);
    }

    @Override
    public int getDuration() {
        if (this.getParameter(DURATION) == null) {
            return -1;
        }
        return super.getParameterAsInt(DURATION);
    }
}

