/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.util;

import android.content.Context;
import android.text.SpannableStringBuilder;
import android.text.style.ImageSpan;
import com.google.android.util.AbstractMessageParser;
import com.google.android.util.SmileyResources;
import java.util.ArrayList;

public class SmileyParser
extends AbstractMessageParser {
    private SmileyResources mRes;

    public SmileyParser(String text, SmileyResources res) {
        super(text, true, false, false, false, false, false);
        this.mRes = res;
    }

    @Override
    protected AbstractMessageParser.Resources getResources() {
        return this.mRes;
    }

    public CharSequence getSpannableString(Context context) {
        SpannableStringBuilder builder = new SpannableStringBuilder();
        if (this.getPartCount() == 0) {
            return "";
        }
        AbstractMessageParser.Part part = this.getPart(0);
        ArrayList<AbstractMessageParser.Token> tokens = part.getTokens();
        int len = tokens.size();
        for (int i = 0; i < len; ++i) {
            int resid;
            AbstractMessageParser.Token token = tokens.get(i);
            int start = builder.length();
            builder.append(token.getRawText());
            if (token.getType() != AbstractMessageParser.Token.Type.SMILEY || (resid = this.mRes.getSmileyRes(token.getRawText())) == -1) continue;
            builder.setSpan(new ImageSpan(context, resid), start, builder.length(), 33);
        }
        return builder;
    }
}

