/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.graphics.Rect;
import android.graphics.Region;
import android.view.GestureDetector;
import android.view.InputDevice;
import android.view.InputEvent;
import android.view.MotionEvent;
import android.view.WindowManagerPolicy;
import com.android.server.wm.DisplayContent;
import com.android.server.wm.Task;
import com.android.server.wm.WindowManagerService;

public class TaskTapPointerEventListener
implements WindowManagerPolicy.PointerEventListener {
    private final Region mTouchExcludeRegion = new Region();
    private final WindowManagerService mService;
    private final DisplayContent mDisplayContent;
    private final Rect mTmpRect = new Rect();
    private final Region mNonResizeableRegion = new Region();
    private boolean mTwoFingerScrolling;
    private boolean mInGestureDetection;
    private GestureDetector mGestureDetector;
    private int mPointerIconType = 1;

    public TaskTapPointerEventListener(WindowManagerService service, DisplayContent displayContent) {
        this.mService = service;
        this.mDisplayContent = displayContent;
    }

    void init() {
        this.mGestureDetector = new GestureDetector(this.mService.mContext, new TwoFingerScrollListener(), this.mService.mH);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onPointerEvent(MotionEvent motionEvent) {
        this.doGestureDetection(motionEvent);
        int action = motionEvent.getAction();
        switch (action & 0xFF) {
            case 0: {
                int x = (int)motionEvent.getX();
                int y = (int)motionEvent.getY();
                TaskTapPointerEventListener taskTapPointerEventListener = this;
                synchronized (taskTapPointerEventListener) {
                    if (!this.mTouchExcludeRegion.contains(x, y)) {
                        this.mService.mH.obtainMessage(31, x, y, this.mDisplayContent).sendToTarget();
                    }
                    break;
                }
            }
            case 2: {
                if (motionEvent.getPointerCount() == 2) break;
                this.stopTwoFingerScroll();
                break;
            }
            case 7: {
                int x = (int)motionEvent.getX();
                int y = (int)motionEvent.getY();
                Task task = this.mDisplayContent.findTaskForControlPoint(x, y);
                InputDevice inputDevice = motionEvent.getDevice();
                if (task == null || inputDevice == null) {
                    this.mPointerIconType = 1;
                    break;
                }
                task.getDimBounds(this.mTmpRect);
                if (!this.mTmpRect.isEmpty() && !this.mTmpRect.contains(x, y)) {
                    int iconType = 1000;
                    if (x < this.mTmpRect.left) {
                        iconType = y < this.mTmpRect.top ? 1017 : (y > this.mTmpRect.bottom ? 1016 : 1014);
                    } else if (x > this.mTmpRect.right) {
                        iconType = y < this.mTmpRect.top ? 1016 : (y > this.mTmpRect.bottom ? 1017 : 1014);
                    } else if (y < this.mTmpRect.top || y > this.mTmpRect.bottom) {
                        iconType = 1015;
                    }
                    if (this.mPointerIconType == iconType) break;
                    this.mPointerIconType = iconType;
                    inputDevice.setPointerType(iconType);
                    break;
                }
                this.mPointerIconType = 1;
                break;
            }
            case 10: {
                this.mPointerIconType = 1;
                InputDevice inputDevice = motionEvent.getDevice();
                if (inputDevice == null) break;
                inputDevice.setPointerType(1000);
                break;
            }
            case 1: 
            case 6: {
                this.stopTwoFingerScroll();
            }
        }
    }

    private void doGestureDetection(MotionEvent motionEvent) {
        if (this.mGestureDetector == null || this.mNonResizeableRegion.isEmpty()) {
            return;
        }
        int action = motionEvent.getAction() & 0xFF;
        int x = (int)motionEvent.getX();
        int y = (int)motionEvent.getY();
        boolean isTouchInside = this.mNonResizeableRegion.contains(x, y);
        if (this.mInGestureDetection || action == 0 && isTouchInside) {
            boolean bl = this.mInGestureDetection = isTouchInside && action != 1 && action != 6 && action != 3;
            if (this.mInGestureDetection) {
                this.mGestureDetector.onTouchEvent(motionEvent);
            } else {
                InputEvent cancelEvent = motionEvent.copy();
                ((MotionEvent)cancelEvent).cancel();
                this.mGestureDetector.onTouchEvent((MotionEvent)cancelEvent);
                this.stopTwoFingerScroll();
            }
        }
    }

    private void onTwoFingerScroll(MotionEvent e) {
        int x = (int)e.getX(0);
        int y = (int)e.getY(0);
        if (!this.mTwoFingerScrolling) {
            this.mTwoFingerScrolling = true;
            this.mService.mH.obtainMessage(44, x, y, this.mDisplayContent).sendToTarget();
        }
    }

    private void stopTwoFingerScroll() {
        if (this.mTwoFingerScrolling) {
            this.mTwoFingerScrolling = false;
            this.mService.mH.obtainMessage(40).sendToTarget();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setTouchExcludeRegion(Region newRegion, Region nonResizeableRegion) {
        TaskTapPointerEventListener taskTapPointerEventListener = this;
        synchronized (taskTapPointerEventListener) {
            this.mTouchExcludeRegion.set(newRegion);
            this.mNonResizeableRegion.set(nonResizeableRegion);
        }
    }

    private final class TwoFingerScrollListener
    extends GestureDetector.SimpleOnGestureListener {
        private TwoFingerScrollListener() {
        }

        @Override
        public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
            if (e2.getPointerCount() == 2) {
                TaskTapPointerEventListener.this.onTwoFingerScroll(e2);
                return true;
            }
            TaskTapPointerEventListener.this.stopTwoFingerScroll();
            return false;
        }
    }
}

