/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.app.ActivityManager;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.graphics.Rect;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.EventLog;
import android.util.Slog;
import android.util.SparseArray;
import android.view.DisplayInfo;
import android.view.SurfaceControl;
import com.android.internal.policy.DividerSnapAlgorithm;
import com.android.internal.policy.DockedDividerUtils;
import com.android.server.wm.AppTokenList;
import com.android.server.wm.AppWindowToken;
import com.android.server.wm.BoundsAnimationController;
import com.android.server.wm.DimLayer;
import com.android.server.wm.DisplayContent;
import com.android.server.wm.Task;
import com.android.server.wm.WindowList;
import com.android.server.wm.WindowManagerService;
import com.android.server.wm.WindowState;
import com.android.server.wm.WindowStateAnimator;
import com.android.server.wm.WindowToken;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;

public class TaskStack
implements DimLayer.DimLayerUser,
BoundsAnimationController.AnimateBoundsUser {
    private static final float ADJUSTED_STACK_FRACTION_MIN = 0.3f;
    private static final float IME_ADJUST_DIM_AMOUNT = 0.25f;
    final int mStackId;
    private final WindowManagerService mService;
    private DisplayContent mDisplayContent;
    private final ArrayList<Task> mTasks = new ArrayList();
    private Rect mTmpRect = new Rect();
    private Rect mTmpRect2 = new Rect();
    private Rect mBounds = new Rect();
    private final Rect mAdjustedBounds = new Rect();
    private final Rect mFullyAdjustedImeBounds = new Rect();
    private boolean mFullscreen = true;
    int mRotation;
    int mDensity;
    DimLayer mAnimationBackgroundSurface;
    WindowStateAnimator mAnimationBackgroundAnimator;
    final AppTokenList mExitingAppTokens = new AppTokenList();
    boolean mDeferDetach;
    private boolean mDragResizing;
    private final Rect mTmpAdjustedBounds = new Rect();
    private boolean mAdjustedForIme;
    private boolean mImeGoingAway;
    private WindowState mImeWin;
    private float mMinimizeAmount;
    private float mAdjustImeAmount;
    private float mAdjustDividerAmount;
    private final int mDockedStackMinimizeThickness;
    private boolean mBoundsAnimating = false;
    private final Rect mBoundsAfterRotation = new Rect();

    TaskStack(WindowManagerService service, int stackId) {
        this.mService = service;
        this.mStackId = stackId;
        this.mDockedStackMinimizeThickness = service.mContext.getResources().getDimensionPixelSize(17104931);
        EventLog.writeEvent(31004, stackId);
    }

    DisplayContent getDisplayContent() {
        return this.mDisplayContent;
    }

    ArrayList<Task> getTasks() {
        return this.mTasks;
    }

    Task findHomeTask() {
        if (this.mStackId != 0) {
            return null;
        }
        for (int i = this.mTasks.size() - 1; i >= 0; --i) {
            if (!this.mTasks.get(i).isHomeTask()) continue;
            return this.mTasks.get(i);
        }
        return null;
    }

    boolean setBounds(Rect stackBounds, SparseArray<Configuration> configs, SparseArray<Rect> taskBounds, SparseArray<Rect> taskTempInsetBounds) {
        this.setBounds(stackBounds);
        for (int taskNdx = this.mTasks.size() - 1; taskNdx >= 0; --taskNdx) {
            Task task = this.mTasks.get(taskNdx);
            Configuration config = configs.get(task.mTaskId);
            if (config != null) {
                Rect bounds = taskBounds.get(task.mTaskId);
                if (task.isTwoFingerScrollMode()) {
                    task.resizeLocked(bounds, config, false);
                    task.getBounds(this.mTmpRect);
                    task.scrollLocked(this.mTmpRect);
                    continue;
                }
                task.resizeLocked(bounds, config, false);
                task.setTempInsetBounds(taskTempInsetBounds != null ? taskTempInsetBounds.get(task.mTaskId) : null);
                continue;
            }
            Slog.wtf("WindowManager", "No config for task: " + task + ", is there a mismatch with AM?");
        }
        return true;
    }

    void prepareFreezingTaskBounds() {
        for (int taskNdx = this.mTasks.size() - 1; taskNdx >= 0; --taskNdx) {
            Task task = this.mTasks.get(taskNdx);
            task.prepareFreezingBounds();
        }
    }

    boolean isFullscreenBounds(Rect bounds) {
        if (this.mDisplayContent == null || bounds == null) {
            return true;
        }
        this.mDisplayContent.getLogicalDisplayRect(this.mTmpRect);
        return this.mTmpRect.equals(bounds);
    }

    private void setAdjustedBounds(Rect bounds) {
        if (this.mAdjustedBounds.equals(bounds) && !this.isAnimatingForIme()) {
            return;
        }
        this.mAdjustedBounds.set(bounds);
        boolean adjusted = !this.mAdjustedBounds.isEmpty();
        Rect insetBounds = null;
        if (adjusted && this.isAdjustedForMinimizedDock()) {
            insetBounds = this.mBounds;
        } else if (adjusted && this.mAdjustedForIme) {
            insetBounds = this.mImeGoingAway ? this.mBounds : this.mFullyAdjustedImeBounds;
        }
        this.alignTasksToAdjustedBounds(adjusted ? this.mAdjustedBounds : this.mBounds, insetBounds);
        this.mDisplayContent.layoutNeeded = true;
    }

    private void alignTasksToAdjustedBounds(Rect adjustedBounds, Rect tempInsetBounds) {
        if (this.mFullscreen) {
            return;
        }
        for (int taskNdx = this.mTasks.size() - 1; taskNdx >= 0; --taskNdx) {
            Task task = this.mTasks.get(taskNdx);
            if (task.isTwoFingerScrollMode()) {
                task.resizeLocked(null, null, false);
                task.getBounds(this.mTmpRect2);
                task.scrollLocked(this.mTmpRect2);
                continue;
            }
            boolean alignBottom = this.mAdjustedForIme && this.getDockSide() == 2;
            task.alignToAdjustedBounds(adjustedBounds, tempInsetBounds, alignBottom);
        }
    }

    private boolean setBounds(Rect bounds) {
        boolean oldFullscreen = this.mFullscreen;
        int rotation = 0;
        int density = 0;
        if (this.mDisplayContent != null) {
            this.mDisplayContent.getLogicalDisplayRect(this.mTmpRect);
            rotation = this.mDisplayContent.getDisplayInfo().rotation;
            density = this.mDisplayContent.getDisplayInfo().logicalDensityDpi;
            boolean bl = this.mFullscreen = bounds == null;
            if (this.mFullscreen) {
                bounds = this.mTmpRect;
            }
        }
        if (bounds == null) {
            return false;
        }
        if (this.mBounds.equals(bounds) && oldFullscreen == this.mFullscreen && this.mRotation == rotation) {
            return false;
        }
        if (this.mDisplayContent != null) {
            this.mDisplayContent.mDimLayerController.updateDimLayer(this);
            this.mAnimationBackgroundSurface.setBounds(bounds);
        }
        this.mBounds.set(bounds);
        this.mRotation = rotation;
        this.mDensity = density;
        this.updateAdjustedBounds();
        return true;
    }

    void getRawBounds(Rect out) {
        out.set(this.mBounds);
    }

    private boolean useCurrentBounds() {
        return this.mFullscreen || !ActivityManager.StackId.isResizeableByDockedStack(this.mStackId) || this.mDisplayContent == null || this.mDisplayContent.getDockedStackLocked() != null;
    }

    public void getBounds(Rect out) {
        if (this.useCurrentBounds()) {
            if (!this.mAdjustedBounds.isEmpty()) {
                out.set(this.mAdjustedBounds);
            } else {
                out.set(this.mBounds);
            }
            return;
        }
        this.mDisplayContent.getLogicalDisplayRect(out);
    }

    @Override
    public void getDimBounds(Rect out) {
        this.getBounds(out);
    }

    void updateDisplayInfo(Rect bounds) {
        if (this.mDisplayContent == null) {
            return;
        }
        for (int taskNdx = this.mTasks.size() - 1; taskNdx >= 0; --taskNdx) {
            this.mTasks.get(taskNdx).updateDisplayInfo(this.mDisplayContent);
        }
        if (bounds != null) {
            this.setBounds(bounds);
            return;
        }
        if (this.mFullscreen) {
            this.setBounds(null);
            return;
        }
        this.mTmpRect2.set(this.mBounds);
        int newRotation = this.mDisplayContent.getDisplayInfo().rotation;
        int newDensity = this.mDisplayContent.getDisplayInfo().logicalDensityDpi;
        if (this.mRotation == newRotation && this.mDensity == newDensity) {
            this.setBounds(this.mTmpRect2);
        }
    }

    boolean onConfigurationChanged() {
        return this.updateBoundsAfterConfigChange();
    }

    private boolean updateBoundsAfterConfigChange() {
        if (this.mDisplayContent == null) {
            return false;
        }
        int newRotation = this.getDisplayInfo().rotation;
        int newDensity = this.getDisplayInfo().logicalDensityDpi;
        if (this.mRotation == newRotation && this.mDensity == newDensity) {
            return false;
        }
        if (this.mFullscreen) {
            this.setBounds(null);
            return false;
        }
        int oldDockSide = this.mStackId == 3 ? this.getDockSide() : -1;
        this.mTmpRect2.set(this.mBounds);
        this.mDisplayContent.rotateBounds(this.mRotation, newRotation, this.mTmpRect2);
        if (this.mStackId == 3) {
            this.repositionDockedStackAfterRotation(this.mTmpRect2);
            this.snapDockedStackAfterRotation(this.mTmpRect2);
            int newDockSide = this.getDockSide(this.mTmpRect2);
            if (oldDockSide != newDockSide) {
                this.mService.setDockedStackCreateStateLocked(newDockSide == 1 || newDockSide == 2 ? 0 : 1, null);
                this.mDisplayContent.getDockedDividerController().notifyDockSideChanged(newDockSide);
            }
        }
        this.mBoundsAfterRotation.set(this.mTmpRect2);
        return true;
    }

    void getBoundsForNewConfiguration(Rect outBounds) {
        outBounds.set(this.mBoundsAfterRotation);
        this.mBoundsAfterRotation.setEmpty();
    }

    private void repositionDockedStackAfterRotation(Rect inOutBounds) {
        int dockSide = this.getDockSide(inOutBounds);
        if (this.mService.mPolicy.isDockSideAllowed(dockSide)) {
            return;
        }
        this.mDisplayContent.getLogicalDisplayRect(this.mTmpRect);
        dockSide = DockedDividerUtils.invertDockSide(dockSide);
        switch (dockSide) {
            case 1: {
                int movement = inOutBounds.left;
                inOutBounds.left -= movement;
                inOutBounds.right -= movement;
                break;
            }
            case 3: {
                int movement = this.mTmpRect.right - inOutBounds.right;
                inOutBounds.left += movement;
                inOutBounds.right += movement;
                break;
            }
            case 2: {
                int movement = inOutBounds.top;
                inOutBounds.top -= movement;
                inOutBounds.bottom -= movement;
                break;
            }
            case 4: {
                int movement = this.mTmpRect.bottom - inOutBounds.bottom;
                inOutBounds.top += movement;
                inOutBounds.bottom += movement;
            }
        }
    }

    private void snapDockedStackAfterRotation(Rect outBounds) {
        DisplayInfo displayInfo = this.mDisplayContent.getDisplayInfo();
        int dividerSize = this.mService.getDefaultDisplayContentLocked().getDockedDividerController().getContentWidth();
        int dockSide = this.getDockSide(outBounds);
        int dividerPosition = DockedDividerUtils.calculatePositionForBounds(outBounds, dockSide, dividerSize);
        int displayWidth = this.mDisplayContent.getDisplayInfo().logicalWidth;
        int displayHeight = this.mDisplayContent.getDisplayInfo().logicalHeight;
        int rotation = displayInfo.rotation;
        int orientation = this.mService.mCurConfiguration.orientation;
        this.mService.mPolicy.getStableInsetsLw(rotation, displayWidth, displayHeight, outBounds);
        DividerSnapAlgorithm algorithm = new DividerSnapAlgorithm(this.mService.mContext.getResources(), displayWidth, displayHeight, dividerSize, orientation == 1, outBounds);
        DividerSnapAlgorithm.SnapTarget target = algorithm.calculateNonDismissingSnapTarget(dividerPosition);
        DockedDividerUtils.calculateBoundsForPosition(target.position, dockSide, outBounds, displayInfo.logicalWidth, displayInfo.logicalHeight, dividerSize);
    }

    boolean isAnimating() {
        for (int taskNdx = this.mTasks.size() - 1; taskNdx >= 0; --taskNdx) {
            AppTokenList activities = this.mTasks.get((int)taskNdx).mAppTokens;
            for (int activityNdx = activities.size() - 1; activityNdx >= 0; --activityNdx) {
                WindowList windows = ((AppWindowToken)activities.get((int)activityNdx)).allAppWindows;
                for (int winNdx = windows.size() - 1; winNdx >= 0; --winNdx) {
                    WindowStateAnimator winAnimator = ((WindowState)windows.get((int)winNdx)).mWinAnimator;
                    if (!winAnimator.isAnimationSet() && !winAnimator.mWin.mAnimatingExit) continue;
                    return true;
                }
            }
        }
        return false;
    }

    void addTask(Task task, boolean toTop) {
        this.addTask(task, toTop, task.showForAllUsers());
    }

    void addTask(Task task, boolean toTop, boolean showForAllUsers) {
        this.positionTask(task, toTop ? this.mTasks.size() : 0, showForAllUsers);
    }

    void positionTask(Task task, int position, boolean showForAllUsers) {
        boolean toTop;
        boolean canShowTask = showForAllUsers || this.mService.isCurrentProfileLocked(task.mUserId);
        this.mTasks.remove(task);
        int stackSize = this.mTasks.size();
        int minPosition = 0;
        int maxPosition = stackSize;
        if (canShowTask) {
            minPosition = this.computeMinPosition(minPosition, stackSize);
        } else {
            maxPosition = this.computeMaxPosition(maxPosition);
        }
        position = Math.min(Math.max(position, minPosition), maxPosition);
        this.mTasks.add(position, task);
        if (task.mStack != this) {
            task.resetScrollLocked();
        }
        task.mStack = this;
        task.updateDisplayInfo(this.mDisplayContent);
        boolean bl = toTop = position == this.mTasks.size() - 1;
        if (toTop) {
            this.mDisplayContent.moveStack(this, true);
        }
        if (ActivityManager.StackId.windowsAreScaleable(this.mStackId)) {
            this.forceWindowsScaleable(task, true);
        } else {
            this.forceWindowsScaleable(task, false);
        }
        EventLog.writeEvent(31002, task.mTaskId, toTop ? 1 : 0, position);
    }

    private int computeMinPosition(int minPosition, int size) {
        while (minPosition < size) {
            boolean canShowTmpTask;
            Task tmpTask = this.mTasks.get(minPosition);
            boolean bl = canShowTmpTask = tmpTask.showForAllUsers() || this.mService.isCurrentProfileLocked(tmpTask.mUserId);
            if (canShowTmpTask) break;
            ++minPosition;
        }
        return minPosition;
    }

    private int computeMaxPosition(int maxPosition) {
        while (maxPosition > 0) {
            boolean canShowTmpTask;
            Task tmpTask = this.mTasks.get(maxPosition - 1);
            boolean bl = canShowTmpTask = tmpTask.showForAllUsers() || this.mService.isCurrentProfileLocked(tmpTask.mUserId);
            if (!canShowTmpTask) break;
            --maxPosition;
        }
        return maxPosition;
    }

    void moveTaskToTop(Task task) {
        this.mTasks.remove(task);
        this.addTask(task, true);
    }

    void moveTaskToBottom(Task task) {
        this.mTasks.remove(task);
        this.addTask(task, false);
    }

    void removeTask(Task task) {
        this.mTasks.remove(task);
        if (this.mDisplayContent != null) {
            if (this.mTasks.isEmpty()) {
                this.mDisplayContent.moveStack(this, false);
            }
            this.mDisplayContent.layoutNeeded = true;
        }
        for (int appNdx = this.mExitingAppTokens.size() - 1; appNdx >= 0; --appNdx) {
            AppWindowToken wtoken = (AppWindowToken)this.mExitingAppTokens.get(appNdx);
            if (wtoken.mTask != task) continue;
            wtoken.mIsExiting = false;
            this.mExitingAppTokens.remove(appNdx);
        }
    }

    void attachDisplayContent(DisplayContent displayContent) {
        if (this.mDisplayContent != null) {
            throw new IllegalStateException("attachDisplayContent: Already attached");
        }
        this.mDisplayContent = displayContent;
        this.mAnimationBackgroundSurface = new DimLayer(this.mService, this, this.mDisplayContent.getDisplayId(), "animation background stackId=" + this.mStackId);
        Rect bounds = null;
        TaskStack dockedStack = this.mService.mStackIdToStack.get(3);
        if (this.mStackId == 3 || dockedStack != null && ActivityManager.StackId.isResizeableByDockedStack(this.mStackId) && !dockedStack.isFullscreen()) {
            bounds = new Rect();
            displayContent.getLogicalDisplayRect(this.mTmpRect);
            this.mTmpRect2.setEmpty();
            if (dockedStack != null) {
                dockedStack.getRawBounds(this.mTmpRect2);
            }
            boolean dockedOnTopOrLeft = this.mService.mDockedStackCreateMode == 0;
            this.getStackDockedModeBounds(this.mTmpRect, bounds, this.mStackId, this.mTmpRect2, this.mDisplayContent.mDividerControllerLocked.getContentWidth(), dockedOnTopOrLeft);
        }
        this.updateDisplayInfo(bounds);
    }

    void getStackDockedModeBoundsLocked(Rect outBounds, boolean ignoreVisibility) {
        if (this.mStackId != 3 && !ActivityManager.StackId.isResizeableByDockedStack(this.mStackId) || this.mDisplayContent == null) {
            outBounds.set(this.mBounds);
            return;
        }
        TaskStack dockedStack = this.mService.mStackIdToStack.get(3);
        if (dockedStack == null) {
            throw new IllegalStateException("Calling getStackDockedModeBoundsLocked() when there is no docked stack.");
        }
        if (!ignoreVisibility && !dockedStack.isVisibleLocked()) {
            this.mDisplayContent.getLogicalDisplayRect(outBounds);
            return;
        }
        int dockedSide = dockedStack.getDockSide();
        if (dockedSide == -1) {
            Slog.e("WindowManager", "Failed to get valid docked side for docked stack=" + dockedStack);
            outBounds.set(this.mBounds);
            return;
        }
        this.mDisplayContent.getLogicalDisplayRect(this.mTmpRect);
        dockedStack.getRawBounds(this.mTmpRect2);
        boolean dockedOnTopOrLeft = dockedSide == 2 || dockedSide == 1;
        this.getStackDockedModeBounds(this.mTmpRect, outBounds, this.mStackId, this.mTmpRect2, this.mDisplayContent.mDividerControllerLocked.getContentWidth(), dockedOnTopOrLeft);
    }

    private void getStackDockedModeBounds(Rect displayRect, Rect outBounds, int stackId, Rect dockedBounds, int dockDividerWidth, boolean dockOnTopOrLeft) {
        boolean dockedStack = stackId == 3;
        boolean splitHorizontally = displayRect.width() > displayRect.height();
        outBounds.set(displayRect);
        if (dockedStack) {
            if (this.mService.mDockedStackCreateBounds != null) {
                outBounds.set(this.mService.mDockedStackCreateBounds);
                return;
            }
            DisplayInfo di = this.mDisplayContent.getDisplayInfo();
            this.mService.mPolicy.getStableInsetsLw(di.rotation, di.logicalWidth, di.logicalHeight, this.mTmpRect2);
            int position = new DividerSnapAlgorithm((Resources)this.mService.mContext.getResources(), (int)di.logicalWidth, (int)di.logicalHeight, (int)dockDividerWidth, (boolean)(this.mService.mCurConfiguration.orientation == 1 ? true : false), (Rect)this.mTmpRect2).getMiddleTarget().position;
            if (dockOnTopOrLeft) {
                if (splitHorizontally) {
                    outBounds.right = position;
                } else {
                    outBounds.bottom = position;
                }
            } else if (splitHorizontally) {
                outBounds.left = position + dockDividerWidth;
            } else {
                outBounds.top = position + dockDividerWidth;
            }
            return;
        }
        if (!dockOnTopOrLeft) {
            if (splitHorizontally) {
                outBounds.right = dockedBounds.left - dockDividerWidth;
            } else {
                outBounds.bottom = dockedBounds.top - dockDividerWidth;
            }
        } else if (splitHorizontally) {
            outBounds.left = dockedBounds.right + dockDividerWidth;
        } else {
            outBounds.top = dockedBounds.bottom + dockDividerWidth;
        }
        DockedDividerUtils.sanitizeStackBounds(outBounds, !dockOnTopOrLeft);
    }

    void resetDockedStackToMiddle() {
        if (this.mStackId != 3) {
            throw new IllegalStateException("Not a docked stack=" + this);
        }
        this.mService.mDockedStackCreateBounds = null;
        Rect bounds = new Rect();
        this.getStackDockedModeBoundsLocked(bounds, true);
        this.mService.mH.obtainMessage(42, 3, 1, bounds).sendToTarget();
    }

    void detachDisplay() {
        EventLog.writeEvent(31006, this.mStackId);
        boolean doAnotherLayoutPass = false;
        for (int taskNdx = this.mTasks.size() - 1; taskNdx >= 0; --taskNdx) {
            AppTokenList appWindowTokens = this.mTasks.get((int)taskNdx).mAppTokens;
            for (int appNdx = appWindowTokens.size() - 1; appNdx >= 0; --appNdx) {
                WindowList appWindows = ((AppWindowToken)appWindowTokens.get((int)appNdx)).allAppWindows;
                for (int winNdx = appWindows.size() - 1; winNdx >= 0; --winNdx) {
                    this.mService.removeWindowLocked((WindowState)appWindows.get(winNdx));
                    doAnotherLayoutPass = true;
                }
            }
        }
        if (doAnotherLayoutPass) {
            this.mService.mWindowPlacerLocked.requestTraversal();
        }
        this.close();
    }

    void resetAnimationBackgroundAnimator() {
        this.mAnimationBackgroundAnimator = null;
        this.mAnimationBackgroundSurface.hide();
    }

    void setAnimationBackground(WindowStateAnimator winAnimator, int color2) {
        int animLayer = winAnimator.mAnimLayer;
        if (this.mAnimationBackgroundAnimator == null || animLayer < this.mAnimationBackgroundAnimator.mAnimLayer) {
            this.mAnimationBackgroundAnimator = winAnimator;
            animLayer = this.mService.adjustAnimationBackground(winAnimator);
            this.mAnimationBackgroundSurface.show(animLayer - 1, (float)(color2 >> 24 & 0xFF) / 255.0f, 0L);
        }
    }

    void switchUser() {
        int top = this.mTasks.size();
        for (int taskNdx = 0; taskNdx < top; ++taskNdx) {
            Task task = this.mTasks.get(taskNdx);
            if (!this.mService.isCurrentProfileLocked(task.mUserId) && !task.showForAllUsers()) continue;
            this.mTasks.remove(taskNdx);
            this.mTasks.add(task);
            --top;
        }
    }

    void close() {
        if (this.mAnimationBackgroundSurface != null) {
            this.mAnimationBackgroundSurface.destroySurface();
            this.mAnimationBackgroundSurface = null;
        }
        this.mDisplayContent = null;
    }

    void setAdjustedForIme(WindowState imeWin, boolean forceUpdate) {
        this.mImeWin = imeWin;
        this.mImeGoingAway = false;
        if (!this.mAdjustedForIme || forceUpdate) {
            this.mAdjustedForIme = true;
            this.mAdjustImeAmount = 0.0f;
            this.mAdjustDividerAmount = 0.0f;
            this.updateAdjustForIme(0.0f, 0.0f, true);
        }
    }

    boolean isAdjustedForIme() {
        return this.mAdjustedForIme;
    }

    boolean isAnimatingForIme() {
        return this.mImeWin != null && this.mImeWin.isAnimatingLw();
    }

    boolean updateAdjustForIme(float adjustAmount, float adjustDividerAmount, boolean force) {
        if (adjustAmount != this.mAdjustImeAmount || adjustDividerAmount != this.mAdjustDividerAmount || force) {
            this.mAdjustImeAmount = adjustAmount;
            this.mAdjustDividerAmount = adjustDividerAmount;
            this.updateAdjustedBounds();
            return this.isVisibleForUserLocked();
        }
        return false;
    }

    void resetAdjustedForIme(boolean adjustBoundsNow) {
        if (adjustBoundsNow) {
            this.mImeWin = null;
            this.mAdjustedForIme = false;
            this.mImeGoingAway = false;
            this.mAdjustImeAmount = 0.0f;
            this.mAdjustDividerAmount = 0.0f;
            this.updateAdjustedBounds();
            this.mService.setResizeDimLayer(false, this.mStackId, 1.0f);
        } else {
            this.mImeGoingAway |= this.mAdjustedForIme;
        }
    }

    boolean setAdjustedForMinimizedDock(float minimizeAmount) {
        if (minimizeAmount != this.mMinimizeAmount) {
            this.mMinimizeAmount = minimizeAmount;
            this.updateAdjustedBounds();
            return this.isVisibleForUserLocked();
        }
        return false;
    }

    boolean isAdjustedForMinimizedDock() {
        return this.mMinimizeAmount != 0.0f;
    }

    void beginImeAdjustAnimation() {
        for (int j = this.mTasks.size() - 1; j >= 0; --j) {
            Task task = this.mTasks.get(j);
            if (!task.isVisibleForUser()) continue;
            task.setDragResizing(true, 1);
            task.addWindowsWaitingForDrawnIfResizingChanged();
        }
    }

    void endImeAdjustAnimation() {
        for (int j = this.mTasks.size() - 1; j >= 0; --j) {
            this.mTasks.get(j).setDragResizing(false, 1);
        }
    }

    int getMinTopStackBottom(Rect displayContentRect, int originalStackBottom) {
        return displayContentRect.top + (int)((float)(originalStackBottom - displayContentRect.top) * 0.3f);
    }

    private boolean adjustForIME(WindowState imeWin) {
        boolean dockedTopOrBottom;
        int dockedSide = this.getDockSide();
        boolean bl = dockedTopOrBottom = dockedSide == 2 || dockedSide == 4;
        if (imeWin == null || !dockedTopOrBottom) {
            return false;
        }
        Rect displayContentRect = this.mTmpRect;
        Rect contentBounds = this.mTmpRect2;
        this.getDisplayContent().getContentRect(displayContentRect);
        contentBounds.set(displayContentRect);
        int imeTop = Math.max(imeWin.getFrameLw().top, contentBounds.top);
        if (contentBounds.bottom > (imeTop += imeWin.getGivenContentInsetsLw().top)) {
            contentBounds.bottom = imeTop;
        }
        int yOffset = displayContentRect.bottom - contentBounds.bottom;
        int dividerWidth = this.getDisplayContent().mDividerControllerLocked.getContentWidth();
        int dividerWidthInactive = this.getDisplayContent().mDividerControllerLocked.getContentWidthInactive();
        if (dockedSide == 2) {
            int minTopStackBottom = this.getMinTopStackBottom(displayContentRect, this.mBounds.bottom);
            int bottom = Math.max(this.mBounds.bottom - yOffset + dividerWidth - dividerWidthInactive, minTopStackBottom);
            this.mTmpAdjustedBounds.set(this.mBounds);
            this.mTmpAdjustedBounds.bottom = (int)(this.mAdjustImeAmount * (float)bottom + (1.0f - this.mAdjustImeAmount) * (float)this.mBounds.bottom);
            this.mFullyAdjustedImeBounds.set(this.mBounds);
        } else {
            int dividerWidthDelta = dividerWidthInactive - dividerWidth;
            int topBeforeImeAdjust = this.mBounds.top - dividerWidth + dividerWidthInactive;
            int minTopStackBottom = this.getMinTopStackBottom(displayContentRect, this.mBounds.top - dividerWidth);
            int top = Math.max(this.mBounds.top - yOffset, minTopStackBottom + dividerWidthInactive);
            this.mTmpAdjustedBounds.set(this.mBounds);
            this.mTmpAdjustedBounds.top = this.mBounds.top + (int)(this.mAdjustImeAmount * (float)(top - topBeforeImeAdjust) + this.mAdjustDividerAmount * (float)dividerWidthDelta);
            this.mFullyAdjustedImeBounds.set(this.mBounds);
            this.mFullyAdjustedImeBounds.top = top;
            this.mFullyAdjustedImeBounds.bottom = top + this.mBounds.height();
        }
        return true;
    }

    private boolean adjustForMinimizedDockedStack(float minimizeAmount) {
        int dockSide = this.getDockSide();
        if (dockSide == -1 && !this.mTmpAdjustedBounds.isEmpty()) {
            return false;
        }
        if (dockSide == 2) {
            this.mService.getStableInsetsLocked(this.mTmpRect);
            int topInset = this.mTmpRect.top;
            this.mTmpAdjustedBounds.set(this.mBounds);
            this.mTmpAdjustedBounds.bottom = (int)(minimizeAmount * (float)topInset + (1.0f - minimizeAmount) * (float)this.mBounds.bottom);
        } else if (dockSide == 1) {
            this.mTmpAdjustedBounds.set(this.mBounds);
            int width = this.mBounds.width();
            this.mTmpAdjustedBounds.right = (int)(minimizeAmount * (float)this.mDockedStackMinimizeThickness + (1.0f - minimizeAmount) * (float)this.mBounds.right);
            this.mTmpAdjustedBounds.left = this.mTmpAdjustedBounds.right - width;
        } else if (dockSide == 3) {
            this.mTmpAdjustedBounds.set(this.mBounds);
            this.mTmpAdjustedBounds.left = (int)(minimizeAmount * (float)(this.mBounds.right - this.mDockedStackMinimizeThickness) + (1.0f - minimizeAmount) * (float)this.mBounds.left);
        }
        return true;
    }

    int getMinimizeDistance() {
        int dockSide = this.getDockSide();
        if (dockSide == -1) {
            return 0;
        }
        if (dockSide == 2) {
            this.mService.getStableInsetsLocked(this.mTmpRect);
            int topInset = this.mTmpRect.top;
            return this.mBounds.bottom - topInset;
        }
        if (dockSide == 1 || dockSide == 3) {
            return this.mBounds.width() - this.mDockedStackMinimizeThickness;
        }
        return 0;
    }

    private void updateAdjustedBounds() {
        boolean isImeTarget;
        boolean adjust = false;
        if (this.mMinimizeAmount != 0.0f) {
            adjust = this.adjustForMinimizedDockedStack(this.mMinimizeAmount);
        } else if (this.mAdjustedForIme) {
            adjust = this.adjustForIME(this.mImeWin);
        }
        if (!adjust) {
            this.mTmpAdjustedBounds.setEmpty();
        }
        this.setAdjustedBounds(this.mTmpAdjustedBounds);
        boolean bl = isImeTarget = this.mService.getImeFocusStackLocked() == this;
        if (this.mAdjustedForIme && adjust && !isImeTarget) {
            float alpha = Math.max(this.mAdjustImeAmount, this.mAdjustDividerAmount) * 0.25f;
            this.mService.setResizeDimLayer(true, this.mStackId, alpha);
        }
    }

    void applyAdjustForImeIfNeeded(Task task) {
        if (this.mMinimizeAmount != 0.0f || !this.mAdjustedForIme || this.mAdjustedBounds.isEmpty()) {
            return;
        }
        Rect insetBounds = this.mImeGoingAway ? this.mBounds : this.mFullyAdjustedImeBounds;
        task.alignToAdjustedBounds(this.mAdjustedBounds, insetBounds, this.getDockSide() == 2);
        this.mDisplayContent.layoutNeeded = true;
    }

    boolean isAdjustedForMinimizedDockedStack() {
        return this.mMinimizeAmount != 0.0f;
    }

    public void dump(String prefix, PrintWriter pw) {
        pw.println(prefix + "mStackId=" + this.mStackId);
        pw.println(prefix + "mDeferDetach=" + this.mDeferDetach);
        pw.println(prefix + "mFullscreen=" + this.mFullscreen);
        pw.println(prefix + "mBounds=" + this.mBounds.toShortString());
        if (this.mMinimizeAmount != 0.0f) {
            pw.println(prefix + "mMinimizeAmout=" + this.mMinimizeAmount);
        }
        if (this.mAdjustedForIme) {
            pw.println(prefix + "mAdjustedForIme=true");
            pw.println(prefix + "mAdjustImeAmount=" + this.mAdjustImeAmount);
            pw.println(prefix + "mAdjustDividerAmount=" + this.mAdjustDividerAmount);
        }
        if (!this.mAdjustedBounds.isEmpty()) {
            pw.println(prefix + "mAdjustedBounds=" + this.mAdjustedBounds.toShortString());
        }
        for (int taskNdx = this.mTasks.size() - 1; taskNdx >= 0; --taskNdx) {
            this.mTasks.get(taskNdx).dump(prefix + "  ", pw);
        }
        if (this.mAnimationBackgroundSurface.isDimming()) {
            pw.println(prefix + "mWindowAnimationBackgroundSurface:");
            this.mAnimationBackgroundSurface.printTo(prefix + "  ", pw);
        }
        if (!this.mExitingAppTokens.isEmpty()) {
            pw.println();
            pw.println("  Exiting application tokens:");
            for (int i = this.mExitingAppTokens.size() - 1; i >= 0; --i) {
                WindowToken token = (WindowToken)this.mExitingAppTokens.get(i);
                pw.print("  Exiting App #");
                pw.print(i);
                pw.print(' ');
                pw.print(token);
                pw.println(':');
                token.dump(pw, "    ");
            }
        }
    }

    boolean getRawFullscreen() {
        return this.mFullscreen;
    }

    @Override
    public boolean dimFullscreen() {
        return this.mStackId == 0 || this.isFullscreen();
    }

    boolean isFullscreen() {
        if (this.useCurrentBounds()) {
            return this.mFullscreen;
        }
        return true;
    }

    @Override
    public DisplayInfo getDisplayInfo() {
        return this.mDisplayContent.getDisplayInfo();
    }

    public String toString() {
        return "{stackId=" + this.mStackId + " tasks=" + this.mTasks + "}";
    }

    @Override
    public String toShortString() {
        return "Stack=" + this.mStackId;
    }

    int getDockSide() {
        return this.getDockSide(this.mBounds);
    }

    int getDockSide(Rect bounds) {
        if (this.mStackId != 3 && !ActivityManager.StackId.isResizeableByDockedStack(this.mStackId)) {
            return -1;
        }
        if (this.mDisplayContent == null) {
            return -1;
        }
        this.mDisplayContent.getLogicalDisplayRect(this.mTmpRect);
        int orientation = this.mService.mCurConfiguration.orientation;
        return TaskStack.getDockSideUnchecked(bounds, this.mTmpRect, orientation);
    }

    static int getDockSideUnchecked(Rect bounds, Rect displayRect, int orientation) {
        if (orientation == 1) {
            if (bounds.top - displayRect.top <= displayRect.bottom - bounds.bottom) {
                return 2;
            }
            return 4;
        }
        if (orientation == 2) {
            if (bounds.left - displayRect.left <= displayRect.right - bounds.right) {
                return 1;
            }
            return 3;
        }
        return -1;
    }

    boolean isVisibleLocked() {
        boolean keyguardOn;
        boolean bl = keyguardOn = this.mService.mPolicy.isKeyguardShowingOrOccluded() && !this.mService.mAnimator.mKeyguardGoingAway;
        if (keyguardOn && !ActivityManager.StackId.isAllowedOverLockscreen(this.mStackId)) {
            return false;
        }
        for (int i = this.mTasks.size() - 1; i >= 0; --i) {
            Task task = this.mTasks.get(i);
            for (int j = task.mAppTokens.size() - 1; j >= 0; --j) {
                if (((AppWindowToken)task.mAppTokens.get((int)j)).hidden) continue;
                return true;
            }
        }
        return false;
    }

    boolean isVisibleForUserLocked() {
        for (int i = this.mTasks.size() - 1; i >= 0; --i) {
            Task task = this.mTasks.get(i);
            if (!task.isVisibleForUser()) continue;
            return true;
        }
        return false;
    }

    boolean isDragResizing() {
        return this.mDragResizing;
    }

    void setDragResizingLocked(boolean resizing) {
        if (this.mDragResizing == resizing) {
            return;
        }
        this.mDragResizing = resizing;
        for (int i = this.mTasks.size() - 1; i >= 0; --i) {
            this.mTasks.get(i).resetDragResizingChangeReported();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setSize(Rect bounds) {
        HashMap<IBinder, WindowState> hashMap = this.mService.mWindowMap;
        synchronized (hashMap) {
            if (this.mDisplayContent == null) {
                return false;
            }
        }
        try {
            this.mService.mActivityManager.resizeStack(this.mStackId, bounds, false, true, false, -1);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setPinnedStackSize(Rect bounds, Rect tempTaskBounds) {
        HashMap<IBinder, WindowState> hashMap = this.mService.mWindowMap;
        synchronized (hashMap) {
            if (this.mDisplayContent == null) {
                return false;
            }
            if (this.mStackId != 4) {
                Slog.w("WindowManager", "Attempt to use pinned stack resize animation helper onnon pinned stack");
                return false;
            }
        }
        try {
            this.mService.mActivityManager.resizePinnedStack(bounds, tempTaskBounds);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void forceWindowsScaleable(Task task, boolean force) {
        SurfaceControl.openTransaction();
        try {
            AppTokenList activities = task.mAppTokens;
            for (int activityNdx = activities.size() - 1; activityNdx >= 0; --activityNdx) {
                WindowList windows = ((AppWindowToken)activities.get((int)activityNdx)).allAppWindows;
                for (int winNdx = windows.size() - 1; winNdx >= 0; --winNdx) {
                    WindowStateAnimator winAnimator = ((WindowState)windows.get((int)winNdx)).mWinAnimator;
                    if (winAnimator == null || !winAnimator.hasSurface()) continue;
                    winAnimator.mSurfaceController.forceScaleableInTransaction(force);
                }
            }
        }
        finally {
            SurfaceControl.closeTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onAnimationStart() {
        HashMap<IBinder, WindowState> hashMap = this.mService.mWindowMap;
        synchronized (hashMap) {
            this.mBoundsAnimating = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onAnimationEnd() {
        HashMap<IBinder, WindowState> hashMap = this.mService.mWindowMap;
        synchronized (hashMap) {
            this.mBoundsAnimating = false;
            this.mService.requestTraversal();
        }
        if (this.mStackId == 4) {
            try {
                this.mService.mActivityManager.notifyPinnedStackAnimationEnded();
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    @Override
    public void moveToFullscreen() {
        try {
            this.mService.mActivityManager.moveTasksToFullscreenStack(this.mStackId, true);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void getFullScreenBounds(Rect bounds) {
        this.getDisplayContent().getContentRect(bounds);
    }

    public boolean hasMovementAnimations() {
        return ActivityManager.StackId.hasMovementAnimations(this.mStackId);
    }

    public boolean getForceScaleToCrop() {
        return this.mBoundsAnimating;
    }

    public boolean getBoundsAnimating() {
        return this.mBoundsAnimating;
    }
}

