/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.usb;

public final class UsbAudioDevice {
    private static final String TAG = "UsbAudioDevice";
    protected static final boolean DEBUG = false;
    public int mCard;
    public int mDevice;
    public boolean mHasPlayback;
    public boolean mHasCapture;
    public static final int kAudioDeviceClassMask = 0xFFFFFF;
    public static final int kAudioDeviceClass_Undefined = 0;
    public static final int kAudioDeviceClass_Internal = 1;
    public static final int kAudioDeviceClass_External = 2;
    public static final int kAudioDeviceMetaMask = -16777216;
    public static final int kAudioDeviceMeta_Alsa = Integer.MIN_VALUE;
    public int mDeviceClass;
    public String mDeviceName = "";
    public String mDeviceDescription = "";

    public UsbAudioDevice(int card, int device, boolean hasPlayback, boolean hasCapture, int deviceClass) {
        this.mCard = card;
        this.mDevice = device;
        this.mHasPlayback = hasPlayback;
        this.mHasCapture = hasCapture;
        this.mDeviceClass = deviceClass;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("UsbAudioDevice: [card: " + this.mCard);
        sb.append(", device: " + this.mDevice);
        sb.append(", name: " + this.mDeviceName);
        sb.append(", hasPlayback: " + this.mHasPlayback);
        sb.append(", hasCapture: " + this.mHasCapture);
        sb.append(", class: 0x" + Integer.toHexString(this.mDeviceClass) + "]");
        return sb.toString();
    }

    public String toShortString() {
        return "[card:" + this.mCard + " device:" + this.mDevice + " " + this.mDeviceName + "]";
    }
}

