/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.trust;

import android.content.ComponentName;
import android.os.SystemClock;
import android.util.TimeUtils;
import java.io.PrintWriter;
import java.util.ArrayDeque;
import java.util.Iterator;

public class TrustArchive {
    private static final int TYPE_GRANT_TRUST = 0;
    private static final int TYPE_REVOKE_TRUST = 1;
    private static final int TYPE_TRUST_TIMEOUT = 2;
    private static final int TYPE_AGENT_DIED = 3;
    private static final int TYPE_AGENT_CONNECTED = 4;
    private static final int TYPE_AGENT_STOPPED = 5;
    private static final int TYPE_MANAGING_TRUST = 6;
    private static final int HISTORY_LIMIT = 200;
    ArrayDeque<Event> mEvents = new ArrayDeque();

    public void logGrantTrust(int userId, ComponentName agent, String message, long duration, int flags) {
        this.addEvent(new Event(0, userId, agent, message, duration, flags, false));
    }

    public void logRevokeTrust(int userId, ComponentName agent) {
        this.addEvent(new Event(1, userId, agent, null, 0L, 0, false));
    }

    public void logTrustTimeout(int userId, ComponentName agent) {
        this.addEvent(new Event(2, userId, agent, null, 0L, 0, false));
    }

    public void logAgentDied(int userId, ComponentName agent) {
        this.addEvent(new Event(3, userId, agent, null, 0L, 0, false));
    }

    public void logAgentConnected(int userId, ComponentName agent) {
        this.addEvent(new Event(4, userId, agent, null, 0L, 0, false));
    }

    public void logAgentStopped(int userId, ComponentName agent) {
        this.addEvent(new Event(5, userId, agent, null, 0L, 0, false));
    }

    public void logManagingTrust(int userId, ComponentName agent, boolean managing) {
        this.addEvent(new Event(6, userId, agent, null, 0L, 0, managing));
    }

    private void addEvent(Event e) {
        if (this.mEvents.size() >= 200) {
            this.mEvents.removeFirst();
        }
        this.mEvents.addLast(e);
    }

    public void dump(PrintWriter writer, int limit, int userId, String linePrefix, boolean duplicateSimpleNames) {
        int count = 0;
        Iterator<Event> iter = this.mEvents.descendingIterator();
        while (iter.hasNext() && count < limit) {
            Event ev = iter.next();
            if (userId != -1 && userId != ev.userId) continue;
            writer.print(linePrefix);
            writer.printf("#%-2d %s %s: ", count, TrustArchive.formatElapsed(ev.elapsedTimestamp), this.dumpType(ev.type));
            if (userId == -1) {
                writer.print("user=");
                writer.print(ev.userId);
                writer.print(", ");
            }
            writer.print("agent=");
            if (duplicateSimpleNames) {
                writer.print(ev.agent.flattenToShortString());
            } else {
                writer.print(TrustArchive.getSimpleName(ev.agent));
            }
            switch (ev.type) {
                case 0: {
                    writer.printf(", message=\"%s\", duration=%s, flags=%s", ev.message, TrustArchive.formatDuration(ev.duration), this.dumpGrantFlags(ev.flags));
                    break;
                }
                case 6: {
                    writer.printf(", managingTrust=" + ev.managingTrust, new Object[0]);
                    break;
                }
            }
            writer.println();
            ++count;
        }
    }

    public static String formatDuration(long duration) {
        StringBuilder sb = new StringBuilder();
        TimeUtils.formatDuration(duration, sb);
        return sb.toString();
    }

    private static String formatElapsed(long elapsed) {
        long delta = elapsed - SystemClock.elapsedRealtime();
        long wallTime = delta + System.currentTimeMillis();
        return TimeUtils.logTimeOfDay(wallTime);
    }

    static String getSimpleName(ComponentName cn) {
        String name = cn.getClassName();
        int idx = name.lastIndexOf(46);
        if (idx < name.length() && idx >= 0) {
            return name.substring(idx + 1);
        }
        return name;
    }

    private String dumpType(int type) {
        switch (type) {
            case 0: {
                return "GrantTrust";
            }
            case 1: {
                return "RevokeTrust";
            }
            case 2: {
                return "TrustTimeout";
            }
            case 3: {
                return "AgentDied";
            }
            case 4: {
                return "AgentConnected";
            }
            case 5: {
                return "AgentStopped";
            }
            case 6: {
                return "ManagingTrust";
            }
        }
        return "Unknown(" + type + ")";
    }

    private String dumpGrantFlags(int flags) {
        StringBuilder sb = new StringBuilder();
        if ((flags & 1) != 0) {
            if (sb.length() != 0) {
                sb.append('|');
            }
            sb.append("INITIATED_BY_USER");
        }
        if ((flags & 2) != 0) {
            if (sb.length() != 0) {
                sb.append('|');
            }
            sb.append("DISMISS_KEYGUARD");
        }
        if (sb.length() == 0) {
            sb.append('0');
        }
        return sb.toString();
    }

    private static class Event {
        final int type;
        final int userId;
        final ComponentName agent;
        final long elapsedTimestamp;
        final String message;
        final long duration;
        final int flags;
        final boolean managingTrust;

        private Event(int type, int userId, ComponentName agent, String message, long duration, int flags, boolean managingTrust) {
            this.type = type;
            this.userId = userId;
            this.agent = agent;
            this.elapsedTimestamp = SystemClock.elapsedRealtime();
            this.message = message;
            this.duration = duration;
            this.flags = flags;
            this.managingTrust = managingTrust;
        }
    }
}

