/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.pm;

import android.app.ActivityManager;
import android.app.ActivityManagerNative;
import android.app.AppGlobals;
import android.app.IUidObserver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.IPackageManager;
import android.content.pm.IShortcutService;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManagerInternal;
import android.content.pm.ParceledListSlice;
import android.content.pm.ResolveInfo;
import android.content.pm.ShortcutInfo;
import android.content.pm.ShortcutServiceInternal;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.RectF;
import android.graphics.drawable.Icon;
import android.os.Binder;
import android.os.Environment;
import android.os.FileUtils;
import android.os.Handler;
import android.os.Looper;
import android.os.ParcelFileDescriptor;
import android.os.PersistableBundle;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.os.SELinux;
import android.os.ShellCommand;
import android.os.SystemClock;
import android.os.UserHandle;
import android.os.UserManager;
import android.provider.Settings;
import android.text.TextUtils;
import android.text.format.Time;
import android.util.ArraySet;
import android.util.AtomicFile;
import android.util.KeyValueListParser;
import android.util.Slog;
import android.util.SparseArray;
import android.util.SparseIntArray;
import android.util.SparseLongArray;
import android.util.TypedValue;
import android.util.Xml;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.content.PackageMonitor;
import com.android.internal.os.BackgroundThread;
import com.android.internal.util.FastXmlSerializer;
import com.android.internal.util.Preconditions;
import com.android.server.LocalServices;
import com.android.server.SystemService;
import com.android.server.pm.ShortcutLauncher;
import com.android.server.pm.ShortcutPackage;
import com.android.server.pm.ShortcutUser;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.Predicate;
import libcore.io.IoUtils;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public class ShortcutService
extends IShortcutService.Stub {
    static final String TAG = "ShortcutService";
    public static final boolean FEATURE_ENABLED = false;
    static final boolean DEBUG = false;
    static final boolean DEBUG_LOAD = false;
    static final boolean DEBUG_PROCSTATE = false;
    static final long DEFAULT_RESET_INTERVAL_SEC = 86400L;
    static final int DEFAULT_MAX_UPDATES_PER_INTERVAL = 10;
    static final int DEFAULT_MAX_SHORTCUTS_PER_APP = 5;
    static final int DEFAULT_MAX_ICON_DIMENSION_DP = 96;
    static final int DEFAULT_MAX_ICON_DIMENSION_LOWRAM_DP = 48;
    static final String DEFAULT_ICON_PERSIST_FORMAT = Bitmap.CompressFormat.PNG.name();
    static final int DEFAULT_ICON_PERSIST_QUALITY = 100;
    static final int DEFAULT_SAVE_DELAY_MS = 3000;
    static final String FILENAME_BASE_STATE = "shortcut_service.xml";
    static final String DIRECTORY_PER_USER = "shortcut_service";
    static final String FILENAME_USER_PACKAGES = "shortcuts.xml";
    static final String DIRECTORY_BITMAPS = "bitmaps";
    private static final String TAG_ROOT = "root";
    private static final String TAG_LAST_RESET_TIME = "last_reset_time";
    private static final String TAG_LOCALE_CHANGE_SEQUENCE_NUMBER = "locale_seq_no";
    private static final String ATTR_VALUE = "value";
    final Context mContext;
    private final Object mLock = new Object();
    private final Handler mHandler;
    @GuardedBy(value="mLock")
    private final ArrayList<ShortcutServiceInternal.ShortcutChangeListener> mListeners = new ArrayList(1);
    @GuardedBy(value="mLock")
    private long mRawLastResetTime;
    @GuardedBy(value="mLock")
    private final SparseArray<ShortcutUser> mUsers = new SparseArray();
    private int mMaxDynamicShortcuts;
    int mMaxUpdatesPerInterval;
    private long mResetInterval;
    private int mMaxIconDimension;
    private Bitmap.CompressFormat mIconPersistFormat;
    private int mIconPersistQuality;
    private int mSaveDelayMillis;
    private final IPackageManager mIPackageManager;
    private final PackageManagerInternal mPackageManagerInternal;
    private final UserManager mUserManager;
    @GuardedBy(value="mLock")
    final SparseIntArray mUidState = new SparseIntArray();
    @GuardedBy(value="mLock")
    final SparseLongArray mUidLastForegroundElapsedTime = new SparseLongArray();
    @GuardedBy(value="mLock")
    private List<Integer> mDirtyUserIds = new ArrayList<Integer>();
    private final AtomicLong mLocaleChangeSequenceNumber = new AtomicLong();
    private static final int PACKAGE_MATCH_FLAGS = 794624;
    final Object mStatLock = new Object();
    @GuardedBy(value="mStatLock")
    private final int[] mCountStats = new int[5];
    @GuardedBy(value="mStatLock")
    private final long[] mDurationStats = new long[5];
    private static final int PROCESS_STATE_FOREGROUND_THRESHOLD = 4;
    private final IUidObserver mUidObserver = new IUidObserver.Stub(){

        @Override
        public void onUidStateChanged(int uid, int procState) throws RemoteException {
            ShortcutService.this.handleOnUidStateChanged(uid, procState);
        }

        @Override
        public void onUidGone(int uid) throws RemoteException {
            ShortcutService.this.handleOnUidStateChanged(uid, 16);
        }

        @Override
        public void onUidActive(int uid) throws RemoteException {
        }

        @Override
        public void onUidIdle(int uid) throws RemoteException {
        }
    };
    private final Runnable mSaveDirtyInfoRunner = this::saveDirtyInfo;
    final PackageMonitor mPackageMonitor = new PackageMonitor(){

        @Override
        public void onPackageAdded(String packageName, int uid) {
            ShortcutService.this.handlePackageAdded(packageName, this.getChangingUserId());
        }

        @Override
        public void onPackageUpdateFinished(String packageName, int uid) {
            ShortcutService.this.handlePackageUpdateFinished(packageName, this.getChangingUserId());
        }

        @Override
        public void onPackageRemoved(String packageName, int uid) {
            ShortcutService.this.handlePackageRemoved(packageName, this.getChangingUserId());
        }

        @Override
        public void onPackageDataCleared(String packageName, int uid) {
            ShortcutService.this.handlePackageDataCleared(packageName, this.getChangingUserId());
        }
    };

    public ShortcutService(Context context) {
        this(context, BackgroundThread.get().getLooper());
    }

    ShortcutService(Context context, Looper looper) {
        this.mContext = Preconditions.checkNotNull(context);
        LocalServices.addService(ShortcutServiceInternal.class, new LocalService());
        this.mHandler = new Handler(looper);
        this.mIPackageManager = AppGlobals.getPackageManager();
        this.mPackageManagerInternal = LocalServices.getService(PackageManagerInternal.class);
        this.mUserManager = context.getSystemService(UserManager.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void logDurationStat(int statId, long start) {
        Object object = this.mStatLock;
        synchronized (object) {
            int n = statId;
            this.mCountStats[n] = this.mCountStats[n] + 1;
            int n2 = statId;
            this.mDurationStats[n2] = this.mDurationStats[n2] + (System.currentTimeMillis() - start);
        }
    }

    public long getLocaleChangeSequenceNumber() {
        return this.mLocaleChangeSequenceNumber.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleOnUidStateChanged(int uid, int procState) {
        Object object = this.mLock;
        synchronized (object) {
            this.mUidState.put(uid, procState);
            if (this.isProcessStateForeground(procState)) {
                this.mUidLastForegroundElapsedTime.put(uid, this.injectElapsedRealtime());
            }
        }
    }

    private boolean isProcessStateForeground(int processState) {
        return processState <= 4;
    }

    boolean isUidForegroundLocked(int uid) {
        if (uid == 1000) {
            return true;
        }
        return this.isProcessStateForeground(this.mUidState.get(uid, 16));
    }

    long getUidLastForegroundElapsedTimeLocked(int uid) {
        return this.mUidLastForegroundElapsedTime.get(uid);
    }

    void onBootPhase(int phase) {
        switch (phase) {
            case 480: {
                this.initialize();
            }
        }
    }

    void handleUnlockUser(int userId) {
    }

    void handleCleanupUser(int userId) {
    }

    private void unloadUserLocked(int userId) {
        this.saveDirtyInfo();
        this.mUsers.delete(userId);
    }

    private AtomicFile getBaseStateFile() {
        File path = new File(this.injectSystemDataPath(), FILENAME_BASE_STATE);
        path.mkdirs();
        return new AtomicFile(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize() {
        Object object = this.mLock;
        synchronized (object) {
            this.loadConfigurationLocked();
            this.loadBaseStateLocked();
        }
    }

    private void loadConfigurationLocked() {
        this.updateConfigurationLocked(this.injectShortcutManagerConstants());
    }

    boolean updateConfigurationLocked(String config) {
        boolean result = true;
        KeyValueListParser parser = new KeyValueListParser(',');
        try {
            parser.setString(config);
        }
        catch (IllegalArgumentException e) {
            Slog.e(TAG, "Bad shortcut manager settings", e);
            result = false;
        }
        this.mSaveDelayMillis = Math.max(0, (int)parser.getLong("save_delay_ms", 3000L));
        this.mResetInterval = Math.max(1L, parser.getLong("reset_interval_sec", 86400L) * 1000L);
        this.mMaxUpdatesPerInterval = Math.max(0, (int)parser.getLong("max_updates_per_interval", 10L));
        this.mMaxDynamicShortcuts = Math.max(0, (int)parser.getLong("max_shortcuts", 5L));
        int iconDimensionDp = Math.max(1, this.injectIsLowRamDevice() ? (int)parser.getLong("max_icon_dimension_dp_lowram", 48L) : (int)parser.getLong("max_icon_dimension_dp", 96L));
        this.mMaxIconDimension = this.injectDipToPixel(iconDimensionDp);
        this.mIconPersistFormat = Bitmap.CompressFormat.valueOf(parser.getString("icon_format", DEFAULT_ICON_PERSIST_FORMAT));
        this.mIconPersistQuality = (int)parser.getLong("icon_quality", 100L);
        return result;
    }

    String injectShortcutManagerConstants() {
        return Settings.Global.getString(this.mContext.getContentResolver(), "shortcut_manager_constants");
    }

    int injectDipToPixel(int dip) {
        return (int)TypedValue.applyDimension(1, dip, this.mContext.getResources().getDisplayMetrics());
    }

    static String parseStringAttribute(XmlPullParser parser, String attribute) {
        return parser.getAttributeValue(null, attribute);
    }

    static boolean parseBooleanAttribute(XmlPullParser parser, String attribute) {
        return ShortcutService.parseLongAttribute(parser, attribute) == 1L;
    }

    static int parseIntAttribute(XmlPullParser parser, String attribute) {
        return (int)ShortcutService.parseLongAttribute(parser, attribute);
    }

    static int parseIntAttribute(XmlPullParser parser, String attribute, int def) {
        return (int)ShortcutService.parseLongAttribute(parser, attribute, def);
    }

    static long parseLongAttribute(XmlPullParser parser, String attribute) {
        return ShortcutService.parseLongAttribute(parser, attribute, 0L);
    }

    static long parseLongAttribute(XmlPullParser parser, String attribute, long def) {
        String value = ShortcutService.parseStringAttribute(parser, attribute);
        if (TextUtils.isEmpty(value)) {
            return def;
        }
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            Slog.e(TAG, "Error parsing long " + value);
            return def;
        }
    }

    static ComponentName parseComponentNameAttribute(XmlPullParser parser, String attribute) {
        String value = ShortcutService.parseStringAttribute(parser, attribute);
        if (TextUtils.isEmpty(value)) {
            return null;
        }
        return ComponentName.unflattenFromString(value);
    }

    static Intent parseIntentAttribute(XmlPullParser parser, String attribute) {
        String value = ShortcutService.parseStringAttribute(parser, attribute);
        if (TextUtils.isEmpty(value)) {
            return null;
        }
        try {
            return Intent.parseUri(value, 0);
        }
        catch (URISyntaxException e) {
            Slog.e(TAG, "Error parsing intent", e);
            return null;
        }
    }

    static void writeTagValue(XmlSerializer out, String tag, String value) throws IOException {
        if (TextUtils.isEmpty(value)) {
            return;
        }
        out.startTag(null, tag);
        out.attribute(null, ATTR_VALUE, value);
        out.endTag(null, tag);
    }

    static void writeTagValue(XmlSerializer out, String tag, long value) throws IOException {
        ShortcutService.writeTagValue(out, tag, Long.toString(value));
    }

    static void writeTagValue(XmlSerializer out, String tag, ComponentName name) throws IOException {
        if (name == null) {
            return;
        }
        ShortcutService.writeTagValue(out, tag, name.flattenToString());
    }

    static void writeTagExtra(XmlSerializer out, String tag, PersistableBundle bundle) throws IOException, XmlPullParserException {
        if (bundle == null) {
            return;
        }
        out.startTag(null, tag);
        bundle.saveToXml(out);
        out.endTag(null, tag);
    }

    static void writeAttr(XmlSerializer out, String name, String value) throws IOException {
        if (TextUtils.isEmpty(value)) {
            return;
        }
        out.attribute(null, name, value);
    }

    static void writeAttr(XmlSerializer out, String name, long value) throws IOException {
        ShortcutService.writeAttr(out, name, String.valueOf(value));
    }

    static void writeAttr(XmlSerializer out, String name, boolean value) throws IOException {
        if (value) {
            ShortcutService.writeAttr(out, name, "1");
        }
    }

    static void writeAttr(XmlSerializer out, String name, ComponentName comp) throws IOException {
        if (comp == null) {
            return;
        }
        ShortcutService.writeAttr(out, name, comp.flattenToString());
    }

    static void writeAttr(XmlSerializer out, String name, Intent intent) throws IOException {
        if (intent == null) {
            return;
        }
        ShortcutService.writeAttr(out, name, intent.toUri(0));
    }

    void saveBaseStateLocked() {
        AtomicFile file = this.getBaseStateFile();
        FileOutputStream outs = null;
        try {
            outs = file.startWrite();
            FastXmlSerializer out = new FastXmlSerializer();
            out.setOutput(outs, StandardCharsets.UTF_8.name());
            out.startDocument(null, true);
            out.startTag(null, TAG_ROOT);
            ShortcutService.writeTagValue((XmlSerializer)out, TAG_LAST_RESET_TIME, this.mRawLastResetTime);
            ShortcutService.writeTagValue((XmlSerializer)out, TAG_LOCALE_CHANGE_SEQUENCE_NUMBER, this.mLocaleChangeSequenceNumber.get());
            out.endTag(null, TAG_ROOT);
            out.endDocument();
            file.finishWrite(outs);
        }
        catch (IOException e) {
            Slog.e(TAG, "Failed to write to file " + file.getBaseFile(), e);
            file.failWrite(outs);
        }
    }

    private void loadBaseStateLocked() {
        this.mRawLastResetTime = 0L;
        AtomicFile file = this.getBaseStateFile();
        try (FileInputStream in2 = file.openRead();){
            int type;
            XmlPullParser parser = Xml.newPullParser();
            parser.setInput(in2, StandardCharsets.UTF_8.name());
            block23: while ((type = parser.next()) != 1) {
                if (type != 2) continue;
                int depth = parser.getDepth();
                String tag = parser.getName();
                if (depth == 1) {
                    if (TAG_ROOT.equals(tag)) continue;
                    Slog.e(TAG, "Invalid root tag: " + tag);
                    return;
                }
                switch (tag) {
                    case "last_reset_time": {
                        this.mRawLastResetTime = ShortcutService.parseLongAttribute(parser, ATTR_VALUE);
                        continue block23;
                    }
                    case "locale_seq_no": {
                        this.mLocaleChangeSequenceNumber.set(ShortcutService.parseLongAttribute(parser, ATTR_VALUE));
                        continue block23;
                    }
                }
                Slog.e(TAG, "Invalid tag: " + tag);
            }
        }
        catch (FileNotFoundException in2) {
        }
        catch (IOException | XmlPullParserException e) {
            Slog.e(TAG, "Failed to read file " + file.getBaseFile(), e);
            this.mRawLastResetTime = 0L;
        }
        this.getLastResetTimeLocked();
    }

    private void saveUserLocked(int userId) {
        File path = new File(this.injectUserDataPath(userId), FILENAME_USER_PACKAGES);
        path.mkdirs();
        AtomicFile file = new AtomicFile(path);
        FileOutputStream os = null;
        try {
            os = file.startWrite();
            this.saveUserInternalLocked(userId, os, false);
            file.finishWrite(os);
        }
        catch (IOException | XmlPullParserException e) {
            Slog.e(TAG, "Failed to write to file " + file.getBaseFile(), e);
            file.failWrite(os);
        }
    }

    private void saveUserInternalLocked(int userId, OutputStream os, boolean forBackup) throws IOException, XmlPullParserException {
        BufferedOutputStream bos = new BufferedOutputStream(os);
        FastXmlSerializer out = new FastXmlSerializer();
        out.setOutput(bos, StandardCharsets.UTF_8.name());
        out.startDocument(null, true);
        this.getUserShortcutsLocked(userId).saveToXml(this, out, forBackup);
        out.endDocument();
        bos.flush();
        os.flush();
    }

    static IOException throwForInvalidTag(int depth, String tag) throws IOException {
        throw new IOException(String.format("Invalid tag '%s' found at depth %d", tag, depth));
    }

    static void warnForInvalidTag(int depth, String tag) throws IOException {
        Slog.w(TAG, String.format("Invalid tag '%s' found at depth %d", tag, depth));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ShortcutUser loadUserLocked(int userId) {
        FileInputStream in;
        File path = new File(this.injectUserDataPath(userId), FILENAME_USER_PACKAGES);
        AtomicFile file = new AtomicFile(path);
        try {
            in = file.openRead();
        }
        catch (FileNotFoundException e) {
            return null;
        }
        try {
            ShortcutUser e = this.loadUserInternal(userId, in, false);
            return e;
        }
        catch (IOException | XmlPullParserException e) {
            Slog.e(TAG, "Failed to read file " + file.getBaseFile(), e);
            ShortcutUser shortcutUser = null;
            return shortcutUser;
        }
        finally {
            IoUtils.closeQuietly(in);
        }
    }

    private ShortcutUser loadUserInternal(int userId, InputStream is, boolean fromBackup) throws XmlPullParserException, IOException {
        int type;
        BufferedInputStream bis = new BufferedInputStream(is);
        ShortcutUser ret = null;
        XmlPullParser parser = Xml.newPullParser();
        parser.setInput(bis, StandardCharsets.UTF_8.name());
        while ((type = parser.next()) != 1) {
            if (type != 2) continue;
            int depth = parser.getDepth();
            String tag = parser.getName();
            if (depth == 1 && "user".equals(tag)) {
                ret = ShortcutUser.loadFromXml(this, parser, userId, fromBackup);
                continue;
            }
            ShortcutService.throwForInvalidTag(depth, tag);
        }
        return ret;
    }

    private void scheduleSaveBaseState() {
        this.scheduleSaveInner(-10000);
    }

    void scheduleSaveUser(int userId) {
        this.scheduleSaveInner(userId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleSaveInner(int userId) {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mDirtyUserIds.contains(userId)) {
                this.mDirtyUserIds.add(userId);
            }
        }
        this.mHandler.removeCallbacks(this.mSaveDirtyInfoRunner);
        this.mHandler.postDelayed(this.mSaveDirtyInfoRunner, this.mSaveDelayMillis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void saveDirtyInfo() {
        Object object = this.mLock;
        synchronized (object) {
            for (int i = this.mDirtyUserIds.size() - 1; i >= 0; --i) {
                int userId = this.mDirtyUserIds.get(i);
                if (userId == -10000) {
                    this.saveBaseStateLocked();
                    continue;
                }
                this.saveUserLocked(userId);
            }
            this.mDirtyUserIds.clear();
        }
    }

    long getLastResetTimeLocked() {
        this.updateTimesLocked();
        return this.mRawLastResetTime;
    }

    long getNextResetTimeLocked() {
        this.updateTimesLocked();
        return this.mRawLastResetTime + this.mResetInterval;
    }

    static boolean isClockValid(long time) {
        return time >= 1420070400L;
    }

    private void updateTimesLocked() {
        long now = this.injectCurrentTimeMillis();
        long prevLastResetTime = this.mRawLastResetTime;
        if (this.mRawLastResetTime == 0L) {
            this.mRawLastResetTime = now;
        } else if (now < this.mRawLastResetTime) {
            if (ShortcutService.isClockValid(now)) {
                Slog.w(TAG, "Clock rewound");
                this.mRawLastResetTime = now;
            }
        } else if (this.mRawLastResetTime + this.mResetInterval <= now) {
            long offset = this.mRawLastResetTime % this.mResetInterval;
            this.mRawLastResetTime = now / this.mResetInterval * this.mResetInterval + offset;
        }
        if (prevLastResetTime != this.mRawLastResetTime) {
            this.scheduleSaveBaseState();
        }
    }

    @GuardedBy(value="mLock")
    private boolean isUserLoadedLocked(int userId) {
        return this.mUsers.get(userId) != null;
    }

    @GuardedBy(value="mLock")
    ShortcutUser getUserShortcutsLocked(int userId) {
        ShortcutUser userPackages = this.mUsers.get(userId);
        if (userPackages == null) {
            userPackages = this.loadUserLocked(userId);
            if (userPackages == null) {
                userPackages = new ShortcutUser(userId);
            }
            this.mUsers.put(userId, userPackages);
        }
        return userPackages;
    }

    void forEachLoadedUserLocked(Consumer<ShortcutUser> c) {
        for (int i = this.mUsers.size() - 1; i >= 0; --i) {
            c.accept(this.mUsers.valueAt(i));
        }
    }

    @GuardedBy(value="mLock")
    ShortcutPackage getPackageShortcutsLocked(String packageName, int userId) {
        return this.getUserShortcutsLocked(userId).getPackageShortcuts(this, packageName);
    }

    @GuardedBy(value="mLock")
    ShortcutLauncher getLauncherShortcutsLocked(String packageName, int ownerUserId, int launcherUserId) {
        return this.getUserShortcutsLocked(ownerUserId).getLauncherShortcuts(this, packageName, launcherUserId);
    }

    void removeIcon(int userId, ShortcutInfo shortcut) {
        if (shortcut.getBitmapPath() != null) {
            new File(shortcut.getBitmapPath()).delete();
            shortcut.setBitmapPath(null);
            shortcut.setIconResourceId(0);
            shortcut.clearFlags(12);
        }
    }

    public void cleanupBitmapsForPackage(int userId, String packageName) {
        File packagePath = new File(this.getUserBitmapFilePath(userId), packageName);
        if (!packagePath.isDirectory()) {
            return;
        }
        if (!FileUtils.deleteContents(packagePath) || !packagePath.delete()) {
            Slog.w(TAG, "Unable to remove directory " + packagePath);
        }
    }

    FileOutputStreamWithPath openIconFileForWrite(int userId, ShortcutInfo shortcut) throws IOException {
        File packagePath = new File(this.getUserBitmapFilePath(userId), shortcut.getPackageName());
        if (!packagePath.isDirectory()) {
            packagePath.mkdirs();
            if (!packagePath.isDirectory()) {
                throw new IOException("Unable to create directory " + packagePath);
            }
            SELinux.restorecon(packagePath);
        }
        String baseName = String.valueOf(this.injectCurrentTimeMillis());
        int suffix = 0;
        String filename;
        File file;
        while ((file = new File(packagePath, filename = (suffix == 0 ? baseName : baseName + "_" + suffix) + ".png")).exists()) {
            ++suffix;
        }
        return new FileOutputStreamWithPath(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void saveIconAndFixUpShortcut(int userId, ShortcutInfo shortcut) {
        if (shortcut.hasIconFile()) return;
        if (shortcut.hasIconResource()) {
            return;
        }
        long token = this.injectClearCallingIdentity();
        try {
            shortcut.setIconResourceId(0);
            shortcut.setBitmapPath(null);
            Icon icon = shortcut.getIcon();
            if (icon == null) {
                return;
            }
            Bitmap bitmapToRecycle = null;
            try {
                Bitmap bitmap;
                switch (icon.getType()) {
                    case 2: {
                        this.injectValidateIconResPackage(shortcut, icon);
                        shortcut.setIconResourceId(icon.getResId());
                        shortcut.addFlags(4);
                        return;
                    }
                    case 1: {
                        bitmap = icon.getBitmap();
                        break;
                    }
                    default: {
                        throw ShortcutInfo.getInvalidIconException();
                    }
                }
                if (bitmap == null) {
                    Slog.e(TAG, "Null bitmap detected");
                    return;
                }
                File path = null;
                try {
                    FileOutputStreamWithPath out = this.openIconFileForWrite(userId, shortcut);
                    try {
                        path = out.getFile();
                        Bitmap shrunk = ShortcutService.shrinkBitmap(bitmap, this.mMaxIconDimension);
                        try {
                            shrunk.compress(this.mIconPersistFormat, this.mIconPersistQuality, out);
                        }
                        finally {
                            if (bitmap != shrunk) {
                                shrunk.recycle();
                            }
                        }
                        shortcut.setBitmapPath(out.getFile().getAbsolutePath());
                        shortcut.addFlags(8);
                        return;
                    }
                    finally {
                        IoUtils.closeQuietly(out);
                    }
                }
                catch (IOException | RuntimeException e) {
                    Slog.wtf(TAG, "Unable to write bitmap to file", e);
                    if (path == null) return;
                    if (!path.exists()) return;
                    path.delete();
                    return;
                }
            }
            finally {
                if (bitmapToRecycle != null) {
                    bitmapToRecycle.recycle();
                }
                shortcut.clearIcon();
            }
        }
        finally {
            this.injectRestoreCallingIdentity(token);
        }
    }

    void injectValidateIconResPackage(ShortcutInfo shortcut, Icon icon) {
        if (!shortcut.getPackageName().equals(icon.getResPackage())) {
            throw new IllegalArgumentException("Icon resource must reside in shortcut owner package");
        }
    }

    static Bitmap shrinkBitmap(Bitmap in, int maxSize) {
        int ow = in.getWidth();
        int oh = in.getHeight();
        if (ow <= maxSize && oh <= maxSize) {
            return in;
        }
        int longerDimension = Math.max(ow, oh);
        int nw = ow * maxSize / longerDimension;
        int nh = oh * maxSize / longerDimension;
        Bitmap scaledBitmap = Bitmap.createBitmap(nw, nh, Bitmap.Config.ARGB_8888);
        Canvas c = new Canvas(scaledBitmap);
        RectF dst = new RectF(0.0f, 0.0f, nw, nh);
        c.drawBitmap(in, null, dst, null);
        return scaledBitmap;
    }

    private boolean isCallerSystem() {
        int callingUid = this.injectBinderCallingUid();
        return UserHandle.isSameApp(callingUid, 1000);
    }

    private boolean isCallerShell() {
        int callingUid = this.injectBinderCallingUid();
        return callingUid == 2000 || callingUid == 0;
    }

    private void enforceSystemOrShell() {
        Preconditions.checkState(this.isCallerSystem() || this.isCallerShell(), "Caller must be system or shell");
    }

    private void enforceShell() {
        Preconditions.checkState(this.isCallerShell(), "Caller must be shell");
    }

    private void enforceSystem() {
        Preconditions.checkState(this.isCallerSystem(), "Caller must be system");
    }

    private void enforceResetThrottlingPermission() {
        if (this.isCallerSystem()) {
            return;
        }
        this.injectEnforceCallingPermission("android.permission.RESET_SHORTCUT_MANAGER_THROTTLING", null);
    }

    void injectEnforceCallingPermission(String permission2, String message) {
        this.mContext.enforceCallingPermission(permission2, message);
    }

    private void verifyCaller(String packageName, int userId) {
        Preconditions.checkStringNotEmpty(packageName, "packageName");
        if (this.isCallerSystem()) {
            return;
        }
        int callingUid = this.injectBinderCallingUid();
        if (UserHandle.getUserId(callingUid) != userId) {
            throw new SecurityException("Invalid user-ID");
        }
        if (this.injectGetPackageUid(packageName, userId) == this.injectBinderCallingUid()) {
            return;
        }
        throw new SecurityException("Calling package name mismatch");
    }

    void postToHandler(Runnable r) {
        this.mHandler.post(r);
    }

    void enforceMaxDynamicShortcuts(int numShortcuts) {
        if (numShortcuts > this.mMaxDynamicShortcuts) {
            throw new IllegalArgumentException("Max number of dynamic shortcuts exceeded");
        }
    }

    void packageShortcutsChanged(String packageName, int userId) {
        this.notifyListeners(packageName, userId);
        this.scheduleSaveUser(userId);
    }

    private void notifyListeners(String packageName, int userId) {
        if (!this.mUserManager.isUserRunning(userId)) {
            return;
        }
        this.postToHandler(() -> {
            ArrayList<ShortcutServiceInternal.ShortcutChangeListener> copy;
            Object object = this.mLock;
            synchronized (object) {
                copy = new ArrayList<ShortcutServiceInternal.ShortcutChangeListener>(this.mListeners);
            }
            for (int i = copy.size() - 1; i >= 0; --i) {
                copy.get(i).onShortcutChanged(packageName, userId);
            }
        });
    }

    private void fixUpIncomingShortcutInfo(ShortcutInfo shortcut, boolean forUpdate) {
        Preconditions.checkNotNull(shortcut, "Null shortcut detected");
        if (shortcut.getActivityComponent() != null) {
            Preconditions.checkState(shortcut.getPackageName().equals(shortcut.getActivityComponent().getPackageName()), "Activity package name mismatch");
        }
        if (!forUpdate) {
            shortcut.enforceMandatoryFields();
        }
        if (shortcut.getIcon() != null) {
            ShortcutInfo.validateIcon(shortcut.getIcon());
        }
        ShortcutService.validateForXml(shortcut.getId());
        ShortcutService.validateForXml(shortcut.getTitle());
        ShortcutService.validatePersistableBundleForXml(shortcut.getIntentPersistableExtras());
        ShortcutService.validatePersistableBundleForXml(shortcut.getExtras());
        shortcut.replaceFlags(0);
    }

    private static void validatePersistableBundleForXml(PersistableBundle b) {
        if (b == null || b.size() == 0) {
            return;
        }
        for (String key : b.keySet()) {
            ShortcutService.validateForXml(key);
            Object value = b.get(key);
            if (value == null) continue;
            if (value instanceof String) {
                ShortcutService.validateForXml((String)value);
                continue;
            }
            if (value instanceof String[]) {
                for (String v : (String[])value) {
                    ShortcutService.validateForXml(v);
                }
                continue;
            }
            if (!(value instanceof PersistableBundle)) continue;
            ShortcutService.validatePersistableBundleForXml((PersistableBundle)value);
        }
    }

    private static void validateForXml(String s) {
        if (TextUtils.isEmpty(s)) {
            return;
        }
        for (int i = s.length() - 1; i >= 0; --i) {
            if (ShortcutService.isAllowedInXml(s.charAt(i))) continue;
            throw new IllegalArgumentException("Unsupported character detected in: " + s);
        }
    }

    private static boolean isAllowedInXml(char c) {
        return c >= ' ' && c <= '\ud7ff' || c >= '\ue000' && c <= '\ufffd';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setDynamicShortcuts(String packageName, ParceledListSlice shortcutInfoList, int userId) {
        this.verifyCaller(packageName, userId);
        List newShortcuts = shortcutInfoList.getList();
        int size = newShortcuts.size();
        Object object = this.mLock;
        synchronized (object) {
            int i;
            ShortcutPackage ps = this.getPackageShortcutsLocked(packageName, userId);
            if (!ps.tryApiCall(this)) {
                return false;
            }
            this.enforceMaxDynamicShortcuts(size);
            for (i = 0; i < size; ++i) {
                this.fixUpIncomingShortcutInfo((ShortcutInfo)newShortcuts.get(i), false);
            }
            ps.deleteAllDynamicShortcuts(this);
            for (i = 0; i < size; ++i) {
                ShortcutInfo newShortcut = (ShortcutInfo)newShortcuts.get(i);
                ps.addDynamicShortcut(this, newShortcut);
            }
        }
        this.packageShortcutsChanged(packageName, userId);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean updateShortcuts(String packageName, ParceledListSlice shortcutInfoList, int userId) {
        this.verifyCaller(packageName, userId);
        List newShortcuts = shortcutInfoList.getList();
        int size = newShortcuts.size();
        Object object = this.mLock;
        synchronized (object) {
            ShortcutPackage ps = this.getPackageShortcutsLocked(packageName, userId);
            if (!ps.tryApiCall(this)) {
                return false;
            }
            for (int i = 0; i < size; ++i) {
                boolean replacingIcon;
                ShortcutInfo source = (ShortcutInfo)newShortcuts.get(i);
                this.fixUpIncomingShortcutInfo(source, true);
                ShortcutInfo target = ps.findShortcutById(source.getId());
                if (target == null) continue;
                boolean bl = replacingIcon = source.getIcon() != null;
                if (replacingIcon) {
                    this.removeIcon(userId, target);
                }
                target.copyNonNullFieldsFrom(source);
                if (!replacingIcon) continue;
                this.saveIconAndFixUpShortcut(userId, target);
            }
        }
        this.packageShortcutsChanged(packageName, userId);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addDynamicShortcuts(String packageName, ParceledListSlice shortcutInfoList, int userId) {
        this.verifyCaller(packageName, userId);
        List newShortcuts = shortcutInfoList.getList();
        int size = newShortcuts.size();
        Object object = this.mLock;
        synchronized (object) {
            ShortcutPackage ps = this.getPackageShortcutsLocked(packageName, userId);
            if (!ps.tryApiCall(this)) {
                return false;
            }
            for (int i = 0; i < size; ++i) {
                ShortcutInfo newShortcut = (ShortcutInfo)newShortcuts.get(i);
                this.fixUpIncomingShortcutInfo(newShortcut, false);
                ps.addDynamicShortcut(this, newShortcut);
            }
        }
        this.packageShortcutsChanged(packageName, userId);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeDynamicShortcuts(String packageName, List shortcutIds, int userId) {
        this.verifyCaller(packageName, userId);
        Preconditions.checkNotNull(shortcutIds, "shortcutIds must be provided");
        Object object = this.mLock;
        synchronized (object) {
            for (int i = shortcutIds.size() - 1; i >= 0; --i) {
                this.getPackageShortcutsLocked(packageName, userId).deleteDynamicWithId(this, Preconditions.checkStringNotEmpty((String)shortcutIds.get(i)));
            }
        }
        this.packageShortcutsChanged(packageName, userId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAllDynamicShortcuts(String packageName, int userId) {
        this.verifyCaller(packageName, userId);
        Object object = this.mLock;
        synchronized (object) {
            this.getPackageShortcutsLocked(packageName, userId).deleteAllDynamicShortcuts(this);
        }
        this.packageShortcutsChanged(packageName, userId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ParceledListSlice<ShortcutInfo> getDynamicShortcuts(String packageName, int userId) {
        this.verifyCaller(packageName, userId);
        Object object = this.mLock;
        synchronized (object) {
            return this.getShortcutsWithQueryLocked(packageName, userId, 1, ShortcutInfo::isDynamic);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ParceledListSlice<ShortcutInfo> getPinnedShortcuts(String packageName, int userId) {
        this.verifyCaller(packageName, userId);
        Object object = this.mLock;
        synchronized (object) {
            return this.getShortcutsWithQueryLocked(packageName, userId, 1, ShortcutInfo::isPinned);
        }
    }

    private ParceledListSlice<ShortcutInfo> getShortcutsWithQueryLocked(String packageName, int userId, int cloneFlags, Predicate<ShortcutInfo> query) {
        ArrayList<ShortcutInfo> ret = new ArrayList<ShortcutInfo>();
        this.getPackageShortcutsLocked(packageName, userId).findAll(this, ret, query, cloneFlags);
        return new ParceledListSlice<ShortcutInfo>(ret);
    }

    @Override
    public int getMaxDynamicShortcutCount(String packageName, int userId) throws RemoteException {
        this.verifyCaller(packageName, userId);
        return this.mMaxDynamicShortcuts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRemainingCallCount(String packageName, int userId) {
        this.verifyCaller(packageName, userId);
        Object object = this.mLock;
        synchronized (object) {
            return this.mMaxUpdatesPerInterval - this.getPackageShortcutsLocked(packageName, userId).getApiCallCount(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getRateLimitResetTime(String packageName, int userId) {
        this.verifyCaller(packageName, userId);
        Object object = this.mLock;
        synchronized (object) {
            return this.getNextResetTimeLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getIconMaxDimensions(String packageName, int userId) throws RemoteException {
        this.verifyCaller(packageName, userId);
        Object object = this.mLock;
        synchronized (object) {
            return this.mMaxIconDimension;
        }
    }

    @Override
    public void resetThrottling() {
        this.enforceSystemOrShell();
        this.resetThrottlingInner(this.getCallingUserId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resetThrottlingInner(int userId) {
        Object object = this.mLock;
        synchronized (object) {
            this.getUserShortcutsLocked(userId).resetThrottling();
        }
        this.scheduleSaveUser(userId);
        Slog.i(TAG, "ShortcutManager: throttling counter reset for user " + userId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resetAllThrottlingInner() {
        Object object = this.mLock;
        synchronized (object) {
            this.mRawLastResetTime = this.injectCurrentTimeMillis();
        }
        this.scheduleSaveBaseState();
        Slog.i(TAG, "ShortcutManager: throttling counter reset for all users");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resetPackageThrottling(String packageName, int userId) {
        Object object = this.mLock;
        synchronized (object) {
            this.getPackageShortcutsLocked(packageName, userId).resetRateLimitingForCommandLineNoSaving();
            this.saveUserLocked(userId);
        }
    }

    @Override
    public void onApplicationActive(String packageName, int userId) {
        this.enforceResetThrottlingPermission();
        this.resetPackageThrottling(packageName, userId);
    }

    boolean hasShortcutHostPermission(String callingPackage, int userId) {
        return this.hasShortcutHostPermissionInner(callingPackage, userId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean hasShortcutHostPermissionInner(String callingPackage, int userId) {
        Object object = this.mLock;
        synchronized (object) {
            long start = System.currentTimeMillis();
            ShortcutUser user = this.getUserShortcutsLocked(userId);
            ArrayList<ResolveInfo> allHomeCandidates = new ArrayList<ResolveInfo>();
            long startGetHomeActivitiesAsUser = System.currentTimeMillis();
            ComponentName defaultLauncher = this.injectPackageManagerInternal().getHomeActivitiesAsUser(allHomeCandidates, userId);
            this.logDurationStat(0, startGetHomeActivitiesAsUser);
            ComponentName detected = defaultLauncher != null ? defaultLauncher : user.getLauncherComponent();
            if (detected == null) {
                int size = allHomeCandidates.size();
                int lastPriority = Integer.MIN_VALUE;
                for (int i = 0; i < size; ++i) {
                    ResolveInfo ri = (ResolveInfo)allHomeCandidates.get(i);
                    if (!ri.activityInfo.applicationInfo.isSystemApp() || ri.priority < lastPriority) continue;
                    detected = ri.activityInfo.getComponentName();
                    lastPriority = ri.priority;
                }
            }
            this.logDurationStat(4, start);
            if (detected != null) {
                user.setLauncherComponent(this, detected);
                return detected.getPackageName().equals(callingPackage);
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanUpPackageForAllLoadedUsers(String packageName, int packageUserId) {
        Object object = this.mLock;
        synchronized (object) {
            this.forEachLoadedUserLocked(user -> this.cleanUpPackageLocked(packageName, user.getUserId(), packageUserId));
        }
    }

    void cleanUpPackageLocked(String packageName, int owningUserId, int packageUserId) {
        boolean wasUserLoaded = this.isUserLoadedLocked(owningUserId);
        ShortcutUser user = this.getUserShortcutsLocked(owningUserId);
        boolean doNotify = false;
        if (packageUserId == owningUserId && user.removePackage(this, packageName) != null) {
            doNotify = true;
        }
        user.removeLauncher(packageUserId, packageName);
        user.forAllLaunchers(l -> l.cleanUpPackage(packageName, packageUserId));
        user.forAllPackages(p -> p.refreshPinnedFlags(this));
        this.scheduleSaveUser(owningUserId);
        if (doNotify) {
            this.notifyListeners(packageName, owningUserId);
        }
        if (!wasUserLoaded) {
            this.unloadUserLocked(owningUserId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkPackageChanges(int ownerUserId) {
        ArrayList gonePackages = new ArrayList();
        Object object = this.mLock;
        synchronized (object) {
            ShortcutUser user = this.getUserShortcutsLocked(ownerUserId);
            user.forAllPackageItems(spi -> {
                if (spi.getPackageInfo().isShadow()) {
                    return;
                }
                int versionCode = this.getApplicationVersionCode(spi.getPackageName(), spi.getPackageUserId());
                if (versionCode >= 0) {
                    this.getUserShortcutsLocked(ownerUserId).handlePackageUpdated(this, spi.getPackageName(), versionCode);
                } else {
                    gonePackages.add(ShortcutUser.PackageWithUser.of(spi));
                }
            });
            if (gonePackages.size() > 0) {
                for (int i = gonePackages.size() - 1; i >= 0; --i) {
                    ShortcutUser.PackageWithUser pu = (ShortcutUser.PackageWithUser)gonePackages.get(i);
                    this.cleanUpPackageLocked(pu.packageName, ownerUserId, pu.userId);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handlePackageAdded(String packageName, int userId) {
        Object object = this.mLock;
        synchronized (object) {
            this.forEachLoadedUserLocked(user -> user.attemptToRestoreIfNeededAndSave(this, packageName, userId));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handlePackageUpdateFinished(String packageName, int userId) {
        Object object = this.mLock;
        synchronized (object) {
            this.forEachLoadedUserLocked(user -> user.attemptToRestoreIfNeededAndSave(this, packageName, userId));
            int versionCode = this.getApplicationVersionCode(packageName, userId);
            if (versionCode < 0) {
                return;
            }
            this.getUserShortcutsLocked(userId).handlePackageUpdated(this, packageName, versionCode);
        }
    }

    private void handlePackageRemoved(String packageName, int packageUserId) {
        this.cleanUpPackageForAllLoadedUsers(packageName, packageUserId);
    }

    private void handlePackageDataCleared(String packageName, int packageUserId) {
        this.cleanUpPackageForAllLoadedUsers(packageName, packageUserId);
    }

    PackageInfo getPackageInfoWithSignatures(String packageName, int userId) {
        return this.injectPackageInfo(packageName, userId, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int injectGetPackageUid(String packageName, int userId) {
        long token = this.injectClearCallingIdentity();
        try {
            int n = this.mIPackageManager.getPackageUid(packageName, 794624, userId);
            return n;
        }
        catch (RemoteException e) {
            Slog.wtf(TAG, "RemoteException", e);
            int n = -1;
            return n;
        }
        finally {
            this.injectRestoreCallingIdentity(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PackageInfo injectPackageInfo(String packageName, int userId, boolean getSignatures) {
        long start = System.currentTimeMillis();
        long token = this.injectClearCallingIdentity();
        try {
            PackageInfo packageInfo = this.mIPackageManager.getPackageInfo(packageName, 0xC2000 | (getSignatures ? 64 : 0), userId);
            this.injectRestoreCallingIdentity(token);
            this.logDurationStat(getSignatures ? 2 : 1, start);
            return packageInfo;
        }
        catch (RemoteException e) {
            try {
                Slog.wtf(TAG, "RemoteException", e);
                PackageInfo packageInfo = null;
                this.injectRestoreCallingIdentity(token);
                this.logDurationStat(getSignatures ? 2 : 1, start);
                return packageInfo;
            }
            catch (Throwable throwable) {
                this.injectRestoreCallingIdentity(token);
                this.logDurationStat(getSignatures ? 2 : 1, start);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ApplicationInfo injectApplicationInfo(String packageName, int userId) {
        long start = System.currentTimeMillis();
        long token = this.injectClearCallingIdentity();
        try {
            ApplicationInfo applicationInfo = this.mIPackageManager.getApplicationInfo(packageName, 794624, userId);
            return applicationInfo;
        }
        catch (RemoteException e) {
            Slog.wtf(TAG, "RemoteException", e);
            ApplicationInfo applicationInfo = null;
            return applicationInfo;
        }
        finally {
            this.injectRestoreCallingIdentity(token);
            this.logDurationStat(3, start);
        }
    }

    private boolean isApplicationFlagSet(String packageName, int userId, int flags) {
        ApplicationInfo ai = this.injectApplicationInfo(packageName, userId);
        return ai != null && (ai.flags & flags) == flags;
    }

    boolean isPackageInstalled(String packageName, int userId) {
        return this.isApplicationFlagSet(packageName, userId, 0x800000);
    }

    int getApplicationVersionCode(String packageName, int userId) {
        ApplicationInfo ai = this.injectApplicationInfo(packageName, userId);
        if (ai == null || (ai.flags & 0x800000) == 0) {
            return -1;
        }
        return ai.versionCode;
    }

    boolean shouldBackupApp(String packageName, int userId) {
        return this.isApplicationFlagSet(packageName, userId, 32768);
    }

    boolean shouldBackupApp(PackageInfo pi) {
        return (pi.applicationInfo.flags & 0x8000) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getBackupPayload(int userId) {
        this.enforceSystem();
        Object object = this.mLock;
        synchronized (object) {
            ShortcutUser user = this.getUserShortcutsLocked(userId);
            if (user == null) {
                Slog.w(TAG, "Can't backup: user not found: id=" + userId);
                return null;
            }
            user.forAllPackageItems(spi -> spi.refreshPackageInfoAndSave(this));
            ByteArrayOutputStream os = new ByteArrayOutputStream(32768);
            try {
                this.saveUserInternalLocked(userId, os, true);
            }
            catch (IOException | XmlPullParserException e) {
                Slog.w(TAG, "Backup failed.", e);
                return null;
            }
            return os.toByteArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void applyRestore(byte[] payload, int userId) {
        ShortcutUser user;
        this.enforceSystem();
        ByteArrayInputStream is = new ByteArrayInputStream(payload);
        try {
            user = this.loadUserInternal(userId, is, true);
        }
        catch (IOException | XmlPullParserException e) {
            Slog.w(TAG, "Restoration failed.", e);
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            this.mUsers.put(userId, user);
            File bitmapPath = this.getUserBitmapFilePath(userId);
            boolean success = FileUtils.deleteContents(bitmapPath);
            if (!success) {
                Slog.w(TAG, "Failed to delete " + bitmapPath);
            }
            this.saveUserLocked(userId);
        }
    }

    @Override
    public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        if (this.mContext.checkCallingOrSelfPermission("android.permission.DUMP") != 0) {
            pw.println("Permission Denial: can't dump UserManager from from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid() + " without permission " + "android.permission.DUMP");
            return;
        }
        this.dumpInner(pw, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dumpInner(PrintWriter pw, String[] args) {
        Object object = this.mLock;
        synchronized (object) {
            int i;
            long now = this.injectCurrentTimeMillis();
            pw.print("Now: [");
            pw.print(now);
            pw.print("] ");
            pw.print(ShortcutService.formatTime(now));
            pw.print("  Raw last reset: [");
            pw.print(this.mRawLastResetTime);
            pw.print("] ");
            pw.print(ShortcutService.formatTime(this.mRawLastResetTime));
            long last = this.getLastResetTimeLocked();
            pw.print("  Last reset: [");
            pw.print(last);
            pw.print("] ");
            pw.print(ShortcutService.formatTime(last));
            long next = this.getNextResetTimeLocked();
            pw.print("  Next reset: [");
            pw.print(next);
            pw.print("] ");
            pw.print(ShortcutService.formatTime(next));
            pw.print("  Locale change seq#: ");
            pw.print(this.mLocaleChangeSequenceNumber.get());
            pw.println();
            pw.print("  Config:");
            pw.print("    Max icon dim: ");
            pw.println(this.mMaxIconDimension);
            pw.print("    Icon format: ");
            pw.println((Object)this.mIconPersistFormat);
            pw.print("    Icon quality: ");
            pw.println(this.mIconPersistQuality);
            pw.print("    saveDelayMillis: ");
            pw.println(this.mSaveDelayMillis);
            pw.print("    resetInterval: ");
            pw.println(this.mResetInterval);
            pw.print("    maxUpdatesPerInterval: ");
            pw.println(this.mMaxUpdatesPerInterval);
            pw.print("    maxDynamicShortcuts: ");
            pw.println(this.mMaxDynamicShortcuts);
            pw.println();
            pw.println("  Stats:");
            Object object2 = this.mStatLock;
            synchronized (object2) {
                String p = "    ";
                this.dumpStatLS(pw, "    ", 0, "getHomeActivities()");
                this.dumpStatLS(pw, "    ", 4, "Launcher permission check");
                this.dumpStatLS(pw, "    ", 1, "getPackageInfo()");
                this.dumpStatLS(pw, "    ", 2, "getPackageInfo(SIG)");
                this.dumpStatLS(pw, "    ", 3, "getApplicationInfo");
            }
            for (i = 0; i < this.mUsers.size(); ++i) {
                pw.println();
                this.mUsers.valueAt(i).dump(this, pw, "  ");
            }
            pw.println();
            pw.println("  UID state:");
            for (i = 0; i < this.mUidState.size(); ++i) {
                int uid = this.mUidState.keyAt(i);
                int state = this.mUidState.valueAt(i);
                pw.print("    UID=");
                pw.print(uid);
                pw.print(" state=");
                pw.print(state);
                if (this.isProcessStateForeground(state)) {
                    pw.print("  [FG]");
                }
                pw.print("  last FG=");
                pw.print(this.mUidLastForegroundElapsedTime.get(uid));
                pw.println();
            }
        }
    }

    static String formatTime(long time) {
        Time tobj = new Time();
        tobj.set(time);
        return tobj.format("%Y-%m-%d %H:%M:%S");
    }

    private void dumpStatLS(PrintWriter pw, String prefix, int statId, String label) {
        pw.print(prefix);
        int count = this.mCountStats[statId];
        long dur = this.mDurationStats[statId];
        pw.println(String.format("%s: count=%d, total=%dms, avg=%.1fms", label, count, dur, count == 0 ? 0.0 : (double)dur / (double)count));
    }

    @Override
    public void onShellCommand(FileDescriptor in, FileDescriptor out, FileDescriptor err, String[] args, ResultReceiver resultReceiver) throws RemoteException {
        this.enforceShell();
        new MyShellCommand().exec(this, in, out, err, args, resultReceiver);
    }

    long injectCurrentTimeMillis() {
        return System.currentTimeMillis();
    }

    long injectElapsedRealtime() {
        return SystemClock.elapsedRealtime();
    }

    int injectBinderCallingUid() {
        return ShortcutService.getCallingUid();
    }

    private int getCallingUserId() {
        return UserHandle.getUserId(this.injectBinderCallingUid());
    }

    long injectClearCallingIdentity() {
        return Binder.clearCallingIdentity();
    }

    void injectRestoreCallingIdentity(long token) {
        Binder.restoreCallingIdentity(token);
    }

    final void wtf(String message) {
        this.wtf(message, null);
    }

    void wtf(String message, Exception e) {
        Slog.wtf(TAG, message, e);
    }

    File injectSystemDataPath() {
        return Environment.getDataSystemDirectory();
    }

    File injectUserDataPath(int userId) {
        return new File(Environment.getDataSystemCeDirectory(userId), DIRECTORY_PER_USER);
    }

    boolean injectIsLowRamDevice() {
        return ActivityManager.isLowRamDeviceStatic();
    }

    void injectRegisterUidObserver(IUidObserver observer, int which) {
        try {
            ActivityManagerNative.getDefault().registerUidObserver(observer, which);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    PackageManagerInternal injectPackageManagerInternal() {
        return this.mPackageManagerInternal;
    }

    File getUserBitmapFilePath(int userId) {
        return new File(this.injectUserDataPath(userId), DIRECTORY_BITMAPS);
    }

    SparseArray<ShortcutUser> getShortcutsForTest() {
        return this.mUsers;
    }

    int getMaxDynamicShortcutsForTest() {
        return this.mMaxDynamicShortcuts;
    }

    int getMaxUpdatesPerIntervalForTest() {
        return this.mMaxUpdatesPerInterval;
    }

    long getResetIntervalForTest() {
        return this.mResetInterval;
    }

    int getMaxIconDimensionForTest() {
        return this.mMaxIconDimension;
    }

    Bitmap.CompressFormat getIconPersistFormatForTest() {
        return this.mIconPersistFormat;
    }

    int getIconPersistQualityForTest() {
        return this.mIconPersistQuality;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ShortcutInfo getPackageShortcutForTest(String packageName, String shortcutId, int userId) {
        Object object = this.mLock;
        synchronized (object) {
            ShortcutUser user = this.mUsers.get(userId);
            if (user == null) {
                return null;
            }
            ShortcutPackage pkg = user.getAllPackagesForTest().get(packageName);
            if (pkg == null) {
                return null;
            }
            return pkg.findShortcutById(shortcutId);
        }
    }

    static /* synthetic */ AtomicLong access$300(ShortcutService x0) {
        return x0.mLocaleChangeSequenceNumber;
    }

    private class MyShellCommand
    extends ShellCommand {
        private int mUserId = 0;

        private MyShellCommand() {
        }

        private void parseOptions(boolean takeUser) throws CommandException {
            String opt;
            block6: while ((opt = this.getNextOption()) != null) {
                switch (opt) {
                    case "--user": {
                        if (!takeUser) break;
                        this.mUserId = UserHandle.parseUserArg(this.getNextArgRequired());
                        continue block6;
                    }
                }
                throw new CommandException("Unknown option: " + opt);
            }
        }

        @Override
        public int onCommand(String cmd) {
            if (cmd == null) {
                return this.handleDefaultCommands(cmd);
            }
            PrintWriter pw = this.getOutPrintWriter();
            try {
                switch (cmd) {
                    case "reset-package-throttling": {
                        this.handleResetPackageThrottling();
                        break;
                    }
                    case "reset-throttling": {
                        this.handleResetThrottling();
                        break;
                    }
                    case "reset-all-throttling": {
                        this.handleResetAllThrottling();
                        break;
                    }
                    case "override-config": {
                        this.handleOverrideConfig();
                        break;
                    }
                    case "reset-config": {
                        this.handleResetConfig();
                        break;
                    }
                    case "clear-default-launcher": {
                        this.handleClearDefaultLauncher();
                        break;
                    }
                    case "get-default-launcher": {
                        this.handleGetDefaultLauncher();
                        break;
                    }
                    case "refresh-default-launcher": {
                        this.handleRefreshDefaultLauncher();
                        break;
                    }
                    case "unload-user": {
                        this.handleUnloadUser();
                        break;
                    }
                    case "clear-shortcuts": {
                        this.handleClearShortcuts();
                        break;
                    }
                    default: {
                        return this.handleDefaultCommands(cmd);
                    }
                }
            }
            catch (CommandException e) {
                pw.println("Error: " + e.getMessage());
                return 1;
            }
            pw.println("Success");
            return 0;
        }

        @Override
        public void onHelp() {
            PrintWriter pw = this.getOutPrintWriter();
            pw.println("Usage: cmd shortcut COMMAND [options ...]");
            pw.println();
            pw.println("cmd shortcut reset-package-throttling [--user USER_ID] PACKAGE");
            pw.println("    Reset throttling for a package");
            pw.println();
            pw.println("cmd shortcut reset-throttling [--user USER_ID]");
            pw.println("    Reset throttling for all packages and users");
            pw.println();
            pw.println("cmd shortcut reset-all-throttling");
            pw.println("    Reset the throttling state for all users");
            pw.println();
            pw.println("cmd shortcut override-config CONFIG");
            pw.println("    Override the configuration for testing (will last until reboot)");
            pw.println();
            pw.println("cmd shortcut reset-config");
            pw.println("    Reset the configuration set with \"update-config\"");
            pw.println();
            pw.println("cmd shortcut clear-default-launcher [--user USER_ID]");
            pw.println("    Clear the cached default launcher");
            pw.println();
            pw.println("cmd shortcut get-default-launcher [--user USER_ID]");
            pw.println("    Show the cached default launcher");
            pw.println();
            pw.println("cmd shortcut refresh-default-launcher [--user USER_ID]");
            pw.println("    Refresh the cached default launcher");
            pw.println();
            pw.println("cmd shortcut unload-user [--user USER_ID]");
            pw.println("    Unload a user from the memory");
            pw.println("    (This should not affect any observable behavior)");
            pw.println();
            pw.println("cmd shortcut clear-shortcuts [--user USER_ID] PACKAGE");
            pw.println("    Remove all shortcuts from a package, including pinned shortcuts");
            pw.println();
        }

        private void handleResetThrottling() throws CommandException {
            this.parseOptions(true);
            Slog.i(ShortcutService.TAG, "cmd: handleResetThrottling");
            ShortcutService.this.resetThrottlingInner(this.mUserId);
        }

        private void handleResetAllThrottling() {
            Slog.i(ShortcutService.TAG, "cmd: handleResetAllThrottling");
            ShortcutService.this.resetAllThrottlingInner();
        }

        private void handleResetPackageThrottling() throws CommandException {
            this.parseOptions(true);
            String packageName = this.getNextArgRequired();
            Slog.i(ShortcutService.TAG, "cmd: handleResetPackageThrottling: " + packageName);
            ShortcutService.this.resetPackageThrottling(packageName, this.mUserId);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleOverrideConfig() throws CommandException {
            String config = this.getNextArgRequired();
            Slog.i(ShortcutService.TAG, "cmd: handleOverrideConfig: " + config);
            Object object = ShortcutService.this.mLock;
            synchronized (object) {
                if (!ShortcutService.this.updateConfigurationLocked(config)) {
                    throw new CommandException("override-config failed.  See logcat for details.");
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleResetConfig() {
            Slog.i(ShortcutService.TAG, "cmd: handleResetConfig");
            Object object = ShortcutService.this.mLock;
            synchronized (object) {
                ShortcutService.this.loadConfigurationLocked();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void clearLauncher() {
            Object object = ShortcutService.this.mLock;
            synchronized (object) {
                ShortcutService.this.getUserShortcutsLocked(this.mUserId).setLauncherComponent(ShortcutService.this, null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void showLauncher() {
            Object object = ShortcutService.this.mLock;
            synchronized (object) {
                ShortcutService.this.hasShortcutHostPermissionInner("-", this.mUserId);
                this.getOutPrintWriter().println("Launcher: " + ShortcutService.this.getUserShortcutsLocked(this.mUserId).getLauncherComponent());
            }
        }

        private void handleClearDefaultLauncher() throws CommandException {
            this.parseOptions(true);
            this.clearLauncher();
        }

        private void handleGetDefaultLauncher() throws CommandException {
            this.parseOptions(true);
            this.showLauncher();
        }

        private void handleRefreshDefaultLauncher() throws CommandException {
            this.parseOptions(true);
            this.clearLauncher();
            this.showLauncher();
        }

        private void handleUnloadUser() throws CommandException {
            this.parseOptions(true);
            Slog.i(ShortcutService.TAG, "cmd: handleUnloadUser: " + this.mUserId);
            ShortcutService.this.handleCleanupUser(this.mUserId);
        }

        private void handleClearShortcuts() throws CommandException {
            this.parseOptions(true);
            String packageName = this.getNextArgRequired();
            Slog.i(ShortcutService.TAG, "cmd: handleClearShortcuts: " + this.mUserId + ", " + packageName);
            ShortcutService.this.cleanUpPackageForAllLoadedUsers(packageName, this.mUserId);
        }
    }

    static class CommandException
    extends Exception {
        public CommandException(String message) {
            super(message);
        }
    }

    private class LocalService
    extends ShortcutServiceInternal {
        private LocalService() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<ShortcutInfo> getShortcuts(int launcherUserId, String callingPackage, long changedSince, String packageName, List<String> shortcutIds, ComponentName componentName, int queryFlags, int userId) {
            int cloneFlag;
            ArrayList<ShortcutInfo> ret = new ArrayList<ShortcutInfo>();
            int n = cloneFlag = (queryFlags & 4) == 0 ? 3 : 4;
            if (packageName == null) {
                shortcutIds = null;
            }
            Object object = ShortcutService.this.mLock;
            synchronized (object) {
                ShortcutService.this.getLauncherShortcutsLocked(callingPackage, userId, launcherUserId).attemptToRestoreIfNeededAndSave(ShortcutService.this);
                if (packageName != null) {
                    this.getShortcutsInnerLocked(launcherUserId, callingPackage, packageName, shortcutIds, changedSince, componentName, queryFlags, userId, ret, cloneFlag);
                } else {
                    List<String> shortcutIdsF = shortcutIds;
                    ShortcutService.this.getUserShortcutsLocked(userId).forAllPackages(p -> this.getShortcutsInnerLocked(launcherUserId, callingPackage, p.getPackageName(), shortcutIdsF, changedSince, componentName, queryFlags, userId, ret, cloneFlag));
                }
            }
            return ret;
        }

        private void getShortcutsInnerLocked(int launcherUserId, String callingPackage, String packageName, List<String> shortcutIds, long changedSince, ComponentName componentName, int queryFlags, int userId, ArrayList<ShortcutInfo> ret, int cloneFlag) {
            ArraySet<String> ids = shortcutIds == null ? null : new ArraySet<String>(shortcutIds);
            ShortcutService.this.getPackageShortcutsLocked(packageName, userId).findAll(ShortcutService.this, ret, si -> {
                if (si.getLastChangedTimestamp() < changedSince) {
                    return false;
                }
                if (ids != null && !ids.contains(si.getId())) {
                    return false;
                }
                if (componentName != null && !componentName.equals(si.getActivityComponent())) {
                    return false;
                }
                boolean matchDynamic = (queryFlags & 1) != 0 && si.isDynamic();
                boolean matchPinned = (queryFlags & 2) != 0 && si.isPinned();
                return matchDynamic || matchPinned;
            }, cloneFlag, callingPackage, launcherUserId);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isPinnedByCaller(int launcherUserId, String callingPackage, String packageName, String shortcutId, int userId) {
            Preconditions.checkStringNotEmpty(packageName, "packageName");
            Preconditions.checkStringNotEmpty(shortcutId, "shortcutId");
            Object object = ShortcutService.this.mLock;
            synchronized (object) {
                ShortcutService.this.getLauncherShortcutsLocked(callingPackage, userId, launcherUserId).attemptToRestoreIfNeededAndSave(ShortcutService.this);
                ShortcutInfo si = this.getShortcutInfoLocked(launcherUserId, callingPackage, packageName, shortcutId, userId);
                return si != null && si.isPinned();
            }
        }

        private ShortcutInfo getShortcutInfoLocked(int launcherUserId, String callingPackage, String packageName, String shortcutId, int userId) {
            Preconditions.checkStringNotEmpty(packageName, "packageName");
            Preconditions.checkStringNotEmpty(shortcutId, "shortcutId");
            ArrayList<ShortcutInfo> list = new ArrayList<ShortcutInfo>(1);
            ShortcutService.this.getPackageShortcutsLocked(packageName, userId).findAll(ShortcutService.this, list, si -> shortcutId.equals(si.getId()), 0, callingPackage, launcherUserId);
            return list.size() == 0 ? null : list.get(0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void pinShortcuts(int launcherUserId, String callingPackage, String packageName, List<String> shortcutIds, int userId) {
            Preconditions.checkStringNotEmpty(packageName, "packageName");
            Preconditions.checkNotNull(shortcutIds, "shortcutIds");
            Object object = ShortcutService.this.mLock;
            synchronized (object) {
                ShortcutLauncher launcher = ShortcutService.this.getLauncherShortcutsLocked(callingPackage, userId, launcherUserId);
                launcher.attemptToRestoreIfNeededAndSave(ShortcutService.this);
                launcher.pinShortcuts(ShortcutService.this, userId, packageName, shortcutIds);
            }
            ShortcutService.this.packageShortcutsChanged(packageName, userId);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Intent createShortcutIntent(int launcherUserId, String callingPackage, String packageName, String shortcutId, int userId) {
            Preconditions.checkStringNotEmpty(packageName, "packageName can't be empty");
            Preconditions.checkStringNotEmpty(shortcutId, "shortcutId can't be empty");
            Object object = ShortcutService.this.mLock;
            synchronized (object) {
                ShortcutService.this.getLauncherShortcutsLocked(callingPackage, userId, launcherUserId).attemptToRestoreIfNeededAndSave(ShortcutService.this);
                ShortcutInfo si = this.getShortcutInfoLocked(launcherUserId, callingPackage, packageName, shortcutId, userId);
                if (si == null || !si.isDynamic() && !si.isPinned()) {
                    return null;
                }
                return si.getIntent();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addListener(ShortcutServiceInternal.ShortcutChangeListener listener) {
            Object object = ShortcutService.this.mLock;
            synchronized (object) {
                ShortcutService.this.mListeners.add(Preconditions.checkNotNull(listener));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getShortcutIconResId(int launcherUserId, String callingPackage, String packageName, String shortcutId, int userId) {
            Preconditions.checkNotNull(callingPackage, "callingPackage");
            Preconditions.checkNotNull(packageName, "packageName");
            Preconditions.checkNotNull(shortcutId, "shortcutId");
            Object object = ShortcutService.this.mLock;
            synchronized (object) {
                ShortcutService.this.getLauncherShortcutsLocked(callingPackage, userId, launcherUserId).attemptToRestoreIfNeededAndSave(ShortcutService.this);
                ShortcutInfo shortcutInfo = ShortcutService.this.getPackageShortcutsLocked(packageName, userId).findShortcutById(shortcutId);
                return shortcutInfo != null && shortcutInfo.hasIconResource() ? shortcutInfo.getIconResourceId() : 0;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ParcelFileDescriptor getShortcutIconFd(int launcherUserId, String callingPackage, String packageName, String shortcutId, int userId) {
            Preconditions.checkNotNull(callingPackage, "callingPackage");
            Preconditions.checkNotNull(packageName, "packageName");
            Preconditions.checkNotNull(shortcutId, "shortcutId");
            Object object = ShortcutService.this.mLock;
            synchronized (object) {
                ShortcutService.this.getLauncherShortcutsLocked(callingPackage, userId, launcherUserId).attemptToRestoreIfNeededAndSave(ShortcutService.this);
                ShortcutInfo shortcutInfo = ShortcutService.this.getPackageShortcutsLocked(packageName, userId).findShortcutById(shortcutId);
                if (shortcutInfo == null || !shortcutInfo.hasIconFile()) {
                    return null;
                }
                try {
                    if (shortcutInfo.getBitmapPath() == null) {
                        Slog.w(ShortcutService.TAG, "null bitmap detected in getShortcutIconFd()");
                        return null;
                    }
                    return ParcelFileDescriptor.open(new File(shortcutInfo.getBitmapPath()), 0x10000000);
                }
                catch (FileNotFoundException e) {
                    Slog.e(ShortcutService.TAG, "Icon file not found: " + shortcutInfo.getBitmapPath());
                    return null;
                }
            }
        }

        @Override
        public boolean hasShortcutHostPermission(int launcherUserId, String callingPackage) {
            return ShortcutService.this.hasShortcutHostPermission(callingPackage, launcherUserId);
        }

        @Override
        public void onSystemLocaleChangedNoLock() {
        }

        private /* synthetic */ void lambda$onSystemLocaleChangedNoLock$3() {
            ShortcutService.this.scheduleSaveBaseState();
        }
    }

    static class FileOutputStreamWithPath
    extends FileOutputStream {
        private final File mFile;

        public FileOutputStreamWithPath(File file) throws FileNotFoundException {
            super(file);
            this.mFile = file;
        }

        public File getFile() {
            return this.mFile;
        }
    }

    public static final class Lifecycle
    extends SystemService {
        final ShortcutService mService;

        public Lifecycle(Context context) {
            super(context);
            this.mService = new ShortcutService(context);
        }

        @Override
        public void onStart() {
            this.publishBinderService("shortcut", this.mService);
        }

        @Override
        public void onBootPhase(int phase) {
            this.mService.onBootPhase(phase);
        }

        @Override
        public void onCleanupUser(int userHandle) {
            this.mService.handleCleanupUser(userHandle);
        }

        @Override
        public void onUnlockUser(int userId) {
            this.mService.handleUnlockUser(userId);
        }
    }

    static interface Stats {
        public static final int GET_DEFAULT_HOME = 0;
        public static final int GET_PACKAGE_INFO = 1;
        public static final int GET_PACKAGE_INFO_WITH_SIG = 2;
        public static final int GET_APPLICATION_INFO = 3;
        public static final int LAUNCHER_PERMISSION_CHECK = 4;
        public static final int COUNT = 5;
    }

    static interface ConfigConstants {
        public static final String KEY_SAVE_DELAY_MILLIS = "save_delay_ms";
        public static final String KEY_RESET_INTERVAL_SEC = "reset_interval_sec";
        public static final String KEY_MAX_UPDATES_PER_INTERVAL = "max_updates_per_interval";
        public static final String KEY_MAX_ICON_DIMENSION_DP = "max_icon_dimension_dp";
        public static final String KEY_MAX_ICON_DIMENSION_DP_LOWRAM = "max_icon_dimension_dp_lowram";
        public static final String KEY_MAX_SHORTCUTS = "max_shortcuts";
        public static final String KEY_ICON_QUALITY = "icon_quality";
        public static final String KEY_ICON_FORMAT = "icon_format";
    }
}

