/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.pm;

import android.content.pm.PackageInfo;
import com.android.internal.util.Preconditions;
import com.android.server.pm.ShortcutPackageInfo;
import com.android.server.pm.ShortcutService;
import com.android.server.pm.ShortcutUser;
import java.io.IOException;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

abstract class ShortcutPackageItem {
    private static final String TAG = "ShortcutService";
    private final int mPackageUserId;
    private final String mPackageName;
    private final ShortcutPackageInfo mPackageInfo;
    protected final ShortcutUser mShortcutUser;

    protected ShortcutPackageItem(ShortcutUser shortcutUser, int packageUserId, String packageName, ShortcutPackageInfo packageInfo) {
        this.mShortcutUser = shortcutUser;
        this.mPackageUserId = packageUserId;
        this.mPackageName = Preconditions.checkStringNotEmpty(packageName);
        this.mPackageInfo = Preconditions.checkNotNull(packageInfo);
    }

    public int getPackageUserId() {
        return this.mPackageUserId;
    }

    public abstract int getOwnerUserId();

    public String getPackageName() {
        return this.mPackageName;
    }

    public ShortcutPackageInfo getPackageInfo() {
        return this.mPackageInfo;
    }

    public void refreshPackageInfoAndSave(ShortcutService s) {
        if (this.mPackageInfo.isShadow()) {
            return;
        }
        this.mPackageInfo.refresh(s, this);
        s.scheduleSaveUser(this.getOwnerUserId());
    }

    public void attemptToRestoreIfNeededAndSave(ShortcutService s) {
        if (!this.mPackageInfo.isShadow()) {
            return;
        }
        if (!s.isPackageInstalled(this.mPackageName, this.mPackageUserId)) {
            return;
        }
        if (!this.mPackageInfo.hasSignatures()) {
            s.wtf("Attempted to restore package " + this.mPackageName + ", user=" + this.mPackageUserId + " but signatures not found in the restore data.");
            this.onRestoreBlocked(s);
            return;
        }
        PackageInfo pi = s.getPackageInfoWithSignatures(this.mPackageName, this.mPackageUserId);
        if (!this.mPackageInfo.canRestoreTo(s, pi)) {
            this.onRestoreBlocked(s);
            return;
        }
        this.onRestored(s);
        this.mPackageInfo.setShadow(false);
        s.scheduleSaveUser(this.mPackageUserId);
    }

    protected abstract void onRestoreBlocked(ShortcutService var1);

    protected abstract void onRestored(ShortcutService var1);

    public abstract void saveToXml(XmlSerializer var1, boolean var2) throws IOException, XmlPullParserException;
}

