/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.pm;

import android.util.SparseArray;

public class ProtectedPackages {
    private int mDeviceOwnerUserId;
    private String mDeviceOwnerPackage;
    private SparseArray<String> mProfileOwnerPackages;
    private final Object mLock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDeviceAndProfileOwnerPackages(int deviceOwnerUserId, String deviceOwnerPackage, SparseArray<String> profileOwnerPackages) {
        Object object = this.mLock;
        synchronized (object) {
            this.mDeviceOwnerUserId = deviceOwnerUserId;
            this.mDeviceOwnerPackage = deviceOwnerUserId == -10000 ? null : deviceOwnerPackage;
            this.mProfileOwnerPackages = profileOwnerPackages == null ? null : profileOwnerPackages.clone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasDeviceOwnerOrProfileOwner(int userId, String packageName) {
        if (packageName == null) {
            return false;
        }
        Object object = this.mLock;
        synchronized (object) {
            if (this.mDeviceOwnerPackage != null && this.mDeviceOwnerUserId == userId && packageName.equals(this.mDeviceOwnerPackage)) {
                return true;
            }
            if (this.mProfileOwnerPackages != null && packageName.equals(this.mProfileOwnerPackages.get(userId))) {
                return true;
            }
        }
        return false;
    }

    public boolean canPackageStateBeChanged(int userId, String packageName) {
        return this.hasDeviceOwnerOrProfileOwner(userId, packageName);
    }

    public boolean canPackageBeWiped(int userId, String packageName) {
        return this.hasDeviceOwnerOrProfileOwner(userId, packageName);
    }
}

