/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.pm;

import android.content.Context;
import android.content.pm.PackageStats;
import android.os.Build;
import android.util.Slog;
import com.android.internal.os.InstallerConnection;
import com.android.server.SystemService;
import dalvik.system.VMRuntime;
import java.util.Arrays;

public final class Installer
extends SystemService {
    private static final String TAG = "Installer";
    public static final int DEXOPT_PUBLIC = 2;
    public static final int DEXOPT_SAFEMODE = 4;
    public static final int DEXOPT_DEBUGGABLE = 8;
    public static final int DEXOPT_BOOTCOMPLETE = 16;
    public static final int DEXOPT_PROFILE_GUIDED = 32;
    public static final int DEXOPT_OTA = 64;
    public static final int FLAG_CLEAR_CACHE_ONLY = 256;
    public static final int FLAG_CLEAR_CODE_CACHE_ONLY = 512;
    private final InstallerConnection mInstaller = new InstallerConnection();

    public Installer(Context context) {
        super(context);
    }

    public void setWarnIfHeld(Object warnIfHeld) {
        this.mInstaller.setWarnIfHeld(warnIfHeld);
    }

    @Override
    public void onStart() {
        Slog.i(TAG, "Waiting for installd to be ready.");
        this.mInstaller.waitForConnection();
    }

    public void createAppData(String uuid, String pkgname, int userid, int flags, int appid, String seinfo, int targetSdkVersion) throws InstallerConnection.InstallerException {
        this.mInstaller.execute("create_app_data", uuid, pkgname, userid, flags, appid, seinfo, targetSdkVersion);
    }

    public void restoreconAppData(String uuid, String pkgname, int userid, int flags, int appid, String seinfo) throws InstallerConnection.InstallerException {
        this.mInstaller.execute("restorecon_app_data", uuid, pkgname, userid, flags, appid, seinfo);
    }

    public void migrateAppData(String uuid, String pkgname, int userid, int flags) throws InstallerConnection.InstallerException {
        this.mInstaller.execute("migrate_app_data", uuid, pkgname, userid, flags);
    }

    public void clearAppData(String uuid, String pkgname, int userid, int flags, long ceDataInode) throws InstallerConnection.InstallerException {
        this.mInstaller.execute("clear_app_data", uuid, pkgname, userid, flags, ceDataInode);
    }

    public void destroyAppData(String uuid, String pkgname, int userid, int flags, long ceDataInode) throws InstallerConnection.InstallerException {
        this.mInstaller.execute("destroy_app_data", uuid, pkgname, userid, flags, ceDataInode);
    }

    public void moveCompleteApp(String from_uuid, String to_uuid, String package_name, String data_app_name, int appid, String seinfo, int targetSdkVersion) throws InstallerConnection.InstallerException {
        this.mInstaller.execute("move_complete_app", from_uuid, to_uuid, package_name, data_app_name, appid, seinfo, targetSdkVersion);
    }

    public void getAppSize(String uuid, String pkgname, int userid, int flags, long ceDataInode, String codePath, PackageStats stats) throws InstallerConnection.InstallerException {
        Object[] res = this.mInstaller.execute("get_app_size", uuid, pkgname, userid, flags, ceDataInode, codePath);
        try {
            stats.codeSize += Long.parseLong(res[1]);
            stats.dataSize += Long.parseLong((String)res[2]);
            stats.cacheSize += Long.parseLong((String)res[3]);
        }
        catch (ArrayIndexOutOfBoundsException | NumberFormatException e) {
            throw new InstallerConnection.InstallerException("Invalid size result: " + Arrays.toString(res));
        }
    }

    public long getAppDataInode(String uuid, String pkgname, int userid, int flags) throws InstallerConnection.InstallerException {
        Object[] res = this.mInstaller.execute("get_app_data_inode", uuid, pkgname, userid, flags);
        try {
            return Long.parseLong(res[1]);
        }
        catch (ArrayIndexOutOfBoundsException | NumberFormatException e) {
            throw new InstallerConnection.InstallerException("Invalid inode result: " + Arrays.toString(res));
        }
    }

    public void dexopt(String apkPath, int uid, String instructionSet, int dexoptNeeded, int dexFlags, String compilerFilter, String volumeUuid, String sharedLibraries) throws InstallerConnection.InstallerException {
        Installer.assertValidInstructionSet(instructionSet);
        this.mInstaller.dexopt(apkPath, uid, instructionSet, dexoptNeeded, dexFlags, compilerFilter, volumeUuid, sharedLibraries);
    }

    public void dexopt(String apkPath, int uid, String pkgName, String instructionSet, int dexoptNeeded, String outputPath, int dexFlags, String compilerFilter, String volumeUuid, String sharedLibraries) throws InstallerConnection.InstallerException {
        Installer.assertValidInstructionSet(instructionSet);
        this.mInstaller.dexopt(apkPath, uid, pkgName, instructionSet, dexoptNeeded, outputPath, dexFlags, compilerFilter, volumeUuid, sharedLibraries);
    }

    public boolean mergeProfiles(int uid, String pkgName) throws InstallerConnection.InstallerException {
        return this.mInstaller.mergeProfiles(uid, pkgName);
    }

    public boolean dumpProfiles(String gid, String packageName, String codePaths) throws InstallerConnection.InstallerException {
        return this.mInstaller.dumpProfiles(gid, packageName, codePaths);
    }

    public void idmap(String targetApkPath, String overlayApkPath, int uid) throws InstallerConnection.InstallerException {
        this.mInstaller.execute("idmap", targetApkPath, overlayApkPath, uid);
    }

    public void rmdex(String codePath, String instructionSet) throws InstallerConnection.InstallerException {
        Installer.assertValidInstructionSet(instructionSet);
        this.mInstaller.execute("rmdex", codePath, instructionSet);
    }

    public void rmPackageDir(String packageDir) throws InstallerConnection.InstallerException {
        this.mInstaller.execute("rmpackagedir", packageDir);
    }

    public void clearAppProfiles(String pkgName) throws InstallerConnection.InstallerException {
        this.mInstaller.execute("clear_app_profiles", pkgName);
    }

    public void destroyAppProfiles(String pkgName) throws InstallerConnection.InstallerException {
        this.mInstaller.execute("destroy_app_profiles", pkgName);
    }

    public void createUserData(String uuid, int userId, int userSerial, int flags) throws InstallerConnection.InstallerException {
        this.mInstaller.execute("create_user_data", uuid, userId, userSerial, flags);
    }

    public void destroyUserData(String uuid, int userId, int flags) throws InstallerConnection.InstallerException {
        this.mInstaller.execute("destroy_user_data", uuid, userId, flags);
    }

    public void markBootComplete(String instructionSet) throws InstallerConnection.InstallerException {
        Installer.assertValidInstructionSet(instructionSet);
        this.mInstaller.execute("markbootcomplete", instructionSet);
    }

    public void freeCache(String uuid, long freeStorageSize) throws InstallerConnection.InstallerException {
        this.mInstaller.execute("freecache", uuid, freeStorageSize);
    }

    public void linkNativeLibraryDirectory(String uuid, String dataPath, String nativeLibPath32, int userId) throws InstallerConnection.InstallerException {
        this.mInstaller.execute("linklib", uuid, dataPath, nativeLibPath32, userId);
    }

    public void createOatDir(String oatDir, String dexInstructionSet) throws InstallerConnection.InstallerException {
        this.mInstaller.execute("createoatdir", oatDir, dexInstructionSet);
    }

    public void linkFile(String relativePath, String fromBase, String toBase) throws InstallerConnection.InstallerException {
        this.mInstaller.execute("linkfile", relativePath, fromBase, toBase);
    }

    public void moveAb(String apkPath, String instructionSet, String outputPath) throws InstallerConnection.InstallerException {
        this.mInstaller.execute("move_ab", apkPath, instructionSet, outputPath);
    }

    private static void assertValidInstructionSet(String instructionSet) throws InstallerConnection.InstallerException {
        for (String abi : Build.SUPPORTED_ABIS) {
            if (!VMRuntime.getInstructionSet(abi).equals(instructionSet)) continue;
            return;
        }
        throw new InstallerConnection.InstallerException("Invalid instruction set: " + instructionSet);
    }
}

