/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.pm;

import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManagerInternal;
import android.content.pm.PackageParser;
import android.content.pm.ProviderInfo;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.os.UserHandle;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.Log;
import com.android.server.pm.BasePermission;
import com.android.server.pm.PackageManagerService;
import com.android.server.pm.PackageSetting;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

final class DefaultPermissionGrantPolicy {
    private static final String TAG = "DefaultPermGrantPolicy";
    private static final boolean DEBUG = false;
    private static final int DEFAULT_FLAGS = 786432;
    private static final String AUDIO_MIME_TYPE = "audio/mpeg";
    private static final Set<String> PHONE_PERMISSIONS = new ArraySet<String>();
    private static final Set<String> CONTACTS_PERMISSIONS;
    private static final Set<String> LOCATION_PERMISSIONS;
    private static final Set<String> CALENDAR_PERMISSIONS;
    private static final Set<String> SMS_PERMISSIONS;
    private static final Set<String> MICROPHONE_PERMISSIONS;
    private static final Set<String> CAMERA_PERMISSIONS;
    private static final Set<String> SENSORS_PERMISSIONS;
    private static final Set<String> STORAGE_PERMISSIONS;
    private final PackageManagerService mService;
    private PackageManagerInternal.PackagesProvider mLocationPackagesProvider;
    private PackageManagerInternal.PackagesProvider mVoiceInteractionPackagesProvider;
    private PackageManagerInternal.PackagesProvider mSmsAppPackagesProvider;
    private PackageManagerInternal.PackagesProvider mDialerAppPackagesProvider;
    private PackageManagerInternal.PackagesProvider mSimCallManagerPackagesProvider;
    private PackageManagerInternal.SyncAdapterPackagesProvider mSyncAdapterPackagesProvider;

    public DefaultPermissionGrantPolicy(PackageManagerService service) {
        this.mService = service;
    }

    public void setLocationPackagesProviderLPw(PackageManagerInternal.PackagesProvider provider) {
        this.mLocationPackagesProvider = provider;
    }

    public void setVoiceInteractionPackagesProviderLPw(PackageManagerInternal.PackagesProvider provider) {
        this.mVoiceInteractionPackagesProvider = provider;
    }

    public void setSmsAppPackagesProviderLPw(PackageManagerInternal.PackagesProvider provider) {
        this.mSmsAppPackagesProvider = provider;
    }

    public void setDialerAppPackagesProviderLPw(PackageManagerInternal.PackagesProvider provider) {
        this.mDialerAppPackagesProvider = provider;
    }

    public void setSimCallManagerPackagesProviderLPw(PackageManagerInternal.PackagesProvider provider) {
        this.mSimCallManagerPackagesProvider = provider;
    }

    public void setSyncAdapterPackagesProviderLPw(PackageManagerInternal.SyncAdapterPackagesProvider provider) {
        this.mSyncAdapterPackagesProvider = provider;
    }

    public void grantDefaultPermissions(int userId) {
        this.grantPermissionsToSysComponentsAndPrivApps(userId);
        this.grantDefaultSystemHandlerPermissions(userId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void grantPermissionsToSysComponentsAndPrivApps(int userId) {
        Log.i(TAG, "Granting permissions to platform components for user " + userId);
        ArrayMap<String, PackageParser.Package> arrayMap = this.mService.mPackages;
        synchronized (arrayMap) {
            for (PackageParser.Package pkg : this.mService.mPackages.values()) {
                if (!this.isSysComponentOrPersistentPlatformSignedPrivAppLPr(pkg) || !DefaultPermissionGrantPolicy.doesPackageSupportRuntimePermissions(pkg) || pkg.requestedPermissions.isEmpty()) continue;
                ArraySet<String> permissions = new ArraySet<String>();
                int permissionCount = pkg.requestedPermissions.size();
                for (int i = 0; i < permissionCount; ++i) {
                    String permission2 = pkg.requestedPermissions.get(i);
                    BasePermission bp = this.mService.mSettings.mPermissions.get(permission2);
                    if (bp == null || !bp.isRuntime()) continue;
                    permissions.add(permission2);
                }
                if (permissions.isEmpty()) continue;
                this.grantRuntimePermissionsLPw(pkg, permissions, true, userId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void grantDefaultSystemHandlerPermissions(int userId) {
        PackageManagerInternal.SyncAdapterPackagesProvider syncAdapterPackagesProvider;
        PackageManagerInternal.PackagesProvider simCallManagerPackagesProvider;
        PackageManagerInternal.PackagesProvider dialerAppPackagesProvider;
        PackageManagerInternal.PackagesProvider smsAppPackagesProvider;
        PackageManagerInternal.PackagesProvider voiceInteractionPackagesProvider;
        PackageManagerInternal.PackagesProvider locationPackagesProvider;
        Log.i(TAG, "Granting permissions to default platform handlers for user " + userId);
        ArrayMap<String, PackageParser.Package> arrayMap = this.mService.mPackages;
        synchronized (arrayMap) {
            locationPackagesProvider = this.mLocationPackagesProvider;
            voiceInteractionPackagesProvider = this.mVoiceInteractionPackagesProvider;
            smsAppPackagesProvider = this.mSmsAppPackagesProvider;
            dialerAppPackagesProvider = this.mDialerAppPackagesProvider;
            simCallManagerPackagesProvider = this.mSimCallManagerPackagesProvider;
            syncAdapterPackagesProvider = this.mSyncAdapterPackagesProvider;
        }
        String[] voiceInteractPackageNames = voiceInteractionPackagesProvider != null ? voiceInteractionPackagesProvider.getPackages(userId) : null;
        String[] locationPackageNames = locationPackagesProvider != null ? locationPackagesProvider.getPackages(userId) : null;
        String[] smsAppPackageNames = smsAppPackagesProvider != null ? smsAppPackagesProvider.getPackages(userId) : null;
        String[] dialerAppPackageNames = dialerAppPackagesProvider != null ? dialerAppPackagesProvider.getPackages(userId) : null;
        String[] simCallManagerPackageNames = simCallManagerPackagesProvider != null ? simCallManagerPackagesProvider.getPackages(userId) : null;
        String[] contactsSyncAdapterPackages = syncAdapterPackagesProvider != null ? syncAdapterPackagesProvider.getPackages("com.android.contacts", userId) : null;
        String[] calendarSyncAdapterPackages = syncAdapterPackagesProvider != null ? syncAdapterPackagesProvider.getPackages("com.android.calendar", userId) : null;
        ArrayMap<String, PackageParser.Package> arrayMap2 = this.mService.mPackages;
        synchronized (arrayMap2) {
            Intent emergencyInfoIntent;
            PackageParser.Package emergencyInfoPckg;
            PackageParser.Package printSpoolerPackage;
            Intent deviceProvisionIntent;
            PackageParser.Package deviceProvisionPackage;
            PackageParser.Package calendarProviderPackage;
            Intent carrierProvIntent;
            PackageParser.Package carrierProvPackage;
            int n;
            Object dialerIntent;
            Intent certInstallerIntent;
            PackageParser.Package certInstallerPackage;
            PackageParser.Package storagePackage;
            Intent downloadsUiIntent;
            PackageParser.Package downloadsUiPackage;
            PackageParser.Package downloadsPackage;
            PackageParser.Package mediaStorePackage;
            Intent cameraIntent;
            PackageParser.Package cameraPackage;
            PackageParser.Package setupPackage;
            PackageParser.Package verifierPackage;
            PackageParser.Package installerPackage = this.getSystemPackageLPr(this.mService.mRequiredInstallerPackage);
            if (installerPackage != null && DefaultPermissionGrantPolicy.doesPackageSupportRuntimePermissions(installerPackage)) {
                this.grantRuntimePermissionsLPw(installerPackage, STORAGE_PERMISSIONS, true, userId);
            }
            if ((verifierPackage = this.getSystemPackageLPr(this.mService.mRequiredVerifierPackage)) != null && DefaultPermissionGrantPolicy.doesPackageSupportRuntimePermissions(verifierPackage)) {
                this.grantRuntimePermissionsLPw(verifierPackage, STORAGE_PERMISSIONS, true, userId);
                this.grantRuntimePermissionsLPw(verifierPackage, PHONE_PERMISSIONS, false, userId);
                this.grantRuntimePermissionsLPw(verifierPackage, SMS_PERMISSIONS, false, userId);
            }
            if ((setupPackage = this.getSystemPackageLPr(this.mService.mSetupWizardPackage)) != null && DefaultPermissionGrantPolicy.doesPackageSupportRuntimePermissions(setupPackage)) {
                this.grantRuntimePermissionsLPw(setupPackage, PHONE_PERMISSIONS, userId);
                this.grantRuntimePermissionsLPw(setupPackage, CONTACTS_PERMISSIONS, userId);
                this.grantRuntimePermissionsLPw(setupPackage, LOCATION_PERMISSIONS, userId);
                this.grantRuntimePermissionsLPw(setupPackage, CAMERA_PERMISSIONS, userId);
            }
            if ((cameraPackage = this.getDefaultSystemHandlerActivityPackageLPr(cameraIntent = new Intent("android.media.action.IMAGE_CAPTURE"), userId)) != null && DefaultPermissionGrantPolicy.doesPackageSupportRuntimePermissions(cameraPackage)) {
                this.grantRuntimePermissionsLPw(cameraPackage, CAMERA_PERMISSIONS, userId);
                this.grantRuntimePermissionsLPw(cameraPackage, MICROPHONE_PERMISSIONS, userId);
                this.grantRuntimePermissionsLPw(cameraPackage, STORAGE_PERMISSIONS, userId);
            }
            if ((mediaStorePackage = this.getDefaultProviderAuthorityPackageLPr("media", userId)) != null) {
                this.grantRuntimePermissionsLPw(mediaStorePackage, STORAGE_PERMISSIONS, true, userId);
            }
            if ((downloadsPackage = this.getDefaultProviderAuthorityPackageLPr("downloads", userId)) != null) {
                this.grantRuntimePermissionsLPw(downloadsPackage, STORAGE_PERMISSIONS, true, userId);
            }
            if ((downloadsUiPackage = this.getDefaultSystemHandlerActivityPackageLPr(downloadsUiIntent = new Intent("android.intent.action.VIEW_DOWNLOADS"), userId)) != null && DefaultPermissionGrantPolicy.doesPackageSupportRuntimePermissions(downloadsUiPackage)) {
                this.grantRuntimePermissionsLPw(downloadsUiPackage, STORAGE_PERMISSIONS, true, userId);
            }
            if ((storagePackage = this.getDefaultProviderAuthorityPackageLPr("com.android.externalstorage.documents", userId)) != null) {
                this.grantRuntimePermissionsLPw(storagePackage, STORAGE_PERMISSIONS, true, userId);
            }
            if ((certInstallerPackage = this.getDefaultSystemHandlerActivityPackageLPr(certInstallerIntent = new Intent("android.credentials.INSTALL"), userId)) != null && DefaultPermissionGrantPolicy.doesPackageSupportRuntimePermissions(certInstallerPackage)) {
                this.grantRuntimePermissionsLPw(certInstallerPackage, STORAGE_PERMISSIONS, true, userId);
            }
            if (dialerAppPackageNames == null) {
                dialerIntent = new Intent("android.intent.action.DIAL");
                PackageParser.Package dialerPackage = this.getDefaultSystemHandlerActivityPackageLPr((Intent)dialerIntent, userId);
                if (dialerPackage != null) {
                    this.grantDefaultPermissionsToDefaultSystemDialerAppLPr(dialerPackage, userId);
                }
            } else {
                dialerIntent = dialerAppPackageNames;
                int dialerPackage = ((String[])dialerIntent).length;
                for (n = 0; n < dialerPackage; ++n) {
                    String dialerAppPackageName = dialerIntent[n];
                    PackageParser.Package dialerPackage2 = this.getSystemPackageLPr(dialerAppPackageName);
                    if (dialerPackage2 == null) continue;
                    this.grantDefaultPermissionsToDefaultSystemDialerAppLPr(dialerPackage2, userId);
                }
            }
            if (simCallManagerPackageNames != null) {
                dialerIntent = simCallManagerPackageNames;
                int dialerPackage = ((String[])dialerIntent).length;
                for (n = 0; n < dialerPackage; ++n) {
                    String simCallManagerPackageName = dialerIntent[n];
                    PackageParser.Package simCallManagerPackage = this.getSystemPackageLPr(simCallManagerPackageName);
                    if (simCallManagerPackage == null) continue;
                    this.grantDefaultPermissionsToDefaultSimCallManagerLPr(simCallManagerPackage, userId);
                }
            }
            if (smsAppPackageNames == null) {
                Intent smsIntent = new Intent("android.intent.action.MAIN");
                smsIntent.addCategory("android.intent.category.APP_MESSAGING");
                PackageParser.Package smsPackage = this.getDefaultSystemHandlerActivityPackageLPr(smsIntent, userId);
                if (smsPackage != null) {
                    this.grantDefaultPermissionsToDefaultSystemSmsAppLPr(smsPackage, userId);
                }
            } else {
                for (String smsPackageName : smsAppPackageNames) {
                    PackageParser.Package smsPackage = this.getSystemPackageLPr(smsPackageName);
                    if (smsPackage == null) continue;
                    this.grantDefaultPermissionsToDefaultSystemSmsAppLPr(smsPackage, userId);
                }
            }
            Intent cbrIntent = new Intent("android.provider.Telephony.SMS_CB_RECEIVED");
            PackageParser.Package cbrPackage = this.getDefaultSystemHandlerActivityPackageLPr(cbrIntent, userId);
            if (cbrPackage != null && DefaultPermissionGrantPolicy.doesPackageSupportRuntimePermissions(cbrPackage)) {
                this.grantRuntimePermissionsLPw(cbrPackage, SMS_PERMISSIONS, userId);
            }
            if ((carrierProvPackage = this.getDefaultSystemHandlerServicePackageLPr(carrierProvIntent = new Intent("android.provider.Telephony.SMS_CARRIER_PROVISION"), userId)) != null && DefaultPermissionGrantPolicy.doesPackageSupportRuntimePermissions(carrierProvPackage)) {
                this.grantRuntimePermissionsLPw(carrierProvPackage, SMS_PERMISSIONS, false, userId);
            }
            Intent calendarIntent = new Intent("android.intent.action.MAIN");
            calendarIntent.addCategory("android.intent.category.APP_CALENDAR");
            PackageParser.Package calendarPackage = this.getDefaultSystemHandlerActivityPackageLPr(calendarIntent, userId);
            if (calendarPackage != null && DefaultPermissionGrantPolicy.doesPackageSupportRuntimePermissions(calendarPackage)) {
                this.grantRuntimePermissionsLPw(calendarPackage, CALENDAR_PERMISSIONS, userId);
                this.grantRuntimePermissionsLPw(calendarPackage, CONTACTS_PERMISSIONS, userId);
            }
            if ((calendarProviderPackage = this.getDefaultProviderAuthorityPackageLPr("com.android.calendar", userId)) != null) {
                this.grantRuntimePermissionsLPw(calendarProviderPackage, CONTACTS_PERMISSIONS, userId);
                this.grantRuntimePermissionsLPw(calendarProviderPackage, CALENDAR_PERMISSIONS, true, userId);
                this.grantRuntimePermissionsLPw(calendarProviderPackage, STORAGE_PERMISSIONS, userId);
            }
            List<PackageParser.Package> calendarSyncAdapters = this.getHeadlessSyncAdapterPackagesLPr(calendarSyncAdapterPackages, userId);
            int calendarSyncAdapterCount = calendarSyncAdapters.size();
            for (int i = 0; i < calendarSyncAdapterCount; ++i) {
                PackageParser.Package calendarSyncAdapter = calendarSyncAdapters.get(i);
                if (!DefaultPermissionGrantPolicy.doesPackageSupportRuntimePermissions(calendarSyncAdapter)) continue;
                this.grantRuntimePermissionsLPw(calendarSyncAdapter, CALENDAR_PERMISSIONS, userId);
            }
            Intent contactsIntent = new Intent("android.intent.action.MAIN");
            contactsIntent.addCategory("android.intent.category.APP_CONTACTS");
            PackageParser.Package contactsPackage = this.getDefaultSystemHandlerActivityPackageLPr(contactsIntent, userId);
            if (contactsPackage != null && DefaultPermissionGrantPolicy.doesPackageSupportRuntimePermissions(contactsPackage)) {
                this.grantRuntimePermissionsLPw(contactsPackage, CONTACTS_PERMISSIONS, userId);
                this.grantRuntimePermissionsLPw(contactsPackage, PHONE_PERMISSIONS, userId);
            }
            List<PackageParser.Package> contactsSyncAdapters = this.getHeadlessSyncAdapterPackagesLPr(contactsSyncAdapterPackages, userId);
            int contactsSyncAdapterCount = contactsSyncAdapters.size();
            for (int i = 0; i < contactsSyncAdapterCount; ++i) {
                PackageParser.Package contactsSyncAdapter = contactsSyncAdapters.get(i);
                if (!DefaultPermissionGrantPolicy.doesPackageSupportRuntimePermissions(contactsSyncAdapter)) continue;
                this.grantRuntimePermissionsLPw(contactsSyncAdapter, CONTACTS_PERMISSIONS, userId);
            }
            PackageParser.Package contactsProviderPackage = this.getDefaultProviderAuthorityPackageLPr("com.android.contacts", userId);
            if (contactsProviderPackage != null) {
                this.grantRuntimePermissionsLPw(contactsProviderPackage, CONTACTS_PERMISSIONS, true, userId);
                this.grantRuntimePermissionsLPw(contactsProviderPackage, PHONE_PERMISSIONS, true, userId);
                this.grantRuntimePermissionsLPw(contactsProviderPackage, STORAGE_PERMISSIONS, userId);
            }
            if ((deviceProvisionPackage = this.getDefaultSystemHandlerActivityPackageLPr(deviceProvisionIntent = new Intent("android.app.action.PROVISION_MANAGED_DEVICE"), userId)) != null && DefaultPermissionGrantPolicy.doesPackageSupportRuntimePermissions(deviceProvisionPackage)) {
                this.grantRuntimePermissionsLPw(deviceProvisionPackage, CONTACTS_PERMISSIONS, userId);
            }
            Intent mapsIntent = new Intent("android.intent.action.MAIN");
            mapsIntent.addCategory("android.intent.category.APP_MAPS");
            PackageParser.Package mapsPackage = this.getDefaultSystemHandlerActivityPackageLPr(mapsIntent, userId);
            if (mapsPackage != null && DefaultPermissionGrantPolicy.doesPackageSupportRuntimePermissions(mapsPackage)) {
                this.grantRuntimePermissionsLPw(mapsPackage, LOCATION_PERMISSIONS, userId);
            }
            Intent galleryIntent = new Intent("android.intent.action.MAIN");
            galleryIntent.addCategory("android.intent.category.APP_GALLERY");
            PackageParser.Package galleryPackage = this.getDefaultSystemHandlerActivityPackageLPr(galleryIntent, userId);
            if (galleryPackage != null && DefaultPermissionGrantPolicy.doesPackageSupportRuntimePermissions(galleryPackage)) {
                this.grantRuntimePermissionsLPw(galleryPackage, STORAGE_PERMISSIONS, userId);
            }
            Intent emailIntent = new Intent("android.intent.action.MAIN");
            emailIntent.addCategory("android.intent.category.APP_EMAIL");
            PackageParser.Package emailPackage = this.getDefaultSystemHandlerActivityPackageLPr(emailIntent, userId);
            if (emailPackage != null && DefaultPermissionGrantPolicy.doesPackageSupportRuntimePermissions(emailPackage)) {
                this.grantRuntimePermissionsLPw(emailPackage, CONTACTS_PERMISSIONS, userId);
            }
            PackageParser.Package browserPackage = null;
            String defaultBrowserPackage = this.mService.getDefaultBrowserPackageName(userId);
            if (defaultBrowserPackage != null) {
                browserPackage = this.getPackageLPr(defaultBrowserPackage);
            }
            if (browserPackage == null) {
                String[] browserIntent = new Intent("android.intent.action.MAIN");
                browserIntent.addCategory("android.intent.category.APP_BROWSER");
                browserPackage = this.getDefaultSystemHandlerActivityPackageLPr((Intent)browserIntent, userId);
            }
            if (browserPackage != null && DefaultPermissionGrantPolicy.doesPackageSupportRuntimePermissions(browserPackage)) {
                this.grantRuntimePermissionsLPw(browserPackage, LOCATION_PERMISSIONS, userId);
            }
            if (voiceInteractPackageNames != null) {
                for (String voiceInteractPackageName : voiceInteractPackageNames) {
                    PackageParser.Package voiceInteractPackage = this.getSystemPackageLPr(voiceInteractPackageName);
                    if (voiceInteractPackage == null || !DefaultPermissionGrantPolicy.doesPackageSupportRuntimePermissions(voiceInteractPackage)) continue;
                    this.grantRuntimePermissionsLPw(voiceInteractPackage, CONTACTS_PERMISSIONS, userId);
                    this.grantRuntimePermissionsLPw(voiceInteractPackage, CALENDAR_PERMISSIONS, userId);
                    this.grantRuntimePermissionsLPw(voiceInteractPackage, MICROPHONE_PERMISSIONS, userId);
                    this.grantRuntimePermissionsLPw(voiceInteractPackage, PHONE_PERMISSIONS, userId);
                    this.grantRuntimePermissionsLPw(voiceInteractPackage, SMS_PERMISSIONS, userId);
                    this.grantRuntimePermissionsLPw(voiceInteractPackage, LOCATION_PERMISSIONS, userId);
                }
            }
            Intent voiceRecoIntent = new Intent("android.speech.RecognitionService");
            voiceRecoIntent.addCategory("android.intent.category.DEFAULT");
            PackageParser.Package voiceRecoPackage = this.getDefaultSystemHandlerServicePackageLPr(voiceRecoIntent, userId);
            if (voiceRecoPackage != null && DefaultPermissionGrantPolicy.doesPackageSupportRuntimePermissions(voiceRecoPackage)) {
                this.grantRuntimePermissionsLPw(voiceRecoPackage, MICROPHONE_PERMISSIONS, userId);
            }
            if (locationPackageNames != null) {
                for (String packageName : locationPackageNames) {
                    PackageParser.Package locationPackage = this.getSystemPackageLPr(packageName);
                    if (locationPackage == null || !DefaultPermissionGrantPolicy.doesPackageSupportRuntimePermissions(locationPackage)) continue;
                    this.grantRuntimePermissionsLPw(locationPackage, CONTACTS_PERMISSIONS, userId);
                    this.grantRuntimePermissionsLPw(locationPackage, CALENDAR_PERMISSIONS, userId);
                    this.grantRuntimePermissionsLPw(locationPackage, MICROPHONE_PERMISSIONS, userId);
                    this.grantRuntimePermissionsLPw(locationPackage, PHONE_PERMISSIONS, userId);
                    this.grantRuntimePermissionsLPw(locationPackage, SMS_PERMISSIONS, userId);
                    this.grantRuntimePermissionsLPw(locationPackage, LOCATION_PERMISSIONS, true, userId);
                    this.grantRuntimePermissionsLPw(locationPackage, CAMERA_PERMISSIONS, userId);
                    this.grantRuntimePermissionsLPw(locationPackage, SENSORS_PERMISSIONS, userId);
                    this.grantRuntimePermissionsLPw(locationPackage, STORAGE_PERMISSIONS, userId);
                }
            }
            Intent musicIntent = new Intent("android.intent.action.VIEW");
            musicIntent.addCategory("android.intent.category.DEFAULT");
            musicIntent.setDataAndType(Uri.fromFile(new File("foo.mp3")), AUDIO_MIME_TYPE);
            PackageParser.Package musicPackage = this.getDefaultSystemHandlerActivityPackageLPr(musicIntent, userId);
            if (musicPackage != null && DefaultPermissionGrantPolicy.doesPackageSupportRuntimePermissions(musicPackage)) {
                this.grantRuntimePermissionsLPw(musicPackage, STORAGE_PERMISSIONS, userId);
            }
            if (this.mService.hasSystemFeature("android.hardware.type.watch", 0)) {
                Intent homeIntent = new Intent("android.intent.action.MAIN");
                homeIntent.addCategory("android.intent.category.HOME_MAIN");
                PackageParser.Package wearHomePackage = this.getDefaultSystemHandlerActivityPackageLPr(homeIntent, userId);
                if (wearHomePackage != null && DefaultPermissionGrantPolicy.doesPackageSupportRuntimePermissions(wearHomePackage)) {
                    this.grantRuntimePermissionsLPw(wearHomePackage, CONTACTS_PERMISSIONS, false, userId);
                    this.grantRuntimePermissionsLPw(wearHomePackage, PHONE_PERMISSIONS, true, userId);
                    this.grantRuntimePermissionsLPw(wearHomePackage, MICROPHONE_PERMISSIONS, false, userId);
                    this.grantRuntimePermissionsLPw(wearHomePackage, LOCATION_PERMISSIONS, false, userId);
                }
            }
            if ((printSpoolerPackage = this.getSystemPackageLPr("com.android.printspooler")) != null && DefaultPermissionGrantPolicy.doesPackageSupportRuntimePermissions(printSpoolerPackage)) {
                this.grantRuntimePermissionsLPw(printSpoolerPackage, LOCATION_PERMISSIONS, true, userId);
            }
            if ((emergencyInfoPckg = this.getDefaultSystemHandlerActivityPackageLPr(emergencyInfoIntent = new Intent("android.telephony.action.EMERGENCY_ASSISTANCE"), userId)) != null && DefaultPermissionGrantPolicy.doesPackageSupportRuntimePermissions(emergencyInfoPckg)) {
                this.grantRuntimePermissionsLPw(emergencyInfoPckg, CONTACTS_PERMISSIONS, true, userId);
                this.grantRuntimePermissionsLPw(emergencyInfoPckg, PHONE_PERMISSIONS, true, userId);
            }
            Intent nfcTagIntent = new Intent("android.intent.action.VIEW");
            nfcTagIntent.setType("vnd.android.cursor.item/ndef_msg");
            PackageParser.Package nfcTagPkg = this.getDefaultSystemHandlerActivityPackageLPr(nfcTagIntent, userId);
            if (nfcTagPkg != null && DefaultPermissionGrantPolicy.doesPackageSupportRuntimePermissions(nfcTagPkg)) {
                this.grantRuntimePermissionsLPw(nfcTagPkg, CONTACTS_PERMISSIONS, false, userId);
                this.grantRuntimePermissionsLPw(nfcTagPkg, PHONE_PERMISSIONS, false, userId);
            }
            this.mService.mSettings.onDefaultRuntimePermissionsGrantedLPr(userId);
        }
    }

    private void grantDefaultPermissionsToDefaultSystemDialerAppLPr(PackageParser.Package dialerPackage, int userId) {
        if (DefaultPermissionGrantPolicy.doesPackageSupportRuntimePermissions(dialerPackage)) {
            boolean isPhonePermFixed = this.mService.hasSystemFeature("android.hardware.type.watch", 0);
            this.grantRuntimePermissionsLPw(dialerPackage, PHONE_PERMISSIONS, isPhonePermFixed, userId);
            this.grantRuntimePermissionsLPw(dialerPackage, CONTACTS_PERMISSIONS, userId);
            this.grantRuntimePermissionsLPw(dialerPackage, SMS_PERMISSIONS, userId);
            this.grantRuntimePermissionsLPw(dialerPackage, MICROPHONE_PERMISSIONS, userId);
        }
    }

    private void grantDefaultPermissionsToDefaultSystemSmsAppLPr(PackageParser.Package smsPackage, int userId) {
        if (DefaultPermissionGrantPolicy.doesPackageSupportRuntimePermissions(smsPackage)) {
            this.grantRuntimePermissionsLPw(smsPackage, PHONE_PERMISSIONS, userId);
            this.grantRuntimePermissionsLPw(smsPackage, CONTACTS_PERMISSIONS, userId);
            this.grantRuntimePermissionsLPw(smsPackage, SMS_PERMISSIONS, userId);
        }
    }

    public void grantDefaultPermissionsToDefaultSmsAppLPr(String packageName, int userId) {
        Log.i(TAG, "Granting permissions to default sms app for user:" + userId);
        if (packageName == null) {
            return;
        }
        PackageParser.Package smsPackage = this.getPackageLPr(packageName);
        if (smsPackage != null && DefaultPermissionGrantPolicy.doesPackageSupportRuntimePermissions(smsPackage)) {
            this.grantRuntimePermissionsLPw(smsPackage, PHONE_PERMISSIONS, false, true, userId);
            this.grantRuntimePermissionsLPw(smsPackage, CONTACTS_PERMISSIONS, false, true, userId);
            this.grantRuntimePermissionsLPw(smsPackage, SMS_PERMISSIONS, false, true, userId);
        }
    }

    public void grantDefaultPermissionsToDefaultDialerAppLPr(String packageName, int userId) {
        Log.i(TAG, "Granting permissions to default dialer app for user:" + userId);
        if (packageName == null) {
            return;
        }
        PackageParser.Package dialerPackage = this.getPackageLPr(packageName);
        if (dialerPackage != null && DefaultPermissionGrantPolicy.doesPackageSupportRuntimePermissions(dialerPackage)) {
            this.grantRuntimePermissionsLPw(dialerPackage, PHONE_PERMISSIONS, false, true, userId);
            this.grantRuntimePermissionsLPw(dialerPackage, CONTACTS_PERMISSIONS, false, true, userId);
            this.grantRuntimePermissionsLPw(dialerPackage, SMS_PERMISSIONS, false, true, userId);
            this.grantRuntimePermissionsLPw(dialerPackage, MICROPHONE_PERMISSIONS, false, true, userId);
        }
    }

    private void grantDefaultPermissionsToDefaultSimCallManagerLPr(PackageParser.Package simCallManagerPackage, int userId) {
        Log.i(TAG, "Granting permissions to sim call manager for user:" + userId);
        if (DefaultPermissionGrantPolicy.doesPackageSupportRuntimePermissions(simCallManagerPackage)) {
            this.grantRuntimePermissionsLPw(simCallManagerPackage, PHONE_PERMISSIONS, userId);
            this.grantRuntimePermissionsLPw(simCallManagerPackage, MICROPHONE_PERMISSIONS, userId);
        }
    }

    public void grantDefaultPermissionsToDefaultSimCallManagerLPr(String packageName, int userId) {
        if (packageName == null) {
            return;
        }
        PackageParser.Package simCallManagerPackage = this.getPackageLPr(packageName);
        if (simCallManagerPackage != null) {
            this.grantDefaultPermissionsToDefaultSimCallManagerLPr(simCallManagerPackage, userId);
        }
    }

    public void grantDefaultPermissionsToEnabledCarrierAppsLPr(String[] packageNames, int userId) {
        Log.i(TAG, "Granting permissions to enabled carrier apps for user:" + userId);
        if (packageNames == null) {
            return;
        }
        for (String packageName : packageNames) {
            PackageParser.Package carrierPackage = this.getSystemPackageLPr(packageName);
            if (carrierPackage == null || !DefaultPermissionGrantPolicy.doesPackageSupportRuntimePermissions(carrierPackage)) continue;
            this.grantRuntimePermissionsLPw(carrierPackage, PHONE_PERMISSIONS, userId);
            this.grantRuntimePermissionsLPw(carrierPackage, LOCATION_PERMISSIONS, userId);
            this.grantRuntimePermissionsLPw(carrierPackage, SMS_PERMISSIONS, userId);
        }
    }

    public void grantDefaultPermissionsToDefaultBrowserLPr(String packageName, int userId) {
        Log.i(TAG, "Granting permissions to default browser for user:" + userId);
        if (packageName == null) {
            return;
        }
        PackageParser.Package browserPackage = this.getSystemPackageLPr(packageName);
        if (browserPackage != null && DefaultPermissionGrantPolicy.doesPackageSupportRuntimePermissions(browserPackage)) {
            this.grantRuntimePermissionsLPw(browserPackage, LOCATION_PERMISSIONS, false, false, userId);
        }
    }

    private PackageParser.Package getDefaultSystemHandlerActivityPackageLPr(Intent intent, int userId) {
        ResolveInfo handler = this.mService.resolveIntent(intent, intent.resolveType(this.mService.mContext.getContentResolver()), 786432, userId);
        if (handler == null || handler.activityInfo == null) {
            return null;
        }
        ActivityInfo activityInfo = handler.activityInfo;
        if (activityInfo.packageName.equals(this.mService.mResolveActivity.packageName) && activityInfo.name.equals(this.mService.mResolveActivity.name)) {
            return null;
        }
        return this.getSystemPackageLPr(handler.activityInfo.packageName);
    }

    private PackageParser.Package getDefaultSystemHandlerServicePackageLPr(Intent intent, int userId) {
        List<ResolveInfo> handlers = this.mService.queryIntentServices(intent, intent.resolveType(this.mService.mContext.getContentResolver()), 786432, userId).getList();
        if (handlers == null) {
            return null;
        }
        int handlerCount = handlers.size();
        for (int i = 0; i < handlerCount; ++i) {
            ResolveInfo handler = handlers.get(i);
            PackageParser.Package handlerPackage = this.getSystemPackageLPr(handler.serviceInfo.packageName);
            if (handlerPackage == null) continue;
            return handlerPackage;
        }
        return null;
    }

    private List<PackageParser.Package> getHeadlessSyncAdapterPackagesLPr(String[] syncAdapterPackageNames, int userId) {
        ArrayList<PackageParser.Package> syncAdapterPackages = new ArrayList<PackageParser.Package>();
        Intent homeIntent = new Intent("android.intent.action.MAIN");
        homeIntent.addCategory("android.intent.category.LAUNCHER");
        for (String syncAdapterPackageName : syncAdapterPackageNames) {
            PackageParser.Package syncAdapterPackage;
            homeIntent.setPackage(syncAdapterPackageName);
            ResolveInfo homeActivity = this.mService.resolveIntent(homeIntent, homeIntent.resolveType(this.mService.mContext.getContentResolver()), 786432, userId);
            if (homeActivity != null || (syncAdapterPackage = this.getSystemPackageLPr(syncAdapterPackageName)) == null) continue;
            syncAdapterPackages.add(syncAdapterPackage);
        }
        return syncAdapterPackages;
    }

    private PackageParser.Package getDefaultProviderAuthorityPackageLPr(String authority, int userId) {
        ProviderInfo provider = this.mService.resolveContentProvider(authority, 786432, userId);
        if (provider != null) {
            return this.getSystemPackageLPr(provider.packageName);
        }
        return null;
    }

    private PackageParser.Package getPackageLPr(String packageName) {
        return this.mService.mPackages.get(packageName);
    }

    private PackageParser.Package getSystemPackageLPr(String packageName) {
        PackageParser.Package pkg = this.getPackageLPr(packageName);
        if (pkg != null && pkg.isSystemApp()) {
            return !this.isSysComponentOrPersistentPlatformSignedPrivAppLPr(pkg) ? pkg : null;
        }
        return null;
    }

    private void grantRuntimePermissionsLPw(PackageParser.Package pkg, Set<String> permissions, int userId) {
        this.grantRuntimePermissionsLPw(pkg, permissions, false, false, userId);
    }

    private void grantRuntimePermissionsLPw(PackageParser.Package pkg, Set<String> permissions, boolean systemFixed, int userId) {
        this.grantRuntimePermissionsLPw(pkg, permissions, systemFixed, false, userId);
    }

    private void grantRuntimePermissionsLPw(PackageParser.Package pkg, Set<String> permissions, boolean systemFixed, boolean isDefaultPhoneOrSms, int userId) {
        PackageSetting sysPs;
        if (pkg.requestedPermissions.isEmpty()) {
            return;
        }
        ArrayList<String> requestedPermissions = pkg.requestedPermissions;
        ArraySet<String> grantablePermissions = null;
        if (!isDefaultPhoneOrSms && pkg.isUpdatedSystemApp() && (sysPs = this.mService.mSettings.getDisabledSystemPkgLPr(pkg.packageName)) != null) {
            if (sysPs.pkg.requestedPermissions.isEmpty()) {
                return;
            }
            if (!requestedPermissions.equals(sysPs.pkg.requestedPermissions)) {
                grantablePermissions = new ArraySet<String>(requestedPermissions);
                requestedPermissions = sysPs.pkg.requestedPermissions;
            }
        }
        int grantablePermissionCount = requestedPermissions.size();
        for (int i = 0; i < grantablePermissionCount; ++i) {
            String permission2 = (String)requestedPermissions.get(i);
            if (grantablePermissions != null && !grantablePermissions.contains(permission2) || !permissions.contains(permission2)) continue;
            int flags = this.mService.getPermissionFlags(permission2, pkg.packageName, userId);
            if (flags == 0 || isDefaultPhoneOrSms) {
                int fixedFlags = 20;
                if ((flags & 0x14) != 0) continue;
                this.mService.grantRuntimePermission(pkg.packageName, permission2, userId);
                int newFlags = 32;
                if (systemFixed) {
                    newFlags |= 0x10;
                }
                this.mService.updatePermissionFlags(permission2, pkg.packageName, newFlags, newFlags, userId);
            }
            if ((flags & 0x20) == 0 || (flags & 0x10) == 0 || systemFixed) continue;
            this.mService.updatePermissionFlags(permission2, pkg.packageName, 16, 0, userId);
        }
    }

    private boolean isSysComponentOrPersistentPlatformSignedPrivAppLPr(PackageParser.Package pkg) {
        if (UserHandle.getAppId(pkg.applicationInfo.uid) < 10000) {
            return true;
        }
        if (!pkg.isPrivilegedApp()) {
            return false;
        }
        PackageSetting sysPkg = this.mService.mSettings.getDisabledSystemPkgLPr(pkg.packageName);
        if (sysPkg != null && sysPkg.pkg != null ? (sysPkg.pkg.applicationInfo.flags & 8) == 0 : (pkg.applicationInfo.flags & 8) == 0) {
            return false;
        }
        return PackageManagerService.compareSignatures(this.mService.mPlatformPackage.mSignatures, pkg.mSignatures) == 0;
    }

    private static boolean doesPackageSupportRuntimePermissions(PackageParser.Package pkg) {
        return pkg.applicationInfo.targetSdkVersion > 22;
    }

    static {
        PHONE_PERMISSIONS.add("android.permission.READ_PHONE_STATE");
        PHONE_PERMISSIONS.add("android.permission.CALL_PHONE");
        PHONE_PERMISSIONS.add("android.permission.READ_CALL_LOG");
        PHONE_PERMISSIONS.add("android.permission.WRITE_CALL_LOG");
        PHONE_PERMISSIONS.add("com.android.voicemail.permission.ADD_VOICEMAIL");
        PHONE_PERMISSIONS.add("android.permission.USE_SIP");
        PHONE_PERMISSIONS.add("android.permission.PROCESS_OUTGOING_CALLS");
        CONTACTS_PERMISSIONS = new ArraySet<String>();
        CONTACTS_PERMISSIONS.add("android.permission.READ_CONTACTS");
        CONTACTS_PERMISSIONS.add("android.permission.WRITE_CONTACTS");
        CONTACTS_PERMISSIONS.add("android.permission.GET_ACCOUNTS");
        LOCATION_PERMISSIONS = new ArraySet<String>();
        LOCATION_PERMISSIONS.add("android.permission.ACCESS_FINE_LOCATION");
        LOCATION_PERMISSIONS.add("android.permission.ACCESS_COARSE_LOCATION");
        CALENDAR_PERMISSIONS = new ArraySet<String>();
        CALENDAR_PERMISSIONS.add("android.permission.READ_CALENDAR");
        CALENDAR_PERMISSIONS.add("android.permission.WRITE_CALENDAR");
        SMS_PERMISSIONS = new ArraySet<String>();
        SMS_PERMISSIONS.add("android.permission.SEND_SMS");
        SMS_PERMISSIONS.add("android.permission.RECEIVE_SMS");
        SMS_PERMISSIONS.add("android.permission.READ_SMS");
        SMS_PERMISSIONS.add("android.permission.RECEIVE_WAP_PUSH");
        SMS_PERMISSIONS.add("android.permission.RECEIVE_MMS");
        SMS_PERMISSIONS.add("android.permission.READ_CELL_BROADCASTS");
        MICROPHONE_PERMISSIONS = new ArraySet<String>();
        MICROPHONE_PERMISSIONS.add("android.permission.RECORD_AUDIO");
        CAMERA_PERMISSIONS = new ArraySet<String>();
        CAMERA_PERMISSIONS.add("android.permission.CAMERA");
        SENSORS_PERMISSIONS = new ArraySet<String>();
        SENSORS_PERMISSIONS.add("android.permission.BODY_SENSORS");
        STORAGE_PERMISSIONS = new ArraySet<String>();
        STORAGE_PERMISSIONS.add("android.permission.READ_EXTERNAL_STORAGE");
        STORAGE_PERMISSIONS.add("android.permission.WRITE_EXTERNAL_STORAGE");
    }
}

