/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.notification;

import com.android.server.notification.NotificationRecord;
import java.util.concurrent.TimeUnit;

public abstract class RankingReconsideration
implements Runnable {
    private static final long IMMEDIATE = 0L;
    private static final int START = 0;
    private static final int RUNNING = 1;
    private static final int DONE = 2;
    private static final int CANCELLED = 3;
    private int mState;
    private long mDelay;
    protected String mKey;

    public RankingReconsideration(String key) {
        this(key, 0L);
    }

    public RankingReconsideration(String key, long delay) {
        this.mDelay = delay;
        this.mKey = key;
        this.mState = 0;
    }

    public String getKey() {
        return this.mKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.mState == 0) {
            this.mState = 1;
            this.work();
            this.mState = 2;
            RankingReconsideration rankingReconsideration = this;
            synchronized (rankingReconsideration) {
                this.notifyAll();
            }
        }
    }

    public long getDelay(TimeUnit unit) {
        return unit.convert(this.mDelay, TimeUnit.MILLISECONDS);
    }

    public boolean cancel(boolean mayInterruptIfRunning) {
        if (this.mState == 0) {
            this.mState = 3;
            return true;
        }
        return false;
    }

    public boolean isCancelled() {
        return this.mState == 3;
    }

    public boolean isDone() {
        return this.mState == 2;
    }

    public abstract void work();

    public abstract void applyChangesLocked(NotificationRecord var1);
}

