/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.location;

import android.location.GnssMeasurementsEvent;
import android.location.IGnssMeasurementsListener;
import android.os.Handler;
import android.os.RemoteException;
import android.util.Log;
import com.android.server.location.RemoteListenerHelper;

public abstract class GnssMeasurementsProvider
extends RemoteListenerHelper<IGnssMeasurementsListener> {
    private static final String TAG = "GnssMeasurementsProvider";

    protected GnssMeasurementsProvider(Handler handler) {
        super(handler, TAG);
    }

    public void onMeasurementsAvailable(final GnssMeasurementsEvent event) {
        RemoteListenerHelper.ListenerOperation<IGnssMeasurementsListener> operation = new RemoteListenerHelper.ListenerOperation<IGnssMeasurementsListener>(){

            @Override
            public void execute(IGnssMeasurementsListener listener) throws RemoteException {
                listener.onGnssMeasurementsReceived(event);
            }
        };
        this.foreach(operation);
    }

    public void onCapabilitiesUpdated(boolean isGnssMeasurementsSupported) {
        this.setSupported(isGnssMeasurementsSupported);
        this.updateResult();
    }

    public void onGpsEnabledChanged() {
        if (this.tryUpdateRegistrationWithService()) {
            this.updateResult();
        }
    }

    @Override
    protected RemoteListenerHelper.ListenerOperation<IGnssMeasurementsListener> getHandlerOperation(int result) {
        int status;
        switch (result) {
            case 0: {
                status = 1;
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                status = 0;
                break;
            }
            case 3: {
                status = 2;
                break;
            }
            case 5: {
                return null;
            }
            default: {
                Log.v(TAG, "Unhandled addListener result: " + result);
                return null;
            }
        }
        return new StatusChangedOperation(status);
    }

    private static class StatusChangedOperation
    implements RemoteListenerHelper.ListenerOperation<IGnssMeasurementsListener> {
        private final int mStatus;

        public StatusChangedOperation(int status) {
            this.mStatus = status;
        }

        @Override
        public void execute(IGnssMeasurementsListener listener) throws RemoteException {
            listener.onStatusChanged(this.mStatus);
        }
    }
}

