/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.lights;

import android.app.ActivityManager;
import android.content.Context;
import android.os.Handler;
import android.os.Message;
import android.os.RemoteException;
import android.os.Trace;
import android.provider.Settings;
import android.service.vr.IVrManager;
import android.service.vr.IVrStateCallbacks;
import android.util.Slog;
import com.android.server.SystemService;
import com.android.server.lights.Light;
import com.android.server.lights.LightsManager;

public class LightsService
extends SystemService {
    static final String TAG = "LightsService";
    static final boolean DEBUG = false;
    final LightImpl[] mLights = new LightImpl[8];
    private boolean mVrModeEnabled;
    private final IVrStateCallbacks mVrStateCallbacks = new IVrStateCallbacks.Stub(){

        @Override
        public void onVrStateChanged(boolean enabled) throws RemoteException {
            LightImpl l = LightsService.this.mLights[0];
            int vrDisplayMode = LightsService.this.getVrDisplayMode();
            if (enabled && vrDisplayMode == 0) {
                if (!LightsService.this.mVrModeEnabled) {
                    l.enableLowPersistence();
                    LightsService.this.mVrModeEnabled = true;
                }
            } else if (LightsService.this.mVrModeEnabled) {
                l.disableLowPersistence();
                LightsService.this.mVrModeEnabled = false;
            }
        }
    };
    private final LightsManager mService = new LightsManager(){

        @Override
        public Light getLight(int id2) {
            if (id2 < 8) {
                return LightsService.this.mLights[id2];
            }
            return null;
        }
    };
    private Handler mH = new Handler(){

        @Override
        public void handleMessage(Message msg) {
            LightImpl light = (LightImpl)msg.obj;
            light.stopFlashing();
        }
    };
    private long mNativePointer = LightsService.init_native();

    public LightsService(Context context) {
        super(context);
        for (int i = 0; i < 8; ++i) {
            this.mLights[i] = new LightImpl(i);
        }
    }

    @Override
    public void onStart() {
        this.publishLocalService(LightsManager.class, this.mService);
    }

    @Override
    public void onBootPhase(int phase) {
        if (phase == 500) {
            IVrManager vrManager = (IVrManager)((Object)this.getBinderService("vrmanager"));
            try {
                vrManager.registerListener(this.mVrStateCallbacks);
            }
            catch (RemoteException e) {
                Slog.e(TAG, "Failed to register VR mode state listener: " + e);
            }
        }
    }

    private int getVrDisplayMode() {
        int currentUser = ActivityManager.getCurrentUser();
        return Settings.Secure.getIntForUser(this.getContext().getContentResolver(), "vr_display_mode", 0, currentUser);
    }

    protected void finalize() throws Throwable {
        LightsService.finalize_native(this.mNativePointer);
        super.finalize();
    }

    private static native long init_native();

    private static native void finalize_native(long var0);

    static native void setLight_native(long var0, int var2, int var3, int var4, int var5, int var6, int var7);

    private final class LightImpl
    extends Light {
        private int mId;
        private int mColor;
        private int mMode;
        private int mOnMS;
        private int mOffMS;
        private boolean mFlashing;
        private int mBrightnessMode;
        private int mLastBrightnessMode;
        private int mLastColor;
        private boolean mLocked;

        private LightImpl(int id2) {
            this.mId = id2;
        }

        @Override
        public void setBrightness(int brightness) {
            this.setBrightness(brightness, 0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setBrightness(int brightness, int brightnessMode) {
            LightImpl lightImpl = this;
            synchronized (lightImpl) {
                int color2 = brightness & 0xFF;
                color2 = 0xFF000000 | color2 << 16 | color2 << 8 | color2;
                this.setLightLocked(color2, 0, 0, 0, brightnessMode);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setColor(int color2) {
            LightImpl lightImpl = this;
            synchronized (lightImpl) {
                this.setLightLocked(color2, 0, 0, 0, 0);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setFlashing(int color2, int mode, int onMS, int offMS) {
            LightImpl lightImpl = this;
            synchronized (lightImpl) {
                this.setLightLocked(color2, mode, onMS, offMS, 0);
            }
        }

        @Override
        public void pulse() {
            this.pulse(0xFFFFFF, 7);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void pulse(int color2, int onMS) {
            LightImpl lightImpl = this;
            synchronized (lightImpl) {
                if (this.mBrightnessMode == 2) {
                    return;
                }
                if (this.mColor == 0 && !this.mFlashing) {
                    this.setLightLocked(color2, 2, onMS, 1000, 0);
                    this.mColor = 0;
                    LightsService.this.mH.sendMessageDelayed(Message.obtain(LightsService.this.mH, 1, this), onMS);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void turnOff() {
            LightImpl lightImpl = this;
            synchronized (lightImpl) {
                this.setLightLocked(0, 0, 0, 0, 0);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void enableLowPersistence() {
            LightImpl lightImpl = this;
            synchronized (lightImpl) {
                this.setLightLocked(0, 0, 0, 0, 2);
                this.mLocked = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void disableLowPersistence() {
            LightImpl lightImpl = this;
            synchronized (lightImpl) {
                this.mLocked = false;
                this.setLightLocked(this.mLastColor, 0, 0, 0, this.mLastBrightnessMode);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void stopFlashing() {
            LightImpl lightImpl = this;
            synchronized (lightImpl) {
                this.setLightLocked(this.mColor, 0, 0, 0, 0);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setLightLocked(int color2, int mode, int onMS, int offMS, int brightnessMode) {
            if (!(this.mLocked || color2 == this.mColor && mode == this.mMode && onMS == this.mOnMS && offMS == this.mOffMS && this.mBrightnessMode == brightnessMode)) {
                this.mLastColor = this.mColor;
                this.mColor = color2;
                this.mMode = mode;
                this.mOnMS = onMS;
                this.mOffMS = offMS;
                this.mLastBrightnessMode = this.mBrightnessMode;
                this.mBrightnessMode = brightnessMode;
                Trace.traceBegin(131072L, "setLight(" + this.mId + ", 0x" + Integer.toHexString(color2) + ")");
                try {
                    LightsService.setLight_native(LightsService.this.mNativePointer, this.mId, color2, mode, onMS, offMS, brightnessMode);
                }
                finally {
                    Trace.traceEnd(131072L);
                }
            }
        }
    }
}

