/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.job.controllers;

import android.app.job.JobInfo;
import android.content.Context;
import android.database.ContentObserver;
import android.net.Uri;
import android.os.Handler;
import android.os.UserHandle;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.TimeUtils;
import com.android.server.job.JobSchedulerService;
import com.android.server.job.StateChangedListener;
import com.android.server.job.controllers.JobStatus;
import com.android.server.job.controllers.StateController;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

public class ContentObserverController
extends StateController {
    private static final String TAG = "JobScheduler.Content";
    private static final boolean DEBUG = false;
    private static final int MAX_URIS_REPORTED = 50;
    private static final int URIS_URGENT_THRESHOLD = 40;
    private static final Object sCreationLock = new Object();
    private static volatile ContentObserverController sController;
    private final List<JobStatus> mTrackedTasks = new ArrayList<JobStatus>();
    ArrayMap<JobInfo.TriggerContentUri, ObserverInstance> mObservers = new ArrayMap();
    final Handler mHandler;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ContentObserverController get(JobSchedulerService taskManagerService) {
        Object object = sCreationLock;
        synchronized (object) {
            if (sController == null) {
                sController = new ContentObserverController(taskManagerService, taskManagerService.getContext(), taskManagerService.getLock());
            }
        }
        return sController;
    }

    public static ContentObserverController getForTesting(StateChangedListener stateChangedListener, Context context) {
        return new ContentObserverController(stateChangedListener, context, new Object());
    }

    private ContentObserverController(StateChangedListener stateChangedListener, Context context, Object lock) {
        super(stateChangedListener, context, lock);
        this.mHandler = new Handler(context.getMainLooper());
    }

    @Override
    public void maybeStartTrackingJobLocked(JobStatus taskStatus, JobStatus lastJob) {
        if (taskStatus.hasContentTriggerConstraint()) {
            if (taskStatus.contentObserverJobInstance == null) {
                taskStatus.contentObserverJobInstance = new JobInstance(taskStatus);
            }
            this.mTrackedTasks.add(taskStatus);
            boolean havePendingUris = false;
            if (taskStatus.contentObserverJobInstance.mChangedAuthorities != null) {
                havePendingUris = true;
            }
            if (taskStatus.changedAuthorities != null) {
                havePendingUris = true;
                if (taskStatus.contentObserverJobInstance.mChangedAuthorities == null) {
                    taskStatus.contentObserverJobInstance.mChangedAuthorities = new ArraySet();
                }
                for (String auth : taskStatus.changedAuthorities) {
                    taskStatus.contentObserverJobInstance.mChangedAuthorities.add(auth);
                }
                if (taskStatus.changedUris != null) {
                    if (taskStatus.contentObserverJobInstance.mChangedUris == null) {
                        taskStatus.contentObserverJobInstance.mChangedUris = new ArraySet();
                    }
                    for (Uri uri : taskStatus.changedUris) {
                        taskStatus.contentObserverJobInstance.mChangedUris.add(uri);
                    }
                }
                taskStatus.changedAuthorities = null;
                taskStatus.changedUris = null;
            }
            taskStatus.changedAuthorities = null;
            taskStatus.changedUris = null;
            taskStatus.setContentTriggerConstraintSatisfied(havePendingUris);
        }
        if (lastJob != null && lastJob.contentObserverJobInstance != null) {
            lastJob.contentObserverJobInstance.detachLocked();
            lastJob.contentObserverJobInstance = null;
        }
    }

    @Override
    public void prepareForExecutionLocked(JobStatus taskStatus) {
        if (taskStatus.hasContentTriggerConstraint() && taskStatus.contentObserverJobInstance != null) {
            taskStatus.changedUris = taskStatus.contentObserverJobInstance.mChangedUris;
            taskStatus.changedAuthorities = taskStatus.contentObserverJobInstance.mChangedAuthorities;
            taskStatus.contentObserverJobInstance.mChangedUris = null;
            taskStatus.contentObserverJobInstance.mChangedAuthorities = null;
        }
    }

    @Override
    public void maybeStopTrackingJobLocked(JobStatus taskStatus, JobStatus incomingJob, boolean forUpdate) {
        if (taskStatus.hasContentTriggerConstraint()) {
            if (taskStatus.contentObserverJobInstance != null) {
                taskStatus.contentObserverJobInstance.unscheduleLocked();
                if (incomingJob != null) {
                    if (taskStatus.contentObserverJobInstance != null && taskStatus.contentObserverJobInstance.mChangedAuthorities != null) {
                        if (incomingJob.contentObserverJobInstance == null) {
                            incomingJob.contentObserverJobInstance = new JobInstance(incomingJob);
                        }
                        incomingJob.contentObserverJobInstance.mChangedAuthorities = taskStatus.contentObserverJobInstance.mChangedAuthorities;
                        incomingJob.contentObserverJobInstance.mChangedUris = taskStatus.contentObserverJobInstance.mChangedUris;
                        taskStatus.contentObserverJobInstance.mChangedAuthorities = null;
                        taskStatus.contentObserverJobInstance.mChangedUris = null;
                    }
                } else {
                    taskStatus.contentObserverJobInstance.detachLocked();
                    taskStatus.contentObserverJobInstance = null;
                }
            }
            this.mTrackedTasks.remove(taskStatus);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rescheduleForFailure(JobStatus newJob, JobStatus failureToReschedule) {
        if (failureToReschedule.hasContentTriggerConstraint() && newJob.hasContentTriggerConstraint()) {
            Object object = this.mLock;
            synchronized (object) {
                newJob.changedAuthorities = failureToReschedule.changedAuthorities;
                newJob.changedUris = failureToReschedule.changedUris;
            }
        }
    }

    @Override
    public void dumpControllerStateLocked(PrintWriter pw, int filterUid) {
        pw.println("Content:");
        for (JobStatus js : this.mTrackedTasks) {
            if (!js.shouldDump(filterUid)) continue;
            pw.print("  #");
            js.printUniqueId(pw);
            pw.print(" from ");
            UserHandle.formatUid(pw, js.getSourceUid());
            pw.println();
        }
        int N = this.mObservers.size();
        if (N > 0) {
            pw.println("  Observers:");
            for (int i = 0; i < N; ++i) {
                ObserverInstance obs = this.mObservers.valueAt(i);
                int M = obs.mJobs.size();
                boolean shouldDump = false;
                for (int j = 0; j < M; ++j) {
                    JobInstance inst = obs.mJobs.valueAt(j);
                    if (!inst.mJobStatus.shouldDump(filterUid)) continue;
                    shouldDump = true;
                    break;
                }
                if (!shouldDump) continue;
                pw.print("    ");
                JobInfo.TriggerContentUri trigger = this.mObservers.keyAt(i);
                pw.print(trigger.getUri());
                pw.print(" 0x");
                pw.print(Integer.toHexString(trigger.getFlags()));
                pw.print(" (");
                pw.print(System.identityHashCode(obs));
                pw.println("):");
                pw.println("      Jobs:");
                for (int j = 0; j < M; ++j) {
                    JobInstance inst = obs.mJobs.valueAt(j);
                    pw.print("        #");
                    inst.mJobStatus.printUniqueId(pw);
                    pw.print(" from ");
                    UserHandle.formatUid(pw, inst.mJobStatus.getSourceUid());
                    if (inst.mChangedAuthorities != null) {
                        int k;
                        pw.println(":");
                        if (inst.mTriggerPending) {
                            pw.print("          Trigger pending: update=");
                            TimeUtils.formatDuration(inst.mJobStatus.getTriggerContentUpdateDelay(), pw);
                            pw.print(", max=");
                            TimeUtils.formatDuration(inst.mJobStatus.getTriggerContentMaxDelay(), pw);
                            pw.println();
                        }
                        pw.println("          Changed Authorities:");
                        for (k = 0; k < inst.mChangedAuthorities.size(); ++k) {
                            pw.print("          ");
                            pw.println(inst.mChangedAuthorities.valueAt(k));
                        }
                        if (inst.mChangedUris == null) continue;
                        pw.println("          Changed URIs:");
                        for (k = 0; k < inst.mChangedUris.size(); ++k) {
                            pw.print("          ");
                            pw.println(inst.mChangedUris.valueAt(k));
                        }
                        continue;
                    }
                    pw.println();
                }
            }
        }
    }

    final class JobInstance {
        final ArrayList<ObserverInstance> mMyObservers = new ArrayList();
        final JobStatus mJobStatus;
        final Runnable mExecuteRunner;
        final Runnable mTimeoutRunner;
        ArraySet<Uri> mChangedUris;
        ArraySet<String> mChangedAuthorities;
        boolean mTriggerPending;

        JobInstance(JobStatus jobStatus) {
            this.mJobStatus = jobStatus;
            this.mExecuteRunner = new TriggerRunnable(this);
            this.mTimeoutRunner = new TriggerRunnable(this);
            JobInfo.TriggerContentUri[] uris = jobStatus.getJob().getTriggerContentUris();
            if (uris != null) {
                for (JobInfo.TriggerContentUri uri : uris) {
                    ObserverInstance obs = ContentObserverController.this.mObservers.get(uri);
                    if (obs == null) {
                        obs = new ObserverInstance(ContentObserverController.this.mHandler, uri);
                        ContentObserverController.this.mObservers.put(uri, obs);
                        boolean andDescendants = (uri.getFlags() & 1) != 0;
                        ContentObserverController.this.mContext.getContentResolver().registerContentObserver(uri.getUri(), andDescendants, obs);
                    }
                    obs.mJobs.add(this);
                    this.mMyObservers.add(obs);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void trigger() {
            boolean reportChange = false;
            Object object = ContentObserverController.this.mLock;
            synchronized (object) {
                if (this.mTriggerPending) {
                    if (this.mJobStatus.setContentTriggerConstraintSatisfied(true)) {
                        reportChange = true;
                    }
                    this.unscheduleLocked();
                }
            }
            if (reportChange) {
                ContentObserverController.this.mStateChangedListener.onControllerStateChanged();
            }
        }

        void scheduleLocked() {
            if (!this.mTriggerPending) {
                this.mTriggerPending = true;
                ContentObserverController.this.mHandler.postDelayed(this.mTimeoutRunner, this.mJobStatus.getTriggerContentMaxDelay());
            }
            ContentObserverController.this.mHandler.removeCallbacks(this.mExecuteRunner);
            if (this.mChangedUris.size() >= 40) {
                ContentObserverController.this.mHandler.post(this.mExecuteRunner);
            } else {
                ContentObserverController.this.mHandler.postDelayed(this.mExecuteRunner, this.mJobStatus.getTriggerContentUpdateDelay());
            }
        }

        void unscheduleLocked() {
            if (this.mTriggerPending) {
                ContentObserverController.this.mHandler.removeCallbacks(this.mExecuteRunner);
                ContentObserverController.this.mHandler.removeCallbacks(this.mTimeoutRunner);
                this.mTriggerPending = false;
            }
        }

        void detachLocked() {
            int N = this.mMyObservers.size();
            for (int i = 0; i < N; ++i) {
                ObserverInstance obs = this.mMyObservers.get(i);
                obs.mJobs.remove(this);
                if (obs.mJobs.size() != 0) continue;
                ContentObserverController.this.mContext.getContentResolver().unregisterContentObserver(obs);
                ContentObserverController.this.mObservers.remove(obs.mUri);
            }
        }
    }

    static final class TriggerRunnable
    implements Runnable {
        final JobInstance mInstance;

        TriggerRunnable(JobInstance instance) {
            this.mInstance = instance;
        }

        @Override
        public void run() {
            this.mInstance.trigger();
        }
    }

    final class ObserverInstance
    extends ContentObserver {
        final JobInfo.TriggerContentUri mUri;
        final ArraySet<JobInstance> mJobs;

        public ObserverInstance(Handler handler, JobInfo.TriggerContentUri uri) {
            super(handler);
            this.mJobs = new ArraySet();
            this.mUri = uri;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onChange(boolean selfChange, Uri uri) {
            Object object = ContentObserverController.this.mLock;
            synchronized (object) {
                int N = this.mJobs.size();
                for (int i = 0; i < N; ++i) {
                    JobInstance inst = this.mJobs.valueAt(i);
                    if (inst.mChangedUris == null) {
                        inst.mChangedUris = new ArraySet();
                    }
                    if (inst.mChangedUris.size() < 50) {
                        inst.mChangedUris.add(uri);
                    }
                    if (inst.mChangedAuthorities == null) {
                        inst.mChangedAuthorities = new ArraySet();
                    }
                    inst.mChangedAuthorities.add(uri.getAuthority());
                    inst.scheduleLocked();
                }
            }
        }
    }
}

