/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.fingerprint;

import android.content.Context;
import android.hardware.fingerprint.IFingerprintDaemon;
import android.hardware.fingerprint.IFingerprintServiceReceiver;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Slog;
import com.android.server.fingerprint.ClientMonitor;
import com.android.server.fingerprint.FingerprintUtils;

public abstract class RemovalClient
extends ClientMonitor {
    private int mFingerId;

    public RemovalClient(Context context, long halDeviceId, IBinder token, IFingerprintServiceReceiver receiver, int fingerId, int groupId, int userId, boolean restricted, String owner) {
        super(context, halDeviceId, token, receiver, userId, groupId, restricted, owner);
        this.mFingerId = fingerId;
    }

    @Override
    public int start() {
        IFingerprintDaemon daemon = this.getFingerprintDaemon();
        try {
            int result = daemon.remove(this.mFingerId, this.getGroupId());
            if (result != 0) {
                Slog.w("FingerprintService", "startRemove with id = " + this.mFingerId + " failed, result=" + result);
                this.onError(1);
                return result;
            }
        }
        catch (RemoteException e) {
            Slog.e("FingerprintService", "startRemove failed", e);
        }
        return 0;
    }

    @Override
    public int stop(boolean initiatedByClient) {
        if (initiatedByClient) {
            this.onError(5);
        }
        return 0;
    }

    private boolean sendRemoved(int fingerId, int groupId) {
        IFingerprintServiceReceiver receiver = this.getReceiver();
        try {
            if (receiver != null) {
                receiver.onRemoved(this.getHalDeviceId(), fingerId, groupId);
            }
        }
        catch (RemoteException e) {
            Slog.w("FingerprintService", "Failed to notify Removed:", e);
        }
        return fingerId == 0;
    }

    @Override
    public boolean onRemoved(int fingerId, int groupId) {
        if (fingerId != 0) {
            FingerprintUtils.getInstance().removeFingerprintIdForUser(this.getContext(), fingerId, this.getTargetUserId());
        }
        return this.sendRemoved(fingerId, this.getGroupId());
    }

    @Override
    public boolean onEnrollResult(int fingerId, int groupId, int rem) {
        Slog.w("FingerprintService", "onEnrollResult() called for remove!");
        return true;
    }

    @Override
    public boolean onAuthenticated(int fingerId, int groupId) {
        Slog.w("FingerprintService", "onAuthenticated() called for remove!");
        return true;
    }

    @Override
    public boolean onEnumerationResult(int fingerId, int groupId) {
        Slog.w("FingerprintService", "onEnumerationResult() called for remove!");
        return false;
    }
}

