/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.fingerprint;

import android.app.ActivityManager;
import android.app.ActivityManagerNative;
import android.app.AlarmManager;
import android.app.AppOpsManager;
import android.app.PendingIntent;
import android.app.SynchronousUserSwitchObserver;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.UserInfo;
import android.hardware.fingerprint.Fingerprint;
import android.hardware.fingerprint.IFingerprintDaemon;
import android.hardware.fingerprint.IFingerprintDaemonCallback;
import android.hardware.fingerprint.IFingerprintService;
import android.hardware.fingerprint.IFingerprintServiceLockoutResetCallback;
import android.hardware.fingerprint.IFingerprintServiceReceiver;
import android.os.Binder;
import android.os.DeadObjectException;
import android.os.Environment;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.PowerManager;
import android.os.RemoteException;
import android.os.SELinux;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.os.UserHandle;
import android.os.UserManager;
import android.util.Slog;
import com.android.internal.logging.MetricsLogger;
import com.android.server.SystemService;
import com.android.server.fingerprint.AuthenticationClient;
import com.android.server.fingerprint.ClientMonitor;
import com.android.server.fingerprint.EnrollClient;
import com.android.server.fingerprint.FingerprintUtils;
import com.android.server.fingerprint.RemovalClient;
import java.io.File;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class FingerprintService
extends SystemService
implements IBinder.DeathRecipient {
    static final String TAG = "FingerprintService";
    static final boolean DEBUG = true;
    private static final String FP_DATA_DIR = "fpdata";
    private static final String FINGERPRINTD = "android.hardware.fingerprint.IFingerprintDaemon";
    private static final int MSG_USER_SWITCHING = 10;
    private static final String ACTION_LOCKOUT_RESET = "com.android.server.fingerprint.ACTION_LOCKOUT_RESET";
    private final ArrayList<FingerprintServiceLockoutResetMonitor> mLockoutMonitors = new ArrayList();
    private final AppOpsManager mAppOps;
    private static final long FAIL_LOCKOUT_TIMEOUT_MS = 30000L;
    private static final int MAX_FAILED_ATTEMPTS = 5;
    private static final long CANCEL_TIMEOUT_LIMIT = 3000L;
    private final String mKeyguardPackage;
    private int mCurrentUserId = -2;
    private final FingerprintUtils mFingerprintUtils = FingerprintUtils.getInstance();
    private Context mContext;
    private long mHalDeviceId;
    private int mFailedAttempts;
    private IFingerprintDaemon mDaemon;
    private final PowerManager mPowerManager;
    private final AlarmManager mAlarmManager;
    private final UserManager mUserManager;
    private ClientMonitor mCurrentClient;
    private ClientMonitor mPendingClient;
    private long mCurrentAuthenticatorId;
    private Handler mHandler = new Handler(){

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 10: {
                    FingerprintService.this.handleUserSwitching(msg.arg1);
                    break;
                }
                default: {
                    Slog.w(FingerprintService.TAG, "Unknown message:" + msg.what);
                }
            }
        }
    };
    private final BroadcastReceiver mLockoutReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            if (FingerprintService.ACTION_LOCKOUT_RESET.equals(intent.getAction())) {
                FingerprintService.this.resetFailedAttempts();
            }
        }
    };
    private final Runnable mResetFailedAttemptsRunnable = new Runnable(){

        @Override
        public void run() {
            FingerprintService.this.resetFailedAttempts();
        }
    };
    private final Runnable mResetClientState = new Runnable(){

        @Override
        public void run() {
            Slog.w(FingerprintService.TAG, "Client " + (FingerprintService.this.mCurrentClient != null ? FingerprintService.this.mCurrentClient.getOwnerString() : "null") + " failed to respond to cancel, starting client " + (FingerprintService.this.mPendingClient != null ? FingerprintService.this.mPendingClient.getOwnerString() : "null"));
            FingerprintService.this.mCurrentClient = null;
            FingerprintService.this.startClient(FingerprintService.this.mPendingClient, false);
        }
    };
    private IFingerprintDaemonCallback mDaemonCallback = new IFingerprintDaemonCallback.Stub(){

        @Override
        public void onEnrollResult(final long deviceId, final int fingerId, final int groupId, final int remaining) {
            FingerprintService.this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    FingerprintService.this.handleEnrollResult(deviceId, fingerId, groupId, remaining);
                }
            });
        }

        @Override
        public void onAcquired(final long deviceId, final int acquiredInfo) {
            FingerprintService.this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    FingerprintService.this.handleAcquired(deviceId, acquiredInfo);
                }
            });
        }

        @Override
        public void onAuthenticated(final long deviceId, final int fingerId, final int groupId) {
            FingerprintService.this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    FingerprintService.this.handleAuthenticated(deviceId, fingerId, groupId);
                }
            });
        }

        @Override
        public void onError(final long deviceId, final int error) {
            FingerprintService.this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    FingerprintService.this.handleError(deviceId, error);
                }
            });
        }

        @Override
        public void onRemoved(final long deviceId, final int fingerId, final int groupId) {
            FingerprintService.this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    FingerprintService.this.handleRemoved(deviceId, fingerId, groupId);
                }
            });
        }

        @Override
        public void onEnumerate(final long deviceId, final int[] fingerIds, final int[] groupIds) {
            FingerprintService.this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    FingerprintService.this.handleEnumerate(deviceId, fingerIds, groupIds);
                }
            });
        }
    };

    public FingerprintService(Context context) {
        super(context);
        this.mContext = context;
        this.mKeyguardPackage = ComponentName.unflattenFromString(context.getResources().getString(17039463)).getPackageName();
        this.mAppOps = context.getSystemService(AppOpsManager.class);
        this.mPowerManager = this.mContext.getSystemService(PowerManager.class);
        this.mAlarmManager = this.mContext.getSystemService(AlarmManager.class);
        this.mContext.registerReceiver(this.mLockoutReceiver, new IntentFilter(ACTION_LOCKOUT_RESET), "android.permission.RESET_FINGERPRINT_LOCKOUT", null);
        this.mUserManager = UserManager.get(this.mContext);
    }

    @Override
    public void binderDied() {
        Slog.v(TAG, "fingerprintd died");
        this.mDaemon = null;
        this.handleError(this.mHalDeviceId, 1);
    }

    public IFingerprintDaemon getFingerprintDaemon() {
        block6: {
            if (this.mDaemon == null) {
                this.mDaemon = IFingerprintDaemon.Stub.asInterface(ServiceManager.getService(FINGERPRINTD));
                if (this.mDaemon != null) {
                    try {
                        this.mDaemon.asBinder().linkToDeath(this, 0);
                        this.mDaemon.init(this.mDaemonCallback);
                        this.mHalDeviceId = this.mDaemon.openHal();
                        if (this.mHalDeviceId != 0L) {
                            this.updateActiveGroup(ActivityManager.getCurrentUser(), null);
                            break block6;
                        }
                        Slog.w(TAG, "Failed to open Fingerprint HAL!");
                        this.mDaemon = null;
                    }
                    catch (RemoteException e) {
                        Slog.e(TAG, "Failed to open fingeprintd HAL", e);
                        this.mDaemon = null;
                    }
                } else {
                    Slog.w(TAG, "fingerprint service not available");
                }
            }
        }
        return this.mDaemon;
    }

    protected void handleEnumerate(long deviceId, int[] fingerIds, int[] groupIds) {
        if (fingerIds.length != groupIds.length) {
            Slog.w(TAG, "fingerIds and groupIds differ in length: f[]=" + Arrays.toString(fingerIds) + ", g[]=" + Arrays.toString(groupIds));
            return;
        }
        Slog.w(TAG, "Enumerate: f[]=" + fingerIds + ", g[]=" + groupIds);
    }

    protected void handleError(long deviceId, int error) {
        ClientMonitor client = this.mCurrentClient;
        if (client != null && client.onError(error)) {
            this.removeClient(client);
        }
        Slog.v(TAG, "handleError(client=" + (client != null ? client.getOwnerString() : "null") + ", error = " + error + ")");
        if (error == 5) {
            this.mHandler.removeCallbacks(this.mResetClientState);
            if (this.mPendingClient != null) {
                Slog.v(TAG, "start pending client " + this.mPendingClient.getOwnerString());
                this.startClient(this.mPendingClient, false);
                this.mPendingClient = null;
            }
        }
    }

    protected void handleRemoved(long deviceId, int fingerId, int groupId) {
        ClientMonitor client = this.mCurrentClient;
        if (client != null && client.onRemoved(fingerId, groupId)) {
            this.removeClient(client);
        }
    }

    protected void handleAuthenticated(long deviceId, int fingerId, int groupId) {
        ClientMonitor client = this.mCurrentClient;
        if (client != null && client.onAuthenticated(fingerId, groupId)) {
            this.removeClient(client);
        }
    }

    protected void handleAcquired(long deviceId, int acquiredInfo) {
        ClientMonitor client = this.mCurrentClient;
        if (client != null && client.onAcquired(acquiredInfo)) {
            this.removeClient(client);
        }
    }

    protected void handleEnrollResult(long deviceId, int fingerId, int groupId, int remaining) {
        ClientMonitor client = this.mCurrentClient;
        if (client != null && client.onEnrollResult(fingerId, groupId, remaining)) {
            this.removeClient(client);
        }
    }

    private void userActivity() {
        long now = SystemClock.uptimeMillis();
        this.mPowerManager.userActivity(now, 2, 0);
    }

    void handleUserSwitching(int userId) {
        this.updateActiveGroup(userId, null);
    }

    private void removeClient(ClientMonitor client) {
        if (client != null) {
            client.destroy();
            if (client != this.mCurrentClient && this.mCurrentClient != null) {
                Slog.w(TAG, "Unexpected client: " + client.getOwnerString() + "expected: " + this.mCurrentClient != null ? this.mCurrentClient.getOwnerString() : "null");
            }
        }
        if (this.mCurrentClient != null) {
            Slog.v(TAG, "Done with client: " + client.getOwnerString());
            this.mCurrentClient = null;
        }
    }

    private boolean inLockoutMode() {
        return this.mFailedAttempts >= 5;
    }

    private void scheduleLockoutReset() {
        this.mAlarmManager.set(2, SystemClock.elapsedRealtime() + 30000L, this.getLockoutResetIntent());
    }

    private void cancelLockoutReset() {
        this.mAlarmManager.cancel(this.getLockoutResetIntent());
    }

    private PendingIntent getLockoutResetIntent() {
        return PendingIntent.getBroadcast(this.mContext, 0, new Intent(ACTION_LOCKOUT_RESET), 0x8000000);
    }

    public long startPreEnroll(IBinder token) {
        IFingerprintDaemon daemon = this.getFingerprintDaemon();
        if (daemon == null) {
            Slog.w(TAG, "startPreEnroll: no fingeprintd!");
            return 0L;
        }
        try {
            return daemon.preEnroll();
        }
        catch (RemoteException e) {
            Slog.e(TAG, "startPreEnroll failed", e);
            return 0L;
        }
    }

    public int startPostEnroll(IBinder token) {
        IFingerprintDaemon daemon = this.getFingerprintDaemon();
        if (daemon == null) {
            Slog.w(TAG, "startPostEnroll: no fingeprintd!");
            return 0;
        }
        try {
            return daemon.postEnroll();
        }
        catch (RemoteException e) {
            Slog.e(TAG, "startPostEnroll failed", e);
            return 0;
        }
    }

    private void startClient(ClientMonitor newClient, boolean initiatedByClient) {
        ClientMonitor currentClient = this.mCurrentClient;
        if (currentClient != null) {
            Slog.v(TAG, "request stop current client " + currentClient.getOwnerString());
            currentClient.stop(initiatedByClient);
            this.mPendingClient = newClient;
            this.mHandler.removeCallbacks(this.mResetClientState);
            this.mHandler.postDelayed(this.mResetClientState, 3000L);
        } else if (newClient != null) {
            this.mCurrentClient = newClient;
            Slog.v(TAG, "starting client " + newClient.getClass().getSuperclass().getSimpleName() + "(" + newClient.getOwnerString() + "), initiatedByClient = " + initiatedByClient + ")");
            newClient.start();
        }
    }

    void startRemove(IBinder token, int fingerId, int groupId, int userId, IFingerprintServiceReceiver receiver, boolean restricted) {
        IFingerprintDaemon daemon = this.getFingerprintDaemon();
        if (daemon == null) {
            Slog.w(TAG, "startRemove: no fingeprintd!");
            return;
        }
        RemovalClient client = new RemovalClient(this.getContext(), this.mHalDeviceId, token, receiver, fingerId, groupId, userId, restricted, token.toString()){

            @Override
            public void notifyUserActivity() {
                FingerprintService.this.userActivity();
            }

            @Override
            public IFingerprintDaemon getFingerprintDaemon() {
                return FingerprintService.this.getFingerprintDaemon();
            }
        };
        this.startClient(client, true);
    }

    public List<Fingerprint> getEnrolledFingerprints(int userId) {
        return this.mFingerprintUtils.getFingerprintsForUser(this.mContext, userId);
    }

    public boolean hasEnrolledFingerprints(int userId) {
        if (userId != UserHandle.getCallingUserId()) {
            this.checkPermission("android.permission.INTERACT_ACROSS_USERS");
        }
        return this.mFingerprintUtils.getFingerprintsForUser(this.mContext, userId).size() > 0;
    }

    boolean hasPermission(String permission2) {
        return this.getContext().checkCallingOrSelfPermission(permission2) == 0;
    }

    void checkPermission(String permission2) {
        this.getContext().enforceCallingOrSelfPermission(permission2, "Must have " + permission2 + " permission.");
    }

    int getEffectiveUserId(int userId) {
        UserManager um = UserManager.get(this.mContext);
        if (um != null) {
            long callingIdentity = Binder.clearCallingIdentity();
            userId = um.getCredentialOwnerProfile(userId);
            Binder.restoreCallingIdentity(callingIdentity);
        } else {
            Slog.e(TAG, "Unable to acquire UserManager");
        }
        return userId;
    }

    boolean isCurrentUserOrProfile(int userId) {
        UserManager um = UserManager.get(this.mContext);
        for (int profileId : um.getEnabledProfileIds(userId)) {
            if (profileId != userId) continue;
            return true;
        }
        return false;
    }

    private boolean isForegroundActivity(int uid, int pid) {
        try {
            List<ActivityManager.RunningAppProcessInfo> procs = ActivityManagerNative.getDefault().getRunningAppProcesses();
            int N = procs.size();
            for (int i = 0; i < N; ++i) {
                ActivityManager.RunningAppProcessInfo proc = procs.get(i);
                if (proc.pid != pid || proc.uid != uid || proc.importance != 100) continue;
                return true;
            }
        }
        catch (RemoteException e) {
            Slog.w(TAG, "am.getRunningAppProcesses() failed");
        }
        return false;
    }

    private boolean canUseFingerprint(String opPackageName, boolean foregroundOnly, int uid, int pid) {
        this.checkPermission("android.permission.USE_FINGERPRINT");
        if (this.isKeyguard(opPackageName)) {
            return true;
        }
        if (!this.isCurrentUserOrProfile(UserHandle.getCallingUserId())) {
            Slog.w(TAG, "Rejecting " + opPackageName + " ; not a current user or profile");
            return false;
        }
        if (this.mAppOps.noteOp(55, uid, opPackageName) != 0) {
            Slog.w(TAG, "Rejecting " + opPackageName + " ; permission denied");
            return false;
        }
        if (foregroundOnly && !this.isForegroundActivity(uid, pid)) {
            Slog.w(TAG, "Rejecting " + opPackageName + " ; not in foreground");
            return false;
        }
        return true;
    }

    private boolean isKeyguard(String clientPackage) {
        return this.mKeyguardPackage.equals(clientPackage);
    }

    private void addLockoutResetMonitor(FingerprintServiceLockoutResetMonitor monitor) {
        if (!this.mLockoutMonitors.contains(monitor)) {
            this.mLockoutMonitors.add(monitor);
        }
    }

    private void removeLockoutResetCallback(FingerprintServiceLockoutResetMonitor monitor) {
        this.mLockoutMonitors.remove(monitor);
    }

    private void notifyLockoutResetMonitors() {
        for (int i = 0; i < this.mLockoutMonitors.size(); ++i) {
            this.mLockoutMonitors.get(i).sendLockoutReset();
        }
    }

    private void startAuthentication(IBinder token, long opId, int callingUserId, int groupId, IFingerprintServiceReceiver receiver, int flags, boolean restricted, String opPackageName) {
        this.updateActiveGroup(groupId, opPackageName);
        Slog.v(TAG, "startAuthentication(" + opPackageName + ")");
        AuthenticationClient client = new AuthenticationClient(this.getContext(), this.mHalDeviceId, token, receiver, callingUserId, groupId, opId, restricted, opPackageName){

            @Override
            public boolean handleFailedAttempt() {
                FingerprintService.this.mFailedAttempts++;
                if (FingerprintService.this.inLockoutMode()) {
                    FingerprintService.this.scheduleLockoutReset();
                    return true;
                }
                return false;
            }

            @Override
            public void resetFailedAttempts() {
                FingerprintService.this.resetFailedAttempts();
            }

            @Override
            public void notifyUserActivity() {
                FingerprintService.this.userActivity();
            }

            @Override
            public IFingerprintDaemon getFingerprintDaemon() {
                return FingerprintService.this.getFingerprintDaemon();
            }
        };
        if (this.inLockoutMode()) {
            Slog.v(TAG, "In lockout mode; disallowing authentication");
            if (!client.onError(7)) {
                Slog.w(TAG, "Cannot send timeout message to client");
            }
            return;
        }
        this.startClient(client, true);
    }

    private void startEnrollment(IBinder token, byte[] cryptoToken, int userId, IFingerprintServiceReceiver receiver, int flags, boolean restricted, String opPackageName) {
        this.updateActiveGroup(userId, opPackageName);
        int groupId = userId;
        EnrollClient client = new EnrollClient(this.getContext(), this.mHalDeviceId, token, receiver, userId, groupId, cryptoToken, restricted, opPackageName){

            @Override
            public IFingerprintDaemon getFingerprintDaemon() {
                return FingerprintService.this.getFingerprintDaemon();
            }

            @Override
            public void notifyUserActivity() {
                FingerprintService.this.userActivity();
            }
        };
        this.startClient(client, true);
    }

    protected void resetFailedAttempts() {
        if (this.inLockoutMode()) {
            Slog.v(TAG, "Reset fingerprint lockout");
        }
        this.mFailedAttempts = 0;
        this.cancelLockoutReset();
        this.notifyLockoutResetMonitors();
    }

    private void dumpInternal(PrintWriter pw) {
        JSONObject dump = new JSONObject();
        try {
            dump.put("service", "Fingerprint Manager");
            JSONArray sets = new JSONArray();
            for (UserInfo user : UserManager.get(this.getContext()).getUsers()) {
                int userId = user.getUserHandle().getIdentifier();
                int N = this.mFingerprintUtils.getFingerprintsForUser(this.mContext, userId).size();
                JSONObject set = new JSONObject();
                set.put("id", userId);
                set.put("count", N);
                sets.put(set);
            }
            dump.put("prints", sets);
        }
        catch (JSONException e) {
            Slog.e(TAG, "dump formatting failure", e);
        }
        pw.println(dump);
    }

    @Override
    public void onStart() {
        this.publishBinderService("fingerprint", new FingerprintServiceWrapper());
        IFingerprintDaemon daemon = this.getFingerprintDaemon();
        Slog.v(TAG, "Fingerprint HAL id: " + this.mHalDeviceId);
        this.listenForUserSwitches();
    }

    private void updateActiveGroup(int userId, String clientPackage) {
        IFingerprintDaemon daemon = this.getFingerprintDaemon();
        if (daemon != null) {
            try {
                userId = this.getUserOrWorkProfileId(clientPackage, userId);
                if (userId != this.mCurrentUserId) {
                    File systemDir = Environment.getUserSystemDirectory(userId);
                    File fpDir = new File(systemDir, FP_DATA_DIR);
                    if (!fpDir.exists()) {
                        if (!fpDir.mkdir()) {
                            Slog.v(TAG, "Cannot make directory: " + fpDir.getAbsolutePath());
                            return;
                        }
                        if (!SELinux.restorecon(fpDir)) {
                            Slog.w(TAG, "Restorecons failed. Directory will have wrong label.");
                            return;
                        }
                    }
                    daemon.setActiveGroup(userId, fpDir.getAbsolutePath().getBytes());
                    this.mCurrentUserId = userId;
                }
                this.mCurrentAuthenticatorId = daemon.getAuthenticatorId();
            }
            catch (RemoteException e) {
                Slog.e(TAG, "Failed to setActiveGroup():", e);
            }
        }
    }

    private int getUserOrWorkProfileId(String clientPackage, int userId) {
        if (!this.isKeyguard(clientPackage) && this.isWorkProfile(userId)) {
            return userId;
        }
        return this.getEffectiveUserId(userId);
    }

    private boolean isWorkProfile(int userId) {
        UserInfo info = this.mUserManager.getUserInfo(userId);
        return info != null && info.isManagedProfile();
    }

    private void listenForUserSwitches() {
        try {
            ActivityManagerNative.getDefault().registerUserSwitchObserver(new SynchronousUserSwitchObserver(){

                @Override
                public void onUserSwitching(int newUserId) throws RemoteException {
                    FingerprintService.this.mHandler.obtainMessage(10, newUserId, 0).sendToTarget();
                }

                @Override
                public void onUserSwitchComplete(int newUserId) throws RemoteException {
                }

                @Override
                public void onForegroundProfileSwitch(int newProfileId) {
                }
            });
        }
        catch (RemoteException e) {
            Slog.w(TAG, "Failed to listen for user switching event", e);
        }
    }

    public long getAuthenticatorId(String opPackageName) {
        return this.mCurrentAuthenticatorId;
    }

    private final class FingerprintServiceWrapper
    extends IFingerprintService.Stub {
        private FingerprintServiceWrapper() {
        }

        @Override
        public long preEnroll(IBinder token) {
            FingerprintService.this.checkPermission("android.permission.MANAGE_FINGERPRINT");
            return FingerprintService.this.startPreEnroll(token);
        }

        @Override
        public int postEnroll(IBinder token) {
            FingerprintService.this.checkPermission("android.permission.MANAGE_FINGERPRINT");
            return FingerprintService.this.startPostEnroll(token);
        }

        @Override
        public void enroll(final IBinder token, final byte[] cryptoToken, final int userId, final IFingerprintServiceReceiver receiver, final int flags, final String opPackageName) {
            FingerprintService.this.checkPermission("android.permission.MANAGE_FINGERPRINT");
            int limit = FingerprintService.this.mContext.getResources().getInteger(17694873);
            int enrolled = FingerprintService.this.getEnrolledFingerprints(userId).size();
            if (enrolled >= limit) {
                Slog.w(FingerprintService.TAG, "Too many fingerprints registered");
                return;
            }
            if (!FingerprintService.this.isCurrentUserOrProfile(userId)) {
                return;
            }
            final boolean restricted = this.isRestricted();
            FingerprintService.this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    FingerprintService.this.startEnrollment(token, cryptoToken, userId, receiver, flags, restricted, opPackageName);
                }
            });
        }

        private boolean isRestricted() {
            boolean restricted = !FingerprintService.this.hasPermission("android.permission.MANAGE_FINGERPRINT");
            return restricted;
        }

        @Override
        public void cancelEnrollment(final IBinder token) {
            FingerprintService.this.checkPermission("android.permission.MANAGE_FINGERPRINT");
            FingerprintService.this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    ClientMonitor client = FingerprintService.this.mCurrentClient;
                    if (client instanceof EnrollClient && client.getToken() == token) {
                        client.stop(client.getToken() == token);
                    }
                }
            });
        }

        @Override
        public void authenticate(final IBinder token, final long opId, final int groupId, final IFingerprintServiceReceiver receiver, final int flags, final String opPackageName) {
            final int callingUid = Binder.getCallingUid();
            final int callingUserId = UserHandle.getCallingUserId();
            final int pid = Binder.getCallingPid();
            final boolean restricted = this.isRestricted();
            FingerprintService.this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    MetricsLogger.histogram(FingerprintService.this.mContext, "fingerprint_token", opId != 0L ? 1 : 0);
                    if (!FingerprintService.this.canUseFingerprint(opPackageName, true, callingUid, pid)) {
                        Slog.v(FingerprintService.TAG, "authenticate(): reject " + opPackageName);
                        return;
                    }
                    FingerprintService.this.startAuthentication(token, opId, callingUserId, groupId, receiver, flags, restricted, opPackageName);
                }
            });
        }

        @Override
        public void cancelAuthentication(final IBinder token, final String opPackageName) {
            final int uid = Binder.getCallingUid();
            final int pid = Binder.getCallingPid();
            FingerprintService.this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    if (!FingerprintService.this.canUseFingerprint(opPackageName, true, uid, pid)) {
                        Slog.v(FingerprintService.TAG, "cancelAuthentication(): reject " + opPackageName);
                    } else {
                        ClientMonitor client = FingerprintService.this.mCurrentClient;
                        if (client instanceof AuthenticationClient) {
                            if (client.getToken() == token) {
                                Slog.v(FingerprintService.TAG, "stop client " + client.getOwnerString());
                                client.stop(client.getToken() == token);
                            } else {
                                Slog.v(FingerprintService.TAG, "can't stop client " + client.getOwnerString() + " since tokens don't match");
                            }
                        } else if (client != null) {
                            Slog.v(FingerprintService.TAG, "can't cancel non-authenticating client " + client.getOwnerString());
                        }
                    }
                }
            });
        }

        @Override
        public void setActiveUser(final int userId) {
            FingerprintService.this.checkPermission("android.permission.MANAGE_FINGERPRINT");
            FingerprintService.this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    FingerprintService.this.updateActiveGroup(userId, null);
                }
            });
        }

        @Override
        public void remove(final IBinder token, final int fingerId, final int groupId, final int userId, final IFingerprintServiceReceiver receiver) {
            FingerprintService.this.checkPermission("android.permission.MANAGE_FINGERPRINT");
            final boolean restricted = this.isRestricted();
            FingerprintService.this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    FingerprintService.this.startRemove(token, fingerId, groupId, userId, receiver, restricted);
                }
            });
        }

        @Override
        public boolean isHardwareDetected(long deviceId, String opPackageName) {
            if (!FingerprintService.this.canUseFingerprint(opPackageName, false, Binder.getCallingUid(), Binder.getCallingPid())) {
                return false;
            }
            return FingerprintService.this.mHalDeviceId != 0L;
        }

        @Override
        public void rename(final int fingerId, final int groupId, final String name) {
            FingerprintService.this.checkPermission("android.permission.MANAGE_FINGERPRINT");
            if (!FingerprintService.this.isCurrentUserOrProfile(groupId)) {
                return;
            }
            FingerprintService.this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    FingerprintService.this.mFingerprintUtils.renameFingerprintForUser(FingerprintService.this.mContext, fingerId, groupId, name);
                }
            });
        }

        @Override
        public List<Fingerprint> getEnrolledFingerprints(int userId, String opPackageName) {
            if (!FingerprintService.this.canUseFingerprint(opPackageName, false, Binder.getCallingUid(), Binder.getCallingPid())) {
                return Collections.emptyList();
            }
            if (!FingerprintService.this.isCurrentUserOrProfile(userId)) {
                return Collections.emptyList();
            }
            return FingerprintService.this.getEnrolledFingerprints(userId);
        }

        @Override
        public boolean hasEnrolledFingerprints(int userId, String opPackageName) {
            if (!FingerprintService.this.canUseFingerprint(opPackageName, false, Binder.getCallingUid(), Binder.getCallingPid())) {
                return false;
            }
            if (!FingerprintService.this.isCurrentUserOrProfile(userId)) {
                return false;
            }
            return FingerprintService.this.hasEnrolledFingerprints(userId);
        }

        @Override
        public long getAuthenticatorId(String opPackageName) {
            return FingerprintService.this.getAuthenticatorId(opPackageName);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
            if (FingerprintService.this.mContext.checkCallingOrSelfPermission("android.permission.DUMP") != 0) {
                pw.println("Permission Denial: can't dump Fingerprint from from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid());
                return;
            }
            long ident = Binder.clearCallingIdentity();
            try {
                FingerprintService.this.dumpInternal(pw);
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }

        @Override
        public void resetTimeout(byte[] token) {
            FingerprintService.this.checkPermission("android.permission.RESET_FINGERPRINT_LOCKOUT");
            FingerprintService.this.mHandler.post(FingerprintService.this.mResetFailedAttemptsRunnable);
        }

        @Override
        public void addLockoutResetCallback(final IFingerprintServiceLockoutResetCallback callback) throws RemoteException {
            FingerprintService.this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    FingerprintService.this.addLockoutResetMonitor(new FingerprintServiceLockoutResetMonitor(callback));
                }
            });
        }
    }

    private class FingerprintServiceLockoutResetMonitor {
        private final IFingerprintServiceLockoutResetCallback mCallback;
        private final Runnable mRemoveCallbackRunnable = new Runnable(){

            @Override
            public void run() {
                FingerprintService.this.removeLockoutResetCallback(FingerprintServiceLockoutResetMonitor.this);
            }
        };

        public FingerprintServiceLockoutResetMonitor(IFingerprintServiceLockoutResetCallback callback) {
            this.mCallback = callback;
        }

        public void sendLockoutReset() {
            if (this.mCallback != null) {
                try {
                    this.mCallback.onLockoutReset(FingerprintService.this.mHalDeviceId);
                }
                catch (DeadObjectException e) {
                    Slog.w(FingerprintService.TAG, "Death object while invoking onLockoutReset: ", e);
                    FingerprintService.this.mHandler.post(this.mRemoveCallbackRunnable);
                }
                catch (RemoteException e) {
                    Slog.w(FingerprintService.TAG, "Failed to invoke onLockoutReset: ", e);
                }
            }
        }
    }
}

