/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.fingerprint;

import android.content.Context;
import android.hardware.fingerprint.IFingerprintDaemon;
import android.hardware.fingerprint.IFingerprintServiceReceiver;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Slog;
import com.android.internal.logging.MetricsLogger;
import com.android.server.fingerprint.ClientMonitor;
import com.android.server.fingerprint.FingerprintUtils;
import java.util.Arrays;

public abstract class EnrollClient
extends ClientMonitor {
    private static final long MS_PER_SEC = 1000L;
    private static final int ENROLLMENT_TIMEOUT_MS = 60000;
    private byte[] mCryptoToken;

    public EnrollClient(Context context, long halDeviceId, IBinder token, IFingerprintServiceReceiver receiver, int userId, int groupId, byte[] cryptoToken, boolean restricted, String owner) {
        super(context, halDeviceId, token, receiver, userId, groupId, restricted, owner);
        this.mCryptoToken = Arrays.copyOf(cryptoToken, cryptoToken.length);
    }

    @Override
    public boolean onEnrollResult(int fingerId, int groupId, int remaining) {
        if (groupId != this.getGroupId()) {
            Slog.w("FingerprintService", "groupId != getGroupId(), groupId: " + groupId + " getGroupId():" + this.getGroupId());
        }
        if (remaining == 0) {
            FingerprintUtils.getInstance().addFingerprintForUser(this.getContext(), fingerId, this.getTargetUserId());
        }
        return this.sendEnrollResult(fingerId, groupId, remaining);
    }

    private boolean sendEnrollResult(int fpId, int groupId, int remaining) {
        IFingerprintServiceReceiver receiver = this.getReceiver();
        if (receiver == null) {
            return true;
        }
        FingerprintUtils.vibrateFingerprintSuccess(this.getContext());
        MetricsLogger.action(this.getContext(), 251);
        try {
            receiver.onEnrollResult(this.getHalDeviceId(), fpId, groupId, remaining);
            return remaining == 0;
        }
        catch (RemoteException e) {
            Slog.w("FingerprintService", "Failed to notify EnrollResult:", e);
            return true;
        }
    }

    @Override
    public int start() {
        IFingerprintDaemon daemon = this.getFingerprintDaemon();
        if (daemon == null) {
            Slog.w("FingerprintService", "enroll: no fingeprintd!");
            return 3;
        }
        int timeout = 60;
        try {
            int result = daemon.enroll(this.mCryptoToken, this.getGroupId(), 60);
            if (result != 0) {
                Slog.w("FingerprintService", "startEnroll failed, result=" + result);
                this.onError(1);
                return result;
            }
        }
        catch (RemoteException e) {
            Slog.e("FingerprintService", "startEnroll failed", e);
        }
        return 0;
    }

    @Override
    public int stop(boolean initiatedByClient) {
        IFingerprintDaemon daemon = this.getFingerprintDaemon();
        if (daemon == null) {
            Slog.w("FingerprintService", "stopEnrollment: no fingeprintd!");
            return 3;
        }
        try {
            int result = daemon.cancelEnrollment();
            if (result != 0) {
                Slog.w("FingerprintService", "startEnrollCancel failed, result = " + result);
                return result;
            }
        }
        catch (RemoteException e) {
            Slog.e("FingerprintService", "stopEnrollment failed", e);
        }
        if (initiatedByClient) {
            this.onError(5);
        }
        return 0;
    }

    @Override
    public boolean onRemoved(int fingerId, int groupId) {
        Slog.w("FingerprintService", "onRemoved() called for enroll!");
        return true;
    }

    @Override
    public boolean onEnumerationResult(int fingerId, int groupId) {
        Slog.w("FingerprintService", "onEnumerationResult() called for enroll!");
        return true;
    }

    @Override
    public boolean onAuthenticated(int fingerId, int groupId) {
        Slog.w("FingerprintService", "onAuthenticated() called for enroll!");
        return true;
    }
}

