/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.display;

import android.content.Context;
import android.content.res.Resources;
import android.os.Build;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.SystemProperties;
import android.os.Trace;
import android.util.Slog;
import android.util.SparseArray;
import android.view.Display;
import android.view.DisplayEventReceiver;
import android.view.SurfaceControl;
import com.android.server.LocalServices;
import com.android.server.display.DisplayAdapter;
import com.android.server.display.DisplayDevice;
import com.android.server.display.DisplayDeviceInfo;
import com.android.server.display.DisplayManagerService;
import com.android.server.lights.Light;
import com.android.server.lights.LightsManager;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;

final class LocalDisplayAdapter
extends DisplayAdapter {
    private static final String TAG = "LocalDisplayAdapter";
    private static final boolean DEBUG = false;
    private static final String UNIQUE_ID_PREFIX = "local:";
    private static final String PROPERTY_EMULATOR_CIRCULAR = "ro.emulator.circular";
    private static final int[] BUILT_IN_DISPLAY_IDS_TO_SCAN = new int[]{0, 1};
    private final SparseArray<LocalDisplayDevice> mDevices = new SparseArray();
    private HotplugDisplayEventReceiver mHotplugReceiver;

    public LocalDisplayAdapter(DisplayManagerService.SyncRoot syncRoot, Context context, Handler handler, DisplayAdapter.Listener listener) {
        super(syncRoot, context, handler, listener, TAG);
    }

    @Override
    public void registerLocked() {
        super.registerLocked();
        this.mHotplugReceiver = new HotplugDisplayEventReceiver(this.getHandler().getLooper());
        for (int builtInDisplayId : BUILT_IN_DISPLAY_IDS_TO_SCAN) {
            this.tryConnectDisplayLocked(builtInDisplayId);
        }
    }

    private void tryConnectDisplayLocked(int builtInDisplayId) {
        IBinder displayToken = SurfaceControl.getBuiltInDisplay(builtInDisplayId);
        if (displayToken != null) {
            SurfaceControl.PhysicalDisplayInfo[] configs = SurfaceControl.getDisplayConfigs(displayToken);
            if (configs == null) {
                Slog.w(TAG, "No valid configs found for display device " + builtInDisplayId);
                return;
            }
            int activeConfig = SurfaceControl.getActiveConfig(displayToken);
            if (activeConfig < 0) {
                Slog.w(TAG, "No active config found for display device " + builtInDisplayId);
                return;
            }
            LocalDisplayDevice device = this.mDevices.get(builtInDisplayId);
            if (device == null) {
                device = new LocalDisplayDevice(displayToken, builtInDisplayId, configs, activeConfig);
                this.mDevices.put(builtInDisplayId, device);
                this.sendDisplayDeviceEventLocked(device, 1);
            } else if (device.updatePhysicalDisplayInfoLocked(configs, activeConfig)) {
                this.sendDisplayDeviceEventLocked(device, 2);
            }
        }
    }

    private void tryDisconnectDisplayLocked(int builtInDisplayId) {
        LocalDisplayDevice device = this.mDevices.get(builtInDisplayId);
        if (device != null) {
            this.mDevices.remove(builtInDisplayId);
            this.sendDisplayDeviceEventLocked(device, 3);
        }
    }

    static int getPowerModeForState(int state) {
        switch (state) {
            case 1: {
                return 0;
            }
            case 3: {
                return 1;
            }
            case 4: {
                return 3;
            }
        }
        return 2;
    }

    private final class HotplugDisplayEventReceiver
    extends DisplayEventReceiver {
        public HotplugDisplayEventReceiver(Looper looper) {
            super(looper);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onHotplug(long timestampNanos, int builtInDisplayId, boolean connected) {
            DisplayManagerService.SyncRoot syncRoot = LocalDisplayAdapter.this.getSyncRoot();
            synchronized (syncRoot) {
                if (connected) {
                    LocalDisplayAdapter.this.tryConnectDisplayLocked(builtInDisplayId);
                } else {
                    LocalDisplayAdapter.this.tryDisconnectDisplayLocked(builtInDisplayId);
                }
            }
        }
    }

    private static final class DisplayModeRecord {
        public final Display.Mode mMode;

        public DisplayModeRecord(SurfaceControl.PhysicalDisplayInfo phys) {
            this.mMode = DisplayAdapter.createMode(phys.width, phys.height, phys.refreshRate);
        }

        public boolean hasMatchingMode(SurfaceControl.PhysicalDisplayInfo info) {
            int modeRefreshRate = Float.floatToIntBits(this.mMode.getRefreshRate());
            int displayInfoRefreshRate = Float.floatToIntBits(info.refreshRate);
            return this.mMode.getPhysicalWidth() == info.width && this.mMode.getPhysicalHeight() == info.height && modeRefreshRate == displayInfoRefreshRate;
        }

        public String toString() {
            return "DisplayModeRecord{mMode=" + this.mMode + "}";
        }
    }

    private final class LocalDisplayDevice
    extends DisplayDevice {
        private final int mBuiltInDisplayId;
        private final Light mBacklight;
        private final SparseArray<DisplayModeRecord> mSupportedModes;
        private final SparseArray<Display.ColorTransform> mSupportedColorTransforms;
        private DisplayDeviceInfo mInfo;
        private boolean mHavePendingChanges;
        private int mState;
        private int mBrightness;
        private int mActivePhysIndex;
        private int mDefaultModeId;
        private int mActiveModeId;
        private boolean mActiveModeInvalid;
        private int mDefaultColorTransformId;
        private int mActiveColorTransformId;
        private boolean mActiveColorTransformInvalid;
        private Display.HdrCapabilities mHdrCapabilities;
        private SurfaceControl.PhysicalDisplayInfo[] mDisplayInfos;

        public LocalDisplayDevice(IBinder displayToken, int builtInDisplayId, SurfaceControl.PhysicalDisplayInfo[] physicalDisplayInfos, int activeDisplayInfo) {
            super(LocalDisplayAdapter.this, displayToken, LocalDisplayAdapter.UNIQUE_ID_PREFIX + builtInDisplayId);
            this.mSupportedModes = new SparseArray();
            this.mSupportedColorTransforms = new SparseArray();
            this.mState = 0;
            this.mBrightness = -1;
            this.mBuiltInDisplayId = builtInDisplayId;
            this.updatePhysicalDisplayInfoLocked(physicalDisplayInfos, activeDisplayInfo);
            if (this.mBuiltInDisplayId == 0) {
                LightsManager lights = LocalServices.getService(LightsManager.class);
                this.mBacklight = lights.getLight(0);
            } else {
                this.mBacklight = null;
            }
            this.mHdrCapabilities = SurfaceControl.getHdrCapabilities(displayToken);
        }

        public boolean updatePhysicalDisplayInfoLocked(SurfaceControl.PhysicalDisplayInfo[] physicalDisplayInfos, int activeDisplayInfo) {
            boolean recordsChanged;
            this.mDisplayInfos = Arrays.copyOf(physicalDisplayInfos, physicalDisplayInfos.length);
            this.mActivePhysIndex = activeDisplayInfo;
            ArrayList<Display.ColorTransform> colorTransforms = new ArrayList<Display.ColorTransform>();
            boolean colorTransformsAdded = false;
            Display.ColorTransform activeColorTransform = null;
            for (int i = 0; i < physicalDisplayInfos.length; ++i) {
                SurfaceControl.PhysicalDisplayInfo info = physicalDisplayInfos[i];
                boolean existingMode = false;
                for (int j = 0; j < colorTransforms.size(); ++j) {
                    if (((Display.ColorTransform)colorTransforms.get(j)).getColorTransform() != info.colorTransform) continue;
                    existingMode = true;
                    break;
                }
                if (existingMode) continue;
                Display.ColorTransform colorTransform = this.findColorTransform(info);
                if (colorTransform == null) {
                    colorTransform = DisplayAdapter.createColorTransform(info.colorTransform);
                    colorTransformsAdded = true;
                }
                colorTransforms.add(colorTransform);
                if (i != activeDisplayInfo) continue;
                activeColorTransform = colorTransform;
            }
            ArrayList<DisplayModeRecord> records = new ArrayList<DisplayModeRecord>();
            boolean modesAdded = false;
            for (int i = 0; i < physicalDisplayInfos.length; ++i) {
                SurfaceControl.PhysicalDisplayInfo info = physicalDisplayInfos[i];
                boolean existingMode = false;
                for (int j = 0; j < records.size(); ++j) {
                    if (!((DisplayModeRecord)records.get(j)).hasMatchingMode(info)) continue;
                    existingMode = true;
                    break;
                }
                if (existingMode) continue;
                DisplayModeRecord record = this.findDisplayModeRecord(info);
                if (record == null) {
                    record = new DisplayModeRecord(info);
                    modesAdded = true;
                }
                records.add(record);
            }
            DisplayModeRecord activeRecord = null;
            for (int i = 0; i < records.size(); ++i) {
                DisplayModeRecord record = (DisplayModeRecord)records.get(i);
                if (!record.hasMatchingMode(physicalDisplayInfos[activeDisplayInfo])) continue;
                activeRecord = record;
                break;
            }
            if (this.mActiveModeId != 0 && this.mActiveModeId != activeRecord.mMode.getModeId()) {
                this.mActiveModeInvalid = true;
                LocalDisplayAdapter.this.sendTraversalRequestLocked();
            }
            if (this.mActiveColorTransformId != 0 && this.mActiveColorTransformId != activeColorTransform.getId()) {
                this.mActiveColorTransformInvalid = true;
                LocalDisplayAdapter.this.sendTraversalRequestLocked();
            }
            boolean colorTransformsChanged = colorTransforms.size() != this.mSupportedColorTransforms.size() || colorTransformsAdded;
            boolean bl = recordsChanged = records.size() != this.mSupportedModes.size() || modesAdded;
            if (!recordsChanged && !colorTransformsChanged) {
                return false;
            }
            this.mHavePendingChanges = true;
            this.mSupportedModes.clear();
            for (DisplayModeRecord record : records) {
                this.mSupportedModes.put(record.mMode.getModeId(), record);
            }
            this.mSupportedColorTransforms.clear();
            for (Display.ColorTransform colorTransform : colorTransforms) {
                this.mSupportedColorTransforms.put(colorTransform.getId(), colorTransform);
            }
            if (this.findDisplayInfoIndexLocked(this.mDefaultColorTransformId, this.mDefaultModeId) < 0) {
                if (this.mDefaultModeId != 0) {
                    Slog.w(LocalDisplayAdapter.TAG, "Default display mode no longer available, using currently active mode as default.");
                }
                this.mDefaultModeId = activeRecord.mMode.getModeId();
                if (this.mDefaultColorTransformId != 0) {
                    Slog.w(LocalDisplayAdapter.TAG, "Default color transform no longer available, using currently active color transform as default");
                }
                this.mDefaultColorTransformId = activeColorTransform.getId();
            }
            if (this.mSupportedModes.indexOfKey(this.mActiveModeId) < 0) {
                if (this.mActiveModeId != 0) {
                    Slog.w(LocalDisplayAdapter.TAG, "Active display mode no longer available, reverting to default mode.");
                }
                this.mActiveModeId = this.mDefaultModeId;
                this.mActiveModeInvalid = true;
            }
            if (this.mSupportedColorTransforms.indexOfKey(this.mActiveColorTransformId) < 0) {
                if (this.mActiveColorTransformId != 0) {
                    Slog.w(LocalDisplayAdapter.TAG, "Active color transform no longer available, reverting to default transform.");
                }
                this.mActiveColorTransformId = this.mDefaultColorTransformId;
                this.mActiveColorTransformInvalid = true;
            }
            LocalDisplayAdapter.this.sendTraversalRequestLocked();
            return true;
        }

        private DisplayModeRecord findDisplayModeRecord(SurfaceControl.PhysicalDisplayInfo info) {
            for (int i = 0; i < this.mSupportedModes.size(); ++i) {
                DisplayModeRecord record = this.mSupportedModes.valueAt(i);
                if (!record.hasMatchingMode(info)) continue;
                return record;
            }
            return null;
        }

        private Display.ColorTransform findColorTransform(SurfaceControl.PhysicalDisplayInfo info) {
            for (int i = 0; i < this.mSupportedColorTransforms.size(); ++i) {
                Display.ColorTransform transform = this.mSupportedColorTransforms.valueAt(i);
                if (transform.getColorTransform() != info.colorTransform) continue;
                return transform;
            }
            return null;
        }

        @Override
        public void applyPendingDisplayDeviceInfoChangesLocked() {
            if (this.mHavePendingChanges) {
                this.mInfo = null;
                this.mHavePendingChanges = false;
            }
        }

        @Override
        public DisplayDeviceInfo getDisplayDeviceInfoLocked() {
            if (this.mInfo == null) {
                int i;
                SurfaceControl.PhysicalDisplayInfo phys = this.mDisplayInfos[this.mActivePhysIndex];
                this.mInfo = new DisplayDeviceInfo();
                this.mInfo.width = phys.width;
                this.mInfo.height = phys.height;
                this.mInfo.modeId = this.mActiveModeId;
                this.mInfo.defaultModeId = this.mDefaultModeId;
                this.mInfo.supportedModes = new Display.Mode[this.mSupportedModes.size()];
                for (i = 0; i < this.mSupportedModes.size(); ++i) {
                    DisplayModeRecord record = this.mSupportedModes.valueAt(i);
                    this.mInfo.supportedModes[i] = record.mMode;
                }
                this.mInfo.colorTransformId = this.mActiveColorTransformId;
                this.mInfo.defaultColorTransformId = this.mDefaultColorTransformId;
                this.mInfo.supportedColorTransforms = new Display.ColorTransform[this.mSupportedColorTransforms.size()];
                for (i = 0; i < this.mSupportedColorTransforms.size(); ++i) {
                    this.mInfo.supportedColorTransforms[i] = this.mSupportedColorTransforms.valueAt(i);
                }
                this.mInfo.hdrCapabilities = this.mHdrCapabilities;
                this.mInfo.appVsyncOffsetNanos = phys.appVsyncOffsetNanos;
                this.mInfo.presentationDeadlineNanos = phys.presentationDeadlineNanos;
                this.mInfo.state = this.mState;
                this.mInfo.uniqueId = this.getUniqueId();
                if (phys.secure) {
                    this.mInfo.flags = 12;
                }
                Resources res = LocalDisplayAdapter.this.getContext().getResources();
                if (this.mBuiltInDisplayId == 0) {
                    this.mInfo.name = res.getString(17040633);
                    this.mInfo.flags |= 3;
                    if (res.getBoolean(17957026) || Build.IS_EMULATOR && SystemProperties.getBoolean(LocalDisplayAdapter.PROPERTY_EMULATOR_CIRCULAR, false)) {
                        this.mInfo.flags |= 0x100;
                    }
                    this.mInfo.type = 1;
                    this.mInfo.densityDpi = (int)(phys.density * 160.0f + 0.5f);
                    this.mInfo.xDpi = phys.xDpi;
                    this.mInfo.yDpi = phys.yDpi;
                    this.mInfo.touch = 1;
                } else {
                    this.mInfo.type = 2;
                    this.mInfo.flags |= 0x40;
                    this.mInfo.name = LocalDisplayAdapter.this.getContext().getResources().getString(17040634);
                    this.mInfo.touch = 2;
                    this.mInfo.setAssumedDensityForExternalDisplay(phys.width, phys.height);
                    if ("portrait".equals(SystemProperties.get("persist.demo.hdmirotation"))) {
                        this.mInfo.rotation = 3;
                    }
                    if (SystemProperties.getBoolean("persist.demo.hdmirotates", false)) {
                        this.mInfo.flags |= 2;
                    }
                    if (!res.getBoolean(17956983)) {
                        this.mInfo.flags |= 0x80;
                    }
                }
            }
            return this.mInfo;
        }

        @Override
        public Runnable requestDisplayStateLocked(final int state, final int brightness) {
            boolean brightnessChanged;
            assert (state != 1 || brightness == 0);
            boolean stateChanged = this.mState != state;
            boolean bl = brightnessChanged = this.mBrightness != brightness && this.mBacklight != null;
            if (stateChanged || brightnessChanged) {
                final int displayId = this.mBuiltInDisplayId;
                final IBinder token = this.getDisplayTokenLocked();
                final int oldState = this.mState;
                if (stateChanged) {
                    this.mState = state;
                    this.updateDeviceInfoLocked();
                }
                if (brightnessChanged) {
                    this.mBrightness = brightness;
                }
                return new Runnable(){

                    @Override
                    public void run() {
                        int currentState = oldState;
                        if (Display.isSuspendedState(oldState) || oldState == 0) {
                            if (!Display.isSuspendedState(state)) {
                                this.setDisplayState(state);
                                currentState = state;
                            } else if (state == 4 || oldState == 4) {
                                this.setDisplayState(3);
                                currentState = 3;
                            } else {
                                return;
                            }
                        }
                        if (brightnessChanged) {
                            this.setDisplayBrightness(brightness);
                        }
                        if (state != currentState) {
                            this.setDisplayState(state);
                        }
                    }

                    private void setDisplayState(int state2) {
                        Trace.traceBegin(131072L, "setDisplayState(id=" + displayId + ", state=" + Display.stateToString(state2) + ")");
                        try {
                            int mode = LocalDisplayAdapter.getPowerModeForState(state2);
                            SurfaceControl.setDisplayPowerMode(token, mode);
                        }
                        finally {
                            Trace.traceEnd(131072L);
                        }
                    }

                    private void setDisplayBrightness(int brightness2) {
                        Trace.traceBegin(131072L, "setDisplayBrightness(id=" + displayId + ", brightness=" + brightness2 + ")");
                        try {
                            LocalDisplayDevice.this.mBacklight.setBrightness(brightness2);
                        }
                        finally {
                            Trace.traceEnd(131072L);
                        }
                    }
                };
            }
            return null;
        }

        @Override
        public void requestColorTransformAndModeInTransactionLocked(int colorTransformId, int modeId) {
            if (modeId == 0) {
                modeId = this.mDefaultModeId;
            } else if (this.mSupportedModes.indexOfKey(modeId) < 0) {
                Slog.w(LocalDisplayAdapter.TAG, "Requested mode " + modeId + " is not supported by this display, reverting to default display mode.");
                modeId = this.mDefaultModeId;
            }
            if (colorTransformId == 0) {
                colorTransformId = this.mDefaultColorTransformId;
            } else if (this.mSupportedColorTransforms.indexOfKey(colorTransformId) < 0) {
                Slog.w(LocalDisplayAdapter.TAG, "Requested color transform " + colorTransformId + " is not supported by this display, reverting to the default color transform");
                colorTransformId = this.mDefaultColorTransformId;
            }
            int physIndex = this.findDisplayInfoIndexLocked(colorTransformId, modeId);
            if (physIndex < 0) {
                Slog.w(LocalDisplayAdapter.TAG, "Requested color transform, mode ID pair (" + colorTransformId + ", " + modeId + ") not available, trying color transform with default mode ID");
                modeId = this.mDefaultModeId;
                physIndex = this.findDisplayInfoIndexLocked(colorTransformId, modeId);
                if (physIndex < 0) {
                    Slog.w(LocalDisplayAdapter.TAG, "Requested color transform with default mode ID still not available, falling back to default color transform with default mode.");
                    colorTransformId = this.mDefaultColorTransformId;
                    physIndex = this.findDisplayInfoIndexLocked(colorTransformId, modeId);
                }
            }
            if (this.mActivePhysIndex == physIndex) {
                return;
            }
            SurfaceControl.setActiveConfig(this.getDisplayTokenLocked(), physIndex);
            this.mActivePhysIndex = physIndex;
            this.mActiveModeId = modeId;
            this.mActiveModeInvalid = false;
            this.mActiveColorTransformId = colorTransformId;
            this.mActiveColorTransformInvalid = false;
            this.updateDeviceInfoLocked();
        }

        @Override
        public void dumpLocked(PrintWriter pw) {
            int i;
            super.dumpLocked(pw);
            pw.println("mBuiltInDisplayId=" + this.mBuiltInDisplayId);
            pw.println("mActivePhysIndex=" + this.mActivePhysIndex);
            pw.println("mActiveModeId=" + this.mActiveModeId);
            pw.println("mActiveColorTransformId=" + this.mActiveColorTransformId);
            pw.println("mState=" + Display.stateToString(this.mState));
            pw.println("mBrightness=" + this.mBrightness);
            pw.println("mBacklight=" + this.mBacklight);
            pw.println("mDisplayInfos=");
            for (i = 0; i < this.mDisplayInfos.length; ++i) {
                pw.println("  " + this.mDisplayInfos[i]);
            }
            pw.println("mSupportedModes=");
            for (i = 0; i < this.mSupportedModes.size(); ++i) {
                pw.println("  " + this.mSupportedModes.valueAt(i));
            }
            pw.println("mSupportedColorTransforms=[");
            for (i = 0; i < this.mSupportedColorTransforms.size(); ++i) {
                if (i != 0) {
                    pw.print(", ");
                }
                pw.print(this.mSupportedColorTransforms.valueAt(i));
            }
            pw.println("]");
        }

        private int findDisplayInfoIndexLocked(int colorTransformId, int modeId) {
            DisplayModeRecord record = this.mSupportedModes.get(modeId);
            Display.ColorTransform transform = this.mSupportedColorTransforms.get(colorTransformId);
            if (record != null && transform != null) {
                for (int i = 0; i < this.mDisplayInfos.length; ++i) {
                    SurfaceControl.PhysicalDisplayInfo info = this.mDisplayInfos[i];
                    if (info.colorTransform != transform.getColorTransform() || !record.hasMatchingMode(info)) continue;
                    return i;
                }
            }
            return -1;
        }

        private void updateDeviceInfoLocked() {
            this.mInfo = null;
            LocalDisplayAdapter.this.sendDisplayDeviceEventLocked(this, 2);
        }
    }
}

