/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.devicepolicy;

import android.accessibilityservice.AccessibilityServiceInfo;
import android.accounts.AccountManager;
import android.annotation.IntDef;
import android.app.ActivityManagerNative;
import android.app.AlarmManager;
import android.app.AppGlobals;
import android.app.IActivityManager;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.app.admin.DeviceAdminInfo;
import android.app.admin.DevicePolicyManagerInternal;
import android.app.admin.IDevicePolicyManager;
import android.app.admin.SecurityLog;
import android.app.admin.SystemUpdatePolicy;
import android.app.backup.IBackupManager;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ActivityInfo;
import android.content.pm.ApplicationInfo;
import android.content.pm.IPackageManager;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.PackageManagerInternal;
import android.content.pm.ParceledListSlice;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.content.pm.UserInfo;
import android.database.ContentObserver;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.media.AudioManager;
import android.media.IAudioService;
import android.net.ConnectivityManager;
import android.net.ProxyInfo;
import android.net.Uri;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.AsyncTask;
import android.os.Binder;
import android.os.Bundle;
import android.os.Environment;
import android.os.FileUtils;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.os.PersistableBundle;
import android.os.PowerManager;
import android.os.PowerManagerInternal;
import android.os.Process;
import android.os.RecoverySystem;
import android.os.RemoteCallback;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.os.UserHandle;
import android.os.UserManager;
import android.os.UserManagerInternal;
import android.os.storage.StorageManager;
import android.provider.ContactsContract;
import android.provider.ContactsInternal;
import android.provider.Settings;
import android.security.Credentials;
import android.security.IKeyChainAliasCallback;
import android.security.IKeyChainService;
import android.security.KeyChain;
import android.service.persistentdata.PersistentDataBlockManager;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.Log;
import android.util.Pair;
import android.util.Slog;
import android.util.SparseArray;
import android.util.Xml;
import android.view.IWindowManager;
import android.view.accessibility.AccessibilityManager;
import android.view.accessibility.IAccessibilityManager;
import android.view.inputmethod.InputMethodInfo;
import android.view.inputmethod.InputMethodManager;
import com.android.internal.statusbar.IStatusBarService;
import com.android.internal.util.FastXmlSerializer;
import com.android.internal.util.JournaledFile;
import com.android.internal.util.ParcelableString;
import com.android.internal.util.Preconditions;
import com.android.internal.util.XmlUtils;
import com.android.internal.widget.LockPatternUtils;
import com.android.server.LocalServices;
import com.android.server.SystemService;
import com.android.server.devicepolicy.Owners;
import com.android.server.devicepolicy.RemoteBugreportUtils;
import com.android.server.devicepolicy.SecurityLogMonitor;
import com.android.server.pm.UserRestrictionsUtils;
import com.google.android.collect.Sets;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.nio.charset.StandardCharsets;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public class DevicePolicyManagerService
extends IDevicePolicyManager.Stub {
    private static final String LOG_TAG = "DevicePolicyManagerService";
    private static final boolean VERBOSE_LOG = false;
    private static final String DEVICE_POLICIES_XML = "device_policies.xml";
    private static final String TAG_ACCEPTED_CA_CERTIFICATES = "accepted-ca-certificate";
    private static final String TAG_LOCK_TASK_COMPONENTS = "lock-task-component";
    private static final String TAG_STATUS_BAR = "statusbar";
    private static final String ATTR_DISABLED = "disabled";
    private static final String ATTR_NAME = "name";
    private static final String DO_NOT_ASK_CREDENTIALS_ON_BOOT_XML = "do-not-ask-credentials-on-boot";
    private static final String TAG_AFFILIATION_ID = "affiliation-id";
    private static final String TAG_ADMIN_BROADCAST_PENDING = "admin-broadcast-pending";
    private static final String ATTR_VALUE = "value";
    private static final String TAG_INITIALIZATION_BUNDLE = "initialization-bundle";
    private static final int REQUEST_EXPIRE_PASSWORD = 5571;
    private static final long MS_PER_DAY = 86400000L;
    private static final long EXPIRATION_GRACE_PERIOD_MS = 432000000L;
    private static final String ACTION_EXPIRED_PASSWORD_NOTIFICATION = "com.android.server.ACTION_EXPIRED_PASSWORD_NOTIFICATION";
    private static final int MONITORING_CERT_NOTIFICATION_ID = 0x1140001;
    private static final int PROFILE_WIPED_NOTIFICATION_ID = 1001;
    private static final String ATTR_PERMISSION_PROVIDER = "permission-provider";
    private static final String ATTR_SETUP_COMPLETE = "setup-complete";
    private static final String ATTR_PROVISIONING_STATE = "provisioning-state";
    private static final String ATTR_PERMISSION_POLICY = "permission-policy";
    private static final String ATTR_DELEGATED_CERT_INSTALLER = "delegated-cert-installer";
    private static final String ATTR_APPLICATION_RESTRICTIONS_MANAGER = "application-restrictions-manager";
    private static final String PROPERTY_DEVICE_OWNER_PRESENT = "ro.device_owner";
    private static final int STATUS_BAR_DISABLE_MASK = 0x2070000;
    private static final int STATUS_BAR_DISABLE2_MASK = 1;
    private static final Set<String> SECURE_SETTINGS_WHITELIST = new ArraySet<String>();
    private static final Set<String> SECURE_SETTINGS_DEVICEOWNER_WHITELIST;
    private static final Set<String> GLOBAL_SETTINGS_WHITELIST;
    private static final Set<String> GLOBAL_SETTINGS_DEPRECATED;
    private static final int PROFILE_KEYGUARD_FEATURES_AFFECT_OWNER = 48;
    private static final int PROFILE_KEYGUARD_FEATURES_PROFILE_ONLY = 8;
    private static final int PROFILE_KEYGUARD_FEATURES = 56;
    private static final int CODE_OK = 0;
    private static final int CODE_HAS_DEVICE_OWNER = 1;
    private static final int CODE_USER_HAS_PROFILE_OWNER = 2;
    private static final int CODE_USER_NOT_RUNNING = 3;
    private static final int CODE_USER_SETUP_COMPLETED = 4;
    private static final int CODE_NONSYSTEM_USER_EXISTS = 5;
    private static final int CODE_ACCOUNTS_NOT_EMPTY = 6;
    private static final int CODE_NOT_SYSTEM_USER = 7;
    private static final int DEVICE_ADMIN_DEACTIVATE_TIMEOUT = 10000;
    final Context mContext;
    final Injector mInjector;
    final IPackageManager mIPackageManager;
    final UserManager mUserManager;
    final UserManagerInternal mUserManagerInternal;
    final TelephonyManager mTelephonyManager;
    private final LockPatternUtils mLockPatternUtils;
    private final Set<Pair<String, Integer>> mPackagesToRemove = new ArraySet<Pair<String, Integer>>();
    final LocalService mLocalService;
    final Owners mOwners;
    private final Binder mToken = new Binder();
    boolean mHasFeature;
    private final SecurityLogMonitor mSecurityLogMonitor;
    private final AtomicBoolean mRemoteBugreportServiceIsActive = new AtomicBoolean();
    private final AtomicBoolean mRemoteBugreportSharingAccepted = new AtomicBoolean();
    private final Runnable mRemoteBugreportTimeoutRunnable = new Runnable(){

        @Override
        public void run() {
            if (DevicePolicyManagerService.this.mRemoteBugreportServiceIsActive.get()) {
                DevicePolicyManagerService.this.onBugreportFailed();
            }
        }
    };
    private final BroadcastReceiver mRemoteBugreportFinishedReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            if ("android.intent.action.REMOTE_BUGREPORT_DISPATCH".equals(intent.getAction()) && DevicePolicyManagerService.this.mRemoteBugreportServiceIsActive.get()) {
                DevicePolicyManagerService.this.onBugreportFinished(intent);
            }
        }
    };
    private final BroadcastReceiver mRemoteBugreportConsentReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            DevicePolicyManagerService.this.mInjector.getNotificationManager().cancel(DevicePolicyManagerService.LOG_TAG, 678432343);
            if ("com.android.server.action.BUGREPORT_SHARING_ACCEPTED".equals(action)) {
                DevicePolicyManagerService.this.onBugreportSharingAccepted();
            } else if ("com.android.server.action.BUGREPORT_SHARING_DECLINED".equals(action)) {
                DevicePolicyManagerService.this.onBugreportSharingDeclined();
            }
            DevicePolicyManagerService.this.mContext.unregisterReceiver(DevicePolicyManagerService.this.mRemoteBugreportConsentReceiver);
        }
    };
    final SparseArray<DevicePolicyData> mUserData = new SparseArray();
    final Handler mHandler;
    BroadcastReceiver mReceiver = new BroadcastReceiver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            final int userHandle = intent.getIntExtra("android.intent.extra.user_handle", this.getSendingUserId());
            if ("android.intent.action.BOOT_COMPLETED".equals(action) && userHandle == DevicePolicyManagerService.this.mOwners.getDeviceOwnerUserId() && DevicePolicyManagerService.this.getDeviceOwnerRemoteBugreportUri() != null) {
                IntentFilter filterConsent = new IntentFilter();
                filterConsent.addAction("com.android.server.action.BUGREPORT_SHARING_DECLINED");
                filterConsent.addAction("com.android.server.action.BUGREPORT_SHARING_ACCEPTED");
                DevicePolicyManagerService.this.mContext.registerReceiver(DevicePolicyManagerService.this.mRemoteBugreportConsentReceiver, filterConsent);
                DevicePolicyManagerService.this.mInjector.getNotificationManager().notifyAsUser(DevicePolicyManagerService.LOG_TAG, 678432343, RemoteBugreportUtils.buildNotification(DevicePolicyManagerService.this.mContext, 3), UserHandle.ALL);
            }
            if ("android.intent.action.BOOT_COMPLETED".equals(action) || DevicePolicyManagerService.ACTION_EXPIRED_PASSWORD_NOTIFICATION.equals(action)) {
                DevicePolicyManagerService.this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        DevicePolicyManagerService.this.handlePasswordExpirationNotification(userHandle);
                    }
                });
            }
            if ("android.intent.action.USER_UNLOCKED".equals(action) || "android.intent.action.USER_STARTED".equals(action) || "android.security.STORAGE_CHANGED".equals(action)) {
                int userId = intent.getIntExtra("android.intent.extra.user_handle", -1);
                new MonitoringCertNotificationTask().execute(userId);
            }
            if ("android.intent.action.USER_ADDED".equals(action)) {
                DevicePolicyManagerService.this.disableSecurityLoggingIfNotCompliant();
            } else if ("android.intent.action.USER_REMOVED".equals(action)) {
                DevicePolicyManagerService.this.disableSecurityLoggingIfNotCompliant();
                DevicePolicyManagerService.this.removeUserData(userHandle);
            } else if ("android.intent.action.USER_STARTED".equals(action)) {
                DevicePolicyManagerService devicePolicyManagerService = DevicePolicyManagerService.this;
                synchronized (devicePolicyManagerService) {
                    DevicePolicyManagerService.this.mUserData.remove(userHandle);
                    DevicePolicyManagerService.this.sendAdminEnabledBroadcastLocked(userHandle);
                }
                DevicePolicyManagerService.this.handlePackagesChanged(null, userHandle);
            } else if ("android.intent.action.EXTERNAL_APPLICATIONS_UNAVAILABLE".equals(action)) {
                DevicePolicyManagerService.this.handlePackagesChanged(null, userHandle);
            } else if ("android.intent.action.PACKAGE_CHANGED".equals(action) || "android.intent.action.PACKAGE_ADDED".equals(action) && intent.getBooleanExtra("android.intent.extra.REPLACING", false)) {
                DevicePolicyManagerService.this.handlePackagesChanged(intent.getData().getSchemeSpecificPart(), userHandle);
            } else if ("android.intent.action.PACKAGE_REMOVED".equals(action) && !intent.getBooleanExtra("android.intent.extra.REPLACING", false)) {
                DevicePolicyManagerService.this.handlePackagesChanged(intent.getData().getSchemeSpecificPart(), userHandle);
            } else if ("android.intent.action.MANAGED_PROFILE_ADDED".equals(action)) {
                DevicePolicyManagerService.this.clearWipeProfileNotification();
            }
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handlePackagesChanged(String packageName, int userHandle) {
        boolean removed = false;
        DevicePolicyData policy = this.getUserData(userHandle);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            for (int i = policy.mAdminList.size() - 1; i >= 0; --i) {
                ActiveAdmin aa = policy.mAdminList.get(i);
                try {
                    String adminPackage = aa.info.getPackageName();
                    if (packageName != null && !packageName.equals(adminPackage) || this.mIPackageManager.getPackageInfo(adminPackage, 0, userHandle) != null && this.mIPackageManager.getReceiverInfo(aa.info.getComponent(), 786432, userHandle) != null) continue;
                    removed = true;
                    policy.mAdminList.remove(i);
                    policy.mAdminMap.remove(aa.info.getComponent());
                    continue;
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
            if (removed) {
                this.validatePasswordOwnerLocked(policy);
                this.saveSettingsLocked(policy.mUserHandle);
            }
            if (this.isRemovedPackage(packageName, policy.mDelegatedCertInstallerPackage, userHandle)) {
                policy.mDelegatedCertInstallerPackage = null;
                this.saveSettingsLocked(policy.mUserHandle);
            }
            if (this.isRemovedPackage(packageName, policy.mApplicationRestrictionsManagingPackage, userHandle)) {
                policy.mApplicationRestrictionsManagingPackage = null;
                this.saveSettingsLocked(policy.mUserHandle);
            }
        }
        if (removed) {
            this.pushUserRestrictions(userHandle);
        }
    }

    private boolean isRemovedPackage(String changedPackage, String targetPackage, int userHandle) {
        try {
            return targetPackage != null && (changedPackage == null || changedPackage.equals(targetPackage)) && this.mIPackageManager.getPackageInfo(targetPackage, 0, userHandle) == null;
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    public DevicePolicyManagerService(Context context) {
        this(new Injector(context));
    }

    DevicePolicyManagerService(Injector injector) {
        this.mInjector = injector;
        this.mContext = Preconditions.checkNotNull(injector.mContext);
        this.mHandler = new Handler(Preconditions.checkNotNull(injector.getMyLooper()));
        this.mOwners = Preconditions.checkNotNull(injector.newOwners());
        this.mUserManager = Preconditions.checkNotNull(injector.getUserManager());
        this.mUserManagerInternal = Preconditions.checkNotNull(injector.getUserManagerInternal());
        this.mIPackageManager = Preconditions.checkNotNull(injector.getIPackageManager());
        this.mTelephonyManager = Preconditions.checkNotNull(injector.getTelephonyManager());
        this.mLocalService = new LocalService();
        this.mLockPatternUtils = injector.newLockPatternUtils();
        this.mSecurityLogMonitor = new SecurityLogMonitor(this);
        this.mHasFeature = this.mContext.getPackageManager().hasSystemFeature("android.software.device_admin");
        if (!this.mHasFeature) {
            return;
        }
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.intent.action.BOOT_COMPLETED");
        filter.addAction(ACTION_EXPIRED_PASSWORD_NOTIFICATION);
        filter.addAction("android.intent.action.USER_ADDED");
        filter.addAction("android.intent.action.USER_REMOVED");
        filter.addAction("android.intent.action.USER_STARTED");
        filter.addAction("android.intent.action.USER_UNLOCKED");
        filter.addAction("android.security.STORAGE_CHANGED");
        filter.setPriority(1000);
        this.mContext.registerReceiverAsUser(this.mReceiver, UserHandle.ALL, filter, null, this.mHandler);
        filter = new IntentFilter();
        filter.addAction("android.intent.action.PACKAGE_CHANGED");
        filter.addAction("android.intent.action.PACKAGE_REMOVED");
        filter.addAction("android.intent.action.EXTERNAL_APPLICATIONS_UNAVAILABLE");
        filter.addAction("android.intent.action.PACKAGE_ADDED");
        filter.addDataScheme("package");
        this.mContext.registerReceiverAsUser(this.mReceiver, UserHandle.ALL, filter, null, this.mHandler);
        filter = new IntentFilter();
        filter.addAction("android.intent.action.MANAGED_PROFILE_ADDED");
        this.mContext.registerReceiverAsUser(this.mReceiver, UserHandle.ALL, filter, null, this.mHandler);
        LocalServices.addService(DevicePolicyManagerInternal.class, this.mLocalService);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DevicePolicyData getUserData(int userHandle) {
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            DevicePolicyData policy = this.mUserData.get(userHandle);
            if (policy == null) {
                policy = new DevicePolicyData(userHandle);
                this.mUserData.append(userHandle, policy);
                this.loadSettingsLocked(policy, userHandle);
            }
            return policy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DevicePolicyData getUserDataUnchecked(int userHandle) {
        long ident = this.mInjector.binderClearCallingIdentity();
        try {
            DevicePolicyData devicePolicyData = this.getUserData(userHandle);
            return devicePolicyData;
        }
        finally {
            this.mInjector.binderRestoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeUserData(int userHandle) {
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            if (userHandle == 0) {
                Slog.w(LOG_TAG, "Tried to remove device policy file for user 0! Ignoring.");
                return;
            }
            this.mOwners.removeProfileOwner(userHandle);
            this.mOwners.writeProfileOwner(userHandle);
            DevicePolicyData policy = this.mUserData.get(userHandle);
            if (policy != null) {
                this.mUserData.remove(userHandle);
            }
            File policyFile = new File(this.mInjector.environmentGetUserSystemDirectory(userHandle), DEVICE_POLICIES_XML);
            policyFile.delete();
            Slog.i(LOG_TAG, "Removed device policy file " + policyFile.getAbsolutePath());
        }
        this.updateScreenCaptureDisabledInWindowManager(userHandle, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void loadOwners() {
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            this.mOwners.load();
            this.setDeviceOwnerSystemPropertyLocked();
            this.findOwnerComponentIfNecessaryLocked();
            this.migrateUserRestrictionsIfNecessaryLocked();
            this.updateDeviceOwnerLocked();
        }
    }

    private void setDeviceOwnerSystemPropertyLocked() {
        if (this.mInjector.settingsGlobalGetInt("device_provisioned", 0) == 0) {
            return;
        }
        if (StorageManager.inCryptKeeperBounce()) {
            return;
        }
        if (!TextUtils.isEmpty(this.mInjector.systemPropertiesGet(PROPERTY_DEVICE_OWNER_PRESENT))) {
            Slog.w(LOG_TAG, "Trying to set ro.device_owner, but it has already been set?");
        } else if (this.mOwners.hasDeviceOwner()) {
            this.mInjector.systemPropertiesSet(PROPERTY_DEVICE_OWNER_PRESENT, "true");
            Slog.i(LOG_TAG, "Set ro.device_owner property to true");
            this.disableSecurityLoggingIfNotCompliant();
            if (this.mInjector.securityLogGetLoggingEnabledProperty()) {
                this.mSecurityLogMonitor.start();
            }
        } else {
            this.mInjector.systemPropertiesSet(PROPERTY_DEVICE_OWNER_PRESENT, "false");
            Slog.i(LOG_TAG, "Set ro.device_owner property to false");
        }
    }

    private void findOwnerComponentIfNecessaryLocked() {
        if (!this.mOwners.hasDeviceOwner()) {
            return;
        }
        ComponentName doComponentName = this.mOwners.getDeviceOwnerComponent();
        if (!TextUtils.isEmpty(doComponentName.getClassName())) {
            return;
        }
        ComponentName doComponent = this.findAdminComponentWithPackageLocked(doComponentName.getPackageName(), this.mOwners.getDeviceOwnerUserId());
        if (doComponent == null) {
            Slog.e(LOG_TAG, "Device-owner isn't registered as device-admin");
        } else {
            this.mOwners.setDeviceOwnerWithRestrictionsMigrated(doComponent, this.mOwners.getDeviceOwnerName(), this.mOwners.getDeviceOwnerUserId(), !this.mOwners.getDeviceOwnerUserRestrictionsNeedsMigration());
            this.mOwners.writeDeviceOwner();
        }
    }

    private void migrateUserRestrictionsIfNecessaryLocked() {
        boolean migrated = false;
        if (this.mOwners.getDeviceOwnerUserRestrictionsNeedsMigration()) {
            migrated = true;
            ActiveAdmin deviceOwnerAdmin = this.getDeviceOwnerAdminLocked();
            this.migrateUserRestrictionsForUser(UserHandle.SYSTEM, deviceOwnerAdmin, null, true);
            this.pushUserRestrictions(0);
            this.mOwners.setDeviceOwnerUserRestrictionsMigrated();
        }
        ArraySet<String> secondaryUserExceptionList = Sets.newArraySet("no_outgoing_calls", "no_sms");
        for (UserInfo ui : this.mUserManager.getUsers()) {
            int userId = ui.id;
            if (!this.mOwners.getProfileOwnerUserRestrictionsNeedsMigration(userId)) continue;
            migrated = true;
            ActiveAdmin profileOwnerAdmin = this.getProfileOwnerAdminLocked(userId);
            ArraySet<String> exceptionList = userId == 0 ? null : secondaryUserExceptionList;
            this.migrateUserRestrictionsForUser(ui.getUserHandle(), profileOwnerAdmin, exceptionList, false);
            this.pushUserRestrictions(userId);
            this.mOwners.setProfileOwnerUserRestrictionsMigrated(userId);
        }
    }

    private void migrateUserRestrictionsForUser(UserHandle user, ActiveAdmin admin, Set<String> exceptionList, boolean isDeviceOwner) {
        Bundle origRestrictions = this.mUserManagerInternal.getBaseUserRestrictions(user.getIdentifier());
        Bundle newBaseRestrictions = new Bundle();
        Bundle newOwnerRestrictions = new Bundle();
        for (String key : origRestrictions.keySet()) {
            boolean canOwnerChange;
            if (!origRestrictions.getBoolean(key)) continue;
            boolean bl = canOwnerChange = isDeviceOwner ? UserRestrictionsUtils.canDeviceOwnerChange(key) : UserRestrictionsUtils.canProfileOwnerChange(key, user.getIdentifier());
            if (!canOwnerChange || exceptionList != null && exceptionList.contains(key)) {
                newBaseRestrictions.putBoolean(key, true);
                continue;
            }
            newOwnerRestrictions.putBoolean(key, true);
        }
        this.mUserManagerInternal.setBaseUserRestrictionsByDpmsForMigration(user.getIdentifier(), newBaseRestrictions);
        if (admin != null) {
            admin.ensureUserRestrictions().clear();
            admin.ensureUserRestrictions().putAll(newOwnerRestrictions);
        } else {
            Slog.w(LOG_TAG, "ActiveAdmin for DO/PO not found. user=" + user.getIdentifier());
        }
        this.saveSettingsLocked(user.getIdentifier());
    }

    private ComponentName findAdminComponentWithPackageLocked(String packageName, int userId) {
        DevicePolicyData policy = this.getUserData(userId);
        int n = policy.mAdminList.size();
        ComponentName found = null;
        int nFound = 0;
        for (int i = 0; i < n; ++i) {
            ActiveAdmin admin = policy.mAdminList.get(i);
            if (!packageName.equals(admin.info.getPackageName())) continue;
            if (nFound == 0) {
                found = admin.info.getComponent();
            }
            ++nFound;
        }
        if (nFound > 1) {
            Slog.w(LOG_TAG, "Multiple DA found; assume the first one is DO.");
        }
        return found;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setExpirationAlarmCheckLocked(Context context, int userHandle, boolean parent) {
        long alarmTime;
        long expiration = this.getPasswordExpirationLocked(null, userHandle, parent);
        long now = System.currentTimeMillis();
        long timeToExpire = expiration - now;
        if (expiration == 0L) {
            alarmTime = 0L;
        } else if (timeToExpire <= 0L) {
            alarmTime = now + 86400000L;
        } else {
            long alarmInterval = timeToExpire % 86400000L;
            if (alarmInterval == 0L) {
                alarmInterval = 86400000L;
            }
            alarmTime = now + alarmInterval;
        }
        long token = this.mInjector.binderClearCallingIdentity();
        try {
            int affectedUserHandle = parent ? this.getProfileParentId(userHandle) : userHandle;
            AlarmManager am = (AlarmManager)context.getSystemService("alarm");
            PendingIntent pi = PendingIntent.getBroadcastAsUser(context, 5571, new Intent(ACTION_EXPIRED_PASSWORD_NOTIFICATION), 0x48000000, UserHandle.of(affectedUserHandle));
            am.cancel(pi);
            if (alarmTime != 0L) {
                am.set(1, alarmTime, pi);
            }
        }
        finally {
            this.mInjector.binderRestoreCallingIdentity(token);
        }
    }

    ActiveAdmin getActiveAdminUncheckedLocked(ComponentName who, int userHandle) {
        ActiveAdmin admin = this.getUserData((int)userHandle).mAdminMap.get(who);
        if (admin != null && who.getPackageName().equals(admin.info.getActivityInfo().packageName) && who.getClassName().equals(admin.info.getActivityInfo().name)) {
            return admin;
        }
        return null;
    }

    ActiveAdmin getActiveAdminUncheckedLocked(ComponentName who, int userHandle, boolean parent) {
        ActiveAdmin admin;
        if (parent) {
            this.enforceManagedProfile(userHandle, "call APIs on the parent profile");
        }
        if ((admin = this.getActiveAdminUncheckedLocked(who, userHandle)) != null && parent) {
            admin = admin.getParentActiveAdmin();
        }
        return admin;
    }

    ActiveAdmin getActiveAdminForCallerLocked(ComponentName who, int reqPolicy) throws SecurityException {
        int callingUid = this.mInjector.binderGetCallingUid();
        ActiveAdmin result = this.getActiveAdminWithPolicyForUidLocked(who, reqPolicy, callingUid);
        if (result != null) {
            return result;
        }
        if (who != null) {
            int userId = UserHandle.getUserId(callingUid);
            DevicePolicyData policy = this.getUserData(userId);
            ActiveAdmin admin = policy.mAdminMap.get(who);
            if (reqPolicy == -2) {
                throw new SecurityException("Admin " + admin.info.getComponent() + " does not own the device");
            }
            if (reqPolicy == -1) {
                throw new SecurityException("Admin " + admin.info.getComponent() + " does not own the profile");
            }
            throw new SecurityException("Admin " + admin.info.getComponent() + " did not specify uses-policy for: " + admin.info.getTagForPolicy(reqPolicy));
        }
        throw new SecurityException("No active admin owned by uid " + this.mInjector.binderGetCallingUid() + " for policy #" + reqPolicy);
    }

    ActiveAdmin getActiveAdminForCallerLocked(ComponentName who, int reqPolicy, boolean parent) throws SecurityException {
        if (parent) {
            this.enforceManagedProfile(this.mInjector.userHandleGetCallingUserId(), "call APIs on the parent profile");
        }
        ActiveAdmin admin = this.getActiveAdminForCallerLocked(who, reqPolicy);
        return parent ? admin.getParentActiveAdmin() : admin;
    }

    private ActiveAdmin getActiveAdminForUidLocked(ComponentName who, int uid) {
        int userId = UserHandle.getUserId(uid);
        DevicePolicyData policy = this.getUserData(userId);
        ActiveAdmin admin = policy.mAdminMap.get(who);
        if (admin == null) {
            throw new SecurityException("No active admin " + who);
        }
        if (admin.getUid() != uid) {
            throw new SecurityException("Admin " + who + " is not owned by uid " + uid);
        }
        return admin;
    }

    private ActiveAdmin getActiveAdminWithPolicyForUidLocked(ComponentName who, int reqPolicy, int uid) {
        int userId = UserHandle.getUserId(uid);
        DevicePolicyData policy = this.getUserData(userId);
        if (who != null) {
            ActiveAdmin admin = policy.mAdminMap.get(who);
            if (admin == null) {
                throw new SecurityException("No active admin " + who);
            }
            if (admin.getUid() != uid) {
                throw new SecurityException("Admin " + who + " is not owned by uid " + uid);
            }
            if (this.isActiveAdminWithPolicyForUserLocked(admin, reqPolicy, userId)) {
                return admin;
            }
        } else {
            for (ActiveAdmin admin : policy.mAdminList) {
                if (admin.getUid() != uid || !this.isActiveAdminWithPolicyForUserLocked(admin, reqPolicy, userId)) continue;
                return admin;
            }
        }
        return null;
    }

    boolean isActiveAdminWithPolicyForUserLocked(ActiveAdmin admin, int reqPolicy, int userId) {
        boolean ownsDevice = this.isDeviceOwner(admin.info.getComponent(), userId);
        boolean ownsProfile = this.isProfileOwner(admin.info.getComponent(), userId);
        if (reqPolicy == -2) {
            return ownsDevice;
        }
        if (reqPolicy == -1) {
            return ownsDevice || ownsProfile;
        }
        return admin.info.usesPolicy(reqPolicy);
    }

    void sendAdminCommandLocked(ActiveAdmin admin, String action) {
        this.sendAdminCommandLocked(admin, action, null);
    }

    void sendAdminCommandLocked(ActiveAdmin admin, String action, BroadcastReceiver result) {
        this.sendAdminCommandLocked(admin, action, null, result);
    }

    void sendAdminCommandLocked(ActiveAdmin admin, String action, Bundle adminExtras, BroadcastReceiver result) {
        Intent intent = new Intent(action);
        intent.setComponent(admin.info.getComponent());
        if (action.equals("android.app.action.ACTION_PASSWORD_EXPIRING")) {
            intent.putExtra("expiration", admin.passwordExpirationDate);
        }
        if (adminExtras != null) {
            intent.putExtras(adminExtras);
        }
        if (result != null) {
            this.mContext.sendOrderedBroadcastAsUser(intent, admin.getUserHandle(), null, result, this.mHandler, -1, null, null);
        } else {
            this.mContext.sendBroadcastAsUser(intent, admin.getUserHandle());
        }
    }

    void sendAdminCommandLocked(String action, int reqPolicy, int userHandle) {
        DevicePolicyData policy = this.getUserData(userHandle);
        int count = policy.mAdminList.size();
        if (count > 0) {
            for (int i = 0; i < count; ++i) {
                ActiveAdmin admin = policy.mAdminList.get(i);
                if (!admin.info.usesPolicy(reqPolicy)) continue;
                this.sendAdminCommandLocked(admin, action);
            }
        }
    }

    private void sendAdminCommandToSelfAndProfilesLocked(String action, int reqPolicy, int userHandle) {
        int[] profileIds;
        for (int profileId : profileIds = this.mUserManager.getProfileIdsWithDisabled(userHandle)) {
            this.sendAdminCommandLocked(action, reqPolicy, profileId);
        }
    }

    private void sendAdminCommandForLockscreenPoliciesLocked(String action, int reqPolicy, int userHandle) {
        if (this.isSeparateProfileChallengeEnabled(userHandle)) {
            this.sendAdminCommandLocked(action, reqPolicy, userHandle);
        } else {
            this.sendAdminCommandToSelfAndProfilesLocked(action, reqPolicy, userHandle);
        }
    }

    void removeActiveAdminLocked(final ComponentName adminReceiver, final int userHandle) {
        ActiveAdmin admin = this.getActiveAdminUncheckedLocked(adminReceiver, userHandle);
        if (admin != null) {
            this.getUserData((int)userHandle).mRemovingAdmins.add(adminReceiver);
            this.sendAdminCommandLocked(admin, "android.app.action.DEVICE_ADMIN_DISABLED", new BroadcastReceiver(){

                @Override
                public void onReceive(Context context, Intent intent) {
                    DevicePolicyManagerService.this.removeAdminArtifacts(adminReceiver, userHandle);
                    DevicePolicyManagerService.this.removePackageIfRequired(adminReceiver.getPackageName(), userHandle);
                }
            });
        }
    }

    public DeviceAdminInfo findAdmin(ComponentName adminName, int userHandle, boolean throwForMissiongPermission) {
        if (!this.mHasFeature) {
            return null;
        }
        this.enforceFullCrossUsersPermission(userHandle);
        ActivityInfo ai = null;
        try {
            ai = this.mIPackageManager.getReceiverInfo(adminName, 819328, userHandle);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        if (ai == null) {
            throw new IllegalArgumentException("Unknown admin: " + adminName);
        }
        if (!"android.permission.BIND_DEVICE_ADMIN".equals(ai.permission)) {
            String message = "DeviceAdminReceiver " + adminName + " must be protected with " + "android.permission.BIND_DEVICE_ADMIN";
            Slog.w(LOG_TAG, message);
            if (throwForMissiongPermission && ai.applicationInfo.targetSdkVersion > 23) {
                throw new IllegalArgumentException(message);
            }
        }
        try {
            return new DeviceAdminInfo(this.mContext, ai);
        }
        catch (IOException | XmlPullParserException e) {
            Slog.w(LOG_TAG, "Bad device admin requested for user=" + userHandle + ": " + adminName, e);
            return null;
        }
    }

    private JournaledFile makeJournaledFile(int userHandle) {
        String base = userHandle == 0 ? this.mInjector.getDevicePolicyFilePathForSystemUser() + DEVICE_POLICIES_XML : new File(this.mInjector.environmentGetUserSystemDirectory(userHandle), DEVICE_POLICIES_XML).getAbsolutePath();
        return new JournaledFile(new File(base), new File(base + ".tmp"));
    }

    private void saveSettingsLocked(int userHandle) {
        DevicePolicyData policy = this.getUserData(userHandle);
        JournaledFile journal = this.makeJournaledFile(userHandle);
        FileOutputStream stream = null;
        try {
            int i;
            stream = new FileOutputStream(journal.chooseForWrite(), false);
            FastXmlSerializer out = new FastXmlSerializer();
            out.setOutput(stream, StandardCharsets.UTF_8.name());
            out.startDocument(null, true);
            out.startTag(null, "policies");
            if (policy.mRestrictionsProvider != null) {
                out.attribute(null, ATTR_PERMISSION_PROVIDER, policy.mRestrictionsProvider.flattenToString());
            }
            if (policy.mUserSetupComplete) {
                out.attribute(null, ATTR_SETUP_COMPLETE, Boolean.toString(true));
            }
            if (policy.mUserProvisioningState != 0) {
                out.attribute(null, ATTR_PROVISIONING_STATE, Integer.toString(policy.mUserProvisioningState));
            }
            if (policy.mPermissionPolicy != 0) {
                out.attribute(null, ATTR_PERMISSION_POLICY, Integer.toString(policy.mPermissionPolicy));
            }
            if (policy.mDelegatedCertInstallerPackage != null) {
                out.attribute(null, ATTR_DELEGATED_CERT_INSTALLER, policy.mDelegatedCertInstallerPackage);
            }
            if (policy.mApplicationRestrictionsManagingPackage != null) {
                out.attribute(null, ATTR_APPLICATION_RESTRICTIONS_MANAGER, policy.mApplicationRestrictionsManagingPackage);
            }
            int N = policy.mAdminList.size();
            for (i = 0; i < N; ++i) {
                ActiveAdmin ap = policy.mAdminList.get(i);
                if (ap == null) continue;
                out.startTag(null, "admin");
                out.attribute(null, ATTR_NAME, ap.info.getComponent().flattenToString());
                ap.writeToXml(out);
                out.endTag(null, "admin");
            }
            if (policy.mPasswordOwner >= 0) {
                out.startTag(null, "password-owner");
                out.attribute(null, ATTR_VALUE, Integer.toString(policy.mPasswordOwner));
                out.endTag(null, "password-owner");
            }
            if (policy.mFailedPasswordAttempts != 0) {
                out.startTag(null, "failed-password-attempts");
                out.attribute(null, ATTR_VALUE, Integer.toString(policy.mFailedPasswordAttempts));
                out.endTag(null, "failed-password-attempts");
            }
            if (policy.mActivePasswordQuality != 0 || policy.mActivePasswordLength != 0 || policy.mActivePasswordUpperCase != 0 || policy.mActivePasswordLowerCase != 0 || policy.mActivePasswordLetters != 0 || policy.mActivePasswordNumeric != 0 || policy.mActivePasswordSymbols != 0 || policy.mActivePasswordNonLetter != 0) {
                out.startTag(null, "active-password");
                out.attribute(null, "quality", Integer.toString(policy.mActivePasswordQuality));
                out.attribute(null, "length", Integer.toString(policy.mActivePasswordLength));
                out.attribute(null, "uppercase", Integer.toString(policy.mActivePasswordUpperCase));
                out.attribute(null, "lowercase", Integer.toString(policy.mActivePasswordLowerCase));
                out.attribute(null, "letters", Integer.toString(policy.mActivePasswordLetters));
                out.attribute(null, "numeric", Integer.toString(policy.mActivePasswordNumeric));
                out.attribute(null, "symbols", Integer.toString(policy.mActivePasswordSymbols));
                out.attribute(null, "nonletter", Integer.toString(policy.mActivePasswordNonLetter));
                out.endTag(null, "active-password");
            }
            for (i = 0; i < policy.mAcceptedCaCertificates.size(); ++i) {
                out.startTag(null, TAG_ACCEPTED_CA_CERTIFICATES);
                out.attribute(null, ATTR_NAME, policy.mAcceptedCaCertificates.valueAt(i));
                out.endTag(null, TAG_ACCEPTED_CA_CERTIFICATES);
            }
            for (i = 0; i < policy.mLockTaskPackages.size(); ++i) {
                String component = policy.mLockTaskPackages.get(i);
                out.startTag(null, TAG_LOCK_TASK_COMPONENTS);
                out.attribute(null, ATTR_NAME, component);
                out.endTag(null, TAG_LOCK_TASK_COMPONENTS);
            }
            if (policy.mStatusBarDisabled) {
                out.startTag(null, TAG_STATUS_BAR);
                out.attribute(null, ATTR_DISABLED, Boolean.toString(policy.mStatusBarDisabled));
                out.endTag(null, TAG_STATUS_BAR);
            }
            if (policy.doNotAskCredentialsOnBoot) {
                out.startTag(null, DO_NOT_ASK_CREDENTIALS_ON_BOOT_XML);
                out.endTag(null, DO_NOT_ASK_CREDENTIALS_ON_BOOT_XML);
            }
            for (String id2 : policy.mAffiliationIds) {
                out.startTag(null, TAG_AFFILIATION_ID);
                out.attribute(null, "id", id2);
                out.endTag(null, TAG_AFFILIATION_ID);
            }
            if (policy.mAdminBroadcastPending) {
                out.startTag(null, TAG_ADMIN_BROADCAST_PENDING);
                out.attribute(null, ATTR_VALUE, Boolean.toString(policy.mAdminBroadcastPending));
                out.endTag(null, TAG_ADMIN_BROADCAST_PENDING);
            }
            if (policy.mInitBundle != null) {
                out.startTag(null, TAG_INITIALIZATION_BUNDLE);
                policy.mInitBundle.saveToXml(out);
                out.endTag(null, TAG_INITIALIZATION_BUNDLE);
            }
            out.endTag(null, "policies");
            out.endDocument();
            stream.flush();
            FileUtils.sync(stream);
            stream.close();
            journal.commit();
            this.sendChangedNotification(userHandle);
        }
        catch (IOException | XmlPullParserException e) {
            Slog.w(LOG_TAG, "failed writing file", e);
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            journal.rollback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendChangedNotification(int userHandle) {
        Intent intent = new Intent("android.app.action.DEVICE_POLICY_MANAGER_STATE_CHANGED");
        intent.setFlags(0x40000000);
        long ident = this.mInjector.binderClearCallingIdentity();
        try {
            this.mContext.sendBroadcastAsUser(intent, new UserHandle(userHandle));
        }
        finally {
            this.mInjector.binderRestoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadSettingsLocked(DevicePolicyData policy, int userHandle) {
        JournaledFile journal = this.makeJournaledFile(userHandle);
        FileInputStream stream = null;
        File file = journal.chooseForRead();
        try {
            String permissionPolicy;
            String provisioningState;
            String userSetupComplete;
            int type;
            stream = new FileInputStream(file);
            XmlPullParser parser = Xml.newPullParser();
            parser.setInput(stream, StandardCharsets.UTF_8.name());
            while ((type = parser.next()) != 1 && type != 2) {
            }
            String tag = parser.getName();
            if (!"policies".equals(tag)) {
                throw new XmlPullParserException("Settings do not start with policies tag: found " + tag);
            }
            String permissionProvider = parser.getAttributeValue(null, ATTR_PERMISSION_PROVIDER);
            if (permissionProvider != null) {
                policy.mRestrictionsProvider = ComponentName.unflattenFromString(permissionProvider);
            }
            if ((userSetupComplete = parser.getAttributeValue(null, ATTR_SETUP_COMPLETE)) != null && Boolean.toString(true).equals(userSetupComplete)) {
                policy.mUserSetupComplete = true;
            }
            if (!TextUtils.isEmpty(provisioningState = parser.getAttributeValue(null, ATTR_PROVISIONING_STATE))) {
                policy.mUserProvisioningState = Integer.parseInt(provisioningState);
            }
            if (!TextUtils.isEmpty(permissionPolicy = parser.getAttributeValue(null, ATTR_PERMISSION_POLICY))) {
                policy.mPermissionPolicy = Integer.parseInt(permissionPolicy);
            }
            policy.mDelegatedCertInstallerPackage = parser.getAttributeValue(null, ATTR_DELEGATED_CERT_INSTALLER);
            policy.mApplicationRestrictionsManagingPackage = parser.getAttributeValue(null, ATTR_APPLICATION_RESTRICTIONS_MANAGER);
            type = parser.next();
            int outerDepth = parser.getDepth();
            policy.mLockTaskPackages.clear();
            policy.mAdminList.clear();
            policy.mAdminMap.clear();
            policy.mAffiliationIds.clear();
            while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
                if (type == 3 || type == 4) continue;
                tag = parser.getName();
                if ("admin".equals(tag)) {
                    String name = parser.getAttributeValue(null, ATTR_NAME);
                    try {
                        DeviceAdminInfo dai = this.findAdmin(ComponentName.unflattenFromString(name), userHandle, false);
                        if (dai == null) continue;
                        ActiveAdmin ap = new ActiveAdmin(dai, false);
                        ap.readFromXml(parser);
                        policy.mAdminMap.put(ap.info.getComponent(), ap);
                    }
                    catch (RuntimeException e) {
                        Slog.w(LOG_TAG, "Failed loading admin " + name, e);
                    }
                    continue;
                }
                if ("failed-password-attempts".equals(tag)) {
                    policy.mFailedPasswordAttempts = Integer.parseInt(parser.getAttributeValue(null, ATTR_VALUE));
                    continue;
                }
                if ("password-owner".equals(tag)) {
                    policy.mPasswordOwner = Integer.parseInt(parser.getAttributeValue(null, ATTR_VALUE));
                    continue;
                }
                if ("active-password".equals(tag)) {
                    policy.mActivePasswordQuality = Integer.parseInt(parser.getAttributeValue(null, "quality"));
                    policy.mActivePasswordLength = Integer.parseInt(parser.getAttributeValue(null, "length"));
                    policy.mActivePasswordUpperCase = Integer.parseInt(parser.getAttributeValue(null, "uppercase"));
                    policy.mActivePasswordLowerCase = Integer.parseInt(parser.getAttributeValue(null, "lowercase"));
                    policy.mActivePasswordLetters = Integer.parseInt(parser.getAttributeValue(null, "letters"));
                    policy.mActivePasswordNumeric = Integer.parseInt(parser.getAttributeValue(null, "numeric"));
                    policy.mActivePasswordSymbols = Integer.parseInt(parser.getAttributeValue(null, "symbols"));
                    policy.mActivePasswordNonLetter = Integer.parseInt(parser.getAttributeValue(null, "nonletter"));
                    continue;
                }
                if (TAG_ACCEPTED_CA_CERTIFICATES.equals(tag)) {
                    policy.mAcceptedCaCertificates.add(parser.getAttributeValue(null, ATTR_NAME));
                    continue;
                }
                if (TAG_LOCK_TASK_COMPONENTS.equals(tag)) {
                    policy.mLockTaskPackages.add(parser.getAttributeValue(null, ATTR_NAME));
                    continue;
                }
                if (TAG_STATUS_BAR.equals(tag)) {
                    policy.mStatusBarDisabled = Boolean.parseBoolean(parser.getAttributeValue(null, ATTR_DISABLED));
                    continue;
                }
                if (DO_NOT_ASK_CREDENTIALS_ON_BOOT_XML.equals(tag)) {
                    policy.doNotAskCredentialsOnBoot = true;
                    continue;
                }
                if (TAG_AFFILIATION_ID.equals(tag)) {
                    policy.mAffiliationIds.add(parser.getAttributeValue(null, "id"));
                    continue;
                }
                if (TAG_ADMIN_BROADCAST_PENDING.equals(tag)) {
                    String pending = parser.getAttributeValue(null, ATTR_VALUE);
                    policy.mAdminBroadcastPending = Boolean.toString(true).equals(pending);
                    continue;
                }
                if (TAG_INITIALIZATION_BUNDLE.equals(tag)) {
                    policy.mInitBundle = PersistableBundle.restoreFromXml(parser);
                    continue;
                }
                Slog.w(LOG_TAG, "Unknown tag: " + tag);
                XmlUtils.skipCurrentTag(parser);
            }
        }
        catch (FileNotFoundException parser) {
        }
        catch (IOException | IndexOutOfBoundsException | NullPointerException | NumberFormatException | XmlPullParserException e) {
            Slog.w(LOG_TAG, "failed parsing " + file, e);
        }
        try {
            if (stream != null) {
                stream.close();
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        policy.mAdminList.addAll(policy.mAdminMap.values());
        long identity = this.mInjector.binderClearCallingIdentity();
        try {
            int actualPasswordQuality = this.mLockPatternUtils.getActivePasswordQuality(userHandle);
            if (actualPasswordQuality < policy.mActivePasswordQuality) {
                Slog.w(LOG_TAG, "Active password quality 0x" + Integer.toHexString(policy.mActivePasswordQuality) + " does not match actual quality 0x" + Integer.toHexString(actualPasswordQuality));
                policy.mActivePasswordQuality = 0;
                policy.mActivePasswordLength = 0;
                policy.mActivePasswordUpperCase = 0;
                policy.mActivePasswordLowerCase = 0;
                policy.mActivePasswordLetters = 0;
                policy.mActivePasswordNumeric = 0;
                policy.mActivePasswordSymbols = 0;
                policy.mActivePasswordNonLetter = 0;
            }
        }
        finally {
            this.mInjector.binderRestoreCallingIdentity(identity);
        }
        this.validatePasswordOwnerLocked(policy);
        this.updateMaximumTimeToLockLocked(userHandle);
        this.updateLockTaskPackagesLocked(policy.mLockTaskPackages, userHandle);
        if (policy.mStatusBarDisabled) {
            this.setStatusBarDisabledInternal(policy.mStatusBarDisabled, userHandle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateLockTaskPackagesLocked(List<String> packages, int userId) {
        long ident = this.mInjector.binderClearCallingIdentity();
        try {
            this.mInjector.getIActivityManager().updateLockTaskPackages(userId, packages.toArray(new String[packages.size()]));
        }
        catch (RemoteException remoteException) {
        }
        finally {
            this.mInjector.binderRestoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDeviceOwnerLocked() {
        long ident = this.mInjector.binderClearCallingIdentity();
        try {
            ComponentName deviceOwnerComponent = this.mOwners.getDeviceOwnerComponent();
            if (deviceOwnerComponent != null) {
                this.mInjector.getIActivityManager().updateDeviceOwner(deviceOwnerComponent.getPackageName());
            }
        }
        catch (RemoteException remoteException) {
        }
        finally {
            this.mInjector.binderRestoreCallingIdentity(ident);
        }
    }

    static void validateQualityConstant(int quality) {
        switch (quality) {
            case 0: 
            case 32768: 
            case 65536: 
            case 131072: 
            case 196608: 
            case 262144: 
            case 327680: 
            case 393216: 
            case 524288: {
                return;
            }
        }
        throw new IllegalArgumentException("Invalid quality constant: 0x" + Integer.toHexString(quality));
    }

    void validatePasswordOwnerLocked(DevicePolicyData policy) {
        if (policy.mPasswordOwner >= 0) {
            boolean haveOwner = false;
            for (int i = policy.mAdminList.size() - 1; i >= 0; --i) {
                if (policy.mAdminList.get(i).getUid() != policy.mPasswordOwner) continue;
                haveOwner = true;
                break;
            }
            if (!haveOwner) {
                Slog.w(LOG_TAG, "Previous password owner " + policy.mPasswordOwner + " no longer active; disabling");
                policy.mPasswordOwner = -1;
            }
        }
    }

    void systemReady(int phase) {
        if (!this.mHasFeature) {
            return;
        }
        switch (phase) {
            case 480: {
                this.onLockSettingsReady();
                break;
            }
            case 1000: {
                this.ensureDeviceOwnerUserStarted();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onLockSettingsReady() {
        List<String> packageList;
        this.getUserData(0);
        this.loadOwners();
        this.cleanUpOldUsers();
        this.onStartUser(0);
        new SetupContentObserver(this.mHandler).register();
        this.updateUserSetupComplete();
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            packageList = this.getKeepUninstalledPackagesLocked();
        }
        if (packageList != null) {
            this.mInjector.getPackageManagerInternal().setKeepUninstalledPackages(packageList);
        }
        devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            ActiveAdmin deviceOwner = this.getDeviceOwnerAdminLocked();
            if (deviceOwner != null) {
                this.mUserManagerInternal.setForceEphemeralUsers(deviceOwner.forceEphemeralUsers);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureDeviceOwnerUserStarted() {
        int userId;
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            if (!this.mOwners.hasDeviceOwner()) {
                return;
            }
            userId = this.mOwners.getDeviceOwnerUserId();
        }
        if (userId != 0) {
            try {
                this.mInjector.getIActivityManager().startUserInBackground(userId);
            }
            catch (RemoteException e) {
                Slog.w(LOG_TAG, "Exception starting user", e);
            }
        }
    }

    private void onStartUser(int userId) {
        this.updateScreenCaptureDisabledInWindowManager(userId, this.getScreenCaptureDisabled(null, userId));
        this.pushUserRestrictions(userId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanUpOldUsers() {
        ArraySet<Integer> usersWithData;
        Set<Integer> usersWithProfileOwners;
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            usersWithProfileOwners = this.mOwners.getProfileOwnerKeys();
            usersWithData = new ArraySet<Integer>();
            for (int i = 0; i < this.mUserData.size(); ++i) {
                usersWithData.add(this.mUserData.keyAt(i));
            }
        }
        List<UserInfo> allUsers = this.mUserManager.getUsers();
        ArraySet<Integer> deletedUsers = new ArraySet<Integer>();
        deletedUsers.addAll(usersWithProfileOwners);
        deletedUsers.addAll((Collection<Integer>)usersWithData);
        for (UserInfo userInfo : allUsers) {
            deletedUsers.remove(userInfo.id);
        }
        for (Integer userId : deletedUsers) {
            this.removeUserData(userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handlePasswordExpirationNotification(int userHandle) {
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            long now = System.currentTimeMillis();
            List<ActiveAdmin> admins = this.getActiveAdminsForLockscreenPoliciesLocked(userHandle, false);
            int N = admins.size();
            for (int i = 0; i < N; ++i) {
                ActiveAdmin admin = admins.get(i);
                if (!admin.info.usesPolicy(6) || admin.passwordExpirationTimeout <= 0L || now < admin.passwordExpirationDate - 432000000L || admin.passwordExpirationDate <= 0L) continue;
                this.sendAdminCommandLocked(admin, "android.app.action.ACTION_PASSWORD_EXPIRING");
            }
            this.setExpirationAlarmCheckLocked(this.mContext, userHandle, false);
        }
    }

    @Override
    public void setActiveAdmin(ComponentName adminReceiver, boolean refreshing, int userHandle) {
        if (!this.mHasFeature) {
            return;
        }
        this.setActiveAdmin(adminReceiver, refreshing, userHandle, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setActiveAdmin(ComponentName adminReceiver, boolean refreshing, int userHandle, Bundle onEnableData) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_DEVICE_ADMINS", null);
        this.enforceFullCrossUsersPermission(userHandle);
        DevicePolicyData policy = this.getUserData(userHandle);
        DeviceAdminInfo info = this.findAdmin(adminReceiver, userHandle, true);
        if (info == null) {
            throw new IllegalArgumentException("Bad admin: " + adminReceiver);
        }
        if (!info.getActivityInfo().applicationInfo.isInternal()) {
            throw new IllegalArgumentException("Only apps in internal storage can be active admin: " + adminReceiver);
        }
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            long ident = this.mInjector.binderClearCallingIdentity();
            try {
                if (!refreshing && this.getActiveAdminUncheckedLocked(adminReceiver, userHandle) != null) {
                    throw new IllegalArgumentException("Admin is already added");
                }
                if (policy.mRemovingAdmins.contains(adminReceiver)) {
                    throw new IllegalArgumentException("Trying to set an admin which is being removed");
                }
                ActiveAdmin newAdmin = new ActiveAdmin(info, false);
                policy.mAdminMap.put(adminReceiver, newAdmin);
                int replaceIndex = -1;
                int N = policy.mAdminList.size();
                for (int i = 0; i < N; ++i) {
                    ActiveAdmin oldAdmin = policy.mAdminList.get(i);
                    if (!oldAdmin.info.getComponent().equals(adminReceiver)) continue;
                    replaceIndex = i;
                    break;
                }
                if (replaceIndex == -1) {
                    policy.mAdminList.add(newAdmin);
                    this.enableIfNecessary(info.getPackageName(), userHandle);
                } else {
                    policy.mAdminList.set(replaceIndex, newAdmin);
                }
                this.saveSettingsLocked(userHandle);
                this.sendAdminCommandLocked(newAdmin, "android.app.action.DEVICE_ADMIN_ENABLED", onEnableData, null);
            }
            finally {
                this.mInjector.binderRestoreCallingIdentity(ident);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isAdminActive(ComponentName adminReceiver, int userHandle) {
        if (!this.mHasFeature) {
            return false;
        }
        this.enforceFullCrossUsersPermission(userHandle);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            return this.getActiveAdminUncheckedLocked(adminReceiver, userHandle) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isRemovingAdmin(ComponentName adminReceiver, int userHandle) {
        if (!this.mHasFeature) {
            return false;
        }
        this.enforceFullCrossUsersPermission(userHandle);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            DevicePolicyData policyData = this.getUserData(userHandle);
            return policyData.mRemovingAdmins.contains(adminReceiver);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasGrantedPolicy(ComponentName adminReceiver, int policyId, int userHandle) {
        if (!this.mHasFeature) {
            return false;
        }
        this.enforceFullCrossUsersPermission(userHandle);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            ActiveAdmin administrator = this.getActiveAdminUncheckedLocked(adminReceiver, userHandle);
            if (administrator == null) {
                throw new SecurityException("No active admin " + adminReceiver);
            }
            return administrator.info.usesPolicy(policyId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ComponentName> getActiveAdmins(int userHandle) {
        if (!this.mHasFeature) {
            return Collections.EMPTY_LIST;
        }
        this.enforceFullCrossUsersPermission(userHandle);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            DevicePolicyData policy = this.getUserData(userHandle);
            int N = policy.mAdminList.size();
            if (N <= 0) {
                return null;
            }
            ArrayList<ComponentName> res = new ArrayList<ComponentName>(N);
            for (int i = 0; i < N; ++i) {
                res.add(policy.mAdminList.get((int)i).info.getComponent());
            }
            return res;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean packageHasActiveAdmins(String packageName, int userHandle) {
        if (!this.mHasFeature) {
            return false;
        }
        this.enforceFullCrossUsersPermission(userHandle);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            DevicePolicyData policy = this.getUserData(userHandle);
            int N = policy.mAdminList.size();
            for (int i = 0; i < N; ++i) {
                if (!policy.mAdminList.get((int)i).info.getPackageName().equals(packageName)) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forceRemoveActiveAdmin(ComponentName adminReceiver, int userHandle) {
        if (!this.mHasFeature) {
            return;
        }
        Preconditions.checkNotNull(adminReceiver, "ComponentName is null");
        this.enforceShell("forceRemoveActiveAdmin");
        long ident = this.mInjector.binderClearCallingIdentity();
        try {
            ApplicationInfo ai;
            try {
                ai = this.mIPackageManager.getApplicationInfo(adminReceiver.getPackageName(), 0, userHandle);
            }
            catch (RemoteException e) {
                throw new IllegalStateException(e);
            }
            if (ai == null) {
                throw new IllegalStateException("Couldn't find package to remove admin " + adminReceiver.getPackageName() + " " + userHandle);
            }
            if ((ai.flags & 0x100) == 0) {
                throw new SecurityException("Attempt to remove non-test admin " + adminReceiver + adminReceiver + " " + userHandle);
            }
            DevicePolicyManagerService devicePolicyManagerService = this;
            synchronized (devicePolicyManagerService) {
                if (this.isDeviceOwner(adminReceiver, userHandle)) {
                    this.clearDeviceOwnerLocked(this.getDeviceOwnerAdminLocked(), userHandle);
                }
                if (this.isProfileOwner(adminReceiver, userHandle)) {
                    ActiveAdmin admin = this.getActiveAdminUncheckedLocked(adminReceiver, userHandle, false);
                    this.clearProfileOwnerLocked(admin, userHandle);
                }
            }
            this.removeAdminArtifacts(adminReceiver, userHandle);
        }
        finally {
            this.mInjector.binderRestoreCallingIdentity(ident);
        }
    }

    private void enforceShell(String method) {
        int callingUid = Binder.getCallingUid();
        if (callingUid != 2000 && callingUid != 0) {
            throw new SecurityException("Non-shell user attempted to call " + method);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeActiveAdmin(ComponentName adminReceiver, int userHandle) {
        if (!this.mHasFeature) {
            return;
        }
        this.enforceFullCrossUsersPermission(userHandle);
        this.enforceUserUnlocked(userHandle);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            ActiveAdmin admin = this.getActiveAdminUncheckedLocked(adminReceiver, userHandle);
            if (admin == null) {
                return;
            }
            if (this.isDeviceOwner(adminReceiver, userHandle) || this.isProfileOwner(adminReceiver, userHandle)) {
                Slog.e(LOG_TAG, "Device/profile owner cannot be removed: component=" + adminReceiver);
                return;
            }
            if (admin.getUid() != this.mInjector.binderGetCallingUid()) {
                this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_DEVICE_ADMINS", null);
            }
            long ident = this.mInjector.binderClearCallingIdentity();
            try {
                this.removeActiveAdminLocked(adminReceiver, userHandle);
            }
            finally {
                this.mInjector.binderRestoreCallingIdentity(ident);
            }
        }
    }

    @Override
    public boolean isSeparateProfileChallengeAllowed(int userHandle) {
        ComponentName profileOwner = this.getProfileOwner(userHandle);
        return profileOwner != null && this.getTargetSdk(profileOwner.getPackageName(), userHandle) > 23;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPasswordQuality(ComponentName who, int quality, boolean parent) {
        if (!this.mHasFeature) {
            return;
        }
        Preconditions.checkNotNull(who, "ComponentName is null");
        DevicePolicyManagerService.validateQualityConstant(quality);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            ActiveAdmin ap = this.getActiveAdminForCallerLocked(who, 0, parent);
            if (ap.passwordQuality != quality) {
                ap.passwordQuality = quality;
                this.saveSettingsLocked(this.mInjector.userHandleGetCallingUserId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getPasswordQuality(ComponentName who, int userHandle, boolean parent) {
        if (!this.mHasFeature) {
            return 0;
        }
        this.enforceFullCrossUsersPermission(userHandle);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            int mode = 0;
            if (who != null) {
                ActiveAdmin admin = this.getActiveAdminUncheckedLocked(who, userHandle, parent);
                int n = admin != null ? admin.passwordQuality : mode;
                return n;
            }
            List<ActiveAdmin> admins = this.getActiveAdminsForLockscreenPoliciesLocked(userHandle, parent);
            int N = admins.size();
            for (int i = 0; i < N; ++i) {
                ActiveAdmin admin = admins.get(i);
                if (mode >= admin.passwordQuality) continue;
                mode = admin.passwordQuality;
            }
            return mode;
        }
    }

    private List<ActiveAdmin> getActiveAdminsForLockscreenPoliciesLocked(int userHandle, boolean parent) {
        if (!parent && this.isSeparateProfileChallengeEnabled(userHandle)) {
            return this.getUserDataUnchecked((int)userHandle).mAdminList;
        }
        ArrayList<ActiveAdmin> admins = new ArrayList<ActiveAdmin>();
        for (UserInfo userInfo : this.mUserManager.getProfiles(userHandle)) {
            DevicePolicyData policy = this.getUserData(userInfo.id);
            if (!userInfo.isManagedProfile()) {
                admins.addAll(policy.mAdminList);
                continue;
            }
            boolean hasSeparateChallenge = this.isSeparateProfileChallengeEnabled(userInfo.id);
            int N = policy.mAdminList.size();
            for (int i = 0; i < N; ++i) {
                ActiveAdmin admin = policy.mAdminList.get(i);
                if (admin.hasParentActiveAdmin()) {
                    admins.add(admin.getParentActiveAdmin());
                }
                if (hasSeparateChallenge) continue;
                admins.add(admin);
            }
        }
        return admins;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isSeparateProfileChallengeEnabled(int userHandle) {
        long ident = this.mInjector.binderClearCallingIdentity();
        try {
            boolean bl = this.mLockPatternUtils.isSeparateProfileChallengeEnabled(userHandle);
            return bl;
        }
        finally {
            this.mInjector.binderRestoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPasswordMinimumLength(ComponentName who, int length, boolean parent) {
        if (!this.mHasFeature) {
            return;
        }
        Preconditions.checkNotNull(who, "ComponentName is null");
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            ActiveAdmin ap = this.getActiveAdminForCallerLocked(who, 0, parent);
            if (ap.minimumPasswordLength != length) {
                ap.minimumPasswordLength = length;
                this.saveSettingsLocked(this.mInjector.userHandleGetCallingUserId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getPasswordMinimumLength(ComponentName who, int userHandle, boolean parent) {
        if (!this.mHasFeature) {
            return 0;
        }
        this.enforceFullCrossUsersPermission(userHandle);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            int length = 0;
            if (who != null) {
                ActiveAdmin admin = this.getActiveAdminUncheckedLocked(who, userHandle, parent);
                int n = admin != null ? admin.minimumPasswordLength : length;
                return n;
            }
            List<ActiveAdmin> admins = this.getActiveAdminsForLockscreenPoliciesLocked(userHandle, parent);
            int N = admins.size();
            for (int i = 0; i < N; ++i) {
                ActiveAdmin admin = admins.get(i);
                if (length >= admin.minimumPasswordLength) continue;
                length = admin.minimumPasswordLength;
            }
            return length;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPasswordHistoryLength(ComponentName who, int length, boolean parent) {
        if (!this.mHasFeature) {
            return;
        }
        Preconditions.checkNotNull(who, "ComponentName is null");
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            ActiveAdmin ap = this.getActiveAdminForCallerLocked(who, 0, parent);
            if (ap.passwordHistoryLength != length) {
                ap.passwordHistoryLength = length;
                this.saveSettingsLocked(this.mInjector.userHandleGetCallingUserId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getPasswordHistoryLength(ComponentName who, int userHandle, boolean parent) {
        if (!this.mHasFeature) {
            return 0;
        }
        this.enforceFullCrossUsersPermission(userHandle);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            int length = 0;
            if (who != null) {
                ActiveAdmin admin = this.getActiveAdminUncheckedLocked(who, userHandle, parent);
                int n = admin != null ? admin.passwordHistoryLength : length;
                return n;
            }
            List<ActiveAdmin> admins = this.getActiveAdminsForLockscreenPoliciesLocked(userHandle, parent);
            int N = admins.size();
            for (int i = 0; i < N; ++i) {
                ActiveAdmin admin = admins.get(i);
                if (length >= admin.passwordHistoryLength) continue;
                length = admin.passwordHistoryLength;
            }
            return length;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPasswordExpirationTimeout(ComponentName who, long timeout, boolean parent) {
        if (!this.mHasFeature) {
            return;
        }
        Preconditions.checkNotNull(who, "ComponentName is null");
        Preconditions.checkArgumentNonnegative(timeout, "Timeout must be >= 0 ms");
        int userHandle = this.mInjector.userHandleGetCallingUserId();
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            long expiration;
            ActiveAdmin ap = this.getActiveAdminForCallerLocked(who, 6, parent);
            ap.passwordExpirationDate = expiration = timeout > 0L ? timeout + System.currentTimeMillis() : 0L;
            ap.passwordExpirationTimeout = timeout;
            if (timeout > 0L) {
                Slog.w(LOG_TAG, "setPasswordExpiration(): password will expire on " + DateFormat.getDateTimeInstance(2, 2).format(new Date(expiration)));
            }
            this.saveSettingsLocked(userHandle);
            this.setExpirationAlarmCheckLocked(this.mContext, userHandle, parent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getPasswordExpirationTimeout(ComponentName who, int userHandle, boolean parent) {
        if (!this.mHasFeature) {
            return 0L;
        }
        this.enforceFullCrossUsersPermission(userHandle);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            long timeout = 0L;
            if (who != null) {
                ActiveAdmin admin = this.getActiveAdminUncheckedLocked(who, userHandle, parent);
                long l = admin != null ? admin.passwordExpirationTimeout : timeout;
                return l;
            }
            List<ActiveAdmin> admins = this.getActiveAdminsForLockscreenPoliciesLocked(userHandle, parent);
            int N = admins.size();
            for (int i = 0; i < N; ++i) {
                ActiveAdmin admin = admins.get(i);
                if (timeout != 0L && (admin.passwordExpirationTimeout == 0L || timeout <= admin.passwordExpirationTimeout)) continue;
                timeout = admin.passwordExpirationTimeout;
            }
            return timeout;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addCrossProfileWidgetProvider(ComponentName admin, String packageName) {
        int userId = UserHandle.getCallingUserId();
        ArrayList<String> changedProviders = null;
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            List<String> providers;
            ActiveAdmin activeAdmin = this.getActiveAdminForCallerLocked(admin, -1);
            if (activeAdmin.crossProfileWidgetProviders == null) {
                activeAdmin.crossProfileWidgetProviders = new ArrayList<String>();
            }
            if (!(providers = activeAdmin.crossProfileWidgetProviders).contains(packageName)) {
                providers.add(packageName);
                changedProviders = new ArrayList<String>(providers);
                this.saveSettingsLocked(userId);
            }
        }
        if (changedProviders != null) {
            this.mLocalService.notifyCrossProfileProvidersChanged(userId, changedProviders);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeCrossProfileWidgetProvider(ComponentName admin, String packageName) {
        int userId = UserHandle.getCallingUserId();
        ArrayList<String> changedProviders = null;
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            ActiveAdmin activeAdmin = this.getActiveAdminForCallerLocked(admin, -1);
            if (activeAdmin.crossProfileWidgetProviders == null) {
                return false;
            }
            List<String> providers = activeAdmin.crossProfileWidgetProviders;
            if (providers.remove(packageName)) {
                changedProviders = new ArrayList<String>(providers);
                this.saveSettingsLocked(userId);
            }
        }
        if (changedProviders != null) {
            this.mLocalService.notifyCrossProfileProvidersChanged(userId, changedProviders);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getCrossProfileWidgetProviders(ComponentName admin) {
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            ActiveAdmin activeAdmin = this.getActiveAdminForCallerLocked(admin, -1);
            if (activeAdmin.crossProfileWidgetProviders == null || activeAdmin.crossProfileWidgetProviders.isEmpty()) {
                return null;
            }
            if (this.mInjector.binderIsCallingUidMyUid()) {
                return new ArrayList<String>(activeAdmin.crossProfileWidgetProviders);
            }
            return activeAdmin.crossProfileWidgetProviders;
        }
    }

    private long getPasswordExpirationLocked(ComponentName who, int userHandle, boolean parent) {
        long timeout = 0L;
        if (who != null) {
            ActiveAdmin admin = this.getActiveAdminUncheckedLocked(who, userHandle, parent);
            return admin != null ? admin.passwordExpirationDate : timeout;
        }
        List<ActiveAdmin> admins = this.getActiveAdminsForLockscreenPoliciesLocked(userHandle, parent);
        int N = admins.size();
        for (int i = 0; i < N; ++i) {
            ActiveAdmin admin = admins.get(i);
            if (timeout != 0L && (admin.passwordExpirationDate == 0L || timeout <= admin.passwordExpirationDate)) continue;
            timeout = admin.passwordExpirationDate;
        }
        return timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getPasswordExpiration(ComponentName who, int userHandle, boolean parent) {
        if (!this.mHasFeature) {
            return 0L;
        }
        this.enforceFullCrossUsersPermission(userHandle);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            return this.getPasswordExpirationLocked(who, userHandle, parent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPasswordMinimumUpperCase(ComponentName who, int length, boolean parent) {
        if (!this.mHasFeature) {
            return;
        }
        Preconditions.checkNotNull(who, "ComponentName is null");
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            ActiveAdmin ap = this.getActiveAdminForCallerLocked(who, 0, parent);
            if (ap.minimumPasswordUpperCase != length) {
                ap.minimumPasswordUpperCase = length;
                this.saveSettingsLocked(this.mInjector.userHandleGetCallingUserId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getPasswordMinimumUpperCase(ComponentName who, int userHandle, boolean parent) {
        if (!this.mHasFeature) {
            return 0;
        }
        this.enforceFullCrossUsersPermission(userHandle);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            int length = 0;
            if (who != null) {
                ActiveAdmin admin = this.getActiveAdminUncheckedLocked(who, userHandle, parent);
                int n = admin != null ? admin.minimumPasswordUpperCase : length;
                return n;
            }
            List<ActiveAdmin> admins = this.getActiveAdminsForLockscreenPoliciesLocked(userHandle, parent);
            int N = admins.size();
            for (int i = 0; i < N; ++i) {
                ActiveAdmin admin = admins.get(i);
                if (length >= admin.minimumPasswordUpperCase) continue;
                length = admin.minimumPasswordUpperCase;
            }
            return length;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPasswordMinimumLowerCase(ComponentName who, int length, boolean parent) {
        Preconditions.checkNotNull(who, "ComponentName is null");
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            ActiveAdmin ap = this.getActiveAdminForCallerLocked(who, 0, parent);
            if (ap.minimumPasswordLowerCase != length) {
                ap.minimumPasswordLowerCase = length;
                this.saveSettingsLocked(this.mInjector.userHandleGetCallingUserId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getPasswordMinimumLowerCase(ComponentName who, int userHandle, boolean parent) {
        if (!this.mHasFeature) {
            return 0;
        }
        this.enforceFullCrossUsersPermission(userHandle);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            int length = 0;
            if (who != null) {
                ActiveAdmin admin = this.getActiveAdminUncheckedLocked(who, userHandle, parent);
                int n = admin != null ? admin.minimumPasswordLowerCase : length;
                return n;
            }
            List<ActiveAdmin> admins = this.getActiveAdminsForLockscreenPoliciesLocked(userHandle, parent);
            int N = admins.size();
            for (int i = 0; i < N; ++i) {
                ActiveAdmin admin = admins.get(i);
                if (length >= admin.minimumPasswordLowerCase) continue;
                length = admin.minimumPasswordLowerCase;
            }
            return length;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPasswordMinimumLetters(ComponentName who, int length, boolean parent) {
        if (!this.mHasFeature) {
            return;
        }
        Preconditions.checkNotNull(who, "ComponentName is null");
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            ActiveAdmin ap = this.getActiveAdminForCallerLocked(who, 0, parent);
            if (ap.minimumPasswordLetters != length) {
                ap.minimumPasswordLetters = length;
                this.saveSettingsLocked(this.mInjector.userHandleGetCallingUserId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getPasswordMinimumLetters(ComponentName who, int userHandle, boolean parent) {
        if (!this.mHasFeature) {
            return 0;
        }
        this.enforceFullCrossUsersPermission(userHandle);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            int length = 0;
            if (who != null) {
                ActiveAdmin admin = this.getActiveAdminUncheckedLocked(who, userHandle, parent);
                int n = admin != null ? admin.minimumPasswordLetters : length;
                return n;
            }
            List<ActiveAdmin> admins = this.getActiveAdminsForLockscreenPoliciesLocked(userHandle, parent);
            int N = admins.size();
            for (int i = 0; i < N; ++i) {
                ActiveAdmin admin = admins.get(i);
                if (!DevicePolicyManagerService.isLimitPasswordAllowed(admin, 393216) || length >= admin.minimumPasswordLetters) continue;
                length = admin.minimumPasswordLetters;
            }
            return length;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPasswordMinimumNumeric(ComponentName who, int length, boolean parent) {
        if (!this.mHasFeature) {
            return;
        }
        Preconditions.checkNotNull(who, "ComponentName is null");
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            ActiveAdmin ap = this.getActiveAdminForCallerLocked(who, 0, parent);
            if (ap.minimumPasswordNumeric != length) {
                ap.minimumPasswordNumeric = length;
                this.saveSettingsLocked(this.mInjector.userHandleGetCallingUserId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getPasswordMinimumNumeric(ComponentName who, int userHandle, boolean parent) {
        if (!this.mHasFeature) {
            return 0;
        }
        this.enforceFullCrossUsersPermission(userHandle);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            int length = 0;
            if (who != null) {
                ActiveAdmin admin = this.getActiveAdminUncheckedLocked(who, userHandle, parent);
                int n = admin != null ? admin.minimumPasswordNumeric : length;
                return n;
            }
            List<ActiveAdmin> admins = this.getActiveAdminsForLockscreenPoliciesLocked(userHandle, parent);
            int N = admins.size();
            for (int i = 0; i < N; ++i) {
                ActiveAdmin admin = admins.get(i);
                if (!DevicePolicyManagerService.isLimitPasswordAllowed(admin, 393216) || length >= admin.minimumPasswordNumeric) continue;
                length = admin.minimumPasswordNumeric;
            }
            return length;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPasswordMinimumSymbols(ComponentName who, int length, boolean parent) {
        if (!this.mHasFeature) {
            return;
        }
        Preconditions.checkNotNull(who, "ComponentName is null");
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            ActiveAdmin ap = this.getActiveAdminForCallerLocked(who, 0, parent);
            if (ap.minimumPasswordSymbols != length) {
                ap.minimumPasswordSymbols = length;
                this.saveSettingsLocked(this.mInjector.userHandleGetCallingUserId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getPasswordMinimumSymbols(ComponentName who, int userHandle, boolean parent) {
        if (!this.mHasFeature) {
            return 0;
        }
        this.enforceFullCrossUsersPermission(userHandle);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            int length = 0;
            if (who != null) {
                ActiveAdmin admin = this.getActiveAdminUncheckedLocked(who, userHandle, parent);
                int n = admin != null ? admin.minimumPasswordSymbols : length;
                return n;
            }
            List<ActiveAdmin> admins = this.getActiveAdminsForLockscreenPoliciesLocked(userHandle, parent);
            int N = admins.size();
            for (int i = 0; i < N; ++i) {
                ActiveAdmin admin = admins.get(i);
                if (!DevicePolicyManagerService.isLimitPasswordAllowed(admin, 393216) || length >= admin.minimumPasswordSymbols) continue;
                length = admin.minimumPasswordSymbols;
            }
            return length;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPasswordMinimumNonLetter(ComponentName who, int length, boolean parent) {
        if (!this.mHasFeature) {
            return;
        }
        Preconditions.checkNotNull(who, "ComponentName is null");
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            ActiveAdmin ap = this.getActiveAdminForCallerLocked(who, 0, parent);
            if (ap.minimumPasswordNonLetter != length) {
                ap.minimumPasswordNonLetter = length;
                this.saveSettingsLocked(this.mInjector.userHandleGetCallingUserId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getPasswordMinimumNonLetter(ComponentName who, int userHandle, boolean parent) {
        if (!this.mHasFeature) {
            return 0;
        }
        this.enforceFullCrossUsersPermission(userHandle);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            int length = 0;
            if (who != null) {
                ActiveAdmin admin = this.getActiveAdminUncheckedLocked(who, userHandle, parent);
                int n = admin != null ? admin.minimumPasswordNonLetter : length;
                return n;
            }
            List<ActiveAdmin> admins = this.getActiveAdminsForLockscreenPoliciesLocked(userHandle, parent);
            int N = admins.size();
            for (int i = 0; i < N; ++i) {
                ActiveAdmin admin = admins.get(i);
                if (!DevicePolicyManagerService.isLimitPasswordAllowed(admin, 393216) || length >= admin.minimumPasswordNonLetter) continue;
                length = admin.minimumPasswordNonLetter;
            }
            return length;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isActivePasswordSufficient(int userHandle, boolean parent) {
        if (!this.mHasFeature) {
            return true;
        }
        this.enforceFullCrossUsersPermission(userHandle);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            this.getActiveAdminForCallerLocked(null, 0, parent);
            DevicePolicyData policy = this.getUserDataUnchecked(this.getCredentialOwner(userHandle, parent));
            return this.isActivePasswordSufficientForUserLocked(policy, userHandle, parent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isProfileActivePasswordSufficientForParent(int userHandle) {
        if (!this.mHasFeature) {
            return true;
        }
        this.enforceFullCrossUsersPermission(userHandle);
        this.enforceManagedProfile(userHandle, "call APIs refering to the parent profile");
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            int targetUser = this.getProfileParentId(userHandle);
            DevicePolicyData policy = this.getUserDataUnchecked(this.getCredentialOwner(userHandle, false));
            return this.isActivePasswordSufficientForUserLocked(policy, targetUser, false);
        }
    }

    private boolean isActivePasswordSufficientForUserLocked(DevicePolicyData policy, int userHandle, boolean parent) {
        if (policy.mActivePasswordQuality < this.getPasswordQuality(null, userHandle, parent) || policy.mActivePasswordLength < this.getPasswordMinimumLength(null, userHandle, parent)) {
            return false;
        }
        if (policy.mActivePasswordQuality != 393216) {
            return true;
        }
        return policy.mActivePasswordUpperCase >= this.getPasswordMinimumUpperCase(null, userHandle, parent) && policy.mActivePasswordLowerCase >= this.getPasswordMinimumLowerCase(null, userHandle, parent) && policy.mActivePasswordLetters >= this.getPasswordMinimumLetters(null, userHandle, parent) && policy.mActivePasswordNumeric >= this.getPasswordMinimumNumeric(null, userHandle, parent) && policy.mActivePasswordSymbols >= this.getPasswordMinimumSymbols(null, userHandle, parent) && policy.mActivePasswordNonLetter >= this.getPasswordMinimumNonLetter(null, userHandle, parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getCurrentFailedPasswordAttempts(int userHandle, boolean parent) {
        this.enforceFullCrossUsersPermission(userHandle);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            if (!this.isCallerWithSystemUid()) {
                this.getActiveAdminForCallerLocked(null, 1, parent);
            }
            DevicePolicyData policy = this.getUserDataUnchecked(this.getCredentialOwner(userHandle, parent));
            return policy.mFailedPasswordAttempts;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMaximumFailedPasswordsForWipe(ComponentName who, int num, boolean parent) {
        if (!this.mHasFeature) {
            return;
        }
        Preconditions.checkNotNull(who, "ComponentName is null");
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            this.getActiveAdminForCallerLocked(who, 4, parent);
            ActiveAdmin ap = this.getActiveAdminForCallerLocked(who, 1, parent);
            if (ap.maximumFailedPasswordsForWipe != num) {
                ap.maximumFailedPasswordsForWipe = num;
                this.saveSettingsLocked(this.mInjector.userHandleGetCallingUserId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMaximumFailedPasswordsForWipe(ComponentName who, int userHandle, boolean parent) {
        if (!this.mHasFeature) {
            return 0;
        }
        this.enforceFullCrossUsersPermission(userHandle);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            ActiveAdmin admin = who != null ? this.getActiveAdminUncheckedLocked(who, userHandle, parent) : this.getAdminWithMinimumFailedPasswordsForWipeLocked(userHandle, parent);
            return admin != null ? admin.maximumFailedPasswordsForWipe : 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getProfileWithMinimumFailedPasswordsForWipe(int userHandle, boolean parent) {
        if (!this.mHasFeature) {
            return -10000;
        }
        this.enforceFullCrossUsersPermission(userHandle);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            ActiveAdmin admin = this.getAdminWithMinimumFailedPasswordsForWipeLocked(userHandle, parent);
            return admin != null ? admin.getUserHandle().getIdentifier() : -10000;
        }
    }

    private ActiveAdmin getAdminWithMinimumFailedPasswordsForWipeLocked(int userHandle, boolean parent) {
        int count = 0;
        ActiveAdmin strictestAdmin = null;
        List<ActiveAdmin> admins = this.getActiveAdminsForLockscreenPoliciesLocked(userHandle, parent);
        int N = admins.size();
        for (int i = 0; i < N; ++i) {
            ActiveAdmin admin = admins.get(i);
            if (admin.maximumFailedPasswordsForWipe == 0) continue;
            int userId = admin.getUserHandle().getIdentifier();
            if (count != 0 && count <= admin.maximumFailedPasswordsForWipe && (count != admin.maximumFailedPasswordsForWipe || !this.getUserInfo(userId).isPrimary())) continue;
            count = admin.maximumFailedPasswordsForWipe;
            strictestAdmin = admin;
        }
        return strictestAdmin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UserInfo getUserInfo(int userId) {
        long token = this.mInjector.binderClearCallingIdentity();
        try {
            UserInfo userInfo = this.mUserManager.getUserInfo(userId);
            return userInfo;
        }
        finally {
            this.mInjector.binderRestoreCallingIdentity(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean resetPassword(String passwordOrNull, int flags) throws RemoteException {
        boolean doNotAskCredentialsOnBoot;
        int quality;
        String password;
        if (!this.mHasFeature) {
            return false;
        }
        int callingUid = this.mInjector.binderGetCallingUid();
        int userHandle = this.mInjector.userHandleGetCallingUserId();
        String string2 = password = passwordOrNull != null ? passwordOrNull : "";
        if (TextUtils.isEmpty(password)) {
            this.enforceNotManagedProfile(userHandle, "clear the active password");
        }
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            boolean preN;
            ActiveAdmin admin = this.getActiveAdminWithPolicyForUidLocked(null, -1, callingUid);
            if (admin != null) {
                preN = this.getTargetSdk(admin.info.getPackageName(), userHandle) <= 23;
            } else {
                admin = this.getActiveAdminForCallerLocked(null, 2);
                boolean bl = preN = this.getTargetSdk(admin.info.getPackageName(), userHandle) <= 23;
                if (TextUtils.isEmpty(password)) {
                    if (!preN) {
                        throw new SecurityException("Cannot call with null password");
                    }
                    Slog.e(LOG_TAG, "Cannot call with null password");
                    return false;
                }
                if (this.isLockScreenSecureUnchecked(userHandle)) {
                    if (!preN) {
                        throw new SecurityException("Admin cannot change current password");
                    }
                    Slog.e(LOG_TAG, "Admin cannot change current password");
                    return false;
                }
            }
            if (!this.isManagedProfile(userHandle)) {
                for (UserInfo userInfo : this.mUserManager.getProfiles(userHandle)) {
                    if (!userInfo.isManagedProfile()) continue;
                    if (!preN) {
                        throw new IllegalStateException("Cannot reset password on user has managed profile");
                    }
                    Slog.e(LOG_TAG, "Cannot reset password on user has managed profile");
                    return false;
                }
            }
            if (!this.mUserManager.isUserUnlocked(userHandle)) {
                if (!preN) {
                    throw new IllegalStateException("Cannot reset password when user is locked");
                }
                Slog.e(LOG_TAG, "Cannot reset password when user is locked");
                return false;
            }
            quality = this.getPasswordQuality(null, userHandle, false);
            if (quality == 524288) {
                quality = 0;
            }
            if (quality != 0) {
                int realQuality = LockPatternUtils.computePasswordQuality(password);
                if (realQuality < quality && quality != 393216) {
                    Slog.w(LOG_TAG, "resetPassword: password quality 0x" + Integer.toHexString(realQuality) + " does not meet required quality 0x" + Integer.toHexString(quality));
                    return false;
                }
                quality = Math.max(realQuality, quality);
            }
            int length = this.getPasswordMinimumLength(null, userHandle, false);
            if (password.length() < length) {
                Slog.w(LOG_TAG, "resetPassword: password length " + password.length() + " does not meet required length " + length);
                return false;
            }
            if (quality == 393216) {
                int letters = 0;
                int uppercase = 0;
                int lowercase = 0;
                int numbers = 0;
                int symbols = 0;
                int nonletter = 0;
                for (int i = 0; i < password.length(); ++i) {
                    char c = password.charAt(i);
                    if (c >= 'A' && c <= 'Z') {
                        ++letters;
                        ++uppercase;
                        continue;
                    }
                    if (c >= 'a' && c <= 'z') {
                        ++letters;
                        ++lowercase;
                        continue;
                    }
                    if (c >= '0' && c <= '9') {
                        ++numbers;
                        ++nonletter;
                        continue;
                    }
                    ++symbols;
                    ++nonletter;
                }
                int neededLetters = this.getPasswordMinimumLetters(null, userHandle, false);
                if (letters < neededLetters) {
                    Slog.w(LOG_TAG, "resetPassword: number of letters " + letters + " does not meet required number of letters " + neededLetters);
                    return false;
                }
                int neededNumbers = this.getPasswordMinimumNumeric(null, userHandle, false);
                if (numbers < neededNumbers) {
                    Slog.w(LOG_TAG, "resetPassword: number of numerical digits " + numbers + " does not meet required number of numerical digits " + neededNumbers);
                    return false;
                }
                int neededLowerCase = this.getPasswordMinimumLowerCase(null, userHandle, false);
                if (lowercase < neededLowerCase) {
                    Slog.w(LOG_TAG, "resetPassword: number of lowercase letters " + lowercase + " does not meet required number of lowercase letters " + neededLowerCase);
                    return false;
                }
                int neededUpperCase = this.getPasswordMinimumUpperCase(null, userHandle, false);
                if (uppercase < neededUpperCase) {
                    Slog.w(LOG_TAG, "resetPassword: number of uppercase letters " + uppercase + " does not meet required number of uppercase letters " + neededUpperCase);
                    return false;
                }
                int neededSymbols = this.getPasswordMinimumSymbols(null, userHandle, false);
                if (symbols < neededSymbols) {
                    Slog.w(LOG_TAG, "resetPassword: number of special symbols " + symbols + " does not meet required number of special symbols " + neededSymbols);
                    return false;
                }
                int neededNonLetter = this.getPasswordMinimumNonLetter(null, userHandle, false);
                if (nonletter < neededNonLetter) {
                    Slog.w(LOG_TAG, "resetPassword: number of non-letter characters " + nonletter + " does not meet required number of non-letter characters " + neededNonLetter);
                    return false;
                }
            }
        }
        DevicePolicyData policy = this.getUserData(userHandle);
        if (policy.mPasswordOwner >= 0 && policy.mPasswordOwner != callingUid) {
            Slog.w(LOG_TAG, "resetPassword: already set by another uid and not entered by user");
            return false;
        }
        boolean callerIsDeviceOwnerAdmin = this.isCallerDeviceOwner(callingUid);
        boolean bl = doNotAskCredentialsOnBoot = (flags & 2) != 0;
        if (callerIsDeviceOwnerAdmin && doNotAskCredentialsOnBoot) {
            this.setDoNotAskCredentialsOnBoot();
        }
        long ident = this.mInjector.binderClearCallingIdentity();
        try {
            boolean requireEntry;
            if (!TextUtils.isEmpty(password)) {
                this.mLockPatternUtils.saveLockPassword(password, null, quality, userHandle);
            } else {
                this.mLockPatternUtils.clearLock(userHandle);
            }
            boolean bl2 = requireEntry = (flags & 1) != 0;
            if (requireEntry) {
                this.mLockPatternUtils.requireStrongAuth(2, -1);
            }
            DevicePolicyManagerService devicePolicyManagerService2 = this;
            synchronized (devicePolicyManagerService2) {
                int newOwner;
                int n = newOwner = requireEntry ? callingUid : -1;
                if (policy.mPasswordOwner != newOwner) {
                    policy.mPasswordOwner = newOwner;
                    this.saveSettingsLocked(userHandle);
                }
            }
        }
        finally {
            this.mInjector.binderRestoreCallingIdentity(ident);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isLockScreenSecureUnchecked(int userId) {
        long ident = this.mInjector.binderClearCallingIdentity();
        try {
            boolean bl = this.mLockPatternUtils.isSecure(userId);
            return bl;
        }
        finally {
            this.mInjector.binderRestoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setDoNotAskCredentialsOnBoot() {
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            DevicePolicyData policyData = this.getUserData(0);
            if (!policyData.doNotAskCredentialsOnBoot) {
                policyData.doNotAskCredentialsOnBoot = true;
                this.saveSettingsLocked(0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getDoNotAskCredentialsOnBoot() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.QUERY_DO_NOT_ASK_CREDENTIALS_ON_BOOT", null);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            DevicePolicyData policyData = this.getUserData(0);
            return policyData.doNotAskCredentialsOnBoot;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMaximumTimeToLock(ComponentName who, long timeMs, boolean parent) {
        if (!this.mHasFeature) {
            return;
        }
        Preconditions.checkNotNull(who, "ComponentName is null");
        int userHandle = this.mInjector.userHandleGetCallingUserId();
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            ActiveAdmin ap = this.getActiveAdminForCallerLocked(who, 3, parent);
            if (ap.maximumTimeToUnlock != timeMs) {
                ap.maximumTimeToUnlock = timeMs;
                this.saveSettingsLocked(userHandle);
                this.updateMaximumTimeToLockLocked(userHandle);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateMaximumTimeToLockLocked(int userHandle) {
        int[] profileIds;
        long timeMs = Long.MAX_VALUE;
        for (int profileId : profileIds = this.mUserManager.getProfileIdsWithDisabled(userHandle)) {
            DevicePolicyData policy = this.getUserDataUnchecked(profileId);
            int N = policy.mAdminList.size();
            for (int i = 0; i < N; ++i) {
                ActiveAdmin admin = policy.mAdminList.get(i);
                if (admin.maximumTimeToUnlock > 0L && timeMs > admin.maximumTimeToUnlock) {
                    timeMs = admin.maximumTimeToUnlock;
                }
                if (!admin.hasParentActiveAdmin()) continue;
                ActiveAdmin parentAdmin = admin.getParentActiveAdmin();
                if (parentAdmin.maximumTimeToUnlock <= 0L || timeMs <= parentAdmin.maximumTimeToUnlock) continue;
                timeMs = parentAdmin.maximumTimeToUnlock;
            }
        }
        DevicePolicyData policy = this.getUserDataUnchecked(this.getProfileParentId(userHandle));
        if (policy.mLastMaximumTimeToLock == timeMs) {
            return;
        }
        policy.mLastMaximumTimeToLock = timeMs;
        long ident = this.mInjector.binderClearCallingIdentity();
        try {
            if (policy.mLastMaximumTimeToLock != Long.MAX_VALUE) {
                this.mInjector.settingsGlobalPutInt("stay_on_while_plugged_in", 0);
            }
            this.mInjector.getPowerManagerInternal().setMaximumScreenOffTimeoutFromDeviceAdmin((int)Math.min(policy.mLastMaximumTimeToLock, Integer.MAX_VALUE));
        }
        finally {
            this.mInjector.binderRestoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getMaximumTimeToLock(ComponentName who, int userHandle, boolean parent) {
        if (!this.mHasFeature) {
            return 0L;
        }
        this.enforceFullCrossUsersPermission(userHandle);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            if (who != null) {
                ActiveAdmin admin = this.getActiveAdminUncheckedLocked(who, userHandle, parent);
                long l = admin != null ? admin.maximumTimeToUnlock : 0L;
                return l;
            }
            List<ActiveAdmin> admins = this.getActiveAdminsForLockscreenPoliciesLocked(userHandle, parent);
            return this.getMaximumTimeToLockPolicyFromAdmins(admins);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getMaximumTimeToLockForUserAndProfiles(int userHandle) {
        if (!this.mHasFeature) {
            return 0L;
        }
        this.enforceFullCrossUsersPermission(userHandle);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            ArrayList<ActiveAdmin> admins = new ArrayList<ActiveAdmin>();
            for (UserInfo userInfo : this.mUserManager.getProfiles(userHandle)) {
                DevicePolicyData policy = this.getUserData(userInfo.id);
                admins.addAll(policy.mAdminList);
                if (!userInfo.isManagedProfile()) continue;
                for (ActiveAdmin admin : policy.mAdminList) {
                    if (!admin.hasParentActiveAdmin()) continue;
                    admins.add(admin.getParentActiveAdmin());
                }
            }
            return this.getMaximumTimeToLockPolicyFromAdmins(admins);
        }
    }

    private long getMaximumTimeToLockPolicyFromAdmins(List<ActiveAdmin> admins) {
        long time = 0L;
        int N = admins.size();
        for (int i = 0; i < N; ++i) {
            ActiveAdmin admin = admins.get(i);
            if (time == 0L) {
                time = admin.maximumTimeToUnlock;
                continue;
            }
            if (admin.maximumTimeToUnlock == 0L || time <= admin.maximumTimeToUnlock) continue;
            time = admin.maximumTimeToUnlock;
        }
        return time;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void lockNow(boolean parent) {
        if (!this.mHasFeature) {
            return;
        }
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            this.getActiveAdminForCallerLocked(null, 3, parent);
            int userToLock = this.mInjector.userHandleGetCallingUserId();
            if (parent || !this.isSeparateProfileChallengeEnabled(userToLock)) {
                userToLock = -1;
            }
            long ident = this.mInjector.binderClearCallingIdentity();
            try {
                this.mLockPatternUtils.requireStrongAuth(2, userToLock);
                if (userToLock == -1) {
                    this.mInjector.powerManagerGoToSleep(SystemClock.uptimeMillis(), 1, 0);
                    this.mInjector.getIWindowManager().lockNow(null);
                }
            }
            catch (RemoteException remoteException) {
            }
            finally {
                this.mInjector.binderRestoreCallingIdentity(ident);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enforceCanManageCaCerts(ComponentName who) {
        if (who == null) {
            if (!this.isCallerDelegatedCertInstaller()) {
                this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_CA_CERTIFICATES", null);
            }
        } else {
            DevicePolicyManagerService devicePolicyManagerService = this;
            synchronized (devicePolicyManagerService) {
                this.getActiveAdminForCallerLocked(who, -1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enforceCanManageInstalledKeys(ComponentName who) {
        if (who == null) {
            if (!this.isCallerDelegatedCertInstaller()) {
                throw new SecurityException("who == null, but caller is not cert installer");
            }
        } else {
            DevicePolicyManagerService devicePolicyManagerService = this;
            synchronized (devicePolicyManagerService) {
                this.getActiveAdminForCallerLocked(who, -1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isCallerDelegatedCertInstaller() {
        int callingUid = this.mInjector.binderGetCallingUid();
        int userHandle = UserHandle.getUserId(callingUid);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            DevicePolicyData policy = this.getUserData(userHandle);
            if (policy.mDelegatedCertInstallerPackage == null) {
                return false;
            }
            try {
                int uid = this.mContext.getPackageManager().getPackageUidAsUser(policy.mDelegatedCertInstallerPackage, userHandle);
                return uid == callingUid;
            }
            catch (PackageManager.NameNotFoundException e) {
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean approveCaCert(String alias, int userId, boolean approval) {
        this.enforceManageUsers();
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            boolean changed;
            ArraySet<String> certs = this.getUserData((int)userId).mAcceptedCaCertificates;
            boolean bl = changed = approval ? certs.add(alias) : certs.remove(alias);
            if (!changed) {
                return false;
            }
            this.saveSettingsLocked(userId);
        }
        new MonitoringCertNotificationTask().execute(userId);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCaCertApproved(String alias, int userId) {
        this.enforceManageUsers();
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            return this.getUserData((int)userId).mAcceptedCaCertificates.contains(alias);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeCaApprovalsIfNeeded(int userId) {
        for (UserInfo userInfo : this.mUserManager.getProfiles(userId)) {
            boolean isSecure = this.mLockPatternUtils.isSecure(userInfo.id);
            if (userInfo.isManagedProfile()) {
                isSecure |= this.mLockPatternUtils.isSecure(this.getProfileParentId(userInfo.id));
            }
            if (isSecure) continue;
            DevicePolicyManagerService devicePolicyManagerService = this;
            synchronized (devicePolicyManagerService) {
                this.getUserData((int)userInfo.id).mAcceptedCaCertificates.clear();
                this.saveSettingsLocked(userInfo.id);
            }
            new MonitoringCertNotificationTask().execute(userInfo.id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean installCaCert(ComponentName admin, byte[] certBuffer) throws RemoteException {
        byte[] pemCert;
        this.enforceCanManageCaCerts(admin);
        try {
            X509Certificate cert = DevicePolicyManagerService.parseCert(certBuffer);
            pemCert = Credentials.convertToPem(cert);
        }
        catch (CertificateException ce) {
            Log.e(LOG_TAG, "Problem converting cert", ce);
            return false;
        }
        catch (IOException ioe) {
            Log.e(LOG_TAG, "Problem reading cert", ioe);
            return false;
        }
        UserHandle userHandle = new UserHandle(UserHandle.getCallingUserId());
        long id2 = this.mInjector.binderClearCallingIdentity();
        try {
            KeyChain.KeyChainConnection keyChainConnection = KeyChain.bindAsUser(this.mContext, userHandle);
            try {
                keyChainConnection.getService().installCaCertificate(pemCert);
                boolean bl = true;
                keyChainConnection.close();
                return bl;
            }
            catch (RemoteException e) {
                try {
                    try {
                        Log.e(LOG_TAG, "installCaCertsToKeyChain(): ", e);
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        keyChainConnection.close();
                    }
                }
                catch (InterruptedException e1) {
                    Log.w(LOG_TAG, "installCaCertsToKeyChain(): ", e1);
                    Thread.currentThread().interrupt();
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.mInjector.binderRestoreCallingIdentity(id2);
        }
        return false;
    }

    private static X509Certificate parseCert(byte[] certBuffer) throws CertificateException {
        CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
        return (X509Certificate)certFactory.generateCertificate(new ByteArrayInputStream(certBuffer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void uninstallCaCerts(ComponentName admin, String[] aliases) {
        this.enforceCanManageCaCerts(admin);
        UserHandle userHandle = new UserHandle(UserHandle.getCallingUserId());
        long id2 = this.mInjector.binderClearCallingIdentity();
        try (KeyChain.KeyChainConnection keyChainConnection = KeyChain.bindAsUser(this.mContext, userHandle);){
            for (int i = 0; i < aliases.length; ++i) {
                keyChainConnection.getService().deleteCaCertificate(aliases[i]);
            }
        }
        catch (InterruptedException ie) {
            Log.w(LOG_TAG, "CaCertUninstaller: ", ie);
            Thread.currentThread().interrupt();
        }
        finally {
            this.mInjector.binderRestoreCallingIdentity(id2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean installKeyPair(ComponentName who, byte[] privKey, byte[] cert, byte[] chain, String alias, boolean requestAccess) {
        this.enforceCanManageInstalledKeys(who);
        int callingUid = this.mInjector.binderGetCallingUid();
        long id2 = this.mInjector.binderClearCallingIdentity();
        try {
            IKeyChainService keyChain;
            KeyChain.KeyChainConnection keyChainConnection;
            block14: {
                keyChainConnection = KeyChain.bindAsUser(this.mContext, UserHandle.getUserHandleForUid(callingUid));
                keyChain = keyChainConnection.getService();
                if (keyChain.installKeyPair(privKey, cert, chain, alias)) break block14;
                boolean bl = false;
                keyChainConnection.close();
                return bl;
            }
            try {
                if (requestAccess) {
                    keyChain.setGrant(callingUid, alias, true);
                }
                boolean bl = true;
                keyChainConnection.close();
                return bl;
            }
            catch (RemoteException e) {
                try {
                    try {
                        Log.e(LOG_TAG, "Installing certificate", e);
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        keyChainConnection.close();
                    }
                }
                catch (InterruptedException e2) {
                    Log.w(LOG_TAG, "Interrupted while installing certificate", e2);
                    Thread.currentThread().interrupt();
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.mInjector.binderRestoreCallingIdentity(id2);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeKeyPair(ComponentName who, String alias) {
        this.enforceCanManageInstalledKeys(who);
        UserHandle userHandle = new UserHandle(UserHandle.getCallingUserId());
        long id2 = Binder.clearCallingIdentity();
        try {
            KeyChain.KeyChainConnection keyChainConnection = KeyChain.bindAsUser(this.mContext, userHandle);
            try {
                IKeyChainService keyChain = keyChainConnection.getService();
                boolean bl = keyChain.removeKeyPair(alias);
                keyChainConnection.close();
                return bl;
            }
            catch (RemoteException e) {
                try {
                    try {
                        Log.e(LOG_TAG, "Removing keypair", e);
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        keyChainConnection.close();
                    }
                }
                catch (InterruptedException e2) {
                    Log.w(LOG_TAG, "Interrupted while removing keypair", e2);
                    Thread.currentThread().interrupt();
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            Binder.restoreCallingIdentity(id2);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void choosePrivateKeyAlias(int uid, Uri uri, String alias, final IBinder response) {
        ActiveAdmin deviceOwnerAdmin;
        if (!this.isCallerWithSystemUid()) {
            return;
        }
        UserHandle caller = this.mInjector.binderGetCallingUserHandle();
        ComponentName aliasChooser = this.getProfileOwner(caller.getIdentifier());
        if (aliasChooser == null && caller.isSystem() && (deviceOwnerAdmin = this.getDeviceOwnerAdminLocked()) != null) {
            aliasChooser = deviceOwnerAdmin.info.getComponent();
        }
        if (aliasChooser == null) {
            this.sendPrivateKeyAliasResponse(null, response);
            return;
        }
        Intent intent = new Intent("android.app.action.CHOOSE_PRIVATE_KEY_ALIAS");
        intent.setComponent(aliasChooser);
        intent.putExtra("android.app.extra.CHOOSE_PRIVATE_KEY_SENDER_UID", uid);
        intent.putExtra("android.app.extra.CHOOSE_PRIVATE_KEY_URI", uri);
        intent.putExtra("android.app.extra.CHOOSE_PRIVATE_KEY_ALIAS", alias);
        intent.putExtra("android.app.extra.CHOOSE_PRIVATE_KEY_RESPONSE", response);
        long id2 = this.mInjector.binderClearCallingIdentity();
        try {
            this.mContext.sendOrderedBroadcastAsUser(intent, caller, null, new BroadcastReceiver(){

                @Override
                public void onReceive(Context context, Intent intent) {
                    String chosenAlias = this.getResultData();
                    DevicePolicyManagerService.this.sendPrivateKeyAliasResponse(chosenAlias, response);
                }
            }, null, -1, null, null);
        }
        finally {
            this.mInjector.binderRestoreCallingIdentity(id2);
        }
    }

    private void sendPrivateKeyAliasResponse(final String alias, IBinder responseBinder) {
        final IKeyChainAliasCallback keyChainAliasResponse = IKeyChainAliasCallback.Stub.asInterface(responseBinder);
        new AsyncTask<Void, Void, Void>(){

            protected Void doInBackground(Void ... unused) {
                try {
                    keyChainAliasResponse.alias(alias);
                }
                catch (Exception e) {
                    Log.e(DevicePolicyManagerService.LOG_TAG, "error while responding to callback", e);
                }
                return null;
            }
        }.execute(new Void[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCertInstallerPackage(ComponentName who, String installerPackage) throws SecurityException {
        int userHandle = UserHandle.getCallingUserId();
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            this.getActiveAdminForCallerLocked(who, -1);
            if (this.getTargetSdk(who.getPackageName(), userHandle) >= 24 && installerPackage != null && !this.isPackageInstalledForUser(installerPackage, userHandle)) {
                throw new IllegalArgumentException("Package " + installerPackage + " is not installed on the current user");
            }
            DevicePolicyData policy = this.getUserData(userHandle);
            policy.mDelegatedCertInstallerPackage = installerPackage;
            this.saveSettingsLocked(userHandle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getCertInstallerPackage(ComponentName who) throws SecurityException {
        int userHandle = UserHandle.getCallingUserId();
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            this.getActiveAdminForCallerLocked(who, -1);
            DevicePolicyData policy = this.getUserData(userHandle);
            return policy.mDelegatedCertInstallerPackage;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setAlwaysOnVpnPackage(ComponentName admin, String vpnPackage, boolean lockdown) throws SecurityException {
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            this.getActiveAdminForCallerLocked(admin, -1);
        }
        int userId = this.mInjector.userHandleGetCallingUserId();
        long token = this.mInjector.binderClearCallingIdentity();
        try {
            if (vpnPackage != null && !this.isPackageInstalledForUser(vpnPackage, userId)) {
                boolean bl = false;
                return bl;
            }
            ConnectivityManager connectivityManager = (ConnectivityManager)this.mContext.getSystemService("connectivity");
            if (!connectivityManager.setAlwaysOnVpnPackageForUser(userId, vpnPackage, lockdown)) {
                throw new UnsupportedOperationException();
            }
        }
        finally {
            this.mInjector.binderRestoreCallingIdentity(token);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getAlwaysOnVpnPackage(ComponentName admin) throws SecurityException {
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            this.getActiveAdminForCallerLocked(admin, -1);
        }
        int userId = this.mInjector.userHandleGetCallingUserId();
        long token = this.mInjector.binderClearCallingIdentity();
        try {
            ConnectivityManager connectivityManager = (ConnectivityManager)this.mContext.getSystemService("connectivity");
            String string2 = connectivityManager.getAlwaysOnVpnPackageForUser(userId);
            return string2;
        }
        finally {
            this.mInjector.binderRestoreCallingIdentity(token);
        }
    }

    private void wipeDataLocked(boolean wipeExtRequested, String reason) {
        if (wipeExtRequested) {
            StorageManager sm = (StorageManager)this.mContext.getSystemService("storage");
            sm.wipeAdoptableDisks();
        }
        try {
            RecoverySystem.rebootWipeUserData(this.mContext, reason);
        }
        catch (IOException | SecurityException e) {
            Slog.w(LOG_TAG, "Failed requesting data wipe", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void wipeData(int flags) {
        if (!this.mHasFeature) {
            return;
        }
        int userHandle = this.mInjector.userHandleGetCallingUserId();
        this.enforceFullCrossUsersPermission(userHandle);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            ActiveAdmin admin = this.getActiveAdminForCallerLocked(null, 4);
            String source = admin.info.getComponent().flattenToShortString();
            long ident = this.mInjector.binderClearCallingIdentity();
            try {
                if ((flags & 2) != 0) {
                    if (!this.isDeviceOwner(admin.info.getComponent(), userHandle)) {
                        throw new SecurityException("Only device owner admins can set WIPE_RESET_PROTECTION_DATA");
                    }
                    PersistentDataBlockManager manager = (PersistentDataBlockManager)this.mContext.getSystemService("persistent_data_block");
                    if (manager != null) {
                        manager.wipe();
                    }
                }
                boolean wipeExtRequested = (flags & 1) != 0;
                this.wipeDeviceOrUserLocked(wipeExtRequested, userHandle, "DevicePolicyManager.wipeData() from " + source);
            }
            finally {
                this.mInjector.binderRestoreCallingIdentity(ident);
            }
        }
    }

    private void wipeDeviceOrUserLocked(boolean wipeExtRequested, final int userHandle, String reason) {
        if (userHandle == 0) {
            this.wipeDataLocked(wipeExtRequested, reason);
        } else {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    try {
                        IActivityManager am = DevicePolicyManagerService.this.mInjector.getIActivityManager();
                        if (am.getCurrentUser().id == userHandle) {
                            am.switchUser(0);
                        }
                        boolean isManagedProfile = DevicePolicyManagerService.this.isManagedProfile(userHandle);
                        if (!DevicePolicyManagerService.this.mUserManager.removeUser(userHandle)) {
                            Slog.w(DevicePolicyManagerService.LOG_TAG, "Couldn't remove user " + userHandle);
                        } else if (isManagedProfile) {
                            DevicePolicyManagerService.this.sendWipeProfileNotification();
                        }
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                }
            });
        }
    }

    private void sendWipeProfileNotification() {
        String contentText = this.mContext.getString(17039626);
        Notification notification = new Notification.Builder(this.mContext).setSmallIcon(17301642).setContentTitle(this.mContext.getString(17039623)).setContentText(contentText).setColor(this.mContext.getColor(17170521)).setStyle(new Notification.BigTextStyle().bigText(contentText)).build();
        this.mInjector.getNotificationManager().notify(1001, notification);
    }

    private void clearWipeProfileNotification() {
        this.mInjector.getNotificationManager().cancel(1001);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getRemoveWarning(ComponentName comp, final RemoteCallback result, int userHandle) {
        if (!this.mHasFeature) {
            return;
        }
        this.enforceFullCrossUsersPermission(userHandle);
        this.mContext.enforceCallingOrSelfPermission("android.permission.BIND_DEVICE_ADMIN", null);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            ActiveAdmin admin = this.getActiveAdminUncheckedLocked(comp, userHandle);
            if (admin == null) {
                result.sendResult(null);
                return;
            }
            Intent intent = new Intent("android.app.action.DEVICE_ADMIN_DISABLE_REQUESTED");
            intent.setFlags(0x10000000);
            intent.setComponent(admin.info.getComponent());
            this.mContext.sendOrderedBroadcastAsUser(intent, new UserHandle(userHandle), null, new BroadcastReceiver(){

                @Override
                public void onReceive(Context context, Intent intent) {
                    result.sendResult(this.getResultExtras(false));
                }
            }, null, -1, null, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setActivePasswordState(int quality, int length, int letters, int uppercase, int lowercase, int numbers, int symbols, int nonletter, int userHandle) {
        if (!this.mHasFeature) {
            return;
        }
        this.enforceFullCrossUsersPermission(userHandle);
        if (!this.isSeparateProfileChallengeEnabled(userHandle)) {
            this.enforceNotManagedProfile(userHandle, "set the active password");
        }
        this.mContext.enforceCallingOrSelfPermission("android.permission.BIND_DEVICE_ADMIN", null);
        DevicePolicyManagerService.validateQualityConstant(quality);
        DevicePolicyData policy = this.getUserData(userHandle);
        long ident = this.mInjector.binderClearCallingIdentity();
        try {
            DevicePolicyManagerService devicePolicyManagerService = this;
            synchronized (devicePolicyManagerService) {
                policy.mActivePasswordQuality = quality;
                policy.mActivePasswordLength = length;
                policy.mActivePasswordLetters = letters;
                policy.mActivePasswordLowerCase = lowercase;
                policy.mActivePasswordUpperCase = uppercase;
                policy.mActivePasswordNumeric = numbers;
                policy.mActivePasswordSymbols = symbols;
                policy.mActivePasswordNonLetter = nonletter;
                policy.mFailedPasswordAttempts = 0;
                this.saveSettingsLocked(userHandle);
                this.updatePasswordExpirationsLocked(userHandle);
                this.setExpirationAlarmCheckLocked(this.mContext, userHandle, false);
                this.sendAdminCommandForLockscreenPoliciesLocked("android.app.action.ACTION_PASSWORD_CHANGED", 0, userHandle);
            }
            this.removeCaApprovalsIfNeeded(userHandle);
        }
        finally {
            this.mInjector.binderRestoreCallingIdentity(ident);
        }
    }

    private void updatePasswordExpirationsLocked(int userHandle) {
        ArraySet<Integer> affectedUserIds = new ArraySet<Integer>();
        List<ActiveAdmin> admins = this.getActiveAdminsForLockscreenPoliciesLocked(userHandle, false);
        int N = admins.size();
        for (int i = 0; i < N; ++i) {
            long expiration;
            ActiveAdmin admin = admins.get(i);
            if (!admin.info.usesPolicy(6)) continue;
            affectedUserIds.add(admin.getUserHandle().getIdentifier());
            long timeout = admin.passwordExpirationTimeout;
            admin.passwordExpirationDate = expiration = timeout > 0L ? timeout + System.currentTimeMillis() : 0L;
        }
        Iterator iterator = affectedUserIds.iterator();
        while (iterator.hasNext()) {
            int affectedUserId = (Integer)iterator.next();
            this.saveSettingsLocked(affectedUserId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reportFailedPasswordAttempt(int userHandle) {
        this.enforceFullCrossUsersPermission(userHandle);
        if (!this.isSeparateProfileChallengeEnabled(userHandle)) {
            this.enforceNotManagedProfile(userHandle, "report failed password attempt if separate profile challenge is not in place");
        }
        this.mContext.enforceCallingOrSelfPermission("android.permission.BIND_DEVICE_ADMIN", null);
        long ident = this.mInjector.binderClearCallingIdentity();
        try {
            boolean wipeData = false;
            int identifier = 0;
            DevicePolicyManagerService devicePolicyManagerService = this;
            synchronized (devicePolicyManagerService) {
                DevicePolicyData policy = this.getUserData(userHandle);
                ++policy.mFailedPasswordAttempts;
                this.saveSettingsLocked(userHandle);
                if (this.mHasFeature) {
                    int max;
                    ActiveAdmin strictestAdmin = this.getAdminWithMinimumFailedPasswordsForWipeLocked(userHandle, false);
                    int n = max = strictestAdmin != null ? strictestAdmin.maximumFailedPasswordsForWipe : 0;
                    if (max > 0 && policy.mFailedPasswordAttempts >= max) {
                        wipeData = true;
                        identifier = strictestAdmin.getUserHandle().getIdentifier();
                    }
                    this.sendAdminCommandForLockscreenPoliciesLocked("android.app.action.ACTION_PASSWORD_FAILED", 1, userHandle);
                }
            }
            if (wipeData) {
                this.wipeDeviceOrUserLocked(false, identifier, "reportFailedPasswordAttempt()");
            }
        }
        finally {
            this.mInjector.binderRestoreCallingIdentity(ident);
        }
        if (this.mInjector.securityLogIsLoggingEnabled()) {
            SecurityLog.writeEvent(210007, 0, 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reportSuccessfulPasswordAttempt(int userHandle) {
        this.enforceFullCrossUsersPermission(userHandle);
        this.mContext.enforceCallingOrSelfPermission("android.permission.BIND_DEVICE_ADMIN", null);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            DevicePolicyData policy = this.getUserData(userHandle);
            if (policy.mFailedPasswordAttempts != 0 || policy.mPasswordOwner >= 0) {
                long ident = this.mInjector.binderClearCallingIdentity();
                try {
                    policy.mFailedPasswordAttempts = 0;
                    policy.mPasswordOwner = -1;
                    this.saveSettingsLocked(userHandle);
                    if (this.mHasFeature) {
                        this.sendAdminCommandForLockscreenPoliciesLocked("android.app.action.ACTION_PASSWORD_SUCCEEDED", 1, userHandle);
                    }
                }
                finally {
                    this.mInjector.binderRestoreCallingIdentity(ident);
                }
            }
        }
        if (this.mInjector.securityLogIsLoggingEnabled()) {
            SecurityLog.writeEvent(210007, 1, 1);
        }
    }

    @Override
    public void reportFailedFingerprintAttempt(int userHandle) {
        this.enforceFullCrossUsersPermission(userHandle);
        this.mContext.enforceCallingOrSelfPermission("android.permission.BIND_DEVICE_ADMIN", null);
        if (this.mInjector.securityLogIsLoggingEnabled()) {
            SecurityLog.writeEvent(210007, 0, 0);
        }
    }

    @Override
    public void reportSuccessfulFingerprintAttempt(int userHandle) {
        this.enforceFullCrossUsersPermission(userHandle);
        this.mContext.enforceCallingOrSelfPermission("android.permission.BIND_DEVICE_ADMIN", null);
        if (this.mInjector.securityLogIsLoggingEnabled()) {
            SecurityLog.writeEvent(210007, 1, 0);
        }
    }

    @Override
    public void reportKeyguardDismissed(int userHandle) {
        this.enforceFullCrossUsersPermission(userHandle);
        this.mContext.enforceCallingOrSelfPermission("android.permission.BIND_DEVICE_ADMIN", null);
        if (this.mInjector.securityLogIsLoggingEnabled()) {
            SecurityLog.writeEvent(210006, new Object[0]);
        }
    }

    @Override
    public void reportKeyguardSecured(int userHandle) {
        this.enforceFullCrossUsersPermission(userHandle);
        this.mContext.enforceCallingOrSelfPermission("android.permission.BIND_DEVICE_ADMIN", null);
        if (this.mInjector.securityLogIsLoggingEnabled()) {
            SecurityLog.writeEvent(210008, new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ComponentName setGlobalProxy(ComponentName who, String proxySpec, String exclusionList) {
        if (!this.mHasFeature) {
            return null;
        }
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            Preconditions.checkNotNull(who, "ComponentName is null");
            DevicePolicyData policy = this.getUserData(0);
            ActiveAdmin admin = this.getActiveAdminForCallerLocked(who, 5);
            Set<ComponentName> compSet = policy.mAdminMap.keySet();
            for (ComponentName component : compSet) {
                ActiveAdmin ap = policy.mAdminMap.get(component);
                if (!ap.specifiesGlobalProxy || component.equals(who)) continue;
                return component;
            }
            if (UserHandle.getCallingUserId() != 0) {
                Slog.w(LOG_TAG, "Only the owner is allowed to set the global proxy. User " + UserHandle.getCallingUserId() + " is not permitted.");
                return null;
            }
            if (proxySpec == null) {
                admin.specifiesGlobalProxy = false;
                admin.globalProxySpec = null;
                admin.globalProxyExclusionList = null;
            } else {
                admin.specifiesGlobalProxy = true;
                admin.globalProxySpec = proxySpec;
                admin.globalProxyExclusionList = exclusionList;
            }
            long origId = this.mInjector.binderClearCallingIdentity();
            try {
                this.resetGlobalProxyLocked(policy);
            }
            finally {
                this.mInjector.binderRestoreCallingIdentity(origId);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ComponentName getGlobalProxyAdmin(int userHandle) {
        if (!this.mHasFeature) {
            return null;
        }
        this.enforceFullCrossUsersPermission(userHandle);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            DevicePolicyData policy = this.getUserData(0);
            int N = policy.mAdminList.size();
            for (int i = 0; i < N; ++i) {
                ActiveAdmin ap = policy.mAdminList.get(i);
                if (!ap.specifiesGlobalProxy) continue;
                return ap.info.getComponent();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRecommendedGlobalProxy(ComponentName who, ProxyInfo proxyInfo) {
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            this.getActiveAdminForCallerLocked(who, -2);
        }
        long token = this.mInjector.binderClearCallingIdentity();
        try {
            ConnectivityManager connectivityManager = (ConnectivityManager)this.mContext.getSystemService("connectivity");
            connectivityManager.setGlobalProxy(proxyInfo);
        }
        finally {
            this.mInjector.binderRestoreCallingIdentity(token);
        }
    }

    private void resetGlobalProxyLocked(DevicePolicyData policy) {
        int N = policy.mAdminList.size();
        for (int i = 0; i < N; ++i) {
            ActiveAdmin ap = policy.mAdminList.get(i);
            if (!ap.specifiesGlobalProxy) continue;
            this.saveGlobalProxyLocked(ap.globalProxySpec, ap.globalProxyExclusionList);
            return;
        }
        this.saveGlobalProxyLocked(null, null);
    }

    private void saveGlobalProxyLocked(String proxySpec, String exclusionList) {
        ProxyInfo proxyProperties;
        if (exclusionList == null) {
            exclusionList = "";
        }
        if (proxySpec == null) {
            proxySpec = "";
        }
        proxySpec = proxySpec.trim();
        String[] data = proxySpec.split(":");
        int proxyPort = 8080;
        if (data.length > 1) {
            try {
                proxyPort = Integer.parseInt(data[1]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (!(proxyProperties = new ProxyInfo(data[0], proxyPort, exclusionList = exclusionList.trim())).isValid()) {
            Slog.e(LOG_TAG, "Invalid proxy properties, ignoring: " + proxyProperties.toString());
            return;
        }
        this.mInjector.settingsGlobalPutString("global_http_proxy_host", data[0]);
        this.mInjector.settingsGlobalPutInt("global_http_proxy_port", proxyPort);
        this.mInjector.settingsGlobalPutString("global_http_proxy_exclusion_list", exclusionList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int setStorageEncryption(ComponentName who, boolean encrypt) {
        if (!this.mHasFeature) {
            return 0;
        }
        Preconditions.checkNotNull(who, "ComponentName is null");
        int userHandle = UserHandle.getCallingUserId();
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            if (userHandle != 0) {
                Slog.w(LOG_TAG, "Only owner/system user is allowed to set storage encryption. User " + UserHandle.getCallingUserId() + " is not permitted.");
                return 0;
            }
            ActiveAdmin ap = this.getActiveAdminForCallerLocked(who, 7);
            if (!this.isEncryptionSupported()) {
                return 0;
            }
            if (ap.encryptionRequested != encrypt) {
                ap.encryptionRequested = encrypt;
                this.saveSettingsLocked(userHandle);
            }
            DevicePolicyData policy = this.getUserData(0);
            boolean newRequested = false;
            int N = policy.mAdminList.size();
            for (int i = 0; i < N; ++i) {
                newRequested |= policy.mAdminList.get((int)i).encryptionRequested;
            }
            this.setEncryptionRequested(newRequested);
            return newRequested ? 3 : 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getStorageEncryption(ComponentName who, int userHandle) {
        if (!this.mHasFeature) {
            return false;
        }
        this.enforceFullCrossUsersPermission(userHandle);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            if (who != null) {
                ActiveAdmin ap = this.getActiveAdminUncheckedLocked(who, userHandle);
                boolean bl = ap != null ? ap.encryptionRequested : false;
                return bl;
            }
            DevicePolicyData policy = this.getUserData(userHandle);
            int N = policy.mAdminList.size();
            for (int i = 0; i < N; ++i) {
                if (!policy.mAdminList.get((int)i).encryptionRequested) continue;
                return true;
            }
            return false;
        }
    }

    @Override
    public int getStorageEncryptionStatus(String callerPackage, int userHandle) {
        ApplicationInfo ai;
        if (!this.mHasFeature) {
            // empty if block
        }
        this.enforceFullCrossUsersPermission(userHandle);
        this.ensureCallerPackage(callerPackage);
        try {
            ai = this.mIPackageManager.getApplicationInfo(callerPackage, 0, userHandle);
        }
        catch (RemoteException e) {
            throw new SecurityException(e);
        }
        boolean legacyApp = false;
        if (ai.targetSdkVersion <= 23) {
            legacyApp = true;
        } else if ("com.google.android.apps.enterprise.dmagent".equals(ai.packageName) && ai.versionCode == 697) {
            legacyApp = true;
        }
        int rawStatus = this.getEncryptionStatus();
        if (rawStatus == 5 && legacyApp) {
            return 3;
        }
        return rawStatus;
    }

    private boolean isEncryptionSupported() {
        return this.getEncryptionStatus() != 0;
    }

    private int getEncryptionStatus() {
        if (this.mInjector.storageManagerIsFileBasedEncryptionEnabled()) {
            return 5;
        }
        if (this.mInjector.storageManagerIsNonDefaultBlockEncrypted()) {
            return 3;
        }
        if (this.mInjector.storageManagerIsEncrypted()) {
            return 4;
        }
        if (this.mInjector.storageManagerIsEncryptable()) {
            return 1;
        }
        return 0;
    }

    private void setEncryptionRequested(boolean encrypt) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setScreenCaptureDisabled(ComponentName who, boolean disabled) {
        if (!this.mHasFeature) {
            return;
        }
        Preconditions.checkNotNull(who, "ComponentName is null");
        int userHandle = UserHandle.getCallingUserId();
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            ActiveAdmin ap = this.getActiveAdminForCallerLocked(who, -1);
            if (ap.disableScreenCapture != disabled) {
                ap.disableScreenCapture = disabled;
                this.saveSettingsLocked(userHandle);
                this.updateScreenCaptureDisabledInWindowManager(userHandle, disabled);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getScreenCaptureDisabled(ComponentName who, int userHandle) {
        if (!this.mHasFeature) {
            return false;
        }
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            if (who != null) {
                ActiveAdmin admin = this.getActiveAdminUncheckedLocked(who, userHandle);
                boolean bl = admin != null ? admin.disableScreenCapture : false;
                return bl;
            }
            DevicePolicyData policy = this.getUserData(userHandle);
            int N = policy.mAdminList.size();
            for (int i = 0; i < N; ++i) {
                ActiveAdmin admin = policy.mAdminList.get(i);
                if (!admin.disableScreenCapture) continue;
                return true;
            }
            return false;
        }
    }

    private void updateScreenCaptureDisabledInWindowManager(final int userHandle, final boolean disabled) {
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                try {
                    DevicePolicyManagerService.this.mInjector.getIWindowManager().setScreenCaptureDisabled(userHandle, disabled);
                }
                catch (RemoteException e) {
                    Log.w(DevicePolicyManagerService.LOG_TAG, "Unable to notify WindowManager.", e);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAutoTimeRequired(ComponentName who, boolean required) {
        if (!this.mHasFeature) {
            return;
        }
        Preconditions.checkNotNull(who, "ComponentName is null");
        int userHandle = UserHandle.getCallingUserId();
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            ActiveAdmin admin = this.getActiveAdminForCallerLocked(who, -2);
            if (admin.requireAutoTime != required) {
                admin.requireAutoTime = required;
                this.saveSettingsLocked(userHandle);
            }
        }
        if (required) {
            long ident = this.mInjector.binderClearCallingIdentity();
            try {
                this.mInjector.settingsGlobalPutInt("auto_time", 1);
            }
            finally {
                this.mInjector.binderRestoreCallingIdentity(ident);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getAutoTimeRequired() {
        if (!this.mHasFeature) {
            return false;
        }
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            ActiveAdmin deviceOwner = this.getDeviceOwnerAdminLocked();
            return deviceOwner != null ? deviceOwner.requireAutoTime : false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setForceEphemeralUsers(ComponentName who, boolean forceEphemeralUsers) {
        if (!this.mHasFeature) {
            return;
        }
        Preconditions.checkNotNull(who, "ComponentName is null");
        if (forceEphemeralUsers && !this.mInjector.userManagerIsSplitSystemUser()) {
            throw new UnsupportedOperationException("Cannot force ephemeral users on systems without split system user.");
        }
        boolean removeAllUsers = false;
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            ActiveAdmin deviceOwner = this.getActiveAdminForCallerLocked(who, -2);
            if (deviceOwner.forceEphemeralUsers != forceEphemeralUsers) {
                deviceOwner.forceEphemeralUsers = forceEphemeralUsers;
                this.saveSettingsLocked(this.mInjector.userHandleGetCallingUserId());
                this.mUserManagerInternal.setForceEphemeralUsers(forceEphemeralUsers);
                removeAllUsers = forceEphemeralUsers;
            }
        }
        if (removeAllUsers) {
            long identitity = this.mInjector.binderClearCallingIdentity();
            try {
                this.mUserManagerInternal.removeAllUsers();
            }
            finally {
                this.mInjector.binderRestoreCallingIdentity(identitity);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getForceEphemeralUsers(ComponentName who) {
        if (!this.mHasFeature) {
            return false;
        }
        Preconditions.checkNotNull(who, "ComponentName is null");
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            ActiveAdmin deviceOwner = this.getActiveAdminForCallerLocked(who, -2);
            return deviceOwner.forceEphemeralUsers;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isDeviceOwnerManagedSingleUserDevice() {
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            if (!this.mOwners.hasDeviceOwner()) {
                return false;
            }
        }
        long callingIdentity = this.mInjector.binderClearCallingIdentity();
        try {
            if (this.mInjector.userManagerIsSplitSystemUser()) {
                boolean bl = this.mUserManager.getUserCount() == 2 && this.mOwners.getDeviceOwnerUserId() != 0;
                return bl;
            }
            boolean bl = this.mUserManager.getUserCount() == 1;
            return bl;
        }
        finally {
            this.mInjector.binderRestoreCallingIdentity(callingIdentity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureDeviceOwnerManagingSingleUser(ComponentName who) throws SecurityException {
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            this.getActiveAdminForCallerLocked(who, -2);
        }
        if (!this.isDeviceOwnerManagedSingleUserDevice()) {
            throw new SecurityException("There should only be one user, managed by Device Owner");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean requestBugreport(ComponentName who) {
        if (!this.mHasFeature) {
            return false;
        }
        Preconditions.checkNotNull(who, "ComponentName is null");
        this.ensureDeviceOwnerManagingSingleUser(who);
        if (this.mRemoteBugreportServiceIsActive.get() || this.getDeviceOwnerRemoteBugreportUri() != null) {
            Slog.d(LOG_TAG, "Remote bugreport wasn't started because there's already one running.");
            return false;
        }
        long callingIdentity = this.mInjector.binderClearCallingIdentity();
        try {
            ActivityManagerNative.getDefault().requestBugReport(2);
            this.mRemoteBugreportServiceIsActive.set(true);
            this.mRemoteBugreportSharingAccepted.set(false);
            this.registerRemoteBugreportReceivers();
            this.mInjector.getNotificationManager().notifyAsUser(LOG_TAG, 678432343, RemoteBugreportUtils.buildNotification(this.mContext, 1), UserHandle.ALL);
            this.mHandler.postDelayed(this.mRemoteBugreportTimeoutRunnable, 600000L);
            boolean bl = true;
            return bl;
        }
        catch (RemoteException re) {
            Slog.e(LOG_TAG, "Failed to make remote calls to start bugreportremote service", re);
            boolean bl = false;
            return bl;
        }
        finally {
            this.mInjector.binderRestoreCallingIdentity(callingIdentity);
        }
    }

    synchronized void sendDeviceOwnerCommand(String action, Bundle extras) {
        Intent intent = new Intent(action);
        intent.setComponent(this.mOwners.getDeviceOwnerComponent());
        if (extras != null) {
            intent.putExtras(extras);
        }
        this.mContext.sendBroadcastAsUser(intent, UserHandle.of(this.mOwners.getDeviceOwnerUserId()));
    }

    private synchronized String getDeviceOwnerRemoteBugreportUri() {
        return this.mOwners.getDeviceOwnerRemoteBugreportUri();
    }

    private synchronized void setDeviceOwnerRemoteBugreportUriAndHash(String bugreportUri, String bugreportHash) {
        this.mOwners.setDeviceOwnerRemoteBugreportUriAndHash(bugreportUri, bugreportHash);
    }

    private void registerRemoteBugreportReceivers() {
        try {
            IntentFilter filterFinished = new IntentFilter("android.intent.action.REMOTE_BUGREPORT_DISPATCH", "application/vnd.android.bugreport");
            this.mContext.registerReceiver(this.mRemoteBugreportFinishedReceiver, filterFinished);
        }
        catch (IntentFilter.MalformedMimeTypeException e) {
            Slog.w(LOG_TAG, "Failed to set type application/vnd.android.bugreport", e);
        }
        IntentFilter filterConsent = new IntentFilter();
        filterConsent.addAction("com.android.server.action.BUGREPORT_SHARING_DECLINED");
        filterConsent.addAction("com.android.server.action.BUGREPORT_SHARING_ACCEPTED");
        this.mContext.registerReceiver(this.mRemoteBugreportConsentReceiver, filterConsent);
    }

    private void onBugreportFinished(Intent intent) {
        this.mHandler.removeCallbacks(this.mRemoteBugreportTimeoutRunnable);
        this.mRemoteBugreportServiceIsActive.set(false);
        Uri bugreportUri = intent.getData();
        String bugreportUriString = null;
        if (bugreportUri != null) {
            bugreportUriString = bugreportUri.toString();
        }
        String bugreportHash = intent.getStringExtra("android.intent.extra.REMOTE_BUGREPORT_HASH");
        if (this.mRemoteBugreportSharingAccepted.get()) {
            this.shareBugreportWithDeviceOwnerIfExists(bugreportUriString, bugreportHash);
            this.mInjector.getNotificationManager().cancel(LOG_TAG, 678432343);
        } else {
            this.setDeviceOwnerRemoteBugreportUriAndHash(bugreportUriString, bugreportHash);
            this.mInjector.getNotificationManager().notifyAsUser(LOG_TAG, 678432343, RemoteBugreportUtils.buildNotification(this.mContext, 3), UserHandle.ALL);
        }
        this.mContext.unregisterReceiver(this.mRemoteBugreportFinishedReceiver);
    }

    private void onBugreportFailed() {
        this.mRemoteBugreportServiceIsActive.set(false);
        this.mInjector.systemPropertiesSet("ctl.stop", "bugreportremote");
        this.mRemoteBugreportSharingAccepted.set(false);
        this.setDeviceOwnerRemoteBugreportUriAndHash(null, null);
        this.mInjector.getNotificationManager().cancel(LOG_TAG, 678432343);
        Bundle extras = new Bundle();
        extras.putInt("android.app.extra.BUGREPORT_FAILURE_REASON", 0);
        this.sendDeviceOwnerCommand("android.app.action.BUGREPORT_FAILED", extras);
        this.mContext.unregisterReceiver(this.mRemoteBugreportConsentReceiver);
        this.mContext.unregisterReceiver(this.mRemoteBugreportFinishedReceiver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onBugreportSharingAccepted() {
        this.mRemoteBugreportSharingAccepted.set(true);
        String bugreportUriString = null;
        String bugreportHash = null;
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            bugreportUriString = this.getDeviceOwnerRemoteBugreportUri();
            bugreportHash = this.mOwners.getDeviceOwnerRemoteBugreportHash();
        }
        if (bugreportUriString != null) {
            this.shareBugreportWithDeviceOwnerIfExists(bugreportUriString, bugreportHash);
        } else if (this.mRemoteBugreportServiceIsActive.get()) {
            this.mInjector.getNotificationManager().notifyAsUser(LOG_TAG, 678432343, RemoteBugreportUtils.buildNotification(this.mContext, 2), UserHandle.ALL);
        }
    }

    private void onBugreportSharingDeclined() {
        if (this.mRemoteBugreportServiceIsActive.get()) {
            this.mInjector.systemPropertiesSet("ctl.stop", "bugreportremote");
            this.mRemoteBugreportServiceIsActive.set(false);
            this.mHandler.removeCallbacks(this.mRemoteBugreportTimeoutRunnable);
            this.mContext.unregisterReceiver(this.mRemoteBugreportFinishedReceiver);
        }
        this.mRemoteBugreportSharingAccepted.set(false);
        this.setDeviceOwnerRemoteBugreportUriAndHash(null, null);
        this.sendDeviceOwnerCommand("android.app.action.BUGREPORT_SHARING_DECLINED", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shareBugreportWithDeviceOwnerIfExists(String bugreportUriString, String bugreportHash) {
        ParcelFileDescriptor pfd = null;
        try {
            if (bugreportUriString == null) {
                throw new FileNotFoundException();
            }
            Uri bugreportUri = Uri.parse(bugreportUriString);
            pfd = this.mContext.getContentResolver().openFileDescriptor(bugreportUri, "r");
            DevicePolicyManagerService devicePolicyManagerService = this;
            synchronized (devicePolicyManagerService) {
                Intent intent = new Intent("android.app.action.BUGREPORT_SHARE");
                intent.setComponent(this.mOwners.getDeviceOwnerComponent());
                intent.setDataAndType(bugreportUri, "application/vnd.android.bugreport");
                intent.putExtra("android.app.extra.BUGREPORT_HASH", bugreportHash);
                this.mContext.grantUriPermission(this.mOwners.getDeviceOwnerComponent().getPackageName(), bugreportUri, 1);
                this.mContext.sendBroadcastAsUser(intent, UserHandle.of(this.mOwners.getDeviceOwnerUserId()));
            }
        }
        catch (FileNotFoundException e) {
            Bundle extras = new Bundle();
            extras.putInt("android.app.extra.BUGREPORT_FAILURE_REASON", 1);
            this.sendDeviceOwnerCommand("android.app.action.BUGREPORT_FAILED", extras);
        }
        finally {
            try {
                if (pfd != null) {
                    pfd.close();
                }
            }
            catch (IOException iOException) {}
            this.mRemoteBugreportSharingAccepted.set(false);
            this.setDeviceOwnerRemoteBugreportUriAndHash(null, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCameraDisabled(ComponentName who, boolean disabled) {
        if (!this.mHasFeature) {
            return;
        }
        Preconditions.checkNotNull(who, "ComponentName is null");
        int userHandle = this.mInjector.userHandleGetCallingUserId();
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            ActiveAdmin ap = this.getActiveAdminForCallerLocked(who, 8);
            if (ap.disableCamera != disabled) {
                ap.disableCamera = disabled;
                this.saveSettingsLocked(userHandle);
            }
        }
        this.pushUserRestrictions(userHandle);
    }

    @Override
    public boolean getCameraDisabled(ComponentName who, int userHandle) {
        return this.getCameraDisabled(who, userHandle, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getCameraDisabled(ComponentName who, int userHandle, boolean mergeDeviceOwnerRestriction) {
        if (!this.mHasFeature) {
            return false;
        }
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            ActiveAdmin deviceOwner;
            if (who != null) {
                ActiveAdmin admin = this.getActiveAdminUncheckedLocked(who, userHandle);
                boolean bl = admin != null ? admin.disableCamera : false;
                return bl;
            }
            if (mergeDeviceOwnerRestriction && (deviceOwner = this.getDeviceOwnerAdminLocked()) != null && deviceOwner.disableCamera) {
                return true;
            }
            DevicePolicyData policy = this.getUserData(userHandle);
            int N = policy.mAdminList.size();
            for (int i = 0; i < N; ++i) {
                ActiveAdmin admin = policy.mAdminList.get(i);
                if (!admin.disableCamera) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setKeyguardDisabledFeatures(ComponentName who, int which, boolean parent) {
        if (!this.mHasFeature) {
            return;
        }
        Preconditions.checkNotNull(who, "ComponentName is null");
        int userHandle = this.mInjector.userHandleGetCallingUserId();
        if (this.isManagedProfile(userHandle)) {
            which = parent ? (which &= 0x30) : (which &= 0x38);
        }
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            ActiveAdmin ap = this.getActiveAdminForCallerLocked(who, 9, parent);
            if (ap.disabledKeyguardFeatures != which) {
                ap.disabledKeyguardFeatures = which;
                this.saveSettingsLocked(userHandle);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int getKeyguardDisabledFeatures(ComponentName who, int userHandle, boolean parent) {
        int i;
        int N;
        int which;
        List<ActiveAdmin> admins;
        if (!this.mHasFeature) {
            return 0;
        }
        this.enforceFullCrossUsersPermission(userHandle);
        long ident = this.mInjector.binderClearCallingIdentity();
        try {
            DevicePolicyManagerService devicePolicyManagerService = this;
            synchronized (devicePolicyManagerService) {
                if (who != null) {
                    ActiveAdmin admin = this.getActiveAdminUncheckedLocked(who, userHandle, parent);
                    int n = admin != null ? admin.disabledKeyguardFeatures : 0;
                    // MONITOREXIT @DISABLED, blocks:[0, 4, 8] lbl11 : MonitorExitStatement: MONITOREXIT : var6_5
                    this.mInjector.binderRestoreCallingIdentity(ident);
                    return n;
                }
                admins = !parent && this.isManagedProfile(userHandle) ? this.getUserDataUnchecked((int)userHandle).mAdminList : this.getActiveAdminsForLockscreenPoliciesLocked(userHandle, parent);
                which = 0;
                N = admins.size();
                i = 0;
            }
        }
        catch (Throwable throwable) {
            this.mInjector.binderRestoreCallingIdentity(ident);
            throw throwable;
        }
        {
            while (true) {
                boolean isRequestedUser;
                if (i >= N) {
                    int n = which;
                    // MONITOREXIT @DISABLED, blocks:[4, 6, 7] lbl25 : MonitorExitStatement: MONITOREXIT : var6_5
                    this.mInjector.binderRestoreCallingIdentity(ident);
                    return n;
                }
                ActiveAdmin admin = admins.get(i);
                int userId = admin.getUserHandle().getIdentifier();
                boolean bl = isRequestedUser = !parent && userId == userHandle;
                which = isRequestedUser || !this.isManagedProfile(userId) ? (which |= admin.disabledKeyguardFeatures) : (which |= admin.disabledKeyguardFeatures & 0x30);
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setKeepUninstalledPackages(ComponentName who, List<String> packageList) {
        if (!this.mHasFeature) {
            return;
        }
        Preconditions.checkNotNull(who, "ComponentName is null");
        Preconditions.checkNotNull(packageList, "packageList is null");
        int userHandle = UserHandle.getCallingUserId();
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            ActiveAdmin admin = this.getActiveAdminForCallerLocked(who, -2);
            admin.keepUninstalledPackages = packageList;
            this.saveSettingsLocked(userHandle);
            this.mInjector.getPackageManagerInternal().setKeepUninstalledPackages(packageList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getKeepUninstalledPackages(ComponentName who) {
        Preconditions.checkNotNull(who, "ComponentName is null");
        if (!this.mHasFeature) {
            return null;
        }
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            this.getActiveAdminForCallerLocked(who, -2);
            return this.getKeepUninstalledPackagesLocked();
        }
    }

    private List<String> getKeepUninstalledPackagesLocked() {
        ActiveAdmin deviceOwner = this.getDeviceOwnerAdminLocked();
        return deviceOwner != null ? deviceOwner.keepUninstalledPackages : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setDeviceOwner(ComponentName admin, String ownerName, int userId) {
        if (!this.mHasFeature) {
            return false;
        }
        if (admin == null || !this.isPackageInstalledForUser(admin.getPackageName(), userId)) {
            throw new IllegalArgumentException("Invalid component " + admin + " for device owner");
        }
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            this.enforceCanSetDeviceOwnerLocked(userId);
            if (this.getActiveAdminUncheckedLocked(admin, userId) == null) {
                throw new IllegalArgumentException("Not active admin: " + admin);
            }
            long ident = this.mInjector.binderClearCallingIdentity();
            try {
                if (this.mInjector.getIBackupManager() != null) {
                    this.mInjector.getIBackupManager().setBackupServiceActive(0, false);
                }
            }
            catch (RemoteException e) {
                throw new IllegalStateException("Failed deactivating backup service.", e);
            }
            finally {
                this.mInjector.binderRestoreCallingIdentity(ident);
            }
            this.mOwners.setDeviceOwner(admin, ownerName, userId);
            this.mOwners.writeDeviceOwner();
            this.updateDeviceOwnerLocked();
            this.setDeviceOwnerSystemPropertyLocked();
            Intent intent = new Intent("android.app.action.DEVICE_OWNER_CHANGED");
            ident = this.mInjector.binderClearCallingIdentity();
            try {
                this.mContext.sendBroadcastAsUser(intent, new UserHandle(userId));
            }
            finally {
                this.mInjector.binderRestoreCallingIdentity(ident);
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDeviceOwner(ComponentName who, int userId) {
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            return this.mOwners.hasDeviceOwner() && this.mOwners.getDeviceOwnerUserId() == userId && this.mOwners.getDeviceOwnerComponent().equals(who);
        }
    }

    public boolean isProfileOwner(ComponentName who, int userId) {
        ComponentName profileOwner = this.getProfileOwner(userId);
        return who != null && who.equals(profileOwner);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ComponentName getDeviceOwnerComponent(boolean callingUserOnly) {
        if (!this.mHasFeature) {
            return null;
        }
        if (!callingUserOnly) {
            this.enforceManageUsers();
        }
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            if (!this.mOwners.hasDeviceOwner()) {
                return null;
            }
            if (callingUserOnly && this.mInjector.userHandleGetCallingUserId() != this.mOwners.getDeviceOwnerUserId()) {
                return null;
            }
            return this.mOwners.getDeviceOwnerComponent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getDeviceOwnerUserId() {
        if (!this.mHasFeature) {
            return -10000;
        }
        this.enforceManageUsers();
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            return this.mOwners.hasDeviceOwner() ? this.mOwners.getDeviceOwnerUserId() : -10000;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getDeviceOwnerName() {
        if (!this.mHasFeature) {
            return null;
        }
        this.enforceManageUsers();
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            if (!this.mOwners.hasDeviceOwner()) {
                return null;
            }
            String deviceOwnerPackage = this.mOwners.getDeviceOwnerPackageName();
            return this.getApplicationLabel(deviceOwnerPackage, 0);
        }
    }

    ActiveAdmin getDeviceOwnerAdminLocked() {
        ComponentName component = this.mOwners.getDeviceOwnerComponent();
        if (component == null) {
            return null;
        }
        DevicePolicyData policy = this.getUserData(this.mOwners.getDeviceOwnerUserId());
        int n = policy.mAdminList.size();
        for (int i = 0; i < n; ++i) {
            ActiveAdmin admin = policy.mAdminList.get(i);
            if (!component.equals(admin.info.getComponent())) continue;
            return admin;
        }
        Slog.wtf(LOG_TAG, "Active admin for device owner not found. component=" + component);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearDeviceOwner(String packageName) {
        Preconditions.checkNotNull(packageName, "packageName is null");
        int callingUid = this.mInjector.binderGetCallingUid();
        try {
            int uid = this.mContext.getPackageManager().getPackageUidAsUser(packageName, UserHandle.getUserId(callingUid));
            if (uid != callingUid) {
                throw new SecurityException("Invalid packageName");
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            throw new SecurityException(e);
        }
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            ComponentName deviceOwnerComponent = this.mOwners.getDeviceOwnerComponent();
            int deviceOwnerUserId = this.mOwners.getDeviceOwnerUserId();
            if (!this.mOwners.hasDeviceOwner() || !deviceOwnerComponent.getPackageName().equals(packageName) || deviceOwnerUserId != UserHandle.getUserId(callingUid)) {
                throw new SecurityException("clearDeviceOwner can only be called by the device owner");
            }
            this.enforceUserUnlocked(deviceOwnerUserId);
            ActiveAdmin admin = this.getDeviceOwnerAdminLocked();
            long ident = this.mInjector.binderClearCallingIdentity();
            try {
                this.clearDeviceOwnerLocked(admin, deviceOwnerUserId);
                this.removeActiveAdminLocked(deviceOwnerComponent, deviceOwnerUserId);
            }
            finally {
                this.mInjector.binderRestoreCallingIdentity(ident);
            }
        }
    }

    private void clearDeviceOwnerLocked(ActiveAdmin admin, int userId) {
        if (admin != null) {
            admin.disableCamera = false;
            admin.userRestrictions = null;
            admin.forceEphemeralUsers = false;
            this.mUserManagerInternal.setForceEphemeralUsers(admin.forceEphemeralUsers);
        }
        this.clearUserPoliciesLocked(userId);
        this.mOwners.clearDeviceOwner();
        this.mOwners.writeDeviceOwner();
        this.updateDeviceOwnerLocked();
        this.disableSecurityLoggingIfNotCompliant();
        try {
            this.mInjector.getIBackupManager().setBackupServiceActive(0, true);
        }
        catch (RemoteException e) {
            throw new IllegalStateException("Failed reactivating backup service.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setProfileOwner(ComponentName who, String ownerName, int userHandle) {
        if (!this.mHasFeature) {
            return false;
        }
        if (who == null || !this.isPackageInstalledForUser(who.getPackageName(), userHandle)) {
            throw new IllegalArgumentException("Component " + who + " not installed for userId:" + userHandle);
        }
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            this.enforceCanSetProfileOwnerLocked(userHandle);
            if (this.getActiveAdminUncheckedLocked(who, userHandle) == null) {
                throw new IllegalArgumentException("Not active admin: " + who);
            }
            this.mOwners.setProfileOwner(who, ownerName, userHandle);
            this.mOwners.writeProfileOwner(userHandle);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearProfileOwner(ComponentName who) {
        if (!this.mHasFeature) {
            return;
        }
        UserHandle callingUser = this.mInjector.binderGetCallingUserHandle();
        int userId = callingUser.getIdentifier();
        this.enforceNotManagedProfile(userId, "clear profile owner");
        this.enforceUserUnlocked(userId);
        ActiveAdmin admin = this.getActiveAdminForCallerLocked(who, -1);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            long ident = this.mInjector.binderClearCallingIdentity();
            try {
                this.clearProfileOwnerLocked(admin, userId);
                this.removeActiveAdminLocked(who, userId);
            }
            finally {
                this.mInjector.binderRestoreCallingIdentity(ident);
            }
        }
    }

    public void clearProfileOwnerLocked(ActiveAdmin admin, int userId) {
        if (admin != null) {
            admin.disableCamera = false;
            admin.userRestrictions = null;
        }
        this.clearUserPoliciesLocked(userId);
        this.mOwners.removeProfileOwner(userId);
        this.mOwners.writeProfileOwner(userId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDeviceOwnerLockScreenInfo(ComponentName who, CharSequence info) {
        Preconditions.checkNotNull(who, "ComponentName is null");
        if (!this.mHasFeature) {
            return;
        }
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            this.getActiveAdminForCallerLocked(who, -2);
            long token = this.mInjector.binderClearCallingIdentity();
            try {
                this.mLockPatternUtils.setDeviceOwnerInfo(info != null ? info.toString() : null);
            }
            finally {
                this.mInjector.binderRestoreCallingIdentity(token);
            }
        }
    }

    @Override
    public CharSequence getDeviceOwnerLockScreenInfo() {
        return this.mLockPatternUtils.getDeviceOwnerInfo();
    }

    private void clearUserPoliciesLocked(int userId) {
        DevicePolicyData policy = this.getUserData(userId);
        policy.mPermissionPolicy = 0;
        policy.mDelegatedCertInstallerPackage = null;
        policy.mApplicationRestrictionsManagingPackage = null;
        policy.mStatusBarDisabled = false;
        policy.mUserProvisioningState = 0;
        this.saveSettingsLocked(userId);
        try {
            this.mIPackageManager.updatePermissionFlagsForAllApps(4, 0, userId);
            this.pushUserRestrictions(userId);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @Override
    public boolean hasUserSetupCompleted() {
        return this.hasUserSetupCompleted(UserHandle.getCallingUserId());
    }

    private boolean hasUserSetupCompleted(int userHandle) {
        if (!this.mHasFeature) {
            return true;
        }
        return this.getUserData((int)userHandle).mUserSetupComplete;
    }

    @Override
    public int getUserProvisioningState() {
        if (!this.mHasFeature) {
            return 0;
        }
        int userHandle = this.mInjector.userHandleGetCallingUserId();
        return this.getUserProvisioningState(userHandle);
    }

    private int getUserProvisioningState(int userHandle) {
        return this.getUserData((int)userHandle).mUserProvisioningState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUserProvisioningState(int newState, int userHandle) {
        if (!this.mHasFeature) {
            return;
        }
        if (userHandle != this.mOwners.getDeviceOwnerUserId() && !this.mOwners.hasProfileOwner(userHandle) && this.getManagedUserId(userHandle) == -1) {
            throw new IllegalStateException("Not allowed to change provisioning state unless a device or profile owner is set.");
        }
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            boolean transitionCheckNeeded = true;
            int callingUid = this.mInjector.binderGetCallingUid();
            if (callingUid == 2000 || callingUid == 0) {
                if (this.getUserProvisioningState(userHandle) != 0 || newState != 3) {
                    throw new IllegalStateException("Not allowed to change provisioning state unless current provisioning state is unmanaged, and new state is finalized.");
                }
                transitionCheckNeeded = false;
            } else {
                this.enforceCanManageProfileAndDeviceOwners();
            }
            DevicePolicyData policyData = this.getUserData(userHandle);
            if (transitionCheckNeeded) {
                this.checkUserProvisioningStateTransition(policyData.mUserProvisioningState, newState);
            }
            policyData.mUserProvisioningState = newState;
            this.saveSettingsLocked(userHandle);
        }
    }

    private void checkUserProvisioningStateTransition(int currentState, int newState) {
        switch (currentState) {
            case 0: {
                if (newState == 0) break;
                return;
            }
            case 1: 
            case 2: {
                if (newState != 3) break;
                return;
            }
            case 4: {
                if (newState != 0) break;
                return;
            }
        }
        throw new IllegalStateException("Cannot move to user provisioning state [" + newState + "] from state [" + currentState + "]");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setProfileEnabled(ComponentName who) {
        if (!this.mHasFeature) {
            return;
        }
        Preconditions.checkNotNull(who, "ComponentName is null");
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            this.getActiveAdminForCallerLocked(who, -1);
            int userId = UserHandle.getCallingUserId();
            this.enforceManagedProfile(userId, "enable the profile");
            long id2 = this.mInjector.binderClearCallingIdentity();
            try {
                this.mUserManager.setUserEnabled(userId);
                UserInfo parent = this.mUserManager.getProfileParent(userId);
                Intent intent = new Intent("android.intent.action.MANAGED_PROFILE_ADDED");
                intent.putExtra("android.intent.extra.USER", new UserHandle(userId));
                intent.addFlags(0x50000000);
                this.mContext.sendBroadcastAsUser(intent, new UserHandle(parent.id));
            }
            finally {
                this.mInjector.binderRestoreCallingIdentity(id2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setProfileName(ComponentName who, String profileName) {
        Preconditions.checkNotNull(who, "ComponentName is null");
        int userId = UserHandle.getCallingUserId();
        this.getActiveAdminForCallerLocked(who, -1);
        long id2 = this.mInjector.binderClearCallingIdentity();
        try {
            this.mUserManager.setUserName(userId, profileName);
        }
        finally {
            this.mInjector.binderRestoreCallingIdentity(id2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ComponentName getProfileOwner(int userHandle) {
        if (!this.mHasFeature) {
            return null;
        }
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            return this.mOwners.getProfileOwnerComponent(userHandle);
        }
    }

    ActiveAdmin getProfileOwnerAdminLocked(int userHandle) {
        ComponentName profileOwner = this.mOwners.getProfileOwnerComponent(userHandle);
        if (profileOwner == null) {
            return null;
        }
        DevicePolicyData policy = this.getUserData(userHandle);
        int n = policy.mAdminList.size();
        for (int i = 0; i < n; ++i) {
            ActiveAdmin admin = policy.mAdminList.get(i);
            if (!profileOwner.equals(admin.info.getComponent())) continue;
            return admin;
        }
        return null;
    }

    @Override
    public String getProfileOwnerName(int userHandle) {
        if (!this.mHasFeature) {
            return null;
        }
        this.enforceManageUsers();
        ComponentName profileOwner = this.getProfileOwner(userHandle);
        if (profileOwner == null) {
            return null;
        }
        return this.getApplicationLabel(profileOwner.getPackageName(), userHandle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getApplicationLabel(String packageName, int userHandle) {
        long token = this.mInjector.binderClearCallingIdentity();
        try {
            Context userContext;
            try {
                UserHandle handle = new UserHandle(userHandle);
                userContext = this.mContext.createPackageContextAsUser(packageName, 0, handle);
            }
            catch (PackageManager.NameNotFoundException nnfe) {
                Log.w(LOG_TAG, packageName + " is not installed for user " + userHandle, nnfe);
                String string2 = null;
                this.mInjector.binderRestoreCallingIdentity(token);
                return string2;
            }
            ApplicationInfo appInfo = userContext.getApplicationInfo();
            CharSequence result = null;
            if (appInfo != null) {
                PackageManager pm = userContext.getPackageManager();
                result = pm.getApplicationLabel(appInfo);
            }
            String string3 = result != null ? result.toString() : null;
            return string3;
        }
        finally {
            this.mInjector.binderRestoreCallingIdentity(token);
        }
    }

    private void enforceCanSetProfileOwnerLocked(int userHandle) {
        UserInfo info = this.getUserInfo(userHandle);
        if (info == null) {
            throw new IllegalArgumentException("Attempted to set profile owner for invalid userId: " + userHandle);
        }
        if (info.isGuest()) {
            throw new IllegalStateException("Cannot set a profile owner on a guest");
        }
        if (this.mOwners.hasProfileOwner(userHandle)) {
            throw new IllegalStateException("Trying to set the profile owner, but profile owner is already set.");
        }
        if (this.mOwners.hasDeviceOwner() && this.mOwners.getDeviceOwnerUserId() == userHandle) {
            throw new IllegalStateException("Trying to set the profile owner, but the user already has a device owner.");
        }
        int callingUid = this.mInjector.binderGetCallingUid();
        if (callingUid == 2000 || callingUid == 0) {
            if (this.hasUserSetupCompleted(userHandle) && AccountManager.get(this.mContext).getAccountsAsUser(userHandle).length > 0) {
                throw new IllegalStateException("Not allowed to set the profile owner because there are already some accounts on the profile");
            }
            return;
        }
        this.enforceCanManageProfileAndDeviceOwners();
        if (this.hasUserSetupCompleted(userHandle) && !this.isCallerWithSystemUid()) {
            throw new IllegalStateException("Cannot set the profile owner on a user which is already set-up");
        }
    }

    private void enforceCanSetDeviceOwnerLocked(int userId) {
        boolean isAdb;
        int callingUid = this.mInjector.binderGetCallingUid();
        boolean bl = isAdb = callingUid == 2000 || callingUid == 0;
        if (!isAdb) {
            this.enforceCanManageProfileAndDeviceOwners();
        }
        int code = this.checkSetDeviceOwnerPreCondition(userId, isAdb);
        switch (code) {
            case 0: {
                return;
            }
            case 1: {
                throw new IllegalStateException("Trying to set the device owner, but device owner is already set.");
            }
            case 2: {
                throw new IllegalStateException("Trying to set the device owner, but the user already has a profile owner.");
            }
            case 3: {
                throw new IllegalStateException("User not running: " + userId);
            }
            case 7: {
                throw new IllegalStateException("User is not system user");
            }
            case 4: {
                throw new IllegalStateException("Cannot set the device owner if the device is already set-up");
            }
            case 5: {
                throw new IllegalStateException("Not allowed to set the device owner because there are already several users on the device");
            }
            case 6: {
                throw new IllegalStateException("Not allowed to set the device owner because there are already some accounts on the device");
            }
        }
        throw new IllegalStateException("Unknown @DeviceOwnerPreConditionCode " + code);
    }

    private void enforceUserUnlocked(int userId) {
        Preconditions.checkState(this.mUserManager.isUserUnlocked(userId), "User must be running and unlocked");
    }

    private void enforceManageUsers() {
        int callingUid = this.mInjector.binderGetCallingUid();
        if (!this.isCallerWithSystemUid() && callingUid != 0) {
            this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_USERS", null);
        }
    }

    private void enforceFullCrossUsersPermission(int userHandle) {
        this.enforceSystemUserOrPermission(userHandle, "android.permission.INTERACT_ACROSS_USERS_FULL");
    }

    private void enforceCrossUsersPermission(int userHandle) {
        this.enforceSystemUserOrPermission(userHandle, "android.permission.INTERACT_ACROSS_USERS");
    }

    private void enforceSystemUserOrPermission(int userHandle, String permission2) {
        if (userHandle < 0) {
            throw new IllegalArgumentException("Invalid userId " + userHandle);
        }
        int callingUid = this.mInjector.binderGetCallingUid();
        if (userHandle == UserHandle.getUserId(callingUid)) {
            return;
        }
        if (!this.isCallerWithSystemUid() && callingUid != 0) {
            this.mContext.enforceCallingOrSelfPermission(permission2, "Must be system or have " + permission2 + " permission");
        }
    }

    private void enforceManagedProfile(int userHandle, String message) {
        if (!this.isManagedProfile(userHandle)) {
            throw new SecurityException("You can not " + message + " outside a managed profile.");
        }
    }

    private void enforceNotManagedProfile(int userHandle, String message) {
        if (this.isManagedProfile(userHandle)) {
            throw new SecurityException("You can not " + message + " for a managed profile.");
        }
    }

    private void ensureCallerPackage(String packageName) {
        if (packageName == null) {
            Preconditions.checkState(this.isCallerWithSystemUid(), "Only caller can omit package name");
        } else {
            int callingUid = this.mInjector.binderGetCallingUid();
            int userId = this.mInjector.userHandleGetCallingUserId();
            try {
                ApplicationInfo ai = this.mIPackageManager.getApplicationInfo(packageName, 0, userId);
                Preconditions.checkState(ai.uid == callingUid, "Unmatching package name");
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    private boolean isCallerWithSystemUid() {
        return UserHandle.isSameApp(this.mInjector.binderGetCallingUid(), 1000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getProfileParentId(int userHandle) {
        long ident = this.mInjector.binderClearCallingIdentity();
        try {
            UserInfo parentUser = this.mUserManager.getProfileParent(userHandle);
            int n = parentUser != null ? parentUser.id : userHandle;
            return n;
        }
        finally {
            this.mInjector.binderRestoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getCredentialOwner(int userHandle, boolean parent) {
        long ident = this.mInjector.binderClearCallingIdentity();
        try {
            UserInfo parentProfile;
            if (parent && (parentProfile = this.mUserManager.getProfileParent(userHandle)) != null) {
                userHandle = parentProfile.id;
            }
            int n = this.mUserManager.getCredentialOwnerProfile(userHandle);
            return n;
        }
        finally {
            this.mInjector.binderRestoreCallingIdentity(ident);
        }
    }

    private boolean isManagedProfile(int userHandle) {
        return this.getUserInfo(userHandle).isManagedProfile();
    }

    private void enableIfNecessary(String packageName, int userId) {
        try {
            ApplicationInfo ai = this.mIPackageManager.getApplicationInfo(packageName, 32768, userId);
            if (ai.enabledSetting == 4) {
                this.mIPackageManager.setApplicationEnabledSetting(packageName, 0, 1, userId, "DevicePolicyManager");
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        if (this.mContext.checkCallingOrSelfPermission("android.permission.DUMP") != 0) {
            pw.println("Permission Denial: can't dump DevicePolicyManagerService from from pid=" + this.mInjector.binderGetCallingPid() + ", uid=" + this.mInjector.binderGetCallingUid());
            return;
        }
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            pw.println("Current Device Policy Manager state:");
            this.mOwners.dump("  ", pw);
            int userCount = this.mUserData.size();
            for (int u = 0; u < userCount; ++u) {
                DevicePolicyData policy = this.getUserData(this.mUserData.keyAt(u));
                pw.println();
                pw.println("  Enabled Device Admins (User " + policy.mUserHandle + ", provisioningState: " + policy.mUserProvisioningState + "):");
                int N = policy.mAdminList.size();
                for (int i = 0; i < N; ++i) {
                    ActiveAdmin ap = policy.mAdminList.get(i);
                    if (ap == null) continue;
                    pw.print("    ");
                    pw.print(ap.info.getComponent().flattenToShortString());
                    pw.println(":");
                    ap.dump("      ", pw);
                }
                if (!policy.mRemovingAdmins.isEmpty()) {
                    pw.println("    Removing Device Admins (User " + policy.mUserHandle + "): " + policy.mRemovingAdmins);
                }
                pw.println(" ");
                pw.print("    mPasswordOwner=");
                pw.println(policy.mPasswordOwner);
            }
            pw.println();
            pw.println("Encryption Status: " + this.getEncryptionStatusName(this.getEncryptionStatus()));
        }
    }

    private String getEncryptionStatusName(int encryptionStatus) {
        switch (encryptionStatus) {
            case 1: {
                return "inactive";
            }
            case 4: {
                return "block default key";
            }
            case 3: {
                return "block";
            }
            case 5: {
                return "per-user";
            }
            case 0: {
                return "unsupported";
            }
            case 2: {
                return "activating";
            }
        }
        return "unknown";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPersistentPreferredActivity(ComponentName who, IntentFilter filter, ComponentName activity) {
        Preconditions.checkNotNull(who, "ComponentName is null");
        int userHandle = UserHandle.getCallingUserId();
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            this.getActiveAdminForCallerLocked(who, -1);
            long id2 = this.mInjector.binderClearCallingIdentity();
            try {
                this.mIPackageManager.addPersistentPreferredActivity(filter, activity, userHandle);
            }
            catch (RemoteException remoteException) {
            }
            finally {
                this.mInjector.binderRestoreCallingIdentity(id2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearPackagePersistentPreferredActivities(ComponentName who, String packageName) {
        Preconditions.checkNotNull(who, "ComponentName is null");
        int userHandle = UserHandle.getCallingUserId();
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            this.getActiveAdminForCallerLocked(who, -1);
            long id2 = this.mInjector.binderClearCallingIdentity();
            try {
                this.mIPackageManager.clearPackagePersistentPreferredActivities(packageName, userHandle);
            }
            catch (RemoteException remoteException) {
            }
            finally {
                this.mInjector.binderRestoreCallingIdentity(id2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setApplicationRestrictionsManagingPackage(ComponentName admin, String packageName) {
        Preconditions.checkNotNull(admin, "ComponentName is null");
        int userHandle = this.mInjector.userHandleGetCallingUserId();
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            this.getActiveAdminForCallerLocked(admin, -1);
            if (packageName != null && !this.isPackageInstalledForUser(packageName, userHandle)) {
                return false;
            }
            DevicePolicyData policy = this.getUserData(userHandle);
            policy.mApplicationRestrictionsManagingPackage = packageName;
            this.saveSettingsLocked(userHandle);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getApplicationRestrictionsManagingPackage(ComponentName admin) {
        Preconditions.checkNotNull(admin, "ComponentName is null");
        int userHandle = this.mInjector.userHandleGetCallingUserId();
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            this.getActiveAdminForCallerLocked(admin, -1);
            DevicePolicyData policy = this.getUserData(userHandle);
            return policy.mApplicationRestrictionsManagingPackage;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCallerApplicationRestrictionsManagingPackage() {
        int callingUid = this.mInjector.binderGetCallingUid();
        int userHandle = UserHandle.getUserId(callingUid);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            DevicePolicyData policy = this.getUserData(userHandle);
            if (policy.mApplicationRestrictionsManagingPackage == null) {
                return false;
            }
            try {
                int uid = this.mContext.getPackageManager().getPackageUidAsUser(policy.mApplicationRestrictionsManagingPackage, userHandle);
                return uid == callingUid;
            }
            catch (PackageManager.NameNotFoundException e) {
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enforceCanManageApplicationRestrictions(ComponentName who) {
        if (who != null) {
            DevicePolicyManagerService devicePolicyManagerService = this;
            synchronized (devicePolicyManagerService) {
                this.getActiveAdminForCallerLocked(who, -1);
            }
        } else if (!this.isCallerApplicationRestrictionsManagingPackage()) {
            throw new SecurityException("No admin component given, and caller cannot manage application restrictions for other apps.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setApplicationRestrictions(ComponentName who, String packageName, Bundle settings) {
        this.enforceCanManageApplicationRestrictions(who);
        UserHandle userHandle = this.mInjector.binderGetCallingUserHandle();
        long id2 = this.mInjector.binderClearCallingIdentity();
        try {
            this.mUserManager.setApplicationRestrictions(packageName, settings, userHandle);
        }
        finally {
            this.mInjector.binderRestoreCallingIdentity(id2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTrustAgentConfiguration(ComponentName admin, ComponentName agent, PersistableBundle args, boolean parent) {
        if (!this.mHasFeature) {
            return;
        }
        Preconditions.checkNotNull(admin, "admin is null");
        Preconditions.checkNotNull(agent, "agent is null");
        int userHandle = UserHandle.getCallingUserId();
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            ActiveAdmin ap = this.getActiveAdminForCallerLocked(admin, 9, parent);
            ap.trustAgentInfos.put(agent.flattenToString(), new ActiveAdmin.TrustAgentInfo(args));
            this.saveSettingsLocked(userHandle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<PersistableBundle> getTrustAgentConfiguration(ComponentName admin, ComponentName agent, int userHandle, boolean parent) {
        if (!this.mHasFeature) {
            return null;
        }
        Preconditions.checkNotNull(agent, "agent null");
        this.enforceFullCrossUsersPermission(userHandle);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            String componentName = agent.flattenToString();
            if (admin != null) {
                ActiveAdmin ap = this.getActiveAdminUncheckedLocked(admin, userHandle, parent);
                if (ap == null) {
                    return null;
                }
                ActiveAdmin.TrustAgentInfo trustAgentInfo = ap.trustAgentInfos.get(componentName);
                if (trustAgentInfo == null || trustAgentInfo.options == null) {
                    return null;
                }
                ArrayList<PersistableBundle> result = new ArrayList<PersistableBundle>();
                result.add(trustAgentInfo.options);
                return result;
            }
            ArrayList<PersistableBundle> result = null;
            List<ActiveAdmin> admins = this.getActiveAdminsForLockscreenPoliciesLocked(userHandle, parent);
            boolean allAdminsHaveOptions = true;
            int N = admins.size();
            for (int i = 0; i < N; ++i) {
                ActiveAdmin active = admins.get(i);
                boolean disablesTrust = (active.disabledKeyguardFeatures & 0x10) != 0;
                ActiveAdmin.TrustAgentInfo info = active.trustAgentInfos.get(componentName);
                if (info != null && info.options != null && !info.options.isEmpty()) {
                    if (disablesTrust) {
                        if (result == null) {
                            result = new ArrayList<PersistableBundle>();
                        }
                        result.add(info.options);
                        continue;
                    }
                    Log.w(LOG_TAG, "Ignoring admin " + active.info + " because it has trust options but doesn't declare KEYGUARD_DISABLE_TRUST_AGENTS");
                    continue;
                }
                if (!disablesTrust) continue;
                allAdminsHaveOptions = false;
                break;
            }
            return allAdminsHaveOptions ? result : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRestrictionsProvider(ComponentName who, ComponentName permissionProvider) {
        Preconditions.checkNotNull(who, "ComponentName is null");
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            this.getActiveAdminForCallerLocked(who, -1);
            int userHandle = UserHandle.getCallingUserId();
            DevicePolicyData userData = this.getUserData(userHandle);
            userData.mRestrictionsProvider = permissionProvider;
            this.saveSettingsLocked(userHandle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ComponentName getRestrictionsProvider(int userHandle) {
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            if (!this.isCallerWithSystemUid()) {
                throw new SecurityException("Only the system can query the permission provider");
            }
            DevicePolicyData userData = this.getUserData(userHandle);
            ComponentName componentName = userData != null ? userData.mRestrictionsProvider : null;
            return componentName;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addCrossProfileIntentFilter(ComponentName who, IntentFilter filter, int flags) {
        Preconditions.checkNotNull(who, "ComponentName is null");
        int callingUserId = UserHandle.getCallingUserId();
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            this.getActiveAdminForCallerLocked(who, -1);
            long id2 = this.mInjector.binderClearCallingIdentity();
            try {
                UserInfo parent = this.mUserManager.getProfileParent(callingUserId);
                if (parent == null) {
                    Slog.e(LOG_TAG, "Cannot call addCrossProfileIntentFilter if there is no parent");
                    return;
                }
                if ((flags & 1) != 0) {
                    this.mIPackageManager.addCrossProfileIntentFilter(filter, who.getPackageName(), callingUserId, parent.id, 0);
                }
                if ((flags & 2) != 0) {
                    this.mIPackageManager.addCrossProfileIntentFilter(filter, who.getPackageName(), parent.id, callingUserId, 0);
                }
            }
            catch (RemoteException remoteException) {
            }
            finally {
                this.mInjector.binderRestoreCallingIdentity(id2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearCrossProfileIntentFilters(ComponentName who) {
        Preconditions.checkNotNull(who, "ComponentName is null");
        int callingUserId = UserHandle.getCallingUserId();
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            this.getActiveAdminForCallerLocked(who, -1);
            long id2 = this.mInjector.binderClearCallingIdentity();
            try {
                UserInfo parent = this.mUserManager.getProfileParent(callingUserId);
                if (parent == null) {
                    Slog.e(LOG_TAG, "Cannot call clearCrossProfileIntentFilter if there is no parent");
                    return;
                }
                this.mIPackageManager.clearCrossProfileIntentFilters(callingUserId, who.getPackageName());
                this.mIPackageManager.clearCrossProfileIntentFilters(parent.id, who.getPackageName());
            }
            catch (RemoteException remoteException) {
            }
            finally {
                this.mInjector.binderRestoreCallingIdentity(id2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkPackagesInPermittedListOrSystem(List<String> enabledPackages, List<String> permittedList, int userIdToCheck) {
        long id2 = this.mInjector.binderClearCallingIdentity();
        try {
            UserInfo user = this.getUserInfo(userIdToCheck);
            if (user.isManagedProfile()) {
                userIdToCheck = user.profileGroupId;
            }
            for (String enabledPackage : enabledPackages) {
                boolean systemService = false;
                try {
                    ApplicationInfo applicationInfo = this.mIPackageManager.getApplicationInfo(enabledPackage, 8192, userIdToCheck);
                    systemService = (applicationInfo.flags & 1) != 0;
                }
                catch (RemoteException e) {
                    Log.i(LOG_TAG, "Can't talk to package managed", e);
                }
                if (systemService || permittedList.contains(enabledPackage)) continue;
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.mInjector.binderRestoreCallingIdentity(id2);
        }
        return true;
    }

    private AccessibilityManager getAccessibilityManagerForUser(int userId) {
        IBinder iBinder = ServiceManager.getService("accessibility");
        IAccessibilityManager service = iBinder == null ? null : IAccessibilityManager.Stub.asInterface(iBinder);
        return new AccessibilityManager(this.mContext, service, userId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setPermittedAccessibilityServices(ComponentName who, List packageList) {
        if (!this.mHasFeature) {
            return false;
        }
        Preconditions.checkNotNull(who, "ComponentName is null");
        if (packageList != null) {
            int userId = UserHandle.getCallingUserId();
            List<AccessibilityServiceInfo> enabledServices = null;
            long id2 = this.mInjector.binderClearCallingIdentity();
            try {
                UserInfo user = this.getUserInfo(userId);
                if (user.isManagedProfile()) {
                    userId = user.profileGroupId;
                }
                AccessibilityManager accessibilityManager = this.getAccessibilityManagerForUser(userId);
                enabledServices = accessibilityManager.getEnabledAccessibilityServiceList(-1);
            }
            finally {
                this.mInjector.binderRestoreCallingIdentity(id2);
            }
            if (enabledServices != null) {
                ArrayList<String> enabledPackages = new ArrayList<String>();
                for (AccessibilityServiceInfo service : enabledServices) {
                    enabledPackages.add(service.getResolveInfo().serviceInfo.packageName);
                }
                if (!this.checkPackagesInPermittedListOrSystem(enabledPackages, packageList, userId)) {
                    Slog.e(LOG_TAG, "Cannot set permitted accessibility services, because it contains already enabled accesibility services.");
                    return false;
                }
            }
        }
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            ActiveAdmin admin = this.getActiveAdminForCallerLocked(who, -1);
            admin.permittedAccessiblityServices = packageList;
            this.saveSettingsLocked(UserHandle.getCallingUserId());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getPermittedAccessibilityServices(ComponentName who) {
        if (!this.mHasFeature) {
            return null;
        }
        Preconditions.checkNotNull(who, "ComponentName is null");
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            ActiveAdmin admin = this.getActiveAdminForCallerLocked(who, -1);
            return admin.permittedAccessiblityServices;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getPermittedAccessibilityServicesForUser(int userId) {
        if (!this.mHasFeature) {
            return null;
        }
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            int[] profileIds;
            ArrayList<String> result = null;
            for (int profileId : profileIds = this.mUserManager.getProfileIdsWithDisabled(userId)) {
                DevicePolicyData policy = this.getUserDataUnchecked(profileId);
                int N = policy.mAdminList.size();
                for (int j = 0; j < N; ++j) {
                    ActiveAdmin admin = policy.mAdminList.get(j);
                    List<String> fromAdmin = admin.permittedAccessiblityServices;
                    if (fromAdmin == null) continue;
                    if (result == null) {
                        result = new ArrayList<String>(fromAdmin);
                        continue;
                    }
                    result.retainAll(fromAdmin);
                }
            }
            if (result != null) {
                long id2 = this.mInjector.binderClearCallingIdentity();
                try {
                    AccessibilityManager accessibilityManager;
                    List<AccessibilityServiceInfo> installedServices;
                    UserInfo user = this.getUserInfo(userId);
                    if (user.isManagedProfile()) {
                        userId = user.profileGroupId;
                    }
                    if ((installedServices = (accessibilityManager = this.getAccessibilityManagerForUser(userId)).getInstalledAccessibilityServiceList()) != null) {
                        for (AccessibilityServiceInfo service : installedServices) {
                            ServiceInfo serviceInfo = service.getResolveInfo().serviceInfo;
                            ApplicationInfo applicationInfo = serviceInfo.applicationInfo;
                            if ((applicationInfo.flags & 1) == 0) continue;
                            result.add(serviceInfo.packageName);
                        }
                    }
                }
                finally {
                    this.mInjector.binderRestoreCallingIdentity(id2);
                }
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isAccessibilityServicePermittedByAdmin(ComponentName who, String packageName, int userHandle) {
        if (!this.mHasFeature) {
            return true;
        }
        Preconditions.checkNotNull(who, "ComponentName is null");
        Preconditions.checkStringNotEmpty(packageName, "packageName is null");
        if (!this.isCallerWithSystemUid()) {
            throw new SecurityException("Only the system can query if an accessibility service is disabled by admin");
        }
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            ActiveAdmin admin = this.getActiveAdminUncheckedLocked(who, userHandle);
            if (admin == null) {
                return false;
            }
            if (admin.permittedAccessiblityServices == null) {
                return true;
            }
            return this.checkPackagesInPermittedListOrSystem(Arrays.asList(packageName), admin.permittedAccessiblityServices, userHandle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkCallerIsCurrentUserOrProfile() {
        int callingUserId = UserHandle.getCallingUserId();
        long token = this.mInjector.binderClearCallingIdentity();
        try {
            UserInfo currentUser;
            UserInfo callingUser = this.getUserInfo(callingUserId);
            try {
                currentUser = this.mInjector.getIActivityManager().getCurrentUser();
            }
            catch (RemoteException e) {
                Slog.e(LOG_TAG, "Failed to talk to activity managed.", e);
                boolean bl = false;
                this.mInjector.binderRestoreCallingIdentity(token);
                return bl;
            }
            if (callingUser.isManagedProfile() && callingUser.profileGroupId != currentUser.id) {
                Slog.e(LOG_TAG, "Cannot set permitted input methods for managed profile of a user that isn't the foreground user.");
                boolean bl = false;
                return bl;
            }
            if (!callingUser.isManagedProfile() && callingUserId != currentUser.id) {
                Slog.e(LOG_TAG, "Cannot set permitted input methods of a user that isn't the foreground user.");
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.mInjector.binderRestoreCallingIdentity(token);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setPermittedInputMethods(ComponentName who, List packageList) {
        InputMethodManager inputMethodManager;
        List<InputMethodInfo> enabledImes;
        if (!this.mHasFeature) {
            return false;
        }
        Preconditions.checkNotNull(who, "ComponentName is null");
        if (!this.checkCallerIsCurrentUserOrProfile()) {
            return false;
        }
        if (packageList != null && (enabledImes = (inputMethodManager = this.mContext.getSystemService(InputMethodManager.class)).getEnabledInputMethodList()) != null) {
            ArrayList<String> enabledPackages = new ArrayList<String>();
            for (InputMethodInfo ime : enabledImes) {
                enabledPackages.add(ime.getPackageName());
            }
            if (!this.checkPackagesInPermittedListOrSystem(enabledPackages, packageList, this.mInjector.binderGetCallingUserHandle().getIdentifier())) {
                Slog.e(LOG_TAG, "Cannot set permitted input methods, because it contains already enabled input method.");
                return false;
            }
        }
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            ActiveAdmin admin = this.getActiveAdminForCallerLocked(who, -1);
            admin.permittedInputMethods = packageList;
            this.saveSettingsLocked(UserHandle.getCallingUserId());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getPermittedInputMethods(ComponentName who) {
        if (!this.mHasFeature) {
            return null;
        }
        Preconditions.checkNotNull(who, "ComponentName is null");
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            ActiveAdmin admin = this.getActiveAdminForCallerLocked(who, -1);
            return admin.permittedInputMethods;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getPermittedInputMethodsForCurrentUser() {
        UserInfo currentUser;
        try {
            currentUser = this.mInjector.getIActivityManager().getCurrentUser();
        }
        catch (RemoteException e) {
            Slog.e(LOG_TAG, "Failed to make remote calls to get current user", e);
            return null;
        }
        int userId = currentUser.id;
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            int[] profileIds;
            ArrayList<String> result = null;
            for (int profileId : profileIds = this.mUserManager.getProfileIdsWithDisabled(userId)) {
                DevicePolicyData policy = this.getUserDataUnchecked(profileId);
                int N = policy.mAdminList.size();
                for (int j = 0; j < N; ++j) {
                    ActiveAdmin admin = policy.mAdminList.get(j);
                    List<String> fromAdmin = admin.permittedInputMethods;
                    if (fromAdmin == null) continue;
                    if (result == null) {
                        result = new ArrayList<String>(fromAdmin);
                        continue;
                    }
                    result.retainAll(fromAdmin);
                }
            }
            if (result != null) {
                InputMethodManager inputMethodManager = this.mContext.getSystemService(InputMethodManager.class);
                List<InputMethodInfo> imes = inputMethodManager.getInputMethodList();
                long id2 = this.mInjector.binderClearCallingIdentity();
                try {
                    if (imes != null) {
                        for (InputMethodInfo ime : imes) {
                            ServiceInfo serviceInfo = ime.getServiceInfo();
                            ApplicationInfo applicationInfo = serviceInfo.applicationInfo;
                            if ((applicationInfo.flags & 1) == 0) continue;
                            result.add(serviceInfo.packageName);
                        }
                    }
                }
                finally {
                    this.mInjector.binderRestoreCallingIdentity(id2);
                }
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isInputMethodPermittedByAdmin(ComponentName who, String packageName, int userHandle) {
        if (!this.mHasFeature) {
            return true;
        }
        Preconditions.checkNotNull(who, "ComponentName is null");
        Preconditions.checkStringNotEmpty(packageName, "packageName is null");
        if (!this.isCallerWithSystemUid()) {
            throw new SecurityException("Only the system can query if an input method is disabled by admin");
        }
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            ActiveAdmin admin = this.getActiveAdminUncheckedLocked(who, userHandle);
            if (admin == null) {
                return false;
            }
            if (admin.permittedInputMethods == null) {
                return true;
            }
            return this.checkPackagesInPermittedListOrSystem(Arrays.asList(packageName), admin.permittedInputMethods, userHandle);
        }
    }

    private void sendAdminEnabledBroadcastLocked(int userHandle) {
        DevicePolicyData policyData = this.getUserData(userHandle);
        if (policyData.mAdminBroadcastPending) {
            ActiveAdmin admin = this.getProfileOwnerAdminLocked(userHandle);
            if (admin != null) {
                PersistableBundle initBundle = policyData.mInitBundle;
                this.sendAdminCommandLocked(admin, "android.app.action.DEVICE_ADMIN_ENABLED", initBundle == null ? null : new Bundle(initBundle), null);
            }
            policyData.mInitBundle = null;
            policyData.mAdminBroadcastPending = false;
            this.saveSettingsLocked(userHandle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UserHandle createAndManageUser(ComponentName admin, String name, ComponentName profileOwner, PersistableBundle adminExtras, int flags) {
        Preconditions.checkNotNull(admin, "admin is null");
        Preconditions.checkNotNull(profileOwner, "profileOwner is null");
        if (!admin.getPackageName().equals(profileOwner.getPackageName())) {
            throw new IllegalArgumentException("profileOwner " + profileOwner + " and admin " + admin + " are not in the same package");
        }
        if (!this.mInjector.binderGetCallingUserHandle().isSystem()) {
            throw new SecurityException("createAndManageUser was called from non-system user");
        }
        if (!this.mInjector.userManagerIsSplitSystemUser() && (flags & 2) != 0) {
            throw new IllegalArgumentException("Ephemeral users are only supported on systems with a split system user.");
        }
        UserHandle user = null;
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            this.getActiveAdminForCallerLocked(admin, -2);
            long id2 = this.mInjector.binderClearCallingIdentity();
            try {
                UserInfo userInfo;
                int userInfoFlags = 0;
                if ((flags & 2) != 0) {
                    userInfoFlags |= 0x100;
                }
                if ((userInfo = this.mUserManagerInternal.createUserEvenWhenDisallowed(name, userInfoFlags)) != null) {
                    user = userInfo.getUserHandle();
                }
            }
            finally {
                this.mInjector.binderRestoreCallingIdentity(id2);
            }
        }
        if (user == null) {
            return null;
        }
        long id3 = this.mInjector.binderClearCallingIdentity();
        try {
            String adminPkg = admin.getPackageName();
            int userHandle = user.getIdentifier();
            try {
                if (!this.mIPackageManager.isPackageAvailable(adminPkg, userHandle)) {
                    this.mIPackageManager.installExistingPackageAsUser(adminPkg, userHandle);
                }
            }
            catch (RemoteException e) {
                Slog.e(LOG_TAG, "Failed to make remote calls for createAndManageUser, removing created user", e);
                this.mUserManager.removeUser(user.getIdentifier());
                UserHandle userHandle2 = null;
                this.mInjector.binderRestoreCallingIdentity(id3);
                return userHandle2;
            }
            this.setActiveAdmin(profileOwner, true, userHandle);
            DevicePolicyManagerService e = this;
            synchronized (e) {
                DevicePolicyData policyData = this.getUserData(userHandle);
                policyData.mInitBundle = adminExtras;
                policyData.mAdminBroadcastPending = true;
                this.saveSettingsLocked(userHandle);
            }
            String ownerName = this.getProfileOwnerName(Process.myUserHandle().getIdentifier());
            this.setProfileOwner(profileOwner, ownerName, userHandle);
            if ((flags & 1) != 0) {
                Settings.Secure.putIntForUser(this.mContext.getContentResolver(), "user_setup_complete", 1, userHandle);
            }
            UserHandle userHandle3 = user;
            return userHandle3;
        }
        finally {
            this.mInjector.binderRestoreCallingIdentity(id3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeUser(ComponentName who, UserHandle userHandle) {
        Preconditions.checkNotNull(who, "ComponentName is null");
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            boolean bl;
            this.getActiveAdminForCallerLocked(who, -2);
            long id2 = this.mInjector.binderClearCallingIdentity();
            try {
                bl = this.mUserManager.removeUser(userHandle.getIdentifier());
                this.mInjector.binderRestoreCallingIdentity(id2);
            }
            catch (Throwable throwable) {
                this.mInjector.binderRestoreCallingIdentity(id2);
                throw throwable;
            }
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean switchUser(ComponentName who, UserHandle userHandle) {
        Preconditions.checkNotNull(who, "ComponentName is null");
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            boolean bl;
            this.getActiveAdminForCallerLocked(who, -2);
            long id2 = this.mInjector.binderClearCallingIdentity();
            try {
                int userId = 0;
                if (userHandle != null) {
                    userId = userHandle.getIdentifier();
                }
                bl = this.mInjector.getIActivityManager().switchUser(userId);
                this.mInjector.binderRestoreCallingIdentity(id2);
            }
            catch (RemoteException e) {
                boolean bl2;
                try {
                    Log.e(LOG_TAG, "Couldn't switch user", e);
                    bl2 = false;
                    this.mInjector.binderRestoreCallingIdentity(id2);
                }
                catch (Throwable throwable) {
                    this.mInjector.binderRestoreCallingIdentity(id2);
                    throw throwable;
                }
                return bl2;
            }
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Bundle getApplicationRestrictions(ComponentName who, String packageName) {
        this.enforceCanManageApplicationRestrictions(who);
        UserHandle userHandle = this.mInjector.binderGetCallingUserHandle();
        long id2 = this.mInjector.binderClearCallingIdentity();
        try {
            Bundle bundle = this.mUserManager.getApplicationRestrictions(packageName, userHandle);
            Bundle bundle2 = bundle != null ? bundle : Bundle.EMPTY;
            return bundle2;
        }
        finally {
            this.mInjector.binderRestoreCallingIdentity(id2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String[] setPackagesSuspended(ComponentName who, String[] packageNames, boolean suspended) {
        Preconditions.checkNotNull(who, "ComponentName is null");
        int callingUserId = UserHandle.getCallingUserId();
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            this.getActiveAdminForCallerLocked(who, -1);
            long id2 = this.mInjector.binderClearCallingIdentity();
            try {
                String[] stringArray = this.mIPackageManager.setPackagesSuspendedAsUser(packageNames, suspended, callingUserId);
                return stringArray;
            }
            catch (RemoteException re) {
                Slog.e(LOG_TAG, "Failed talking to the package manager", re);
            }
            finally {
                this.mInjector.binderRestoreCallingIdentity(id2);
            }
            return packageNames;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isPackageSuspended(ComponentName who, String packageName) {
        Preconditions.checkNotNull(who, "ComponentName is null");
        int callingUserId = UserHandle.getCallingUserId();
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            this.getActiveAdminForCallerLocked(who, -1);
            long id2 = this.mInjector.binderClearCallingIdentity();
            try {
                boolean bl = this.mIPackageManager.isPackageSuspendedForUser(packageName, callingUserId);
                return bl;
            }
            catch (RemoteException re) {
                Slog.e(LOG_TAG, "Failed talking to the package manager", re);
            }
            finally {
                this.mInjector.binderRestoreCallingIdentity(id2);
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUserRestriction(ComponentName who, String key, boolean enabledFromThisOwner) {
        Preconditions.checkNotNull(who, "ComponentName is null");
        if (!UserRestrictionsUtils.isValidRestriction(key)) {
            return;
        }
        int userHandle = this.mInjector.userHandleGetCallingUserId();
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            ActiveAdmin activeAdmin = this.getActiveAdminForCallerLocked(who, -1);
            boolean isDeviceOwner = this.isDeviceOwner(who, userHandle);
            if (isDeviceOwner) {
                if (!UserRestrictionsUtils.canDeviceOwnerChange(key)) {
                    throw new SecurityException("Device owner cannot set user restriction " + key);
                }
            } else if (!UserRestrictionsUtils.canProfileOwnerChange(key, userHandle)) {
                throw new SecurityException("Profile owner cannot set user restriction " + key);
            }
            activeAdmin.ensureUserRestrictions().putBoolean(key, enabledFromThisOwner);
            this.saveSettingsLocked(userHandle);
            this.pushUserRestrictions(userHandle);
            this.sendChangedNotification(userHandle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pushUserRestrictions(int userId) {
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            Bundle global;
            Bundle local = new Bundle();
            if (this.mOwners.isDeviceOwnerUserId(userId)) {
                global = new Bundle();
                ActiveAdmin deviceOwner = this.getDeviceOwnerAdminLocked();
                if (deviceOwner == null) {
                    return;
                }
                UserRestrictionsUtils.sortToGlobalAndLocal(deviceOwner.userRestrictions, global, local);
                if (deviceOwner.disableCamera) {
                    global.putBoolean("no_camera", true);
                }
            } else {
                global = null;
                ActiveAdmin profileOwner = this.getProfileOwnerAdminLocked(userId);
                if (profileOwner != null) {
                    UserRestrictionsUtils.merge(local, profileOwner.userRestrictions);
                }
            }
            if (this.getCameraDisabled(null, userId, false)) {
                local.putBoolean("no_camera", true);
            }
            this.mUserManagerInternal.setDevicePolicyUserRestrictions(userId, local, global);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Bundle getUserRestrictions(ComponentName who) {
        if (!this.mHasFeature) {
            return null;
        }
        Preconditions.checkNotNull(who, "ComponentName is null");
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            ActiveAdmin activeAdmin = this.getActiveAdminForCallerLocked(who, -1);
            return activeAdmin.userRestrictions;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean setApplicationHidden(ComponentName who, String packageName, boolean hidden) {
        Preconditions.checkNotNull(who, "ComponentName is null");
        int callingUserId = UserHandle.getCallingUserId();
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            this.getActiveAdminForCallerLocked(who, -1);
            long id2 = this.mInjector.binderClearCallingIdentity();
            try {
                boolean bl = this.mIPackageManager.setApplicationHiddenSettingAsUser(packageName, hidden, callingUserId);
                return bl;
            }
            catch (RemoteException re) {
                Slog.e(LOG_TAG, "Failed to setApplicationHiddenSetting", re);
            }
            finally {
                this.mInjector.binderRestoreCallingIdentity(id2);
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isApplicationHidden(ComponentName who, String packageName) {
        Preconditions.checkNotNull(who, "ComponentName is null");
        int callingUserId = UserHandle.getCallingUserId();
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            this.getActiveAdminForCallerLocked(who, -1);
            long id2 = this.mInjector.binderClearCallingIdentity();
            try {
                boolean bl = this.mIPackageManager.getApplicationHiddenSettingAsUser(packageName, callingUserId);
                return bl;
            }
            catch (RemoteException re) {
                Slog.e(LOG_TAG, "Failed to getApplicationHiddenSettingAsUser", re);
            }
            finally {
                this.mInjector.binderRestoreCallingIdentity(id2);
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enableSystemApp(ComponentName who, String packageName) {
        Preconditions.checkNotNull(who, "ComponentName is null");
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            this.getActiveAdminForCallerLocked(who, -1);
            int userId = UserHandle.getCallingUserId();
            long id2 = this.mInjector.binderClearCallingIdentity();
            try {
                int parentUserId = this.getProfileParentId(userId);
                if (!this.isSystemApp(this.mIPackageManager, packageName, parentUserId)) {
                    throw new IllegalArgumentException("Only system apps can be enabled this way.");
                }
                this.mIPackageManager.installExistingPackageAsUser(packageName, userId);
            }
            catch (RemoteException re) {
                Slog.wtf(LOG_TAG, "Failed to install " + packageName, re);
            }
            finally {
                this.mInjector.binderRestoreCallingIdentity(id2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int enableSystemAppWithIntent(ComponentName who, Intent intent) {
        Preconditions.checkNotNull(who, "ComponentName is null");
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            int n;
            this.getActiveAdminForCallerLocked(who, -1);
            int userId = UserHandle.getCallingUserId();
            long id2 = this.mInjector.binderClearCallingIdentity();
            try {
                int parentUserId = this.getProfileParentId(userId);
                List activitiesToEnable = this.mIPackageManager.queryIntentActivities(intent, intent.resolveTypeIfNeeded(this.mContext.getContentResolver()), 786432, parentUserId).getList();
                int numberOfAppsInstalled = 0;
                if (activitiesToEnable != null) {
                    for (ResolveInfo info : activitiesToEnable) {
                        if (info.activityInfo == null) continue;
                        String packageName = info.activityInfo.packageName;
                        if (this.isSystemApp(this.mIPackageManager, packageName, parentUserId)) {
                            ++numberOfAppsInstalled;
                            this.mIPackageManager.installExistingPackageAsUser(packageName, userId);
                            continue;
                        }
                        Slog.d(LOG_TAG, "Not enabling " + packageName + " since is not a system app");
                    }
                }
                n = numberOfAppsInstalled;
                this.mInjector.binderRestoreCallingIdentity(id2);
            }
            catch (RemoteException e) {
                int n2;
                try {
                    Slog.wtf(LOG_TAG, "Failed to resolve intent for: " + intent);
                    n2 = 0;
                    this.mInjector.binderRestoreCallingIdentity(id2);
                }
                catch (Throwable throwable) {
                    this.mInjector.binderRestoreCallingIdentity(id2);
                    throw throwable;
                }
                return n2;
            }
            return n;
        }
    }

    private boolean isSystemApp(IPackageManager pm, String packageName, int userId) throws RemoteException {
        ApplicationInfo appInfo = pm.getApplicationInfo(packageName, 8192, userId);
        if (appInfo == null) {
            throw new IllegalArgumentException("The application " + packageName + " is not present on this device");
        }
        return (appInfo.flags & 1) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAccountManagementDisabled(ComponentName who, String accountType, boolean disabled) {
        if (!this.mHasFeature) {
            return;
        }
        Preconditions.checkNotNull(who, "ComponentName is null");
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            ActiveAdmin ap = this.getActiveAdminForCallerLocked(who, -1);
            if (disabled) {
                ap.accountTypesWithManagementDisabled.add(accountType);
            } else {
                ap.accountTypesWithManagementDisabled.remove(accountType);
            }
            this.saveSettingsLocked(UserHandle.getCallingUserId());
        }
    }

    @Override
    public String[] getAccountTypesWithManagementDisabled() {
        return this.getAccountTypesWithManagementDisabledAsUser(UserHandle.getCallingUserId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getAccountTypesWithManagementDisabledAsUser(int userId) {
        this.enforceFullCrossUsersPermission(userId);
        if (!this.mHasFeature) {
            return null;
        }
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            DevicePolicyData policy = this.getUserData(userId);
            int N = policy.mAdminList.size();
            ArraySet<String> resultSet = new ArraySet<String>();
            for (int i = 0; i < N; ++i) {
                ActiveAdmin admin = policy.mAdminList.get(i);
                resultSet.addAll(admin.accountTypesWithManagementDisabled);
            }
            return resultSet.toArray(new String[resultSet.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUninstallBlocked(ComponentName who, String packageName, boolean uninstallBlocked) {
        Preconditions.checkNotNull(who, "ComponentName is null");
        int userId = UserHandle.getCallingUserId();
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            this.getActiveAdminForCallerLocked(who, -1);
            long id2 = this.mInjector.binderClearCallingIdentity();
            try {
                this.mIPackageManager.setBlockUninstallForUser(packageName, uninstallBlocked, userId);
            }
            catch (RemoteException re) {
                Slog.e(LOG_TAG, "Failed to setBlockUninstallForUser", re);
            }
            finally {
                this.mInjector.binderRestoreCallingIdentity(id2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isUninstallBlocked(ComponentName who, String packageName) {
        int userId = UserHandle.getCallingUserId();
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            if (who != null) {
                this.getActiveAdminForCallerLocked(who, -1);
            }
            long id2 = this.mInjector.binderClearCallingIdentity();
            try {
                boolean bl = this.mIPackageManager.getBlockUninstallForUser(packageName, userId);
                return bl;
            }
            catch (RemoteException re) {
                Slog.e(LOG_TAG, "Failed to getBlockUninstallForUser", re);
            }
            finally {
                this.mInjector.binderRestoreCallingIdentity(id2);
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCrossProfileCallerIdDisabled(ComponentName who, boolean disabled) {
        if (!this.mHasFeature) {
            return;
        }
        Preconditions.checkNotNull(who, "ComponentName is null");
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            ActiveAdmin admin = this.getActiveAdminForCallerLocked(who, -1);
            if (admin.disableCallerId != disabled) {
                admin.disableCallerId = disabled;
                this.saveSettingsLocked(this.mInjector.userHandleGetCallingUserId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getCrossProfileCallerIdDisabled(ComponentName who) {
        if (!this.mHasFeature) {
            return false;
        }
        Preconditions.checkNotNull(who, "ComponentName is null");
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            ActiveAdmin admin = this.getActiveAdminForCallerLocked(who, -1);
            return admin.disableCallerId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getCrossProfileCallerIdDisabledForUser(int userId) {
        this.enforceCrossUsersPermission(userId);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            ActiveAdmin admin = this.getProfileOwnerAdminLocked(userId);
            return admin != null ? admin.disableCallerId : false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCrossProfileContactsSearchDisabled(ComponentName who, boolean disabled) {
        if (!this.mHasFeature) {
            return;
        }
        Preconditions.checkNotNull(who, "ComponentName is null");
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            ActiveAdmin admin = this.getActiveAdminForCallerLocked(who, -1);
            if (admin.disableContactsSearch != disabled) {
                admin.disableContactsSearch = disabled;
                this.saveSettingsLocked(this.mInjector.userHandleGetCallingUserId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getCrossProfileContactsSearchDisabled(ComponentName who) {
        if (!this.mHasFeature) {
            return false;
        }
        Preconditions.checkNotNull(who, "ComponentName is null");
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            ActiveAdmin admin = this.getActiveAdminForCallerLocked(who, -1);
            return admin.disableContactsSearch;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getCrossProfileContactsSearchDisabledForUser(int userId) {
        this.enforceCrossUsersPermission(userId);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            ActiveAdmin admin = this.getProfileOwnerAdminLocked(userId);
            return admin != null ? admin.disableContactsSearch : false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void startManagedQuickContact(String actualLookupKey, long actualContactId, boolean isContactIdIgnored, long actualDirectoryId, Intent originalIntent) {
        int managedUserId;
        long ident;
        Intent intent;
        block9: {
            intent = ContactsContract.QuickContact.rebuildManagedQuickContactsIntent(actualLookupKey, actualContactId, isContactIdIgnored, actualDirectoryId, originalIntent);
            int callingUserId = UserHandle.getCallingUserId();
            ident = this.mInjector.binderClearCallingIdentity();
            DevicePolicyManagerService devicePolicyManagerService = this;
            // MONITORENTER : devicePolicyManagerService
            managedUserId = this.getManagedUserId(callingUserId);
            if (managedUserId < 0) {
                // MONITOREXIT : devicePolicyManagerService
                this.mInjector.binderRestoreCallingIdentity(ident);
                return;
            }
            if (!this.isCrossProfileQuickContactDisabled(managedUserId)) break block9;
            this.mInjector.binderRestoreCallingIdentity(ident);
            return;
        }
        try {
            ContactsInternal.startQuickContactWithErrorToastForUser(this.mContext, intent, new UserHandle(managedUserId));
            // MONITOREXIT : devicePolicyManagerService
            return;
        }
        finally {
            this.mInjector.binderRestoreCallingIdentity(ident);
        }
    }

    private boolean isCrossProfileQuickContactDisabled(int userId) {
        return this.getCrossProfileCallerIdDisabledForUser(userId) && this.getCrossProfileContactsSearchDisabledForUser(userId);
    }

    public int getManagedUserId(int callingUserId) {
        for (UserInfo ui : this.mUserManager.getProfiles(callingUserId)) {
            if (ui.id == callingUserId || !ui.isManagedProfile()) continue;
            return ui.id;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBluetoothContactSharingDisabled(ComponentName who, boolean disabled) {
        if (!this.mHasFeature) {
            return;
        }
        Preconditions.checkNotNull(who, "ComponentName is null");
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            ActiveAdmin admin = this.getActiveAdminForCallerLocked(who, -1);
            if (admin.disableBluetoothContactSharing != disabled) {
                admin.disableBluetoothContactSharing = disabled;
                this.saveSettingsLocked(UserHandle.getCallingUserId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getBluetoothContactSharingDisabled(ComponentName who) {
        if (!this.mHasFeature) {
            return false;
        }
        Preconditions.checkNotNull(who, "ComponentName is null");
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            ActiveAdmin admin = this.getActiveAdminForCallerLocked(who, -1);
            return admin.disableBluetoothContactSharing;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getBluetoothContactSharingDisabledForUser(int userId) {
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            ActiveAdmin admin = this.getProfileOwnerAdminLocked(userId);
            return admin != null ? admin.disableBluetoothContactSharing : false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLockTaskPackages(ComponentName who, String[] packages) throws SecurityException {
        Preconditions.checkNotNull(who, "ComponentName is null");
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            ActiveAdmin deviceOwner = this.getActiveAdminWithPolicyForUidLocked(who, -2, this.mInjector.binderGetCallingUid());
            ActiveAdmin profileOwner = this.getActiveAdminWithPolicyForUidLocked(who, -1, this.mInjector.binderGetCallingUid());
            if (!(deviceOwner != null || profileOwner != null && this.isAffiliatedUser())) {
                throw new SecurityException("Admin " + who + " is neither the device owner or affiliated user's profile owner.");
            }
            int userHandle = this.mInjector.userHandleGetCallingUserId();
            this.setLockTaskPackagesLocked(userHandle, new ArrayList<String>(Arrays.asList(packages)));
        }
    }

    private void setLockTaskPackagesLocked(int userHandle, List<String> packages) {
        DevicePolicyData policy = this.getUserData(userHandle);
        policy.mLockTaskPackages = packages;
        this.saveSettingsLocked(userHandle);
        this.updateLockTaskPackagesLocked(packages, userHandle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getLockTaskPackages(ComponentName who) {
        Preconditions.checkNotNull(who, "ComponentName is null");
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            this.getActiveAdminForCallerLocked(who, -2);
            int userHandle = this.mInjector.binderGetCallingUserHandle().getIdentifier();
            List<String> packages = this.getLockTaskPackagesLocked(userHandle);
            return packages.toArray(new String[packages.size()]);
        }
    }

    private List<String> getLockTaskPackagesLocked(int userHandle) {
        DevicePolicyData policy = this.getUserData(userHandle);
        return policy.mLockTaskPackages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isLockTaskPermitted(String pkg) {
        int uid = this.mInjector.binderGetCallingUid();
        int userHandle = UserHandle.getUserId(uid);
        DevicePolicyData policy = this.getUserData(userHandle);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            for (int i = 0; i < policy.mLockTaskPackages.size(); ++i) {
                String lockTaskPackage = policy.mLockTaskPackages.get(i);
                if (!lockTaskPackage.equals(pkg)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyLockTaskModeChanged(boolean isEnabled, String pkg, int userHandle) {
        if (!this.isCallerWithSystemUid()) {
            throw new SecurityException("notifyLockTaskModeChanged can only be called by system");
        }
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            DevicePolicyData policy = this.getUserData(userHandle);
            Bundle adminExtras = new Bundle();
            adminExtras.putString("android.app.extra.LOCK_TASK_PACKAGE", pkg);
            for (ActiveAdmin admin : policy.mAdminList) {
                boolean ownsDevice = this.isDeviceOwner(admin.info.getComponent(), userHandle);
                boolean ownsProfile = this.isProfileOwner(admin.info.getComponent(), userHandle);
                if (!ownsDevice && !ownsProfile) continue;
                if (isEnabled) {
                    this.sendAdminCommandLocked(admin, "android.app.action.LOCK_TASK_ENTERING", adminExtras, null);
                    continue;
                }
                this.sendAdminCommandLocked(admin, "android.app.action.LOCK_TASK_EXITING");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setGlobalSetting(ComponentName who, String setting, String value) {
        Preconditions.checkNotNull(who, "ComponentName is null");
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            long timeMs;
            this.getActiveAdminForCallerLocked(who, -2);
            if (GLOBAL_SETTINGS_DEPRECATED.contains(setting)) {
                Log.i(LOG_TAG, "Global setting no longer supported: " + setting);
                return;
            }
            if (!GLOBAL_SETTINGS_WHITELIST.contains(setting)) {
                throw new SecurityException(String.format("Permission denial: device owners cannot update %1$s", setting));
            }
            if ("stay_on_while_plugged_in".equals(setting) && (timeMs = this.getMaximumTimeToLock(who, this.mInjector.userHandleGetCallingUserId(), false)) > 0L && timeMs < Integer.MAX_VALUE) {
                return;
            }
            long id2 = this.mInjector.binderClearCallingIdentity();
            try {
                this.mInjector.settingsGlobalPutString(setting, value);
            }
            finally {
                this.mInjector.binderRestoreCallingIdentity(id2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSecureSetting(ComponentName who, String setting, String value) {
        Preconditions.checkNotNull(who, "ComponentName is null");
        int callingUserId = this.mInjector.userHandleGetCallingUserId();
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            this.getActiveAdminForCallerLocked(who, -1);
            if (this.isDeviceOwner(who, callingUserId)) {
                if (!SECURE_SETTINGS_DEVICEOWNER_WHITELIST.contains(setting)) {
                    throw new SecurityException(String.format("Permission denial: Device owners cannot update %1$s", setting));
                }
            } else if (!SECURE_SETTINGS_WHITELIST.contains(setting)) {
                throw new SecurityException(String.format("Permission denial: Profile owners cannot update %1$s", setting));
            }
            long id2 = this.mInjector.binderClearCallingIdentity();
            try {
                this.mInjector.settingsSecurePutStringForUser(setting, value, callingUserId);
            }
            finally {
                this.mInjector.binderRestoreCallingIdentity(id2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMasterVolumeMuted(ComponentName who, boolean on) {
        Preconditions.checkNotNull(who, "ComponentName is null");
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            this.getActiveAdminForCallerLocked(who, -1);
            int userId = UserHandle.getCallingUserId();
            long identity = this.mInjector.binderClearCallingIdentity();
            try {
                IAudioService iAudioService = IAudioService.Stub.asInterface(ServiceManager.getService("audio"));
                iAudioService.setMasterMute(on, 0, this.mContext.getPackageName(), userId);
            }
            catch (RemoteException re) {
                Slog.e(LOG_TAG, "Failed to setMasterMute", re);
            }
            finally {
                this.mInjector.binderRestoreCallingIdentity(identity);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isMasterVolumeMuted(ComponentName who) {
        Preconditions.checkNotNull(who, "ComponentName is null");
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            this.getActiveAdminForCallerLocked(who, -1);
            AudioManager audioManager = (AudioManager)this.mContext.getSystemService("audio");
            return audioManager.isMasterMute();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUserIcon(ComponentName who, Bitmap icon) {
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            Preconditions.checkNotNull(who, "ComponentName is null");
            this.getActiveAdminForCallerLocked(who, -1);
            int userId = UserHandle.getCallingUserId();
            long id2 = this.mInjector.binderClearCallingIdentity();
            try {
                this.mUserManagerInternal.setUserIcon(userId, icon);
            }
            finally {
                this.mInjector.binderRestoreCallingIdentity(id2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setKeyguardDisabled(ComponentName who, boolean disabled) {
        Preconditions.checkNotNull(who, "ComponentName is null");
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            this.getActiveAdminForCallerLocked(who, -2);
        }
        int userId = UserHandle.getCallingUserId();
        long ident = this.mInjector.binderClearCallingIdentity();
        try {
            if (disabled && this.mLockPatternUtils.isSecure(userId)) {
                boolean bl = false;
                return bl;
            }
            this.mLockPatternUtils.setLockScreenDisabled(disabled, userId);
        }
        finally {
            this.mInjector.binderRestoreCallingIdentity(ident);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setStatusBarDisabled(ComponentName who, boolean disabled) {
        int userId = UserHandle.getCallingUserId();
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            this.getActiveAdminForCallerLocked(who, -2);
            DevicePolicyData policy = this.getUserData(userId);
            if (policy.mStatusBarDisabled != disabled) {
                if (!this.setStatusBarDisabledInternal(disabled, userId)) {
                    return false;
                }
                policy.mStatusBarDisabled = disabled;
                this.saveSettingsLocked(userId);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setStatusBarDisabledInternal(boolean disabled, int userId) {
        long ident = this.mInjector.binderClearCallingIdentity();
        try {
            IStatusBarService statusBarService = IStatusBarService.Stub.asInterface(ServiceManager.checkService(TAG_STATUS_BAR));
            if (statusBarService != null) {
                int flags1 = disabled ? 0x2070000 : 0;
                int flags2 = disabled ? 1 : 0;
                statusBarService.disableForUser(flags1, this.mToken, this.mContext.getPackageName(), userId);
                statusBarService.disable2ForUser(flags2, this.mToken, this.mContext.getPackageName(), userId);
                boolean bl = true;
                return bl;
            }
        }
        catch (RemoteException e) {
            Slog.e(LOG_TAG, "Failed to disable the status bar", e);
        }
        finally {
            this.mInjector.binderRestoreCallingIdentity(ident);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateUserSetupComplete() {
        List<UserInfo> users = this.mUserManager.getUsers(true);
        int N = users.size();
        for (int i = 0; i < N; ++i) {
            int userHandle = users.get((int)i).id;
            if (this.mInjector.settingsSecureGetIntForUser("user_setup_complete", 0, userHandle) == 0) continue;
            DevicePolicyData policy = this.getUserData(userHandle);
            if (policy.mUserSetupComplete) continue;
            policy.mUserSetupComplete = true;
            DevicePolicyManagerService devicePolicyManagerService = this;
            synchronized (devicePolicyManagerService) {
                this.saveSettingsLocked(userHandle);
                continue;
            }
        }
    }

    private static boolean isLimitPasswordAllowed(ActiveAdmin admin, int minPasswordQuality) {
        if (admin.passwordQuality < minPasswordQuality) {
            return false;
        }
        return admin.info.usesPolicy(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSystemUpdatePolicy(ComponentName who, SystemUpdatePolicy policy) {
        if (policy != null && !policy.isValid()) {
            throw new IllegalArgumentException("Invalid system update policy.");
        }
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            this.getActiveAdminForCallerLocked(who, -2);
            if (policy == null) {
                this.mOwners.clearSystemUpdatePolicy();
            } else {
                this.mOwners.setSystemUpdatePolicy(policy);
            }
            this.mOwners.writeDeviceOwner();
        }
        this.mContext.sendBroadcastAsUser(new Intent("android.app.action.SYSTEM_UPDATE_POLICY_CHANGED"), UserHandle.SYSTEM);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SystemUpdatePolicy getSystemUpdatePolicy() {
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            SystemUpdatePolicy policy = this.mOwners.getSystemUpdatePolicy();
            if (policy != null && !policy.isValid()) {
                Slog.w(LOG_TAG, "Stored system update policy is invalid, return null instead.");
                return null;
            }
            return policy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isCallerDeviceOwner(int callerUid) {
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            String[] pkgs;
            if (!this.mOwners.hasDeviceOwner()) {
                return false;
            }
            if (UserHandle.getUserId(callerUid) != this.mOwners.getDeviceOwnerUserId()) {
                return false;
            }
            String deviceOwnerPackageName = this.mOwners.getDeviceOwnerComponent().getPackageName();
            for (String pkg : pkgs = this.mContext.getPackageManager().getPackagesForUid(callerUid)) {
                if (!deviceOwnerPackageName.equals(pkg)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyPendingSystemUpdate(long updateReceivedTime) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.NOTIFY_PENDING_SYSTEM_UPDATE", "Only the system update service can broadcast update information");
        if (UserHandle.getCallingUserId() != 0) {
            Slog.w(LOG_TAG, "Only the system update service in the system user can broadcast update information.");
            return;
        }
        Intent intent = new Intent("android.app.action.NOTIFY_PENDING_SYSTEM_UPDATE");
        intent.putExtra("android.app.extra.SYSTEM_UPDATE_RECEIVED_TIME", updateReceivedTime);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            String deviceOwnerPackage;
            String string2 = deviceOwnerPackage = this.mOwners.hasDeviceOwner() ? this.mOwners.getDeviceOwnerComponent().getPackageName() : null;
            if (deviceOwnerPackage == null) {
                return;
            }
            UserHandle deviceOwnerUser = new UserHandle(this.mOwners.getDeviceOwnerUserId());
            ActivityInfo[] receivers = null;
            try {
                receivers = this.mContext.getPackageManager().getPackageInfo((String)deviceOwnerPackage, (int)2).receivers;
            }
            catch (PackageManager.NameNotFoundException e) {
                Log.e(LOG_TAG, "Cannot find device owner package", e);
            }
            if (receivers != null) {
                long ident = this.mInjector.binderClearCallingIdentity();
                try {
                    for (int i = 0; i < receivers.length; ++i) {
                        if (!"android.permission.BIND_DEVICE_ADMIN".equals(receivers[i].permission)) continue;
                        intent.setComponent(new ComponentName(deviceOwnerPackage, receivers[i].name));
                        this.mContext.sendBroadcastAsUser(intent, deviceOwnerUser);
                    }
                }
                finally {
                    this.mInjector.binderRestoreCallingIdentity(ident);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPermissionPolicy(ComponentName admin, int policy) throws RemoteException {
        int userId = UserHandle.getCallingUserId();
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            this.getActiveAdminForCallerLocked(admin, -1);
            DevicePolicyData userPolicy = this.getUserData(userId);
            if (userPolicy.mPermissionPolicy != policy) {
                userPolicy.mPermissionPolicy = policy;
                this.saveSettingsLocked(userId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getPermissionPolicy(ComponentName admin) throws RemoteException {
        int userId = UserHandle.getCallingUserId();
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            DevicePolicyData userPolicy = this.getUserData(userId);
            return userPolicy.mPermissionPolicy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean setPermissionGrantState(ComponentName admin, String packageName, String permission2, int grantState) throws RemoteException {
        UserHandle user = this.mInjector.binderGetCallingUserHandle();
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            this.getActiveAdminForCallerLocked(admin, -1);
            long ident = this.mInjector.binderClearCallingIdentity();
            try {
                if (this.getTargetSdk(packageName, user.getIdentifier()) < 23) {
                    boolean bl = false;
                    return bl;
                }
                PackageManager packageManager = this.mContext.getPackageManager();
                switch (grantState) {
                    case 1: {
                        packageManager.grantRuntimePermission(packageName, permission2, user);
                        packageManager.updatePermissionFlags(permission2, packageName, 4, 4, user);
                        break;
                    }
                    case 2: {
                        packageManager.revokeRuntimePermission(packageName, permission2, user);
                        packageManager.updatePermissionFlags(permission2, packageName, 4, 4, user);
                        break;
                    }
                    case 0: {
                        packageManager.updatePermissionFlags(permission2, packageName, 4, 0, user);
                        break;
                    }
                }
                boolean bl = true;
                return bl;
            }
            catch (SecurityException se) {
                boolean bl2 = false;
                return bl2;
            }
            finally {
                this.mInjector.binderRestoreCallingIdentity(ident);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int getPermissionGrantState(ComponentName admin, String packageName, String permission2) throws RemoteException {
        PackageManager packageManager = this.mContext.getPackageManager();
        UserHandle user = this.mInjector.binderGetCallingUserHandle();
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            this.getActiveAdminForCallerLocked(admin, -1);
            long ident = this.mInjector.binderClearCallingIdentity();
            try {
                int granted = this.mIPackageManager.checkPermission(permission2, packageName, user.getIdentifier());
                int permFlags = packageManager.getPermissionFlags(permission2, packageName, user);
                if ((permFlags & 4) != 4) {
                    int n = 0;
                    return n;
                }
                int n = granted == 0 ? 1 : 2;
                return n;
            }
            finally {
                this.mInjector.binderRestoreCallingIdentity(ident);
            }
        }
    }

    boolean isPackageInstalledForUser(String packageName, int userHandle) {
        try {
            PackageInfo pi = this.mInjector.getIPackageManager().getPackageInfo(packageName, 0, userHandle);
            return pi != null && pi.applicationInfo.flags != 0;
        }
        catch (RemoteException re) {
            throw new RuntimeException("Package manager has died", re);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isProvisioningAllowed(String action) {
        if (!this.mHasFeature) {
            return false;
        }
        int callingUserId = this.mInjector.userHandleGetCallingUserId();
        if ("android.app.action.PROVISION_MANAGED_PROFILE".equals(action)) {
            if (!this.hasFeatureManagedUsers()) {
                return false;
            }
            DevicePolicyManagerService devicePolicyManagerService = this;
            synchronized (devicePolicyManagerService) {
                if (this.mOwners.hasDeviceOwner()) {
                    if (!this.mInjector.userManagerIsSplitSystemUser()) {
                        return false;
                    }
                    if (this.mOwners.getDeviceOwnerUserId() != 0) {
                        return false;
                    }
                    if (callingUserId == 0) {
                        return false;
                    }
                }
            }
            if (this.getProfileOwner(callingUserId) != null) {
                return false;
            }
            long ident = this.mInjector.binderClearCallingIdentity();
            try {
                if (!this.mUserManager.canAddMoreManagedProfiles(callingUserId, true)) {
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.mInjector.binderRestoreCallingIdentity(ident);
            }
            return true;
        }
        if ("android.app.action.PROVISION_MANAGED_DEVICE".equals(action)) {
            return this.isDeviceOwnerProvisioningAllowed(callingUserId);
        }
        if ("android.app.action.PROVISION_MANAGED_USER".equals(action)) {
            if (!this.hasFeatureManagedUsers()) {
                return false;
            }
            if (!this.mInjector.userManagerIsSplitSystemUser()) {
                return false;
            }
            if (callingUserId == 0) {
                return false;
            }
            return !this.hasUserSetupCompleted(callingUserId);
        }
        if ("android.app.action.PROVISION_MANAGED_SHAREABLE_DEVICE".equals(action)) {
            if (!this.mInjector.userManagerIsSplitSystemUser()) {
                return false;
            }
            return this.isDeviceOwnerProvisioningAllowed(callingUserId);
        }
        throw new IllegalArgumentException("Unknown provisioning action " + action);
    }

    private synchronized int checkSetDeviceOwnerPreCondition(int deviceOwnerUserId, boolean isAdb) {
        if (this.mOwners.hasDeviceOwner()) {
            return 1;
        }
        if (this.mOwners.hasProfileOwner(deviceOwnerUserId)) {
            return 2;
        }
        if (!this.mUserManager.isUserRunning(new UserHandle(deviceOwnerUserId))) {
            return 3;
        }
        if (isAdb) {
            if (this.hasUserSetupCompleted(0) && !this.mInjector.userManagerIsSplitSystemUser()) {
                if (this.mUserManager.getUserCount() > 1) {
                    return 5;
                }
                if (AccountManager.get(this.mContext).getAccounts().length > 0) {
                    return 6;
                }
            }
            return 0;
        }
        if (!this.mInjector.userManagerIsSplitSystemUser()) {
            if (deviceOwnerUserId != 0) {
                return 7;
            }
            if (this.hasUserSetupCompleted(0)) {
                return 4;
            }
        }
        return 0;
    }

    private boolean isDeviceOwnerProvisioningAllowed(int deviceOwnerUserId) {
        return 0 == this.checkSetDeviceOwnerPreCondition(deviceOwnerUserId, false);
    }

    private boolean hasFeatureManagedUsers() {
        try {
            return this.mIPackageManager.hasSystemFeature("android.software.managed_users", 0);
        }
        catch (RemoteException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getWifiMacAddress(ComponentName admin) {
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            this.getActiveAdminForCallerLocked(admin, -2);
        }
        long ident = this.mInjector.binderClearCallingIdentity();
        try {
            WifiInfo wifiInfo = this.mInjector.getWifiManager().getConnectionInfo();
            if (wifiInfo == null) {
                String string2 = null;
                return string2;
            }
            String string3 = wifiInfo.hasRealMacAddress() ? wifiInfo.getMacAddress() : null;
            return string3;
        }
        finally {
            this.mInjector.binderRestoreCallingIdentity(ident);
        }
    }

    private int getTargetSdk(String packageName, int userId) {
        try {
            ApplicationInfo ai = this.mIPackageManager.getApplicationInfo(packageName, 0, userId);
            int targetSdkVersion = ai == null ? 0 : ai.targetSdkVersion;
            return targetSdkVersion;
        }
        catch (RemoteException e) {
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isManagedProfile(ComponentName admin) {
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            this.getActiveAdminForCallerLocked(admin, -1);
        }
        int callingUserId = this.mInjector.userHandleGetCallingUserId();
        UserInfo user = this.getUserInfo(callingUserId);
        return user != null && user.isManagedProfile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isSystemOnlyUser(ComponentName admin) {
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            this.getActiveAdminForCallerLocked(admin, -2);
        }
        int callingUserId = this.mInjector.userHandleGetCallingUserId();
        return UserManager.isSplitSystemUser() && callingUserId == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reboot(ComponentName admin) {
        Preconditions.checkNotNull(admin);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            this.getActiveAdminForCallerLocked(admin, -2);
        }
        long ident = this.mInjector.binderClearCallingIdentity();
        try {
            if (this.mTelephonyManager.getCallState() != 0) {
                throw new IllegalStateException("Cannot be called with ongoing call on the device");
            }
            this.mInjector.powerManagerReboot("deviceowner");
        }
        finally {
            this.mInjector.binderRestoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setShortSupportMessage(ComponentName who, CharSequence message) {
        if (!this.mHasFeature) {
            return;
        }
        Preconditions.checkNotNull(who, "ComponentName is null");
        int userHandle = this.mInjector.userHandleGetCallingUserId();
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            ActiveAdmin admin = this.getActiveAdminForUidLocked(who, this.mInjector.binderGetCallingUid());
            if (!TextUtils.equals(admin.shortSupportMessage, message)) {
                admin.shortSupportMessage = message;
                this.saveSettingsLocked(userHandle);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CharSequence getShortSupportMessage(ComponentName who) {
        if (!this.mHasFeature) {
            return null;
        }
        Preconditions.checkNotNull(who, "ComponentName is null");
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            ActiveAdmin admin = this.getActiveAdminForUidLocked(who, this.mInjector.binderGetCallingUid());
            return admin.shortSupportMessage;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLongSupportMessage(ComponentName who, CharSequence message) {
        if (!this.mHasFeature) {
            return;
        }
        Preconditions.checkNotNull(who, "ComponentName is null");
        int userHandle = this.mInjector.userHandleGetCallingUserId();
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            ActiveAdmin admin = this.getActiveAdminForUidLocked(who, this.mInjector.binderGetCallingUid());
            if (!TextUtils.equals(admin.longSupportMessage, message)) {
                admin.longSupportMessage = message;
                this.saveSettingsLocked(userHandle);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CharSequence getLongSupportMessage(ComponentName who) {
        if (!this.mHasFeature) {
            return null;
        }
        Preconditions.checkNotNull(who, "ComponentName is null");
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            ActiveAdmin admin = this.getActiveAdminForUidLocked(who, this.mInjector.binderGetCallingUid());
            return admin.longSupportMessage;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CharSequence getShortSupportMessageForUser(ComponentName who, int userHandle) {
        if (!this.mHasFeature) {
            return null;
        }
        Preconditions.checkNotNull(who, "ComponentName is null");
        if (!this.isCallerWithSystemUid()) {
            throw new SecurityException("Only the system can query support message for user");
        }
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            ActiveAdmin admin = this.getActiveAdminUncheckedLocked(who, userHandle);
            if (admin != null) {
                return admin.shortSupportMessage;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CharSequence getLongSupportMessageForUser(ComponentName who, int userHandle) {
        if (!this.mHasFeature) {
            return null;
        }
        Preconditions.checkNotNull(who, "ComponentName is null");
        if (!this.isCallerWithSystemUid()) {
            throw new SecurityException("Only the system can query support message for user");
        }
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            ActiveAdmin admin = this.getActiveAdminUncheckedLocked(who, userHandle);
            if (admin != null) {
                return admin.longSupportMessage;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setOrganizationColor(ComponentName who, int color2) {
        if (!this.mHasFeature) {
            return;
        }
        Preconditions.checkNotNull(who, "ComponentName is null");
        int userHandle = this.mInjector.userHandleGetCallingUserId();
        this.enforceManagedProfile(userHandle, "set organization color");
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            ActiveAdmin admin = this.getActiveAdminForCallerLocked(who, -1);
            admin.organizationColor = color2;
            this.saveSettingsLocked(userHandle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setOrganizationColorForUser(int color2, int userId) {
        if (!this.mHasFeature) {
            return;
        }
        this.enforceFullCrossUsersPermission(userId);
        this.enforceManageUsers();
        this.enforceManagedProfile(userId, "set organization color");
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            ActiveAdmin admin = this.getProfileOwnerAdminLocked(userId);
            admin.organizationColor = color2;
            this.saveSettingsLocked(userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getOrganizationColor(ComponentName who) {
        if (!this.mHasFeature) {
            return ActiveAdmin.DEF_ORGANIZATION_COLOR;
        }
        Preconditions.checkNotNull(who, "ComponentName is null");
        this.enforceManagedProfile(this.mInjector.userHandleGetCallingUserId(), "get organization color");
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            ActiveAdmin admin = this.getActiveAdminForCallerLocked(who, -1);
            return admin.organizationColor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getOrganizationColorForUser(int userHandle) {
        if (!this.mHasFeature) {
            return ActiveAdmin.DEF_ORGANIZATION_COLOR;
        }
        this.enforceFullCrossUsersPermission(userHandle);
        this.enforceManagedProfile(userHandle, "get organization color");
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            ActiveAdmin profileOwner = this.getProfileOwnerAdminLocked(userHandle);
            return profileOwner != null ? profileOwner.organizationColor : ActiveAdmin.DEF_ORGANIZATION_COLOR;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setOrganizationName(ComponentName who, CharSequence text) {
        if (!this.mHasFeature) {
            return;
        }
        Preconditions.checkNotNull(who, "ComponentName is null");
        int userHandle = this.mInjector.userHandleGetCallingUserId();
        this.enforceManagedProfile(userHandle, "set organization name");
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            ActiveAdmin admin = this.getActiveAdminForCallerLocked(who, -1);
            if (!TextUtils.equals(admin.organizationName, text)) {
                admin.organizationName = text == null || text.length() == 0 ? null : text.toString();
                this.saveSettingsLocked(userHandle);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CharSequence getOrganizationName(ComponentName who) {
        if (!this.mHasFeature) {
            return null;
        }
        Preconditions.checkNotNull(who, "ComponentName is null");
        this.enforceManagedProfile(this.mInjector.userHandleGetCallingUserId(), "get organization name");
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            ActiveAdmin admin = this.getActiveAdminForCallerLocked(who, -1);
            return admin.organizationName;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CharSequence getOrganizationNameForUser(int userHandle) {
        if (!this.mHasFeature) {
            return null;
        }
        this.enforceFullCrossUsersPermission(userHandle);
        this.enforceManagedProfile(userHandle, "get organization name");
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            ActiveAdmin profileOwner = this.getProfileOwnerAdminLocked(userHandle);
            return profileOwner != null ? profileOwner.organizationName : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAffiliationIds(ComponentName admin, List<String> ids) {
        ArraySet<String> affiliationIds = new ArraySet<String>(ids);
        int callingUserId = this.mInjector.userHandleGetCallingUserId();
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            this.getActiveAdminForCallerLocked(admin, -1);
            this.getUserData((int)callingUserId).mAffiliationIds = affiliationIds;
            this.saveSettingsLocked(callingUserId);
            if (callingUserId != 0 && this.isDeviceOwner(admin, callingUserId)) {
                this.getUserData((int)0).mAffiliationIds = affiliationIds;
                this.saveSettingsLocked(0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isAffiliatedUser() {
        int callingUserId = this.mInjector.userHandleGetCallingUserId();
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            if (this.mOwners.getDeviceOwnerUserId() == callingUserId) {
                return true;
            }
            ComponentName profileOwner = this.getProfileOwner(callingUserId);
            if (profileOwner == null || !profileOwner.getPackageName().equals(this.mOwners.getDeviceOwnerPackageName())) {
                return false;
            }
            Set<String> userAffiliationIds = this.getUserData((int)callingUserId).mAffiliationIds;
            Set<String> deviceAffiliationIds = this.getUserData((int)0).mAffiliationIds;
            for (String id2 : userAffiliationIds) {
                if (!deviceAffiliationIds.contains(id2)) continue;
                return true;
            }
        }
        return false;
    }

    private synchronized void disableSecurityLoggingIfNotCompliant() {
        if (!this.isDeviceOwnerManagedSingleUserDevice()) {
            this.mInjector.securityLogSetLoggingEnabledProperty(false);
            Slog.w(LOG_TAG, "Security logging turned off as it's no longer a single user device.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSecurityLoggingEnabled(ComponentName admin, boolean enabled) {
        Preconditions.checkNotNull(admin);
        this.ensureDeviceOwnerManagingSingleUser(admin);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            if (enabled == this.mInjector.securityLogGetLoggingEnabledProperty()) {
                return;
            }
            this.mInjector.securityLogSetLoggingEnabledProperty(enabled);
            if (enabled) {
                this.mSecurityLogMonitor.start();
            } else {
                this.mSecurityLogMonitor.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isSecurityLoggingEnabled(ComponentName admin) {
        Preconditions.checkNotNull(admin);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            this.getActiveAdminForCallerLocked(admin, -2);
            return this.mInjector.securityLogGetLoggingEnabledProperty();
        }
    }

    @Override
    public ParceledListSlice<SecurityLog.SecurityEvent> retrievePreRebootSecurityLogs(ComponentName admin) {
        Preconditions.checkNotNull(admin);
        this.ensureDeviceOwnerManagingSingleUser(admin);
        if (!this.mContext.getResources().getBoolean(17957039)) {
            return null;
        }
        ArrayList<SecurityLog.SecurityEvent> output = new ArrayList<SecurityLog.SecurityEvent>();
        try {
            SecurityLog.readPreviousEvents(output);
            return new ParceledListSlice<SecurityLog.SecurityEvent>(output);
        }
        catch (IOException e) {
            Slog.w(LOG_TAG, "Fail to read previous events", e);
            return new ParceledListSlice<SecurityLog.SecurityEvent>(Collections.emptyList());
        }
    }

    @Override
    public ParceledListSlice<SecurityLog.SecurityEvent> retrieveSecurityLogs(ComponentName admin) {
        Preconditions.checkNotNull(admin);
        this.ensureDeviceOwnerManagingSingleUser(admin);
        List<SecurityLog.SecurityEvent> logs = this.mSecurityLogMonitor.retrieveLogs();
        return logs != null ? new ParceledListSlice<SecurityLog.SecurityEvent>(logs) : null;
    }

    private void enforceCanManageDeviceAdmin() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_DEVICE_ADMINS", null);
    }

    private void enforceCanManageProfileAndDeviceOwners() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_PROFILE_AND_DEVICE_OWNERS", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isUninstallInQueue(String packageName) {
        this.enforceCanManageDeviceAdmin();
        int userId = this.mInjector.userHandleGetCallingUserId();
        Pair<String, Integer> packageUserPair = new Pair<String, Integer>(packageName, userId);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            return this.mPackagesToRemove.contains(packageUserPair);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void uninstallPackageWithActiveAdmins(final String packageName) {
        this.enforceCanManageDeviceAdmin();
        Preconditions.checkArgument(!TextUtils.isEmpty(packageName));
        final int userId = this.mInjector.userHandleGetCallingUserId();
        this.enforceUserUnlocked(userId);
        ComponentName profileOwner = this.getProfileOwner(userId);
        if (profileOwner != null && packageName.equals(profileOwner.getPackageName())) {
            throw new IllegalArgumentException("Cannot uninstall a package with a profile owner");
        }
        ComponentName deviceOwner = this.getDeviceOwnerComponent(false);
        if (this.getDeviceOwnerUserId() == userId && deviceOwner != null && packageName.equals(deviceOwner.getPackageName())) {
            throw new IllegalArgumentException("Cannot uninstall a package with a device owner");
        }
        Pair<String, Integer> packageUserPair = new Pair<String, Integer>(packageName, userId);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            this.mPackagesToRemove.add(packageUserPair);
        }
        List<ComponentName> allActiveAdmins = this.getActiveAdmins(userId);
        final ArrayList<ComponentName> packageActiveAdmins = new ArrayList<ComponentName>();
        if (allActiveAdmins != null) {
            for (ComponentName activeAdmin : allActiveAdmins) {
                if (!packageName.equals(activeAdmin.getPackageName())) continue;
                packageActiveAdmins.add(activeAdmin);
                this.removeActiveAdmin(activeAdmin, userId);
            }
        }
        if (packageActiveAdmins.size() == 0) {
            this.startUninstallIntent(packageName, userId);
        } else {
            this.mHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    for (ComponentName activeAdmin : packageActiveAdmins) {
                        DevicePolicyManagerService.this.removeAdminArtifacts(activeAdmin, userId);
                    }
                    DevicePolicyManagerService.this.startUninstallIntent(packageName, userId);
                }
            }, 10000L);
        }
    }

    private void removePackageIfRequired(String packageName, int userId) {
        if (!this.packageHasActiveAdmins(packageName, userId)) {
            this.startUninstallIntent(packageName, userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startUninstallIntent(String packageName, int userId) {
        Pair<String, Integer> packageUserPair = new Pair<String, Integer>(packageName, userId);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            if (!this.mPackagesToRemove.contains(packageUserPair)) {
                return;
            }
            this.mPackagesToRemove.remove(packageUserPair);
        }
        try {
            if (this.mInjector.getIPackageManager().getPackageInfo(packageName, 0, userId) == null) {
                return;
            }
        }
        catch (RemoteException re) {
            Log.e(LOG_TAG, "Failure talking to PackageManager while getting package info");
        }
        try {
            this.mInjector.getIActivityManager().forceStopPackage(packageName, userId);
        }
        catch (RemoteException re) {
            Log.e(LOG_TAG, "Failure talking to ActivityManager while force stopping package");
        }
        Uri packageURI = Uri.parse("package:" + packageName);
        Intent uninstallIntent = new Intent("android.intent.action.UNINSTALL_PACKAGE", packageURI);
        uninstallIntent.setFlags(0x10000000);
        this.mContext.startActivityAsUser(uninstallIntent, UserHandle.of(userId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAdminArtifacts(ComponentName adminReceiver, int userHandle) {
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            ActiveAdmin admin = this.getActiveAdminUncheckedLocked(adminReceiver, userHandle);
            if (admin == null) {
                return;
            }
            DevicePolicyData policy = this.getUserData(userHandle);
            boolean doProxyCleanup = admin.info.usesPolicy(5);
            policy.mAdminList.remove(admin);
            policy.mAdminMap.remove(adminReceiver);
            this.validatePasswordOwnerLocked(policy);
            if (doProxyCleanup) {
                this.resetGlobalProxyLocked(policy);
            }
            this.saveSettingsLocked(userHandle);
            this.updateMaximumTimeToLockLocked(userHandle);
            policy.mRemovingAdmins.remove(adminReceiver);
        }
        this.pushUserRestrictions(userHandle);
    }

    static {
        SECURE_SETTINGS_WHITELIST.add("default_input_method");
        SECURE_SETTINGS_WHITELIST.add("skip_first_use_hints");
        SECURE_SETTINGS_WHITELIST.add("install_non_market_apps");
        SECURE_SETTINGS_DEVICEOWNER_WHITELIST = new ArraySet<String>();
        SECURE_SETTINGS_DEVICEOWNER_WHITELIST.addAll(SECURE_SETTINGS_WHITELIST);
        SECURE_SETTINGS_DEVICEOWNER_WHITELIST.add("location_mode");
        GLOBAL_SETTINGS_WHITELIST = new ArraySet<String>();
        GLOBAL_SETTINGS_WHITELIST.add("adb_enabled");
        GLOBAL_SETTINGS_WHITELIST.add("auto_time");
        GLOBAL_SETTINGS_WHITELIST.add("auto_time_zone");
        GLOBAL_SETTINGS_WHITELIST.add("data_roaming");
        GLOBAL_SETTINGS_WHITELIST.add("usb_mass_storage_enabled");
        GLOBAL_SETTINGS_WHITELIST.add("wifi_sleep_policy");
        GLOBAL_SETTINGS_WHITELIST.add("stay_on_while_plugged_in");
        GLOBAL_SETTINGS_WHITELIST.add("wifi_device_owner_configs_lockdown");
        GLOBAL_SETTINGS_DEPRECATED = new ArraySet<String>();
        GLOBAL_SETTINGS_DEPRECATED.add("bluetooth_on");
        GLOBAL_SETTINGS_DEPRECATED.add("development_settings_enabled");
        GLOBAL_SETTINGS_DEPRECATED.add("mode_ringer");
        GLOBAL_SETTINGS_DEPRECATED.add("network_preference");
        GLOBAL_SETTINGS_DEPRECATED.add("wifi_on");
    }

    final class LocalService
    extends DevicePolicyManagerInternal {
        private List<DevicePolicyManagerInternal.OnCrossProfileWidgetProvidersChangeListener> mWidgetProviderListeners;

        LocalService() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<String> getCrossProfileWidgetProviders(int profileId) {
            DevicePolicyManagerService devicePolicyManagerService = DevicePolicyManagerService.this;
            synchronized (devicePolicyManagerService) {
                if (DevicePolicyManagerService.this.mOwners == null) {
                    return Collections.emptyList();
                }
                ComponentName ownerComponent = DevicePolicyManagerService.this.mOwners.getProfileOwnerComponent(profileId);
                if (ownerComponent == null) {
                    return Collections.emptyList();
                }
                DevicePolicyData policy = DevicePolicyManagerService.this.getUserDataUnchecked(profileId);
                ActiveAdmin admin = policy.mAdminMap.get(ownerComponent);
                if (admin == null || admin.crossProfileWidgetProviders == null || admin.crossProfileWidgetProviders.isEmpty()) {
                    return Collections.emptyList();
                }
                return admin.crossProfileWidgetProviders;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addOnCrossProfileWidgetProvidersChangeListener(DevicePolicyManagerInternal.OnCrossProfileWidgetProvidersChangeListener listener) {
            DevicePolicyManagerService devicePolicyManagerService = DevicePolicyManagerService.this;
            synchronized (devicePolicyManagerService) {
                if (this.mWidgetProviderListeners == null) {
                    this.mWidgetProviderListeners = new ArrayList<DevicePolicyManagerInternal.OnCrossProfileWidgetProvidersChangeListener>();
                }
                if (!this.mWidgetProviderListeners.contains(listener)) {
                    this.mWidgetProviderListeners.add(listener);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isActiveAdminWithPolicy(int uid, int reqPolicy) {
            DevicePolicyManagerService devicePolicyManagerService = DevicePolicyManagerService.this;
            synchronized (devicePolicyManagerService) {
                return DevicePolicyManagerService.this.getActiveAdminWithPolicyForUidLocked(null, reqPolicy, uid) != null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void notifyCrossProfileProvidersChanged(int userId, List<String> packages) {
            ArrayList<DevicePolicyManagerInternal.OnCrossProfileWidgetProvidersChangeListener> listeners;
            DevicePolicyManagerService devicePolicyManagerService = DevicePolicyManagerService.this;
            synchronized (devicePolicyManagerService) {
                listeners = new ArrayList<DevicePolicyManagerInternal.OnCrossProfileWidgetProvidersChangeListener>(this.mWidgetProviderListeners);
            }
            int listenerCount = listeners.size();
            for (int i = 0; i < listenerCount; ++i) {
                DevicePolicyManagerInternal.OnCrossProfileWidgetProvidersChangeListener listener = (DevicePolicyManagerInternal.OnCrossProfileWidgetProvidersChangeListener)listeners.get(i);
                listener.onCrossProfileWidgetProvidersChanged(userId, packages);
            }
        }

        @Override
        public Intent createPackageSuspendedDialogIntent(String packageName, int userId) {
            Intent intent = new Intent("android.settings.SHOW_ADMIN_SUPPORT_DETAILS");
            intent.putExtra("android.intent.extra.USER_ID", userId);
            intent.setFlags(0x10000000);
            ComponentName profileOwner = DevicePolicyManagerService.this.mOwners.getProfileOwnerComponent(userId);
            if (profileOwner != null) {
                intent.putExtra("android.app.extra.DEVICE_ADMIN", profileOwner);
                return intent;
            }
            Pair<Integer, ComponentName> deviceOwner = DevicePolicyManagerService.this.mOwners.getDeviceOwnerUserIdAndComponent();
            if (deviceOwner != null && (Integer)deviceOwner.first == userId) {
                intent.putExtra("android.app.extra.DEVICE_ADMIN", (Parcelable)deviceOwner.second);
                return intent;
            }
            return intent;
        }
    }

    private class SetupContentObserver
    extends ContentObserver {
        private final Uri mUserSetupComplete;
        private final Uri mDeviceProvisioned;

        public SetupContentObserver(Handler handler) {
            super(handler);
            this.mUserSetupComplete = Settings.Secure.getUriFor("user_setup_complete");
            this.mDeviceProvisioned = Settings.Global.getUriFor("device_provisioned");
        }

        void register() {
            DevicePolicyManagerService.this.mInjector.registerContentObserver(this.mUserSetupComplete, false, this, -1);
            DevicePolicyManagerService.this.mInjector.registerContentObserver(this.mDeviceProvisioned, false, this, -1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onChange(boolean selfChange, Uri uri) {
            if (this.mUserSetupComplete.equals(uri)) {
                DevicePolicyManagerService.this.updateUserSetupComplete();
            } else if (this.mDeviceProvisioned.equals(uri)) {
                DevicePolicyManagerService devicePolicyManagerService = DevicePolicyManagerService.this;
                synchronized (devicePolicyManagerService) {
                    DevicePolicyManagerService.this.setDeviceOwnerSystemPropertyLocked();
                }
            }
        }
    }

    private class MonitoringCertNotificationTask
    extends AsyncTask<Integer, Void, Void> {
        private MonitoringCertNotificationTask() {
        }

        protected Void doInBackground(Integer ... params) {
            int userHandle = params[0];
            if (userHandle == -1) {
                for (UserInfo userInfo : DevicePolicyManagerService.this.mUserManager.getUsers(true)) {
                    this.manageNotification(userInfo.getUserHandle());
                }
            } else {
                this.manageNotification(UserHandle.of(userHandle));
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void manageNotification(UserHandle userHandle) {
            Context userContext;
            int smallIconId;
            String contentText;
            List<String> pendingCertificates;
            if (!DevicePolicyManagerService.this.mUserManager.isUserUnlocked(userHandle)) {
                return;
            }
            try {
                pendingCertificates = this.getInstalledCaCertificates(userHandle);
            }
            catch (RemoteException | RuntimeException e) {
                Log.e(DevicePolicyManagerService.LOG_TAG, "Could not retrieve certificates from KeyChain service", e);
                return;
            }
            DevicePolicyManagerService e = DevicePolicyManagerService.this;
            synchronized (e) {
                DevicePolicyData policy = DevicePolicyManagerService.this.getUserData(userHandle.getIdentifier());
                if (policy.mAcceptedCaCertificates.retainAll(pendingCertificates)) {
                    DevicePolicyManagerService.this.saveSettingsLocked(userHandle.getIdentifier());
                }
                pendingCertificates.removeAll(policy.mAcceptedCaCertificates);
            }
            if (pendingCertificates.isEmpty()) {
                DevicePolicyManagerService.this.mInjector.getNotificationManager().cancelAsUser(null, 0x1140001, userHandle);
                return;
            }
            int parentUserId = userHandle.getIdentifier();
            if (DevicePolicyManagerService.this.getProfileOwner(userHandle.getIdentifier()) != null) {
                contentText = DevicePolicyManagerService.this.mContext.getString(17039622, DevicePolicyManagerService.this.getProfileOwnerName(userHandle.getIdentifier()));
                smallIconId = 17303260;
                parentUserId = DevicePolicyManagerService.this.getProfileParentId(userHandle.getIdentifier());
            } else if (DevicePolicyManagerService.this.getDeviceOwnerUserId() == userHandle.getIdentifier()) {
                contentText = DevicePolicyManagerService.this.mContext.getString(17039622, DevicePolicyManagerService.this.getDeviceOwnerName());
                smallIconId = 17303260;
            } else {
                contentText = DevicePolicyManagerService.this.mContext.getString(0x1040104);
                smallIconId = 17301642;
            }
            int numberOfCertificates = pendingCertificates.size();
            Intent dialogIntent = new Intent("com.android.settings.MONITORING_CERT_INFO");
            dialogIntent.setFlags(0x10008000);
            dialogIntent.setPackage("com.android.settings");
            dialogIntent.putExtra("android.settings.extra.number_of_certificates", numberOfCertificates);
            dialogIntent.putExtra("android.intent.extra.USER_ID", userHandle.getIdentifier());
            PendingIntent notifyIntent = PendingIntent.getActivityAsUser(DevicePolicyManagerService.this.mContext, 0, dialogIntent, 0x8000000, null, new UserHandle(parentUserId));
            try {
                String packageName = DevicePolicyManagerService.this.mContext.getPackageName();
                userContext = DevicePolicyManagerService.this.mContext.createPackageContextAsUser(packageName, 0, userHandle);
            }
            catch (PackageManager.NameNotFoundException e2) {
                Log.e(DevicePolicyManagerService.LOG_TAG, "Create context as " + userHandle + " failed", e2);
                return;
            }
            Notification noti = new Notification.Builder(userContext).setSmallIcon(smallIconId).setContentTitle(DevicePolicyManagerService.this.mContext.getResources().getQuantityText(0x1140001, numberOfCertificates)).setContentText(contentText).setContentIntent(notifyIntent).setPriority(1).setShowWhen(false).setColor(DevicePolicyManagerService.this.mContext.getColor(17170521)).build();
            DevicePolicyManagerService.this.mInjector.getNotificationManager().notifyAsUser(null, 0x1140001, noti, userHandle);
        }

        private List<String> getInstalledCaCertificates(UserHandle userHandle) throws RemoteException, RuntimeException {
            try (KeyChain.KeyChainConnection conn = null;){
                conn = KeyChain.bindAsUser(DevicePolicyManagerService.this.mContext, userHandle);
                List aliases = conn.getService().getUserCaAliases().getList();
                ArrayList<String> result = new ArrayList<String>(aliases.size());
                for (int i = 0; i < aliases.size(); ++i) {
                    result.add(((ParcelableString)aliases.get((int)i)).string);
                }
                ArrayList<String> arrayList = result;
                return arrayList;
            }
        }
    }

    static class Injector {
        private final Context mContext;

        Injector(Context context) {
            this.mContext = context;
        }

        Owners newOwners() {
            return new Owners(this.getUserManager(), this.getUserManagerInternal(), this.getPackageManagerInternal());
        }

        UserManager getUserManager() {
            return UserManager.get(this.mContext);
        }

        UserManagerInternal getUserManagerInternal() {
            return LocalServices.getService(UserManagerInternal.class);
        }

        PackageManagerInternal getPackageManagerInternal() {
            return LocalServices.getService(PackageManagerInternal.class);
        }

        NotificationManager getNotificationManager() {
            return this.mContext.getSystemService(NotificationManager.class);
        }

        PowerManagerInternal getPowerManagerInternal() {
            return LocalServices.getService(PowerManagerInternal.class);
        }

        TelephonyManager getTelephonyManager() {
            return TelephonyManager.from(this.mContext);
        }

        IWindowManager getIWindowManager() {
            return IWindowManager.Stub.asInterface(ServiceManager.getService("window"));
        }

        IActivityManager getIActivityManager() {
            return ActivityManagerNative.getDefault();
        }

        IPackageManager getIPackageManager() {
            return AppGlobals.getPackageManager();
        }

        IBackupManager getIBackupManager() {
            return IBackupManager.Stub.asInterface(ServiceManager.getService("backup"));
        }

        IAudioService getIAudioService() {
            return IAudioService.Stub.asInterface(ServiceManager.getService("audio"));
        }

        LockPatternUtils newLockPatternUtils() {
            return new LockPatternUtils(this.mContext);
        }

        boolean storageManagerIsFileBasedEncryptionEnabled() {
            return StorageManager.isFileEncryptedNativeOnly();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean storageManagerIsNonDefaultBlockEncrypted() {
            long identity = Binder.clearCallingIdentity();
            try {
                boolean bl = StorageManager.isNonDefaultBlockEncrypted();
                return bl;
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        boolean storageManagerIsEncrypted() {
            return StorageManager.isEncrypted();
        }

        boolean storageManagerIsEncryptable() {
            return StorageManager.isEncryptable();
        }

        Looper getMyLooper() {
            return Looper.myLooper();
        }

        WifiManager getWifiManager() {
            return this.mContext.getSystemService(WifiManager.class);
        }

        long binderClearCallingIdentity() {
            return Binder.clearCallingIdentity();
        }

        void binderRestoreCallingIdentity(long token) {
            Binder.restoreCallingIdentity(token);
        }

        int binderGetCallingUid() {
            return Binder.getCallingUid();
        }

        int binderGetCallingPid() {
            return Binder.getCallingPid();
        }

        UserHandle binderGetCallingUserHandle() {
            return Binder.getCallingUserHandle();
        }

        boolean binderIsCallingUidMyUid() {
            return Binder.getCallingUid() == Process.myUid();
        }

        final int userHandleGetCallingUserId() {
            return UserHandle.getUserId(this.binderGetCallingUid());
        }

        File environmentGetUserSystemDirectory(int userId) {
            return Environment.getUserSystemDirectory(userId);
        }

        void powerManagerGoToSleep(long time, int reason, int flags) {
            this.mContext.getSystemService(PowerManager.class).goToSleep(time, reason, flags);
        }

        void powerManagerReboot(String reason) {
            this.mContext.getSystemService(PowerManager.class).reboot(reason);
        }

        boolean systemPropertiesGetBoolean(String key, boolean def) {
            return SystemProperties.getBoolean(key, def);
        }

        long systemPropertiesGetLong(String key, long def) {
            return SystemProperties.getLong(key, def);
        }

        String systemPropertiesGet(String key, String def) {
            return SystemProperties.get(key, def);
        }

        String systemPropertiesGet(String key) {
            return SystemProperties.get(key);
        }

        void systemPropertiesSet(String key, String value) {
            SystemProperties.set(key, value);
        }

        boolean userManagerIsSplitSystemUser() {
            return UserManager.isSplitSystemUser();
        }

        String getDevicePolicyFilePathForSystemUser() {
            return "/data/system/";
        }

        void registerContentObserver(Uri uri, boolean notifyForDescendents, ContentObserver observer, int userHandle) {
            this.mContext.getContentResolver().registerContentObserver(uri, notifyForDescendents, observer, userHandle);
        }

        int settingsSecureGetIntForUser(String name, int def, int userHandle) {
            return Settings.Secure.getIntForUser(this.mContext.getContentResolver(), name, def, userHandle);
        }

        void settingsSecurePutIntForUser(String name, int value, int userHandle) {
            Settings.Secure.putIntForUser(this.mContext.getContentResolver(), name, value, userHandle);
        }

        void settingsSecurePutStringForUser(String name, String value, int userHandle) {
            Settings.Secure.putStringForUser(this.mContext.getContentResolver(), name, value, userHandle);
        }

        void settingsGlobalPutStringForUser(String name, String value, int userHandle) {
            Settings.Global.putStringForUser(this.mContext.getContentResolver(), name, value, userHandle);
        }

        void settingsSecurePutInt(String name, int value) {
            Settings.Secure.putInt(this.mContext.getContentResolver(), name, value);
        }

        int settingsGlobalGetInt(String name, int def) {
            return Settings.Global.getInt(this.mContext.getContentResolver(), name, def);
        }

        void settingsGlobalPutInt(String name, int value) {
            Settings.Global.putInt(this.mContext.getContentResolver(), name, value);
        }

        void settingsSecurePutString(String name, String value) {
            Settings.Secure.putString(this.mContext.getContentResolver(), name, value);
        }

        void settingsGlobalPutString(String name, String value) {
            Settings.Global.putString(this.mContext.getContentResolver(), name, value);
        }

        void securityLogSetLoggingEnabledProperty(boolean enabled) {
            SecurityLog.setLoggingEnabledProperty(enabled);
        }

        boolean securityLogGetLoggingEnabledProperty() {
            return SecurityLog.getLoggingEnabledProperty();
        }

        boolean securityLogIsLoggingEnabled() {
            return SecurityLog.isLoggingEnabled();
        }
    }

    static class ActiveAdmin {
        private static final String TAG_DISABLE_KEYGUARD_FEATURES = "disable-keyguard-features";
        private static final String TAG_DISABLE_CAMERA = "disable-camera";
        private static final String TAG_DISABLE_CALLER_ID = "disable-caller-id";
        private static final String TAG_DISABLE_CONTACTS_SEARCH = "disable-contacts-search";
        private static final String TAG_DISABLE_BLUETOOTH_CONTACT_SHARING = "disable-bt-contacts-sharing";
        private static final String TAG_DISABLE_SCREEN_CAPTURE = "disable-screen-capture";
        private static final String TAG_DISABLE_ACCOUNT_MANAGEMENT = "disable-account-management";
        private static final String TAG_REQUIRE_AUTO_TIME = "require_auto_time";
        private static final String TAG_FORCE_EPHEMERAL_USERS = "force_ephemeral_users";
        private static final String TAG_ACCOUNT_TYPE = "account-type";
        private static final String TAG_PERMITTED_ACCESSIBILITY_SERVICES = "permitted-accessiblity-services";
        private static final String TAG_ENCRYPTION_REQUESTED = "encryption-requested";
        private static final String TAG_MANAGE_TRUST_AGENT_FEATURES = "manage-trust-agent-features";
        private static final String TAG_TRUST_AGENT_COMPONENT_OPTIONS = "trust-agent-component-options";
        private static final String TAG_TRUST_AGENT_COMPONENT = "component";
        private static final String TAG_PASSWORD_EXPIRATION_DATE = "password-expiration-date";
        private static final String TAG_PASSWORD_EXPIRATION_TIMEOUT = "password-expiration-timeout";
        private static final String TAG_GLOBAL_PROXY_EXCLUSION_LIST = "global-proxy-exclusion-list";
        private static final String TAG_GLOBAL_PROXY_SPEC = "global-proxy-spec";
        private static final String TAG_SPECIFIES_GLOBAL_PROXY = "specifies-global-proxy";
        private static final String TAG_PERMITTED_IMES = "permitted-imes";
        private static final String TAG_MAX_FAILED_PASSWORD_WIPE = "max-failed-password-wipe";
        private static final String TAG_MAX_TIME_TO_UNLOCK = "max-time-to-unlock";
        private static final String TAG_MIN_PASSWORD_NONLETTER = "min-password-nonletter";
        private static final String TAG_MIN_PASSWORD_SYMBOLS = "min-password-symbols";
        private static final String TAG_MIN_PASSWORD_NUMERIC = "min-password-numeric";
        private static final String TAG_MIN_PASSWORD_LETTERS = "min-password-letters";
        private static final String TAG_MIN_PASSWORD_LOWERCASE = "min-password-lowercase";
        private static final String TAG_MIN_PASSWORD_UPPERCASE = "min-password-uppercase";
        private static final String TAG_PASSWORD_HISTORY_LENGTH = "password-history-length";
        private static final String TAG_MIN_PASSWORD_LENGTH = "min-password-length";
        private static final String ATTR_VALUE = "value";
        private static final String TAG_PASSWORD_QUALITY = "password-quality";
        private static final String TAG_POLICIES = "policies";
        private static final String TAG_CROSS_PROFILE_WIDGET_PROVIDERS = "cross-profile-widget-providers";
        private static final String TAG_PROVIDER = "provider";
        private static final String TAG_PACKAGE_LIST_ITEM = "item";
        private static final String TAG_KEEP_UNINSTALLED_PACKAGES = "keep-uninstalled-packages";
        private static final String TAG_USER_RESTRICTIONS = "user-restrictions";
        private static final String TAG_SHORT_SUPPORT_MESSAGE = "short-support-message";
        private static final String TAG_LONG_SUPPORT_MESSAGE = "long-support-message";
        private static final String TAG_PARENT_ADMIN = "parent-admin";
        private static final String TAG_ORGANIZATION_COLOR = "organization-color";
        private static final String TAG_ORGANIZATION_NAME = "organization-name";
        final DeviceAdminInfo info;
        int passwordQuality = 0;
        static final int DEF_MINIMUM_PASSWORD_LENGTH = 0;
        int minimumPasswordLength = 0;
        static final int DEF_PASSWORD_HISTORY_LENGTH = 0;
        int passwordHistoryLength = 0;
        static final int DEF_MINIMUM_PASSWORD_UPPER_CASE = 0;
        int minimumPasswordUpperCase = 0;
        static final int DEF_MINIMUM_PASSWORD_LOWER_CASE = 0;
        int minimumPasswordLowerCase = 0;
        static final int DEF_MINIMUM_PASSWORD_LETTERS = 1;
        int minimumPasswordLetters = 1;
        static final int DEF_MINIMUM_PASSWORD_NUMERIC = 1;
        int minimumPasswordNumeric = 1;
        static final int DEF_MINIMUM_PASSWORD_SYMBOLS = 1;
        int minimumPasswordSymbols = 1;
        static final int DEF_MINIMUM_PASSWORD_NON_LETTER = 0;
        int minimumPasswordNonLetter = 0;
        static final long DEF_MAXIMUM_TIME_TO_UNLOCK = 0L;
        long maximumTimeToUnlock = 0L;
        static final int DEF_MAXIMUM_FAILED_PASSWORDS_FOR_WIPE = 0;
        int maximumFailedPasswordsForWipe = 0;
        static final long DEF_PASSWORD_EXPIRATION_TIMEOUT = 0L;
        long passwordExpirationTimeout = 0L;
        static final long DEF_PASSWORD_EXPIRATION_DATE = 0L;
        long passwordExpirationDate = 0L;
        static final int DEF_KEYGUARD_FEATURES_DISABLED = 0;
        int disabledKeyguardFeatures = 0;
        boolean encryptionRequested = false;
        boolean disableCamera = false;
        boolean disableCallerId = false;
        boolean disableContactsSearch = false;
        boolean disableBluetoothContactSharing = true;
        boolean disableScreenCapture = false;
        boolean requireAutoTime = false;
        boolean forceEphemeralUsers = false;
        ActiveAdmin parentAdmin;
        final boolean isParent;
        Set<String> accountTypesWithManagementDisabled = new ArraySet<String>();
        List<String> permittedAccessiblityServices;
        List<String> permittedInputMethods;
        List<String> keepUninstalledPackages;
        boolean specifiesGlobalProxy = false;
        String globalProxySpec = null;
        String globalProxyExclusionList = null;
        ArrayMap<String, TrustAgentInfo> trustAgentInfos = new ArrayMap();
        List<String> crossProfileWidgetProviders;
        Bundle userRestrictions;
        CharSequence shortSupportMessage = null;
        CharSequence longSupportMessage = null;
        static final int DEF_ORGANIZATION_COLOR = Color.parseColor("#00796B");
        int organizationColor = DEF_ORGANIZATION_COLOR;
        String organizationName = null;

        ActiveAdmin(DeviceAdminInfo _info, boolean parent) {
            this.info = _info;
            this.isParent = parent;
        }

        ActiveAdmin getParentActiveAdmin() {
            Preconditions.checkState(!this.isParent);
            if (this.parentAdmin == null) {
                this.parentAdmin = new ActiveAdmin(this.info, true);
            }
            return this.parentAdmin;
        }

        boolean hasParentActiveAdmin() {
            return this.parentAdmin != null;
        }

        int getUid() {
            return this.info.getActivityInfo().applicationInfo.uid;
        }

        public UserHandle getUserHandle() {
            return UserHandle.of(UserHandle.getUserId(this.info.getActivityInfo().applicationInfo.uid));
        }

        /*
         * WARNING - void declaration
         */
        void writeToXml(XmlSerializer out) throws IllegalArgumentException, IllegalStateException, IOException {
            out.startTag(null, TAG_POLICIES);
            this.info.writePoliciesToXml(out);
            out.endTag(null, TAG_POLICIES);
            if (this.passwordQuality != 0) {
                out.startTag(null, TAG_PASSWORD_QUALITY);
                out.attribute(null, "value", Integer.toString(this.passwordQuality));
                out.endTag(null, TAG_PASSWORD_QUALITY);
                if (this.minimumPasswordLength != 0) {
                    out.startTag(null, TAG_MIN_PASSWORD_LENGTH);
                    out.attribute(null, "value", Integer.toString(this.minimumPasswordLength));
                    out.endTag(null, TAG_MIN_PASSWORD_LENGTH);
                }
                if (this.passwordHistoryLength != 0) {
                    out.startTag(null, TAG_PASSWORD_HISTORY_LENGTH);
                    out.attribute(null, "value", Integer.toString(this.passwordHistoryLength));
                    out.endTag(null, TAG_PASSWORD_HISTORY_LENGTH);
                }
                if (this.minimumPasswordUpperCase != 0) {
                    out.startTag(null, TAG_MIN_PASSWORD_UPPERCASE);
                    out.attribute(null, "value", Integer.toString(this.minimumPasswordUpperCase));
                    out.endTag(null, TAG_MIN_PASSWORD_UPPERCASE);
                }
                if (this.minimumPasswordLowerCase != 0) {
                    out.startTag(null, TAG_MIN_PASSWORD_LOWERCASE);
                    out.attribute(null, "value", Integer.toString(this.minimumPasswordLowerCase));
                    out.endTag(null, TAG_MIN_PASSWORD_LOWERCASE);
                }
                if (this.minimumPasswordLetters != 1) {
                    out.startTag(null, TAG_MIN_PASSWORD_LETTERS);
                    out.attribute(null, "value", Integer.toString(this.minimumPasswordLetters));
                    out.endTag(null, TAG_MIN_PASSWORD_LETTERS);
                }
                if (this.minimumPasswordNumeric != 1) {
                    out.startTag(null, TAG_MIN_PASSWORD_NUMERIC);
                    out.attribute(null, "value", Integer.toString(this.minimumPasswordNumeric));
                    out.endTag(null, TAG_MIN_PASSWORD_NUMERIC);
                }
                if (this.minimumPasswordSymbols != 1) {
                    out.startTag(null, TAG_MIN_PASSWORD_SYMBOLS);
                    out.attribute(null, "value", Integer.toString(this.minimumPasswordSymbols));
                    out.endTag(null, TAG_MIN_PASSWORD_SYMBOLS);
                }
                if (this.minimumPasswordNonLetter > 0) {
                    out.startTag(null, TAG_MIN_PASSWORD_NONLETTER);
                    out.attribute(null, "value", Integer.toString(this.minimumPasswordNonLetter));
                    out.endTag(null, TAG_MIN_PASSWORD_NONLETTER);
                }
            }
            if (this.maximumTimeToUnlock != 0L) {
                out.startTag(null, TAG_MAX_TIME_TO_UNLOCK);
                out.attribute(null, "value", Long.toString(this.maximumTimeToUnlock));
                out.endTag(null, TAG_MAX_TIME_TO_UNLOCK);
            }
            if (this.maximumFailedPasswordsForWipe != 0) {
                out.startTag(null, TAG_MAX_FAILED_PASSWORD_WIPE);
                out.attribute(null, "value", Integer.toString(this.maximumFailedPasswordsForWipe));
                out.endTag(null, TAG_MAX_FAILED_PASSWORD_WIPE);
            }
            if (this.specifiesGlobalProxy) {
                out.startTag(null, TAG_SPECIFIES_GLOBAL_PROXY);
                out.attribute(null, "value", Boolean.toString(this.specifiesGlobalProxy));
                out.endTag(null, TAG_SPECIFIES_GLOBAL_PROXY);
                if (this.globalProxySpec != null) {
                    out.startTag(null, TAG_GLOBAL_PROXY_SPEC);
                    out.attribute(null, "value", this.globalProxySpec);
                    out.endTag(null, TAG_GLOBAL_PROXY_SPEC);
                }
                if (this.globalProxyExclusionList != null) {
                    out.startTag(null, TAG_GLOBAL_PROXY_EXCLUSION_LIST);
                    out.attribute(null, "value", this.globalProxyExclusionList);
                    out.endTag(null, TAG_GLOBAL_PROXY_EXCLUSION_LIST);
                }
            }
            if (this.passwordExpirationTimeout != 0L) {
                out.startTag(null, TAG_PASSWORD_EXPIRATION_TIMEOUT);
                out.attribute(null, "value", Long.toString(this.passwordExpirationTimeout));
                out.endTag(null, TAG_PASSWORD_EXPIRATION_TIMEOUT);
            }
            if (this.passwordExpirationDate != 0L) {
                out.startTag(null, TAG_PASSWORD_EXPIRATION_DATE);
                out.attribute(null, "value", Long.toString(this.passwordExpirationDate));
                out.endTag(null, TAG_PASSWORD_EXPIRATION_DATE);
            }
            if (this.encryptionRequested) {
                out.startTag(null, TAG_ENCRYPTION_REQUESTED);
                out.attribute(null, "value", Boolean.toString(this.encryptionRequested));
                out.endTag(null, TAG_ENCRYPTION_REQUESTED);
            }
            if (this.disableCamera) {
                out.startTag(null, TAG_DISABLE_CAMERA);
                out.attribute(null, "value", Boolean.toString(this.disableCamera));
                out.endTag(null, TAG_DISABLE_CAMERA);
            }
            if (this.disableCallerId) {
                out.startTag(null, TAG_DISABLE_CALLER_ID);
                out.attribute(null, "value", Boolean.toString(this.disableCallerId));
                out.endTag(null, TAG_DISABLE_CALLER_ID);
            }
            if (this.disableContactsSearch) {
                out.startTag(null, TAG_DISABLE_CONTACTS_SEARCH);
                out.attribute(null, "value", Boolean.toString(this.disableContactsSearch));
                out.endTag(null, TAG_DISABLE_CONTACTS_SEARCH);
            }
            if (!this.disableBluetoothContactSharing) {
                out.startTag(null, TAG_DISABLE_BLUETOOTH_CONTACT_SHARING);
                out.attribute(null, "value", Boolean.toString(this.disableBluetoothContactSharing));
                out.endTag(null, TAG_DISABLE_BLUETOOTH_CONTACT_SHARING);
            }
            if (this.disableScreenCapture) {
                out.startTag(null, TAG_DISABLE_SCREEN_CAPTURE);
                out.attribute(null, "value", Boolean.toString(this.disableScreenCapture));
                out.endTag(null, TAG_DISABLE_SCREEN_CAPTURE);
            }
            if (this.requireAutoTime) {
                out.startTag(null, TAG_REQUIRE_AUTO_TIME);
                out.attribute(null, "value", Boolean.toString(this.requireAutoTime));
                out.endTag(null, TAG_REQUIRE_AUTO_TIME);
            }
            if (this.forceEphemeralUsers) {
                out.startTag(null, TAG_FORCE_EPHEMERAL_USERS);
                out.attribute(null, "value", Boolean.toString(this.forceEphemeralUsers));
                out.endTag(null, TAG_FORCE_EPHEMERAL_USERS);
            }
            if (this.disabledKeyguardFeatures != 0) {
                out.startTag(null, TAG_DISABLE_KEYGUARD_FEATURES);
                out.attribute(null, "value", Integer.toString(this.disabledKeyguardFeatures));
                out.endTag(null, TAG_DISABLE_KEYGUARD_FEATURES);
            }
            if (!this.accountTypesWithManagementDisabled.isEmpty()) {
                out.startTag(null, TAG_DISABLE_ACCOUNT_MANAGEMENT);
                for (String string2 : this.accountTypesWithManagementDisabled) {
                    out.startTag(null, TAG_ACCOUNT_TYPE);
                    out.attribute(null, "value", string2);
                    out.endTag(null, TAG_ACCOUNT_TYPE);
                }
                out.endTag(null, TAG_DISABLE_ACCOUNT_MANAGEMENT);
            }
            if (!this.trustAgentInfos.isEmpty()) {
                Set<Map.Entry<String, TrustAgentInfo>> set = this.trustAgentInfos.entrySet();
                out.startTag(null, TAG_MANAGE_TRUST_AGENT_FEATURES);
                for (Map.Entry<String, TrustAgentInfo> entry : set) {
                    TrustAgentInfo trustAgentInfo = entry.getValue();
                    out.startTag(null, TAG_TRUST_AGENT_COMPONENT);
                    out.attribute(null, "value", entry.getKey());
                    if (trustAgentInfo.options != null) {
                        out.startTag(null, TAG_TRUST_AGENT_COMPONENT_OPTIONS);
                        try {
                            trustAgentInfo.options.saveToXml(out);
                        }
                        catch (XmlPullParserException e) {
                            Log.e(DevicePolicyManagerService.LOG_TAG, "Failed to save TrustAgent options", e);
                        }
                        out.endTag(null, TAG_TRUST_AGENT_COMPONENT_OPTIONS);
                    }
                    out.endTag(null, TAG_TRUST_AGENT_COMPONENT);
                }
                out.endTag(null, TAG_MANAGE_TRUST_AGENT_FEATURES);
            }
            if (this.crossProfileWidgetProviders != null && !this.crossProfileWidgetProviders.isEmpty()) {
                void var3_8;
                out.startTag(null, TAG_CROSS_PROFILE_WIDGET_PROVIDERS);
                int providerCount = this.crossProfileWidgetProviders.size();
                boolean bl = false;
                while (var3_8 < providerCount) {
                    String string3 = this.crossProfileWidgetProviders.get((int)var3_8);
                    out.startTag(null, TAG_PROVIDER);
                    out.attribute(null, "value", string3);
                    out.endTag(null, TAG_PROVIDER);
                    ++var3_8;
                }
                out.endTag(null, TAG_CROSS_PROFILE_WIDGET_PROVIDERS);
            }
            this.writePackageListToXml(out, TAG_PERMITTED_ACCESSIBILITY_SERVICES, this.permittedAccessiblityServices);
            this.writePackageListToXml(out, TAG_PERMITTED_IMES, this.permittedInputMethods);
            this.writePackageListToXml(out, TAG_KEEP_UNINSTALLED_PACKAGES, this.keepUninstalledPackages);
            if (this.hasUserRestrictions()) {
                UserRestrictionsUtils.writeRestrictions(out, this.userRestrictions, TAG_USER_RESTRICTIONS);
            }
            if (!TextUtils.isEmpty(this.shortSupportMessage)) {
                out.startTag(null, TAG_SHORT_SUPPORT_MESSAGE);
                out.text(this.shortSupportMessage.toString());
                out.endTag(null, TAG_SHORT_SUPPORT_MESSAGE);
            }
            if (!TextUtils.isEmpty(this.longSupportMessage)) {
                out.startTag(null, TAG_LONG_SUPPORT_MESSAGE);
                out.text(this.longSupportMessage.toString());
                out.endTag(null, TAG_LONG_SUPPORT_MESSAGE);
            }
            if (this.parentAdmin != null) {
                out.startTag(null, TAG_PARENT_ADMIN);
                this.parentAdmin.writeToXml(out);
                out.endTag(null, TAG_PARENT_ADMIN);
            }
            if (this.organizationColor != DEF_ORGANIZATION_COLOR) {
                out.startTag(null, TAG_ORGANIZATION_COLOR);
                out.attribute(null, "value", Integer.toString(this.organizationColor));
                out.endTag(null, TAG_ORGANIZATION_COLOR);
            }
            if (this.organizationName != null) {
                out.startTag(null, TAG_ORGANIZATION_NAME);
                out.text(this.organizationName);
                out.endTag(null, TAG_ORGANIZATION_NAME);
            }
        }

        void writePackageListToXml(XmlSerializer out, String outerTag, List<String> packageList) throws IllegalArgumentException, IllegalStateException, IOException {
            if (packageList == null) {
                return;
            }
            out.startTag(null, outerTag);
            for (String packageName : packageList) {
                out.startTag(null, TAG_PACKAGE_LIST_ITEM);
                out.attribute(null, "value", packageName);
                out.endTag(null, TAG_PACKAGE_LIST_ITEM);
            }
            out.endTag(null, outerTag);
        }

        void readFromXml(XmlPullParser parser) throws XmlPullParserException, IOException {
            int type;
            int outerDepth = parser.getDepth();
            while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
                if (type == 3 || type == 4) continue;
                String tag = parser.getName();
                if (TAG_POLICIES.equals(tag)) {
                    this.info.readPoliciesFromXml(parser);
                    continue;
                }
                if (TAG_PASSWORD_QUALITY.equals(tag)) {
                    this.passwordQuality = Integer.parseInt(parser.getAttributeValue(null, "value"));
                    continue;
                }
                if (TAG_MIN_PASSWORD_LENGTH.equals(tag)) {
                    this.minimumPasswordLength = Integer.parseInt(parser.getAttributeValue(null, "value"));
                    continue;
                }
                if (TAG_PASSWORD_HISTORY_LENGTH.equals(tag)) {
                    this.passwordHistoryLength = Integer.parseInt(parser.getAttributeValue(null, "value"));
                    continue;
                }
                if (TAG_MIN_PASSWORD_UPPERCASE.equals(tag)) {
                    this.minimumPasswordUpperCase = Integer.parseInt(parser.getAttributeValue(null, "value"));
                    continue;
                }
                if (TAG_MIN_PASSWORD_LOWERCASE.equals(tag)) {
                    this.minimumPasswordLowerCase = Integer.parseInt(parser.getAttributeValue(null, "value"));
                    continue;
                }
                if (TAG_MIN_PASSWORD_LETTERS.equals(tag)) {
                    this.minimumPasswordLetters = Integer.parseInt(parser.getAttributeValue(null, "value"));
                    continue;
                }
                if (TAG_MIN_PASSWORD_NUMERIC.equals(tag)) {
                    this.minimumPasswordNumeric = Integer.parseInt(parser.getAttributeValue(null, "value"));
                    continue;
                }
                if (TAG_MIN_PASSWORD_SYMBOLS.equals(tag)) {
                    this.minimumPasswordSymbols = Integer.parseInt(parser.getAttributeValue(null, "value"));
                    continue;
                }
                if (TAG_MIN_PASSWORD_NONLETTER.equals(tag)) {
                    this.minimumPasswordNonLetter = Integer.parseInt(parser.getAttributeValue(null, "value"));
                    continue;
                }
                if (TAG_MAX_TIME_TO_UNLOCK.equals(tag)) {
                    this.maximumTimeToUnlock = Long.parseLong(parser.getAttributeValue(null, "value"));
                    continue;
                }
                if (TAG_MAX_FAILED_PASSWORD_WIPE.equals(tag)) {
                    this.maximumFailedPasswordsForWipe = Integer.parseInt(parser.getAttributeValue(null, "value"));
                    continue;
                }
                if (TAG_SPECIFIES_GLOBAL_PROXY.equals(tag)) {
                    this.specifiesGlobalProxy = Boolean.parseBoolean(parser.getAttributeValue(null, "value"));
                    continue;
                }
                if (TAG_GLOBAL_PROXY_SPEC.equals(tag)) {
                    this.globalProxySpec = parser.getAttributeValue(null, "value");
                    continue;
                }
                if (TAG_GLOBAL_PROXY_EXCLUSION_LIST.equals(tag)) {
                    this.globalProxyExclusionList = parser.getAttributeValue(null, "value");
                    continue;
                }
                if (TAG_PASSWORD_EXPIRATION_TIMEOUT.equals(tag)) {
                    this.passwordExpirationTimeout = Long.parseLong(parser.getAttributeValue(null, "value"));
                    continue;
                }
                if (TAG_PASSWORD_EXPIRATION_DATE.equals(tag)) {
                    this.passwordExpirationDate = Long.parseLong(parser.getAttributeValue(null, "value"));
                    continue;
                }
                if (TAG_ENCRYPTION_REQUESTED.equals(tag)) {
                    this.encryptionRequested = Boolean.parseBoolean(parser.getAttributeValue(null, "value"));
                    continue;
                }
                if (TAG_DISABLE_CAMERA.equals(tag)) {
                    this.disableCamera = Boolean.parseBoolean(parser.getAttributeValue(null, "value"));
                    continue;
                }
                if (TAG_DISABLE_CALLER_ID.equals(tag)) {
                    this.disableCallerId = Boolean.parseBoolean(parser.getAttributeValue(null, "value"));
                    continue;
                }
                if (TAG_DISABLE_CONTACTS_SEARCH.equals(tag)) {
                    this.disableContactsSearch = Boolean.parseBoolean(parser.getAttributeValue(null, "value"));
                    continue;
                }
                if (TAG_DISABLE_BLUETOOTH_CONTACT_SHARING.equals(tag)) {
                    this.disableBluetoothContactSharing = Boolean.parseBoolean(parser.getAttributeValue(null, "value"));
                    continue;
                }
                if (TAG_DISABLE_SCREEN_CAPTURE.equals(tag)) {
                    this.disableScreenCapture = Boolean.parseBoolean(parser.getAttributeValue(null, "value"));
                    continue;
                }
                if (TAG_REQUIRE_AUTO_TIME.equals(tag)) {
                    this.requireAutoTime = Boolean.parseBoolean(parser.getAttributeValue(null, "value"));
                    continue;
                }
                if (TAG_FORCE_EPHEMERAL_USERS.equals(tag)) {
                    this.forceEphemeralUsers = Boolean.parseBoolean(parser.getAttributeValue(null, "value"));
                    continue;
                }
                if (TAG_DISABLE_KEYGUARD_FEATURES.equals(tag)) {
                    this.disabledKeyguardFeatures = Integer.parseInt(parser.getAttributeValue(null, "value"));
                    continue;
                }
                if (TAG_DISABLE_ACCOUNT_MANAGEMENT.equals(tag)) {
                    this.accountTypesWithManagementDisabled = this.readDisableAccountInfo(parser, tag);
                    continue;
                }
                if (TAG_MANAGE_TRUST_AGENT_FEATURES.equals(tag)) {
                    this.trustAgentInfos = this.getAllTrustAgentInfos(parser, tag);
                    continue;
                }
                if (TAG_CROSS_PROFILE_WIDGET_PROVIDERS.equals(tag)) {
                    this.crossProfileWidgetProviders = this.getCrossProfileWidgetProviders(parser, tag);
                    continue;
                }
                if (TAG_PERMITTED_ACCESSIBILITY_SERVICES.equals(tag)) {
                    this.permittedAccessiblityServices = this.readPackageList(parser, tag);
                    continue;
                }
                if (TAG_PERMITTED_IMES.equals(tag)) {
                    this.permittedInputMethods = this.readPackageList(parser, tag);
                    continue;
                }
                if (TAG_KEEP_UNINSTALLED_PACKAGES.equals(tag)) {
                    this.keepUninstalledPackages = this.readPackageList(parser, tag);
                    continue;
                }
                if (TAG_USER_RESTRICTIONS.equals(tag)) {
                    UserRestrictionsUtils.readRestrictions(parser, this.ensureUserRestrictions());
                    continue;
                }
                if (TAG_SHORT_SUPPORT_MESSAGE.equals(tag)) {
                    type = parser.next();
                    if (type == 4) {
                        this.shortSupportMessage = parser.getText();
                        continue;
                    }
                    Log.w(DevicePolicyManagerService.LOG_TAG, "Missing text when loading short support message");
                    continue;
                }
                if (TAG_LONG_SUPPORT_MESSAGE.equals(tag)) {
                    type = parser.next();
                    if (type == 4) {
                        this.longSupportMessage = parser.getText();
                        continue;
                    }
                    Log.w(DevicePolicyManagerService.LOG_TAG, "Missing text when loading long support message");
                    continue;
                }
                if (TAG_PARENT_ADMIN.equals(tag)) {
                    Preconditions.checkState(!this.isParent);
                    this.parentAdmin = new ActiveAdmin(this.info, true);
                    this.parentAdmin.readFromXml(parser);
                    continue;
                }
                if (TAG_ORGANIZATION_COLOR.equals(tag)) {
                    this.organizationColor = Integer.parseInt(parser.getAttributeValue(null, "value"));
                    continue;
                }
                if (TAG_ORGANIZATION_NAME.equals(tag)) {
                    type = parser.next();
                    if (type == 4) {
                        this.organizationName = parser.getText();
                        continue;
                    }
                    Log.w(DevicePolicyManagerService.LOG_TAG, "Missing text when loading organization name");
                    continue;
                }
                Slog.w(DevicePolicyManagerService.LOG_TAG, "Unknown admin tag: " + tag);
                XmlUtils.skipCurrentTag(parser);
            }
        }

        private List<String> readPackageList(XmlPullParser parser, String tag) throws XmlPullParserException, IOException {
            int outerType;
            ArrayList<String> result = new ArrayList<String>();
            int outerDepth = parser.getDepth();
            while ((outerType = parser.next()) != 1 && (outerType != 3 || parser.getDepth() > outerDepth)) {
                if (outerType == 3 || outerType == 4) continue;
                String outerTag = parser.getName();
                if (TAG_PACKAGE_LIST_ITEM.equals(outerTag)) {
                    String packageName = parser.getAttributeValue(null, "value");
                    if (packageName != null) {
                        result.add(packageName);
                        continue;
                    }
                    Slog.w(DevicePolicyManagerService.LOG_TAG, "Package name missing under " + outerTag);
                    continue;
                }
                Slog.w(DevicePolicyManagerService.LOG_TAG, "Unknown tag under " + tag + ": " + outerTag);
            }
            return result;
        }

        private Set<String> readDisableAccountInfo(XmlPullParser parser, String tag) throws XmlPullParserException, IOException {
            int typeDAM;
            int outerDepthDAM = parser.getDepth();
            ArraySet<String> result = new ArraySet<String>();
            while ((typeDAM = parser.next()) != 1 && (typeDAM != 3 || parser.getDepth() > outerDepthDAM)) {
                if (typeDAM == 3 || typeDAM == 4) continue;
                String tagDAM = parser.getName();
                if (TAG_ACCOUNT_TYPE.equals(tagDAM)) {
                    result.add(parser.getAttributeValue(null, "value"));
                    continue;
                }
                Slog.w(DevicePolicyManagerService.LOG_TAG, "Unknown tag under " + tag + ": " + tagDAM);
            }
            return result;
        }

        private ArrayMap<String, TrustAgentInfo> getAllTrustAgentInfos(XmlPullParser parser, String tag) throws XmlPullParserException, IOException {
            int typeDAM;
            int outerDepthDAM = parser.getDepth();
            ArrayMap<String, TrustAgentInfo> result = new ArrayMap<String, TrustAgentInfo>();
            while ((typeDAM = parser.next()) != 1 && (typeDAM != 3 || parser.getDepth() > outerDepthDAM)) {
                if (typeDAM == 3 || typeDAM == 4) continue;
                String tagDAM = parser.getName();
                if (TAG_TRUST_AGENT_COMPONENT.equals(tagDAM)) {
                    String component = parser.getAttributeValue(null, "value");
                    TrustAgentInfo trustAgentInfo = this.getTrustAgentInfo(parser, tag);
                    result.put(component, trustAgentInfo);
                    continue;
                }
                Slog.w(DevicePolicyManagerService.LOG_TAG, "Unknown tag under " + tag + ": " + tagDAM);
            }
            return result;
        }

        private TrustAgentInfo getTrustAgentInfo(XmlPullParser parser, String tag) throws XmlPullParserException, IOException {
            int typeDAM;
            int outerDepthDAM = parser.getDepth();
            TrustAgentInfo result = new TrustAgentInfo(null);
            while ((typeDAM = parser.next()) != 1 && (typeDAM != 3 || parser.getDepth() > outerDepthDAM)) {
                if (typeDAM == 3 || typeDAM == 4) continue;
                String tagDAM = parser.getName();
                if (TAG_TRUST_AGENT_COMPONENT_OPTIONS.equals(tagDAM)) {
                    result.options = PersistableBundle.restoreFromXml(parser);
                    continue;
                }
                Slog.w(DevicePolicyManagerService.LOG_TAG, "Unknown tag under " + tag + ": " + tagDAM);
            }
            return result;
        }

        private List<String> getCrossProfileWidgetProviders(XmlPullParser parser, String tag) throws XmlPullParserException, IOException {
            int typeDAM;
            int outerDepthDAM = parser.getDepth();
            ArrayList<String> result = null;
            while ((typeDAM = parser.next()) != 1 && (typeDAM != 3 || parser.getDepth() > outerDepthDAM)) {
                if (typeDAM == 3 || typeDAM == 4) continue;
                String tagDAM = parser.getName();
                if (TAG_PROVIDER.equals(tagDAM)) {
                    String provider = parser.getAttributeValue(null, "value");
                    if (result == null) {
                        result = new ArrayList<String>();
                    }
                    result.add(provider);
                    continue;
                }
                Slog.w(DevicePolicyManagerService.LOG_TAG, "Unknown tag under " + tag + ": " + tagDAM);
            }
            return result;
        }

        boolean hasUserRestrictions() {
            return this.userRestrictions != null && this.userRestrictions.size() > 0;
        }

        Bundle ensureUserRestrictions() {
            if (this.userRestrictions == null) {
                this.userRestrictions = new Bundle();
            }
            return this.userRestrictions;
        }

        void dump(String prefix, PrintWriter pw) {
            pw.print(prefix);
            pw.print("uid=");
            pw.println(this.getUid());
            pw.print(prefix);
            pw.println("policies:");
            ArrayList<DeviceAdminInfo.PolicyInfo> pols = this.info.getUsedPolicies();
            if (pols != null) {
                for (int i = 0; i < pols.size(); ++i) {
                    pw.print(prefix);
                    pw.print("  ");
                    pw.println(pols.get((int)i).tag);
                }
            }
            pw.print(prefix);
            pw.print("passwordQuality=0x");
            pw.println(Integer.toHexString(this.passwordQuality));
            pw.print(prefix);
            pw.print("minimumPasswordLength=");
            pw.println(this.minimumPasswordLength);
            pw.print(prefix);
            pw.print("passwordHistoryLength=");
            pw.println(this.passwordHistoryLength);
            pw.print(prefix);
            pw.print("minimumPasswordUpperCase=");
            pw.println(this.minimumPasswordUpperCase);
            pw.print(prefix);
            pw.print("minimumPasswordLowerCase=");
            pw.println(this.minimumPasswordLowerCase);
            pw.print(prefix);
            pw.print("minimumPasswordLetters=");
            pw.println(this.minimumPasswordLetters);
            pw.print(prefix);
            pw.print("minimumPasswordNumeric=");
            pw.println(this.minimumPasswordNumeric);
            pw.print(prefix);
            pw.print("minimumPasswordSymbols=");
            pw.println(this.minimumPasswordSymbols);
            pw.print(prefix);
            pw.print("minimumPasswordNonLetter=");
            pw.println(this.minimumPasswordNonLetter);
            pw.print(prefix);
            pw.print("maximumTimeToUnlock=");
            pw.println(this.maximumTimeToUnlock);
            pw.print(prefix);
            pw.print("maximumFailedPasswordsForWipe=");
            pw.println(this.maximumFailedPasswordsForWipe);
            pw.print(prefix);
            pw.print("specifiesGlobalProxy=");
            pw.println(this.specifiesGlobalProxy);
            pw.print(prefix);
            pw.print("passwordExpirationTimeout=");
            pw.println(this.passwordExpirationTimeout);
            pw.print(prefix);
            pw.print("passwordExpirationDate=");
            pw.println(this.passwordExpirationDate);
            if (this.globalProxySpec != null) {
                pw.print(prefix);
                pw.print("globalProxySpec=");
                pw.println(this.globalProxySpec);
            }
            if (this.globalProxyExclusionList != null) {
                pw.print(prefix);
                pw.print("globalProxyEclusionList=");
                pw.println(this.globalProxyExclusionList);
            }
            pw.print(prefix);
            pw.print("encryptionRequested=");
            pw.println(this.encryptionRequested);
            pw.print(prefix);
            pw.print("disableCamera=");
            pw.println(this.disableCamera);
            pw.print(prefix);
            pw.print("disableCallerId=");
            pw.println(this.disableCallerId);
            pw.print(prefix);
            pw.print("disableContactsSearch=");
            pw.println(this.disableContactsSearch);
            pw.print(prefix);
            pw.print("disableBluetoothContactSharing=");
            pw.println(this.disableBluetoothContactSharing);
            pw.print(prefix);
            pw.print("disableScreenCapture=");
            pw.println(this.disableScreenCapture);
            pw.print(prefix);
            pw.print("requireAutoTime=");
            pw.println(this.requireAutoTime);
            pw.print(prefix);
            pw.print("forceEphemeralUsers=");
            pw.println(this.forceEphemeralUsers);
            pw.print(prefix);
            pw.print("disabledKeyguardFeatures=");
            pw.println(this.disabledKeyguardFeatures);
            pw.print(prefix);
            pw.print("crossProfileWidgetProviders=");
            pw.println(this.crossProfileWidgetProviders);
            if (this.permittedAccessiblityServices != null) {
                pw.print(prefix);
                pw.print("permittedAccessibilityServices=");
                pw.println(this.permittedAccessiblityServices);
            }
            if (this.permittedInputMethods != null) {
                pw.print(prefix);
                pw.print("permittedInputMethods=");
                pw.println(this.permittedInputMethods);
            }
            if (this.keepUninstalledPackages != null) {
                pw.print(prefix);
                pw.print("keepUninstalledPackages=");
                pw.println(this.keepUninstalledPackages);
            }
            pw.print(prefix);
            pw.print("organizationColor=");
            pw.println(this.organizationColor);
            if (this.organizationName != null) {
                pw.print(prefix);
                pw.print("organizationName=");
                pw.println(this.organizationName);
            }
            pw.print(prefix);
            pw.println("userRestrictions:");
            UserRestrictionsUtils.dumpRestrictions(pw, prefix + "  ", this.userRestrictions);
            pw.print(prefix);
            pw.print("isParent=");
            pw.println(this.isParent);
            if (this.parentAdmin != null) {
                pw.print(prefix);
                pw.println("parentAdmin:");
                this.parentAdmin.dump(prefix + "  ", pw);
            }
        }

        static class TrustAgentInfo {
            public PersistableBundle options;

            TrustAgentInfo(PersistableBundle bundle) {
                this.options = bundle;
            }
        }
    }

    public static class DevicePolicyData {
        int mActivePasswordQuality = 0;
        int mActivePasswordLength = 0;
        int mActivePasswordUpperCase = 0;
        int mActivePasswordLowerCase = 0;
        int mActivePasswordLetters = 0;
        int mActivePasswordNumeric = 0;
        int mActivePasswordSymbols = 0;
        int mActivePasswordNonLetter = 0;
        int mFailedPasswordAttempts = 0;
        int mUserHandle;
        int mPasswordOwner = -1;
        long mLastMaximumTimeToLock = -1L;
        boolean mUserSetupComplete = false;
        int mUserProvisioningState;
        int mPermissionPolicy;
        final ArrayMap<ComponentName, ActiveAdmin> mAdminMap = new ArrayMap();
        final ArrayList<ActiveAdmin> mAdminList = new ArrayList();
        final ArrayList<ComponentName> mRemovingAdmins = new ArrayList();
        final ArraySet<String> mAcceptedCaCertificates = new ArraySet();
        List<String> mLockTaskPackages = new ArrayList<String>();
        boolean mStatusBarDisabled = false;
        ComponentName mRestrictionsProvider;
        String mDelegatedCertInstallerPackage;
        boolean doNotAskCredentialsOnBoot = false;
        String mApplicationRestrictionsManagingPackage;
        Set<String> mAffiliationIds = new ArraySet<String>();
        boolean mAdminBroadcastPending = false;
        PersistableBundle mInitBundle = null;

        public DevicePolicyData(int userHandle) {
            this.mUserHandle = userHandle;
        }
    }

    public static final class Lifecycle
    extends SystemService {
        private DevicePolicyManagerService mService;

        public Lifecycle(Context context) {
            super(context);
            this.mService = new DevicePolicyManagerService(context);
        }

        @Override
        public void onStart() {
            this.publishBinderService("device_policy", this.mService);
        }

        @Override
        public void onBootPhase(int phase) {
            this.mService.systemReady(phase);
        }

        @Override
        public void onStartUser(int userHandle) {
            this.mService.onStartUser(userHandle);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @IntDef(value={0L, 1L, 2L, 3L, 4L, 7L})
    private static @interface DeviceOwnerPreConditionCode {
    }
}

