/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.connectivity;

import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothPan;
import android.bluetooth.BluetoothProfile;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.Resources;
import android.hardware.usb.UsbManager;
import android.net.ConnectivityManager;
import android.net.INetworkStatsService;
import android.net.InterfaceConfiguration;
import android.net.LinkAddress;
import android.net.LinkProperties;
import android.net.Network;
import android.net.NetworkInfo;
import android.net.NetworkRequest;
import android.net.NetworkState;
import android.net.NetworkUtils;
import android.net.RouteInfo;
import android.net.wifi.WifiManager;
import android.os.Binder;
import android.os.Bundle;
import android.os.INetworkManagementService;
import android.os.Looper;
import android.os.Message;
import android.os.Parcel;
import android.os.ResultReceiver;
import android.os.SystemProperties;
import android.os.UserHandle;
import android.telephony.CarrierConfigManager;
import android.telephony.TelephonyManager;
import android.util.Log;
import android.util.SparseArray;
import com.android.internal.util.IState;
import com.android.internal.util.IndentingPrintWriter;
import com.android.internal.util.MessageUtils;
import com.android.internal.util.State;
import com.android.internal.util.StateMachine;
import com.android.server.IoThread;
import com.android.server.net.BaseNetworkObserver;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

public class Tethering
extends BaseNetworkObserver {
    private final Context mContext;
    private static final String TAG = "Tethering";
    private static final boolean DBG = false;
    private static final boolean VDBG = false;
    private static final Class[] messageClasses = new Class[]{Tethering.class, TetherMasterSM.class, TetherInterfaceSM.class};
    private static final SparseArray<String> sMagicDecoderRing = MessageUtils.findMessageNames(messageClasses);
    private String[] mTetherableUsbRegexs;
    private String[] mTetherableWifiRegexs;
    private String[] mTetherableBluetoothRegexs;
    private Collection<Integer> mUpstreamIfaceTypes;
    private final Object mPublicSync;
    private static final Integer MOBILE_TYPE = new Integer(0);
    private static final Integer HIPRI_TYPE = new Integer(5);
    private static final Integer DUN_TYPE = new Integer(4);
    private int mPreferredUpstreamMobileApn = -1;
    private final INetworkManagementService mNMService;
    private final INetworkStatsService mStatsService;
    private final Looper mLooper;
    private HashMap<String, TetherInterfaceSM> mIfaces;
    private BroadcastReceiver mStateReceiver;
    private static final ComponentName TETHER_SERVICE = ComponentName.unflattenFromString(Resources.getSystem().getString(17039414));
    private static final String USB_NEAR_IFACE_ADDR = "192.168.42.129";
    private static final int USB_PREFIX_LENGTH = 24;
    private String[] mDhcpRange;
    private static final String[] DHCP_DEFAULT_RANGE = new String[]{"192.168.42.2", "192.168.42.254", "192.168.43.2", "192.168.43.254", "192.168.44.2", "192.168.44.254", "192.168.45.2", "192.168.45.254", "192.168.46.2", "192.168.46.254", "192.168.47.2", "192.168.47.254", "192.168.48.2", "192.168.48.254", "192.168.49.2", "192.168.49.254"};
    private String[] mDefaultDnsServers;
    private static final String DNS_DEFAULT_SERVER1 = "8.8.8.8";
    private static final String DNS_DEFAULT_SERVER2 = "8.8.4.4";
    private final StateMachine mTetherMasterSM;
    private final UpstreamNetworkMonitor mUpstreamNetworkMonitor;
    private String mCurrentUpstreamIface;
    private Notification.Builder mTetheredNotificationBuilder;
    private int mLastNotificationId;
    private boolean mRndisEnabled;
    private boolean mUsbTetherRequested;

    public Tethering(Context context, INetworkManagementService nmService, INetworkStatsService statsService) {
        this.mContext = context;
        this.mNMService = nmService;
        this.mStatsService = statsService;
        this.mPublicSync = new Object();
        this.mIfaces = new HashMap();
        this.mLooper = IoThread.get().getLooper();
        this.mTetherMasterSM = new TetherMasterSM("TetherMaster", this.mLooper);
        this.mTetherMasterSM.start();
        this.mUpstreamNetworkMonitor = new UpstreamNetworkMonitor();
        this.mStateReceiver = new StateReceiver();
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.hardware.usb.action.USB_STATE");
        filter.addAction("android.net.conn.CONNECTIVITY_CHANGE");
        filter.addAction("android.intent.action.CONFIGURATION_CHANGED");
        this.mContext.registerReceiver(this.mStateReceiver, filter);
        filter = new IntentFilter();
        filter.addAction("android.intent.action.MEDIA_SHARED");
        filter.addAction("android.intent.action.MEDIA_UNSHARED");
        filter.addDataScheme("file");
        this.mContext.registerReceiver(this.mStateReceiver, filter);
        this.mDhcpRange = context.getResources().getStringArray(17235990);
        if (this.mDhcpRange.length == 0 || this.mDhcpRange.length % 2 == 1) {
            this.mDhcpRange = DHCP_DEFAULT_RANGE;
        }
        this.updateConfiguration();
        this.mDefaultDnsServers = new String[2];
        this.mDefaultDnsServers[0] = DNS_DEFAULT_SERVER1;
        this.mDefaultDnsServers[1] = DNS_DEFAULT_SERVER2;
    }

    private ConnectivityManager getConnectivityManager() {
        return (ConnectivityManager)this.mContext.getSystemService("connectivity");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateConfiguration() {
        String[] tetherableUsbRegexs = this.mContext.getResources().getStringArray(17235986);
        String[] tetherableWifiRegexs = this.mContext.getResources().getStringArray(17235987);
        String[] tetherableBluetoothRegexs = this.mContext.getResources().getStringArray(17235989);
        int[] ifaceTypes = this.mContext.getResources().getIntArray(17235992);
        ArrayList<Integer> upstreamIfaceTypes = new ArrayList<Integer>();
        for (int i : ifaceTypes) {
            upstreamIfaceTypes.add(new Integer(i));
        }
        Object object = this.mPublicSync;
        synchronized (object) {
            this.mTetherableUsbRegexs = tetherableUsbRegexs;
            this.mTetherableWifiRegexs = tetherableWifiRegexs;
            this.mTetherableBluetoothRegexs = tetherableBluetoothRegexs;
            this.mUpstreamIfaceTypes = upstreamIfaceTypes;
        }
        this.checkDunRequired();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void interfaceStatusChanged(String iface, boolean up) {
        boolean found = false;
        boolean usb = false;
        Object object = this.mPublicSync;
        synchronized (object) {
            if (this.isWifi(iface)) {
                found = true;
            } else if (this.isUsb(iface)) {
                found = true;
                usb = true;
            } else if (this.isBluetooth(iface)) {
                found = true;
            }
            if (!found) {
                return;
            }
            TetherInterfaceSM sm = this.mIfaces.get(iface);
            if (up) {
                if (sm == null) {
                    sm = new TetherInterfaceSM(iface, this.mLooper, usb);
                    this.mIfaces.put(iface, sm);
                    sm.start();
                }
            } else if (!this.isUsb(iface) && sm != null) {
                sm.sendMessage(327784);
                this.mIfaces.remove(iface);
            }
        }
    }

    @Override
    public void interfaceLinkStateChanged(String iface, boolean up) {
        this.interfaceStatusChanged(iface, up);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isUsb(String iface) {
        Object object = this.mPublicSync;
        synchronized (object) {
            for (String regex : this.mTetherableUsbRegexs) {
                if (!iface.matches(regex)) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isWifi(String iface) {
        Object object = this.mPublicSync;
        synchronized (object) {
            for (String regex : this.mTetherableWifiRegexs) {
                if (!iface.matches(regex)) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isBluetooth(String iface) {
        Object object = this.mPublicSync;
        synchronized (object) {
            for (String regex : this.mTetherableBluetoothRegexs) {
                if (!iface.matches(regex)) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void interfaceAdded(String iface) {
        boolean found = false;
        boolean usb = false;
        Object object = this.mPublicSync;
        synchronized (object) {
            if (this.isWifi(iface)) {
                found = true;
            }
            if (this.isUsb(iface)) {
                found = true;
                usb = true;
            }
            if (this.isBluetooth(iface)) {
                found = true;
            }
            if (!found) {
                return;
            }
            TetherInterfaceSM sm = this.mIfaces.get(iface);
            if (sm != null) {
                return;
            }
            sm = new TetherInterfaceSM(iface, this.mLooper, usb);
            this.mIfaces.put(iface, sm);
            sm.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void interfaceRemoved(String iface) {
        Object object = this.mPublicSync;
        synchronized (object) {
            TetherInterfaceSM sm = this.mIfaces.get(iface);
            if (sm == null) {
                return;
            }
            sm.sendMessage(327784);
            this.mIfaces.remove(iface);
        }
    }

    public void startTethering(int type, ResultReceiver receiver, boolean showProvisioningUi) {
        if (!this.isTetherProvisioningRequired()) {
            this.enableTetheringInternal(type, true, receiver);
            return;
        }
        if (showProvisioningUi) {
            this.runUiTetherProvisioningAndEnable(type, receiver);
        } else {
            this.runSilentTetherProvisioningAndEnable(type, receiver);
        }
    }

    public void stopTethering(int type) {
        this.enableTetheringInternal(type, false, null);
        if (this.isTetherProvisioningRequired()) {
            this.cancelTetherProvisioningRechecks(type);
        }
    }

    private boolean isTetherProvisioningRequired() {
        String[] provisionApp = this.mContext.getResources().getStringArray(0x1070017);
        if (SystemProperties.getBoolean("net.tethering.noprovisioning", false) || provisionApp == null) {
            return false;
        }
        CarrierConfigManager configManager = (CarrierConfigManager)this.mContext.getSystemService("carrier_config");
        boolean isEntitlementCheckRequired = configManager.getConfig().getBoolean("require_entitlement_checks_bool");
        if (!isEntitlementCheckRequired) {
            return false;
        }
        return provisionApp.length == 2;
    }

    private void enableTetheringInternal(int type, boolean enable, ResultReceiver receiver) {
        boolean isProvisioningRequired = this.isTetherProvisioningRequired();
        switch (type) {
            case 0: {
                WifiManager wifiManager = (WifiManager)this.mContext.getSystemService("wifi");
                if (wifiManager.setWifiApEnabled(null, enable)) {
                    this.sendTetherResult(receiver, 0);
                    if (!enable || !isProvisioningRequired) break;
                    this.scheduleProvisioningRechecks(type);
                    break;
                }
                this.sendTetherResult(receiver, 5);
                break;
            }
            case 1: {
                int result = this.setUsbTethering(enable);
                if (enable && isProvisioningRequired && result == 0) {
                    this.scheduleProvisioningRechecks(type);
                }
                this.sendTetherResult(receiver, result);
                break;
            }
            case 2: {
                this.setBluetoothTethering(enable, receiver);
                break;
            }
            default: {
                Log.w(TAG, "Invalid tether type.");
                this.sendTetherResult(receiver, 1);
            }
        }
    }

    private void sendTetherResult(ResultReceiver receiver, int result) {
        if (receiver != null) {
            receiver.send(result, null);
        }
    }

    private void setBluetoothTethering(final boolean enable, final ResultReceiver receiver) {
        final BluetoothAdapter adapter = BluetoothAdapter.getDefaultAdapter();
        if (adapter == null || !adapter.isEnabled()) {
            Log.w(TAG, "Tried to enable bluetooth tethering with null or disabled adapter. null: " + (adapter == null));
            this.sendTetherResult(receiver, 2);
            return;
        }
        adapter.getProfileProxy(this.mContext, new BluetoothProfile.ServiceListener(){

            @Override
            public void onServiceDisconnected(int profile) {
            }

            @Override
            public void onServiceConnected(int profile, BluetoothProfile proxy) {
                ((BluetoothPan)proxy).setBluetoothTethering(enable);
                int result = ((BluetoothPan)proxy).isTetheringOn() == enable ? 0 : 5;
                Tethering.this.sendTetherResult(receiver, result);
                if (enable && Tethering.this.isTetherProvisioningRequired()) {
                    Tethering.this.scheduleProvisioningRechecks(2);
                }
                adapter.closeProfileProxy(5, proxy);
            }
        }, 5);
    }

    private void runUiTetherProvisioningAndEnable(int type, ResultReceiver receiver) {
        ResultReceiver proxyReceiver = this.getProxyReceiver(type, receiver);
        this.sendUiTetherProvisionIntent(type, proxyReceiver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendUiTetherProvisionIntent(int type, ResultReceiver receiver) {
        Intent intent = new Intent("android.settings.TETHER_PROVISIONING_UI");
        intent.putExtra("extraAddTetherType", type);
        intent.putExtra("extraProvisionCallback", receiver);
        long ident = Binder.clearCallingIdentity();
        try {
            this.mContext.startActivityAsUser(intent, UserHandle.CURRENT);
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    private ResultReceiver getProxyReceiver(final int type, final ResultReceiver receiver) {
        ResultReceiver rr = new ResultReceiver(null){

            @Override
            protected void onReceiveResult(int resultCode, Bundle resultData) {
                if (resultCode == 0) {
                    Tethering.this.enableTetheringInternal(type, true, receiver);
                } else {
                    Tethering.this.sendTetherResult(receiver, resultCode);
                }
            }
        };
        Parcel parcel = Parcel.obtain();
        rr.writeToParcel(parcel, 0);
        parcel.setDataPosition(0);
        ResultReceiver receiverForSending = ResultReceiver.CREATOR.createFromParcel(parcel);
        parcel.recycle();
        return receiverForSending;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleProvisioningRechecks(int type) {
        Intent intent = new Intent();
        intent.putExtra("extraAddTetherType", type);
        intent.putExtra("extraSetAlarm", true);
        intent.setComponent(TETHER_SERVICE);
        long ident = Binder.clearCallingIdentity();
        try {
            this.mContext.startServiceAsUser(intent, UserHandle.CURRENT);
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    private void runSilentTetherProvisioningAndEnable(int type, ResultReceiver receiver) {
        ResultReceiver proxyReceiver = this.getProxyReceiver(type, receiver);
        this.sendSilentTetherProvisionIntent(type, proxyReceiver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendSilentTetherProvisionIntent(int type, ResultReceiver receiver) {
        Intent intent = new Intent();
        intent.putExtra("extraAddTetherType", type);
        intent.putExtra("extraRunProvision", true);
        intent.putExtra("extraProvisionCallback", receiver);
        intent.setComponent(TETHER_SERVICE);
        long ident = Binder.clearCallingIdentity();
        try {
            this.mContext.startServiceAsUser(intent, UserHandle.CURRENT);
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelTetherProvisioningRechecks(int type) {
        if (this.getConnectivityManager().isTetheringSupported()) {
            Intent intent = new Intent();
            intent.putExtra("extraRemTetherType", type);
            intent.setComponent(TETHER_SERVICE);
            long ident = Binder.clearCallingIdentity();
            try {
                this.mContext.startServiceAsUser(intent, UserHandle.CURRENT);
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int tether(String iface) {
        TetherInterfaceSM sm = null;
        Object object = this.mPublicSync;
        synchronized (object) {
            sm = this.mIfaces.get(iface);
        }
        if (sm == null) {
            Log.e(TAG, "Tried to Tether an unknown iface :" + iface + ", ignoring");
            return 1;
        }
        if (!sm.isAvailable() && !sm.isErrored()) {
            Log.e(TAG, "Tried to Tether an unavailable iface :" + iface + ", ignoring");
            return 4;
        }
        sm.sendMessage(327782);
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int untether(String iface) {
        TetherInterfaceSM sm = null;
        Object object = this.mPublicSync;
        synchronized (object) {
            sm = this.mIfaces.get(iface);
        }
        if (sm == null) {
            Log.e(TAG, "Tried to Untether an unknown iface :" + iface + ", ignoring");
            return 1;
        }
        if (sm.isErrored()) {
            Log.e(TAG, "Tried to Untethered an errored iface :" + iface + ", ignoring");
            return 4;
        }
        sm.sendMessage(327783);
        return 0;
    }

    public void untetherAll() {
        for (String iface : this.mIfaces.keySet()) {
            this.untether(iface);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLastTetherError(String iface) {
        TetherInterfaceSM sm = null;
        Object object = this.mPublicSync;
        synchronized (object) {
            sm = this.mIfaces.get(iface);
            if (sm == null) {
                Log.e(TAG, "Tried to getLastTetherError on an unknown iface :" + iface + ", ignoring");
                return 1;
            }
            return sm.getLastError();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendTetherStateChangedBroadcast() {
        if (!this.getConnectivityManager().isTetheringSupported()) {
            return;
        }
        ArrayList<String> availableList = new ArrayList<String>();
        ArrayList<String> activeList = new ArrayList<String>();
        ArrayList<String> erroredList = new ArrayList<String>();
        boolean wifiTethered = false;
        boolean usbTethered = false;
        boolean bluetoothTethered = false;
        Object object = this.mPublicSync;
        synchronized (object) {
            Set<String> ifaces = this.mIfaces.keySet();
            for (String iface : ifaces) {
                TetherInterfaceSM sm = this.mIfaces.get(iface);
                if (sm == null) continue;
                if (sm.isErrored()) {
                    erroredList.add(iface);
                    continue;
                }
                if (sm.isAvailable()) {
                    availableList.add(iface);
                    continue;
                }
                if (!sm.isTethered()) continue;
                if (this.isUsb(iface)) {
                    usbTethered = true;
                } else if (this.isWifi(iface)) {
                    wifiTethered = true;
                } else if (this.isBluetooth(iface)) {
                    bluetoothTethered = true;
                }
                activeList.add(iface);
            }
        }
        Intent broadcast = new Intent("android.net.conn.TETHER_STATE_CHANGED");
        broadcast.addFlags(0x24000000);
        broadcast.putStringArrayListExtra("availableArray", availableList);
        broadcast.putStringArrayListExtra("activeArray", activeList);
        broadcast.putStringArrayListExtra("erroredArray", erroredList);
        this.mContext.sendStickyBroadcastAsUser(broadcast, UserHandle.ALL);
        if (usbTethered) {
            if (wifiTethered || bluetoothTethered) {
                this.showTetheredNotification(17303293);
            } else {
                this.showTetheredNotification(17303294);
            }
        } else if (wifiTethered) {
            if (bluetoothTethered) {
                this.showTetheredNotification(17303293);
            } else {
                this.clearTetheredNotification();
            }
        } else if (bluetoothTethered) {
            this.showTetheredNotification(17303292);
        } else {
            this.clearTetheredNotification();
        }
    }

    private void showTetheredNotification(int icon) {
        NotificationManager notificationManager = (NotificationManager)this.mContext.getSystemService("notification");
        if (notificationManager == null) {
            return;
        }
        if (this.mLastNotificationId != 0) {
            if (this.mLastNotificationId == icon) {
                return;
            }
            notificationManager.cancelAsUser(null, this.mLastNotificationId, UserHandle.ALL);
            this.mLastNotificationId = 0;
        }
        Intent intent = new Intent();
        intent.setClassName("com.android.settings", "com.android.settings.TetherSettings");
        intent.setFlags(0x40000000);
        PendingIntent pi = PendingIntent.getActivityAsUser(this.mContext, 0, intent, 0, null, UserHandle.CURRENT);
        Resources r = Resources.getSystem();
        CharSequence title = r.getText(17040506);
        CharSequence message = r.getText(17040507);
        if (this.mTetheredNotificationBuilder == null) {
            this.mTetheredNotificationBuilder = new Notification.Builder(this.mContext);
            this.mTetheredNotificationBuilder.setWhen(0L).setOngoing(true).setColor(this.mContext.getColor(17170521)).setVisibility(1).setCategory("status");
        }
        this.mTetheredNotificationBuilder.setSmallIcon(icon).setContentTitle(title).setContentText(message).setContentIntent(pi);
        this.mLastNotificationId = icon;
        notificationManager.notifyAsUser(null, this.mLastNotificationId, this.mTetheredNotificationBuilder.build(), UserHandle.ALL);
    }

    private void clearTetheredNotification() {
        NotificationManager notificationManager = (NotificationManager)this.mContext.getSystemService("notification");
        if (notificationManager != null && this.mLastNotificationId != 0) {
            notificationManager.cancelAsUser(null, this.mLastNotificationId, UserHandle.ALL);
            this.mLastNotificationId = 0;
        }
    }

    private void tetherUsb(boolean enable) {
        String[] ifaces = new String[]{};
        try {
            ifaces = this.mNMService.listInterfaces();
        }
        catch (Exception e) {
            Log.e(TAG, "Error listing Interfaces", e);
            return;
        }
        for (String iface : ifaces) {
            int result;
            if (!this.isUsb(iface)) continue;
            int n = result = enable ? this.tether(iface) : this.untether(iface);
            if (result != 0) continue;
            return;
        }
        Log.e(TAG, "unable start or stop USB tethering");
    }

    private boolean configureUsbIface(boolean enabled) {
        String[] ifaces = new String[]{};
        try {
            ifaces = this.mNMService.listInterfaces();
        }
        catch (Exception e) {
            Log.e(TAG, "Error listing Interfaces", e);
            return false;
        }
        for (String iface : ifaces) {
            if (!this.isUsb(iface)) continue;
            InterfaceConfiguration ifcg = null;
            try {
                ifcg = this.mNMService.getInterfaceConfig(iface);
                if (ifcg == null) continue;
                InetAddress addr = NetworkUtils.numericToInetAddress(USB_NEAR_IFACE_ADDR);
                ifcg.setLinkAddress(new LinkAddress(addr, 24));
                if (enabled) {
                    ifcg.setInterfaceUp();
                } else {
                    ifcg.setInterfaceDown();
                }
                ifcg.clearFlag("running");
                this.mNMService.setInterfaceConfig(iface, ifcg);
            }
            catch (Exception e) {
                Log.e(TAG, "Error configuring interface " + iface, e);
                return false;
            }
        }
        return true;
    }

    public String[] getTetherableUsbRegexs() {
        return this.mTetherableUsbRegexs;
    }

    public String[] getTetherableWifiRegexs() {
        return this.mTetherableWifiRegexs;
    }

    public String[] getTetherableBluetoothRegexs() {
        return this.mTetherableBluetoothRegexs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setUsbTethering(boolean enable) {
        UsbManager usbManager = (UsbManager)this.mContext.getSystemService("usb");
        Object object = this.mPublicSync;
        synchronized (object) {
            if (enable) {
                if (this.mRndisEnabled) {
                    long ident = Binder.clearCallingIdentity();
                    try {
                        this.tetherUsb(true);
                    }
                    finally {
                        Binder.restoreCallingIdentity(ident);
                    }
                } else {
                    this.mUsbTetherRequested = true;
                    usbManager.setCurrentFunction("rndis");
                }
            } else {
                long ident = Binder.clearCallingIdentity();
                try {
                    this.tetherUsb(false);
                }
                finally {
                    Binder.restoreCallingIdentity(ident);
                }
                if (this.mRndisEnabled) {
                    usbManager.setCurrentFunction(null);
                }
                this.mUsbTetherRequested = false;
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getUpstreamIfaceTypes() {
        int[] values;
        Object object = this.mPublicSync;
        synchronized (object) {
            this.updateConfiguration();
            values = new int[this.mUpstreamIfaceTypes.size()];
            Iterator<Integer> iterator = this.mUpstreamIfaceTypes.iterator();
            for (int i = 0; i < this.mUpstreamIfaceTypes.size(); ++i) {
                values[i] = iterator.next();
            }
        }
        return values;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkDunRequired() {
        int secureSetting = 2;
        TelephonyManager tm = (TelephonyManager)this.mContext.getSystemService("phone");
        if (tm != null) {
            secureSetting = tm.getTetherApnRequired();
        }
        Object object = this.mPublicSync;
        synchronized (object) {
            if (secureSetting != 2) {
                int requiredApn;
                int n = requiredApn = secureSetting == 1 ? 4 : 5;
                if (requiredApn == 4) {
                    while (this.mUpstreamIfaceTypes.contains(MOBILE_TYPE)) {
                        this.mUpstreamIfaceTypes.remove(MOBILE_TYPE);
                    }
                    while (this.mUpstreamIfaceTypes.contains(HIPRI_TYPE)) {
                        this.mUpstreamIfaceTypes.remove(HIPRI_TYPE);
                    }
                    if (!this.mUpstreamIfaceTypes.contains(DUN_TYPE)) {
                        this.mUpstreamIfaceTypes.add(DUN_TYPE);
                    }
                } else {
                    while (this.mUpstreamIfaceTypes.contains(DUN_TYPE)) {
                        this.mUpstreamIfaceTypes.remove(DUN_TYPE);
                    }
                    if (!this.mUpstreamIfaceTypes.contains(MOBILE_TYPE)) {
                        this.mUpstreamIfaceTypes.add(MOBILE_TYPE);
                    }
                    if (!this.mUpstreamIfaceTypes.contains(HIPRI_TYPE)) {
                        this.mUpstreamIfaceTypes.add(HIPRI_TYPE);
                    }
                }
            }
            this.mPreferredUpstreamMobileApn = this.mUpstreamIfaceTypes.contains(DUN_TYPE) ? 4 : 5;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getTetheredIfaces() {
        ArrayList<String> list = new ArrayList<String>();
        Object object = this.mPublicSync;
        synchronized (object) {
            Set<String> keys = this.mIfaces.keySet();
            for (String key : keys) {
                TetherInterfaceSM sm = this.mIfaces.get(key);
                if (!sm.isTethered()) continue;
                list.add(key);
            }
        }
        String[] retVal = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            retVal[i] = (String)list.get(i);
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getTetherableIfaces() {
        ArrayList<String> list = new ArrayList<String>();
        Object object = this.mPublicSync;
        synchronized (object) {
            Set<String> keys = this.mIfaces.keySet();
            for (String key : keys) {
                TetherInterfaceSM sm = this.mIfaces.get(key);
                if (!sm.isAvailable()) continue;
                list.add(key);
            }
        }
        String[] retVal = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            retVal[i] = (String)list.get(i);
        }
        return retVal;
    }

    public String[] getTetheredDhcpRanges() {
        return this.mDhcpRange;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getErroredIfaces() {
        ArrayList<String> list = new ArrayList<String>();
        Object object = this.mPublicSync;
        synchronized (object) {
            Set<String> keys = this.mIfaces.keySet();
            for (String key : keys) {
                TetherInterfaceSM sm = this.mIfaces.get(key);
                if (!sm.isErrored()) continue;
                list.add(key);
            }
        }
        String[] retVal = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            retVal[i] = (String)list.get(i);
        }
        return retVal;
    }

    private void maybeLogMessage(State state, int what) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dump(FileDescriptor fd, PrintWriter writer, String[] args) {
        IndentingPrintWriter pw = new IndentingPrintWriter((Writer)writer, "  ");
        if (this.mContext.checkCallingOrSelfPermission("android.permission.DUMP") != 0) {
            pw.println("Permission Denial: can't dump ConnectivityService.Tether from from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid());
            return;
        }
        pw.println("Tethering:");
        pw.increaseIndent();
        pw.print("mUpstreamIfaceTypes:");
        Object object = this.mPublicSync;
        synchronized (object) {
            for (Integer n : this.mUpstreamIfaceTypes) {
                pw.print(" " + ConnectivityManager.getNetworkTypeName(n));
            }
            pw.println();
            pw.println("Tether state:");
            pw.increaseIndent();
            for (Object object2 : this.mIfaces.values()) {
                pw.println(object2);
            }
            pw.decreaseIndent();
        }
        pw.decreaseIndent();
    }

    class TetherMasterSM
    extends StateMachine {
        private static final int BASE_MASTER = 327680;
        static final int CMD_TETHER_MODE_REQUESTED = 327681;
        static final int CMD_TETHER_MODE_UNREQUESTED = 327682;
        static final int CMD_UPSTREAM_CHANGED = 327683;
        static final int CMD_RETRY_UPSTREAM = 327684;
        static final int EVENT_UPSTREAM_LINKPROPERTIES_CHANGED = 327685;
        static final int EVENT_UPSTREAM_LOST = 327686;
        private int mSequenceNumber;
        private State mInitialState;
        private State mTetherModeAliveState;
        private State mSetIpForwardingEnabledErrorState;
        private State mSetIpForwardingDisabledErrorState;
        private State mStartTetheringErrorState;
        private State mStopTetheringErrorState;
        private State mSetDnsForwardersErrorState;
        private ArrayList<TetherInterfaceSM> mNotifyList;
        private int mMobileApnReserved;
        private ConnectivityManager.NetworkCallback mMobileUpstreamCallback;
        private static final int UPSTREAM_SETTLE_TIME_MS = 10000;
        private final AtomicInteger mSimBcastGenerationNumber;
        private SimChangeBroadcastReceiver mBroadcastReceiver;

        TetherMasterSM(String name, Looper looper) {
            super(name, looper);
            this.mMobileApnReserved = -1;
            this.mSimBcastGenerationNumber = new AtomicInteger(0);
            this.mBroadcastReceiver = null;
            this.mInitialState = new InitialState();
            this.addState(this.mInitialState);
            this.mTetherModeAliveState = new TetherModeAliveState();
            this.addState(this.mTetherModeAliveState);
            this.mSetIpForwardingEnabledErrorState = new SetIpForwardingEnabledErrorState();
            this.addState(this.mSetIpForwardingEnabledErrorState);
            this.mSetIpForwardingDisabledErrorState = new SetIpForwardingDisabledErrorState();
            this.addState(this.mSetIpForwardingDisabledErrorState);
            this.mStartTetheringErrorState = new StartTetheringErrorState();
            this.addState(this.mStartTetheringErrorState);
            this.mStopTetheringErrorState = new StopTetheringErrorState();
            this.addState(this.mStopTetheringErrorState);
            this.mSetDnsForwardersErrorState = new SetDnsForwardersErrorState();
            this.addState(this.mSetDnsForwardersErrorState);
            this.mNotifyList = new ArrayList();
            this.setInitialState(this.mInitialState);
        }

        private void startListeningForSimChanges() {
            if (this.mBroadcastReceiver == null) {
                this.mBroadcastReceiver = new SimChangeBroadcastReceiver(this.mSimBcastGenerationNumber.incrementAndGet());
                IntentFilter filter = new IntentFilter();
                filter.addAction("android.intent.action.SIM_STATE_CHANGED");
                Tethering.this.mContext.registerReceiver(this.mBroadcastReceiver, filter);
            }
        }

        private void stopListeningForSimChanges() {
            if (this.mBroadcastReceiver != null) {
                this.mSimBcastGenerationNumber.incrementAndGet();
                Tethering.this.mContext.unregisterReceiver(this.mBroadcastReceiver);
                this.mBroadcastReceiver = null;
            }
        }

        class SetDnsForwardersErrorState
        extends ErrorState {
            SetDnsForwardersErrorState() {
            }

            @Override
            public void enter() {
                Log.e(Tethering.TAG, "Error in setDnsForwarders");
                this.notify(327791);
                try {
                    Tethering.this.mNMService.stopTethering();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    Tethering.this.mNMService.setIpForwardingEnabled(false);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        class StopTetheringErrorState
        extends ErrorState {
            StopTetheringErrorState() {
            }

            @Override
            public void enter() {
                Log.e(Tethering.TAG, "Error in stopTethering");
                this.notify(327790);
                try {
                    Tethering.this.mNMService.setIpForwardingEnabled(false);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        class StartTetheringErrorState
        extends ErrorState {
            StartTetheringErrorState() {
            }

            @Override
            public void enter() {
                Log.e(Tethering.TAG, "Error in startTethering");
                this.notify(327789);
                try {
                    Tethering.this.mNMService.setIpForwardingEnabled(false);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        class SetIpForwardingDisabledErrorState
        extends ErrorState {
            SetIpForwardingDisabledErrorState() {
            }

            @Override
            public void enter() {
                Log.e(Tethering.TAG, "Error in setIpForwardingDisabled");
                this.notify(327788);
            }
        }

        class SetIpForwardingEnabledErrorState
        extends ErrorState {
            SetIpForwardingEnabledErrorState() {
            }

            @Override
            public void enter() {
                Log.e(Tethering.TAG, "Error in setIpForwardingEnabled");
                this.notify(327787);
            }
        }

        class ErrorState
        extends State {
            int mErrorNotification;

            ErrorState() {
            }

            @Override
            public boolean processMessage(Message message) {
                boolean retValue = true;
                switch (message.what) {
                    case 327681: {
                        TetherInterfaceSM who = (TetherInterfaceSM)message.obj;
                        who.sendMessage(this.mErrorNotification);
                        break;
                    }
                    default: {
                        retValue = false;
                    }
                }
                return retValue;
            }

            void notify(int msgType) {
                this.mErrorNotification = msgType;
                for (Object o : TetherMasterSM.this.mNotifyList) {
                    TetherInterfaceSM sm = (TetherInterfaceSM)o;
                    sm.sendMessage(msgType);
                }
            }
        }

        class TetherModeAliveState
        extends TetherMasterUtilState {
            boolean mTryCell;

            TetherModeAliveState() {
                this.mTryCell = true;
            }

            @Override
            public void enter() {
                this.turnOnMasterTetherSettings();
                TetherMasterSM.this.startListeningForSimChanges();
                Tethering.this.mUpstreamNetworkMonitor.start();
                this.mTryCell = true;
                this.chooseUpstreamType(this.mTryCell);
                this.mTryCell = !this.mTryCell;
            }

            @Override
            public void exit() {
                this.turnOffUpstreamMobileConnection();
                Tethering.this.mUpstreamNetworkMonitor.stop();
                TetherMasterSM.this.stopListeningForSimChanges();
                this.notifyTetheredOfNewUpstreamIface(null);
            }

            @Override
            public boolean processMessage(Message message) {
                Tethering.this.maybeLogMessage(this, message.what);
                boolean retValue = true;
                switch (message.what) {
                    case 327681: {
                        TetherInterfaceSM who = (TetherInterfaceSM)message.obj;
                        TetherMasterSM.this.mNotifyList.add(who);
                        who.sendMessage(327792, Tethering.this.mCurrentUpstreamIface);
                        break;
                    }
                    case 327682: {
                        TetherInterfaceSM who = (TetherInterfaceSM)message.obj;
                        int index = TetherMasterSM.this.mNotifyList.indexOf(who);
                        if (index != -1) {
                            TetherMasterSM.this.mNotifyList.remove(index);
                            if (!TetherMasterSM.this.mNotifyList.isEmpty()) break;
                            this.turnOffMasterTetherSettings();
                            break;
                        }
                        Log.e(Tethering.TAG, "TetherModeAliveState UNREQUESTED has unknown who: " + who);
                        break;
                    }
                    case 327683: {
                        this.mTryCell = true;
                        this.chooseUpstreamType(this.mTryCell);
                        this.mTryCell = !this.mTryCell;
                        break;
                    }
                    case 327684: {
                        this.chooseUpstreamType(this.mTryCell);
                        this.mTryCell = !this.mTryCell;
                        break;
                    }
                    case 327685: {
                        NetworkState state = (NetworkState)message.obj;
                        if (Tethering.this.mUpstreamNetworkMonitor.processLinkPropertiesChanged(state)) {
                            this.setDnsForwarders(state.network, state.linkProperties);
                            break;
                        }
                        if (Tethering.this.mCurrentUpstreamIface != null) break;
                        this.chooseUpstreamType(false);
                        break;
                    }
                    case 327686: {
                        Tethering.this.mUpstreamNetworkMonitor.processNetworkLost((Network)message.obj);
                        break;
                    }
                    default: {
                        retValue = false;
                    }
                }
                return retValue;
            }
        }

        class InitialState
        extends TetherMasterUtilState {
            InitialState() {
            }

            @Override
            public void enter() {
            }

            @Override
            public boolean processMessage(Message message) {
                Tethering.this.maybeLogMessage(this, message.what);
                boolean retValue = true;
                switch (message.what) {
                    case 327681: {
                        TetherInterfaceSM who = (TetherInterfaceSM)message.obj;
                        TetherMasterSM.this.mNotifyList.add(who);
                        TetherMasterSM.this.transitionTo(TetherMasterSM.this.mTetherModeAliveState);
                        break;
                    }
                    case 327682: {
                        TetherInterfaceSM who = (TetherInterfaceSM)message.obj;
                        int index = TetherMasterSM.this.mNotifyList.indexOf(who);
                        if (index == -1) break;
                        TetherMasterSM.this.mNotifyList.remove(who);
                        break;
                    }
                    default: {
                        retValue = false;
                    }
                }
                return retValue;
            }
        }

        class SimChangeBroadcastReceiver
        extends BroadcastReceiver {
            private final int mGenerationNumber;
            private boolean mSimAbsentSeen = false;

            public SimChangeBroadcastReceiver(int generationNumber) {
                this.mGenerationNumber = generationNumber;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onReceive(Context context, Intent intent) {
                block13: {
                    if (this.mGenerationNumber != TetherMasterSM.this.mSimBcastGenerationNumber.get()) {
                        return;
                    }
                    String state = intent.getStringExtra("ss");
                    Log.d(Tethering.TAG, "got Sim changed to state " + state + ", mSimAbsentSeen=" + this.mSimAbsentSeen);
                    if (!this.mSimAbsentSeen && "ABSENT".equals(state)) {
                        this.mSimAbsentSeen = true;
                    }
                    if (this.mSimAbsentSeen && "LOADED".equals(state)) {
                        this.mSimAbsentSeen = false;
                        try {
                            if (!Tethering.this.mContext.getResources().getString(17039412).isEmpty()) {
                                ArrayList<Integer> tethered = new ArrayList<Integer>();
                                Iterator iterator = Tethering.this.mPublicSync;
                                synchronized (iterator) {
                                    Set ifaces = Tethering.this.mIfaces.keySet();
                                    for (Object iface : ifaces) {
                                        TetherInterfaceSM sm = (TetherInterfaceSM)Tethering.this.mIfaces.get(iface);
                                        if (sm == null || !sm.isTethered()) continue;
                                        if (Tethering.this.isUsb((String)iface)) {
                                            tethered.add(new Integer(1));
                                            continue;
                                        }
                                        if (Tethering.this.isWifi((String)iface)) {
                                            tethered.add(new Integer(0));
                                            continue;
                                        }
                                        if (!Tethering.this.isBluetooth((String)iface)) continue;
                                        tethered.add(new Integer(2));
                                    }
                                }
                                iterator = tethered.iterator();
                                while (iterator.hasNext()) {
                                    int tetherType = (Integer)iterator.next();
                                    Intent startProvIntent = new Intent();
                                    startProvIntent.putExtra("extraAddTetherType", tetherType);
                                    startProvIntent.putExtra("extraRunProvision", true);
                                    startProvIntent.setComponent(TETHER_SERVICE);
                                    Tethering.this.mContext.startServiceAsUser(startProvIntent, UserHandle.CURRENT);
                                }
                                Log.d(Tethering.TAG, "re-evaluate provisioning");
                                break block13;
                            }
                            Log.d(Tethering.TAG, "no prov-check needed for new SIM");
                        }
                        catch (Resources.NotFoundException e) {
                            Log.d(Tethering.TAG, "no prov-check needed for new SIM");
                        }
                    }
                }
            }
        }

        class TetherMasterUtilState
        extends State {
            TetherMasterUtilState() {
            }

            @Override
            public boolean processMessage(Message m) {
                return false;
            }

            protected boolean turnOnUpstreamMobileConnection(int apnType) {
                if (apnType == -1) {
                    return false;
                }
                if (apnType != TetherMasterSM.this.mMobileApnReserved) {
                    this.turnOffUpstreamMobileConnection();
                }
                if (TetherMasterSM.this.mMobileUpstreamCallback != null) {
                    return true;
                }
                switch (apnType) {
                    case 0: 
                    case 4: 
                    case 5: {
                        TetherMasterSM.this.mMobileApnReserved = apnType;
                        break;
                    }
                    default: {
                        return false;
                    }
                }
                NetworkRequest.Builder builder = new NetworkRequest.Builder().addTransportType(0);
                if (apnType == 4) {
                    builder.removeCapability(13).addCapability(2);
                } else {
                    builder.addCapability(12);
                }
                NetworkRequest mobileUpstreamRequest = builder.build();
                TetherMasterSM.this.mMobileUpstreamCallback = new ConnectivityManager.NetworkCallback();
                Tethering.this.getConnectivityManager().requestNetwork(mobileUpstreamRequest, TetherMasterSM.this.mMobileUpstreamCallback, 0, apnType);
                return true;
            }

            protected void turnOffUpstreamMobileConnection() {
                if (TetherMasterSM.this.mMobileUpstreamCallback != null) {
                    Tethering.this.getConnectivityManager().unregisterNetworkCallback(TetherMasterSM.this.mMobileUpstreamCallback);
                    TetherMasterSM.this.mMobileUpstreamCallback = null;
                }
                TetherMasterSM.this.mMobileApnReserved = -1;
            }

            protected boolean turnOnMasterTetherSettings() {
                try {
                    Tethering.this.mNMService.setIpForwardingEnabled(true);
                }
                catch (Exception e) {
                    TetherMasterSM.this.transitionTo(TetherMasterSM.this.mSetIpForwardingEnabledErrorState);
                    return false;
                }
                try {
                    Tethering.this.mNMService.startTethering(Tethering.this.mDhcpRange);
                }
                catch (Exception e) {
                    try {
                        Tethering.this.mNMService.stopTethering();
                        Tethering.this.mNMService.startTethering(Tethering.this.mDhcpRange);
                    }
                    catch (Exception ee) {
                        TetherMasterSM.this.transitionTo(TetherMasterSM.this.mStartTetheringErrorState);
                        return false;
                    }
                }
                return true;
            }

            protected boolean turnOffMasterTetherSettings() {
                try {
                    Tethering.this.mNMService.stopTethering();
                }
                catch (Exception e) {
                    TetherMasterSM.this.transitionTo(TetherMasterSM.this.mStopTetheringErrorState);
                    return false;
                }
                try {
                    Tethering.this.mNMService.setIpForwardingEnabled(false);
                }
                catch (Exception e) {
                    TetherMasterSM.this.transitionTo(TetherMasterSM.this.mSetIpForwardingDisabledErrorState);
                    return false;
                }
                TetherMasterSM.this.transitionTo(TetherMasterSM.this.mInitialState);
                return true;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void chooseUpstreamType(boolean tryCell) {
                int upType = -1;
                String iface = null;
                Tethering.this.updateConfiguration();
                Object object = Tethering.this.mPublicSync;
                synchronized (object) {
                    for (Integer netType : Tethering.this.mUpstreamIfaceTypes) {
                        NetworkInfo info = Tethering.this.getConnectivityManager().getNetworkInfo(netType);
                        if (info == null || !info.isConnected()) continue;
                        upType = netType;
                        break;
                    }
                }
                switch (upType) {
                    case 4: 
                    case 5: {
                        this.turnOnUpstreamMobileConnection(upType);
                        break;
                    }
                    case -1: {
                        if (tryCell && this.turnOnUpstreamMobileConnection(Tethering.this.mPreferredUpstreamMobileApn)) break;
                        TetherMasterSM.this.sendMessageDelayed(327684, 10000L);
                        break;
                    }
                    default: {
                        this.turnOffUpstreamMobileConnection();
                    }
                }
                if (upType != -1) {
                    LinkProperties linkProperties = Tethering.this.getConnectivityManager().getLinkProperties(upType);
                    if (linkProperties != null) {
                        Log.i(Tethering.TAG, "Finding IPv4 upstream interface on: " + linkProperties);
                        RouteInfo ipv4Default = RouteInfo.selectBestRoute(linkProperties.getAllRoutes(), Inet4Address.ANY);
                        if (ipv4Default != null) {
                            iface = ipv4Default.getInterface();
                            Log.i(Tethering.TAG, "Found interface " + ipv4Default.getInterface());
                        } else {
                            Log.i(Tethering.TAG, "No IPv4 upstream interface, giving up.");
                        }
                    }
                    if (iface != null) {
                        Network network = Tethering.this.getConnectivityManager().getNetworkForType(upType);
                        if (network == null) {
                            Log.e(Tethering.TAG, "No Network for upstream type " + upType + "!");
                        }
                        this.setDnsForwarders(network, linkProperties);
                    }
                }
                this.notifyTetheredOfNewUpstreamIface(iface);
            }

            protected void setDnsForwarders(Network network, LinkProperties lp) {
                String[] dnsServers = Tethering.this.mDefaultDnsServers;
                List<InetAddress> dnses = lp.getDnsServers();
                if (dnses != null && !dnses.isEmpty()) {
                    dnsServers = NetworkUtils.makeStrings(dnses);
                }
                try {
                    Tethering.this.mNMService.setDnsForwarders(network, dnsServers);
                }
                catch (Exception e) {
                    Log.e(Tethering.TAG, "Setting DNS forwarders failed!");
                    TetherMasterSM.this.transitionTo(TetherMasterSM.this.mSetDnsForwardersErrorState);
                }
            }

            protected void notifyTetheredOfNewUpstreamIface(String ifaceName) {
                Tethering.this.mCurrentUpstreamIface = ifaceName;
                for (TetherInterfaceSM sm : TetherMasterSM.this.mNotifyList) {
                    sm.sendMessage(327792, ifaceName);
                }
            }
        }
    }

    class UpstreamNetworkMonitor {
        final HashMap<Network, NetworkState> mNetworkMap = new HashMap();
        ConnectivityManager.NetworkCallback mDefaultNetworkCallback;
        ConnectivityManager.NetworkCallback mDunTetheringCallback;

        UpstreamNetworkMonitor() {
        }

        void start() {
            this.stop();
            this.mDefaultNetworkCallback = new UpstreamNetworkCallback();
            Tethering.this.getConnectivityManager().registerDefaultNetworkCallback(this.mDefaultNetworkCallback);
            NetworkRequest dunTetheringRequest = new NetworkRequest.Builder().addTransportType(0).removeCapability(13).addCapability(2).build();
            this.mDunTetheringCallback = new UpstreamNetworkCallback();
            Tethering.this.getConnectivityManager().registerNetworkCallback(dunTetheringRequest, this.mDunTetheringCallback);
        }

        void stop() {
            if (this.mDefaultNetworkCallback != null) {
                Tethering.this.getConnectivityManager().unregisterNetworkCallback(this.mDefaultNetworkCallback);
                this.mDefaultNetworkCallback = null;
            }
            if (this.mDunTetheringCallback != null) {
                Tethering.this.getConnectivityManager().unregisterNetworkCallback(this.mDunTetheringCallback);
                this.mDunTetheringCallback = null;
            }
            this.mNetworkMap.clear();
        }

        boolean processLinkPropertiesChanged(NetworkState networkState) {
            if (networkState == null || networkState.network == null || networkState.linkProperties == null) {
                return false;
            }
            this.mNetworkMap.put(networkState.network, networkState);
            if (Tethering.this.mCurrentUpstreamIface != null) {
                for (String ifname : networkState.linkProperties.getAllInterfaceNames()) {
                    if (!Tethering.this.mCurrentUpstreamIface.equals(ifname)) continue;
                    return true;
                }
            }
            return false;
        }

        void processNetworkLost(Network network) {
            if (network != null) {
                this.mNetworkMap.remove(network);
            }
        }
    }

    class UpstreamNetworkCallback
    extends ConnectivityManager.NetworkCallback {
        UpstreamNetworkCallback() {
        }

        @Override
        public void onLinkPropertiesChanged(Network network, LinkProperties newLp) {
            Tethering.this.mTetherMasterSM.sendMessage(327685, new NetworkState(null, newLp, null, network, null, null));
        }

        @Override
        public void onLost(Network network) {
            Tethering.this.mTetherMasterSM.sendMessage(327686, network);
        }
    }

    class TetherInterfaceSM
    extends StateMachine {
        private static final int BASE_IFACE = 327780;
        static final int CMD_TETHER_MODE_DEAD = 327781;
        static final int CMD_TETHER_REQUESTED = 327782;
        static final int CMD_TETHER_UNREQUESTED = 327783;
        static final int CMD_INTERFACE_DOWN = 327784;
        static final int CMD_INTERFACE_UP = 327785;
        static final int CMD_CELL_DUN_ERROR = 327786;
        static final int CMD_IP_FORWARDING_ENABLE_ERROR = 327787;
        static final int CMD_IP_FORWARDING_DISABLE_ERROR = 327788;
        static final int CMD_START_TETHERING_ERROR = 327789;
        static final int CMD_STOP_TETHERING_ERROR = 327790;
        static final int CMD_SET_DNS_FORWARDERS_ERROR = 327791;
        static final int CMD_TETHER_CONNECTION_CHANGED = 327792;
        private State mDefaultState;
        private State mInitialState;
        private State mStartingState;
        private State mTetheredState;
        private State mUnavailableState;
        private boolean mAvailable;
        private boolean mTethered;
        int mLastError;
        String mIfaceName;
        String mMyUpstreamIfaceName;
        boolean mUsb;

        TetherInterfaceSM(String name, Looper looper, boolean usb) {
            super(name, looper);
            this.mIfaceName = name;
            this.mUsb = usb;
            this.setLastError(0);
            this.mInitialState = new InitialState();
            this.addState(this.mInitialState);
            this.mStartingState = new StartingState();
            this.addState(this.mStartingState);
            this.mTetheredState = new TetheredState();
            this.addState(this.mTetheredState);
            this.mUnavailableState = new UnavailableState();
            this.addState(this.mUnavailableState);
            this.setInitialState(this.mInitialState);
        }

        @Override
        public String toString() {
            String res = new String();
            res = res + this.mIfaceName + " - ";
            IState current = this.getCurrentState();
            if (current == this.mInitialState) {
                res = res + "InitialState";
            }
            if (current == this.mStartingState) {
                res = res + "StartingState";
            }
            if (current == this.mTetheredState) {
                res = res + "TetheredState";
            }
            if (current == this.mUnavailableState) {
                res = res + "UnavailableState";
            }
            if (this.mAvailable) {
                res = res + " - Available";
            }
            if (this.mTethered) {
                res = res + " - Tethered";
            }
            res = res + " - lastError =" + this.mLastError;
            return res;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getLastError() {
            Object object = Tethering.this.mPublicSync;
            synchronized (object) {
                return this.mLastError;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setLastError(int error) {
            Object object = Tethering.this.mPublicSync;
            synchronized (object) {
                this.mLastError = error;
                if (this.isErrored() && this.mUsb) {
                    Tethering.this.configureUsbIface(false);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isAvailable() {
            Object object = Tethering.this.mPublicSync;
            synchronized (object) {
                return this.mAvailable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setAvailable(boolean available) {
            Object object = Tethering.this.mPublicSync;
            synchronized (object) {
                this.mAvailable = available;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isTethered() {
            Object object = Tethering.this.mPublicSync;
            synchronized (object) {
                return this.mTethered;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setTethered(boolean tethered) {
            Object object = Tethering.this.mPublicSync;
            synchronized (object) {
                this.mTethered = tethered;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isErrored() {
            Object object = Tethering.this.mPublicSync;
            synchronized (object) {
                return this.mLastError != 0;
            }
        }

        void setLastErrorAndTransitionToInitialState(int error) {
            this.setLastError(error);
            this.transitionTo(this.mInitialState);
        }

        class UnavailableState
        extends State {
            UnavailableState() {
            }

            @Override
            public void enter() {
                TetherInterfaceSM.this.setAvailable(false);
                TetherInterfaceSM.this.setLastError(0);
                TetherInterfaceSM.this.setTethered(false);
                Tethering.this.sendTetherStateChangedBroadcast();
            }

            @Override
            public boolean processMessage(Message message) {
                boolean retValue = true;
                switch (message.what) {
                    case 327785: {
                        TetherInterfaceSM.this.transitionTo(TetherInterfaceSM.this.mInitialState);
                        break;
                    }
                    default: {
                        retValue = false;
                    }
                }
                return retValue;
            }
        }

        class TetheredState
        extends State {
            TetheredState() {
            }

            @Override
            public void enter() {
                try {
                    Tethering.this.mNMService.tetherInterface(TetherInterfaceSM.this.mIfaceName);
                }
                catch (Exception e) {
                    Log.e(Tethering.TAG, "Error Tethering: " + e.toString());
                    TetherInterfaceSM.this.setLastError(6);
                    try {
                        Tethering.this.mNMService.untetherInterface(TetherInterfaceSM.this.mIfaceName);
                    }
                    catch (Exception ee) {
                        Log.e(Tethering.TAG, "Error untethering after failure!" + ee.toString());
                    }
                    TetherInterfaceSM.this.transitionTo(TetherInterfaceSM.this.mInitialState);
                    return;
                }
                TetherInterfaceSM.this.setAvailable(false);
                TetherInterfaceSM.this.setTethered(true);
                Tethering.this.sendTetherStateChangedBroadcast();
            }

            private void cleanupUpstream() {
                if (TetherInterfaceSM.this.mMyUpstreamIfaceName != null) {
                    try {
                        Tethering.this.mStatsService.forceUpdate();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        Tethering.this.mNMService.stopInterfaceForwarding(TetherInterfaceSM.this.mIfaceName, TetherInterfaceSM.this.mMyUpstreamIfaceName);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        Tethering.this.mNMService.disableNat(TetherInterfaceSM.this.mIfaceName, TetherInterfaceSM.this.mMyUpstreamIfaceName);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    TetherInterfaceSM.this.mMyUpstreamIfaceName = null;
                }
            }

            @Override
            public boolean processMessage(Message message) {
                Tethering.this.maybeLogMessage(this, message.what);
                boolean retValue = true;
                boolean error = false;
                switch (message.what) {
                    case 327783: 
                    case 327784: {
                        this.cleanupUpstream();
                        try {
                            Tethering.this.mNMService.untetherInterface(TetherInterfaceSM.this.mIfaceName);
                        }
                        catch (Exception e) {
                            TetherInterfaceSM.this.setLastErrorAndTransitionToInitialState(7);
                            break;
                        }
                        Tethering.this.mTetherMasterSM.sendMessage(327682, TetherInterfaceSM.this);
                        if (message.what == 327783) {
                            if (TetherInterfaceSM.this.mUsb && !Tethering.this.configureUsbIface(false)) {
                                TetherInterfaceSM.this.setLastError(10);
                            }
                            TetherInterfaceSM.this.transitionTo(TetherInterfaceSM.this.mInitialState);
                            break;
                        }
                        if (message.what != 327784) break;
                        TetherInterfaceSM.this.transitionTo(TetherInterfaceSM.this.mUnavailableState);
                        break;
                    }
                    case 327792: {
                        String newUpstreamIfaceName = (String)message.obj;
                        if (TetherInterfaceSM.this.mMyUpstreamIfaceName == null && newUpstreamIfaceName == null || TetherInterfaceSM.this.mMyUpstreamIfaceName != null && TetherInterfaceSM.this.mMyUpstreamIfaceName.equals(newUpstreamIfaceName)) break;
                        this.cleanupUpstream();
                        if (newUpstreamIfaceName != null) {
                            try {
                                Tethering.this.mNMService.enableNat(TetherInterfaceSM.this.mIfaceName, newUpstreamIfaceName);
                                Tethering.this.mNMService.startInterfaceForwarding(TetherInterfaceSM.this.mIfaceName, newUpstreamIfaceName);
                            }
                            catch (Exception e) {
                                Log.e(Tethering.TAG, "Exception enabling Nat: " + e.toString());
                                try {
                                    Tethering.this.mNMService.disableNat(TetherInterfaceSM.this.mIfaceName, newUpstreamIfaceName);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                try {
                                    Tethering.this.mNMService.untetherInterface(TetherInterfaceSM.this.mIfaceName);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                TetherInterfaceSM.this.setLastError(8);
                                TetherInterfaceSM.this.transitionTo(TetherInterfaceSM.this.mInitialState);
                                return true;
                            }
                        }
                        TetherInterfaceSM.this.mMyUpstreamIfaceName = newUpstreamIfaceName;
                        break;
                    }
                    case 327786: 
                    case 327787: 
                    case 327788: 
                    case 327789: 
                    case 327790: 
                    case 327791: {
                        error = true;
                    }
                    case 327781: {
                        this.cleanupUpstream();
                        try {
                            Tethering.this.mNMService.untetherInterface(TetherInterfaceSM.this.mIfaceName);
                        }
                        catch (Exception e) {
                            TetherInterfaceSM.this.setLastErrorAndTransitionToInitialState(7);
                            break;
                        }
                        if (error) {
                            TetherInterfaceSM.this.setLastErrorAndTransitionToInitialState(5);
                            break;
                        }
                        Tethering.this.sendTetherStateChangedBroadcast();
                        if (TetherInterfaceSM.this.mUsb && !Tethering.this.configureUsbIface(false)) {
                            TetherInterfaceSM.this.setLastError(10);
                        }
                        TetherInterfaceSM.this.transitionTo(TetherInterfaceSM.this.mInitialState);
                        break;
                    }
                    default: {
                        retValue = false;
                    }
                }
                return retValue;
            }
        }

        class StartingState
        extends State {
            StartingState() {
            }

            @Override
            public void enter() {
                TetherInterfaceSM.this.setAvailable(false);
                if (TetherInterfaceSM.this.mUsb && !Tethering.this.configureUsbIface(true)) {
                    Tethering.this.mTetherMasterSM.sendMessage(327682, TetherInterfaceSM.this);
                    TetherInterfaceSM.this.setLastError(10);
                    TetherInterfaceSM.this.transitionTo(TetherInterfaceSM.this.mInitialState);
                    return;
                }
                Tethering.this.sendTetherStateChangedBroadcast();
                TetherInterfaceSM.this.transitionTo(TetherInterfaceSM.this.mTetheredState);
            }

            @Override
            public boolean processMessage(Message message) {
                Tethering.this.maybeLogMessage(this, message.what);
                boolean retValue = true;
                switch (message.what) {
                    case 327783: {
                        Tethering.this.mTetherMasterSM.sendMessage(327682, TetherInterfaceSM.this);
                        if (TetherInterfaceSM.this.mUsb && !Tethering.this.configureUsbIface(false)) {
                            TetherInterfaceSM.this.setLastErrorAndTransitionToInitialState(10);
                            break;
                        }
                        TetherInterfaceSM.this.transitionTo(TetherInterfaceSM.this.mInitialState);
                        break;
                    }
                    case 327786: 
                    case 327787: 
                    case 327788: 
                    case 327789: 
                    case 327790: 
                    case 327791: {
                        TetherInterfaceSM.this.setLastErrorAndTransitionToInitialState(5);
                        break;
                    }
                    case 327784: {
                        Tethering.this.mTetherMasterSM.sendMessage(327682, TetherInterfaceSM.this);
                        TetherInterfaceSM.this.transitionTo(TetherInterfaceSM.this.mUnavailableState);
                        break;
                    }
                    default: {
                        retValue = false;
                    }
                }
                return retValue;
            }
        }

        class InitialState
        extends State {
            InitialState() {
            }

            @Override
            public void enter() {
                TetherInterfaceSM.this.setAvailable(true);
                TetherInterfaceSM.this.setTethered(false);
                Tethering.this.sendTetherStateChangedBroadcast();
            }

            @Override
            public boolean processMessage(Message message) {
                Tethering.this.maybeLogMessage(this, message.what);
                boolean retValue = true;
                switch (message.what) {
                    case 327782: {
                        TetherInterfaceSM.this.setLastError(0);
                        Tethering.this.mTetherMasterSM.sendMessage(327681, TetherInterfaceSM.this);
                        TetherInterfaceSM.this.transitionTo(TetherInterfaceSM.this.mStartingState);
                        break;
                    }
                    case 327784: {
                        TetherInterfaceSM.this.transitionTo(TetherInterfaceSM.this.mUnavailableState);
                        break;
                    }
                    default: {
                        retValue = false;
                    }
                }
                return retValue;
            }
        }
    }

    private class StateReceiver
    extends BroadcastReceiver {
        private StateReceiver() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReceive(Context content, Intent intent) {
            String action = intent.getAction();
            if (action == null) {
                return;
            }
            if (action.equals("android.hardware.usb.action.USB_STATE")) {
                Object object = Tethering.this.mPublicSync;
                synchronized (object) {
                    boolean usbConnected = intent.getBooleanExtra("connected", false);
                    Tethering.this.mRndisEnabled = intent.getBooleanExtra("rndis", false);
                    if (usbConnected && Tethering.this.mRndisEnabled && Tethering.this.mUsbTetherRequested) {
                        Tethering.this.tetherUsb(true);
                    }
                    Tethering.this.mUsbTetherRequested = false;
                }
            } else if (action.equals("android.net.conn.CONNECTIVITY_CHANGE")) {
                NetworkInfo networkInfo = (NetworkInfo)intent.getParcelableExtra("networkInfo");
                if (networkInfo != null && networkInfo.getDetailedState() != NetworkInfo.DetailedState.FAILED) {
                    Tethering.this.mTetherMasterSM.sendMessage(327683);
                }
            } else if (action.equals("android.intent.action.CONFIGURATION_CHANGED")) {
                Tethering.this.updateConfiguration();
            }
        }
    }
}

