/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.connectivity;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.ServiceConnection;
import android.net.ProxyInfo;
import android.net.Uri;
import android.os.Handler;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.provider.Settings;
import android.util.Log;
import com.android.internal.annotations.GuardedBy;
import com.android.net.IProxyCallback;
import com.android.net.IProxyPortListener;
import com.android.net.IProxyService;
import com.android.server.IoThread;
import java.io.IOException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import libcore.io.Streams;

public class PacManager {
    public static final String PAC_PACKAGE = "com.android.pacprocessor";
    public static final String PAC_SERVICE = "com.android.pacprocessor.PacService";
    public static final String PAC_SERVICE_NAME = "com.android.net.IProxyService";
    public static final String PROXY_PACKAGE = "com.android.proxyhandler";
    public static final String PROXY_SERVICE = "com.android.proxyhandler.ProxyService";
    private static final String TAG = "PacManager";
    private static final String ACTION_PAC_REFRESH = "android.net.proxy.PAC_REFRESH";
    private static final String DEFAULT_DELAYS = "8 32 120 14400 43200";
    private static final int DELAY_1 = 0;
    private static final int DELAY_4 = 3;
    private static final int DELAY_LONG = 4;
    public static final String KEY_PROXY = "keyProxy";
    private String mCurrentPac;
    @GuardedBy(value="mProxyLock")
    private Uri mPacUrl = Uri.EMPTY;
    private AlarmManager mAlarmManager;
    @GuardedBy(value="mProxyLock")
    private IProxyService mProxyService;
    private PendingIntent mPacRefreshIntent;
    private ServiceConnection mConnection;
    private ServiceConnection mProxyConnection;
    private Context mContext;
    private int mCurrentDelay;
    private int mLastPort;
    private boolean mHasSentBroadcast;
    private boolean mHasDownloaded;
    private Handler mConnectivityHandler;
    private int mProxyMessage;
    private final Object mProxyLock = new Object();
    private Runnable mPacDownloader = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            String file;
            Object object = PacManager.this.mProxyLock;
            synchronized (object) {
                if (Uri.EMPTY.equals(PacManager.this.mPacUrl)) {
                    return;
                }
                try {
                    file = PacManager.get(PacManager.this.mPacUrl);
                }
                catch (IOException ioe) {
                    file = null;
                    Log.w(PacManager.TAG, "Failed to load PAC file: " + ioe);
                }
            }
            if (file != null) {
                object = PacManager.this.mProxyLock;
                synchronized (object) {
                    if (!file.equals(PacManager.this.mCurrentPac)) {
                        PacManager.this.setCurrentProxyScript(file);
                    }
                }
                PacManager.this.mHasDownloaded = true;
                PacManager.this.sendProxyIfNeeded();
                PacManager.this.longSchedule();
            } else {
                PacManager.this.reschedule();
            }
        }
    };

    public PacManager(Context context, Handler handler, int proxyMessage) {
        this.mContext = context;
        this.mLastPort = -1;
        this.mPacRefreshIntent = PendingIntent.getBroadcast(context, 0, new Intent(ACTION_PAC_REFRESH), 0);
        context.registerReceiver(new PacRefreshIntentReceiver(), new IntentFilter(ACTION_PAC_REFRESH));
        this.mConnectivityHandler = handler;
        this.mProxyMessage = proxyMessage;
    }

    private AlarmManager getAlarmManager() {
        if (this.mAlarmManager == null) {
            this.mAlarmManager = (AlarmManager)this.mContext.getSystemService("alarm");
        }
        return this.mAlarmManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean setCurrentProxyScriptUrl(ProxyInfo proxy) {
        if (!Uri.EMPTY.equals(proxy.getPacFileUrl())) {
            if (proxy.getPacFileUrl().equals(this.mPacUrl) && proxy.getPort() > 0) {
                return false;
            }
            Object object = this.mProxyLock;
            synchronized (object) {
                this.mPacUrl = proxy.getPacFileUrl();
            }
            this.mCurrentDelay = 0;
            this.mHasSentBroadcast = false;
            this.mHasDownloaded = false;
            this.getAlarmManager().cancel(this.mPacRefreshIntent);
            this.bind();
            return true;
        }
        this.getAlarmManager().cancel(this.mPacRefreshIntent);
        Object object = this.mProxyLock;
        synchronized (object) {
            this.mPacUrl = Uri.EMPTY;
            this.mCurrentPac = null;
            if (this.mProxyService != null) {
                try {
                    this.mProxyService.stopPacSystem();
                }
                catch (RemoteException e) {
                    Log.w(TAG, "Failed to stop PAC service", e);
                }
                finally {
                    this.unbind();
                }
            }
        }
        return false;
    }

    private static String get(Uri pacUri) throws IOException {
        URL url = new URL(pacUri.toString());
        URLConnection urlConnection = url.openConnection(Proxy.NO_PROXY);
        return new String(Streams.readFully(urlConnection.getInputStream()));
    }

    private int getNextDelay(int currentDelay) {
        if (++currentDelay > 3) {
            return 3;
        }
        return currentDelay;
    }

    private void longSchedule() {
        this.mCurrentDelay = 0;
        this.setDownloadIn(4);
    }

    private void reschedule() {
        this.mCurrentDelay = this.getNextDelay(this.mCurrentDelay);
        this.setDownloadIn(this.mCurrentDelay);
    }

    private String getPacChangeDelay() {
        ContentResolver cr = this.mContext.getContentResolver();
        String defaultDelay = SystemProperties.get("conn.pac_change_delay", DEFAULT_DELAYS);
        String val = Settings.Global.getString(cr, "pac_change_delay");
        return val == null ? defaultDelay : val;
    }

    private long getDownloadDelay(int delayIndex) {
        String[] list = this.getPacChangeDelay().split(" ");
        if (delayIndex < list.length) {
            return Long.parseLong(list[delayIndex]);
        }
        return 0L;
    }

    private void setDownloadIn(int delayIndex) {
        long delay = this.getDownloadDelay(delayIndex);
        long timeTillTrigger = 1000L * delay + SystemClock.elapsedRealtime();
        this.getAlarmManager().set(3, timeTillTrigger, this.mPacRefreshIntent);
    }

    private boolean setCurrentProxyScript(String script) {
        if (this.mProxyService == null) {
            Log.e(TAG, "setCurrentProxyScript: no proxy service");
            return false;
        }
        try {
            this.mProxyService.setPacFile(script);
            this.mCurrentPac = script;
        }
        catch (RemoteException e) {
            Log.e(TAG, "Unable to set PAC file", e);
        }
        return true;
    }

    private void bind() {
        if (this.mContext == null) {
            Log.e(TAG, "No context for binding");
            return;
        }
        Intent intent = new Intent();
        intent.setClassName(PAC_PACKAGE, PAC_SERVICE);
        if (this.mProxyConnection != null && this.mConnection != null) {
            IoThread.getHandler().post(this.mPacDownloader);
            return;
        }
        this.mConnection = new ServiceConnection(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onServiceDisconnected(ComponentName component) {
                Object object = PacManager.this.mProxyLock;
                synchronized (object) {
                    PacManager.this.mProxyService = null;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onServiceConnected(ComponentName component, IBinder binder) {
                Object object = PacManager.this.mProxyLock;
                synchronized (object) {
                    try {
                        Log.d(PacManager.TAG, "Adding service com.android.net.IProxyService " + binder.getInterfaceDescriptor());
                    }
                    catch (RemoteException e1) {
                        Log.e(PacManager.TAG, "Remote Exception", e1);
                    }
                    ServiceManager.addService(PacManager.PAC_SERVICE_NAME, binder);
                    PacManager.this.mProxyService = IProxyService.Stub.asInterface(binder);
                    if (PacManager.this.mProxyService == null) {
                        Log.e(PacManager.TAG, "No proxy service");
                    } else {
                        try {
                            PacManager.this.mProxyService.startPacSystem();
                        }
                        catch (RemoteException e) {
                            Log.e(PacManager.TAG, "Unable to reach ProxyService - PAC will not be started", e);
                        }
                        IoThread.getHandler().post(PacManager.this.mPacDownloader);
                    }
                }
            }
        };
        this.mContext.bindService(intent, this.mConnection, 0x40000005);
        intent = new Intent();
        intent.setClassName(PROXY_PACKAGE, PROXY_SERVICE);
        this.mProxyConnection = new ServiceConnection(){

            @Override
            public void onServiceDisconnected(ComponentName component) {
            }

            @Override
            public void onServiceConnected(ComponentName component, IBinder binder) {
                IProxyCallback callbackService = IProxyCallback.Stub.asInterface(binder);
                if (callbackService != null) {
                    try {
                        callbackService.getProxyPort(new IProxyPortListener.Stub(){

                            @Override
                            public void setProxyPort(int port) throws RemoteException {
                                if (PacManager.this.mLastPort != -1) {
                                    PacManager.this.mHasSentBroadcast = false;
                                }
                                PacManager.this.mLastPort = port;
                                if (port != -1) {
                                    Log.d(PacManager.TAG, "Local proxy is bound on " + port);
                                    PacManager.this.sendProxyIfNeeded();
                                } else {
                                    Log.e(PacManager.TAG, "Received invalid port from Local Proxy, PAC will not be operational");
                                }
                            }
                        });
                    }
                    catch (RemoteException e) {
                        e.printStackTrace();
                    }
                }
            }
        };
        this.mContext.bindService(intent, this.mProxyConnection, 0x40000005);
    }

    private void unbind() {
        if (this.mConnection != null) {
            this.mContext.unbindService(this.mConnection);
            this.mConnection = null;
        }
        if (this.mProxyConnection != null) {
            this.mContext.unbindService(this.mProxyConnection);
            this.mProxyConnection = null;
        }
        this.mProxyService = null;
        this.mLastPort = -1;
    }

    private void sendPacBroadcast(ProxyInfo proxy) {
        this.mConnectivityHandler.sendMessage(this.mConnectivityHandler.obtainMessage(this.mProxyMessage, proxy));
    }

    private synchronized void sendProxyIfNeeded() {
        if (!this.mHasDownloaded || this.mLastPort == -1) {
            return;
        }
        if (!this.mHasSentBroadcast) {
            this.sendPacBroadcast(new ProxyInfo(this.mPacUrl, this.mLastPort));
            this.mHasSentBroadcast = true;
        }
    }

    class PacRefreshIntentReceiver
    extends BroadcastReceiver {
        PacRefreshIntentReceiver() {
        }

        @Override
        public void onReceive(Context context, Intent intent) {
            IoThread.getHandler().post(PacManager.this.mPacDownloader);
        }
    }
}

