/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.am;

import android.app.Dialog;
import android.app.IStopUserCallback;
import android.app.IUserSwitchObserver;
import android.app.KeyguardManager;
import android.content.IIntentReceiver;
import android.content.Intent;
import android.content.pm.UserInfo;
import android.os.Binder;
import android.os.Build;
import android.os.Bundle;
import android.os.Debug;
import android.os.Handler;
import android.os.IBinder;
import android.os.IProgressListener;
import android.os.IRemoteCallback;
import android.os.IUserManager;
import android.os.RemoteCallbackList;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.os.UserHandle;
import android.os.UserManagerInternal;
import android.os.storage.IMountService;
import android.os.storage.StorageManager;
import android.util.IntArray;
import android.util.Pair;
import android.util.Slog;
import android.util.SparseArray;
import android.util.SparseIntArray;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.logging.MetricsLogger;
import com.android.internal.util.ArrayUtils;
import com.android.internal.widget.LockPatternUtils;
import com.android.server.LocalServices;
import com.android.server.am.ActivityManagerService;
import com.android.server.am.EventLogTags;
import com.android.server.am.PreBootBroadcaster;
import com.android.server.am.UserState;
import com.android.server.am.UserSwitchingDialog;
import com.android.server.pm.UserManagerService;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

final class UserController {
    private static final String TAG = "ActivityManager";
    static final int MAX_RUNNING_USERS = 3;
    static final int USER_SWITCH_TIMEOUT = 2000;
    private final ActivityManagerService mService;
    private final Handler mHandler;
    private int mCurrentUserId = 0;
    private int mTargetUserId = -10000;
    @GuardedBy(value="mService")
    private final SparseArray<UserState> mStartedUsers = new SparseArray();
    private final ArrayList<Integer> mUserLru = new ArrayList();
    private int[] mStartedUserArray = new int[]{0};
    private int[] mCurrentProfileIds = new int[0];
    private final SparseIntArray mUserProfileGroupIdsSelfLocked = new SparseIntArray();
    private final RemoteCallbackList<IUserSwitchObserver> mUserSwitchObservers = new RemoteCallbackList();
    Object mCurUserSwitchCallback;
    private volatile UserManagerService mUserManager;
    private final LockPatternUtils mLockPatternUtils;
    private UserManagerInternal mUserManagerInternal;

    UserController(ActivityManagerService service) {
        this.mService = service;
        this.mHandler = this.mService.mHandler;
        UserState uss = new UserState(UserHandle.SYSTEM);
        this.mStartedUsers.put(0, uss);
        this.mUserLru.add(0);
        this.mLockPatternUtils = new LockPatternUtils(this.mService.mContext);
        this.updateStartedUserArrayLocked();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void finishUserSwitch(UserState uss) {
        ActivityManagerService activityManagerService = this.mService;
        synchronized (activityManagerService) {
            this.finishUserBoot(uss);
            this.startProfilesLocked();
            this.stopRunningUsersLocked(3);
        }
    }

    void stopRunningUsersLocked(int maxRunningUsers) {
        int num = this.mUserLru.size();
        int i = 0;
        while (num > maxRunningUsers && i < this.mUserLru.size()) {
            Integer oldUserId = this.mUserLru.get(i);
            UserState oldUss = this.mStartedUsers.get(oldUserId);
            if (oldUss == null) {
                this.mUserLru.remove(i);
                --num;
                continue;
            }
            if (oldUss.state == 4 || oldUss.state == 5) {
                --num;
                ++i;
                continue;
            }
            if (oldUserId == 0 || oldUserId == this.mCurrentUserId) {
                if (UserInfo.isSystemOnly(oldUserId)) {
                    --num;
                }
                ++i;
                continue;
            }
            if (this.stopUsersLocked(oldUserId, false, null) != 0) {
                --num;
            }
            --num;
            ++i;
        }
    }

    private void finishUserBoot(UserState uss) {
        this.finishUserBoot(uss, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishUserBoot(UserState uss, IIntentReceiver resultTo) {
        int userId = uss.mHandle.getIdentifier();
        Slog.d(TAG, "Finishing user boot " + userId);
        ActivityManagerService activityManagerService = this.mService;
        synchronized (activityManagerService) {
            if (this.mStartedUsers.get(userId) != uss) {
                return;
            }
            if (uss.setState(0, 1)) {
                this.getUserManagerInternal().setUserState(userId, uss.state);
                int uptimeSeconds = (int)(SystemClock.elapsedRealtime() / 1000L);
                MetricsLogger.histogram(this.mService.mContext, "framework_locked_boot_completed", uptimeSeconds);
                Intent intent = new Intent("android.intent.action.LOCKED_BOOT_COMPLETED", null);
                intent.putExtra("android.intent.extra.user_handle", userId);
                intent.addFlags(0x9000000);
                this.mService.broadcastIntentLocked(null, null, intent, null, resultTo, 0, null, null, new String[]{"android.permission.RECEIVE_BOOT_COMPLETED"}, -1, null, true, false, ActivityManagerService.MY_PID, 1000, userId);
            }
            if (this.getUserManager().isManagedProfile(userId)) {
                UserInfo parent = this.getUserManager().getProfileParent(userId);
                if (parent != null && this.isUserRunningLocked(parent.id, 4)) {
                    Slog.d(TAG, "User " + userId + " (parent " + parent.id + "): attempting unlock because parent is unlocked");
                    this.maybeUnlockUser(userId);
                } else {
                    String parentId = parent == null ? "<null>" : String.valueOf(parent.id);
                    Slog.d(TAG, "User " + userId + " (parent " + parentId + "): delaying unlock because parent is locked");
                }
            } else {
                this.maybeUnlockUser(userId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishUserUnlocking(UserState uss) {
        int userId = uss.mHandle.getIdentifier();
        ActivityManagerService activityManagerService = this.mService;
        synchronized (activityManagerService) {
            if (this.mStartedUsers.get(uss.mHandle.getIdentifier()) != uss) {
                return;
            }
            if (!StorageManager.isUserKeyUnlocked(userId)) {
                return;
            }
            if (uss.setState(1, 2)) {
                this.getUserManagerInternal().setUserState(userId, uss.state);
                uss.mUnlockProgress.start();
                uss.mUnlockProgress.setProgress(5, this.mService.mContext.getString(17040296));
                this.mUserManager.onBeforeUnlockUser(userId);
                uss.mUnlockProgress.setProgress(20);
                this.mHandler.obtainMessage(61, userId, 0, uss).sendToTarget();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void finishUserUnlocked(final UserState uss) {
        int userId = uss.mHandle.getIdentifier();
        ActivityManagerService activityManagerService = this.mService;
        synchronized (activityManagerService) {
            if (this.mStartedUsers.get(uss.mHandle.getIdentifier()) != uss) {
                return;
            }
            if (!StorageManager.isUserKeyUnlocked(userId)) {
                return;
            }
            if (uss.setState(2, 3)) {
                UserInfo parent;
                this.getUserManagerInternal().setUserState(userId, uss.state);
                uss.mUnlockProgress.finish();
                Intent unlockedIntent = new Intent("android.intent.action.USER_UNLOCKED");
                unlockedIntent.putExtra("android.intent.extra.user_handle", userId);
                unlockedIntent.addFlags(0x50000000);
                this.mService.broadcastIntentLocked(null, null, unlockedIntent, null, null, 0, null, null, null, -1, null, false, false, ActivityManagerService.MY_PID, 1000, userId);
                if (this.getUserInfo(userId).isManagedProfile() && (parent = this.getUserManager().getProfileParent(userId)) != null) {
                    Intent profileUnlockedIntent = new Intent("android.intent.action.MANAGED_PROFILE_UNLOCKED");
                    profileUnlockedIntent.putExtra("android.intent.extra.USER", UserHandle.of(userId));
                    profileUnlockedIntent.addFlags(0x50000000);
                    this.mService.broadcastIntentLocked(null, null, profileUnlockedIntent, null, null, 0, null, null, null, -1, null, false, false, ActivityManagerService.MY_PID, 1000, parent.id);
                }
                UserInfo info = this.getUserInfo(userId);
                if (!Objects.equals(info.lastLoggedInFingerprint, Build.FINGERPRINT)) {
                    new PreBootBroadcaster(this.mService, userId, null){

                        @Override
                        public void onFinished() {
                            UserController.this.finishUserUnlockedCompleted(uss);
                        }
                    }.sendNext();
                } else {
                    this.finishUserUnlockedCompleted(uss);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishUserUnlockedCompleted(UserState uss) {
        int userId = uss.mHandle.getIdentifier();
        ActivityManagerService activityManagerService = this.mService;
        synchronized (activityManagerService) {
            if (this.mStartedUsers.get(uss.mHandle.getIdentifier()) != uss) {
                return;
            }
            final UserInfo userInfo = this.getUserInfo(userId);
            if (userInfo == null) {
                return;
            }
            if (!StorageManager.isUserKeyUnlocked(userId)) {
                return;
            }
            this.mUserManager.onUserLoggedIn(userId);
            if (!userInfo.isInitialized() && userId != 0) {
                Slog.d(TAG, "Initializing user #" + userId);
                Intent intent = new Intent("android.intent.action.USER_INITIALIZE");
                intent.addFlags(0x10000000);
                this.mService.broadcastIntentLocked(null, null, intent, null, new IIntentReceiver.Stub(){

                    @Override
                    public void performReceive(Intent intent, int resultCode, String data, Bundle extras, boolean ordered, boolean sticky, int sendingUser) {
                        UserController.this.getUserManager().makeInitialized(userInfo.id);
                    }
                }, 0, null, null, null, -1, null, true, false, ActivityManagerService.MY_PID, 1000, userId);
            }
            Slog.d(TAG, "Sending BOOT_COMPLETE user #" + userId);
            int uptimeSeconds = (int)(SystemClock.elapsedRealtime() / 1000L);
            MetricsLogger.histogram(this.mService.mContext, "framework_boot_completed", uptimeSeconds);
            Intent bootIntent = new Intent("android.intent.action.BOOT_COMPLETED", null);
            bootIntent.putExtra("android.intent.extra.user_handle", userId);
            bootIntent.addFlags(0x9000000);
            this.mService.broadcastIntentLocked(null, null, bootIntent, null, null, 0, null, null, new String[]{"android.permission.RECEIVE_BOOT_COMPLETED"}, -1, null, true, false, ActivityManagerService.MY_PID, 1000, userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int stopUser(int userId, boolean force, IStopUserCallback callback) {
        if (this.mService.checkCallingPermission("android.permission.INTERACT_ACROSS_USERS_FULL") != 0) {
            String msg = "Permission Denial: switchUser() from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid() + " requires " + "android.permission.INTERACT_ACROSS_USERS_FULL";
            Slog.w(TAG, msg);
            throw new SecurityException(msg);
        }
        if (userId < 0 || userId == 0) {
            throw new IllegalArgumentException("Can't stop system user " + userId);
        }
        this.mService.enforceShellRestriction("no_debugging_features", userId);
        ActivityManagerService activityManagerService = this.mService;
        synchronized (activityManagerService) {
            return this.stopUsersLocked(userId, force, callback);
        }
    }

    private int stopUsersLocked(int userId, boolean force, IStopUserCallback callback) {
        if (userId == 0) {
            return -3;
        }
        if (this.isCurrentUserLocked(userId)) {
            return -2;
        }
        int[] usersToStop = this.getUsersToStopLocked(userId);
        for (int i = 0; i < usersToStop.length; ++i) {
            int relatedUserId = usersToStop[i];
            if (0 != relatedUserId && !this.isCurrentUserLocked(relatedUserId)) continue;
            if (force) {
                Slog.i(TAG, "Force stop user " + userId + ". Related users will not be stopped");
                this.stopSingleUserLocked(userId, callback);
                return 0;
            }
            return -4;
        }
        for (int userIdToStop : usersToStop) {
            this.stopSingleUserLocked(userIdToStop, userIdToStop == userId ? callback : null);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopSingleUserLocked(final int userId, final IStopUserCallback callback) {
        final UserState uss = this.mStartedUsers.get(userId);
        if (uss == null) {
            if (callback != null) {
                this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            callback.userStopped(userId);
                        }
                        catch (RemoteException remoteException) {
                            // empty catch block
                        }
                    }
                });
            }
            return;
        }
        if (callback != null) {
            uss.mStopCallbacks.add(callback);
        }
        if (uss.state != 4 && uss.state != 5) {
            uss.setState(4);
            this.getUserManagerInternal().setUserState(userId, uss.state);
            this.updateStartedUserArrayLocked();
            long ident = Binder.clearCallingIdentity();
            try {
                Intent stoppingIntent = new Intent("android.intent.action.USER_STOPPING");
                stoppingIntent.addFlags(0x40000000);
                stoppingIntent.putExtra("android.intent.extra.user_handle", userId);
                stoppingIntent.putExtra("android.intent.extra.SHUTDOWN_USERSPACE_ONLY", true);
                IIntentReceiver.Stub stoppingReceiver = new IIntentReceiver.Stub(){

                    @Override
                    public void performReceive(Intent intent, int resultCode, String data, Bundle extras, boolean ordered, boolean sticky, int sendingUser) {
                        UserController.this.mHandler.post(new Runnable(){

                            @Override
                            public void run() {
                                UserController.this.finishUserStopping(userId, uss);
                            }
                        });
                    }
                };
                this.mService.clearBroadcastQueueForUserLocked(userId);
                this.mService.broadcastIntentLocked(null, null, stoppingIntent, null, stoppingReceiver, 0, null, null, new String[]{"android.permission.INTERACT_ACROSS_USERS"}, -1, null, true, false, ActivityManagerService.MY_PID, 1000, -1);
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void finishUserStopping(int userId, final UserState uss) {
        Intent shutdownIntent = new Intent("android.intent.action.ACTION_SHUTDOWN");
        IIntentReceiver.Stub shutdownReceiver = new IIntentReceiver.Stub(){

            @Override
            public void performReceive(Intent intent, int resultCode, String data, Bundle extras, boolean ordered, boolean sticky, int sendingUser) {
                UserController.this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        UserController.this.finishUserStopped(uss);
                    }
                });
            }
        };
        ActivityManagerService activityManagerService = this.mService;
        synchronized (activityManagerService) {
            if (uss.state != 4) {
                return;
            }
            uss.setState(5);
        }
        this.getUserManagerInternal().setUserState(userId, uss.state);
        this.mService.mBatteryStatsService.noteEvent(16391, Integer.toString(userId), userId);
        this.mService.mSystemServiceManager.stopUser(userId);
        activityManagerService = this.mService;
        synchronized (activityManagerService) {
            this.mService.broadcastIntentLocked(null, null, shutdownIntent, null, shutdownReceiver, 0, null, null, null, -1, null, true, false, ActivityManagerService.MY_PID, 1000, userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void finishUserStopped(UserState uss) {
        boolean stopped;
        ArrayList<IStopUserCallback> callbacks;
        int userId = uss.mHandle.getIdentifier();
        ActivityManagerService activityManagerService = this.mService;
        synchronized (activityManagerService) {
            callbacks = new ArrayList<IStopUserCallback>(uss.mStopCallbacks);
            if (this.mStartedUsers.get(userId) != uss) {
                stopped = false;
            } else if (uss.state != 5) {
                stopped = false;
            } else {
                stopped = true;
                this.mStartedUsers.remove(userId);
                this.getUserManagerInternal().removeUserState(userId);
                this.mUserLru.remove((Object)userId);
                this.updateStartedUserArrayLocked();
                this.mService.onUserStoppedLocked(userId);
                this.forceStopUserLocked(userId, "finish user");
            }
        }
        for (int i = 0; i < callbacks.size(); ++i) {
            try {
                if (stopped) {
                    callbacks.get(i).userStopped(userId);
                    continue;
                }
                callbacks.get(i).userStopAborted(userId);
                continue;
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        if (stopped) {
            this.mService.mSystemServiceManager.cleanupUser(userId);
            ActivityManagerService activityManagerService2 = this.mService;
            synchronized (activityManagerService2) {
                this.mService.mStackSupervisor.removeUserLocked(userId);
            }
            if (this.getUserInfo(userId).isEphemeral()) {
                this.mUserManager.removeUser(userId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int[] getUsersToStopLocked(int userId) {
        int startedUsersSize = this.mStartedUsers.size();
        IntArray userIds = new IntArray();
        userIds.add(userId);
        SparseIntArray sparseIntArray = this.mUserProfileGroupIdsSelfLocked;
        synchronized (sparseIntArray) {
            int userGroupId = this.mUserProfileGroupIdsSelfLocked.get(userId, -10000);
            for (int i = 0; i < startedUsersSize; ++i) {
                boolean sameUserId;
                UserState uss = this.mStartedUsers.valueAt(i);
                int startedUserId = uss.mHandle.getIdentifier();
                int startedUserGroupId = this.mUserProfileGroupIdsSelfLocked.get(startedUserId, -10000);
                boolean sameGroup = userGroupId != -10000 && userGroupId == startedUserGroupId;
                boolean bl = sameUserId = startedUserId == userId;
                if (!sameGroup || sameUserId) continue;
                userIds.add(startedUserId);
            }
        }
        return userIds.toArray();
    }

    private void forceStopUserLocked(int userId, String reason) {
        this.mService.forceStopPackageLocked(null, -1, false, false, true, false, false, userId, reason);
        Intent intent = new Intent("android.intent.action.USER_STOPPED");
        intent.addFlags(0x50000000);
        intent.putExtra("android.intent.extra.user_handle", userId);
        this.mService.broadcastIntentLocked(null, null, intent, null, null, 0, null, null, null, -1, null, false, false, ActivityManagerService.MY_PID, 1000, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopGuestOrEphemeralUserIfBackground() {
        ActivityManagerService activityManagerService = this.mService;
        synchronized (activityManagerService) {
            int num = this.mUserLru.size();
            for (int i = 0; i < num; ++i) {
                Integer oldUserId = this.mUserLru.get(i);
                UserState oldUss = this.mStartedUsers.get(oldUserId);
                if (oldUserId == 0 || oldUserId == this.mCurrentUserId || oldUss.state == 4 || oldUss.state == 5) continue;
                UserInfo userInfo = this.getUserInfo(oldUserId);
                if (userInfo.isEphemeral()) {
                    LocalServices.getService(UserManagerInternal.class).onEphemeralUserStop(oldUserId);
                }
                if (!userInfo.isGuest() && !userInfo.isEphemeral()) continue;
                this.stopUsersLocked(oldUserId, true, null);
                break;
            }
        }
    }

    void startProfilesLocked() {
        int i;
        List<UserInfo> profiles = this.getUserManager().getProfiles(this.mCurrentUserId, false);
        ArrayList<UserInfo> profilesToStart = new ArrayList<UserInfo>(profiles.size());
        for (UserInfo user : profiles) {
            if ((user.flags & 0x10) != 16 || user.id == this.mCurrentUserId || user.isQuietModeEnabled()) continue;
            profilesToStart.add(user);
        }
        int profilesToStartSize = profilesToStart.size();
        for (i = 0; i < profilesToStartSize && i < 2; ++i) {
            this.startUser(((UserInfo)profilesToStart.get((int)i)).id, false);
        }
        if (i < profilesToStartSize) {
            Slog.w(TAG, "More profiles than MAX_RUNNING_USERS");
        }
    }

    private UserManagerService getUserManager() {
        UserManagerService userManager = this.mUserManager;
        if (userManager == null) {
            IBinder b = ServiceManager.getService("user");
            userManager = this.mUserManager = (UserManagerService)IUserManager.Stub.asInterface(b);
        }
        return userManager;
    }

    private IMountService getMountService() {
        return IMountService.Stub.asInterface(ServiceManager.getService("mount"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    boolean startUser(int userId, boolean foreground) {
        int oldUserId;
        long ident;
        block25: {
            if (this.mService.checkCallingPermission("android.permission.INTERACT_ACROSS_USERS_FULL") != 0) {
                String msg = "Permission Denial: switchUser() from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid() + " requires " + "android.permission.INTERACT_ACROSS_USERS_FULL";
                Slog.w(TAG, msg);
                throw new SecurityException(msg);
            }
            Slog.i(TAG, "Starting userid:" + userId + " fg:" + foreground);
            ident = Binder.clearCallingIdentity();
            ActivityManagerService activityManagerService = this.mService;
            // MONITORENTER : activityManagerService
            oldUserId = this.mCurrentUserId;
            if (oldUserId != userId) break block25;
            boolean bl = true;
            // MONITOREXIT : activityManagerService
            Binder.restoreCallingIdentity(ident);
            return bl;
        }
        this.mService.mStackSupervisor.setLockTaskModeLocked(null, 0, "startUser", false);
        UserInfo userInfo = this.getUserInfo(userId);
        if (userInfo == null) {
            Slog.w(TAG, "No user info for user #" + userId);
            boolean bl = false;
            // MONITOREXIT : activityManagerService
            Binder.restoreCallingIdentity(ident);
            return bl;
        }
        if (foreground && userInfo.isManagedProfile()) {
            Slog.w(TAG, "Cannot switch to User #" + userId + ": not a full user");
            boolean bl = false;
            // MONITOREXIT : activityManagerService
            Binder.restoreCallingIdentity(ident);
            return bl;
        }
        try {
            Intent intent;
            if (foreground) {
                this.mService.mWindowManager.startFreezingScreen(17432705, 17432704);
            }
            boolean needStart = false;
            if (this.mStartedUsers.get(userId) == null) {
                UserState userState = new UserState(UserHandle.of(userId));
                this.mStartedUsers.put(userId, userState);
                this.getUserManagerInternal().setUserState(userId, userState.state);
                this.updateStartedUserArrayLocked();
                needStart = true;
            }
            UserState uss = this.mStartedUsers.get(userId);
            Integer userIdInt = userId;
            this.mUserLru.remove(userIdInt);
            this.mUserLru.add(userIdInt);
            if (foreground) {
                this.mCurrentUserId = userId;
                this.mService.updateUserConfigurationLocked();
                this.mTargetUserId = -10000;
                this.updateCurrentProfileIdsLocked();
                this.mService.mWindowManager.setCurrentUser(userId, this.mCurrentProfileIds);
                this.mService.mWindowManager.lockNow(null);
            } else {
                Integer currentUserIdInt = this.mCurrentUserId;
                this.updateCurrentProfileIdsLocked();
                this.mService.mWindowManager.setCurrentProfileIds(this.mCurrentProfileIds);
                this.mUserLru.remove(currentUserIdInt);
                this.mUserLru.add(currentUserIdInt);
            }
            if (uss.state == 4) {
                uss.setState(uss.lastState);
                this.getUserManagerInternal().setUserState(userId, uss.state);
                this.updateStartedUserArrayLocked();
                needStart = true;
            } else if (uss.state == 5) {
                uss.setState(0);
                this.getUserManagerInternal().setUserState(userId, uss.state);
                this.updateStartedUserArrayLocked();
                needStart = true;
            }
            if (uss.state == 0) {
                this.getUserManager().onBeforeStartUser(userId);
                this.mHandler.sendMessage(this.mHandler.obtainMessage(42, userId, 0));
            }
            if (foreground) {
                this.mHandler.sendMessage(this.mHandler.obtainMessage(43, userId, oldUserId));
                this.mHandler.removeMessages(34);
                this.mHandler.removeMessages(36);
                this.mHandler.sendMessage(this.mHandler.obtainMessage(34, oldUserId, userId, uss));
                this.mHandler.sendMessageDelayed(this.mHandler.obtainMessage(36, oldUserId, userId, uss), 2000L);
            }
            if (needStart) {
                intent = new Intent("android.intent.action.USER_STARTED");
                intent.addFlags(0x50000000);
                intent.putExtra("android.intent.extra.user_handle", userId);
                this.mService.broadcastIntentLocked(null, null, intent, null, null, 0, null, null, null, -1, null, false, false, ActivityManagerService.MY_PID, 1000, userId);
            }
            if (foreground) {
                this.moveUserToForegroundLocked(uss, oldUserId, userId);
            } else {
                this.mService.mUserController.finishUserBoot(uss);
            }
            if (needStart) {
                intent = new Intent("android.intent.action.USER_STARTING");
                intent.addFlags(0x40000000);
                intent.putExtra("android.intent.extra.user_handle", userId);
                this.mService.broadcastIntentLocked(null, null, intent, null, new IIntentReceiver.Stub(){

                    @Override
                    public void performReceive(Intent intent, int resultCode, String data, Bundle extras, boolean ordered, boolean sticky, int sendingUser) throws RemoteException {
                    }
                }, 0, null, null, new String[]{"android.permission.INTERACT_ACROSS_USERS"}, -1, null, true, false, ActivityManagerService.MY_PID, 1000, -1);
            }
            // MONITOREXIT : activityManagerService
            return true;
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    boolean startUserInForeground(int userId, Dialog dlg) {
        boolean result = this.startUser(userId, true);
        dlg.dismiss();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean unlockUser(int userId, byte[] token, byte[] secret, IProgressListener listener) {
        if (this.mService.checkCallingPermission("android.permission.INTERACT_ACROSS_USERS_FULL") != 0) {
            String msg = "Permission Denial: unlockUser() from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid() + " requires " + "android.permission.INTERACT_ACROSS_USERS_FULL";
            Slog.w(TAG, msg);
            throw new SecurityException(msg);
        }
        long binderToken = Binder.clearCallingIdentity();
        try {
            boolean bl = this.unlockUserCleared(userId, token, secret, listener);
            return bl;
        }
        finally {
            Binder.restoreCallingIdentity(binderToken);
        }
    }

    boolean maybeUnlockUser(int userId) {
        return this.unlockUserCleared(userId, null, null, null);
    }

    private static void notifyFinished(int userId, IProgressListener listener) {
        if (listener == null) {
            return;
        }
        try {
            listener.onFinished(userId, null);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean unlockUserCleared(int userId, byte[] token, byte[] secret, IProgressListener listener) {
        ActivityManagerService activityManagerService = this.mService;
        synchronized (activityManagerService) {
            UserState uss;
            if (!StorageManager.isUserKeyUnlocked(userId)) {
                UserInfo userInfo = this.getUserInfo(userId);
                IMountService mountService = this.getMountService();
                try {
                    mountService.unlockUserKey(userId, userInfo.serialNumber, token, secret);
                }
                catch (RemoteException | RuntimeException e) {
                    Slog.w(TAG, "Failed to unlock: " + e.getMessage());
                }
            }
            if ((uss = this.mStartedUsers.get(userId)) == null) {
                UserController.notifyFinished(userId, listener);
                return false;
            }
            uss.mUnlockProgress.addListener(listener);
            this.finishUserUnlocking(uss);
            for (int i = 0; i < this.mStartedUsers.size(); ++i) {
                int testUserId = this.mStartedUsers.keyAt(i);
                UserInfo parent = this.getUserManager().getProfileParent(testUserId);
                if (parent == null || parent.id != userId || testUserId == userId) continue;
                Slog.d(TAG, "User " + testUserId + " (parent " + parent.id + "): attempting unlock because parent was just unlocked");
                this.maybeUnlockUser(testUserId);
            }
        }
        return true;
    }

    void showUserSwitchDialog(Pair<UserInfo, UserInfo> fromToUserPair) {
        UserSwitchingDialog d = new UserSwitchingDialog(this.mService, this.mService.mContext, (UserInfo)fromToUserPair.first, (UserInfo)fromToUserPair.second, true);
        ((Dialog)d).show();
    }

    void dispatchForegroundProfileChanged(int userId) {
        int observerCount = this.mUserSwitchObservers.beginBroadcast();
        for (int i = 0; i < observerCount; ++i) {
            try {
                this.mUserSwitchObservers.getBroadcastItem(i).onForegroundProfileSwitch(userId);
                continue;
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        this.mUserSwitchObservers.finishBroadcast();
    }

    void dispatchUserSwitchComplete(int userId) {
        int observerCount = this.mUserSwitchObservers.beginBroadcast();
        for (int i = 0; i < observerCount; ++i) {
            try {
                this.mUserSwitchObservers.getBroadcastItem(i).onUserSwitchComplete(userId);
                continue;
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        this.mUserSwitchObservers.finishBroadcast();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopBackgroundUsersIfEnforced(int oldUserId) {
        if (oldUserId == 0) {
            return;
        }
        boolean disallowRunInBg = this.hasUserRestriction("no_run_in_background", oldUserId);
        if (!disallowRunInBg) {
            return;
        }
        ActivityManagerService activityManagerService = this.mService;
        synchronized (activityManagerService) {
            this.stopUsersLocked(oldUserId, false, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void timeoutUserSwitch(UserState uss, int oldUserId, int newUserId) {
        ActivityManagerService activityManagerService = this.mService;
        synchronized (activityManagerService) {
            Slog.wtf(TAG, "User switch timeout: from " + oldUserId + " to " + newUserId);
            this.sendContinueUserSwitchLocked(uss, oldUserId, newUserId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dispatchUserSwitch(final UserState uss, final int oldUserId, final int newUserId) {
        Slog.d(TAG, "Dispatch onUserSwitching oldUser #" + oldUserId + " newUser #" + newUserId);
        final int observerCount = this.mUserSwitchObservers.beginBroadcast();
        if (observerCount > 0) {
            IRemoteCallback.Stub callback = new IRemoteCallback.Stub(){
                int mCount = 0;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void sendResult(Bundle data) throws RemoteException {
                    ActivityManagerService activityManagerService = UserController.this.mService;
                    synchronized (activityManagerService) {
                        if (UserController.this.mCurUserSwitchCallback == this) {
                            ++this.mCount;
                            if (this.mCount == observerCount) {
                                UserController.this.sendContinueUserSwitchLocked(uss, oldUserId, newUserId);
                            }
                        }
                    }
                }
            };
            ActivityManagerService activityManagerService = this.mService;
            synchronized (activityManagerService) {
                uss.switching = true;
                this.mCurUserSwitchCallback = callback;
            }
            for (int i = 0; i < observerCount; ++i) {
                try {
                    this.mUserSwitchObservers.getBroadcastItem(i).onUserSwitching(newUserId, callback);
                    continue;
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
        } else {
            ActivityManagerService activityManagerService = this.mService;
            synchronized (activityManagerService) {
                this.sendContinueUserSwitchLocked(uss, oldUserId, newUserId);
            }
        }
        this.mUserSwitchObservers.finishBroadcast();
    }

    void sendContinueUserSwitchLocked(UserState uss, int oldUserId, int newUserId) {
        this.mCurUserSwitchCallback = null;
        this.mHandler.removeMessages(36);
        this.mHandler.sendMessage(this.mHandler.obtainMessage(35, oldUserId, newUserId, uss));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void continueUserSwitch(UserState uss, int oldUserId, int newUserId) {
        Slog.d(TAG, "Continue user switch oldUser #" + oldUserId + ", newUser #" + newUserId);
        ActivityManagerService activityManagerService = this.mService;
        synchronized (activityManagerService) {
            this.mService.mWindowManager.stopFreezingScreen();
        }
        uss.switching = false;
        this.mHandler.removeMessages(56);
        this.mHandler.sendMessage(this.mHandler.obtainMessage(56, newUserId, 0));
        this.stopGuestOrEphemeralUserIfBackground();
        this.stopBackgroundUsersIfEnforced(oldUserId);
    }

    void moveUserToForegroundLocked(UserState uss, int oldUserId, int newUserId) {
        boolean homeInFront = this.mService.mStackSupervisor.switchUserLocked(newUserId, uss);
        if (homeInFront) {
            this.mService.startHomeActivityLocked(newUserId, "moveUserToForeground");
        } else {
            this.mService.mStackSupervisor.resumeFocusedStackTopActivityLocked();
        }
        EventLogTags.writeAmSwitchUser(newUserId);
        this.sendUserSwitchBroadcastsLocked(oldUserId, newUserId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendUserSwitchBroadcastsLocked(int oldUserId, int newUserId) {
        long ident = Binder.clearCallingIdentity();
        try {
            Intent intent;
            int profileUserId;
            int i;
            int count;
            List<UserInfo> profiles;
            if (oldUserId >= 0) {
                profiles = this.getUserManager().getProfiles(oldUserId, false);
                count = profiles.size();
                for (i = 0; i < count; ++i) {
                    profileUserId = profiles.get((int)i).id;
                    intent = new Intent("android.intent.action.USER_BACKGROUND");
                    intent.addFlags(0x50000000);
                    intent.putExtra("android.intent.extra.user_handle", profileUserId);
                    this.mService.broadcastIntentLocked(null, null, intent, null, null, 0, null, null, null, -1, null, false, false, ActivityManagerService.MY_PID, 1000, profileUserId);
                }
            }
            if (newUserId >= 0) {
                profiles = this.getUserManager().getProfiles(newUserId, false);
                count = profiles.size();
                for (i = 0; i < count; ++i) {
                    profileUserId = profiles.get((int)i).id;
                    intent = new Intent("android.intent.action.USER_FOREGROUND");
                    intent.addFlags(0x50000000);
                    intent.putExtra("android.intent.extra.user_handle", profileUserId);
                    this.mService.broadcastIntentLocked(null, null, intent, null, null, 0, null, null, null, -1, null, false, false, ActivityManagerService.MY_PID, 1000, profileUserId);
                }
                intent = new Intent("android.intent.action.USER_SWITCHED");
                intent.addFlags(0x50000000);
                intent.putExtra("android.intent.extra.user_handle", newUserId);
                this.mService.broadcastIntentLocked(null, null, intent, null, null, 0, null, null, new String[]{"android.permission.MANAGE_USERS"}, -1, null, false, false, ActivityManagerService.MY_PID, 1000, -1);
            }
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    int handleIncomingUser(int callingPid, int callingUid, int userId, boolean allowAll, int allowMode, String name, String callerPackage) {
        int callingUserId = UserHandle.getUserId(callingUid);
        if (callingUserId == userId) {
            return userId;
        }
        int targetUserId = this.unsafeConvertIncomingUserLocked(userId);
        if (callingUid != 0 && callingUid != 1000) {
            boolean allow;
            if (this.mService.checkComponentPermission("android.permission.INTERACT_ACROSS_USERS_FULL", callingPid, callingUid, -1, true) == 0) {
                allow = true;
            } else if (allowMode == 2) {
                allow = false;
            } else if (this.mService.checkComponentPermission("android.permission.INTERACT_ACROSS_USERS", callingPid, callingUid, -1, true) != 0) {
                allow = false;
            } else if (allowMode == 0) {
                allow = true;
            } else if (allowMode == 1) {
                allow = this.isSameProfileGroup(callingUserId, targetUserId);
            } else {
                throw new IllegalArgumentException("Unknown mode: " + allowMode);
            }
            if (!allow) {
                if (userId == -3) {
                    targetUserId = callingUserId;
                } else {
                    StringBuilder builder = new StringBuilder(128);
                    builder.append("Permission Denial: ");
                    builder.append(name);
                    if (callerPackage != null) {
                        builder.append(" from ");
                        builder.append(callerPackage);
                    }
                    builder.append(" asks to run as user ");
                    builder.append(userId);
                    builder.append(" but is calling from user ");
                    builder.append(UserHandle.getUserId(callingUid));
                    builder.append("; this requires ");
                    builder.append("android.permission.INTERACT_ACROSS_USERS_FULL");
                    if (allowMode != 2) {
                        builder.append(" or ");
                        builder.append("android.permission.INTERACT_ACROSS_USERS");
                    }
                    String msg = builder.toString();
                    Slog.w(TAG, msg);
                    throw new SecurityException(msg);
                }
            }
        }
        if (!allowAll && targetUserId < 0) {
            throw new IllegalArgumentException("Call does not support special user #" + targetUserId);
        }
        if (callingUid == 2000 && targetUserId >= 0 && this.hasUserRestriction("no_debugging_features", targetUserId)) {
            throw new SecurityException("Shell does not have permission to access user " + targetUserId + "\n " + Debug.getCallers(3));
        }
        return targetUserId;
    }

    int unsafeConvertIncomingUserLocked(int userId) {
        return userId == -2 || userId == -3 ? this.getCurrentUserIdLocked() : userId;
    }

    void registerUserSwitchObserver(IUserSwitchObserver observer) {
        if (this.mService.checkCallingPermission("android.permission.INTERACT_ACROSS_USERS_FULL") != 0) {
            String msg = "Permission Denial: registerUserSwitchObserver() from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid() + " requires " + "android.permission.INTERACT_ACROSS_USERS_FULL";
            Slog.w(TAG, msg);
            throw new SecurityException(msg);
        }
        this.mUserSwitchObservers.register(observer);
    }

    void unregisterUserSwitchObserver(IUserSwitchObserver observer) {
        this.mUserSwitchObservers.unregister(observer);
    }

    UserState getStartedUserStateLocked(int userId) {
        return this.mStartedUsers.get(userId);
    }

    boolean hasStartedUserState(int userId) {
        return this.mStartedUsers.get(userId) != null;
    }

    private void updateStartedUserArrayLocked() {
        UserState uss;
        int i;
        int num = 0;
        for (i = 0; i < this.mStartedUsers.size(); ++i) {
            uss = this.mStartedUsers.valueAt(i);
            if (uss.state == 4 || uss.state == 5) continue;
            ++num;
        }
        this.mStartedUserArray = new int[num];
        num = 0;
        for (i = 0; i < this.mStartedUsers.size(); ++i) {
            uss = this.mStartedUsers.valueAt(i);
            if (uss.state == 4 || uss.state == 5) continue;
            this.mStartedUserArray[num++] = this.mStartedUsers.keyAt(i);
        }
    }

    void sendBootCompletedLocked(IIntentReceiver resultTo) {
        for (int i = 0; i < this.mStartedUsers.size(); ++i) {
            UserState uss = this.mStartedUsers.valueAt(i);
            this.finishUserBoot(uss, resultTo);
        }
    }

    void onSystemReady() {
        this.updateCurrentProfileIdsLocked();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCurrentProfileIdsLocked() {
        List<UserInfo> profiles = this.getUserManager().getProfiles(this.mCurrentUserId, false);
        int[] currentProfileIds = new int[profiles.size()];
        for (int i = 0; i < currentProfileIds.length; ++i) {
            currentProfileIds[i] = profiles.get((int)i).id;
        }
        this.mCurrentProfileIds = currentProfileIds;
        SparseIntArray sparseIntArray = this.mUserProfileGroupIdsSelfLocked;
        synchronized (sparseIntArray) {
            this.mUserProfileGroupIdsSelfLocked.clear();
            List<UserInfo> users = this.getUserManager().getUsers(false);
            for (int i = 0; i < users.size(); ++i) {
                UserInfo user = users.get(i);
                if (user.profileGroupId == -10000) continue;
                this.mUserProfileGroupIdsSelfLocked.put(user.id, user.profileGroupId);
            }
        }
    }

    int[] getStartedUserArrayLocked() {
        return this.mStartedUserArray;
    }

    boolean isUserStoppingOrShuttingDownLocked(int userId) {
        UserState state = this.getStartedUserStateLocked(userId);
        if (state == null) {
            return false;
        }
        return state.state == 4 || state.state == 5;
    }

    boolean isUserRunningLocked(int userId, int flags) {
        UserState state = this.getStartedUserStateLocked(userId);
        if (state == null) {
            return false;
        }
        if ((flags & 1) != 0) {
            return true;
        }
        if ((flags & 2) != 0) {
            switch (state.state) {
                case 0: 
                case 1: {
                    return true;
                }
            }
            return false;
        }
        if ((flags & 8) != 0) {
            switch (state.state) {
                case 2: 
                case 3: {
                    return true;
                }
            }
            return false;
        }
        if ((flags & 4) != 0) {
            switch (state.state) {
                case 3: {
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    UserInfo getCurrentUser() {
        if (this.mService.checkCallingPermission("android.permission.INTERACT_ACROSS_USERS") != 0 && this.mService.checkCallingPermission("android.permission.INTERACT_ACROSS_USERS_FULL") != 0) {
            String msg = "Permission Denial: getCurrentUser() from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid() + " requires " + "android.permission.INTERACT_ACROSS_USERS";
            Slog.w(TAG, msg);
            throw new SecurityException(msg);
        }
        ActivityManagerService activityManagerService = this.mService;
        synchronized (activityManagerService) {
            return this.getCurrentUserLocked();
        }
    }

    UserInfo getCurrentUserLocked() {
        int userId = this.mTargetUserId != -10000 ? this.mTargetUserId : this.mCurrentUserId;
        return this.getUserInfo(userId);
    }

    int getCurrentOrTargetUserIdLocked() {
        return this.mTargetUserId != -10000 ? this.mTargetUserId : this.mCurrentUserId;
    }

    int getCurrentUserIdLocked() {
        return this.mCurrentUserId;
    }

    private boolean isCurrentUserLocked(int userId) {
        return userId == this.getCurrentOrTargetUserIdLocked();
    }

    int setTargetUserIdLocked(int targetUserId) {
        this.mTargetUserId = targetUserId;
        return this.mTargetUserId;
    }

    int[] getUsers() {
        int[] nArray;
        UserManagerService ums = this.getUserManager();
        if (ums != null) {
            nArray = ums.getUserIds();
        } else {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = 0;
        }
        return nArray;
    }

    UserInfo getUserInfo(int userId) {
        return this.getUserManager().getUserInfo(userId);
    }

    int[] getUserIds() {
        return this.getUserManager().getUserIds();
    }

    boolean exists(int userId) {
        return this.getUserManager().exists(userId);
    }

    boolean hasUserRestriction(String restriction, int userId) {
        return this.getUserManager().hasUserRestriction(restriction, userId);
    }

    Set<Integer> getProfileIds(int userId) {
        HashSet<Integer> userIds = new HashSet<Integer>();
        List<UserInfo> profiles = this.getUserManager().getProfiles(userId, false);
        for (UserInfo user : profiles) {
            userIds.add(user.id);
        }
        return userIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isSameProfileGroup(int callingUserId, int targetUserId) {
        SparseIntArray sparseIntArray = this.mUserProfileGroupIdsSelfLocked;
        synchronized (sparseIntArray) {
            int callingProfile = this.mUserProfileGroupIdsSelfLocked.get(callingUserId, -10000);
            int targetProfile = this.mUserProfileGroupIdsSelfLocked.get(targetUserId, -10000);
            return callingProfile != -10000 && callingProfile == targetProfile;
        }
    }

    boolean isCurrentProfileLocked(int userId) {
        return ArrayUtils.contains(this.mCurrentProfileIds, userId);
    }

    int[] getCurrentProfileIdsLocked() {
        return this.mCurrentProfileIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean shouldConfirmCredentials(int userId) {
        ActivityManagerService activityManagerService = this.mService;
        synchronized (activityManagerService) {
            if (this.mStartedUsers.get(userId) == null) {
                return false;
            }
        }
        if (!this.mLockPatternUtils.isSeparateProfileChallengeEnabled(userId)) {
            return false;
        }
        KeyguardManager km = (KeyguardManager)this.mService.mContext.getSystemService("keyguard");
        return km.isDeviceLocked(userId) && km.isDeviceSecure(userId);
    }

    boolean isLockScreenDisabled(int userId) {
        return this.mLockPatternUtils.isLockScreenDisabled(userId);
    }

    private UserManagerInternal getUserManagerInternal() {
        if (this.mUserManagerInternal == null) {
            this.mUserManagerInternal = LocalServices.getService(UserManagerInternal.class);
        }
        return this.mUserManagerInternal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dump(PrintWriter pw, boolean dumpAll) {
        int i;
        pw.println("  mStartedUsers:");
        for (i = 0; i < this.mStartedUsers.size(); ++i) {
            UserState uss = this.mStartedUsers.valueAt(i);
            pw.print("    User #");
            pw.print(uss.mHandle.getIdentifier());
            pw.print(": ");
            uss.dump("", pw);
        }
        pw.print("  mStartedUserArray: [");
        for (i = 0; i < this.mStartedUserArray.length; ++i) {
            if (i > 0) {
                pw.print(", ");
            }
            pw.print(this.mStartedUserArray[i]);
        }
        pw.println("]");
        pw.print("  mUserLru: [");
        for (i = 0; i < this.mUserLru.size(); ++i) {
            if (i > 0) {
                pw.print(", ");
            }
            pw.print(this.mUserLru.get(i));
        }
        pw.println("]");
        if (dumpAll) {
            pw.print("  mStartedUserArray: ");
            pw.println(Arrays.toString(this.mStartedUserArray));
        }
        SparseIntArray sparseIntArray = this.mUserProfileGroupIdsSelfLocked;
        synchronized (sparseIntArray) {
            if (this.mUserProfileGroupIdsSelfLocked.size() > 0) {
                pw.println("  mUserProfileGroupIds:");
                for (int i2 = 0; i2 < this.mUserProfileGroupIdsSelfLocked.size(); ++i2) {
                    pw.print("    User #");
                    pw.print(this.mUserProfileGroupIdsSelfLocked.keyAt(i2));
                    pw.print(" -> profile #");
                    pw.println(this.mUserProfileGroupIdsSelfLocked.valueAt(i2));
                }
            }
        }
    }
}

