/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.am;

import android.content.res.Resources;
import android.graphics.Point;
import android.net.LocalSocket;
import android.net.LocalSocketAddress;
import android.os.Build;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.util.Slog;
import com.android.internal.util.MemInfoReader;
import com.android.server.wm.WindowManagerService;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;

final class ProcessList {
    private static final String TAG = "ActivityManager";
    static final int MIN_CRASH_INTERVAL = 60000;
    static final int INVALID_ADJ = -10000;
    static final int UNKNOWN_ADJ = 1001;
    static final int CACHED_APP_MAX_ADJ = 906;
    static final int CACHED_APP_MIN_ADJ = 900;
    static final int SERVICE_B_ADJ = 800;
    static final int PREVIOUS_APP_ADJ = 700;
    static final int HOME_APP_ADJ = 600;
    static final int SERVICE_ADJ = 500;
    static final int HEAVY_WEIGHT_APP_ADJ = 400;
    static final int BACKUP_APP_ADJ = 300;
    static final int PERCEPTIBLE_APP_ADJ = 200;
    static final int VISIBLE_APP_ADJ = 100;
    static final int VISIBLE_APP_LAYER_MAX = 99;
    static final int FOREGROUND_APP_ADJ = 0;
    static final int PERSISTENT_SERVICE_ADJ = -700;
    static final int PERSISTENT_PROC_ADJ = -800;
    static final int SYSTEM_ADJ = -900;
    static final int NATIVE_ADJ = -1000;
    static final int PAGE_SIZE = 4096;
    static final int SCHED_GROUP_BACKGROUND = 0;
    static final int SCHED_GROUP_DEFAULT = 1;
    static final int SCHED_GROUP_TOP_APP = 2;
    static final int MIN_CACHED_APPS = 2;
    static final int MAX_CACHED_APPS = 32;
    static final long MAX_EMPTY_TIME = 1800000L;
    private static final int MAX_EMPTY_APPS = ProcessList.computeEmptyProcessLimit(32);
    static final int TRIM_EMPTY_APPS = MAX_EMPTY_APPS / 2;
    static final int TRIM_CACHED_APPS = (32 - MAX_EMPTY_APPS) / 3;
    static final int TRIM_CRITICAL_THRESHOLD = 3;
    static final int TRIM_LOW_THRESHOLD = 5;
    static final byte LMK_TARGET = 0;
    static final byte LMK_PROCPRIO = 1;
    static final byte LMK_PROCREMOVE = 2;
    private final int[] mOomAdj = new int[]{0, 100, 200, 300, 900, 906};
    private final int[] mOomMinFreeLow = new int[]{12288, 18432, 24576, 36864, 43008, 49152};
    private final int[] mOomMinFreeHigh = new int[]{73728, 92160, 110592, 129024, 147456, 184320};
    private final int[] mOomMinFree = new int[this.mOomAdj.length];
    private final long mTotalMemMb;
    private long mCachedRestoreLevel;
    private boolean mHaveDisplaySize;
    private static LocalSocket sLmkdSocket;
    private static OutputStream sLmkdOutputStream;
    public static final int PSS_SAFE_TIME_FROM_STATE_CHANGE = 1000;
    public static final int PSS_MIN_TIME_FROM_STATE_CHANGE = 15000;
    public static final int PSS_MAX_INTERVAL = 1800000;
    public static final int PSS_ALL_INTERVAL = 600000;
    private static final int PSS_SHORT_INTERVAL = 120000;
    private static final int PSS_FIRST_TOP_INTERVAL = 10000;
    private static final int PSS_FIRST_BACKGROUND_INTERVAL = 20000;
    private static final int PSS_FIRST_CACHED_INTERVAL = 30000;
    private static final int PSS_SAME_IMPORTANT_INTERVAL = 900000;
    private static final int PSS_SAME_SERVICE_INTERVAL = 1200000;
    private static final int PSS_SAME_CACHED_INTERVAL = 1800000;
    public static final int PSS_TEST_MIN_TIME_FROM_STATE_CHANGE = 10000;
    private static final int PSS_TEST_FIRST_TOP_INTERVAL = 3000;
    private static final int PSS_TEST_FIRST_BACKGROUND_INTERVAL = 5000;
    private static final int PSS_TEST_SAME_IMPORTANT_INTERVAL = 10000;
    private static final int PSS_TEST_SAME_BACKGROUND_INTERVAL = 15000;
    public static final int PROC_MEM_PERSISTENT = 0;
    public static final int PROC_MEM_TOP = 1;
    public static final int PROC_MEM_IMPORTANT = 2;
    public static final int PROC_MEM_SERVICE = 3;
    public static final int PROC_MEM_CACHED = 4;
    private static final int[] sProcStateToProcMem;
    private static final long[] sFirstAwakePssTimes;
    private static final long[] sSameAwakePssTimes;
    private static final long[] sTestFirstAwakePssTimes;
    private static final long[] sTestSameAwakePssTimes;

    ProcessList() {
        MemInfoReader minfo = new MemInfoReader();
        minfo.readMemInfo();
        this.mTotalMemMb = minfo.getTotalSize() / 0x100000L;
        this.updateOomLevels(0, 0, false);
    }

    void applyDisplaySize(WindowManagerService wm) {
        if (!this.mHaveDisplaySize) {
            Point p = new Point();
            wm.getBaseDisplaySize(0, p);
            if (p.x != 0 && p.y != 0) {
                this.updateOomLevels(p.x, p.y, true);
                this.mHaveDisplaySize = true;
            }
        }
    }

    private void updateOomLevels(int displayWidth, int displayHeight, boolean write) {
        int i;
        float scale;
        float scaleMem = (float)(this.mTotalMemMb - 350L) / 350.0f;
        int minSize = 384000;
        int maxSize = 1024000;
        float scaleDisp = ((float)(displayWidth * displayHeight) - (float)minSize) / (float)(maxSize - minSize);
        float f = scale = scaleMem > scaleDisp ? scaleMem : scaleDisp;
        if (scale < 0.0f) {
            scale = 0.0f;
        } else if (scale > 1.0f) {
            scale = 1.0f;
        }
        int minfree_adj = Resources.getSystem().getInteger(17694729);
        int minfree_abs = Resources.getSystem().getInteger(17694728);
        boolean is64bit = Build.SUPPORTED_64_BIT_ABIS.length > 0;
        for (i = 0; i < this.mOomAdj.length; ++i) {
            int low = this.mOomMinFreeLow[i];
            int high = this.mOomMinFreeHigh[i];
            if (is64bit) {
                if (i == 4) {
                    high = high * 3 / 2;
                } else if (i == 5) {
                    high = high * 7 / 4;
                }
            }
            this.mOomMinFree[i] = (int)((float)low + (float)(high - low) * scale);
        }
        if (minfree_abs >= 0) {
            for (i = 0; i < this.mOomAdj.length; ++i) {
                this.mOomMinFree[i] = (int)((float)minfree_abs * (float)this.mOomMinFree[i] / (float)this.mOomMinFree[this.mOomAdj.length - 1]);
            }
        }
        if (minfree_adj != 0) {
            for (i = 0; i < this.mOomAdj.length; ++i) {
                int n = i;
                this.mOomMinFree[n] = this.mOomMinFree[n] + (int)((float)minfree_adj * (float)this.mOomMinFree[i] / (float)this.mOomMinFree[this.mOomAdj.length - 1]);
                if (this.mOomMinFree[i] >= 0) continue;
                this.mOomMinFree[i] = 0;
            }
        }
        this.mCachedRestoreLevel = this.getMemLevel(906) / 1024L / 3L;
        int reserve = displayWidth * displayHeight * 4 * 3 / 1024;
        int reserve_adj = Resources.getSystem().getInteger(17694731);
        int reserve_abs = Resources.getSystem().getInteger(17694730);
        if (reserve_abs >= 0) {
            reserve = reserve_abs;
        }
        if (reserve_adj != 0 && (reserve += reserve_adj) < 0) {
            reserve = 0;
        }
        if (write) {
            ByteBuffer buf = ByteBuffer.allocate(4 * (2 * this.mOomAdj.length + 1));
            buf.putInt(0);
            for (int i2 = 0; i2 < this.mOomAdj.length; ++i2) {
                buf.putInt(this.mOomMinFree[i2] * 1024 / 4096);
                buf.putInt(this.mOomAdj[i2]);
            }
            ProcessList.writeLmkd(buf);
            SystemProperties.set("sys.sysctl.extra_free_kbytes", Integer.toString(reserve));
        }
    }

    public static int computeEmptyProcessLimit(int totalProcessLimit) {
        return totalProcessLimit / 2;
    }

    private static String buildOomTag(String prefix, String space, int val, int base) {
        if (val == base) {
            if (space == null) {
                return prefix;
            }
            return prefix + "  ";
        }
        return prefix + "+" + Integer.toString(val - base);
    }

    public static String makeOomAdjString(int setAdj) {
        if (setAdj >= 900) {
            return ProcessList.buildOomTag("cch", "  ", setAdj, 900);
        }
        if (setAdj >= 800) {
            return ProcessList.buildOomTag("svcb ", null, setAdj, 800);
        }
        if (setAdj >= 700) {
            return ProcessList.buildOomTag("prev ", null, setAdj, 700);
        }
        if (setAdj >= 600) {
            return ProcessList.buildOomTag("home ", null, setAdj, 600);
        }
        if (setAdj >= 500) {
            return ProcessList.buildOomTag("svc  ", null, setAdj, 500);
        }
        if (setAdj >= 400) {
            return ProcessList.buildOomTag("hvy  ", null, setAdj, 400);
        }
        if (setAdj >= 300) {
            return ProcessList.buildOomTag("bkup ", null, setAdj, 300);
        }
        if (setAdj >= 200) {
            return ProcessList.buildOomTag("prcp ", null, setAdj, 200);
        }
        if (setAdj >= 100) {
            return ProcessList.buildOomTag("vis  ", null, setAdj, 100);
        }
        if (setAdj >= 0) {
            return ProcessList.buildOomTag("fore ", null, setAdj, 0);
        }
        if (setAdj >= -700) {
            return ProcessList.buildOomTag("psvc ", null, setAdj, -700);
        }
        if (setAdj >= -800) {
            return ProcessList.buildOomTag("pers ", null, setAdj, -800);
        }
        if (setAdj >= -900) {
            return ProcessList.buildOomTag("sys  ", null, setAdj, -900);
        }
        if (setAdj >= -1000) {
            return ProcessList.buildOomTag("ntv  ", null, setAdj, -1000);
        }
        return Integer.toString(setAdj);
    }

    public static String makeProcStateString(int curProcState) {
        String procState;
        switch (curProcState) {
            case -1: {
                procState = "N ";
                break;
            }
            case 0: {
                procState = "P ";
                break;
            }
            case 1: {
                procState = "PU";
                break;
            }
            case 2: {
                procState = "T ";
                break;
            }
            case 3: {
                procState = "SB";
                break;
            }
            case 4: {
                procState = "SF";
                break;
            }
            case 5: {
                procState = "TS";
                break;
            }
            case 6: {
                procState = "IF";
                break;
            }
            case 7: {
                procState = "IB";
                break;
            }
            case 8: {
                procState = "BU";
                break;
            }
            case 9: {
                procState = "HW";
                break;
            }
            case 10: {
                procState = "S ";
                break;
            }
            case 11: {
                procState = "R ";
                break;
            }
            case 12: {
                procState = "HO";
                break;
            }
            case 13: {
                procState = "LA";
                break;
            }
            case 14: {
                procState = "CA";
                break;
            }
            case 15: {
                procState = "Ca";
                break;
            }
            case 16: {
                procState = "CE";
                break;
            }
            default: {
                procState = "??";
            }
        }
        return procState;
    }

    public static void appendRamKb(StringBuilder sb, long ramKb) {
        int j = 0;
        int fact = 10;
        while (j < 6) {
            if (ramKb < (long)fact) {
                sb.append(' ');
            }
            ++j;
            fact *= 10;
        }
        sb.append(ramKb);
    }

    public static boolean procStatesDifferForMem(int procState1, int procState2) {
        return sProcStateToProcMem[procState1] != sProcStateToProcMem[procState2];
    }

    public static long minTimeFromStateChange(boolean test) {
        return test ? 10000L : 15000L;
    }

    public static long computeNextPssTime(int procState, boolean first, boolean test, boolean sleeping, long now) {
        long[] table = test ? (first ? sTestFirstAwakePssTimes : sTestSameAwakePssTimes) : (first ? sFirstAwakePssTimes : sSameAwakePssTimes);
        return now + table[procState];
    }

    long getMemLevel(int adjustment) {
        for (int i = 0; i < this.mOomAdj.length; ++i) {
            if (adjustment > this.mOomAdj[i]) continue;
            return this.mOomMinFree[i] * 1024;
        }
        return this.mOomMinFree[this.mOomAdj.length - 1] * 1024;
    }

    long getCachedRestoreThresholdKb() {
        return this.mCachedRestoreLevel;
    }

    public static final void setOomAdj(int pid, int uid, int amt) {
        if (amt == 1001) {
            return;
        }
        long start = SystemClock.elapsedRealtime();
        ByteBuffer buf = ByteBuffer.allocate(16);
        buf.putInt(1);
        buf.putInt(pid);
        buf.putInt(uid);
        buf.putInt(amt);
        ProcessList.writeLmkd(buf);
        long now = SystemClock.elapsedRealtime();
        if (now - start > 250L) {
            Slog.w(TAG, "SLOW OOM ADJ: " + (now - start) + "ms for pid " + pid + " = " + amt);
        }
    }

    public static final void remove(int pid) {
        ByteBuffer buf = ByteBuffer.allocate(8);
        buf.putInt(2);
        buf.putInt(pid);
        ProcessList.writeLmkd(buf);
    }

    private static boolean openLmkdSocket() {
        try {
            sLmkdSocket = new LocalSocket(3);
            sLmkdSocket.connect(new LocalSocketAddress("lmkd", LocalSocketAddress.Namespace.RESERVED));
            sLmkdOutputStream = sLmkdSocket.getOutputStream();
        }
        catch (IOException ex) {
            Slog.w(TAG, "lowmemorykiller daemon socket open failed");
            sLmkdSocket = null;
            return false;
        }
        return true;
    }

    private static void writeLmkd(ByteBuffer buf) {
        for (int i = 0; i < 3; ++i) {
            if (sLmkdSocket == null && !ProcessList.openLmkdSocket()) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            try {
                sLmkdOutputStream.write(buf.array(), 0, buf.position());
                return;
            }
            catch (IOException ex) {
                Slog.w(TAG, "Error writing to lowmemorykiller socket");
                try {
                    sLmkdSocket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                sLmkdSocket = null;
            }
        }
    }

    static {
        sProcStateToProcMem = new int[]{0, 0, 1, 2, 2, 1, 2, 2, 2, 2, 3, 4, 4, 4, 4, 4, 4};
        sFirstAwakePssTimes = new long[]{120000L, 120000L, 10000L, 20000L, 20000L, 20000L, 20000L, 20000L, 20000L, 20000L, 20000L, 30000L, 30000L, 30000L, 30000L, 30000L, 30000L};
        sSameAwakePssTimes = new long[]{900000L, 900000L, 120000L, 900000L, 900000L, 900000L, 900000L, 900000L, 900000L, 900000L, 1200000L, 1200000L, 1800000L, 1800000L, 1800000L, 1800000L, 1800000L};
        sTestFirstAwakePssTimes = new long[]{3000L, 3000L, 3000L, 20000L, 20000L, 20000L, 5000L, 5000L, 5000L, 5000L, 5000L, 5000L, 5000L, 5000L, 5000L, 5000L, 5000L};
        sTestSameAwakePssTimes = new long[]{15000L, 15000L, 10000L, 10000L, 10000L, 10000L, 10000L, 10000L, 10000L, 10000L, 15000L, 15000L, 15000L, 15000L, 15000L, 15000L, 15000L};
    }
}

